DESCRIPTION = "Broadcom Linux Kernel"
SECTION = "kernel"
LICENSE = "GPLv2"

DEFAULT_PREFERENCE = "-1"

FILESEXTRAPATHS_prepend := "${THISDIR}/stblinux-android13-5.15:"

LIC_FILES_CHKSUM = "file://COPYING;md5=6bc538ed5bd9a7fc9398086aedcd7e46" 
SRC_URI += "https://partners.artifactory.comcast.com/artifactory/broadcom_sdk_shared/linux/5_15-1_3/stblinux-android13-5.15-1.3.tgz"
SRC_URI[md5sum] = "059bea3d7cf0d3ff4a83b5e040c15b7f"

SRC_URI += "file://cgroups.cfg \
            file://inet.cfg \
            file://ipsec.cfg \
            file://netfilter.cfg \
            file://overlay.cfg \
            file://stblinux-5.15.cfg \
            file://nfsdisable.cfg \
            file://disable_cdrom_fs.cfg \
            file://ecryptfs.cfg \
            file://dm_crypt.cfg \
            file://stblinux_disable_pcie_powersave.cfg \
            file://unifying_moca_interface_name.patch \
            file://reboot_info.patch \
            file://boops.patch \
            file://stblinux_watchdog_nmi.patch \
            file://Ignore_mmc_alias_id.patch \
            file://cma_debugfs.cfg \
            file://squashfs_performance.cfg \
            file://bluetooth.cfg \
            file://psi_pressure.cfg \
	    file://bt_gpio_wakeup.patch \
	    file://SWLINUX-6684.patch \
"
#GamePad
SRC_URI += "file://0013-RDK-37394-exclude-PS5-controller-from-hid-generic.patch "
SRC_URI += "file://0020-RDK-37392-fix-for-xbox-mapping.patch "
SRC_URI += "file://0021-RDK-37394-fix-to-remove-noise-events-playstation.patch "
SRC_URI += "file://0022-RDK-37394-fix-playstation-mapping.patch "
SRC_URI += "file://0023-RDK-39137-XRE-19923-android-xbox-mapping.patch "
SRC_URI += "file://0025-DELIA-62832-fix-for-delay-on-node-creation-issue.patch "
SRC_URI += "file://0001-CPESP-3698-Nintendo-Switch-ProController_Support.patch "
SRC_URI += "file://stblinux_adaptive_controller_support.patch "
SRC_URI += "file://Google_Stadia_Controller_Support.patch "

# enable zram module
SRC_URI_append_rdkzram += "\
    file://zram.cfg \
"

SRC_URI_append = " \
    file://bluetooth.cfg \
"

COMPATIBLE_HOST = "arm.*|aarch64.*"

KERNEL_VERSION = "5.15-74"
KERNEL_MAJOR_VERSION = "5.15"

LINUX_VERSION ?= "5.15"
LINUX_VERSION_EXTENSION ?= "-brcm"

DEPENDS += "xz-native bc-native lzop-native"

inherit kernel

S = "${WORKDIR}/linux"

do_configure_prepend () {
	# copy desired defconfig so we pick it up for the real kernel_do_configure
	sh ${S}/scripts/kconfig/merge_config.sh -m ${KERNEL_DEFCONFIG} `ls ${WORKDIR}/*.cfg 2>/dev/null`
	mv .config ${WORKDIR}/defconfig
}

KERNEL_CONFIG_COMMAND ?= "oe_runmake oldnoconfig || yes '' | oe_runmake oldconfig"

kernel_do_configure() {
	touch ${B}/.scmversion ${S}/.scmversion
	# Copy defconfig to .config if .config does not exist. This allows
	# recipes to manage the .config themselves in do_configure_prepend().
	if [ -f "${WORKDIR}/defconfig" ] && [ ! -f "${B}/.config" ]; then
		cp "${WORKDIR}/defconfig" "${B}/.config"
	fi
	${KERNEL_CONFIG_COMMAND}
}
# Many scripts want to look in arch/$arch/boot for the bootable
# image. This poses a problem for vmlinux based booting. This
# task arranges to have vmlinux appear in the normalized directory
# location.

do_kernel_link_vmlinux() {
	if [ ! -d "${B}/arch/${ARCH}/boot" ]; then
		mkdir ${B}/arch/${ARCH}/boot
	fi
	cd ${B}/arch/${ARCH}/boot
	ln -sf ../../../vmlinux
}

do_compile_kernelmodules_append () {
       if [ ! -d "${STAGING_KERNEL_BUILDDIR}/scripts" ]; then
                mkdir ${STAGING_KERNEL_BUILDDIR}/scripts
       fi
       cp -f ${B}/scripts/module.lds ${STAGING_KERNEL_BUILDDIR}//scripts/module.lds
}

addtask kernel_link_vmlinux after do_compile before do_install
RDEPENDS_kernel-base = ""
INHIBIT_PACKAGE_STRIP = "1"
