// Copyright (C) 2018 Amal Hussein. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
esid: sec-atomics.notify
description: >
  Return abrupt when ToInteger throws for 'index' argument to Atomics.notify
info: |
  Atomics.notify( typedArray, index, value, timeout )

  2. Let i be ? ValidateAtomicAccess(typedArray, index).

  ValidateAtomicAccess( typedArray, requestIndex )

  2. Let accessIndex be ? ToIndex(requestIndex).

  ToIndex ( value )

  2. Else,
    a. Let integerIndex be ? ToInteger(value).

  ToInteger(value)

  1. Let number be ? ToNumber(argument).

    Symbol --> Throw a TypeError exception.

features: [Atomics, SharedArrayBuffer, Symbol, Symbol.toPrimitive, TypedArray]
---*/

const i32a = new Int32Array(
  new SharedArrayBuffer(Int32Array.BYTES_PER_ELEMENT * 4)
);

const poisonedValueOf = {
  valueOf: function() {
    throw new Test262Error('should not evaluate this code');
  }
};

const poisonedToPrimitive = {
  [Symbol.toPrimitive]: function() {
    throw new Test262Error("passing a poisoned object using @@ToPrimitive");
  }
};

assert.throws(Test262Error, function() {
  Atomics.notify(i32a, poisonedValueOf, poisonedValueOf);
}, '`Atomics.notify(i32a, poisonedValueOf, poisonedValueOf)` throws Test262Error');

assert.throws(Test262Error, function() {
  Atomics.notify(i32a, poisonedToPrimitive, poisonedToPrimitive);
}, '`Atomics.notify(i32a, poisonedToPrimitive, poisonedToPrimitive)` throws Test262Error');

assert.throws(TypeError, function() {
  Atomics.notify(i32a, Symbol("foo"), poisonedValueOf);
}, '`Atomics.notify(i32a, Symbol("foo"), poisonedValueOf)` throws TypeError');

assert.throws(TypeError, function() {
  Atomics.notify(i32a, Symbol("foo"), poisonedToPrimitive);
}, '`Atomics.notify(i32a, Symbol("foo"), poisonedToPrimitive)` throws TypeError');
