SUMMARY = "Broadcom Oops Dump"
DESCRIPTION = "Broadcom Oops Dump"
SECTION = "console/utils"
LICENSE = "GPLv2"
INC_PR = "r3"
LIC_FILES_CHKSUM = "file://COPYING;md5=eb723b61539feef013de476e68b5c50a"

DEPENDS += "boops-k-headers boops-k util-linux"
PROVIDES += "boops"
RPROVIDES_${PN} += "boops"

SYSTEMD_SERVICE_${PN} += "boops.service"

SRC_URI = "${RDK_GENERIC_ROOT_GIT}/boops/soc/broadcom/common;protocol=${RDK_GIT_PROTOCOL};branch=${RDK_GIT_BRANCH}"
PV = "${RDK_RELEASE}+git"
SRCREV = "${AUTOREV}"
S = "${WORKDIR}/git/boops"
inherit autotools systemd

LDFLAGS_append=" -Wall"
CFLAGS_append=" "
CFLAGS += " -Wall -Wno-unused-function"

FILES_${PN} += "${systemd_unitdir}/system/boops.service"
FILES_${PN} += "${base_libdir}/rdk/boops.sh"


do_install_append () {
    install -d ${D}${systemd_unitdir}/system
    install -m 0644 ${S}/scripts/boops.service ${D}${systemd_unitdir}/system

    install -d ${D}${base_libdir}/rdk
    install -m 0755 ${S}/scripts/boops.sh ${D}${base_libdir}/rdk
}
