/* { dg-do run { target { aarch64_sve_hw } } } */
/* { dg-options "-O2 -ftree-vectorize" } */

#include "cond_cnot_4.c"

#define TEST_LOOP(TYPE1, TYPE2, N)				\
  {								\
    TYPE1 pred[N];						\
    TYPE2 r[N], a[N];						\
    for (int i = 0; i < N; ++i)					\
      {								\
	a[i] = i & 1 ? 0 : 3 * (i + 1);				\
	pred[i] = (i % 3 < 2);					\
	asm volatile ("" ::: "memory");				\
      }								\
    test_##TYPE1##_##TYPE2 (r, a, pred);			\
    for (int i = 0; i < N; ++i)					\
      if (r[i] != (TYPE2) (pred[i] ? !a[i] : a[i]))		\
	__builtin_abort ();					\
  }

int main ()
{
  TEST_ALL (TEST_LOOP)
  return 0;
}
