// Copyright 2017, the V8 project authors. All rights reserved.
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above
//       copyright notice, this list of conditions and the following
//       disclaimer in the documentation and/or other materials provided
//       with the distribution.
//     * Neither the name of Google Inc. nor the names of its
//       contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

// Generated by tools/bigint-tester.py.

var data = [{
  a: -0xdbc196c718e428d8cbb1424c680341e5a740a9d747115d7n,
  b: -0x82b384f7c8532057ec8b84cb94ddcf2f4adbe678beb153b761c33d8a2n,
  r: -0x530016c408840890c9810248480240a4a140a1414311081n
}, {
  a: -0xc2fe28a379d0c0b587b245040845255bfe57a7b486a8247885f8970n,
  b: 0xad8b7eba4fan,
  r: -0xc2fe28a379d0c0b587b245040845255bfe57a7b486a800708140906n
}, {
  a: 0x76e85fc1799n,
  b: 0xa32e6a86421c7b17640d4c51bfdfea4aeebc7111b5d3ecbafc7c97n,
  r: 0xa32e6a86421c7b17640d4c51bfdfea4aeebc7111b5d7eebffc7f9fn
}, {
  a: 0xb11bc649027d7d9cce8b560176b73239c42c27d3333138n,
  b: 0x96606e1344e09404ef2e4n,
  r: 0xb11bc649027d7d9cce8b56017ff736f9f46e2fd37ff3fcn
}, {
  a: -0x118b2907adb82fb319b848cf401e2f53b95d6d09cc7618b3e75efa32c5bb20a14794n,
  b: 0x56d7ca79ad5d109608741ddee890599450b4ff36b225198252e4d5129b4087b8f7a1n,
  r: -0x108210600a02f2111884001000e2643a94900094c520031a51a2a2044bb20010013n
}, {
  a: -0xc94aefeb9f4aa8205fd70099dd95d2ca2513b3b28en,
  b: 0x1df2e152ee6324d17baaee75b14n,
  r: -0xc94aefeb9f4aa82000d10091198592c8051110a08an
}, {
  a: -0x4d2e16616d15288acc767cb7826ae161789958e5437e681baa6c7n,
  b: -0x50b62d64c13b8a69034n,
  r: -0x1010254040280a28003n
}, {
  a: -0x51baea157a3fd982a4dd1d8952f98d9afba0a168b5193feec35645n,
  b: 0x416cf1db3ded557cbd3c7019aa4328200c1a8f15e3n,
  r: -0x51baea157a3f988204040000028100828ba00128951933e4404205n
}, {
  a: -0xfe1aacc53d5f877cff2710b0b09780bd5418ee86eed3b8482f0n,
  b: -0xb9a3f5fbb9e326080006b9ad9ec1e238976a990cc8c366a201b38af4a99e2115fbcn,
  r: -0x2a8851c41823897221000808300a000108a84a89220002acn
}, {
  a: 0x1de3aa0fc5da4bc127033e45cb01fec86363e7a91ac6cf4b251222n,
  b: 0xd1536a82ab3e4bbd39n,
  r: 0x1de3aa0fc5da4bc127033e45cb01fec86363f7fb7ac6ef7f6fbf3bn
}, {
  a: 0xca1de105c6b314ec3014c3de4561f3075cf19ba5b5d482b7c315fe34ce09bdn,
  b: 0x8cden,
  r: 0xca1de105c6b314ec3014c3de4561f3075cf19ba5b5d482b7c315fe34ce8dffn
}, {
  a: -0x4ad2d97580f3fd083b210fc157fc5560a248e1dc3bfed082aa71ff584f55ee46ddn,
  b: 0x69ed9095315287e329n,
  r: -0x4ad2d97580f3fd083b210fc157fc5560a248e1dc3bfed08282106f484e056804d5n
}, {
  a: -0x1f586cd9333da62793716a659430d821958adaecd6875c6afc396118ad6838c21efcf2n,
  b: 0x22c4b4b1969a0b86623753n,
  r: -0x1f586cd9333da62793716a659430d821958adaecd6875c6adc394108296030401cc8a1n
}, {
  a: -0xf6bba412891ab0cd3f5f50416a3bn,
  b: -0xd912910c4dab62b93eefn,
  r: -0x8912900c0d0b40012a2bn
}, {
  a: 0xf1b0866515fa71ea8595cb8b32a933892b086876369c0217bcn,
  b: -0xcad46aba2d2853be56en,
  r: -0x484468380c00139e042n
}, {
  a: 0n,
  b: -0x1584a0be8e7ffe5de59e52a581df3a6e3dcc9c48e495de5eab864117ab9cbn,
  r: -0x1584a0be8e7ffe5de59e52a581df3a6e3dcc9c48e495de5eab864117ab9cbn
}, {
  a: -0x2cf189acf5019d143f278c48363n,
  b: -0x9afd547508db369f587bf22e9acbd47f4653a61c7596n,
  r: -0x4b100a8a401051425220040101n
}, {
  a: -0xc05f226fb29592dd0edb9n,
  b: 0x6c0c49855f2ce0fe28666c399aa9n,
  r: -0x800d20601011901c06511n
}, {
  a: -0xa5669d093654c6d902ec1c0809902e0a575bdd51332c67031a8d1c8n,
  b: 0xfn,
  r: -0xa5669d093654c6d902ec1c0809902e0a575bdd51332c67031a8d1c1n
}, {
  a: 0x3cd085da49905d2b30fc02ff49d2c1d99a7f75a5cn,
  b: -0xf8b068n,
  r: -0x8a024n
}, {
  a: 0x54b3854bb9be451d96b69135ab3ad1e15e826f6df8bfac0e3c7e9859e67a45392n,
  b: 0xf36545cbccb3120c70075fb38b1fd35f295b16dcceecn,
  r: 0x54b3854bb9be451d96b69f37ff7efdeb7fa2ef6dfdffbcbffd7ffaddf77fcdffen
}, {
  a: 0x7eee5n,
  b: -0x9ae5n,
  r: -0x1001n
}, {
  a: 0x9200bc3956ecf633f0db35603e165c8c508b0d0931af561da50fcf8b241be1d7a63f8cn,
  b: -0x2cf00bf0712184e0c7a6288d0526cc7e7d07300ba048f307d0a24f45081d2991n,
  r: -0x4a00300400104c0878028810126447274061009a048f0005082440408190011n
}, {
  a: -0x520fc02173d1153c0679c36165eb9371cc7ac5597e11f8faeca578b5n,
  b: 0x8adbcbe488e2612bf782b7dc8ea0143fd5an,
  r: -0x520fc02173d1153c0679c34041419371c868400154003010eca400a5n
}, {
  a: 0x8f69c350a143624f134b04348f2ebcffd7f0358179a09d64dn,
  b: -0x753f88bf49c1324327744d3af5780b07c84a032b1n,
  r: -0x543c88b0488032432050410020080a06804a020b1n
}, {
  a: -0x793b1bn,
  b: -0x704fd2ac4123bc707464a6b8eef9n,
  r: -0x382a19n
}, {
  a: -0x786dn,
  b: 0x25d17edc2d268336c119bc537a5ade4dd8213f85b9ccc2dc77fd4n,
  r: -0x29n
}, {
  a: 0xc8b93ac5dc4fa95853eb33ccfd61792n,
  b: 0xa9d451b372ad0694dfe24f1b316dc2c6961cb5754201df21db8f1n,
  r: 0xa9d451b372ad0694dfe24fdbb97fc7dedfbdfd77eb33dffdfbff3n
}, {
  a: 0x569e5a647507c609c22f69e0e0206f7ac991ea291bd0b017f873963e638fdn,
  b: 0x63a3d3fd7a3713cbn,
  r: 0x569e5a647507c609c22f69e0e0206f7ac991ea291bd0b63ffd7fd7bf73bffn
}, {
  a: 0xcb34621e0d9632193166b6bdan,
  b: 0xd8326e9bc44edb90dd460704981207a160an,
  r: 0xd8326e9bc4cffff2df4f9736993367b7fdan
}, {
  a: -0xebeb432c3f3049b9f9e1763e025bc10e8f871a029c1f8e2fb5dac5de458f466071e0n,
  b: -0xe5cf1d9903cc69c3fb6447e5690f1c2860241c61cff612eb6b4d813d4n,
  r: -0x48b1d9803406001b80040e061000800602018418c5400486044011d4n
}, {
  a: 0xcba053dda679687f56b2ec349a5af1n,
  b: -0xfb1c7c63576ca02e6bf08dcca9d293n,
  r: -0x301c2c2251048000294001c8218003n
}, {
  a: -0x68753435e0445a082bf94ef89969aad9927d435ccf67a2ccbca0d0fdn,
  b: 0x9186995dd9c8f5fn,
  r: -0x68753435e0445a082bf94ef89969aad9927d435cc6678248202050a1n
}, {
  a: 0x9a0ac3f91d3n,
  b: -0x2f5cee02359a428045d10eac764a48c31b3e6cecde0299450n,
  r: -0x2f5cee02359a428045d10eac764a48c31b3e6c64d4000040dn
}, {
  a: 0xc09e22c06664f3587a03fb84625ee9d8c8de12ca17e2ed4ff4n,
  b: 0x25e9b6f033104e36182882020345ba0ee1ba9c1ddbb64b52763c47c06684cefd3264n,
  r: 0x25e9b6f033104e3618e89e22c367fefff9fa9fffdff65ffbfefcdfd2ee97eefd7ff4n
}, {
  a: -0x11255c60b3254075230f86cn,
  b: 0xb113f6c5ea0c3a7dea43be2132fa2d9c92e8cf514aa9624f4fdf25abba1n,
  r: -0x1024144091200020020404bn
}, {
  a: -0xc0daa9b70ef77a48badaa1629245d1439an,
  b: 0x575en,
  r: -0xc0daa9b70ef77a48badaa1629245d10082n
}, {
  a: -0x14f353e977bbfe07ce1e0836e6376d31065n,
  b: -0xe1ff2bede42de2b22a48f493n,
  r: -0xa1e028e1e001622222401001n
}, {
  a: 0xcf8d5e9a552781049157ebdb147d45868bdf54n,
  b: 0xc0e48f281e9en,
  r: 0xcf8d5e9a552781049157ebdb14fde58fabdfden
}, {
  a: -0x76993bcaf3e117647b6b5bee4fb21703f97ff0c5581e38d5ab25651666n,
  b: -0x66792477b48c0b51944ed210e865ca24da95077a426dc23d481123a74d16bn,
  r: -0x12013b48c0a1114469210a864ca205015077a004580210810220641061n
}, {
  a: -0x3c44705943102eb51c43n,
  b: -0xea6fae92ce34fe58be3n,
  r: -0xc04704900000ea50843n
}, {
  a: 0x7b32187aaaba607c3aa554c5a9eb0eddaabdd160a075f28bfn,
  b: -0x9374bbf418fa8eda0c5bfc94294cbf9bdd010f9a8908e6514fe536d227c871315b47n,
  r: -0x9374bbf418fa8eda0c584c9428441419d800058a810060410225140221c070205341n
}, {
  a: 0xdc85fcbb1894ebed1bc5763f10a147ce8cf0987df1b8480f582e2446n,
  b: 0x6a962bdac8438c4ba5659a26ccbn,
  r: 0xdc85fcbb1894ebed1bc5763f10a147efeefdbcfdf9fcfa5f59ae6ccfn
}, {
  a: -0xd96cf043387d898915fc698490d6e36c919f89b34081e2b9514cca6268bcc16406a0n,
  b: 0x3fb137555b5b9ee47ccfa8e90db8ad28d3be0662a88n,
  r: -0xd96cf043387d898915fc69849004e008800a00110001003141044020608401000418n
}, {
  a: -0x6815aa1cn,
  b: -0x11n,
  r: -0x11n
}, {
  a: 0x8fffb7ffbb10d257f1664683367f70f290d0e824cecf56458a47ee74700a3f35d9e89en,
  b: 0x70n,
  r: 0x8fffb7ffbb10d257f1664683367f70f290d0e824cecf56458a47ee74700a3f35d9e8fen
}, {
  a: 0x80934e35273d6cb1cbbec615914f946233844dad8c76d30c13n,
  b: -0xb86e0b5b634341d94600ba59fa85708aeff5b2c599cdf1c18dfn,
  r: -0xb0660b182100011042001218a2810088ccc5b205010890c10cdn
}, {
  a: -0xbe421bf21c02ee8174be4997362edf365d0865c210b8en,
  b: 0x75181bd6c26d5a7fb5e909bd3cd752d15a99939c21aec57055d6f95e9468dfc2705n,
  r: -0x24208a00c006600609e4112062a09060108050010889n
}, {
  a: 0xd34en,
  b: -0x2fd8b9n,
  r: -0x2f08b1n
}, {
  a: 0x1d344c27c11bab42c169febfcbf2b35c19e02n,
  b: -0xab68n,
  r: -0x2166n
}, {
  a: -0x7b4fb3782298a867b7fa05893a88e2a17c3f29fn,
  b: 0x9e5b5fd2d6e8dffebe6943dfd1325b4dcca2142cc634437788492e579ecb3n,
  r: -0x200e812022100863933801880800a281282120dn
}, {
  a: 0x1a826a5d219242ddb621047c100ee65eb23a1a6cfd7a385e95d85n,
  b: 0x262f510561a5676428a85f282c64876851396n,
  r: 0x1a826a5d219242ddb62f557d71afe77ebaba5f6cfd7ebf7ed5f97n
}, {
  a: -0x218ca425cf445f692daf6e5bn,
  b: -0xe6d4c5b86268c5e6b09c322900a33c6c101416e7086a4f4bb72af2fean,
  r: -0x10024208604542920af2e49n
}, {
  a: 0xf3dbea04bc456n,
  b: -0xc86f15d77f09162c546b4e7f22f44528ee39c649420267a8fc6067c4n,
  r: -0xc86f15d77f09162c546b4e7f22f44528ee39c649420042005c202382n
}, {
  a: -0x4d31351ebcb0545008f5b83f929d2fcd4e836563dae008bn,
  b: -0xcc677b8519f78c55e76cfb4fff815c8d4a3507ab5a416691acb2962fn,
  r: -0xd30051e348014500815881482102a8504026102ca2000bn
}, {
  a: -0x79172c102f2cf0f5571e8e6145a21eac8a93fffe09db1n,
  b: 0xeddc8b3724f47fe1614f9b206a13654d330a8a381d9e986n,
  r: -0x211408100b00109410048e014482128c8011c7e201431n
}, {
  a: -0x9df2dcb7c6eba2cd7fa9021df1813c704f60b44eac0476n,
  b: -0x747eab32a840f1f0e947c7901855276b52b3a77ccn,
  r: -0x407c2a322840f090214700100004260b40a280442n
}, {
  a: 0x1e66c8993d57a085b1a13f8904afd3871721e0599f6607fa60adn,
  b: -0x92f7726bc38c6602f2d096b608ace23a58324n,
  r: -0x80e5600343840202828080b20008820058303n
}, {
  a: 0x2c53f337bb4b3c88472b8129785d9ce29e74e5f76e3d959265ad0965ab3b3a40e122n,
  b: -0x57e45e70da9f7e84n,
  r: -0x56805440c09f1e82n
}, {
  a: -0xde884a20ba1157e0116d0c5fcb8e2n,
  b: -0xbaeac41042d639f682f6ef7n,
  r: -0x20aa00104010290402c28e1n
}, {
  a: -0x8aef6973370f000925544892167fee7383e08f16a07c2edaf6fd8cf043n,
  b: -0xa2498bf78ccd1e8bb8de82d74a4dff57b3737ba8bc48n,
  r: -0x1004080041e8a3082808702007c0692727988b043n
}, {
  a: 0x6c1a33e1c6cd3915aa7f2173feb40ca72dn,
  b: 0x43f90696n,
  r: 0x6c1a33e1c6cd3915aa7f2173fef7fda7bfn
}, {
  a: -0xb20d0558a178b3cf2n,
  b: 0n,
  r: -0xb20d0558a178b3cf2n
}, {
  a: -0x26d8594e972a1894f6acfa6992b3462cfd5c53b0a29c5829d0b68b7e775a60ff81n,
  b: 0xa6cn,
  r: -0x26d8594e972a1894f6acfa6992b3462cfd5c53b0a29c5829d0b68b7e775a60f581n
}, {
  a: -0xc2692dcdae711f61205bc53f3a930460d922957a2bd6ce37a9c3ef28409e616dfan,
  b: 0xef8127ebn,
  r: -0xc2692dcdae711f61205bc53f3a930460d922957a2bd6ce37a9c3ef284010604811n
}, {
  a: -0x37f0cc4fc293bfc20dbae470d4fb8n,
  b: 0x2c7b3fa494767baf3c03fn,
  r: -0x37f0cc4fc280804209888450c0f81n
}, {
  a: -0x3f13268ca460e1d8da00bcb251618bbc28fn,
  b: 0xaff41c1a31fe2866cfb2a16c37f0e195e14865f9n,
  r: -0x3e10200c200000d0c80080b040218b38207n
}, {
  a: 0xa92a353a6028c5be14dafedded48f541n,
  b: -0x384n,
  r: -0x283n
}, {
  a: -0x902839581088764f66a027b5eb13d55en,
  b: 0xe8fd6ce874522aa22n,
  r: -0x902839581088764160202130aa11555en
}, {
  a: -0x5cece138bd0141770679850n,
  b: -0x375f7n,
  r: -0x31047n
}, {
  a: 0x8e48219e467166158da00e105e95a914ac7n,
  b: 0xc1abe509e2d81abn,
  r: 0x8e48219e467166158da0cfbbff9debdcbefn
}, {
  a: 0xa41an,
  b: -0x16ac087730d84de8b364ec5069a88cb93feb3cbcc03b84e43fd4e9bcc3bcec74n,
  r: -0x16ac087730d84de8b364ec5069a88cb93feb3cbcc03b84e43fd4e9bcc3bc4862n
}, {
  a: -0xbbbfab0643a980cf4f7cf3496af5d2af43656c9e0aa3ffac76d9e5ab3n,
  b: 0xc47cbdfaf640fdcb5d1784d7f7e1f870efe49n,
  r: -0xbbbfab0643a980cf4f7c3301420500af022420880a20080c0689000b3n
}, {
  a: 0xe9e2d5n,
  b: 0xdbf388807e10d22n,
  r: 0xdbf388807e9eff7n
}, {
  a: -0x13ca5d70347c69a78b77df6d1678n,
  b: -0x9cc01fd3a6cb59391da13cb9096b9b47a90d17c500c8f610372945dfn,
  r: -0x1342090014440080821017290457n
}, {
  a: -0x4da27b63287655db2fb33f1be23b6ce28231bn,
  b: -0x45b1c64e0d659ff720bb3c8f6d32ed171ad92b6cec4c307786ca1n,
  r: -0xa23803283245130a912b08e008206282001n
}, {
  a: -0xc3b864e619de4b935a36637b9f0f0e784ce257870ed5ca688d7ca206f04af2eb9c55n,
  b: -0x7c72an,
  r: -0x38401n
}, {
  a: -0x198681231f6076f38e8d95051b9192c88n,
  b: -0xff525311b5cd97284630326da6392b82041a9c6fde25ffbn,
  r: -0x80600220d203023820410040b9000c83n
}, {
  a: -0x229e05ae898044n,
  b: -0x5b0f1f99c776684n,
  r: -0x2090018c010004n
}, {
  a: 0xa9115faa671185n,
  b: -0x730f6c02fb20e66096663bb36214ecn,
  r: -0x730f6c02fb20e6601666201100046bn
}, {
  a: 0x31f70cd4fb0753f05b01502338cafbad5a0cd5n,
  b: -0x15ba8116ab1d087cfdeaa1417f67c74e0e61n,
  r: -0xb20104a80c0824fcaa8041350442040221n
}, {
  a: 0x7a96674c653c4a351bce9b6b07de49176b987f3b5db7b620503269dcc04856d7an,
  b: -0x7932afb15f2dda0fd3b7aee050c6ed789d6935d1226bf7dad0d6bb38n,
  r: -0x28320ca04304480f82132e8040400c48040015d020496212d0529206n
}, {
  a: -0x294b9d6271cc81f7c9a90e24a38e5387108e9dfe3de77e0a1f3b76n,
  b: 0x47270fc44823b17ef49f990a42a3925eb24ebbn,
  r: -0x294b9d6271cc81f788880020a38c4281000004f43d446c000d3145n
}, {
  a: 0xf4c2945733a93cb0fcb9349d204090a6dd8b4eb708e3e6a759144a4810fn,
  b: 0xen,
  r: 0xf4c2945733a93cb0fcb9349d204090a6dd8b4eb708e3e6a759144a4810fn
}, {
  a: 0x10baed4019a305966cb192707d423a9bd95c1dc0d4a3aebf358n,
  b: -0x59f1774230n,
  r: -0x11c1140028n
}, {
  a: 0xbf113d1c1ca7d8d9139b6cbe1fee3a2e241db4d845b42bfdd9056fba7f9cafn,
  b: 0xf3679ee176dc2b0bb9b32277e7db151f2ff64a6n,
  r: 0xbf113d1c1ca7d8d9139b6cbf3ffffe3f6ddfb4fbdfb62ffffdb57ffafffcafn
}, {
  a: -0x513b6c9421dbd4034b861de9e12f91d121c6d943cn,
  b: -0x85a6f43345df85e84896ccff7fc95779a96b8653173n,
  r: -0x3020040181c00002841d69c1071181218651033n
}, {
  a: 0x43a13811a6d5cc015eca613741dfc300374f14fbc2be8a7d5a82dec814fff1d9f2d8n,
  b: -0x1a8853e6c84476c5f613e48ca2a52b5ea9fbefc1654cbeef9e841fn,
  r: -0x1a801186c8042004f600a0880025015480a16d012548000e060407n
}, {
  a: -0x33bd5170ee3375e22a845a7461682b5e948c877d528ad053d235425f807687ae3ac77dn,
  b: -0xe8n,
  r: -0x65n
}, {
  a: 0x85bef13f2e2b4842615553e01684n,
  b: 0x182d08b3e8ed17182463f001f6n,
  r: 0x85befd3fbfebed57797573f017f6n
}, {
  a: -0x3a5n,
  b: -0x7adf75dedn,
  r: -0x1a5n
}, {
  a: 0x61213a735a43f595d905039f34006cc934118n,
  b: -0x58dcdd01n,
  r: -0x104c9c01n
}, {
  a: -0x335c341914b4957ae79fcb3n,
  b: -0x47035a0d8a5e7cfa7777a6ecb6662e0a9cec2e56a04e7a33a10c4e77f85ca3bn,
  r: -0x204c301100040472e01c833n
}, {
  a: -0x4a7bb307151aaaf75b638240e82edc81b8c9n,
  b: -0xd6afdcdc866f47d0bb6b3f14a3ad04dfc30c18391d1n,
  r: -0x4862b0050112a2f14a228040e820c08190c1n
}, {
  a: 0xec7da9b7f7144ad489986cac40be07375834e82c040cd8b89f999b4n,
  b: -0x77fdc34d095e212a56bcee371e86aaeef0ae1d6e49aa3bb998n,
  r: -0x64808209001620281438e4170c8228a0702e1d224022022004n
}, {
  a: 0x66596359f8ccde003047fefc739d811fd062b5d9303e5n,
  b: 0x301b28an,
  r: 0x66596359f8ccde003047fefc739d811fd062b5f93b3efn
}, {
  a: 0x9185d9n,
  b: -0xada122eden,
  r: -0xada022a05n
}, {
  a: 0xe42b80b8800a4afb8n,
  b: 0xd08an,
  r: 0xe42b80b8800a4ffban
}, {
  a: 0x2f70a68fa0116d8f56a8cff12b79b92a014c6a5an,
  b: -0xbc1d98c979d232cc64d042b0cb19742c7596n,
  r: -0x181018c81050204420004080421174201586n
}, {
  a: 0x6c51de2492efc9b88dabc3n,
  b: 0xdaa126d994n,
  r: 0x6c51de2492efdbb9affbd7n
}, {
  a: 0n,
  b: -0x808ff262b449455de740c14ecd337aden,
  r: -0x808ff262b449455de740c14ecd337aden
}, {
  a: 0xfe13d5c67db57b556651fe00409eb0d594caa534n,
  b: -0xaf908f265e3d27b357351e63faff9n,
  r: -0xa8008902401d23b21430062350ac9n
}, {
  a: -0xfe73b1aacc1a958bc3680701644121af22en,
  b: 0x10971eef26873f348dc0875408313efe61n,
  r: -0xfe7280000c128408832007002440200000dn
}, {
  a: 0x6dfd76ccb578d3abe356d6a9b682b9dca6ec62f44daac70ac1da5c1d686e83n,
  b: 0xd78n,
  r: 0x6dfd76ccb578d3abe356d6a9b682b9dca6ec62f44daac70ac1da5c1d686ffbn
}, {
  a: -0x701a346f53ff496f685230142d1bce244713c54e268c8196beff1aa307c392e78ca61n,
  b: 0x9858e051ea7bcbac940307c05a4229ee9c7bf6d4901a9512717118649e1c6bfc0n,
  r: -0x701a242713ae010420522014281b842446114104000801842aed0a82078300e384021n
}, {
  a: 0x10472f3319635f805n,
  b: 0x3b81996e0a4c78431e3an,
  r: 0x3b819d7efb7dfe77fe3fn
}, {
  a: 0x70b5961f48f49ff41166d5177fb5f8a06bb54596d0fd65da2bb2an,
  b: 0xcc97c25db17b3fe8eac16608541en,
  r: 0x70b5961f48f49ff41166d5177ffdfca5fbb7f7fedefd77faaff3en
}, {
  a: -0x6572e3057bd63b22a80d906f254dac7e0fedc4c7da66865e8323cc96f078a4cf4093n,
  b: 0n,
  r: -0x6572e3057bd63b22a80d906f254dac7e0fedc4c7da66865e8323cc96f078a4cf4093n
}, {
  a: -0x622580252af08bf002e9n,
  b: -0x965de24c12a21f76b056d25d2f455fdcb9e7e4b16b4d4da52n,
  r: -0x600180240a1080d00241n
}, {
  a: 0x1c963a0fc6dn,
  b: 0xc5697e5869127fc06d5263397195b01a3c1n,
  r: 0xc5697e5869127fc06d5263397d97ba1ffedn
}, {
  a: 0x929d1c01e8c85c4f4618226een,
  b: -0xdc90e2f04c24305a04730n,
  r: -0xc09002300020304204102n
}, {
  a: 0xd4b29ee781fc14ec8n,
  b: -0xfn,
  r: -0x7n
}, {
  a: 0xae2d8cb205315n,
  b: 0x3361bn,
  r: 0xae2d8cb23771fn
}, {
  a: 0x4b0dbc101fb4fe3dn,
  b: -0xd314e5f457569aa358a4c9817caf1n,
  r: -0xd314e5f457569a030024c800300c1n
}, {
  a: -0x49f83n,
  b: -0x10007f6698ffb0a6d8e87ca040e8baaa700adb668ceef9a374d70a3a2901n,
  r: -0x901n
}, {
  a: 0xaf70785e57bf3eb9b4521894e3bbd6b68d15eaa10e2261n,
  b: 0x92bc763ca97ad7890deae4416c0fc0e1debcf96acffe40cec1c59ae7ced72efn,
  r: 0x92bc763ca97ad7890fffe7c5ed7ff3ebdffdf9ebcffffdefe9d5deefdef72efn
}, {
  a: 0xbd98717c9f323f33e85ff5a705481f55f841c8a427n,
  b: 0xc91129an,
  r: 0xbd98717c9f323f33e85ff5a705481f55f84dd9b6bfn
}, {
  a: -0xcabe0b6e306fbe25b337a96e6bbn,
  b: 0xc1cd7950f195ffcn,
  r: -0xcabe0b6e306f3e208227086a003n
}, {
  a: -0xc2bfcab92f1afa13bcbf2a6n,
  b: 0x372e39dac9ad000514fa5eaa3fc49e28206745992d13be0dcae79bfn,
  r: -0xc2988a20020840123418201n
}, {
  a: -0xe3caaa31c48e1e617f3cf730a43fc18421ab9d538a53acb52ac8d98bn,
  b: 0xec748c83bn,
  r: -0xe3caaa31c48e1e617f3cf730a43fc18421ab9d538a53acb128801181n
}, {
  a: -0xe03ef490b1c4dcfadff111661b2d7n,
  b: -0x8fb2740ac6b172dbn,
  r: -0x8fa07400062132d3n
}, {
  a: -0x76fec0b397aff65637e55409e821cae0894n,
  b: 0n,
  r: -0x76fec0b397aff65637e55409e821cae0894n
}, {
  a: 0xe4513ff780a4505bd7c3be8d1f446b72cd8f433117ca21n,
  b: 0xbd12e1c8f2c57c2cbf71f52c108cdf34can,
  r: 0xe4513ff780a4fd5bf7cbfecd7f6cff73fdaf53bddffeebn
}, {
  a: 0x9cf496fada51e0n,
  b: -0xade36ab01347a67e62e0db80c7c1e81e56aa0a2fa2770825c0aaedf37an,
  r: -0xade36ab01347a67e62e0db80c7c1e81e56aa0a2fa2770001400025a21an
}, {
  a: 0x53103e99ee9cead8c2e8cff5n,
  b: 0xe21970291730e0e4f502686n,
  r: 0x5f31bf9bffffeedecff8eff7n
}, {
  a: -0xd458ce30c64923084280727e50e9295ab9ce81b07ffba277223ef7ab439n,
  b: 0xc32d43ce9759f7027ce0f7d95ee8e2e17a9fc423ea90853fa7021481n,
  r: -0xd450cc20c2000200028030700068015091c800003dc102772004878a039n
}, {
  a: -0xb632defcec9931046a288ecaa8f21fc2an,
  b: 0x2ba4c7804a2a28n,
  r: -0xb632defcec9931046a28048280f21d402n
}, {
  a: 0x742054b4997bf89939a570270886e6a90f4a016fe8632156e6d14c3c5138ab0add9n,
  b: 0x3ddn,
  r: 0x742054b4997bf89939a570270886e6a90f4a016fe8632156e6d14c3c5138ab0afddn
}, {
  a: -0xac22994bb562587f36adbb815df90296af6bn,
  b: -0xf13772da625ba081b4a1faf74a40e02d63dbce2en,
  r: -0x2002004ba000102132a50a00402902928e29n
}, {
  a: 0xb7068ee0f8ffe611483fae9ad19e8881dd2cd1ae7bff41814c96ece19849af6be83a99n,
  b: -0x5b1ff532549n,
  r: -0x41094130541n
}, {
  a: -0x4afbb5n,
  b: -0x36d29952b4169de0da4d60cb660fd07b8d7fb42febee3e1d3b8731e6f3f0n,
  r: -0x42f3a5n
}, {
  a: 0xa62b4fc0a94dba089b3bb72cn,
  b: -0xf7e0c8b5d0642e3b87fdc13b0e5cb3d009a8294abfe8e6c734313f25cc44477fn,
  r: -0xf7e0c8b5d0642e3b87fdc13b0e5cb3d009a8294a19c0a0071430052544444053n
}, {
  a: 0xcb0d87n,
  b: 0x840fan,
  r: 0xcb4dffn
}, {
  a: 0x3c89bbbc3cefb85d1e671f0a0456d783a85a8d455b9a6291f75758dn,
  b: -0xd806211508d546cd50a6618b82a936cd282273c806be2d7f15c5183bf4aba8cdc67705n,
  r: -0xd806211508d546cc102440080000320c08020348029205451045082a440980c0820201n
}, {
  a: -0xe088cc7846dba2f73cc76ea079eb3e40aa4ca6602n,
  b: -0x66n,
  r: -0x2n
}, {
  a: -0x674057aade34860819aa03d5d888d570069a1d90cc7745bb5f1e2ff97513da49d6918n,
  b: -0x2abn,
  r: -0x3n
}, {
  a: -0x7b7d4b206bc86503957ac2fc73fn,
  b: -0xef253c4b2300e2b9741f320d866c5edce12fc8e57n,
  r: -0x39740b2009806402946002c8617n
}, {
  a: 0xe7ee9cdff89d543ae20e61a8e176c667dn,
  b: -0x6e34c5n,
  r: -0x21081n
}, {
  a: 0xd34e934755ca8e1a6344ded71a9n,
  b: -0xeaba6a58eba94900288d5030cc3cn,
  r: -0xe28a02488aa14100088910108c13n
}, {
  a: 0x75122c832a6af2f08722f012a3n,
  b: 0xa65ce008d015b9b641aca6e660d9aafecf49b6bd2505d178f2a46079ee0ffc6n,
  r: 0xa65ce008d015b9b641aca6e660d9aafecf49b7fd27cdf3feffaf687bef0ffe7n
}, {
  a: 0x9b5d4a61bben,
  b: 0x59e4af931f7bee2636a5533614411ac811c755c33d4b90ad35c6dd1bdc970f6af4n,
  r: 0x59e4af931f7bee2636a5533614411ac811c755c33d4b90ad35c6dd1bfdd7af7bfen
}, {
  a: -0x219e438a4aa31895ed00f074a4655d9cb65ce438b37764498f5e760352ab15756be9aen,
  b: 0x17958002de009c425b3036af45dc2d7a33df294f960857b11bfn,
  r: -0x219e438a4aa31895ed008024a4401d943258443891032009085c42014202157000e801n
}, {
  a: 0xb43915c5c4f5d914180191a9cdd15959fbd97de0d308c6ecc81db4b3b0a7678n,
  b: 0x9dbce95df64b0ef61480ac7bbdf0b0c0785b3n,
  r: 0xb43915c5c4f5d914180191a9cdddfdf9ffff7feef71cc6ecfbbdf4b3f0ff7fbn
}, {
  a: 0x383e9d99e0cec20447a37n,
  b: -0xdcdc7491ab01a06c157f156ed7aa977f0de7337b4cd1d99b7680b20510n,
  r: -0xdcdc7491ab01a06c157f156ed7aa977f0de73078040041931280b20509n
}, {
  a: 0xdc7a5ee75d137ed1c9cf5f1116bb456d8ab5c8b51eee87d0b8e71e802b66ee6n,
  b: 0n,
  r: 0xdc7a5ee75d137ed1c9cf5f1116bb456d8ab5c8b51eee87d0b8e71e802b66ee6n
}, {
  a: 0x953a9c6270ad5b6776n,
  b: 0x7af5448n,
  r: 0x953a9c6270afff777en
}, {
  a: -0xee03be7e534f74d8c8b24edba4aeabde3731a337dcn,
  b: 0x45e4cf0d9f0b9889eeb4f072bccea0a4d68ee85631411ad541fe42a105bc5c72ec4n,
  r: -0x2201b43213017098c8a2428ba00a81ce243020111cn
}, {
  a: 0x586ad0c4ce353ccdc15ad9358c0faccd015e9fc5fd62944079e9362a0n,
  b: -0xe2466175db446808014c79fbccd908f1535d86e46f0a20n,
  r: -0xa002216052442008010029ea04010021521980606c0820n
}, {
  a: -0x8dfn,
  b: -0x8fee2f2fe6c4b6ad8bb2f3bn,
  r: -0x81bn
}, {
  a: -0x134dc6fn,
  b: 0x130908496404563e8348bbf0ea857806e4494c53n,
  r: -0x134902dn
}, {
  a: -0x4c36aa3b65ce8a540dc332ee2f805769fd30742f78405n,
  b: 0x428bc835ad4c52cb5a8b5250b60152c05n,
  r: -0x4c36aa3b65ce885405c212a22d000560ad20402e28001n
}, {
  a: 0xa77f3f91143558262856da0a058ecc80af5e180950d5400d2a58c8b392n,
  b: -0xbf1ccae61722905bda8bde0f0d7cf4e5531fabc239936b16c93f4e7fn,
  r: -0x80004ae2022290538801d40a013074400107a2822893621481374c6dn
}, {
  a: -0x346d2141bee3885b5cffd05b361e0d73b9e4e894885af4833047cc5910201180c869n,
  b: 0x3d8335960186d8fa09ccbdb2975e0d1156eec3ea9dn,
  r: -0x346d2141bee3885b5cffd05b36020c4229e468040052300200408050002011000061n
}, {
  a: 0x2ddd58c764efe5d281adf737b2d472b069a46b5ea602f3535d04cf2e2bf14ffn,
  b: -0xe51c4dfd62ef14ef127ee8593b898ca8a44d8a1e6c3f72032533768f4d6d98cd37n,
  r: -0xe51c0028628910010256e000088080a88449001848151200000226830d0d00c901n
}, {
  a: 0xb23127799d5b2f3bd2a7064e18e0c0323d843dac5757afb5cc31055n,
  b: -0x8b3bab1d584824455efe2d4802an,
  r: -0xb09821940402000504a2148029n
}, {
  a: 0n,
  b: -0xde72a807358bbbce74b3f4c3a3717f652d8ed9da3c01aca1d39103342fe02df0286n,
  r: -0xde72a807358bbbce74b3f4c3a3717f652d8ed9da3c01aca1d39103342fe02df0286n
}, {
  a: -0x2071d30ca69531a2df972b872017bb4e6f8e513a303624985e2257709593bcen,
  b: 0xcd6e4f49dbabb1e68375db9c410907f761a6478n,
  r: -0x2071d30ca69531a2df972b872011b00624044018300224001e2250009411b86n
}, {
  a: 0xe4c4ab3b9d4cb58dc143cdcb43109ea5e10dcc5e0e0b51f932826214e0965051en,
  b: -0x5b8c9e2bab931f03336a1c6c02cdd78ca040a80fa7213c4e03af3b31a76bd1b0eea4n,
  r: -0x5b80922108020b00232208400249c6840000a80322011c4a002c13118621d090eaa2n
}, {
  a: -0x7e90c00bdn,
  b: 0x90db634cca9b2eed96eb4159214a31b6aa3e08188f9c1f0026594bbb6ean,
  r: -0x269040015n
}, {
  a: 0xe2e088d713b13cd637dcdb5n,
  b: 0xac20c830d846379e7e96bcc7de9n,
  r: 0xac20eaf0d8d737bf7ed6bfdfdfdn
}, {
  a: -0xd48972d19d6cf96c88301f2209n,
  b: 0xfban,
  r: -0xd48972d19d6cf96c88301f2001n
}, {
  a: -0x890a4d3feb0e5d90d90848e8df32dc002ae89d94fc19c6019db56cn,
  b: -0x71beb300202337b6f9ffn,
  r: -0x609c900000020194b16bn
}, {
  a: -0x24cb53f91331d21f3997385864e230746e867f425b1fd4a03a9b7cf64cd0a7n,
  b: -0xf5de951e8een,
  r: -0xb5ce040c0a5n
}, {
  a: -0xd36fe38f6160c9f432ec621ef2a5b0bf2a15f5059645cd6fn,
  b: -0x5b297a8d44995402dbb54d16a6520a063f7c0e5fd2d6d618cf5ed63fn,
  r: -0x4009400241204914224002063224001f0214d4008644c42fn
}, {
  a: 0n,
  b: 0x8f27ff12b9b33160d1f0846f7c0959eaea694a7fban,
  r: 0x8f27ff12b9b33160d1f0846f7c0959eaea694a7fban
}, {
  a: 0x1f4e08418ff754c734cb7e3efcd4a424d0e53d53bd427058d828n,
  b: 0x640426d5b6380cf65f1a6c5a802b9ffb7bn,
  r: 0x1f4e08418ff754c734ef7e3efdf6bc2cf6ff3f7fffc27bdffb7bn
}, {
  a: -0x37ba89e8c37221e6ba49d877a740de6ece6c73a7f64cn,
  b: 0x53831946a2b816b09n,
  r: -0x37ba89e8c37221e6ba49d877a740c64e4a0450269443n
}, {
  a: 0x2f54bcb84b205a768905b457621c86dec8a9181c31e6a21d2cd3ec0e19d7f2ebed1n,
  b: -0x306f915f98070fce42d0c09df2b8a07df63fcfn,
  r: -0x1003114e180401844200008132182000d0010fn
}, {
  a: -0x8cab64n,
  b: 0xa41a23dn,
  r: -0x8c0943n
}, {
  a: 0n,
  b: -0x6afd0617ef50cb7ae870354edf5564195ea321336e19e000dd5aac860958e3017abe9n,
  r: -0x6afd0617ef50cb7ae870354edf5564195ea321336e19e000dd5aac860958e3017abe9n
}, {
  a: 0n,
  b: -0x4f9dc4bd65d37f3ef7084cd0f3f61e817c3204ef95f77f38e7563ca7c984e3014fn,
  r: -0x4f9dc4bd65d37f3ef7084cd0f3f61e817c3204ef95f77f38e7563ca7c984e3014fn
}, {
  a: 0xdf129c6a4ee48079d25e12b4532024en,
  b: 0x503d78388cf34923442486f02a21e3686202867ba9488da39c6e3d1132c9n,
  r: 0x503d78388cf34923442486f02a21eff96bc6a6ffe94f9da7fd6f7d3332cfn
}, {
  a: -0xd9e54d3001a41n,
  b: -0x7d640dc041f6d9b26f0dff8ff835635ba8c8e433bbd7c7e7790e0f217f2431n,
  r: -0x90e0401000001n
}, {
  a: 0x835fb27cd86e79e8e766ff4191en,
  b: -0xdcea8cfb64ad254cbb829532a097n,
  r: -0xd4ca04d82029004031809002a081n
}, {
  a: 0x4e329ac252fdf5b8ba2c50f164n,
  b: -0x525e2df2a39223405950d1a1e46a302eb0c7be4n,
  r: -0x525e2df2a39223005050d0802020300c30c0a84n
}, {
  a: 0x8af5c1d8b7fb2a8732bcabb5c94c9adc12bda9fdf207ef84f6a94en,
  b: -0xdc4031041941a4f275d9e84469f3d554n,
  r: -0x48003104014100520009e80069015412n
}, {
  a: 0xd172eb08433f890c0a60ac82a862790n,
  b: -0x455effd2972f2e36874619199989de95d4b3a2815778b521e759154accafe8e850b0n,
  r: -0x455effd2972f2e36874619199989de95d4b3a2805148310007491548c427c0685030n
}, {
  a: 0xa7dcbd5849df35fb83ecn,
  b: 0x4a0b50136a55096cf97a4b785ace3004d30a2d775473n,
  r: 0x4a0b50136a55096cf97a4b78ffdebd5cdbdf3dffd7ffn
}, {
  a: -0x3172666ee8c56a6d9ace2c02ed64b349ee07816cfbn,
  b: -0x7ef5ab495796dee0b1817fd4dd9e996017ad2058d4a5ce1ec4bed69d19876a5n,
  r: -0x3140406880016a40008c0800e164034968018064a1n
}, {
  a: -0x1762c675103cccdf762b999bf06649fc49e78807f1b2a057b5099bea79355235dn,
  b: 0x84f9e7e092c32bf39c3d5c3dec842408bf4ba5a848dfan,
  r: -0x1762c675103cccdf762b19021006493c40040002a1820053910100a0581512205n
}, {
  a: -0x12240635n,
  b: -0x2ba413e10791ea3a714de7b8d126e3f203c1e1719e6e1de2n,
  r: -0x12240421n
}, {
  a: -0xdacf6978421196fan,
  b: 0xe3497829d12917ac1f474b5add85a2da6239c4652017f2f861a55d4d634bn,
  r: -0x8070858021094b1n
}, {
  a: -0x1004a09deefcb16102101f192b771db31cb29f4baa7eab41a6e76n,
  b: -0xc391c8c093bea962aa0a9e375b6cb5847fb0d4a6521affbb5df672b4n,
  r: -0x10040019ea942020000015100b5005b30c020501aa7aa14126232n
}, {
  a: 0x96722e9b8097e9f44c2f2abcaf792afabf4b133ef9110252dfe46e1f1c5e00a873b5a7n,
  b: 0x1b3fe2655b7206a9c4a17ff13f10517b4db1451dfbb9n,
  r: 0x96722e9b8097e9f44c2f2abcaf7b3ffaff5b733ef9d5a37fffff7e5f7f5fb1ed7fffbfn
}, {
  a: 0xc422f4n,
  b: 0x9e78f49b9eba0f3a9n,
  r: 0x9e78f49b9ebe4f3fdn
}, {
  a: -0x556738d2db0d94a9e34125d0e43bb8ab340357d942f18cc34b97269a48en,
  b: -0xbab4b32703f84n,
  r: -0x8200932602482n
}, {
  a: -0x11c34065346bfe2dee6fca3fc70d50f3n,
  b: -0xdf61d44f47f7n,
  r: -0xca21c40d40f3n
}, {
  a: 0x904f57ef605en,
  b: 0xf562436cbc7198f10cee67ac500f401dc8af8fe1d0cefn,
  r: 0xf562436cbc7198f10cee67ac500f401dc9affffff6cffn
}, {
  a: 0n,
  b: 0x1374bb861eea9dc28476ab0b329c1b81cffe2d91c136defa5f5465f3de5fc5n,
  r: 0x1374bb861eea9dc28476ab0b329c1b81cffe2d91c136defa5f5465f3de5fc5n
}, {
  a: -0xd77a76bca33b49c874543bd8d4cn,
  b: 0x8f10f84b4a5f129fa8d2755499563c9d28532c542156aed668039b71b2ee74eaddc5n,
  r: -0xc2101298230248c05010315000bn
}, {
  a: 0x2c34c6ce69531e181c4d8b0e46d43e72d3b279n,
  b: -0x2994b897f50557aa51241fc3b79bfe2n,
  r: -0x90088167401070a11001c009280d81n
}, {
  a: -0x2a5096eda7cce9fdd957ced12a706040905d5aca26b6acn,
  b: -0xbc3d2432a89c184c5246b0148eb8d95b27a8af6eec149c77a6f4a74dden,
  r: -0x8401244a00488b8d95306802a606000905502c026048an
}, {
  a: -0x82f07896c12e5cb0n,
  b: 0x3f7b0c1f4a18588eec87456f56b3bd42d7an,
  r: -0x82a00894c02a5086n
}, {
  a: 0xdc39ee98efc0b8270n,
  b: 0x39n,
  r: 0xdc39ee98efc0b8279n
}, {
  a: -0x30a1633a05afa267d99bd647bc0b871n,
  b: 0xc0a9092945e036e51946dee3fff404ea51fa8941823can,
  r: -0x10a0212004000263118a0446bc09831n
}, {
  a: 0x1c2704e418fe516b75f598895fan,
  b: -0x70f35b2508n,
  r: -0x20a2532006n
}, {
  a: 0x29413dcd9989d98bd38d8887532c3212n,
  b: 0xd6f423f005befa670067199229f631e05943eecfde9c1a15e32n,
  r: 0xd6f423f005befa6700679d93fdffb9fdd9fffedfdefd3ad7e32n
}, {
  a: 0x33ca09724fe0007b743512582b54a7ffc0080c5f4cc5bd10fdb33567c5n,
  b: -0xf36909c68f85d26365f9255463154eb2e807acbbc7ca0n,
  r: -0xf04808868a05422100012554220102a0280024888181bn
}, {
  a: 0xb6b8e6c37ea13f32f737632b23646a8d46308a3n,
  b: 0x7b4f67acn,
  r: 0xb6b8e6c37ea13f32f737632b23646a8ff6f6fafn
}, {
  a: -0x404aa1c7d6206ce81n,
  b: -0xc40ec6790fc18dd02893fdc993695bn,
  r: -0x40028107d40024801n
}, {
  a: -0x83283961c7ec1c145cece3b8cd7ffa221539n,
  b: 0xd8d1f547b408c7812f23f2a338692a39c990cd728d1160e22n,
  r: -0x83280940c5cc18045c6062b008572a201119n
}, {
  a: 0x50ceb51ab14c77815d7b85021n,
  b: 0xcf86014a9d42n,
  r: 0x50ceb51ab14c7ff97d7fadd63n
}, {
  a: 0xc062120d4a6b88a97f4a8aa32c4165d78b3952325d2350aac4dc656f3b3n,
  b: 0xf6aa4df1n,
  r: 0xc062120d4a6b88a97f4a8aa32c4165d78b3952325d2350aac4df6fefff3n
}, {
  a: 0x157a0a3059bec3eb7d0bfe3c97505ee2667n,
  b: 0x8f39e1609c2ddb63d31741c80d33fn,
  r: 0x157a0abf79ffe3ff7ddbffff9751deef77fn
}, {
  a: 0x440eced4acf9d2ef39n,
  b: -0x2274d4873c14320adf70c1991e437db16c6828fb36601551d1e7e1ab9763n,
  r: -0x2274d4873c14320adf70c1991e437db16c6828fb36201111014300291043n
}, {
  a: -0x7e9a476bc40588a86100cd2955974449ec32364n,
  b: -0x9624faf8bf4184f73b307n,
  r: -0x42850974000e432303n
}, {
  a: 0x69b73c5a83c076f82666a4d4157en,
  b: 0xb95d8f1f65f03c765fcf68238718c47d668c23037d8d457n,
  r: 0xb95d8f1f65f03c765fcffb73c7b8fc7f6f8e676b7dcd57fn
}, {
  a: 0xa738n,
  b: -0xd589951513415d5b39537f4bc290addb5202b377fa07e2039446e804b9cfn,
  r: -0xd589951513415d5b39537f4bc290addb5202b377fa07e2039446e80418c7n
}, {
  a: 0xf2132efd0b959d6c0ffbeda723065n,
  b: -0x724c4b76ca743634503d4d47n,
  r: -0x100c422608340000000d4d03n
}, {
  a: -0xc4258fb3bb9b9a91fde6d8bdec861284bb74b1d71ffc372d34d4n,
  b: -0x3cb84ba2dc66ca80e332f47aedb4fead9a243eb6ed5e715eafn,
  r: -0x248803a298028080e210b468841084a910201616ec16211483n
}, {
  a: -0x7057bba0a1350527f917281caa9ebe92a67429e74647dn,
  b: -0x836a876c10547cc3b1b4d4c4b90e198e30fa7n,
  r: -0x8120052410142800a0949480a004098600425n
}, {
  a: 0x4f2219dd14b4150622461a729ec914411b2874e23n,
  b: -0x4bc54b86fa31db6d7ce946dec52e0c0dbbn,
  r: -0xa840a8698119a485401469ac40c080199n
}, {
  a: 0x7b5968a8b3e9613a19a6b5d5442aabf240acec909e391b1219854d931f74e6n,
  b: -0xe30ef0an,
  r: -0xc208b0an
}, {
  a: 0x1cf887019f9e1cd29deee5cf2d3c113d8910f06c46eff8a76ef5ed42en,
  b: 0xef3747b51dn,
  r: 0x1cf887019f9e1cd29deee5cf2d3c113d8910f06c46eff8affff5ff53fn
}, {
  a: -0x380f38f3dd37ce2394218d68de362c0516n,
  b: -0x1a53ee2e95669d129n,
  r: -0x210c60c816280101n
}, {
  a: 0xce097abb2643c12a35279b13e8c4c7baen,
  b: -0xd6af5bb5b6c9d472d4866b0a70d3399c777918c0ec031734a8312ece392bf1n,
  r: -0xd6af5bb5b6c9d472d4866b0a70d3311c60500880c001142480000042310051n
}, {
  a: 0x3a11e9f4ba6102d43c33207f0472db9ffda3c4ab17fa272c0d0da578n,
  b: 0x873a9n,
  r: 0x3a11e9f4ba6102d43c33207f0472db9ffda3c4ab17fa272c0d0df7f9n
}, {
  a: 0x600b32e519fan,
  b: -0xd8e1d8b2707224c9ba88862n,
  r: -0xd8e1d8b2707024489088002n
}, {
  a: 0x26e283a8869d4852474c0669864341e2707360c8b5fcea40c50b9can,
  b: 0xd6f8079b84fde7c0d57778e703c98637fn,
  r: 0x26e283a8869d4852474c06fffe47dbe6fdf7e0ddf7fcef43cd8fbffn
}, {
  a: -0x3eec161690b6fd25456b3a8cn,
  b: -0xb446d19848329c0093a59720en,
  r: -0x46c10048020c0010049320an
}, {
  a: 0xd803fa8n,
  b: 0x7f9972637n,
  r: 0x7fd973fbfn
}, {
  a: 0xe97006cfdba7cd09147b66f7d1452353f93a7934373n,
  b: -0x7655f81fe65ca0c71bc53091n,
  r: -0x4010800ba448804418443081n
}, {
  a: -0xdb4a2f76968fbe8986e231dbdec18365b2bn,
  b: 0x17911ae948n,
  r: -0xdb4a2f76968fbe8986e231dbde808241223n
}, {
  a: 0x23d53eef58999e8e97c1501384b691f3daa633138730206n,
  b: 0x7550d55a226cf8159eea9010b259b5b3249b912en,
  r: 0x23d53eef5d9ddfaeb7cfd15beebf91fbffbf7b33cfb932en
}, {
  a: -0xb28a227b6cc9d9be8910e52c7e0338c0769ef45adn,
  b: -0x1d6219421c9e4583d34e3f415b73cf3d74ad89cf91bf3ce553abfdb0c60fdd41cc954n,
  r: -0x8208202908c991be080041287c0000005400c4101n
}, {
  a: 0x4bc7n,
  b: -0x42653e8b9d85db90879d78b7f6d37d6258df74672an,
  r: -0x42653e8b9d85db90879d78b7f6d37d6258df742429n
}, {
  a: 0x5dn,
  b: 0x3f31f11ebf0c078d25303280925ee007c90e91cbf828b8d9223a98c32d54bd912n,
  r: 0x3f31f11ebf0c078d25303280925ee007c90e91cbf828b8d9223a98c32d54bd95fn
}, {
  a: -0x492bbe540be8af3f0000f1002891c553aced4513aa674eb5034n,
  b: -0xad1d37dd285e7a0a287f17cf085e4c6418cff9eed228fdd7a1e61cn,
  r: -0x4129920403a0a2070000f00020804100ac8c45028a454a14014n
}, {
  a: 0xc96b60c023c0n,
  b: -0x9f34c374c3b811106a07dfedc70cacf3ad4e4b88f9d9b99bfn,
  r: -0x9f34c374c3b811106a07dfedc70cacf3ad4e430849d1b983fn
}, {
  a: 0xc9132508bde44c30d82677b89fa9809654dd593e7d1b42cc0ad0d3887de9n,
  b: -0xcdc5cee1431n,
  r: -0x40c0c660011n
}, {
  a: 0x54940f58da93cc943dd884d21407f0e4c68c3538n,
  b: 0x87e437c5bcf3d8393da4785491b7304dn,
  r: 0x54940f58dff7ffd5bdfbdcfb3da7f8f4d7bf357dn
}, {
  a: 0xf6ba959dd407bbe33fn,
  b: -0x18642be37d58ab9d7be2aff4b900cebf54d9c6e72cf8f64c32n,
  r: -0x18642be37d58ab9d7be2aff4b900cebf0041426228f8440c01n
}, {
  a: -0x139236d651017e3568n,
  b: 0n,
  r: -0x139236d651017e3568n
}, {
  a: -0xde2a313ad18a858db9e848466f41ae5e65ddd693ae33e306d1012n,
  b: 0n,
  r: -0xde2a313ad18a858db9e848466f41ae5e65ddd693ae33e306d1012n
}, {
  a: 0x33c81572d92631a8df25acddd4bfc9573df936aedn,
  b: -0x56ead5874187e66dcc2464146feca6a80a34336a8fb57b60n,
  r: -0x56ead5844106a0404c0464100da422200000220800241113n
}, {
  a: -0x3fb448164bfen,
  b: 0x2786eafeaff6d9n,
  r: -0x391400100925n
}, {
  a: 0x812f698792c6f02b2797b5db4d2582a884n,
  b: -0x373c74fc3fcb985fdc09bn,
  r: -0x350c0484224b0807d401bn
}, {
  a: -0x14f1n,
  b: -0x5f6n,
  r: -0x4f1n
}, {
  a: 0x31699d25d7559e9c57cf7a7n,
  b: -0x995741a76083c162en,
  r: -0x98000021608000009n
}, {
  a: 0x161333a06fb3a86c1fd3ca144208b1d89bfda5n,
  b: 0x1510b9fc15576381c0cb7a7092f6c81dd20b03c26e77a8a2cn,
  r: 0x1510b9fc155763b3facffb7a96f7fd3df34f23cb7fffbffadn
}, {
  a: -0x8801aa36b75802307cbn,
  b: 0xb90be0870bb983ee25b8dc3df4ee8493e32e7edee170a0en,
  r: -0x8000810810002005c1n
}, {
  a: -0xben,
  b: 0x50480d2bn,
  r: -0x95n
}, {
  a: 0xc8e76886f8361cbff3fe965eeb8dce1f70fee7b818178f769n,
  b: 0xfb9153cb9d007aa5fcacdean,
  r: 0xc8e76886f8361cbff3fe965eebffdf5ffbffe7fabdffaffebn
}, {
  a: -0x514d62aea497e6b1b80ea852b2c02n,
  b: -0x7c53495b43cde4ea69a265905d2f5c37n,
  r: -0x1005202c8406a69020080052b0c01n
}, {
  a: 0xaba813c94d8d424a06501960095ef98d990ab356316aeffb52e4c6d772e087e69n,
  b: -0x387fda00cd0c67377e301b62fa4f5d3n,
  r: -0x304c8800850004251a3008001a48193n
}, {
  a: -0xe1dc575fe7aacn,
  b: -0xb8993f28fb3n,
  r: -0x98111f20aa3n
}, {
  a: -0xec3eeb5bdf6d5e71db3b736efb81af29f3eb164a00f0d92c0c1343dn,
  b: 0x4ffc991800ed0f8ae133a14ad3e769f2239b66829c052d00bc6n,
  r: -0xec3ea00346655e10d031124c5a812c0892091440007041280013439n
}, {
  a: -0xf7fc92d6a261329a98c9654b269d15a95cd05f9b12n,
  b: -0x5078cdc83319e42528f9d2ab70b3f64c25ae6b05466e35n,
  r: -0xc5c81210a021209890896003260c05a84800460a11n
}, {
  a: -0xca9382545a2b9e837e67d5ded046c43901780c1cden,
  b: 0x7d083aced968092d34d5081aa8c5993606dn,
  r: -0xca9382500a2812026867450c9006441101200c1c91n
}, {
  a: -0xaf101653ad204n,
  b: 0x55d7cfb33a166n,
  r: -0xaa00104085202n
}, {
  a: 0xb710cb18b1e1dc5008ca385703bee30aabc9dc44ceb3c6c77an,
  b: -0x2ac7c50ad71dc4b4e99af5f8b3776c5bc07e10f616e08c38640b0410007dn,
  r: -0x2ac7c50ad708c434e10a1420a3772443807c001414400420200104100005n
}, {
  a: 0xc2bfac538f2d2bc9248486fa0fe5n,
  b: 0xe740bc816563d57189199d90784cfc8a5d6de27cd609e99592f0e4f9bf1ef9n,
  r: 0xe740bc816563d57189199d90784cfc8a5deffffcd78fedbfdbf4e4ffff1ffdn
}, {
  a: 0xe36e5304c1e91ae587d901beca3ff74f8ac006800cfa8bb664ff46004f2b397n,
  b: 0xb37a1c2abdefb99ca41a89dcb8afd5fb659d04980bb5c38d34a8dc3793a05595n,
  r: 0xbf7efd3afdffb9befc7f99dffcaffffffdbd04f80bffebbf76effc7797f2f797n
}, {
  a: 0xad7e3b32381c7c98666091dc5686a73f10ab2d25909fe948ffcdn,
  b: 0x697fcf3e6494192d985d7fbbbbf1fbn,
  r: 0xad7e3b32381c7c98666091fd7fcfbf7f94bb2dbdddfffbfbffffn
}, {
  a: -0xc7n,
  b: 0x6a408fa31f9c1a21a7676195cc20f54d6n,
  r: -0x1n
}, {
  a: -0x66n,
  b: -0xb38f003f75f928ea2f2adc21a2034048b59e8n,
  r: -0x66n
}, {
  a: 0x49506f7ffd4abaf69d70ce6c839122e89e8cfc39b5d1a73cf02dn,
  b: 0x49e5f93c5n,
  r: 0x49506f7ffd4abaf69d70ce6c839122e89e8cfc39b5d5bf7ff3edn
}, {
  a: 0xfcbfd9b413bb5281004330168b2eb348541aebfe1937fa3b1bfd9cb7n,
  b: 0x4ae7ad10fdb1dcb02fc95313ecb6f36108753a4734fn,
  r: 0xfcbfd9b413bb56af7ad33fdf9fefb3fcd53bffff7f37fabf5bfdffffn
}, {
  a: -0x330aa314251132e206841d4b886adf8279021af39d475a2c3310b6a0n,
  b: -0xb03d259430e9924cecn,
  r: -0xb01d0510202110048cn
}, {
  a: 0x92c5994337a8a392c059402ff5deb0f6057a56f96d207df5d95cab3825ec68n,
  b: -0xe85f3a8f07d9d2a3331ee757f7bcef32en,
  r: -0xe01f280a004900a020026215443ca1306n
}, {
  a: -0xf245d340e1e2195efcb9be0413849e9d0e1571a53f4a3d71225a0f149ed2d6af957e9n,
  b: -0x1d62cec9fbd78f9d6652c662be6d8932514bbcbbbada8dcfc343ba392fbaen,
  r: -0x1620848f8918e04020086000e050120114a3c31225a0d0482429229053a9n
}, {
  a: -0xead21e4cb4n,
  b: -0x754d49789d5eac63c17e0c5391e85cee7d05ef821a3527010c1n,
  r: -0xa252100081n
}, {
  a: -0x9ffc49291f22e33ba6460d9301c232729c5f5d72994an,
  b: 0x5fe7c60cd3e3bc3f09afen,
  r: -0x9ffc49291f22e33ba6460d920182123280441c020102n
}, {
  a: 0x726ececfe8ccfa46032ca6626bb50191f2b128n,
  b: 0x8be4ab019743065b72fd0f05e9b972f3c871657443c193b693acc30dn,
  r: 0x8be4ab019743065b72ff6fcfeff9fefbce736df663ebb7b793fef32dn
}, {
  a: -0xbc73070ed317b86be0dce3e771c060dc6en,
  b: -0x2b1b4557fc71d82863ab184828a73fd105c964a1800fe8714b3571615a4917ae2e8an,
  r: -0x886001000300304b205061424100200c0an
}, {
  a: -0x3d9cd16b1n,
  b: 0xb751ac3677ec32a744f2798362eeba7b3507ab330fcb090c7dab580aaca5n,
  r: -0x81c51211n
}, {
  a: -0x15002247ff8a898970a2c7f6691aa5b044e7e4be11e1a46f5d160ea34a659e2a95en,
  b: 0x39862c0a380b0e7569dbdd78f280a5713n,
  r: -0x15002247ff8a898970a2c7f6691aa5b044c6609211c1a4610816042202051e0a84dn
}, {
  a: 0xd9n,
  b: -0xb1e9064e6c6394b1922ecf07dd923d5806ff43139fa02da2284a7df55163e2169n,
  r: -0xb1e9064e6c6394b1922ecf07dd923d5806ff43139fa02da2284a7df55163e2121n
}, {
  a: 0xb7b21c4a468e2c7b8ec64c041cdef402fn,
  b: 0x1dc372d4f65eb32f6a7d326e7f1a2762e8ce9288e577fec13319080130869n,
  r: 0x1dc372d4f65eb32f6a7d326e7f1ab7f2fcced68eed7ffec77f1d1cdff486fn
}, {
  a: -0xd89473b2bn,
  b: -0xf7bd4abaee10c76d17600bf00dc5d23b159949c2e64n,
  r: -0x980042a23n
}, {
  a: -0x279131783b2c3ce7c553d015ed5e2d6n,
  b: -0x684c2ccee8an,
  r: -0x40042c4e282n
}, {
  a: -0xa44e2230bd3ee4a2c572f4778af05d6a4357c4f9f7c53352019e493f4a12d331847n,
  b: 0xf34a08feea1973b4d880fd8f2b200b43bn,
  r: -0xa44e2230bd3ee4a2c572f4778af05d6a430484f101052200010649024010d330845n
}, {
  a: 0xcf9c863f7762083edacae3ff257a6c8093ae5fc2dcfac5f3881bff5af5ben,
  b: -0x6393c1121690bd1f68faa62dc7c713349f37f64e42b95232fbebe1eef282332n,
  r: -0x639300121400891f68120201c00500101736c40a02901012a0c360400200202n
}, {
  a: -0x70e886cn,
  b: 0x36c87509a5c2e12adac43d7n,
  r: -0x2028829n
}, {
  a: -0xcadb8478eccf5727c22d2f56e86a5a1f31f3bde56fa04acn,
  b: -0x3945f258d6cf1n,
  r: -0x3105e048804a1n
}, {
  a: 0xe48ae49c76fb0af0ae6f910c6327b9546958cbb599b30514n,
  b: -0x8391002b07fe16ffe111ffaf1d0350b0d1fd6137acfd30dca66a5en,
  r: -0x8391000b051a028900110f0110025090d0442116a4340044046a4an
}, {
  a: -0x15fc322d7n,
  b: -0xee7926659ca7e9fa100fd708715f248n,
  r: -0x7012247n
}, {
  a: 0xa2a490e22b3f22b05c4fn,
  b: -0x9f172daede11b008a4c7911beb8be77ec69bn,
  r: -0x9f172daede11b00804430119c080c54e8291n
}, {
  a: 0x88550b7b06950d996db06d8bd817496855b563991c5fn,
  b: -0x245e628229718875dc915ca17ac413c4a42121894f2576b624362e64111700n,
  r: -0x245e628229718875dc1108a000c002c024000180442560b604220a040002a1n
}, {
  a: 0xa96981a8e2n,
  b: 0xc2042ba9f3740732adfcfn,
  r: 0xc2042ba9f37e97babffefn
}, {
  a: -0xb85855a4eec17632a1e87df0234ef99d1664dbce2ca7e3e1088c2f31e583d02cbcn,
  b: 0x80c32a01d663986d614e979d471ce1367126beebc66085da672de598660e246c1e5bn,
  r: -0x385054208c411212a16860b0230ec98c104010080c22218000082711e1839020a1n
}, {
  a: 0x4dbbfa25dcf30056c2beee4290210d0d1211687c6284c081da95n,
  b: 0x52fcbafe2b7d7076973145119a0ec946e55n,
  r: 0x4dbbfa25dcf30056c7bfefeff2b7df0f7b737c7d7ba4ec95fed5n
}, {
  a: -0x58d32806f9ae9244cn,
  b: 0x89a3c4ec3ffe983404a7559c6d87b76647dn,
  r: -0x58822002780890003n
}, {
  a: 0xbaf73fd19cbf88510cf3c983816301cfdn,
  b: -0x70a0afdbd8d0b60e32eb2841df536n,
  r: -0x402023405080b20c32682800de101n
}, {
  a: -0x30940n,
  b: 0x8d124b54077b8b5ed9edcb94da62b2n,
  r: -0x1090en
}, {
  a: 0x5e599221117b1e04f6ef85a1332164d3df89387c8c1716b90603effbc5cn,
  b: -0xb695736532afa12060af19f7f4c18d5402ac86a3f0b43061f0115e1780df7b9df04dn,
  r: -0xb6957365320a200060a80817b0810504008c80a2c004206030100e14009f41004001n
}, {
  a: -0xd93e0ed672b9b842ce337bn,
  b: -0x4004e6fe0bd7d476362n,
  r: -0x4004662a0b840462361n
}, {
  a: -0x668f1a743dfn,
  b: -0xcee9b1597def4208c3bd554c5901c9daecc33dn,
  r: -0x48d0a4431dn
}, {
  a: 0xcn,
  b: 0xe4ee0d244428f4c0b926dn,
  r: 0xe4ee0d244428f4c0b926dn
}, {
  a: -0x9926fce8a945ac911173c003acb22606ac069938n,
  b: -0x9efan,
  r: -0x9832n
}, {
  a: -0xa41abda069ac3f83471330286f5e9d123bcc2fbe8597392378987cf766b9259b2cfn,
  b: 0x7bbc90dd803fa961efd353185cae8f175797501665a362a8be9d0211ba4ea74a4n,
  r: -0xa4000120202c00020610202867021110288828ae81921801500060f56601211824bn
}, {
  a: -0x70b65df4e83b8aaf5ef0317aaea0e97e84cc7cb856a10136294eab9a4f99e6e7c2n,
  b: 0n,
  r: -0x70b65df4e83b8aaf5ef0317aaea0e97e84cc7cb856a10136294eab9a4f99e6e7c2n
}, {
  a: 0x61c2ddfe27399167a8593f1869acn,
  b: 0xa562d0c1e3aed4e46b8c20f040fd4476b67a9337f97f24b2b0c1670e414b1e427cn,
  r: 0xa562d0c1e3aed4e46b8c20f040fd4476b67a9377fbfffeb7b9d167ae597f1e6bfcn
}, {
  a: -0x441512bb0357c76a785017b4676f7f3de09916cd9a292fbd46ae1c457034a5f7n,
  b: -0x6a6241f0909f0413bb3e28b5f0332033f61960f81d05358b0e2cc1f07c710c5b4b2n,
  r: -0x4150009004103226000170022033f21800900c0120820a0440e04451004a4b1n
}, {
  a: -0x819d320f878d4a6a9ffde85eff513f01212dc1f74ba811d1805c34db4b813ff753n,
  b: 0xd19a6a84fd55d81cfa50dn,
  r: -0x819d320f878d4a6a9ffde85eff513f01212dc1f74ba810c00054300a0200305253n
}, {
  a: -0x9e689aef5b923e1n,
  b: 0xb57ee544753f76608108cn,
  r: -0x9a0880891b12361n
}, {
  a: -0x47b7e4079dd9d202009371ca856a43f65c0315e2accc0e2n,
  b: 0x8bf7e4b4ebfc10c45180556b97ea478fc1aff6ef458b2n,
  r: -0x47340003091002020082718a846801b0500210000088042n
}, {
  a: -0xe36345e0fbfc88577d71b6aee7f1136464bcfn,
  b: 0x6fb65d6232ce57c1c50f82a61b3e1d3b4718d3e71bn,
  r: -0x2140410083e088075510040e24410260408c5n
}, {
  a: 0xf1f85cffd3b108b17d83a623f1797c5be4d5f985222a12fn,
  b: 0xf0de949ce1db63dae2649122fe2b78a27c93c39635988fan,
  r: 0xf1fedcfff3fb6bfbffe7b723ff7b7cfbfcd7fb9737ba9ffn
}, {
  a: 0xc415601737e1529ddce5ab913e0bfeae8n,
  b: 0x6977d626031n,
  r: 0xc415601737e1529ddce5abf97fdffeaf9n
}, {
  a: -0xd61c9c355cc864be871f8138624e4a5649de69eb23279d166e77n,
  b: 0xcb0207e3db1e7c6127d0318683b59156cb806080e1109b6be84eace6c77439bdn,
  r: -0x821c98254c48640a06090038024e0a46409401a1030118024643n
}, {
  a: -0xef43219688e00b4c8bf09438f3273328aa818772c8be553955a970f3e20bfa719e8ean,
  b: -0xc7c16c602c17c31015eb2343ad25bbdc1858d069b9665f9n,
  r: -0xc124202802810010c822412905a9501040006831060e9n
}, {
  a: -0x1048ac7a26db7e504544f2bd1a172b2bf96af2eb6d9f09n,
  b: -0x82c95efd727e7059a6b2308b42bf53c3n,
  r: -0x4144f0301a100922b02082422d1301n
}, {
  a: 0x8eea913cf0993f14fc078f6f55b4an,
  b: -0x8be2a0f2126ea5a158553b2ac6868a85069ddfdef37n,
  r: -0x8be2a0f2126ea5211044030a46808a010010908a435n
}, {
  a: 0x254655e93803c1c602b5bb779dbb97cf994e7e18277af87n,
  b: 0xe64b780dd6be369n,
  r: 0x254655e93803c1c602b5bb779dbb97cfff4f7e1df7fefefn
}, {
  a: 0x439f23b2966d1f77547n,
  b: -0x9769b7a12c20fbb96fae038n,
  r: -0x9769b4200c0069906088031n
}, {
  a: -0xa41d6dn,
  b: 0xa380d8a454c75n,
  r: -0xa01109n
}, {
  a: 0x91de1c27f0fef67232c1111d83bf932n,
  b: 0x673868196986f1d97830b8b02b7b39a993n,
  r: 0x67397df9ebffffff7f33bcb13bfb3bf9b3n
}, {
  a: -0x9caeb8bffdb5bcafac0f749a8df1a3790405n,
  b: -0x5782938431d735aeea6b504c5n,
  r: -0x538292803141208e0a2310405n
}, {
  a: -0xf1a0c2dad0644636258f31e22794b30n,
  b: -0x18c97994b1dbbbb4ba2abaf0b8592bcb18913086acf9cfe106958ea6e436805859n,
  r: -0x110042ca90640020008a20422004809n
}, {
  a: 0xe65ec14cee300cfb8f14380d9b33e30bb1d7148n,
  b: 0xf973769be39002e536135f4e45b1b557bc4793258e2fa1951128en,
  r: 0xf973769be39002e77ed35fee75bdffdfbc7f9fbfbfefabb5d73cen
}, {
  a: 0xb20c4b7f3bb3329a6e24f6137n,
  b: -0xaa8446be0af69b36be77fc04bdf0c119f7760c6f67de555475fdc5ef5a66a53n,
  r: -0xaa8446be0af69b36be77fc04bdf0c119f7760c4d6394004444cd45815a00a41n
}, {
  a: -0xb8bd187425690444e7f204ef19851f77f8d922b3fc6ec334995db4b07bd5en,
  b: 0x4a712c08b3be0f31ef00daf92n,
  r: -0xb8bd187425690444e7f204ef19851f77f8d92082d0664000904c10b02104en
}, {
  a: -0xeb8bf2e243ef99b94dc728d9562189cc4d1fcb6de10ca5n,
  b: 0x6fe618bdae4bb0n,
  r: -0xeb8bf2e243ef99b94dc728d9562189cc0019c340410405n
}, {
  a: -0x925b77863cn,
  b: 0x52880f1e385f6c96cfdeaf1945fc4b6fcn,
  r: -0x200330004n
}, {
  a: -0xafad1492bd782bdef4c3bd644eb608b581c342b2ccben,
  b: 0x31n,
  r: -0xafad1492bd782bdef4c3bd644eb608b581c342b2cc8dn
}, {
  a: 0xdc183b75bn,
  b: -0x65cbd72e167bd12a7n,
  r: -0x65cbd72e0263c00a5n
}, {
  a: 0xde7ded91bb2d72f365ab404fbb9ee5baca1974501a7e68b72b23b47d1f557e41n,
  b: -0x973c98fb6b717b53e8ea202fc5bc58a0220a40a3d289a297f744724528ea18adn,
  r: -0x100106a405009008840202044201800200200a3c0818200d444420020aa00adn
}, {
  a: -0xdad981dae960fc59684df0f1a60350f6a0f4f96080607bn,
  b: -0xa4e38fce13b0a04b65686f04eddn,
  r: -0x84030a401100200b45000804059n
}, {
  a: 0x514e95fe6efcb31d13855c7b6385330eb70bc654d5d9een,
  b: 0x4836693e86bcfb5616214d166a8c4e6bc5346189c4e1b895a416bb3af3e55fb1n,
  r: 0x4836693e86bcfb5616714f97feeefefbdd37e5ddffe3bdb7aeb7bbfef7f5dfffn
}, {
  a: 0xf3ca8fd1069b278f6337d6489f9254d801b60e995290454da6f0fb9d25an,
  b: 0x9914ddd69ffn,
  r: 0xf3ca8fd1069b278f6337d6489f9254d801b60e995290454dbff4ffdfbffn
}, {
  a: 0x28b69ba3b353a1e40bf488f901c9c19b4c6616ccef3fa12n,
  b: 0x3a75025e8ee56618d20da1f1n,
  r: 0x28b69ba3b353a1e40bf488fba7d9e5fbee7677cdefffbf3n
}, {
  a: 0xca172edfd6281e04690b84d20ba16c1181b7efdbb979bb3154787c62ab6741f9954c06n,
  b: -0x685d51b8e4f51a0bfc4c2f9f97n,
  r: -0x404c018080951008bc042a9391n
}, {
  a: 0x82d53e7d63f20537bcb0e41bfa84a33f6e921n,
  b: 0x9db1f49baab30bee93906d49900eb5cf4858n,
  r: 0x8bdf3f7dfbfb35bffdb9e6dffb84eb7ffe979n
}, {
  a: -0x97582803bf30b1da2d2195ebcde7ff7dabbd41an,
  b: 0x16dcea9ba0f84d63558b38fn,
  r: -0x97582803bf30b1da292115604d07b21caa34411n
}, {
  a: 0x50399766d2bfe4d8f585f6f6fe880ddf1a0f7fdc025519eb6cc555619n,
  b: 0xc4bf4b1874f960e333n,
  r: 0x50399766d2bfe4d8f585f6f6fe880ddf1a0f7fdc4bf5b9ef6fd75f73bn
}, {
  a: 0xb43341420259c20e4n,
  b: -0x33a60058c576f163eaacc61189n,
  r: -0x33a60058c434c163ca88421109n
}, {
  a: 0x7f88b6085990d840b7afbbb5f0857f17a9af8f9cfbn,
  b: -0x89b8417a7685655a429cd83b2n,
  r: -0x8100402076800400400400301n
}, {
  a: 0xd19f7fd92e546c3bn,
  b: -0xff7bb31cdc9e2d3100b78f33400213n,
  r: -0xff7bb31cdc9e2d2000800611000201n
}, {
  a: 0x1443f7265c13db99c618aa4abe2f743n,
  b: -0xf854422dd228d12d279e6dae27n,
  r: -0x881002004220902503140d0825n
}, {
  a: 0xd98a2d6a2cdb1b5e09804632fb10c76en,
  b: -0xd6b1ffc115a4dc14e4a49d6408385566e553cb4501c215e798bae85a8e409n,
  r: -0xd6b1ffc115a4dc14e4a49d640838506645014900004215679898c04a82001n
}, {
  a: -0x7301d3d063c8392f8f76cced9131d80a8en,
  b: 0x7594cad221fdf7d60n,
  r: -0x7301d3d063c8392f88268040912000028en
}, {
  a: 0xc7af444309cd4d8afdn,
  b: 0x94628618bfb4a1a382b39c37c61c652269f3e658add782f8db907b016n,
  r: 0x94628618bfb4a1a382b39c37c61c652269f3e65cfff7c6f8dfd4fbaffn
}, {
  a: -0xd9b7cffc3c852cf8dd6bf9ddd73d835fn,
  b: -0xcfbad7f321c3d0a60ad32bd8fc301f4b4fdfd602f21c2dd40f7666ceabc68n,
  r: -0xd0b4cdfc200520c0dd40f14444288047n
}, {
  a: -0x2b71cc5629c1d327216a9e43c178b0f485b77b302da2d9851b336c34317ab932a826n,
  b: -0x644b7ef65c9efcbc568fcaf2046ca6b424e44ba168fn,
  r: -0x40b0e405816b000520d88500024820004a00320005n
}, {
  a: 0xce2548795e12b5162a6a6n,
  b: -0x8400b5801bed78d27c8e7778ecf3ac2n,
  r: -0x8400b5801b21589204806548e8d1842n
}, {
  a: -0x8a6cb7041d5fc3c6436f98614a16ff678ee9c6ed1cn,
  b: -0x6f5n,
  r: -0x411n
}, {
  a: -0xa9fddeeeaan,
  b: -0x2c8acfe08f6175c663c6bb211573e60bb253n,
  r: -0x21e40aa201n
}, {
  a: 0x3793988a9a01783ade92ff4e902c467320903edcb0beaad803e9636e2fdaee87de4dn,
  b: -0x57d16dbf78cebf6ee120de47a66bf1cd8ef9n,
  r: -0x5741412348401526e0009c018021114800b1n
}, {
  a: 0x66654e214f241bd9d049fa1b9095468cb6679056944d5fe9n,
  b: -0x3bedn,
  r: -0x2005n
}, {
  a: 0xdbd2dec43966f3137den,
  b: -0x3571197716cbbb3a7e967928c943ddc9b41f0c44c4dd41b24403508ae2a31en,
  r: -0x3571197716cbbb3a7e967928c943ddc9b41f0c44c4d0409200004080c28002n
}, {
  a: 0x3fd59d77e3455c0bde8d0513d45feb47ec44a0fdd206b44fd3352n,
  b: -0x9c9eee89ea481905c0dfc5a63f2db87n,
  r: -0x8c0aa000a8001905000dc102302c885n
}, {
  a: 0xa4an,
  b: 0x9fn,
  r: 0xadfn
}, {
  a: 0x7d1a4dc932e2263e287387fbbe8c0ca77965922bf0b04d3540cbee9242f0d1fe047n,
  b: -0xbde6a1e27adc492576d5ef5en,
  r: -0xb924a1e24014490072c00f19n
}, {
  a: -0x8521110c5395af6c521caec5cabn,
  b: -0x8794a87a12464a132f4f8aff0dcn,
  r: -0x8500000812040a00020c8ac508bn
}, {
  a: 0xa425c5c93f4dc2fb9959en,
  b: -0x3d1db701d4ccb60973a470be01e748n,
  r: -0x3d1db701d48ca20160002090006242n
}, {
  a: 0x9n,
  b: 0x934643f28fd700n,
  r: 0x934643f28fd709n
}, {
  a: 0x350f84a4b05n,
  b: -0x788a8a98fd4608dea3eb2bd44d8043cn,
  r: -0x788a8a98fd4608dea3eb0ad0490043bn
}, {
  a: -0xf3d5d47fc6294ad701d7507b164ef571c2d29b95dn,
  b: -0x5fb09n,
  r: -0x1b909n
}, {
  a: -0x171f5d2359f8da787b7f45d89a573230119329425e1c8b067b841n,
  b: 0xc0be7e9994468be8604f459d0213068d287n,
  r: -0x171f5d2359f8da787b3f41800243303011932002421c880072841n
}, {
  a: 0x52b9b6548393292f2ff99cb39f7d4630fac7b90e760b479f2aa9084be9fb7be5691n,
  b: -0x15563330fa0143f4021b19n,
  r: -0x40411207a014040000909n
}, {
  a: 0xd6c91beac0e3eb5a99a1n,
  b: 0x623e55b8d06b53496998c3f81930da1e215630d6f1fdc59bea7n,
  r: 0x623e55b8d06b53496998c3f81930da1f6dd7befefffff5bbfa7n
}, {
  a: 0x1d127071e89b1bb4fa9bf3b70debbc60e0n,
  b: 0xbd4919c341e2fc0n,
  r: 0x1d127071e89b1bb4fa9bf7b79dffbe6fe0n
}, {
  a: -0x685c6aa75713d47705eae6a2dcf00c30402cdb52330106f89daab490bc4aaa00981n,
  b: -0x5ba9332d216b457cdf012c50a0ae53dc8572a7ddde5977bf7b47afe13a444ecn,
  r: -0x4aa1130100630568c6000c500020400c81522301065815aa3000ac402a00081n
}, {
  a: -0xf345e9134a57dcbff79dfd5e9da5d707d222232e3750f13159e951d51n,
  b: -0xb060n,
  r: -0x1051n
}, {
  a: 0x52ae19279b29c0b931ffbf854n,
  b: -0xb54a991ca433410f867f924874eaab537n,
  r: -0xb54a991ca411400804561240440000523n
}, {
  a: -0x27f34a6c0944eeedf654fd7f9c1af9dea0ee2e78b63n,
  b: 0xfc5549f169250eeba5d0f47an,
  r: -0x27f34a6c0944eeedf650382b0008698e00442270b01n
}, {
  a: 0xecc73e4b7e8de245167d7e0503b44ffe287b489edd8d3b9e6n,
  b: 0xa33709c41b84c57e21de487818e4051n,
  r: 0xecc73e4b7e8de24516ff7f0dc7bfcfff7e7bdedefd9dff9f7n
}, {
  a: -0xf73fc03468798c72278e06bcedbb1abc30f0ed450ed2a8d73d9e5fc5ded60n,
  b: -0x4bf76bf14146c261d17f0ed41e686cb11afbc5db403eaed5a021a35657n,
  r: -0x4803428100460260c06b0ed0102840010ad040c9000c22d1a020014457n
}, {
  a: -0xea78ba75363f491c6d11259dca3c7n,
  b: -0xff1ae618a3614dc7af53e84e1n,
  r: -0xba10261801004d012511c80c1n
}, {
  a: 0xc898cda28c2fc27f4996aad9b977c4c244303af04n,
  b: -0x464cccdc804d212aa25n,
  r: -0x644881800090100021n
}, {
  a: 0xbda2fa2c16dfef74a9n,
  b: -0x68a47ef8d1a4bd494d89ab29d38f0961cd17e98a245n,
  r: -0x68a47ef8d1a4bd494d89ab29d00500410c120108245n
}, {
  a: -0xad9d02ac434328870d8aa70922919a2577ebfb3bbd6acffbf86b8d01aded8b7n,
  b: 0xed4b6078c64c22can,
  r: -0xad9d02ac434328870d8aa70922919a2577ebfb3bbd6acff128498801892d835n
}, {
  a: 0x161c81n,
  b: -0x44cc26en,
  r: -0x448c26dn
}, {
  a: -0xc84n,
  b: -0xc21b17afff7d51b1187c18595645b45b9f1930218ed030b044c0n,
  r: -0x484n
}, {
  a: 0x811f113b547b2f5dd02cdn,
  b: -0xaa3ea95c05ce9029f985384881cc900ee2ca1n,
  r: -0xaa3ea95c05ce9029788028408184900222c21n
}, {
  a: -0x83281bbb8ec7829aaad29dd3bdfd09fn,
  b: 0x3e7168dc8d4fdeeb374ec790c0b1n,
  r: -0x832818a9020702020040891384f100fn
}, {
  a: -0x88b33ded80ececd3d1ed1489b96438en,
  b: 0xd32f22n,
  r: -0x88b33ded80ececd3d1ed1489b04408en
}, {
  a: -0x17d28b3b0266b1492c560dn,
  b: -0x256ffc7d610fab51c81718dabce82e3d633f1fdc97953n,
  r: -0x3c282230222b149085001n
}, {
  a: 0xff0014f141977e6a82d96adbeff4c2c0a4b862fa6897c28633n,
  b: 0xdc796ca45180b6312d2a6bbc4n,
  r: 0xff0014f141977e6a82d96adbeff7d6cae5b86bfb7ad7e6bff7n
}, {
  a: 0xfc0b1c1889df3b7927edd2d99a6ee7a82154d5832d5b02d5150f86f121n,
  b: 0x6d521d0c8f98115866819ac5cc12n,
  r: 0xfc0b1c1889df3b7927edd2d99a6ee7ed735ddd8fbd5b5af7959fc7fd33n
}, {
  a: -0xf61144ac04ba4d0ad81ce642a9n,
  b: -0x11dae98d7f75ce217cae8252e72n,
  r: -0x1400008404184002c808240221n
}, {
  a: -0x1c00e3c2b587e9b4a6e0d1377713bcf27eaa6496fb55ad52f6566e162580548n,
  b: -0x6f00e5e82be3n,
  r: -0x660060480143n
}, {
  a: -0x5df92674f9d91846ee3bc3145f0cd4337c800bce4355ddc584bb395eede16592ffn,
  b: 0xf34804a41d3cf31026b445c14df315n,
  r: -0x5df92674f9d91846ee3bc3145f0cd4337c8008864351c0c104ab194aa8202000ebn
}, {
  a: 0x87355396d9b78f79b0cdf7c6b9fb84f63631bbd3bb886f6ae43439bf609n,
  b: 0x711e0a49aa584142872d6474818f5a2b2b42f0cdee9122c16a4d4e00e100d9n,
  r: 0x711e7b5dbb7ddb7af7bf6cfffdefdfbb6f63f3dfffbbbac7feef4f43fbf6d9n
}, {
  a: -0xb9dd3789db02ec923e9987ace984aea9fn,
  b: 0x59b485eaaeb57b5cbfe307da009048888335fbc5en,
  r: -0x114804814000e8003e098724688004281n
}, {
  a: 0xd347bfa9738e5db4132ae23e7e6n,
  b: -0x94a368a4fe0ebe78a88aa89f58n,
  r: -0x80800020c60a24388800881812n
}, {
  a: -0x633a00a331n,
  b: -0xed2367ce96932ccn,
  r: -0x6028002201n
}, {
  a: 0x47bcda2n,
  b: 0xec4aae8fb36ff111416fb1n,
  r: 0xec4aae8fb36ff1157befb3n
}, {
  a: 0xe16c01e3cd3bc945n,
  b: -0xbbb8455377d41055fc06ec98f5c69a81eea695167bac0618cf81n,
  r: -0xbbb8455377d41055fc06ec98f5c69a81eea614127a0c02000681n
}, {
  a: -0xef40e04cf00a526471a31bff9e4f35157b2f1e11e31153fe94bccb3b83d2f060d1cn,
  b: 0x7dfe2ad4bb54380c1fac6b1581b7eeda77ef9a9b1d76025173e6c9abfd098ccd43n,
  r: -0xe8000040b00a10643001194e8644011058010610420013da8080832100026020019n
}, {
  a: -0x2d7aff2226cae5552n,
  b: 0x5a2110505b0e056a017d29b536d309d99634fb4c21d5ad6d00f1278bfd530013f48n,
  r: -0xc58740224cae4012n
}, {
  a: -0xa3b46a94fdea592d7f8979b9d2bd06dn,
  b: -0xb110n,
  r: -0x900dn
}, {
  a: 0x2207848c75943cccc2faaf2cc58cc0c09013f3ae18f25a6cn,
  b: -0x35cd64d0f6aeb2bc6329a0b2f8c855e762e4dad4101cbf971b7191e835e1bded4n,
  r: -0x35cd64d0f6aeb2bc610980b23880142322c0500410043393127080c0146098494n
}, {
  a: 0xa84052b67d7bec695a1d4640d01447e5b7949faf2d2fce69c351e77fan,
  b: 0xc4e2fe1df0418c3fd480264e413d621b66ff08n,
  r: 0xa84052b67d7bec695a1d4e6ff1df47fdf7fddfaf6defdfffe3f7efffan
}, {
  a: 0x14560ac2b4e636533007c282fcn,
  b: -0x57abbdc37387470fen,
  r: -0x118898c0738347002n
}, {
  a: 0x74f421b5e45bfdd5eaaeaedaa7e3b99fb2b92n,
  b: -0x4a7938c44fb4c9751ec6430fn,
  r: -0x2211004021481440604400dn
}, {
  a: 0xc0b76b71e664b2b282cc33b2cf419cn,
  b: -0x1e6c943c765e5800b5cae76b396fadb4a520fd2eb4n,
  r: -0x1e6c943c765e1800948a010b094d2d308400302e24n
}, {
  a: 0x2a10e88e74f9565d7756bde0e7d3bcn,
  b: -0xf4aafd53759959c1a59ddada84faa7c45n,
  r: -0xf4a85c517518104080088a9000f082c41n
}, {
  a: -0xc57ebfe73631752f352acbbd6f833c4n,
  b: -0xe35da1e4756edn,
  r: -0x2249a164012c1n
}, {
  a: -0xbdceafa9013df6a32da9f7da29cn,
  b: 0xd2bb4b36c7eb8c9d06cf2133d8b443ace15858fb0c29395bbd2c84bc81e7ef7f7d2n,
  r: -0xb1c686a0001172032c08108000an
}, {
  a: 0x191be4b7d2f400f62209940050f1bf261c0631a5ac5f6eaac79c5487c420a9f06fn,
  b: -0x4a155462ac0f7112fd8cd69be7c38d8n,
  r: -0x80504220805510238848299e540891n
}, {
  a: -0x43ecdc1f7132df016def3aa5fa1fa8a0aa03e358930df036ed66b2149184n,
  b: -0x2225efa3d8ce758dc9dfdf6b02a42c722e70332acc50n,
  r: -0x20252aa1d80e20808803c348020420322c6032008004n
}, {
  a: 0x1db47b6c50749bfac77741479ae4694ce913f476a076cf9701383e762fc310n,
  b: -0x79b33ff6d7b68cd8b920ed5b733f06n,
  r: -0x10a00b8057800048b800c109503c06n
}, {
  a: -0x67f323fce4542ee9d6fb4d49cc94f82acd7525001n,
  b: -0x64042301a7990bf1b4853dn,
  r: -0x24040001078008d1100001n
}, {
  a: -0xa5a78f27e563bb91e20a86aa727e804e52b85f5e17n,
  b: -0x83112d349ddfcf772db18df746n,
  r: -0x82000420105e804600b00d5605n
}, {
  a: -0x824ef3be4601d6f4134a61118en,
  b: 0xa9f33b8cb26091228fd70787d7bb2d318998e75030438e5a00an,
  r: -0x804c20a6460182f41342001186n
}, {
  a: 0x4f07727a03ee467ab69955c676f4ce4507086dfd36599c60dae54129e66898e3n,
  b: 0x5472acceb601e3640c0e3aff2bd7597d6913451ad06c07378315d86471b68023363n,
  r: 0x5476fcffb7a1ffe46faf7bff7ff77f7ded53759edfff67bfc71dfe7473bee6abbe3n
}, {
  a: -0xaaa69f27be98d1aab4a7a6f4668fc362c7199ce636b572c1n,
  b: -0x68e2c2ee7f82a80df10dc74d0e0d145e19f242f636d8149ec84b3cabf0140fd7n,
  r: -0xa00487050e08100a10a202f426880002c0091ca2301402c1n
}, {
  a: -0xdd49e4c4b0472d6b7c25c1n,
  b: 0x85ef83d693c37cafe803bd2a2c7b43b13308e28bbf04f4fdfb931edf8c45f058eb7n,
  r: -0x900044c410072920782141n
}, {
  a: -0x4075488e89a679ecf37b97c209f228bba51e368n,
  b: 0xb0d1d4238292450ede90a038ee2fn,
  r: -0x4075488e89a470e0b14396c2091200b1a410141n
}, {
  a: 0xaf9632bcaf09ccf9d12007b3da8e8107a504217a8575n,
  b: -0xebbd889059db5f382abc2873d4e5939530d5537b7841n,
  r: -0x4029880050d213002a9c28400461129010d152017801n
}, {
  a: 0x3eae8634936d8n,
  b: 0x62f56bc43637dec872a3f3b231b9136858df48b61d9n,
  r: 0x62f56bc43637dec872a3f3b231b9137efedf7cb77d9n
}, {
  a: 0x83b037a8da6fdaa30a230fa8a4b3c2a4617ca3a4cb2a765ce66a68abd8n,
  b: -0xe44d640e3a574c8c02ba573e539310a45e327262056d1e2194b6e1508ed67db2n,
  r: -0xe44d640c0a40440400205434509010004c305202014c1a209480a11084965422n
}, {
  a: 0x4addfe8847e32af5d8710n,
  b: 0xce2d5baaf8adba164c38dc3d92b3c631c1en,
  r: 0xce2d5baaf8adba5eddfedc7ff3bbf7f9f1en
}, {
  a: -0x8669ed31ba5697fc63ed4541ea91777ec4982664267409bc2a35399ef237cef0n,
  b: 0x3a753927e44d4d417afb23ae8a9b34ed01575adfa35an,
  r: -0x8669ed31ba5697fc63ed4500c290133280980404045001240a103888a0204ca6n
}, {
  a: -0xe6a8b4563958c7bb936d7766ccbdca4f3d84e320ced2d1a4c117bn,
  b: -0xe80e8dad6e55b76a2c229db2da117610ea3936c24f694b0f87e78da22dn,
  r: -0xc280a4523000c229932d2106400c82032c04e20080d05020c0029n
}, {
  a: -0x8bb947a67b63916f7776905f0cc5a8ca1df99c33a723d0d92b61f1f3252e92n,
  b: 0x50bfb93bc9da45n,
  r: -0x8bb947a67b63916f7776905f0cc5a8ca1df99c33a723d0d92b4040c0242491n
}, {
  a: -0xa29bdn,
  b: -0xda45cd1e91ba449e3a7c28418fd5f8n,
  r: -0xa01b5n
}, {
  a: -0x45f2b9b3f94cea359187008e1b50n,
  b: -0xc177083dfaaf2f80c90d83985a8faa299322ba2b0c86e116bc9286n,
  r: -0x5a2299320082a048081008c1206n
}, {
  a: 0xc992d678ca514c84c8a8c22e9ffcf1ebf8n,
  b: -0x341b8ff2ae7cd9d4e4e55a89c38f471f82b2726533f645546067881a2dccn,
  r: -0x341b8ff2ae7cd9d4e4e55a89c306450982302221333645144060000a0404n
}, {
  a: 0xd8eb25c551e0a1dc64529100a0e8c3df572fa6494096234cdde414d76b8fn,
  b: 0x4cf38111ae9df2807f2c9b34f486an,
  r: 0xd8eb25c551e0a1dc64529100a0e8c3dfdf3fb75be9df2b4fffedb7df6befn
}, {
  a: -0xec999da467afa76f68667fn,
  b: -0xe7cfc12d12180c97f62c9d376d04bc1f489db672862cn,
  r: -0x240904a40708852660062bn
}, {
  a: 0x8655b680e0378cb8f1b4d1f23e9a4bcba5de95751131a4c29b6n,
  b: 0x2b134cc055de918b4bf41dbc826ab769890fdbe42545e52551dn,
  r: 0xaf57fec0f5ff9dbbfbf4ddfebefaffebaddfdff53575e5e7dbfn
}, {
  a: 0x807n,
  b: -0xe9a187722e218568d99d97203d02n,
  r: -0xe9a187722e218568d99d97203501n
}, {
  a: -0xdfa6c334fa5cb097dc3a86f89219c3bd8696847e721734f02da0n,
  b: 0x75ae7a54f1298c7d5b90957c2083397n,
  r: -0xdfa6c334fa5cb097dc3a80a0101880ad06100046720034f00c09n
}, {
  a: -0xaba107fb716eeb919n,
  b: -0xda55e1fc0e015bf8e020578e1535ef89e07af4be91d1bd3n,
  r: -0x89a002f03000c1911n
}, {
  a: 0x8e02d5c6bab4da2f5fabec0a98688e952a335405ee50bfa445ffef41en,
  b: -0x9dd30e5818a623fc19f1ebab3dce7cc9825306030n,
  r: -0x805002500086216811c0abaa118e4049820000022n
}, {
  a: -0x54b5416f078669de77e26aaa5feda147n,
  b: -0xde745618cc2n,
  r: -0x8a245618041n
}, {
  a: -0x58e5354dd6a22bcf37f0632680706621e90b77145e9fd0b244de80152af2777n,
  b: -0x1eef062a0ed760fd38d13672a3920fe1293n,
  r: -0x621000a0614409d1090045280100ae0213n
}, {
  a: -0x3eedf788faaa521814b207a8n,
  b: 0x24ff03afe7678n,
  r: -0x3eedf788faa8100804000188n
}, {
  a: 0xe2d7f2302ddc9c92a1f72d2bb715942463676a1ee1bn,
  b: -0x529abe90e48bc390cdc4bdd8c31a3a758cb55163n,
  r: -0x98bc002402c1808d0404888218384188141161n
}, {
  a: 0x623e33143fdb62eec0563a299d5e20c98ce04n,
  b: 0xde2f646n,
  r: 0x623e33143fdb62eec0563a299d5e20dfafe46n
}, {
  a: 0x900011580a21808c880449702e1458c2f3f9b796ddafbd38634bdn,
  b: 0x7481e65d48721533ef43cn,
  r: 0x900011580a21808c880449702e1458c2f7f9f7dfddffbd3bef4bdn
}, {
  a: -0x94a8n,
  b: 0xa695843f171823e6f32d155b9631b9b24d6b4eb4b760d224aea56fd9bc8n,
  r: -0x428n
}, {
  a: -0xa8168ea2d4ac754f50d7a8748067063dfb238856670e740d2n,
  b: 0x4f2a4b9n,
  r: -0xa8168ea2d4ac754f50d7a8748067063dfb238856670054041n
}, {
  a: 0x32b6n,
  b: -0xcb3cc7e86c0bcc37420c57f394bd86b4e8f25e749ccdn,
  r: -0xcb3cc7e86c0bcc37420c57f394bd86b4e8f25e748c49n
}, {
  a: 0x70n,
  b: -0xcce7dc73991918a2862b28ef2c875c738n,
  r: -0xcce7dc73991918a2862b28ef2c875c708n
}, {
  a: 0xe901044c092e7ea7d9bd86abdb78365eae6f6faaen,
  b: 0x71d8ca8ddn,
  r: 0xe901044c092e7ea7d9bd86abdb78365effffefaffn
}, {
  a: -0xe5614461b6bf671546d16652d9682n,
  b: -0xb7458792479ab05fn,
  r: -0x3144051245089001n
}, {
  a: 0x48da05f6n,
  b: 0x10fd644c652863af9ca61a029f8dde9f2bbcd2afaccaa1cf38b56130490fd840226n,
  r: 0x10fd644c652863af9ca61a029f8dde9f2bbcd2afaccaa1cf38b56130490fdde07f6n
}, {
  a: -0x78947c738cc04d60389n,
  b: -0x34d4b895eef1791cff6817c85244d1b0n,
  r: -0x108474010c800440189n
}, {
  a: -0x9bc0b0987fcda518ae58f2en,
  b: 0x17224c5e0n,
  r: -0x9bc0b0987fcda5088c10a0en
}, {
  a: -0x63be1d978759f09b1c3ab1148438698f08caea7541a13e28683f4f2553cen,
  b: 0xb6ba7c3e23ed73ba991188b919440ff43f59c0n,
  r: -0x63be1d978759f09b1c3ab1000400418c008840644021062028300b00020en
}, {
  a: 0x11833a2d4ea76c490770bn,
  b: -0xc3ae21cff59414f3cf33f700a6d250300fn,
  r: -0xc3ae21cff59414e3cc1123008012400005n
}, {
  a: 0xf3af02c491998d72a5d198e3797bf860a948b04n,
  b: 0xed76c8c255afe9605437c55f85aee458bd2bb8n,
  r: 0xffff6eccb5dbfff6a5d3fcf7f97bfe65abdabbcn
}, {
  a: 0xe401f261dcb181c8ff4e89d8bd0b90aaf2b8cf91600442cc8n,
  b: -0x1af02075a48302cc50b4e866db7186d4747c76f0cn,
  r: -0x24020350081020440b4684409410044147834304n
}, {
  a: -0x15cbd53dfb8d2ed79141a660004a0cfb7eee0bd970b272cbe8f0b398n,
  b: -0x269939c190c1fe142968fe86924bbcbcece0e8n,
  r: -0x8020000000fa142808d800924288a8e0a088n
}, {
  a: 0x64e8n,
  b: -0xfe39dbac00b3442d9bcd033b489cba809620b9857fc94337d2817718b833e9a8e127n,
  r: -0xfe39dbac00b3442d9bcd033b489cba809620b9857fc94337d2817718b833e9a88107n
}, {
  a: 0xe5f281b3cd72930f1f1aa34dd9c4357014dd48720f7n,
  b: 0xf776d4an,
  r: 0xe5f281b3cd72930f1f1aa34dd9c4357014ddff76dffn
}, {
  a: -0x9c043d7n,
  b: 0x99327c132da679e8df2111c3f5417aabd568764e5f319e8n,
  r: -0x8004217n
}, {
  a: 0x94a3385ffbff30en,
  b: 0xf5dfeb5f7827ac05e73be3fa32c91ac65807b3030039fe8987239b73an,
  r: 0xf5dfeb5f7827ac05e73be3fa32c91ac65807b30300bdffb9dffbff73en
}, {
  a: 0x67b44e464e6b06950fcaad41f1e5451271n,
  b: 0x58a6b6c600c1845099fa8f888d00e5eead371636fc1a71c3eaff0e6dfe95aef6n,
  r: 0x58a6b6c600c1845099fa8f888d00e5efbd7f567eff1ef5cfeaff4ffdffd5bef7n
}, {
  a: 0x804f68a473c662acb94n,
  b: 0xcac28n,
  r: 0x804f68a473c662eefbcn
}, {
  a: 0x75df338ebd48ea3f9359559e317480c27e2e5375514af9934e9e27c0e6d67a8e630an,
  b: 0n,
  r: 0x75df338ebd48ea3f9359559e317480c27e2e5375514af9934e9e27c0e6d67a8e630an
}, {
  a: -0x781f74ac98e9a250836917e5d4ee3a208bbd50c4212156c43a17450751e6ad8n,
  b: -0x9c3f7f550bc5df3c7bn,
  r: -0xc03215400451e2853n
}, {
  a: 0x78f02929d1a8e6035bd86aa4f9d555fac6fdcc7cb1n,
  b: -0x9722e5a3fa68d2507816357dfbban,
  r: -0x942025815a000200001000318309n
}, {
  a: -0x503dfac6fd7676cb41e8d7ce05395c74a932492n,
  b: -0xbe3c8a60c5e16edfbf9e7329bfe7421dfad5ef0e17a2761a60dd82n,
  r: -0x5039e2029976740141a856c001380460a000482n
}, {
  a: -0xe591750267e4dbe5713e8110e28d07098d88887783530919ab391ccn,
  b: -0x1fd28434ff39465fc923d784486672e06da629f25abc0cd2f6a33e962047b6ae9c002en,
  r: -0xe490350044844324001a0010208900090d08006102000908a90000an
}, {
  a: -0xbc1075cd95b15d2c0737fa390370c99d55c91c7c041ccb87a5e9a69347b8n,
  b: 0xcc865de5a9e12ab45c844e841572f0e72a8d8b4628f4a4n,
  r: -0xbc1075cd95b15d2001221a100250498151811868040c08852060a0930314n
}, {
  a: -0xab353be7ee4725534e12b963eeae3e2953ea5b5dc9f58fc38440e93c13b04e256n,
  b: 0x286aee1557f8af092547c48656c8e9cb3af7da2d324f053a7ae7a1fn,
  r: -0xab353be7ee4705114a000140e68a382951a8131400c508018040a038018008041n
}, {
  a: 0x372937d3a8b463n,
  b: -0x9e280bn,
  r: -0x160809n
}, {
  a: 0x2a73a4111b5e5a618113bb23fbaa0681347bcc4893db4bc1a045an,
  b: 0x4an,
  r: 0x2a73a4111b5e5a618113bb23fbaa0681347bcc4893db4bc1a045an
}, {
  a: 0n,
  b: 0x9d8bdc02af99ab36n,
  r: 0x9d8bdc02af99ab36n
}, {
  a: -0xad924baa1517065b3c344fcda6a6fa15ec2c0af93dc5f0fcf336c03119b9146n,
  b: -0x2eca828317c7b9d7b8351476ac6d1n,
  r: -0x2c0a800105c0b8d330001010a8041n
}, {
  a: -0x565dee701c88291829232cfdfebcec194c4c257f5a4ban,
  b: 0x76feafb84c6b9027fa5a43af7e356an,
  r: -0x565dee701c882918000104793804ec004848050818092n
}, {
  a: 0xa2f8eb42d7cc594d5n,
  b: -0x222ece67f14fn,
  r: -0x2028222610bn
}, {
  a: 0x6c130991de93dan,
  b: 0x28a4bef567e18c0f70895d9n,
  r: 0x28a4bef567e1bc9f7de97dbn
}, {
  a: -0x97edb22572352224e9c70d2885bb41b03a7eb078676b2e73a4n,
  b: 0xcce5f8c381e99c62912022f96b0ffc0f26c87d49ac1053fe876dfen,
  r: -0x72c320462152204c906042001b04130023610682401281202n
}, {
  a: -0xf38df710a23da02df5c718ef1e6b951ec25c6a1bda12f164b5b6e79ee6f47958604831n,
  b: 0x154c58b078a67bb4f4d6557a46935493bafe1n,
  r: -0xf38df710a23da02df5c718ef1e6b951ec2082a10d8109044b0b2828842944810404011n
}, {
  a: 0xb2b679ddecae2c08302d6c6513163b0dfcc76782eb4497ae6da6n,
  b: -0x937ba9ef95f9dc6f8363756159bb2n,
  r: -0x824a884f003188078143340119212n
}, {
  a: 0x480857be84c2n,
  b: 0x4dbb61de74e990cd25516722n,
  r: 0x4dbb61de74e9d8cd77ffe7e2n
}, {
  a: 0x71bc02efa8a060239a3c31d773813c5ad0fa0dd62a5eb2999229f7d9a7510d7e45n,
  b: -0x64d3a8d65ebd5bc5466fc8ed16c6ddf20715243adcb4d88f767b3327ce6f300n,
  r: -0x24d1005458bd4244046288c5040250f00700041a1494408d60022102ce280bbn
}, {
  a: 0x3b4da7e4a4625bd60eec60cc3cd0d7789fb91f4bd3df8a5f134b912904f7da198n,
  b: 0x35654033da36c1ec464facbdb8d6acb92c10cf3e6e3933d65196c51ead440b7ed386n,
  r: 0x3567f4fbfe7ec7edff6feeffbcd7edbd7f99ffbffebd3ffef5f7f5bfbfd44f7ff39en
}, {
  a: -0xf2ea88b053cb5b8b9e094n,
  b: 0xdd94dfb247c6ff057c64f0f985a9e2c5d060ad5n,
  r: -0x920a003052091a0b9e003n
}, {
  a: -0x20ec9b53a59ab76dd7e936f752041c137b96dff443a6b2n,
  b: -0xe3ca114be6ba38a8f85eb0cfbc918d2b0c6e4d2b901c8ee95931b46b1b9n,
  r: -0x8c8143049a8108d2a006e4520000006a94931042a0b1n
}, {
  a: -0x7c785731d31ae861483n,
  b: -0x2c6d320c17464614669badad7d35e7e3e55a5c94n,
  r: -0x58505310521a4021483n
}, {
  a: 0xd259cn,
  b: -0x200c099fef6dn,
  r: -0x200c0992ca61n
}, {
  a: -0x29db6392cd17dddf7ff81910c6d26411d5eecd281434f329bca2b74615263d0n,
  b: -0xd6e38d2db0317e9aa34402b2d51a6e0c7284d0d71b368e7256e245e6741f141a41a295n,
  r: -0x90303808814400b2d500000c600440151a24820042420082400b1400402285n
}, {
  a: -0x49569ec1c24f8e3a3aaa84b55d6f7a8c64051cn,
  b: 0xa12aa5e4e942bf2faa2eecf4a9efaa45061dd49bd107af401n,
  r: -0x4004044100008420000a84940026428c04011bn
}, {
  a: -0x93e0c1f95fb82f599710ca42960db35016d364an,
  b: 0x3132e6db9c08b7e1d46bad518fafn,
  r: -0x93e0c1f95fb82c5192000a408000b14002c3041n
}, {
  a: 0x1a6d449n,
  b: -0xd37e2e151fcc0df9d52853d7af4ef32fc1d30624n,
  r: -0xd37e2e151fcc0df9d52853d7af4ef32fc0510223n
}, {
  a: 0x71892eab0b286938c6e9260a5aea0a1681d4aaf3d4c78949n,
  b: 0x4979bdn,
  r: 0x71892eab0b286938c6e9260a5aea0a1681d4aaf3d4cff9fdn
}, {
  a: 0xeb58a7759f4n,
  b: 0x92fd30a4797b6705d5cec57ba4145a179def799dda99365c1677c1ffc99a76af1c53n,
  r: 0x92fd30a4797b6705d5cec57ba4145a179def799dda99365c1677c1ffcfbffeff5df7n
}, {
  a: 0x3f6d3a1a530f01b1c4n,
  b: -0x7eb87cb924eba8cn,
  r: -0x2c18588904e0a0cn
}, {
  a: -0xcaf72bf4a3748d469de11cec1673b90aed4796894db4f2n,
  b: -0xed00fe44d76bc6175f058f46182afa83a782cbc2ee43085bc85a98350625n,
  r: -0x25701840210084281a100c80262010849401288050421n
}, {
  a: 0x9ff1e4be694e11c7af6e1dadaa81n,
  b: -0x38b573d700n,
  r: -0x10a052547fn
}, {
  a: 0x6df3a6a821383b47effd5631deca7b0d98160a9d311567cd304bf79bb3fa001933e49n,
  b: 0x521dcn,
  r: 0x6df3a6a821383b47effd5631deca7b0d98160a9d311567cd304bf79bb3fa001973fddn
}, {
  a: 0xfn,
  b: 0x2c15ccedd92dd7aa53f879bf9n,
  r: 0x2c15ccedd92dd7aa53f879bffn
}, {
  a: 0xa30ef101f3996d90a337c73d6b0a8aa37c7cn,
  b: -0x8b078a823eb662a8862cf179363286024e899en,
  r: -0x8b0480023e046280060cc038021084004c8182n
}, {
  a: 0x26d407dece81cn,
  b: 0xec894524ea76fcfd4a2c516d4b85f673883f5a0f2fa9b9n,
  r: 0xec894524ea76fcfd4a2c516d4b85f6738a7f5a7fefe9bdn
}, {
  a: 0x2e5cd4bb56bdcff759aa88fdb6c6e5e61n,
  b: 0xe64f617dfe63faen,
  r: 0x2e5cd4bb56bdcff759eecffdfffee7fefn
}, {
  a: -0xebe90d0d99a9179db904aae68cfc7306df3e1n,
  b: 0x393397002n,
  r: -0xebe90d0d99a9179db904aae68cfc4204483e1n
}, {
  a: 0xb3b6fad779be6323dbf0f5ea1e3n,
  b: 0x48f9b2f477d846edc3c22e24e69ea02658db61088cb8be087c6281c4474n,
  r: 0x48f9b2f477d846edc3c22e24e69ea026fbfffbdffdbeff2bfff2f5ee5f7n
}, {
  a: -0x4f2a29981977e6abcb97f42fead4f6624d56986n,
  b: -0xc16481ff2a0d324220441234d455c123bffc6cdbe595f5b922n,
  r: -0x43202000012344014812302fc2c4b6404d52902n
}, {
  a: 0xd8cb3b6a592f9c07e648d511664de23e26b939f5183272bd41339n,
  b: 0xcdb0ce65e0721d729ad5d06cfn,
  r: 0xd8cb3b6a592f9c07e648d511664defbeeefdf9f71d72fafdd17ffn
}, {
  a: -0x45e82521e58c942d3bd72324960d14a1fcf5cfd7be3017dff5bf2n,
  b: 0x2763f37679ad9ba74a02e20d463537e08b99268d8ca6n,
  r: -0x45e82521e588800818452204820d108128948c81b600059725352n
}, {
  a: -0x4fa87346ff4247c214e864f5262c8n,
  b: -0x44dd29c2f304c222d1f94703868a0baa76dc48af20a81d86f61063n,
  r: -0x48a032066d4002c20080406520043n
}, {
  a: 0x3023b1f767cd4ea2db0a3c94d4e40e6e3881cee4cac2267d47a5948d7an,
  b: 0x1436fd0a056a4638426n,
  r: 0x3023b1f767cd4ea2db0a3c94d4e40e6e3881cee5cbeff6fd57a5f78d7en
}, {
  a: -0x6db5cn,
  b: -0x608ef0acn,
  r: -0x6d00cn
}, {
  a: 0x8b971d18e314fdaabb78166490ec82556cd8af8508d5c5b15c1e0e91de95fn,
  b: -0xa7f2617948fe9ae536067f6d49f8b870ec1fb9c55eb9304b6bd9f1e29n,
  r: -0xa2e200690054008520026f0149a89020401ab1001a082041614821621n
}, {
  a: -0x2c6cd8d24efn,
  b: -0x7b8f0b174c38907fbe3e3d98bd7d38e9d1c719a167787425f41493e45a7804910810n,
  r: -0x2400481000fn
}, {
  a: -0xcad63ddf56d1811881c50dac08419926cd37eed60622b75a385a05728e5fffdn,
  b: 0xaefa630d5d7a79c48d2cfa4a176e1dbf587be2a314dfddb01f5bfef50da36n,
  r: -0xca50059c5280810001400104004091224027841404222002084004000a525c9n
}, {
  a: -0x5004920n,
  b: -0xe099en,
  r: -0x91en
}, {
  a: 0xbfdbeef9be30dd4748eaf28477633e86335a0e556ef5c4372n,
  b: -0xbe08f66082e4c7afab33328e98e778ccd64794aa885b422c88db46d3n,
  r: -0xbe08f660024000240832228a1040508880441488885b022800830481n
}, {
  a: -0x917d345fb3f51691915a1af4dba5b52d0a27dedcfn,
  b: 0xf84059dc639bd5244n,
  r: -0x917d345fb3f51691915a1af403a5a42108240ad8bn
}, {
  a: 0x83607248aedn,
  b: -0x183e1c99en,
  r: -0x180c14111n
}, {
  a: 0x4c21d56ba8cf7d0c9556aeeb0b1eb18f32eb38d1a3f7be1f3147a9d8d8c2bn,
  b: -0x8n,
  r: -0x5n
}, {
  a: -0x7e4693f7be6258c79e3dfe310f1312fb84d44e6191ab5a2aaeb85b74bde99n,
  b: -0xbce16500377653d64cd22baf126n,
  r: -0x9440610023520286085220ad001n
}, {
  a: 0x52973ed0536326c5c3n,
  b: -0x7n,
  r: -0x5n
}, {
  a: -0xf4ec2aeb90aed9235d90b7eeb93411c2ad960438n,
  b: 0xfe7cbae2366464f7c8ce155a9bcaff35ffb718103n,
  r: -0x102400c890a890035110a2460110008004860435n
}, {
  a: 0xfdc6ab53c34492d3c0f00c560de129ccaa4e361efda9657n,
  b: 0x97c22c5b9658abb2f55030eb16beaaac82c08n,
  r: 0xfdc6ab53c3d7d2ffdbf65cffbff579fceb5ebebefdabe5fn
}, {
  a: 0xa48970b30c165b886be48e6704a7an,
  b: -0x98bn,
  r: -0x181n
}, {
  a: -0x57ea937f1f31501e44ac11de7858f93dcdf7114f356an,
  b: -0x84cdn,
  r: -0x449n
}, {
  a: -0xc7f06n,
  b: -0xf2efc26c1765b1c5f03an,
  r: -0x47002n
}, {
  a: -0xc859fde6ff6fa51d61868f0n,
  b: -0x7cd7eedcfc29fcc3b9ba7f31c522fa4a69b8f405fbf7a9aa65905a0af99a09ae0814n,
  r: -0x88005904a02f81000080804n
}, {
  a: -0xa7a375a7e9e703ed00c218b3e8b7c3f1e185ac57n,
  b: 0x203eb6d791650f63cf2cb6f8bbcfa5d4e6541e43dd7bf8703e9d50b0c72667041n,
  r: -0x30120a188a603c0004018b00022c0f181818c17n
}, {
  a: -0x74d66dddd7ac9e5b51120545437fd6ae011b351c21daa7f84ab60a47a5f9138dd29n,
  b: 0x67987d1a87cddf477fd980774d05039237aac227635c3fcd98bce8bb579294n,
  r: -0x74d66984502c1603000200004378822e0102140401d881c80802024421700284d29n
}, {
  a: 0x9562f5b289ad89e9459f170b604f13fn,
  b: 0x608c05cde23c02e275644832f6222b66273977c2af6d43dabc8n,
  r: 0x608c05cde23c02e27564dd72f7b2abefaff977dfbf6f63dfbffn
}, {
  a: -0x3379a9a4an,
  b: 0x5140327d0d4327d16c146dn,
  r: -0x26928a01n
}, {
  a: -0xc5cf5e6339cfac4560f37f9ec29c72c6dfb329cd41483n,
  b: -0x385965b007b04a07563c6c6cf31n,
  r: -0x305904800430420712284c40401n
}, {
  a: -0x8fe8ba0e2eae731b12309a4531n,
  b: -0x8f01e0d5d3599f4d9703bd29d833b8e372e292745abf70dacbeb06n,
  r: -0x88e032020224521b10108a4101n
}, {
  a: 0x748c955d7ec0931cca7f1n,
  b: -0xe875e180bb0fa13b1c2fb241cbab884fb893ec55a8dfc7dc790adb99en,
  r: -0xe875e180bb0fa13b1c2fb241cbab884fb89388512882811c68021180dn
}, {
  a: 0x8282c778004944a75866fac8136c9bb9b1520d22658d8bc24n,
  b: -0xdaa2d84n,
  r: -0x5220184n
}, {
  a: 0x5af939056430afb858b9066dcf7988d87f93c586bec927860bec93cc94n,
  b: 0x3dce5a7d31f2456f75ff731bc5854f82ee844f3121n,
  r: 0x5af939056430afb87dff5e7dfffbcdff7ffff79fffcd6f86efecdffdb5n
}, {
  a: -0xcn,
  b: 0xb243dc2c14022ea9c18bc260060b62a0816c57n,
  r: -0x9n
}, {
  a: 0xa3a7e2451e26271659ef1430465fb553c3n,
  b: -0xd2f18c09f5774b299fbf69ee30ba5a513f38252fa484a693ad92c6b4f639c937n,
  r: -0xd2f18c09f5774b299fbf69ee30ba5a50181820218080a0820082c6b0a0088835n
}, {
  a: 0xc2f6dfee8cf7fc12a7fe699f8c073e58fbb813f43155fca2e2d543a63aa49d1n,
  b: -0xe26356e7629f1fbfda2329b309b1e303ae2f48802a84ffc3d1n,
  r: -0x2241000162071f8c1a20003200b0e200240140800084558201n
}, {
  a: -0xc6e94d08f5e0cfca03c79afaa2657b5ed0e79f1n,
  b: -0xcd12731667481a2f4c5a0a9b32647be84b4c5a21860f9496d16ea93db5f7a3627dn,
  r: -0x46a80400c5a0084001410812a2015b5e5026071n
}, {
  a: 0x435c41205d536bn,
  b: -0xbbe4008ab5452d50f3e50d2c0f0f272276n,
  r: -0xbbe4008ab5452d50f3e50c200e0f222015n
}, {
  a: 0xbef04dbfe6137f7cn,
  b: 0xa375a96a2d5a2aebfd12f204e0b82985143f626258a16fd54096e9f586b0ec7bn,
  r: 0xa375a96a2d5a2aebfd12f204e0b82985143f626258a16fd5fef6edffe6b3ff7fn
}, {
  a: 0x300a8f3e9an,
  b: -0x597b5616b5d72820d82e3431338e2aa8n,
  r: -0x597b5616b5d72820d82e340131000026n
}, {
  a: -0x72ee772923cbc352c662b41b092ae521019c4c44a09002f2f2d128ed3bb72378a0cn,
  b: 0x8fc6f06f84bea862c538a0baf845871bf1eb0a836cede5e9840267ec0d24a73a9dfn,
  r: -0x702807002341431002421401012a6020001444448010021272d1080132930040201n
}, {
  a: -0x1e4f9c906f991ca1a8f132a49797e667fd212cb1b5n,
  b: -0x3c1519eff1ce494b3e44b52ceebbe5b2bd4n,
  r: -0x41111ca108e010a084034246e920082191n
}, {
  a: -0x61ddbd8e16a9df837f4561ad9d5fde810b357a6n,
  b: -0xc8c5145ec045cae764557a7902e2d977543ef638b22e3859fcda09306c869c7080n,
  r: -0x2195350206218b026305018d801306800905026n
}, {
  a: -0x638ebf41e84d7f4d0b83389581c55f1c14e8b3a04555b3bfe34e1cae85b8n,
  b: -0x14a9n,
  r: -0x4a1n
}, {
  a: -0x5759e6c09013a5287c81fb2bde3dd5454728d108fa5cen,
  b: 0x95275acn,
  r: -0x5759e6c09013a5287c81fb2bde3dd5454728d108d8042n
}, {
  a: -0x5563a5en,
  b: 0x7f9a1a7da8ab31282n,
  r: -0x544285en
}, {
  a: -0x8661a36a91110b291d247e09a0772b9b27an,
  b: 0xe4c70ca37679741n,
  r: -0x8661a36a91110b291d241a08a0540982039n
}, {
  a: 0x1bca7e5d931cc4bfa2b5aadb4deae30b98fcd1734e38d5n,
  b: -0xb8476dc315b76c3eedbfa3e4367d1cb3d4f44efd95a6ae075e7ce99c4c67b6efde029n,
  r: -0xb8476dc315b76c3eedbfa3e402581822c430040594a402030050c9044022a0cb1c029n
}, {
  a: 0xd7an,
  b: -0xc11d28d5a1ced36n,
  r: -0xc11d28d5a1ce006n
}, {
  a: -0x2927fe84667de647945afn,
  b: 0x2b4d169bfcf56184ab51ce5a5b774c9f1efc91ff9801f5db4faea56bacc1n,
  r: -0x27e080420504010412fn
}, {
  a: 0xa1055504557a9a843e65ce3f90b88cd5cd90ba6eaf559bbbddf320afa559fc5d7615c7n,
  b: 0x8fabe37ee6c069n,
  r: 0xa1055504557a9a843e65ce3f90b88cd5cd90ba6eaf559bbbddf320afaffbff7ff6d5efn
}, {
  a: 0x3e342e71d48396n,
  b: 0x2117ea599017206f08f343n,
  r: 0x2117ea59be372e7fdcf3d7n
}, {
  a: 0x24b45aa8249e385de59726d0a377b2bb8n,
  b: 0n,
  r: 0x24b45aa8249e385de59726d0a377b2bb8n
}, {
  a: 0xf10d1f4c434e7c27252dc87n,
  b: 0xfa568bab16384eda50278bbadc3ad1f5fd775865e7918378f463151942f33n,
  r: 0xfa568bab16384eda50278bbadc3ad1f5fd7758f5ef9fcf7bfe7f373d6ffb7n
}, {
  a: 0x37b10d0ae02cf321n,
  b: 0x445c14d4288cf6a194de56b45e284215bc4df302225159n,
  r: 0x445c14d4288cf6a194de56b45e284237bd4dfbe22ef379n
}, {
  a: -0x2ca260b9c24a496e0601dn,
  b: -0xc4ae3413cfd18019b60f85cda8b281c413n,
  r: -0x8260b8404a092804011n
}, {
  a: -0xd73b52c1a55473198a2n,
  b: -0x46c6e2a01515fe3e6df975aac28834964a18c134e966en,
  r: -0x8030124000403009022n
}, {
  a: 0x11bdebe3a0bc7af948f5f10a58276da8b1e473afecn,
  b: -0xc57acd853e42e2569n,
  r: -0x450805042000c0001n
}, {
  a: -0x9a30ad87504d9e4n,
  b: -0x859e99c7330e58e184e5c5c8ef973762085139baae703fc515ea65c5n,
  r: -0x8200ac0150041c1n
}, {
  a: -0x581197d06f9d520141b40cd863f200n,
  b: 0x2f7a690a3142e2d27dadb3840f22d193cf602ef02828c0158d85add46f7775a0f333n,
  r: -0x81197106a105200019008884300cdn
}, {
  a: 0xa86a91ec484395cac8bbe458a088dcc0d083c36824dffbe453c06b8728n,
  b: 0xe4cc64219f1de4e9605e5eb5b1e6e8cn,
  r: 0xa86a91ec484395cac8bbe458a08edcc6d29bf3fe6edfffe5fbdb7fefacn
}, {
  a: -0xae9120a2e0dd4c93d5f420c1af949aba0e82075cfd6ea5758bff4ebf95n,
  b: 0x29af2ebdf2996847f3b220ac8330f10d3fc4e746a41eee6cn,
  r: -0xae9120a2e0d4409140042081a804089a0200070cf0402110895b401191n
}, {
  a: -0x72a2e2092bb7451775c4c7943n,
  b: 0xeac6e18a31f1f0cdbb604c57dd91f994n,
  r: -0x50a0e001200141120004c0043n
}, {
  a: 0x5f8823b6688c1eca3dca7d0d947797e2ec46ae56b062n,
  b: 0x5a939308d9cb46b4d520fa83acffd3e62fb405deb3a3bd17df127e736641n,
  r: 0x5a939308d9cb46b4dfa8fbb7ecffdfee3ffe7ddfb7f7bff7ff56fe77f663n
}, {
  a: 0x47fcb1a53c4c37bd04aa2a0a39affc0e9b7c8de9c3b13a3bb560887a0523aaba500n,
  b: -0x3e994572fbc3588c562a0119cd18d2b2ca440bcbeef2bf7e7c5dn,
  r: -0x2e9145525841000c160801014100c010400003484ea08554585dn
}, {
  a: 0x5n,
  b: -0xcba3b4b0e2f578df4640b2bded1756en,
  r: -0xcba3b4b0e2f578df4640b2bded17569n
}, {
  a: 0xc4f84aecd002683ce6e8fe5c53e58e338f275b92c1295bf676e6n,
  b: -0xb75ff250c1b0fbfa7de34851319358a596ba64cc9cc8cfd0270e56f384490039d110n,
  r: -0xb75ff250c1b0fbfa3903001121911081101200808c0841c02008046104400009810an
}, {
  a: -0x23faf6274dn,
  b: 0x4a8ba1afc0d6043edc217de54c45f24ab4847326685fc49d6737f5ce7eb25688b6bccbn,
  r: -0x2172400305n
}, {
  a: -0x9ec7a33641a01dde0cbd2b457c4a91a7n,
  b: -0x9358ce448dfa29c24423122b4168cb0bdee16396n,
  r: -0x8cc221024020100a00280b015c400185n
}, {
  a: 0x3e733f6de92c9e550b81553cd4da3dc6e3556cc4c8ab8a392964c07067f18d78d19n,
  b: 0x25deb24353e4f954455e807204f2bb96536648eebn,
  r: 0x3e733f6de92c9e550b81553cd4fffff6e357ecfddcefdeb97b64f2fbf7f3ef78ffbn
}, {
  a: -0xdc42cc97dcad7de6272ab2fea6a1f69c1778310dc420dcf7aaaa7fb39a44b05n,
  b: 0x93ce209e463a62e08b563ca09a35cc9b07bd84da86d8d8bede876c3350d3c8c1n,
  r: -0xc000c4139c0951e6020830f604a1360c042030058020541202883c829240305n
}, {
  a: 0xd24n,
  b: -0xbffd915c84d9651396ef2e83f10985a41cd0406e516d901d9b8236266bb96275een,
  r: -0xbffd915c84d9651396ef2e83f10985a41cd0406e516d901d9b8236266bb96270can
}, {
  a: -0xf50a0a24e4e6aae65b9e12f52bn,
  b: 0xe96c33a0728c6bc022bed6b57139f3e742e45fc5aan,
  r: -0xd500080084c60800191a003001n
}, {
  a: -0xbde5197d83a3907deb5bffaf54b8f733e068bb30b45e479cc09b00c4n,
  b: -0x235989da5fa75ee5694dbaaf8c463d24d851c45baad2aee918654d3n,
  r: -0x25181d81a2106c4210dbaa5080631240001800b00c028c808200c3n
}, {
  a: 0x1e8523bad2n,
  b: -0x3fdf59945ae3d686ce093841f219243ce7037n,
  r: -0x3fdf59945ae3d686ce093841f218042cc4025n
}, {
  a: -0xc4f3eae6f609cd634b3b88da9d2297n,
  b: 0xb4fc5be7ca6a3n,
  r: -0xc4f3eae6f609cd6340300840810015n
}, {
  a: 0x81bb742cebe4854a1ce6d3c8bec187b6d9f8dc616c257224d188fb3d78d4c5n,
  b: 0x16e9da95dba8a989f99974cb72f1cc0b4eb75c1faadc8a4c5df2c5427f4c72n,
  r: 0x97fbfebdfbecadcbfdfff7cbfef1cfbfdfffdc7feefdfa6cddfaff7f7fdcf7n
}, {
  a: 0x66d46fabcd6f89f745aa8aba28c563b6n,
  b: -0xf8992eb057ac6e7d3800e3737baf8f3831e844e614f87fb48b6d0df77dc12b6433en,
  r: -0xf8992eb057ac6e7d3800e3737baf8f3831e800a004402904000905575441232000an
}, {
  a: 0x65cd1e234171ffa71acdn,
  b: -0xdb5n,
  r: -0x531n
}, {
  a: 0xa2db946n,
  b: -0x9ae7c53ed6c1ef4n,
  r: -0x9ae7c53e54006b2n
}, {
  a: -0x5507b4702313df547ee9ea74724b05993d84d03565ca1d4ce7db9fcn,
  b: 0xa3449109537c5ff2fn,
  r: -0x5507b4702313df547ee9ea74724b05993d84d014214a140c83800d1n
}, {
  a: -0xcfdba2bf5d5212b8256d00eb2a7e0562ff71c31d3552a0e165eb23adn,
  b: -0xac691dbd17612b9350cf4c892ecefed675d8e5ad1ab7d039664969899e077607n,
  r: -0x741229350420088244c00c2205805201a31c0192440208104032205n
}, {
  a: 0x56024fe9n,
  b: 0x9d9f7fde4efa80c4b569ae2dd666efb115c34f0d95c28b8cb961a5n,
  r: 0x9d9f7fde4efa80c4b569ae2dd666efb115c34f0d95c28bdebb6fedn
}, {
  a: 0xc07a3fde5f340d22cf7f26a5a4a11362cf9f939be54n,
  b: -0x9fb541af7c22207a78b20118d4d6d62ac89f25b62a77f4a13c3fc90414fa05f34fbca3n,
  r: -0x9fb541af7c22207a78b20118d4d2d008001a04b6285300011425810400d204024600a3n
}, {
  a: 0xe771c90d4206f4c54n,
  b: -0x9f0n,
  r: -0x1acn
}, {
  a: -0x47bd13c3bf98c3637bad4b4aaaa68e4db40d14b7f97an,
  b: 0x81bf332af2d0fa99cbf69853ee02118e1ade49520n,
  r: -0x47b500008d10c260522140022a800e4ca40c1013685an
}, {
  a: 0x54046f439354841d27b4eb80d5ec6d5aa8b49a7a732c22ebf8n,
  b: -0x5a49f95f84bdcca06a10e66n,
  r: -0x18085154841848802810406n
}, {
  a: -0x4c8fa066a47f2a5c8b5c4fa58b7ad2e128177n,
  b: -0xdde2b2fdcae264166ca97c597bfb850e40ec7d8fn,
  r: -0x80f802624412248834407a58850c00000107n
}, {
  a: 0x4dcab3e49115943a660fc1426404d200becfac3eba131947bac326c5c854d9935d5n,
  b: 0xb5205fb152799cafb15f2f0f2n,
  r: 0x4dcab3e49115943a660fc1426404d200becfac3ebab7395fbbd37fddeff5dfbf5f7n
}, {
  a: 0x6e1226f020044a7daa7573563bf97dbd4e394d90f1d550c215c2ddcfcc810019359n,
  b: 0x663c04f84c0414d76df88a8af8186d78fe3n,
  r: 0x6e1226f020044a7daa7573563bf97dbd6e3d4df8fdd554d77dfadfcffc996d79ffbn
}, {
  a: -0x27bdfe414923a31937c146n,
  b: -0xdb8e1c2d6dc229d92160d449f92f83f6a21b2930f22f82370ad41bb735268f8d8e5dn,
  r: -0x2708d40101212209058045n
}, {
  a: 0x1403ba5a2de0349n,
  b: 0xf483d9n,
  r: 0x1403ba5a2fe83d9n
}, {
  a: 0xcbf71f2807e483daae8579a8d3c8dbd6f8d96n,
  b: -0x648a08en,
  r: -0x200200an
}, {
  a: 0xf63ec505b42a6n,
  b: -0x5b6d08e33c9e85555511da6e2de3271b9152622db82e04117ad2d8b9ed24eebf785n,
  r: -0x5b6d08e33c9e85555511da6e2de3271b9152622db82e04117ad2d809c120ea0b501n
}, {
  a: -0xb772fbb892d308dc7bc9e27ccd700ab3n,
  b: 0x62e9693676d6c73bd9ec61bf4bd6b6ec3bc8n,
  r: -0x9640892810c000101a40a02849100033n
}, {
  a: -0xe4e0e7b4a870842f576cc26c614f5248abf56n,
  b: 0xe79c10fefa4272d4af3f73a451d2en,
  r: -0xe4e0e7b408608401052c802840400048aa252n
}, {
  a: -0x5eab7d051cf8c716de54e244b1a6d0bf6dfd5cbe8e09924b09026316n,
  b: -0xff89231fb069b77669977b58727c6a963c2957c395b798125f2031ae4n,
  r: -0x58823101049847069854a0042186802340955c380a09800100020202n
}, {
  a: -0xad9bfaf62b4ad300284c9fcb1473fe6405ec8f46a1a8eb0943360c34cffb7eae875bn,
  b: 0x704905088424727b974166a09a38a89abc8fe30be887e95n,
  r: -0xad9bfaf62b4ad300284c98cb0423762400c80602a180e2084136043401cb4026814bn
}, {
  a: -0xfd1eda9f1bdd96b717df7471e152eea0f633504ff088a6feac10a17f2a9c0a439e719n,
  b: -0xb2cbb63cdbb0320f4d63b0df884203441291a8611580912ddf93n,
  r: -0x30c3061c1120220f412100df080203400000006001808029c711n
}, {
  a: 0xed501dfe9de537caba43c2921ab1ed497a66c598a41c0a6a45f12cd86c12b92c704n,
  b: 0x56cc724547943ee2558f8b6d6dee67385c240aa05702n,
  r: 0xed501dfe9de537caba43c2977ef7ed5d7b67efbdfcfcbefedff77fddee52bb2d706n
}, {
  a: -0xde89398b97bfn,
  b: -0x1eba28514ae2594981cn,
  r: -0x14882180901bn
}, {
  a: -0x5de7b203934656fd9813c3037can,
  b: -0x3cca883fd6d03bn,
  r: -0x2cc8803c101009n
}, {
  a: -0x2ce8n,
  b: 0x324151c0d8ed5742efe28eb09508b6e471e3a7n,
  r: -0xc41n
}, {
  a: 0xb454e409868021899a13daf740f81b7e9359f0c4e4n,
  b: -0xe4106835ad12a64b1d77f1b1ec6c8a75b6ec85cf97f72cf4381n,
  r: -0xe4106835a412a00b0517f1a1644c825082e0044816c220f0301n
}, {
  a: 0x5492b8e3n,
  b: 0x1e0e18c7a84bn,
  r: 0x1e0e5cd7b8ebn
}, {
  a: 0xed2764401fd640703d6100d28e11f6b47ce24f79fac8n,
  b: -0x2a865a2de9c8995n,
  r: -0x8010090840115n
}, {
  a: 0xbb999b3bc489b336c0c012632b1ff1b7949cdc2c21709d5644e6252155e4add2084n,
  b: 0x7355e42251fbceaec6adan,
  r: 0xbb999b3bc489b336c0c012632b1ff1b7949cdc2c21709d7755e62771ffeeafd6aden
}, {
  a: -0x929a3e76b291c4782dbbba82c11cc7fad810c2b9317d1a9216c16b106ae28e2262en,
  b: -0x6dad7fa71c2bdd01d8734c6e716d829215c0fa46bb76de7217b1a9fbfc0n,
  r: -0x208144200c2b9800c010446a5000829011401a0212404a1002a0882262en
}, {
  a: -0x3799n,
  b: 0xb525de78b8e7100e22613efa20635c5b64092e1n,
  r: -0x2519n
}, {
  a: -0xc90b71b8dd86c5615e027773f4cn,
  b: -0xee3f3a4e2720928e206408473e398f3940a7217dcca69d868af0eda3d6e8e0a196e2n,
  r: -0xc80950288d06c0214e020211642n
}, {
  a: -0x37732eac77af5d5af66d2dn,
  b: 0xd1n,
  r: -0x37732eac77af5d5af66d2dn
}, {
  a: 0x13b198378cfen,
  b: 0x3ff891ba17f64504d84a7b026809a2c1ea14b6b6b434db74376f8e130eca7an,
  r: 0x3ff891ba17f64504d84a7b026809a2c1ea14b6b6b434db74377fbf9b3fcefen
}, {
  a: -0x7ba55dbcae1dff3a5bdd3fb2e9f87fae1faf37212cba190bn,
  b: 0x354f2adefe6ae254a2417b8dc0d7d28c981039674bdc5n,
  r: -0x7ba4090c021019105a951ba04120728217263620288a000bn
}, {
  a: 0xdc19d878dd56aaaa88293d5c6ddbe434c89b7e0b93d700f2db3fa3afba1df3657f7105n,
  b: 0xf5e7ac617235a9f819e6ce0cbc29ef12a8c057f84192324e6ece27e4d3can,
  r: 0xdc19d878ddf7efaee97b3dfdfddbe6feccbf7fef93ffc0f7fb7fb3bffe7fff67fff3cfn
}, {
  a: 0x1e5c27961d94cf14bbb7a7f4c4f191n,
  b: -0xa0bcn,
  r: -0x2bn
}, {
  a: 0n,
  b: 0xd523b01545b53d94029dd0bec5847b12a9153117dd2e1f00cab4b8eefn,
  r: 0xd523b01545b53d94029dd0bec5847b12a9153117dd2e1f00cab4b8eefn
}, {
  a: 0xd1cc7bd84cca7262e9a52ab021c363848f8671873c0c023e8e13e3bd1777n,
  b: 0x4d8384c46c44389e36n,
  r: 0xd1cc7bd84cca7262e9a52ab021c363848f8671873c4d83bece7fe7bd9f77n
}, {
  a: -0xf4f5en,
  b: 0x296a5702298d4ebe6dea69309d57c8f298b9c9n,
  r: -0x74615n
}, {
  a: -0xd46c752cb97ee98a55d865c03830997n,
  b: 0x5192n,
  r: -0xd46c752cb97ee98a55d865c03830805n
}, {
  a: -0xe5d1f6291fba904f6203a5e36b36e6f7b1n,
  b: 0x5d46357e75adce4db94e6a97ce32cecb1db97d5n,
  r: -0xa010a4211b200009420304c30306246021n
}, {
  a: -0x7e4dc92eb8n,
  b: 0x3f7f5d6ae578fe3fb48251879db39f687275a197a14cff58n,
  r: -0x684c8100a8n
}, {
  a: 0xb51c89fn,
  b: 0xe0997c3a494accf9195dcf5b9ad358b980dce333b30n,
  r: 0xe0997c3a494accf9195dcf5b9ad358b980dcf73fbbfn
}, {
  a: -0x8351642a1a6850d2b289aa588c19e869421b4a29c2d90875cfebe56317d5d94d7n,
  b: -0xe355b7258ce2b7e9n,
  r: -0xe21416210c4094c1n
}, {
  a: -0x3726206bbcdc1cf8ecfb8727d9585ea252dedacn,
  b: 0xd798a8117b546dd8e0374504a6dc08ff82ba1cd4cf5abf748c373854a4515f2f6c23n,
  r: -0x3006004a3090085008b3040458101aa20008189n
}, {
  a: -0x3ecf380108e5080936ca14bdf27d18bf4ce3n,
  b: 0x6423e5ecf3205171da16ean,
  r: -0x3ecf380108e50809140a100cd22c08254801n
}, {
  a: 0xd64d2d066bf5c1acf0fc638b54583c7da47dd6d578cn,
  b: 0xe98d0b997e10f2fd8468f00a5e62e169c70786b3a8n,
  r: 0xdeddfdbffff5cfaff8feef8bf5fe3e7fbc7dfeff7acn
}, {
  a: -0xef136459d3528526e284d686ad90a6df1ff4dcfd6081ebda8618938c6390e2n,
  b: -0xa08b2e697af750a96c355ec26127498cfcb8e8690f28bbd83274a4fe2n,
  r: -0x89242852660009682058026121490ccc9008080d2821883044200e2n
}, {
  a: 0xe867d55b43390f576fd664b34c0ff5aca71832b53f5ca8cd19bebfe0bc065fn,
  b: 0xc322416df950ab14179e8f09545f8cd8ee4a355bed11a941a61f2n,
  r: 0xe867d55b4f3b2f57ffd76eb34d7ffdfcb75dfafdbffcabddbfffbff4be67ffn
}, {
  a: -0x39n,
  b: 0xd73274ac2bddn,
  r: -0x21n
}, {
  a: -0x31b0bfa4304e6dec96n,
  b: -0x868852663e1314ea2055659604f59ad6ae075dn,
  r: -0x219004a410462c0415n
}, {
  a: -0xcc872152f13dc2c8361cf9500c47bceec0b0509fac28d1e2bc7567n,
  b: 0x12b40b0d7af5d864fd8f999708f1n,
  r: -0xcc872152f13dc2c8361cf9500c4508e4c080000788005062287507n
}, {
  a: 0x2c49416df66729fb3666846501f7a2908aed7cf4a026d7c9a9569e497n,
  b: 0x6f068911abca25f05620841449208eda336237ac330c54cc588ef8d9a95596n,
  r: 0x6f068bd5bfdefff676bfb7766966dedf7b6b3faef7cf5ece7dfefadde9f597n
}, {
  a: -0xb09b9c2476n,
  b: 0xe4ad51d201550fd4728ef32e8de8965094208f50c1802en,
  r: -0x308b1c2452n
}, {
  a: 0xf8bf7cc75dec175f7114a711d5f33e9d809ba89n,
  b: -0x58a6856f28cf085f9200326aca0af6e3a36cbccbf190ef43da41856f8fae9c07fcfdn,
  r: -0x58a6856f28cf085f9200326aca0af0600020880130800842900080208c0604064475n
}, {
  a: -0xfcfb6873c1n,
  b: -0x7709ed1b0f27d4bden,
  r: -0xb0f26843c1n
}, {
  a: -0x15fn,
  b: -0x6f923b86122a6643c49ef8ce19b4322f084bca8827f2cea65e77a9767c7eb0d89253n,
  r: -0x53n
}, {
  a: 0x8dc08071784caa2ee69d3309f29066dbd6ec0e6a3475n,
  b: -0x71ddf4c2c3n,
  r: -0x11d194c283n
}, {
  a: 0x55bf0ca7383980af55565n,
  b: 0x15c718fdeedd0ba3ed3d1acbca44bda8b9b3735094f1a8a67ad809c44fce3fa1b20f2n,
  r: 0x15c718fdeedd0ba3ed3d1acbca44bda8b9b3735094f1a8a67fff0de77fffbfaff75f7n
}, {
  a: -0x6f1ba15336aa7c8915cb6bd1cd16e532cc2ea7n,
  b: -0x83da1516e2d40908afc408b002492e647f24n,
  r: -0x3801116a25409008b400080024122442e23n
}, {
  a: 0xebn,
  b: -0x3222db7fa63a014d463ff92af6c82579b953n,
  r: -0x3222db7fa63a014d463ff92af6c82579b911n
}, {
  a: 0n,
  b: -0xb09412665d31f5d399f080cb573ae8d32726fb9baedfeba738d2dd47ac9bn,
  r: -0xb09412665d31f5d399f080cb573ae8d32726fb9baedfeba738d2dd47ac9bn
}, {
  a: -0xf3n,
  b: -0x7c77febe400a4a46bc77n,
  r: -0x73n
}, {
  a: -0xef9713fb1c860dcd2ab5357b585ea388091a531928b9b4e42ea276abdf0fa5n,
  b: -0x518bb33cc2cfa6008ddbfn,
  r: -0x18b0200c207220080da5n
}, {
  a: -0x742444cf5d3ee60e77d5ec2a846d4646ddf03c7f54e0a45fc043e9ddan,
  b: -0x458e73b5dn,
  r: -0x400261959n
}, {
  a: 0x4d8755e875466b70405a1769e809e09a26ebd4522966997c73cd0c455ac23b78586cen,
  b: -0x1869e7c1b86f1e11f534b0874be713e50814an,
  r: -0x18002381900906018430b0820125008500102n
}, {
  a: 0x64297d5999b438269a0n,
  b: -0x3a3be79n,
  r: -0x219659n
}, {
  a: 0xda89f4a97f8b5a67207e5e5ee86c898e2ebecda9fce038c9ed664e4ffc157n,
  b: -0x1419cefc4f99c0661d1d994d05cd3318194cd1912f710f8fd17b0n,
  r: -0x1084984f8180201511104101413210010cc11002110180016a9n
}, {
  a: 0xf42ac93f1cf62d23a3ca1101f7b7a3038225d542c2a50n,
  b: -0x35n,
  r: -0x25n
}, {
  a: 0xe9a475bd46bc28f30e1196bcbe077ef3de89d5f9af88592c7dd6f5cb9ec31afa5db42n,
  b: -0x8aeab107bb6145ed6091a7ece201ee655baa832d1579f7dce8a9de8db23582181d8294n,
  r: -0x8060b0042b0005604010a68420018800420202200501724c2820908102118210180092n
}, {
  a: 0xb0d32c44ed31a0f0958ea8ce5d32d572ac790f75de02742a44add7n,
  b: -0x36ac3339926d3d19bbd5829db01121a39636a959e30722e3923488a404bf15897n,
  r: -0x36ac3339926430093b910085b010210112122850a005206300200880041b15001n
}, {
  a: 0xcc87cc5a3055b99cb9e5c05e55283b34251718619bfd8026e76c6n,
  b: 0x29456933bfe080d2123cc39c79e4f59e6e8cfee2n,
  r: 0xcc87cc5a3055bb9cfff7fbfe5d2d3b37ed3fdfffdffde6eeefee6n
}, {
  a: -0x89ffa4c171f08781cfef4d618ca3b500aa7d847414cc86c886d43db4115b5481f365en,
  b: 0x3e96d1151367f6a6100e2bdf4a7d591fe1352622a77bb45fc1an,
  r: -0x89ffa4c171f08781cfc1492088a09000086d8054008482808014089011580401a0246n
}, {
  a: -0x29ec611c1eac59479ecf337970a99d9432ce82741a3df043d15abn,
  b: -0x2c136ca3f9ef03d9fa1f27606dd202faa6976027871n,
  r: -0x2c114482c9230150a81d04204c82001a24904001021n
}, {
  a: 0x8ea8142cc98f494be444d969658cb98d1c5ae15ae62740e845n,
  b: 0x9fbd2e7a81a676a5d3e22e2266b1ddba9435abc3f541ca0df9n,
  r: 0x9fbd3e7ec9af7feff7e6ff6b67bdfdbf9c7febdbf767caedfdn
}, {
  a: 0xf4bf4c01b93338482592d5c9ff473478c6adca5caa75a05410dn,
  b: -0x3041d0e66e81ad1aa716b757312b1a6ca377a206695dbb772f2c18fn,
  r: -0x3041004022800408871692452022002883072002210111020f28083n
}, {
  a: -0x7d1n,
  b: -0xda60af8109dn,
  r: -0x91n
}, {
  a: 0xae86c473e3bn,
  b: -0x742edaa0160b9625d797c5e91d5d54c7d6c0beb4d7e60den,
  r: -0x742edaa0160b9625d797c5e91d5d54c7d6c0103013840c5n
}, {
  a: -0x7dbae788cd0ff5939334753441ea9511b03f76d99e9e758a112ea7n,
  b: -0x214286291dc75cc47c84ddc3cn,
  r: -0x10202210d8148c4588010c23n
}, {
  a: 0x9b98ab2e9a9511e9273e84937ed9da02b52f1bd3874n,
  b: 0xd88b7fe635b01dc4f31d6d685n,
  r: 0x9b98ab2e9a9511e927fe8ffffefdfa1ff5ff1fffef5n
}, {
  a: -0x33b658af45de1494n,
  b: 0x7c56682225973769602fc51256614n,
  r: -0x120580304da1084n
}, {
  a: 0x8n,
  b: 0x479779911ff53a621fn,
  r: 0x479779911ff53a621fn
}, {
  a: 0xc7b89976aaen,
  b: -0x78e9075ca03e9be7363dd77c016d86948bc9c6b6433bdn,
  r: -0x78e9075ca03e9be7363dd77c016d86948b08462601111n
}, {
  a: -0xb9183f66fcb1b7ff42b329b615a234f105942ecfb15c8c6207318c25f1d7cabn,
  b: 0x1e569fb5f58aa0864eb70eb83e4382e78n,
  r: -0xb9183f66fcb1b7ff42b329b615a234e101000a0a315c082000310401b055083n
}, {
  a: 0xee3d2391e08cbffa2dc4d20c91887n,
  b: 0xdbeef1a6c1e0c4bn,
  r: 0xee3d2391e08cbffbeff5f6cdf1ccfn
}, {
  a: 0x8f3bd672d8ecef14f610bfdff9981b334d7d5bfca7eb81466cd99ae22n,
  b: -0xa4af1fe4927ce47ee587b24dfe4ef98e75n,
  r: -0x261e4482282040258102499802600055n
}, {
  a: -0xea63314b35a1fee46e8179e8c6b04183470bad1f80c1a631en,
  b: 0n,
  r: -0xea63314b35a1fee46e8179e8c6b04183470bad1f80c1a631en
}, {
  a: 0x4ec8an,
  b: 0x18e7b6e0950458ea6afb775885eaf957bcb53cdb73335604040bc29ec3861fc76n,
  r: 0x18e7b6e0950458ea6afb775885eaf957bcb53cdb73335604040bc29ec3865fcfen
}, {
  a: -0xdcbd0113549385en,
  b: -0x6908f8ec67170ede781f29106c9n,
  r: -0xc9c00130010049n
}, {
  a: 0xafa8f6682f844de0d6d85n,
  b: -0x47c0609f78326eadfad3b59dea4bee3c94n,
  r: -0x47c0609f7832640570913505aa01e21013n
}, {
  a: 0x7a222335abd4023790dc26722e3ddbf4350f505n,
  b: -0xb356ae9c69a11863470c5aad917cn,
  r: -0xb354869029801800020018ad007bn
}, {
  a: 0x7902f7f08c927b2d3111en,
  b: -0xffbba92fc34d1d6fbc2a496a5646951ed1232c6ca5becefen,
  r: -0xffbba92fc34d1d6fbc2a496a5640051080232448052ccee2n
}, {
  a: -0x182b3n,
  b: -0x24a02c50afd7fd4bcf80d92a2d2a2a99a50a4dd6e7b681dc85c94c7f960b04365n,
  r: -0x221n
}, {
  a: 0x56826fn,
  b: -0xe3cf252d2e5993c1d7e1dd75ae2324e56a8ae619edfd6864f1d94da8f28afn,
  r: -0xe3cf252d2e5993c1d7e1dd75ae2324e56a8ae619edfd6864f1d94da892881n
}, {
  a: -0xae3f9a86524ea1487e58b74faf9eba95bbb5e7450525b37108n,
  b: -0x6a892885ee8e8a0f3ba4f3cb67efc1345b7760ff39b1797a78fn,
  r: -0xa81288064048a0403a4834062e9c1205b33407410105932107n
}, {
  a: -0x268273032729b54c691n,
  b: 0n,
  r: -0x268273032729b54c691n
}, {
  a: 0x85cf76e051d2bcb5a6045a32078856dcbfb40b26bf6084n,
  b: -0x172bca5d6dbc121f1ee36b4753453c84821a355e945c2bc8f0b4740699073n,
  r: -0x172bca5d6dbc12170200014242443484821a145e8458020000b4440409073n
}, {
  a: -0x96d8ccd540e2457e90f3ab4077078d4f5997057425eb6de0c0e87699an,
  b: -0x393cce0debbfan,
  r: -0x2920c0086299an
}, {
  a: 0x2a6281875721da96dcab0b585d3838107b63b5n,
  b: -0x1b357n,
  r: -0x9043n
}, {
  a: 0xdn,
  b: -0x5a7c274d1f1a88cac823n,
  r: -0x5a7c274d1f1a88cac823n
}, {
  a: 0x87301a450946b484ae66dd79081180cbadcc976n,
  b: -0x9ae49ecbf4an,
  r: -0x1a24120360an
}, {
  a: 0x4n,
  b: -0xfc54901bd6d463422c21053d3fddd61cdd5d455424a060d23d3343a9n,
  r: -0xfc54901bd6d463422c21053d3fddd61cdd5d455424a060d23d3343a9n
}, {
  a: -0xff0d7b442a235ce40b0n,
  b: -0x877668ec5647e235d020fa4b802b00dcc1be0f87f3e7226cc54b8cf670f81332943e90n,
  r: -0xb80d630400230840090n
}, {
  a: -0xc1091dd6b91226d18f73430cd670172a1ef51a956d9fe773ba8e4c9n,
  b: 0xd28353b3a7b3b8b2cea7f20n,
  r: -0xc1091dd6b91226d18f73430cd670172a0c740804480c474130080c9n
}, {
  a: 0xcf2cada76e41fadb070fd504cee6f71e096dcd5628128cc5279e3fc2033bn,
  b: 0xe99f2a912598d6367e16fa28706ad25c77ab4d286ba4306bden,
  r: 0xcf2cada76ee9fffb972fddd6fefef7fe297defd67c77afcd2fffbff26bffn
}, {
  a: -0x343d27b0dffb56af281d638fdn,
  b: -0x10f18724f7d8edd48b3c6b21820981n,
  r: -0x300d2580dd481286201820881n
}, {
  a: 0n,
  b: 0xf7f22089bdfdf2e7bd7136699381259a695c9ec9aa0e9e740224b17d4d5aad29551a4n,
  r: 0xf7f22089bdfdf2e7bd7136699381259a695c9ec9aa0e9e740224b17d4d5aad29551a4n
}, {
  a: -0xe5314dn,
  b: -0x627802e759e19625393a66188820n,
  r: -0xdn
}, {
  a: 0xa2367222e84e7c2c90fn,
  b: 0x50629d23780e0cc6bf9cn,
  r: 0x5a63ff237e8eefc6ff9fn
}, {
  a: -0x585ca5970b3721e302046792e4051571635cf38713df3bd18badcab1837n,
  b: -0x77bf9998e2c419b7dfa9f767c65848n,
  r: -0x57161188204019b39d08b244821807n
}, {
  a: 0x9250cef2f8d7eae727d75e426277d2a8439e4317364c508ddea347edeb95c2n,
  b: 0xee5cb2e20dc0b92332b93a7bf99cb2e1b697fn,
  r: 0x9250cef2f8d7eae727d75e426ef7dbae63de4b97376fd3afffbbcfeffbfdffn
}, {
  a: -0x13dfe2560179e270828c2f44bn,
  b: 0xc60572c1ddd1357a43e08b7a21fedcf092c57n,
  r: -0x285a0160001c200020c2d009n
}, {
  a: 0x56afc45602c29fde65033e8812a6aa3ccec7n,
  b: 0x70412e6f9135e558820372ba0f55efn,
  r: 0x56afc47643eeffdf75e77e8a13f6ba3fdfefn
}, {
  a: -0xdd46b42dde5edbebff3ee78775174349f765c71c0dd514cfe3n,
  b: -0x8bd04400cd0003350450eae7e52932d7a0d8336n,
  r: -0x89900400cc00031104108a66442100d50048321n
}, {
  a: 0xb3c0b8b28e06d22f14e55ce6b3d8868f8cdad3ae1cbaen,
  b: -0x4a3199aff6357b73ban,
  r: -0x4211012252051a3012n
}, {
  a: 0x2fdc96cb380f34fb1651940d83841adce92b736fd2aeadfcef6ec458e9052df1e1n,
  b: 0xceda9e3763b85b550c2d2abdadn,
  r: 0x2fdc96cb380f34fb1651940d83841adce92b736fdefebfffeffedf5ded2d2ffdedn
}, {
  a: -0x4ff4bc4c3e9f4171bn,
  b: -0xaf432d388f64b23d94de6c4d90892308e378cf5d00f0ee8a020bn,
  r: -0xcf4900c0e880020bn
}, {
  a: -0xc2e9a666c12949b2e7cdc7001c25786b2d90caf97fcaabf70e44f8f5e5e0cea35den,
  b: -0x4bf2362136e47a6ac629n,
  r: -0x40e006011644086a0409n
}, {
  a: -0xb943164d8e5ce9e52afeda08f5605b40b8ea1e5n,
  b: 0xfb1a76e0fdcb434718f33599a157d7124cb67943f9c930d25b5edcaed10f068c8n,
  r: -0xa80004010804a80422ce0800a1205100b0e8125n
}, {
  a: 0x6d38b92855fb59b18083c51c2162381818fdbe45c18ab436bf9ed64bn,
  b: 0x9e765fbe96b3d8819c3929bn,
  r: 0x6d38b92855fb59b18083c51c2162381819ffffffe9ebbdbebfdfd6dbn
}, {
  a: 0x12869685f0b7e86f00e99f7d2772c613aen,
  b: 0xdc1609ca0759ffa233f34a7c7715492583263d6b0dn,
  r: 0xdc1609ca17dfffa7f3f7ea7f77fddf7da776ff7bafn
}, {
  a: -0x8786699c602457ae99f334056fe5fa4e9f8n,
  b: 0xd2eb2fda643689539ce9789n,
  r: -0x8786699c602405049021100166a46206877n
}, {
  a: -0x6f6a46dfda349614ac3edc5e8547f4a1f068bbc941e55109b7b0cb98f4f45c25173dn,
  b: -0x1d5a68de7fa483b8f1c6d31211dfbf2b683n,
  r: -0x40a28941e0400987104910201458201601n
}, {
  a: 0xd0d5f4af75e6cbe668f528976080ebb4471d1b0373217273d3b9bn,
  b: -0xbe13dfd3340feca6c1587477d10f7d130ef1ec212820c4a8d9199676e0f5n,
  r: -0xbe13dfd23000a40081104011500d740106f1442108204488c9089042c065n
}, {
  a: -0x21eb0fe2de465a79a404f294d1e38n,
  b: -0xb3b9a5d2e8c5699d6687bca9dd2362d3bb8e72c5711n,
  r: -0x16207a08844026080008210c1611n
}, {
  a: -0x93fc240d1b5c4n,
  b: -0xe2edff5241ed811c388c709bb6n,
  r: -0x11c0000509182n
}, {
  a: -0x2802c92033eb8b969ddce4d1a27a17f84b379d7c9b618322a16bb670978ba5548fc342n,
  b: 0x8444ce590811en,
  r: -0x2802c92033eb8b969ddce4d1a27a17f84b379d7c9b618322a16bb670978ba1100f4242n
}, {
  a: -0xf0284541cb427c94n,
  b: -0x2ad3453b77f0e6f356e539bc5badf90e41193c2f96959bb49134cfa05d23ddfbce85n,
  r: -0xc0204501c9424c81n
}, {
  a: -0xb26e33n,
  b: -0xaf48166aa6ee7651ebf4b7n,
  r: -0xa26433n
}, {
  a: 0x144b4931b24faa93c3dda5ef7d0c814ed01en,
  b: -0xbn,
  r: -0x1n
}, {
  a: -0x755d1cf832fcd88fd002f2a2e1bef0fe98c5957490a61cdb41014c32c67f6f8n,
  b: -0x2f1c274b28ee96ff7n,
  r: -0xb00014820c6166f7n
}, {
  a: 0xbe6e4e1c7996aa831ac85d97d8183cccb20338abe9acb70e4a96523f3e4530e97n,
  b: 0x640a5923626n,
  r: 0xbe6e4e1c7996aa831ac85d97d8183cccb20338abe9acb70e4a96527f3e5d33eb7n
}, {
  a: -0x693511060cf90595a957028fc271cebb00a19a0f610bc090a32aan,
  b: 0x9041517af49d7db035a775296f0ba2c3470e98346572055e92dafe59an,
  r: -0x280501020049001088560084403088b100819a0d6001400001222n
}, {
  a: -0x111a6ca01ad6cf7b93aee771e35c7fadafn,
  b: 0xb2921ca9c03c742d29827efbc9e5811e130146b4eb8ec4c86167458c5179n,
  r: -0x101a60a01a904b10112a2710801873ac87n
}, {
  a: 0x74c02096fc479c7e9adfb0886d48c181282e9c40107299ec803ecc6148bbd676a85n,
  b: -0x7ae9e801d69den,
  r: -0x1aa1400180159n
}, {
  a: 0x56963ec70696adn,
  b: 0x36b2188f8en,
  r: 0x56963ef71e9fafn
}, {
  a: 0xbafc9e78cbef112df4242828240deb728b9ae00dcean,
  b: -0xb7393de5e37d01058855c9e91a424be952e4365f3a65baa87fbc1185n,
  r: -0xb7393de5e37d0000001041410a4000a91064341f2040920051bc0105n
}, {
  a: 0x65b380e75f1dcf772333f6452cacafe4a022951f03e1n,
  b: 0xf96e842e4d6d65997fb3d5a3cd189ffn,
  r: 0x65b380e75f1dcff7eb73f6d7fefdbfffbd7abddf8bffn
}, {
  a: -0x5eaf61cbn,
  b: -0x1b0ac5f4470800ecfn,
  r: -0x508000cbn
}, {
  a: 0x4e5n,
  b: 0x9dbe325140cb84d193cb8a4d4c83e7414006968c8f7c900eaa7535d828n,
  r: 0x9dbe325140cb84d193cb8a4d4c83e7414006968c8f7c900eaa7535dcedn
}, {
  a: 0xfb2232c4f389f71e6f8cc7077a6f87d11b7632c3bd049e78729d2e78f7349f8n,
  b: 0x2543en,
  r: 0xfb2232c4f389f71e6f8cc7077a6f87d11b7632c3bd049e78729d2e78f735dfen
}, {
  a: -0x729784b5bf116bbec44fd5f7731112a08a6fc3b918018ae63c861612n,
  b: 0xfn,
  r: -0x729784b5bf116bbec44fd5f7731112a08a6fc3b918018ae63c861611n
}, {
  a: 0n,
  b: -0xbdf2556fc62dca25b6f512e6dc72a0b3d94f18ca07a7bfe07cdb5455422d79dcan,
  r: -0xbdf2556fc62dca25b6f512e6dc72a0b3d94f18ca07a7bfe07cdb5455422d79dcan
}, {
  a: -0x13eb5b03c3256d5ca20bcd31d4n,
  b: 0xaef507b7c68856739ba6f7f7df8b66b73381b9n,
  r: -0x1884001000020548008cc3043n
}, {
  a: 0x1432ee6191859a0d9fc03447800729db5e4056n,
  b: 0x427b5ce1876e81098a8cc6d6cacf883b4b1cabb4n,
  r: 0x427f7eefe7ff859b8f9fc6f6cfcf8f3bdb5eebf6n
}, {
  a: -0xcdfdc0c31080cd711e929186e2n,
  b: -0xff8b39fae9a70cdac4fe89d364441610d676n,
  r: -0x850cc0c01080c1600412108662n
}, {
  a: -0xdae1fb87ee00d221a818d3be77360455ac29799b91b224597bfa9c7c4n,
  b: 0xd4ed21bb50n,
  r: -0xdae1fb87ee00d221a818d3be77360455ac29799b91b22450312884484n
}, {
  a: -0xdeea05a99dfb7df33269adn,
  b: -0x80b52781fe3b45e4189b3bc6b836c5e5d9a5a77dbc97b9806939n,
  r: -0xc4c805a11db815b1006929n
}, {
  a: 0x6898ac32ab180baf3dd19d6fcba5d703e850e16e4b03bd6efc31369n,
  b: -0xa55da4c1135aa118f0560cbfda45cd3cf0fd6en,
  r: -0x20442001010281007050081b4a44091030ec05n
}, {
  a: 0xfe0e750d074196e738e9b12cb965184dcfdn,
  b: -0xee6f1dn,
  r: -0x6a2301n
}, {
  a: 0x30131n,
  b: 0xaae430d2efab5b82n,
  r: 0xaae430d2efab5bb3n
}, {
  a: 0x32be7d97398674ca176b6be3c70fdb2b0c596f82237n,
  b: -0x9908a341348d2c2c5815dd1035d5b3208ab77727997fn,
  r: -0x980000000405082058014900018502000a3261079949n
}, {
  a: -0x8cd03f4a7a5d998d512de34997b5d0d0aea44990n,
  b: -0xe00ce72202487b6e326287d28b0d44be486f80a9f011237662e2d6n,
  r: -0xc102202520909041008630081b0100026204086n
}, {
  a: 0x6a91n,
  b: -0x7n,
  r: -0x7n
}, {
  a: -0x50ffcdc794a8e2325ff96725n,
  b: 0x15a4b034334b482ac565bec4111bd0b7a49c3f87ec6c06194c5eb4826b9dabb61n,
  r: -0x103f8c431000a21046214405n
}, {
  a: -0x55dffd3e832cn,
  b: 0x9a456fc3761ea20b3163046f0fc8cf4edbfb9ce3c7c33ac59fen,
  r: -0x4183cc128202n
}, {
  a: 0x1f9d2e3312n,
  b: 0xa42a6583240abdb82bef5f879a11d3fen,
  r: 0xa42a6583240abdb82bef5f9f9f3ff3fen
}, {
  a: -0x8beb54d26079n,
  b: 0xfc7f81abb20c7629d22c8f4cf835ffd771fe47b64e32dec335f542ef13ef4e228f1b75n,
  r: -0xa154506009n
}, {
  a: 0xbe2a1b8af4257885a2ec4dden,
  b: -0x56f938004f28e49efab0f73359239a07a8677224fdc0a7a3f26f756baa4e52dded7n,
  r: -0x56f938004f28e49efab0f73359239a07a8677224fdc005024240352822045019201n
}, {
  a: 0xd07167e53ecb35f81233f0a5b7b50664d580cff6e32533c72bdf8d76a40a8616bfd7cn,
  b: -0x3e14cfa619908d62270f7b1d372b4280a76f94a61bn,
  r: -0x2e1082a6110081402403090007280080070e940203n
}, {
  a: 0x3122f372b09fae8a8922683434ff31573213e79dd647e0fbc570e8c5b1e4c3200n,
  b: 0x594e308a01d496d7n,
  r: 0x3122f372b09fae8a8922683434ff31573213e79dd647e0fbc5f4ebcdb1fdcb6d7n
}, {
  a: 0n,
  b: -0x84ba8712f780f25a8fdfbf9b71f423f96c638eb94e4694255ff140a6ee082edf750n,
  r: -0x84ba8712f780f25a8fdfbf9b71f423f96c638eb94e4694255ff140a6ee082edf750n
}, {
  a: -0xf60f402a88748a8fd49374c1390b0n,
  b: -0xen,
  r: -0xen
}, {
  a: 0x9d0a011ed432636c137e62a5bf28bn,
  b: 0x5352d73b3c5n,
  r: 0x9d0a011ed432636c137f72f7bf3cfn
}, {
  a: -0xb10db1ba1f528740f13b122392dd493242f06bea01n,
  b: 0xf3d505a060a936b96120ef36dn,
  r: -0xb10db1ba1f528740f002022190d5481040e0610801n
}, {
  a: -0x8f5ff1aceeefb011720f0a59091857ffcc450d1d0b4a6b60fn,
  b: -0xd84c2d4b208101d0ba5de9d38c0a801e34fb4e1014a090n,
  r: -0xd8080c4a20010100b0058091840a800410d1401004a00fn
}, {
  a: 0x7ab850217d283684933fb516e6432e64f2ce90bb6ab6fb9a9ede872812n,
  b: -0xbfbca573e8e03e0358f6404c6859cfe382f6421830fc45827f00n,
  r: -0x9e808541686000024810004008090163009440002060010056een
}, {
  a: -0xafbba5dn,
  b: 0n,
  r: -0xafbba5dn
}, {
  a: -0xc9d807269ed332155e8c5a91e7f0804ffa70459f480079an,
  b: -0x6n,
  r: -0x2n
}, {
  a: -0x3802a83a1da8172e85fa3319f887dc0b2c6n,
  b: -0x7eea50d6c253e954eb2cefde7ae0e2bn,
  r: -0x282a1080020281502308e8865800201n
}, {
  a: 0xe1025a715ec42aan,
  b: 0xe63f040f1b7b4bb8cf454n,
  r: 0xe63f04ef1b7b7bfecf6fen
}, {
  a: -0x468a73525d2bd03eden,
  b: -0xeae1d0f81ced447c41a79e53c08f05a4n,
  r: -0x440023125100800482n
}, {
  a: 0xbd8a08c3bf980n,
  b: 0x5c2fa1da0b9efeb39aa2a27624bbeb9b341c3b604527c529bf6f009f425dn,
  r: 0x5c2fa1da0b9efeb39aa2a27624bbeb9b341c3b604527c52bffef8cbffbddn
}, {
  a: -0xd74175b8ce5486e15b8fc429d2c8f205ff01432n,
  b: -0x87cb7986c342fcc1ae06443da37acb444d2f2784758beea6cc35n,
  r: -0xc4006020425006a01004c02050405004ea00431n
}, {
  a: 0xf72164215545b7a5ca3a2385cb7ad0ebfc510bae060d9dn,
  b: -0x464eb69626ad1137a1dd55e02e1e058b3655b56b6fab005n,
  r: -0x400ca09422a90005a15c55c0220800810010a5410f8b001n
}, {
  a: 0xf0abe80c1376d960a4cc90d2d96d91c2e1779n,
  b: -0xc3f66005affa8a7e6f56609dc39865dc37c1eddba1d3208n,
  r: -0xc3f66005af0a0016634400048318214c2500804a2112007n
}, {
  a: 0xa689514333623n,
  b: -0xcba1e8381adfe27dbb9cd9f4157fc2374b63251ba0n,
  r: -0xcba1e8381adfe27dbb9cd9f4157fc0174a6304099dn
}, {
  a: -0xa585b55a37418bf77e1c52fbf9955dn,
  b: -0xc083e48567f7c9c47b5f613d7952f36a2f063eb45n,
  r: -0x24840510360183952e1402f0618145n
}, {
  a: 0x270336874a4dbcd6908d6536n,
  b: 0x6cn,
  r: 0x270336874a4dbcd6908d657en
}, {
  a: 0xa0d7aca1056d408c8fd5194f765ba170909cc82c8can,
  b: -0x2fcf1672an,
  r: -0x230712722n
}, {
  a: -0xa428ea1211a3998d6c654c50925acc2948e9c2cn,
  b: -0xcf8d937fdf80bcan,
  r: -0x82088029488080an
}, {
  a: 0x1d4n,
  b: 0x67aac68fe01961181a9e84d947203d825367c443b5fdc8955a2a758aab935aen,
  r: 0x67aac68fe01961181a9e84d947203d825367c443b5fdc8955a2a758aab935fen
}, {
  a: 0x4cfa95383e1bd2c1536792180b8cb6812276n,
  b: 0x916a808148dd1020f43489b1d9077ca4c3b42d43375535886ac37d70b1a05e26cdn,
  r: 0x916a808148dd1020f43489b1d9077cecfbb53d7f3fd7f5db6fd37d7bbdb6df26ffn
}, {
  a: 0x16eced1c6eed960eada06f8513998814ce905n,
  b: 0xa1c35ea9b8bad61b0ab15b882548970c2eebfn,
  r: 0xb7efffbdfeffd61fafb17f8d37d99f1ceefbfn
}, {
  a: 0x492a9b7af5ffc2773a02581af43ce33e641a796e1f85b5f3625fc9ef2f6cn,
  b: 0x6935f58022a430c754bc2343d7c7deae52338af4015b84bef2094bf935e16b3een,
  r: 0x6935f592abb7bfdffcbf73e3f7c7ffefde33eef5a7dfe5fefb5f7ffdfdfffbfeen
}, {
  a: -0xc27c8d242de16bdf0abb9ddb6149083b8bcd4bb275e9247524458e29f7021030a3dn,
  b: -0x1646e9a3742a9a3af6a77bae803n,
  r: -0x1440202124008a28f6021020801n
}, {
  a: -0xb3a04en,
  b: -0xaa2a3259a012cfef0a01c44acdb0c5ca41ec34c86c28n,
  r: -0x802006n
}, {
  a: -0x434019f439d3bbb49bf659ff1ccdd7cc67de77b755a2ff4da3c5389b7478cban,
  b: 0xb76c50de8691b5f2e80fa1343b1bdc69n,
  r: -0x434019f439d3bbb49bf659ff1ccdd7c4011a721714a0a041230528984440091n
}, {
  a: 0x8744920e6bb72c426de48821c68fa7bafn,
  b: 0x97a2a7c9533fb0048947bbd7f115f9ea552fadfe237079fdc916b0b262n,
  r: 0x97a2a7c9533fb0048947bbd7f975f9eaf7bffffe27fe79ffdd7efafbefn
}, {
  a: 0n,
  b: 0xdbcc303a5e5d8ee6f56d319dd4fn,
  r: 0xdbcc303a5e5d8ee6f56d319dd4fn
}, {
  a: -0xd83e14d05599ac2f3a793be3n,
  b: -0xf41fn,
  r: -0x3003n
}, {
  a: 0xa04af7099c1cd878443n,
  b: 0xd46e1236a1f0d784239eb7d4353c5b740c0c4710fd455n,
  r: 0xd46e1236a1f0d784239eb7d435bc5bf70d9c5fd8fd457n
}, {
  a: -0x55715bf91n,
  b: -0x22e625949396a598a20f4b6d1n,
  r: -0x14b691n
}, {
  a: 0xd8ad7b0800c95bcee1e4a4227c16367fe3e3a9a4513dn,
  b: 0xc6082d5fd7e4dfaecf4cc4424967ab7b87f44fdea6cbd07aa70409792n,
  r: 0xc6082d5fd7e4dfaedffcc44eddffef7fcff66fdfe7effe7ebf9e4d7bfn
}, {
  a: 0x5637fc0fac1cdae7ad885d28016223389n,
  b: 0x678bceb88bfbd3d6b6582b83ce47a294b1666f714b7131beb5a06fffben,
  r: 0x678bceb88bfbd3d6b6582b83cf67ffd4fbe7efff7bf9b5feb5b66fffbfn
}, {
  a: 0xf7a9b67e1n,
  b: 0x5a7d5e99a184873df99a85bn,
  r: 0x5a7d5e99a18487fff9beffbn
}, {
  a: -0x1bb146bfc58b0n,
  b: -0x9bc926f9031bf2f64c9b7df99bb329bb77efn,
  r: -0x19b1029b850afn
}, {
  a: 0xb169e67c12ee51287ea3cn,
  b: -0x6663b7d769fb233522e7ef658a698b4d280e9e2e721466d9daaa21e85c5n,
  r: -0x6663b7d769fb233522e7ef658a698b4d280e9e0e121002c910aa01805c1n
}, {
  a: 0x2f5de16089c1ccda94ee6992808e0c6d97cbe418324918a9d8550n,
  b: -0x1f8229dbda986323593aacfcdd6ec5c5c584a1c4b7d8n,
  r: -0x382205290186203511a282481408444c10421403288n
}, {
  a: -0x4118707cd4e8100n,
  b: 0x7a2e909db124b8n,
  r: -0x4018107404e8048n
}, {
  a: 0x85ca92eb28ee2a6n,
  b: 0xbc34ddbc2e1e1113175c1256b6ee2f1b7bbfd30dn,
  r: 0xbc34ddbc2e1e1113175c1256befeaf3ffbbff3afn
}, {
  a: 0x2203d8634n,
  b: -0x3786bde2b28088cf788c1d733c6b9e02cfae023d4c4n,
  r: -0x3786bde2b28088cf788c1d733c6b9e02cf8c00250c4n
}, {
  a: 0x6148a197afff69c90bdfaafbc43d563b970c45253n,
  b: -0x4b5436e06704ff1n,
  r: -0x420004606300da1n
}, {
  a: 0x76b8de026e09c8965d86bb2dn,
  b: 0x4498a125fb6702ede0bddn,
  r: 0x76bcdf8a7e5ffef67fdebbfdn
}, {
  a: -0xab4f428ab8ad09193d4fae5c2b44dn,
  b: -0x332e74076f76a33b9a70cb2139265971n,
  r: -0xa3404282282109010c02021021041n
}, {
  a: 0xc97f18dbeb6168499ec1777d77bb89dfe1088n,
  b: -0x646687c77b6f4e5eaf55cd64793911f90df5106f17e2913018f35dfdbn,
  r: -0x646687c77b6f4e5eaf5504006120109805b4002e0082800010201cf53n
}, {
  a: -0x795e823642659678545f50ee8f2ec827f6d92d7fn,
  b: -0x8500369dbfn,
  r: -0x500100d3fn
}, {
  a: 0x11d1355c589555e2d0dbf9cd6f738fdfn,
  b: -0x222dfea9bf091365ba3fde7fcccef60a59cb15dc5a5c5261426c48n,
  r: -0x222dfea9bf091365ba3fde6e0ccaa202488a150c00041200006001n
}, {
  a: 0xa9414064eb4218a1652eb6d8n,
  b: 0x2c71622b25422718e3cbfbf680241739010e8353ebdf9n,
  r: 0x2c71622b25422718e3cbfbf694265fbd218e9753ebff9n
}, {
  a: -0xd89ca546066b3d764456c87a78055ff67b059fead9216aa85n,
  b: 0xe94fe4dfefab7b93938a5e934c2a1924b109c530f45006d0c48d185a7e826082en,
  r: -0x4814a144024124524456084a080559263b0087a081210a281n
}, {
  a: 0xe47f7dd842fcc5de553bc35901ba58ebdffa8f9c25720b34c5adn,
  b: 0xa858bn,
  r: 0xe47f7dd842fcc5de553bc35901ba58ebdffa8f9c25720b3ec5afn
}, {
  a: -0x2e2236ba1dea33db4a4a58f73n,
  b: -0x2c612b31b3aa4a3b51707082bd21ce3d08a03c374cf5b988bf5e7dbdn,
  r: -0x2028214ca13980a4040d31n
}, {
  a: -0xf7db30a6736f7787836ad6bf291a2c39a0f5936805n,
  b: 0n,
  r: -0xf7db30a6736f7787836ad6bf291a2c39a0f5936805n
}, {
  a: -0xc1aca924cbd441604a76375120c703f6bf3be881a02e349d5afeea0bf01e2d70cdn,
  b: 0x8992343b2c5be29dd8c7549f924b260465b54492ff504afb9fea2f1d64bd157664n,
  r: -0x402c8904c384016002302340208401f29a0aa801002e34044014c0029002280089n
}, {
  a: 0x52d31d7ae1f34e3cfd203c65193bb38e177679732e366a71n,
  b: -0x5a3affac8233718f7460abf3f920cca6n,
  r: -0x21ac3888200400160008280d1008485n
}, {
  a: -0x69148c4bd5c0145b94a26ae237a4b0f39e1647b7ce0a423966bb76b63ffcd5467n,
  b: 0xdd01fd833fe57679an,
  r: -0x69148c4bd5c0145b94a26ae237a4b0f39e1647b7ce0a423922ba0234001881065n
}, {
  a: 0xb32bbe699ad4818cf59f0a72f44n,
  b: 0xa2n,
  r: 0xb32bbe699ad4818cf59f0a72fe6n
}, {
  a: -0xe1378f953837f91b8b8n,
  b: -0xa1c24857af3a99318a188442578efdef5ca4dba969933430en,
  r: -0xe114849128219110006n
}, {
  a: -0x2d3e5bb93e653f9725f7187386e86082427d8c5691211a89f1bacbda6204bn,
  b: -0x5c146f797483bfcb52d98ab37f791bb718138594664b10767370b4371ff0f70ad07cc2n,
  r: -0x83a58b12c002b1725911871802840024031044611010201f10a408802041n
}, {
  a: -0x3b53b4ae4f2b3ba2694f0c10b0ca584348704e7dbf260228224685083cdc73b0dfcn,
  b: -0x4566802ee7b165870en,
  r: -0x4600002c58121050an
}, {
  a: -0x80f0d2e3eedeen,
  b: -0x19db7a2675daee37013327fn,
  r: -0x80e012012206dn
}, {
  a: 0x77ddfdbe3n,
  b: 0xadcd13eb543d53d82dd659a22a60dc846bn,
  r: 0xadcd13eb543d53d82dd659a22f7ddfdfebn
}, {
  a: -0xbeec144f02c3f5cc9bcn,
  b: 0xbf02e06c3bd865fabn,
  r: -0xbe40140f02c02588011n
}, {
  a: -0xcc53e02aa5569e12aab29f231f0bd7c08442ed37ec3db30b16n,
  b: 0xd8faf76492d7fbe2ad06c8c50d250c5cbc6d4ff7384f83ab43f9f4dn,
  r: -0x8812c00001540e1222a20d231a00110000006907c409800011n
}, {
  a: -0xa7e949904f7b5db579c618d032b4187eccafd28cb4a242c61e20ef981d8cf4e4en,
  b: 0xdeb70bdea10c78fb25791de029561662041303483601870bn,
  r: -0xa7e949904f7b5db57004084010a418704ca84200b42202801e20cf881c8ce4845n
}, {
  a: -0x87fc1eb5a519f797ccn,
  b: 0xdc5fecfc86d03be1ce81cn,
  r: -0x1301690a401e317c4n
}, {
  a: 0x4350c37069c3384e74916844d55ed91842d60d76b78369ad09335n,
  b: -0x2d64319125360b2ba6311b1c18e5661b532aaf1c0b6n,
  r: -0x2c44318124160b2aa020031c08e0000850020214081n
}, {
  a: 0x48c3ac649f5b1149847d7d5fe3bba5710a88da89364769120d4ca5f6ec3759n,
  b: -0xaeee8a5cba5300dbb12a3240e2a66f07c99n,
  r: -0x4a88a543253009b812a120020a00104881n
}, {
  a: -0x5b1e5b6e564f2f878b8d1493fa9019fn,
  b: 0xa70cedc2c98f7c6d9007682694e5f131cbc86db6586e79a6c57c8284ed9a78a8en,
  r: -0x1312492610060902830d10126080111n
}, {
  a: 0x9c631760d98322eb3d21852cc50debc4c230af090c9007bbf81d16770b00fe3c0029n,
  b: -0x264c773e36f53b5c81efca8a982775f0f6c1bad3f33cf011f0n,
  r: -0x648533a32143b1c8140c28208204400e2c188d0f300c011c7n
}, {
  a: 0xa08a2877885f8e7a536ac39553e28778917c2e53c796ebad5fc8bf8bc9d0b3338en,
  b: -0x2d505faab3051c5ea0f08eee3c3650n,
  r: -0x1001828100000160070062e0c0442n
}, {
  a: -0xe2c2b47b2e5b91fffee722db858178d62f34b79e656b6n,
  b: 0x96db062c229ab91cac4b677a1e972ab131d0a749cc49f0n,
  r: -0x82429439065000353a41005a048150c42234830221606n
}, {
  a: 0x63f689271dd63a0f2f699401b8bc4304c1f080df0e81565b600d1c7ba89848a76e3347n,
  b: -0x147e7095ea4501b17472534235382n,
  r: -0x146a1001ea0400017472510014081n
}, {
  a: 0x3bfcd6afa46c1b236051e4387d634c24c0f8fe9cec08fb026b9cfd30d96ef0f8n,
  b: 0x48e1df1b86c98804db522e322c00cab2cda79d58aa36c5efc70n,
  r: 0x3bfcd6afa46c1faf7df1fc7cfde34db5e2fbfedcecabffda7bddffb3fd7efcf8n
}, {
  a: -0x81c2c7d5699a7790b802206efb4abb7b25n,
  b: -0x807d5n,
  r: -0x80305n
}, {
  a: -0x8eeb0cf2d11dad754432399c608f77e1ad2cc97249387c100d883329ce92n,
  b: 0x874fdfad7904da54f2da86cde6ce12a5e27784f8a69b3n,
  r: -0x8eeb0cf2d11dad7500020108608252a08004812001185400088030218601n
}, {
  a: 0x69b1d88d0cd496f6e2a1n,
  b: -0x9332d6ccb885b3e4e2060c8c629d0n,
  r: -0x9332d6ccb804a264220204800094fn
}, {
  a: 0x5d72dfa7f35a09e379dcd73621227909n,
  b: 0xdc483287790398417a5bc111bd7662cb3f93fa24ae2f9b4f33db3c46n,
  r: 0xdc483287790398417a5bc111fd76ffefffdbfbe7ffffdf7f33fb7d4fn
}, {
  a: 0x84e70927d5f670a3b2dfb869665c2a78523086fd07fbb5e0d81de257bcc50n,
  b: 0xc881c736f275fd3bdbf6655e715ec9bcf5528cd0n,
  r: 0x84e70927d5f670a3b2dfbce97e7f6f7f5ff3bfff67fff7f5fc9fef57bccd0n
}, {
  a: 0xc1e511e05fc772e7003bea784e408cd9n,
  b: 0xf885e9abe23f3749a778c491805f118b4bn,
  r: 0xf8c5edbbe27ff77be778fffbf85f518fdbn
}, {
  a: -0x2863dfcf936n,
  b: -0x94dn,
  r: -0x905n
}, {
  a: -0x792fn,
  b: -0xb8358792c8n,
  r: -0x1007n
}, {
  a: 0xb134d6d1175e8e4ea64f8c09c8d5a6f0f8ead7b3b1cac068c32380n,
  b: 0x9107018d33a8741n,
  r: 0xb134d6d1175e8e4ea64f8c09c8d5a6f0f8ead7bbb1fad8fbfba7c1n
}, {
  a: -0xb8171fb318395ad53715n,
  b: 0x32f28ceaf28b0529dca5a7270d9721e99c79908fa59163654557de2753n,
  r: -0x30120e90183808011005n
}, {
  a: 0xc730cfcf9ff4442d1e1750e738bf56dc2ab1a2229dcd28162bdn,
  b: -0x9cd6fbffcea3117n,
  r: -0x1cd46232c6a1103n
}, {
  a: 0x37ee81fd2d77d172526727d936n,
  b: -0x646df45fn,
  r: -0x482449n
}, {
  a: -0xbfce0a9fe5a7cafc8b136dean,
  b: 0xeb5e4a7d7n,
  r: -0xbfce0a9fe5a7caf00a134829n
}, {
  a: -0x241ce870bb4bfdf56e377a0a8a351d3ac29f0a58d67d531den,
  b: 0xae3a09fc2127e0e35d7ed79ad3ffb22ca864e7f8e899n,
  r: -0x241ce0101b403de500314a0802041000009d0058900051145n
}, {
  a: 0x90319fb682d6a5605212ff307b6145ac7702f96a7a445f35n,
  b: -0xfdc5d72de46a72b1182c39176eb4c258060d1d3d1cabcd06743431f105ac2109ad1n,
  r: -0xfdc5d72de46a72b1182438060494c21000081c100ca84902243001d0010801080c1n
}, {
  a: 0xb4c5db63e78c5727369b040c0fccb8fbf0811cd27638eb258c79c1b982cbeb040n,
  b: -0xd9834edde53c59a9b364361d881d1f77ab865431b0cbea9c102e37c0cn,
  r: -0x180308d8c12459a1b0200604081c03258986141030822a04102414c0cn
}, {
  a: -0xeea0c7c58ed27f54401f5f0a76526fb71d763beedb2629c55c1d9e9f1b5997n,
  b: 0x758a6dc0bn,
  r: -0xeea0c7c58ed27f54401f5f0a76526fb71d763beedb2629c55c1d9887190195n
}, {
  a: -0xb7a57e34b98b42c8cd5d605dfbb07n,
  b: 0xf7703f7d742fbf476bd4d8741fd983276cf44879n,
  r: -0x4010800b0080200454d0010bb307n
}, {
  a: 0x3d2535acb31333c4aa3n,
  b: 0xf359b87fa89f7129c405e5212940316213cf5a055631fn,
  r: 0xf359b87fa89f7129c405e521297d3577bfff5b37d6bbfn
}, {
  a: 0x2df3e3bdf1bca76703dff91cf49a103e202426502127a38732b40a2d3f6n,
  b: 0x9fcc0c53194415a7b62bb9f3dac117b6ab3142c79327bd9fa5af131232bacd04f2a5n,
  r: 0x9fcc0c531bdf3fbfff3bfbf7fafdffb7ef79e3c7f327ffffa7bf7b3a73bbcda6f3f7n
}, {
  a: -0x2b1c64213e6b814b8fen,
  b: 0x65955e0ee25a579db1eb9n,
  r: -0x2a0060012428004a045n
}, {
  a: 0x8dbc86b0b77170n,
  b: -0xe0c742340ac9b51077c75b291baf7f6a7bf229c0445fe9d9b1a0594f5e3bc3n,
  r: -0xe0c742340ac9b51077c75b291baf7f6a7bf229c0445fe9d93000594f480a83n
}, {
  a: 0x17410186816f31179dn,
  b: -0x77800d8f5d04a31ab75420fec636bcf834383861822ece673be61599820bd62539n,
  r: -0x77800d8f5d04a31ab75420fec636bcf834383861822ece6728a614190200c62021n
}, {
  a: -0xb860c7160243d7e994e00b42d9f3ad93292cc3f058aac0bb9bn,
  b: 0xeec75dba60f838aaf3f0d36a6728901a1ce805cced70ca94d02fn,
  r: -0x382045160243550804200100d163a583012803100820402b91n
}, {
  a: -0x663fe9233075e18c5a83dfc992b3dfn,
  b: -0x7dd218276ecf121745c43e38d1can,
  r: -0x3dc0002064c1001201c4081091c9n
}, {
  a: -0x3d0n,
  b: 0x5f60bc55e66650339023bfc9bd4b41befb5d2e136966dbc01848f9df6dfn,
  r: -0x101n
}, {
  a: 0xee137cd924n,
  b: 0xbba66e99856fdee27adb258a49d824b91cn,
  r: 0xbba66e99856fdee27adb258aefdb7cf93cn
}, {
  a: -0xf64947524a83ee13fb646787a6ed9688a6a5f64b34a9785ecbn,
  b: -0xdd0a87121def35fn,
  r: -0x5d008302158524bn
}, {
  a: 0xfa4f1ec2e51855eacn,
  b: -0x6f90e7d9f3bb5c6d4bcca898546n,
  r: -0x6f90e7d9f30110610908a088142n
}, {
  a: 0x60a1686b877cn,
  b: -0x97b5213bd0d06438aad343b9d1e99bd2899f39c3f3df0685dn,
  r: -0x97b5213bd0d06438aad343b9d1e99bd2899f39c1e15906801n
}, {
  a: -0xe988f05b77bf2975882bbben,
  b: -0x9a6ba7a4f10dn,
  r: -0x92030080b10dn
}, {
  a: -0xee98fcbb934a88479d66110fa6ea050a4b624fcbfd6538629dan,
  b: 0xe60874c86f7ec816e70f3c03769a790f3938ddn,
  r: -0xee98fcbb934a800718221108026a010a0822488258650860101n
}, {
  a: 0x1d7281dc555fd4685b4675250ab0b34eaa2n,
  b: 0x36dc7a2bb4bn,
  r: 0x1d7281dc555fd4685b4675253efcfb6fbebn
}, {
  a: 0xef93a1c957dc5f8cae1f59c0a47e25c957ef25bc5db8d1586efe69f830c6n,
  b: 0x5e9bef8f3642434769b22db95b0e7a1b72303c85f02358a8bdec6e680b8dc3fbfe8fn,
  r: 0x5e9bef8fffd3e3cf7ffe7fbdff1f7bdbf67e3dcdf7ef7dbcfdfcff786fffebfbfecfn
}, {
  a: 0x662d7bdf53443d550bd04110739a2a681170d31a91b490b3n,
  b: 0x58d4342295bcb78dd193570c3e89d9914ddade2de44b13f7b2n,
  r: 0x58f63d7bdffff7bdd59bd74d3efbdbbb6ddbfefffedbb7f7b3n
}, {
  a: 0xfec5a2fa2aac74bb9fb72478d347ee04b53f7227615c6c6671ecn,
  b: 0n,
  r: 0xfec5a2fa2aac74bb9fb72478d347ee04b53f7227615c6c6671ecn
}, {
  a: -0xdcf8fb61n,
  b: -0x96810283ba055b9fd23c6092f7cad18cen,
  r: -0x5ca81841n
}, {
  a: 0xfec7b82b9f0ea61104b4dd6541f0ca34d18e35a0172681272a22bccee088649a108c7n,
  b: -0x56eeb7ab3292f7354b15f1a3939ffd111612a86deab53f0168fn,
  r: -0x422292aa0210c324410051a0911ed8111402200d62912501609n
}, {
  a: -0x779e3e80dfc1f9074be4ce83b3efb487406d644b02a657f3dec787c151dd32ba3480n,
  b: -0xe0bc9a12cn,
  r: -0xc0288202cn
}, {
  a: 0x7f323ebb592019e2c4afc0e4eaa9545689117cba0052n,
  b: -0xdc57e3a4b98c2cn,
  r: -0x8856e280018c2an
}, {
  a: -0x782104n,
  b: -0x7cn,
  r: -0x4n
}, {
  a: -0xf5f4e1846f7a6f18n,
  b: 0x2a82626442d78n,
  r: -0xf5f44180493a4208n
}, {
  a: -0xaff00bedc1ade855f624e4c536d97c1118f86066f5be22c632ee330288313n,
  b: 0xb1a7c9f607f480c0e9655840d47fc42c4e8fdb539c646161bn,
  r: -0xaff00bedc1ad48503600e0013619141000b820003192204020ac230288101n
}, {
  a: 0xc7156547875ff953824e91056274f8effb3776ca3f5674b963f85529200d121een,
  b: -0x1151c2n,
  r: -0x5002n
}, {
  a: -0xccf4a002a625ac7cdabf9b0bd38261n,
  b: 0xbc59940614294637bef2bcc3ed702e5bb2ef559491d3c0858ce9b0dfdn,
  r: -0xcc1000000224a460c2b78301408201n
}, {
  a: 0x802d114f63086ed08851d857d0a9e552n,
  b: -0x748d494038b411601ac9acff75811242bb56296d29bn,
  r: -0x748d494038b411200a098c79108112423a022161289n
}, {
  a: 0xb34cd50a1b5b1408312d3911c985c859743dea24a47d903f69ben,
  b: 0x1n,
  r: 0xb34cd50a1b5b1408312d3911c985c859743dea24a47d903f69bfn
}, {
  a: -0x74a75a1e5004bn,
  b: -0x63ec789b08537fd5a345d94fb66f4a70e73e685d8d694a4e89c9n,
  r: -0x5086100440049n
}, {
  a: -0x6d7724fd62288e192d1c149350f6f277cb58n,
  b: 0x49n,
  r: -0x6d7724fd62288e192d1c149350f6f277cb17n
}, {
  a: -0xee68b31ad11bf2n,
  b: 0xc4de309075b186ccffc523n,
  r: -0x8a483112001ad1n
}, {
  a: -0xe8c5cc6e1460d969f7bf5a1eec64d547b0b80f3f5f30a7a98715n,
  b: 0x8092e68777af2f5fee866fffd6e3d6c32an,
  r: -0xe8c5cc6e1460d969f73f481868005040a0100910002004290415n
}, {
  a: 0x12cb3eda097f65780n,
  b: -0x99823eb62718fa8d51312288c7f5077f03n,
  r: -0x99823eb62718fa8d501100004760012803n
}, {
  a: -0x3a56f4e928312f2439cd6f5b5f91a0bfa8278d9b524cef8a4f1n,
  b: 0xd2f3698632e0ec3156c792f4bef8bc167ce31e8f7c94509257bn,
  r: -0x280494690811030429086d0b410100a9800481100248af08081n
}, {
  a: -0x12d6a27a036a00e9283ff8106dcd72644a7c2c422c4bdd9826e218bn,
  b: 0x6dd4e407780acce9f147c813304022a5846n,
  r: -0x12d6a27a036a00e9283f900009c8026402140c002448cd980442189n
}, {
  a: -0x8baff4f9a3f824011bb6f3d59bf900ae0bd6f9cc1a92f5e7137ae01ec052cf3n,
  b: 0x46c924cf8ced53f8dd871300f7b41ea3b3b3n,
  r: -0x8baff4f9a3f824011bb6f3d59bf9002c03063108001225860370801e0040c41n
}, {
  a: -0xfbea93f572393f4f65c386c9795ab718a5efe5158bb5fa1d7d07066901545c3e04c62n,
  b: 0x60c709c3ab02dc0db20e0b1c510c0b2937d91c69a608406de9df3d92218een,
  r: -0xfbea93f51238360c44c102c04950b400a4e3e4148824e214590706000000402c04402n
}, {
  a: -0x91e1ebb16767cdc226f9671n,
  b: -0x56ea5e2ea7329b4ddc0ad61e49cccff532240d5ad5675c77bafbbdn,
  r: -0x11204091254645c222a9231n
}, {
  a: 0x899e258d31bfa22cd388116a983e204983db6a2c1369n,
  b: 0x301eff6bd1987831780997cbeffc745ef562b6753f819e5c9b1e0d7954aa725ce4cn,
  r: 0x301eff6bd1987831780997cbfffe7cdffffab6fd3f819efd9bfe0df97dbef2ddf6dn
}, {
  a: 0x30b51eebe5640ff2n,
  b: -0x96fd6da6ebf03334f411f2c82a080517eb425482635c36d3ccd770b4fb8bf9e8fe7n,
  r: -0x96fd6da6ebf03334f411f2c82a080517eb425482635c36d3ccd470a41101a9a8005n
}, {
  a: -0xf3da69fe4f6ab2e922b33c73d7cac37cf73b56a0ea727676246137e574bn,
  b: -0x66c841b226b5a844f63bacb45f0c276652n,
  r: -0x6488018222b52804a62324204600264641n
}, {
  a: 0xc78518a10n,
  b: -0x2bf0cb7b5e9af2f29c0b7eeb9f2a6656c19c047a40235f1e9b156n,
  r: -0x2bf0cb7b5e9af2f29c0b7eeb9f2a6656c19c047a4023181a83146n
}, {
  a: -0x6ea24c3a045eb270ca415f8764ec3ac498b53df8228788142c34f3b788a2a32n,
  b: -0xc74e9abed07257488362a4e58caad79aca6224b2e20d6dce358b3b40e759ef063n,
  r: -0x4e820c10005600004200458420c41ac0002430e000058814083040a708a2021n
}, {
  a: -0x1b760cfab217a9d86a75179aceca2f3d703d6f6a1aa1655341180152073c7c5518n,
  b: -0x96bb35f482c3184b9aa6e148be85876cac8n,
  r: -0x960314f4808210411000800020018744008n
}, {
  a: -0xcbe0ac16bf93e7a216c0f79eec2d2cd7da54da5240ba0355c917a4f35ba67n,
  b: -0xf998816145e78644n,
  r: -0x3118816045258243n
}, {
  a: -0xa076cc28390f82d194ba8a04b67baa1796a8795874c342n,
  b: -0x1b2084e0bc8d3n,
  r: -0xa0084800c041n
}, {
  a: -0x9ff5955b94f8877d6fe1d8en,
  b: 0xebc39cfa9e3bf64c0cf7acd3b9fa6651edf1140facn,
  r: -0x85308440109881206ea1002n
}, {
  a: 0xd8828a1f03b250cba093e2ac66fde3b99761a360c54a8a06c384c245d28137cfn,
  b: -0x8d9dd61fb8fd2f3d60914e64200d8139a279b9849ed6d6bab85ff82ea2d8069n,
  r: -0x595560f80d823056081442000018020806189808a5656928013d82282c8021n
}, {
  a: 0x214fed6f0d5bb2e361cae8dfbn,
  b: -0x244f70ccdaf035ac3b1b62834c972eb610n,
  r: -0x244f70ccd8e001280b0a40814883003205n
}, {
  a: -0x18b873328ca62e23d1667359dfbdb3f861ae1e8dd23cd677b5e33c5bn,
  b: -0xfe8470fb435bd5cf4af730bea1e5b00a45b28b4fen,
  r: -0x3c046031015bd10f021220a881218002411203459n
}, {
  a: -0xf6f37aec326829e2ce575ae190f2af1b1f253f6ec5c1256dc4a242caf336a5bb6d5fn,
  b: 0xe74accbbee76e52015756ca71en,
  r: -0xf6f37aec326829e2ce575ae190f2af1b1f253f6ec50025214400000ad32280934841n
}, {
  a: 0xcd09e60339ad9cecc39965910b97n,
  b: 0xd05dbn,
  r: 0xcd09e60339ad9cecc399659d0fdfn
}, {
  a: -0xe73cef38af5250b46c0d5cb51cb1a67n,
  b: -0xb5692ae4ab11160d0e467e97c662891e5b6e326610ffa740n,
  r: -0xe424e938260010a4240104210cb0227n
}, {
  a: 0xcbe424c705886f83a835dd2e29973281472737c9d07b4a52n,
  b: 0x11dfd90f3ac37dc1c836d964c171c73a2831ed30n,
  r: 0xcbe424c715dfff8fbaf7fdefe9b7fbe5c777f7fbf87bef72n
}, {
  a: 0x491da02882ea883e4685cabf6ecd444057632f7dc124f37n,
  b: 0xf452417f0705363e360c81e6125n,
  r: 0x491da02882ea883e4685feff6fff4745777f3f7dc1e6f37n
}, {
  a: -0xef0dccf1e0873b98ed7f03de9742b49dc6n,
  b: 0xb67e91b0f2aa077deb9a253fcf40923cd722914b9f05ed3ff1cf287an,
  r: -0xc0008c61c0001908a46002128002309586n
}, {
  a: -0xe533560564e721f4n,
  b: 0x29eebca8241317568e2207c3aa5fa15f0fb4313449d4b37535d188fn,
  r: -0xa122140024a22171n
}, {
  a: -0x7b904703bbf0n,
  b: -0x6fn,
  r: -0x6fn
}, {
  a: 0x20614051027d15d2c1ccaecd2n,
  b: 0xd6f0a3459135n,
  r: 0x20614051027d1dffcbfcffdf7n
}, {
  a: 0xc129a3fe61951c18aan,
  b: -0x73fn,
  r: -0x715n
}, {
  a: 0x82e519f01d060e3a841147dde76a4aa68f5369645ae45ban,
  b: 0x3e16cca0a0358cc2e4957fc441f965a173dd6776c6788d80b846c319335aa8dn,
  r: 0x3e16cca0a0358cc2e6f57ff45dff6fbbf7dd67ffe77acfa6bf57eb7d7bfefbfn
}, {
  a: 0x13de42fc79ea07f097a41b7d2653bd29291cfd3d3fen,
  b: -0xbe04c8775c743b886cc0e1d7372497ea35f29e1de12f6a820ba4af0279fn,
  r: -0xbe04c8775c743b886c00a1030604900a20528400c12c428202a00202401n
}, {
  a: 0x2bd4a0b4329a43325dn,
  b: -0xe76d32eccbdee3a515f1c6bc6f3an,
  r: -0xe76d32eccbd4230501c144bc4d21n
}, {
  a: -0x582253d21080cb0cadn,
  b: -0x35998a93428f183b25n,
  r: -0x100002920080080825n
}, {
  a: 0x8aa4a2497c5cf1544ef6f6d78e0b38a1d8605d1fb85f929605c5cca492913a43n,
  b: -0x2f273157d80f4f9958d3a2c3a4d1e95cbc1d8ac551af4669d44d3641c99b95an,
  r: -0x525114018004a99109082830440614038180a045006460980013400c088119n
}, {
  a: 0xad500f5a0c076b3567ce0n,
  b: 0xf1bd9ea586f507b765ae27c0726e99cbdba838d4e18780363ef81e567a625n,
  r: 0xf1bd9ea586f507b765ae27c0726e99cbdba838d4edd78f7e3eff7f777fee5n
}, {
  a: -0x1daa0466e41ecc1n,
  b: 0x2841fc5b32e3de5eaf27e3330dc13ef711bf5b99c68n,
  r: -0x1080440a406081n
}, {
  a: -0xf8e5140cf90ec073fb84973fdd652c28ff5f3n,
  b: 0x6b839ef238cde97c8206563760a3e84bf21e548f8aab9520a349n,
  r: -0x30c5100c8904c0734084123705450428f54b3n
}, {
  a: 0x216e5d55f045ee39e7d1a02e3ad3db063ff8d1a625e6c891acc31c35340b4n,
  b: 0x2a5b94d33fd79eecf8d6cb4fe65cfbc20a0d41630f52n,
  r: 0x216e5d55f045ee39e7f5b96f3bfffbeefffdfdb6ffe7cfbdace3dc3734ff6n
}, {
  a: -0xe0d133af156n,
  b: 0xbc10bae044ef23152d9n,
  r: -0xa01010aa105n
}, {
  a: 0x719ea77070534c6eba7n,
  b: 0xbbaa86df96537c7e45254b5416aaa10a15779df7bf960d1n,
  r: 0xbbaa86df96537c7e45254b5416aaf19eb777fdf7fffebf7n
}, {
  a: 0x8007dd5cf2c0f4fc62b587ba59bdd278en,
  b: -0x8f57569309a7a70ee82829n,
  r: -0x8010109001840204200821n
}, {
  a: 0xaaf90de3203f55b8ad78e931d35f29d510ec631243n,
  b: 0xd19e7f375e931afd133n,
  r: 0xaaf90de3203f55b8ad78e93ddbfffbf5f9fdefd373n
}, {
  a: 0x15e4e8410e49bce1b74835bbb98cn,
  b: 0xd4940395f6543c1f43e16534061397326b52186c8a2aa909993f6bb4a2a3n,
  r: 0xd4940395f6543c1f43e16534061397327ff6f86d8e6bbde9bf7f7fbfbbafn
}, {
  a: 0x76277cb52b2e47c9c93n,
  b: -0x167d3869a64510932f88d9an,
  r: -0x167d0848824010912800109n
}, {
  a: 0xe467fe31ad732aeee2499c04d97c42975f5c3dcfb6862976bd68416e6n,
  b: -0x69b354d8f730350a6655d08901cdf915cc11918n,
  r: -0x20235000833020002240100901c489008410912n
}, {
  a: -0xb756e193022d6n,
  b: 0x9a005d5af5179b669bb042745eae5909bd6ea3e81003903f1fn,
  r: -0x8156e182000c1n
}, {
  a: -0x385782423a0484fe5fe3550ad7ab1b5999n,
  b: -0xe4n,
  r: -0x81n
}, {
  a: -0xd3d6ac42dd271180bf27138eab14b3bc204501fa7c0e7a054c2a32a7b9c929bdn,
  b: 0xd5a5c48a4f446e47ed2dbac13594a3n,
  r: -0xd3d6ac42dd271180bf27138eab14b3bc2000003a74003a010802120538c8291dn
}, {
  a: -0xb494an,
  b: -0x21624be566aeb8bf9652a0c6007fd0f2989cc1fdbef822d38322bn,
  r: -0x80009n
}, {
  a: 0x22n,
  b: -0x3023dbe7dff571cc3343ab9a218bccf8d92481c36bc71d9bd17ebcb2c7n,
  r: -0x3023dbe7dff571cc3343ab9a218bccf8d92481c36bc71d9bd17ebcb2c5n
}, {
  a: 0x29n,
  b: -0xcad5dn,
  r: -0xcad55n
}, {
  a: 0x6c29ecc02f32dbab7b2105d65ed5e869f8022eea374ba213a8627e853e7283n,
  b: -0x3e3cff07d1cf253dbdb9c01d4b0aan,
  r: -0x3e1c1104814504053998000c08029n
}, {
  a: 0x96a08331e402848b7163aef989cffe767aaa687a336786eafe1n,
  b: -0x3f181d42a12b8en,
  r: -0x3818090281000dn
}, {
  a: 0x9d7d2431b05d94d1b8633c7495d6dcfbeb4n,
  b: -0x9631e6c79d3b0d90672c4ea564a21b98a6c74f6cd0dc6c589bcn,
  r: -0x9631e6c79d3b0d9062004a8444a20b08068443084008200010cn
}, {
  a: 0x24b25cf1eb11cbb8f89ce3n,
  b: 0xe2ced1d06525c4df98396b4691287661fc40bdcddb4fc31cf3n,
  r: 0xe2ced1d06525c4df98396b46912876f3fcf1ffdddbfffb9cf3n
}, {
  a: 0xa23d3f299a24fd7e33017524bbd5c3cfbef4n,
  b: 0x2ec1d695df5ce27ee43392ca2787b9f0501ad979fb2a4d92437ed751n,
  r: 0x2ec1d695df5ce27ee433b2ff3fafbbf4fd7efb79ff2effd7c3fffff5n
}, {
  a: -0x1217ed23aa1f9edcb58f7d55dd7aa8eaan,
  b: -0x51a38261b36f5b24720e5ff6ac403efb0d3c3an,
  r: -0x2132421a20700c4b50a4401cd3080c2an
}, {
  a: 0x9024a36064849060b87670ce49d43c486d1ac88007b0680can,
  b: -0x23c1a9b1805fcd9670908472982cb8e8ab4779c22f92942c24b78d5d2n,
  r: -0x23c1a9b1005b4c961010041200088820a20341820280142c200785512n
}, {
  a: -0x30ebe27efb0367daf9eb37d97d34b76an,
  b: 0x227f3015b696c634508be4c7d7dc20n,
  r: -0x30c9804eea016118c9ab34193820234an
}, {
  a: 0x71dff2148d4b9c24c1a4dc2ec3083da20123e7b8f37f0327c7db9bbb0539c08368a20n,
  b: 0xd5ad72540c7109fabff7cede5e6d3fe4da65c2c58ce425957fa7983354n,
  r: 0x71dff2148d4fdef7e5e4df3edfabfffeede7e7fbff7fa77fefdbdffb5d7ffafbebb74n
}, {
  a: -0x2c4e36ac386a87d308ea5866ffce1942d9fc19c48518n,
  b: -0x7bb644db98a349f9ddbd31d3ad97041e455an,
  r: -0x382204d308a24860dd8c1142899400040512n
}, {
  a: -0xff87b56c681a562f0262d356be5ce53f45393ecf3ef50ff45eb269b7b729de7e47n,
  b: -0xc946558285565baed21d6028d40162b1990fee67b259bb168d5ec6181f54d03cn,
  r: -0x8104440000560b024211402854012201190ece26b009b0168048861009545003n
}, {
  a: -0xc563f99307aa8f817cd22d5acbf3202f82a5f3790237d5c7061n,
  b: 0x39027b6bb901c962n,
  r: -0xc563f99307aa8f817cd22d5acbf3202f82a46358000445c3001n
}, {
  a: -0xd9288c99ban,
  b: 0x15eddd88cbn,
  r: -0xc800001131n
}, {
  a: 0x24ba3861d248b93434e223a2878d7a89d546en,
  b: 0xefb52661b43372d8324f160a84e50c5ed46fcdff8f3fb5874061f22eb997cc2n,
  r: 0xefb52661b43372d8324f160a84e5be7ef5ffcdffbf3ff7a7e2e7ff7eb9d7ceen
}, {
  a: 0x75fb3d7e7fn,
  b: 0x8a091219899bn,
  r: 0x8a7dfb3dffffn
}, {
  a: 0x71c32e15d7557b737886230e179f2926432466e67baf8c14en,
  b: -0x46b4e4f11487f53be011923fdb91a223c0513fa5ea7n,
  r: -0x4220a08004877118e0000016d990820100001021ea1n
}, {
  a: 0xe9a8ff60a59a92e5431db42cf78086fc5d74b4d02ef0b86cn,
  b: 0x53a473576d148b050fde7c985081f32050cfa6752e799n,
  r: 0xe9adff67b5fed3edf35dfdefff858eff7f75bcfa6ff2fffdn
}, {
  a: 0xb2cad0cf2c13ec8c061d448279236343cce6n,
  b: -0x67d7af25d3bf3b40a9d5faa67f27756db0e5394n,
  r: -0x67d48300d30d3a4021159a223700654980c1312n
}, {
  a: 0x9d67f91abce82bcf87fcd75c2n,
  b: 0x9312082cb737c9d3ba8a5c5fb5cdbcdca976d3fb189ea65b9c3c7b6d58e953ca522b5n,
  r: 0x9312082cb737c9d3ba8a5c5fb5cdbcdca976d3fb189ebf7ffd3effed7befd7fed77f7n
}, {
  a: 0x7304368812a8f3248ce45c8148cae78c3897419704647672b5e17b9ad94019e3fn,
  b: -0x81954095bb97f22555e4fc0f9142d3cfe6da3ebn,
  r: -0x11040852896602111808c0a10004106a6c21c1n
}, {
  a: -0xcc5b0f77e463fa1aef5bc250901c8f9b09723d7da6ccc07ffdf0f3f82n,
  b: 0x21b574ead0808678bd0aea8750990f2e8fa0aec27f0n,
  r: -0xcc5b0f77e463fa1a4a0b0000101887020110382d26c0c0705d5031802n
}, {
  a: -0xa3e655b3dd2eb3d58f6c10b5a79n,
  b: 0x9dn,
  r: -0xa3e655b3dd2eb3d58f6c10b5a61n
}, {
  a: 0x6c41fc7c6bcea67f9478072fd1cbb2c93568364c86f6896f1n,
  b: -0x9823efcee89660aba071db9255ba15f7af202n,
  r: -0x18006b86e89020200030ca9241b2110126001n
}, {
  a: 0x323e9109735f265e08760d202d7n,
  b: 0xb328e69b2a9a0cn,
  r: 0x323e9109735f2f7e8e7fbfa9adfn
}, {
  a: 0x424251n,
  b: 0x1ef49888fa0abf4327b3n,
  r: 0x1ef49888fa0abf4367f3n
}, {
  a: -0x80b88156b20efa5fdb6f5df8dfa18an,
  b: -0xec70fc0c001n,
  r: -0xe4508c08001n
}, {
  a: -0xe624fe2cd9c4223b6a9d0n,
  b: 0xf57656ffac90b5332a86abde63071cc94684719cf636f94dd2b29f0697an,
  r: -0x6200c8049004002068086n
}, {
  a: -0xa8d44be291336f06n,
  b: 0xde26fe61d6cdbd5c409763b2d89aa8dbff9ff3a0n,
  r: -0x2044432000200c06n
}, {
  a: 0xd0add0b8c5a9096c424ce680a6bc535466f693cfbb25b32109a1c4n,
  b: 0x4840f9f15405493019751b08f8421f97a7a7445a6cfc61db1da9af846fa2n,
  r: 0x4840f9f1fdd5f9f5b97d7f4afce69fb7bff7547efeffeffb3dbbaf8defe6n
}, {
  a: 0x186fa78a80aa659479n,
  b: -0x9n,
  r: -0x1n
}, {
  a: -0xd16b043bc211e938016e7edb9088ce7404931561n,
  b: -0x63a537f0756f491n,
  r: -0x8427404121401n
}, {
  a: -0x324f237596dcb8f3d54af80015338d131a53ba9e0621e422107874193n,
  b: -0x36719f1cf5078886c014940acf9ceaf1bn,
  r: -0x14318d101003888600008402001860113n
}, {
  a: -0xcbdn,
  b: -0xa294dbc68f61d1d680589f87ab1n,
  r: -0x8b1n
}, {
  a: -0x3b6e7564c88329677992bf6n,
  b: 0xben,
  r: -0x3b6e7564c88329677992b42n
}, {
  a: -0x9d7001n,
  b: 0xf4bbf79f5dfaf8ef76a80561679ef869a56bf61378892eaa6e2ccce2c9bcfan,
  r: -0x144001n
}, {
  a: -0x315fe9c95f4a0422f559eabd6fd06b4017274a05d45a0af9n,
  b: -0xa0191fd91833bb67748c586a2cc49ff80d57548033fb103f0fe1n,
  r: -0x115908011b420400504828840fd0094014000201101a0ae1n
}, {
  a: 0x246e92fd9d6edbabd831n,
  b: 0xd6f5fa96e54bd6481f53fe8d0b411bccc5658fn,
  r: 0xd6f5fa96e54bd6481f77fe9fffdd7fdfeffdbfn
}, {
  a: 0x7444n,
  b: 0x35ae21874f7feef06f567c2ab99cf1155cf5d7f9bf818f72e33decaacddfa80a366ben,
  r: 0x35ae21874f7feef06f567c2ab99cf1155cf5d7f9bf818f72e33decaacddfa80a376fen
}, {
  a: -0xedb91039a377fb659ecd6741f9857e5ac489a63af6dn,
  b: -0x17413ffe832be0a57en,
  r: -0x104125ac000a60a56dn
}, {
  a: 0x7f6aa02d645532fc918de4373f1a5831926fe5e167n,
  b: -0x5856089a37fc06bed742167ff53b0365n,
  r: -0x844000a32180080c502066d901a0201n
}, {
  a: 0x3cd81b2ccfe3e8e6147d56d2abff162bcf7n,
  b: 0xafc2d334adn,
  r: 0x3cd81b2ccfe3e8e6147d56d2abff3f3bcffn
}, {
  a: -0xc5d39b2db5863e8ee13a2f665dd044a0f6f6b53ac4fc524b6bee29an,
  b: -0x81c7578ceaa39f5f0448732cbbbc84db9adddef02bb61e70dfbc74f5e9n,
  r: -0x45508a283184300481320b22484000a0d4e6003a40e4004b434e089n
}, {
  a: -0x36cdf012767ae0919466c5a603e1869fd50e6e224d8c277879a6e6626178a7c11n,
  b: 0xda974a7ee05fd3994ac67b69e2271c822059bc7697cb2f68n,
  r: -0x36cdf012767ae0919046810001e0028641020800418c063059a26420000005011n
}, {
  a: 0x238170a438aa0a7ea018cc0b9174ef62314ffac0e3426fb2d561cc01f045062n,
  b: -0xbe4ab26fec742012a251027d0a966b5d2d95ce0963aed5cn,
  r: -0x1e4232646c0000108210003d0894004d2894020803aad1an
}, {
  a: -0x56669ad1c4afc36060ac98db5b98f8d1d5baade25afabd1d631793c050an,
  b: 0x9f3d75950f49453236009ab0dn,
  r: -0x56669ad1c4afc36060ac98db5b98f8d1d52080824af0b41841019340401n
}, {
  a: 0x9e45fc64954c29373bce16e7e16dba7cd28n,
  b: -0x1685b8ee2927e15556a7265de40d4d4an,
  r: -0x1b0aa292480411681004924080042n
}, {
  a: -0x3140f7dfe188922f8b3dbdff1c22f81211d6724fc56171edc21e5bede528a36n,
  b: -0x75a156920755f605n,
  r: -0x5421449206508205n
}, {
  a: -0xd6c8c4e2da855dae38b187c050657bbea35334e0c980n,
  b: 0xab16d374en,
  r: -0xd6c8c4e2da855dae38b187c050657bbea3510480c832n
}, {
  a: 0x17b89bf6dn,
  b: 0xe85d5bcf09bf9ea6c51a967fad8c9f9db5a3cda189db4ba58373n,
  r: 0xe85d5bcf09bf9ea6c51a967fad8c9f9db5a3cda189db7badbf7fn
}, {
  a: 0x67c65e1fb78n,
  b: 0xbbaaf2dd76da7993a20b8fb421ef22070035314c718eb00e4cb9n,
  r: 0xbbaaf2dd76da7993a20b8fb421ef22070035314c77fef5effff9n
}, {
  a: -0xca02bbe00384855cfa6d4730632fn,
  b: -0x2fb7787a3b8f6bf4a85136ee6a34902dcf92d3d6fdd82f296n,
  r: -0x4a02a3400284810c386d45006205n
}, {
  a: -0x77e1516b87022c2975516b082a0n,
  b: 0x6a0a4f07a82cecf331e77197f03f8e3bc9efc1974717b6c025211c5691e3n,
  r: -0x6101400b8600002925402a0021dn
}, {
  a: -0x6670d1a74bc9d20n,
  b: 0xc58e245cc43f342bad2267ff7e361a31bddfbcafc693875c3bc538f01n,
  r: -0x647081840ac101fn
}, {
  a: -0x9d623ae45c9a32ad5151dfbd1526caafbc116f203n,
  b: -0x3426ea9f203852c07cf2075c000644f46c096971b436160a43c81982e888b44e6ba548n,
  r: -0xd420084141a022140001c811026888b04002a003n
}, {
  a: 0x2da6d9e9715ed647b8f89f14fb101390d3294c1f18b5a036365df777cefacc643an,
  b: -0x163cd6e94dadn,
  r: -0x3004210985n
}, {
  a: 0x6e3f3848ac4cb1bafb5ebn,
  b: 0xd1e7d7c97ef580feb15d6f113ac20635a7ed1aa6471067e47e9701ad52939f8dd64an,
  r: 0xd1e7d7c97ef580feb15d6f113ac20635a7ed1aa6471067e6fff785afd6db9faff7ebn
}, {
  a: 0x5070cfb5e79a2e2702540390778de2b9c7n,
  b: 0xca4a398d281faddce58eda5c04ea2a40c6f1ace7cbb98564b3f393n,
  r: 0xca4a398d281faddce58eda7ccfffefdaeef7aef7cbb9f7edf3fbd7n
}, {
  a: -0xdb2b8a28450c41599c898ab6d635n,
  b: -0x9491ceb964d803310009b962fn,
  r: -0x9080841044100100000929625n
}, {
  a: 0xda1ba6c2375cd9cc022n,
  b: 0x7aeb762c79492f612c0b0ebc9b713a7a637071f3cf68n,
  r: 0x7aeb762c79492f612c0b0ebc9ff1ba7e6375fdffcf6an
}, {
  a: 0xc754abf5d5389de45dad4bbf8ff79908779cf1363cd3d86d7518b0d606ff70n,
  b: -0x52c70e6371d2a40da056b424eaf5fbcde1e4aa8n,
  r: -0x20006637082200c8012802028a470c08180088n
}, {
  a: -0x47f3472bd8255fd2n,
  b: -0x5082903bff44d4b1ea68bbbea8e6ec65a4bb50abn,
  r: -0xe2442180215081n
}, {
  a: -0xc47fefd4cc34f0493aff6cb3147b163520e7faa43a73811926880dn,
  b: 0xe0bbf5b0c2cf10b0b4cc2b9eecd833416843f32020a06b8afd195n,
  r: -0xc0744084c010004030b32c02103214012063c08438718101000809n
}, {
  a: -0x87feda1c27e823ceb858955a0bf801610223919ba61beac5cc308925e018eb61n,
  b: -0x51a398722d3694933bn,
  r: -0x418010002520108321n
}, {
  a: -0xe3847991c1a91da9ff2eeb764c7a8b4f1e58n,
  b: -0x1f43eacb53609e8f14961d0en,
  r: -0x1d01ea0a43600c0a00061c06n
}, {
  a: -0x2f3e1aa4cbffcb1ca57513n,
  b: 0xba2d5a29fadc748c6b6979547f5de1a5e36n,
  r: -0x273808204ab80a00a52101n
}, {
  a: -0xa466359af0fecab1f907da7f01388e5baa7d2752253092f10n,
  b: 0x667cdd6ad545e43ba6bf119fdbd9830f8c040n,
  r: -0xa466359af0fe888120050a3a01000840aa602402243012f10n
}, {
  a: 0xd52f114e257c3defa939f2f0a7774b1d6fd9715460435c037f7dn,
  b: -0x2266n,
  r: -0x1n
}, {
  a: -0xfcn,
  b: -0x7b78e12811ca2e0248b47c2d046537b94b5131b776d049528502cf86n,
  r: -0x82n
}, {
  a: -0x15468936a4cbf08924e41cc87cc4d0fn,
  b: 0xcdd96fcc2c34a036a23f850bc8f5aa8501b59e542f21cn,
  r: -0x1448032a403000120e4084028c0d03n
}, {
  a: -0x8a5f0dac003143113a5ed4bcec62be30f3960ecbab99a30ddc7545an,
  b: -0xd723a7dde736bn,
  r: -0x912305dc65049n
}, {
  a: -0xb304849ca3d7bdd7f84493572c30d2994n,
  b: -0x9b55fed19e4e383d6ed5e48n,
  r: -0x9315d6d00402102c20d0804n
}, {
  a: -0x1c6f630a8fc77beb9daf632c4c454914e8cn,
  b: -0xceb0594eb2b35d6e9b423be041db194b07272b65f3a03e0aa0f647ba2a49def8edn,
  r: -0x106262020f0203e0880f602800040904889n
}, {
  a: 0x49cb7ced4af3d6a417f8225d30c751ed95494b6cd99545n,
  b: -0xaf33bde8720e68f12d621ff0a5abef16146efbn,
  r: -0xa5002948600648a00d200e1020a2a412046abbn
}, {
  a: 0x5dc3cfd98ee79dd2e671b3be897e3n,
  b: -0x8822a19fa60d095e436fde3e121n,
  r: -0x820201100000918024c4036001n
}, {
  a: -0x83c62d21f204ebe7e118b0cb184n,
  b: -0xa3542724321670b203d8276182e7a4f214912717e8a1445907f796902021ce26bn,
  r: -0x3c021005004e386800020ca003n
}, {
  a: -0x92ab5d6595d005ae865aen,
  b: 0xf4501a2653d4b1db805e2df4f09b8n,
  r: -0x802b4c241580000a06406n
}, {
  a: -0x882f6aa1e439d3c58e79f7e36785f47ff9b283ca3953a8n,
  b: 0x53e4860ddfd65eec953c10c5887252346d53f1fed787f8b2c8727156a893n,
  r: -0x2a42a1203181858a10a402010070074932818a295325n
}, {
  a: 0xcb1b1c3772db0df5a2b336df0f98e9d8d185c66d3d150f06243b34n,
  b: 0x34277252f99an,
  r: 0xcb1b1c3772db0df5a2b336df0f98e9d8d185c66d3d352f7676fbben
}, {
  a: 0xdc9611c676d8a88e4cc63965b811cn,
  b: 0xc6eb280519c777ba05bebf2ce1e9967e3c1a6a88cfe34bd4647a2717n,
  r: 0xc6eb280519c777ba05bebf2ce1eddf7f3c7f6f8acfe7cff7f67ba71fn
}, {
  a: -0x295be3a9bbfacc06bf9a2d2cc6d699c7f898f92ad8d31323510edcc3a107a3n,
  b: 0x64380b264e5af431682b30f55cc5fd520d7c1303a9ce387767e56n,
  r: -0x295be3a9b9b84c049b1a002cc05408c0a810a02ad800120341021c408101a1n
}, {
  a: -0x647cd1c9d694d22bcd4ce77c9c7d56n,
  b: -0xeede864bd9dcad4n,
  r: -0xacd48643c9c4852n
}, {
  a: 0x9be93ec213faab852a72eea06a10c2610b6b90e6e37a83a28cfd93e8c9980461an,
  b: -0x8ee9238bfn,
  r: -0x661238a5n
}, {
  a: -0xdfb0f2fec2596b978e9e7bb8143n,
  b: 0x1c34ab6143038e9d2a045baebb5b8b5a6d5503f3508bb6ef2n,
  r: -0x5100a07480102a940c8e7008101n
}, {
  a: -0x9caa5b44f21629c197c99e3386d5ab5d810925b2ca82d35n,
  b: 0xda462739d99ba701a1a2ac5fcc66b4f059a34967fc16b03n,
  r: -0x4a85844220408c01649122002910b0d800824900280435n
}, {
  a: 0x330bec36dce10d3730094c3189530d208c58bfn,
  b: -0xaee2bae27590764n,
  r: -0xa6628a207510741n
}, {
  a: 0x3d20406fc4aaa34e0897df5250e0b44623f7n,
  b: 0xc497c256606e4da103b5fdba06d6b7ca6a2a89cd1506bc67f4928abf1e8b31b4f1d22n,
  r: 0xc497c256606e4da103b5fdba06d6b7ca6bfa8dcffd4ebe77f49bffff3f8f3bf4f3ff7n
}, {
  a: -0x3c29c7ff9fdd1809452bb61f9e4b5903417f02e3f3a7dd970364e96n,
  b: -0xca6496fe56e4264n,
  r: -0xc22494960264202n
}, {
  a: -0x14d63321318c73e360c9b7a640bb391da67dd0366831n,
  b: -0xf443a49ff978868368f00ean,
  r: -0x70400093915806810060021n
}, {
  a: -0xfb6fdf73f58ec0a7c2f20ed2595393en,
  b: -0x6793acf9f8584f34ef3bn,
  r: -0x64022c29204805142939n
}, {
  a: -0x9bcf176ec23099b183e6b8f5d1e0d25650dda432858c895dfce52556c5dn,
  b: -0x6648cdc5cd56eb6f1b054cf8f943ac994en,
  r: -0x60805450d524328180004d8c84204084dn
}, {
  a: 0x1b4b623a7fc08975b37a8d2c19cbee6c80fb4c22d1d3db843ceddad22aan,
  b: 0xe158d266e99bcf4c456f97b0ceee72128b94aa139a6e320fffc104199cc4231071850an,
  r: 0xe158d266e99bfffe67efffb8dfff77badbd5bebffeee3fbfffed1d3dbcc7efddfda7aan
}, {
  a: -0x2469cb55b842e3d4b06d83f9474b491n,
  b: 0x9ff2a8d70cd278835e4a542290b9a1a0f157871ddn,
  r: -0x24014801b002c144004c03080048401n
}, {
  a: 0x61n,
  b: 0xd806e248e31022991b84d722c92839ef265n,
  r: 0xd806e248e31022991b84d722c92839ef265n
}, {
  a: -0x61a10ffd83d3153ebc85d9548en,
  b: -0x2916e14e4a898a2963315326e82663n,
  r: -0x61000a89820101301004c80401n
}, {
  a: 0xf142810e03841837ba4e9b9cd5ccf0753df3eb8370f2e949944bn,
  b: -0x3f2cd0cc49a4bf1463874b6n,
  r: -0x382c00c04180b01063060b5n
}, {
  a: -0xb4b3dc6bd2b1469a660a835410d3e891n,
  b: -0x55d77686ead6f3n,
  r: -0x835400c2c091n
}, {
  a: 0x3b00f4a8e3fbd5f759c05cc95n,
  b: 0xbe7640e76aae6e87f463a0886e69927764ac168c8636cb0a1fdc14dee47ed7d2d94n,
  r: 0xbe7640e76aae6e87f463a0886e69927764ac168c863fcbfebfffffdff77fd7ded95n
}, {
  a: -0x70560dn,
  b: 0x910d9a54a05485a2f3214b4650f2bc3a86c3efebe7929108a3d69170b7383fbb83bn,
  r: -0x4605n
}, {
  a: -0xdfa120c07b4e72can,
  b: 0xf664ce8d379045a8b09n,
  r: -0x930120807b0470c1n
}, {
  a: -0x438823b0e7d5ec2d9f2ff5d866d9fa0bddb064090en,
  b: 0x5409a0fa5n,
  r: -0x438823b0e7d5ec2d9f2ff5d866d9fa0bd8b0640009n
}, {
  a: -0x7c94c4fa8cc3cb60ee16b14696bcbd303116110afe1d508829n,
  b: -0x21cca2ff05bdc71b848e3893e48655185575fb24f48n,
  r: -0x20cc20b604a14310000a0893000041100561d100801n
}, {
  a: 0xc07d71ce0acb8f6e4bff8df9fe1c7358n,
  b: 0x1237943d437c5031a2b8bf89n,
  r: 0xc07d71ce1aff9f7f4bffddf9febcffd9n
}, {
  a: -0xa490fd8f801daa850230d44856f20e703d4645f424f7dc276821fb191cf25n,
  b: -0x516a86a7a321d3a2a22075629e91f7ba0903b1d9ec593842f1512708305104bf91e3e3n,
  r: -0x2010380a000502010010500010320c10050204240412500300004b191c321n
}, {
  a: 0x2703ea3a619f430f62c341e76745n,
  b: 0x8867b05b1e65256a2bad767711b64e0a4add79467203cbn,
  r: 0x8867b05b1e65256a2baf77ff3bf7df4b4ffffb47f767cfn
}];

var error_count = 0;
for (var i = 0; i < data.length; i++) {
  var d = data[i];
  var r = d.a | d.b;
  if (d.r !== r) {
    print("Input A:  " + d.a.toString(16));
    print("Input B:  " + d.b.toString(16));
    print("Result:   " + r.toString(16));
    print("Expected: " + d.r);
    print("Op: |");
    error_count++;
  }
}
if (error_count !== 0)
  throw new Error("Finished with " + error_count + " errors.")

