#!/bin/sh
##########################################################################
# If not stated otherwise in this file or this component's Licenses.txt
# file the following copyright and licenses apply:
#
# Copyright 2020 RDK Management
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
##########################################################################
if [ -f /etc/device.properties ];then
    . /etc/device.properties
fi

if [ -f /etc/rfc.properties ];then
    . /etc/rfc.properties
fi

if [ -f /lib/rdk/utils.sh ];then
    . /lib/rdk/utils.sh
fi

REDIRECT_FILE="/dev/null"
TR181_BIN="/usr/bin/tr181 -g"
COLLECTD_BIN="/usr/sbin/collectd"
COLLECTD_CONF="/etc/collectd.conf"
COLLECTD_TR181_NAME='Device.DeviceInfo.X_RDKCENTRAL-COM_RFC.Feature.collectd.Enable'
COLLECTD_URL_TR181_NAME='Device.DeviceInfo.X_RDKCENTRAL-COM_RFC.Feature.collectd.GraphiteURL'
COLLECTD_PORT_TR181_NAME='Device.DeviceInfo.X_RDKCENTRAL-COM_RFC.Feature.collectd.PortNumber'
COLLECTD_HOSTNAME_TR181_NAME='Device.DeviceInfo.X_RDKCENTRAL-COM_RFC.Feature.collectd.Hostname'
TIMESTAMP=`date -u +%y%m%d-%H:%M:%S`
FILENAME=`basename $0`
PID="$$"
PREFIX_DELIM="."
MACADDR=`echo \`getMacAddressOnly\` | sed "s/://g"`

ENABLE_COLLECTD=`${TR181_BIN} ${COLLECTD_TR181_NAME} 2>&1 > ${REDIRECT_FILE}`
HOSTNAME=`${TR181_BIN} ${COLLECTD_HOSTNAME_TR181_NAME} 2>&1 > ${REDIRECT_FILE}`
PORT=`${TR181_BIN} ${COLLECTD_PORT_TR181_NAME} 2>&1 > ${REDIRECT_FILE}`
URL=`${TR181_BIN} ${COLLECTD_URL_TR181_NAME} 2>&1 > ${REDIRECT_FILE}`

if [ ! -z "$HOSTNAME" -a "$HOSTNAME" != " " ]; then
    MACADDR=$HOSTNAME
else
    MACADDR=$MACADDR
fi

if [ ! -z "$PORT" -a "$PORT" != " " ]; then
    PORTNUM=$PORT
fi

if [ ! -z "$URL" -a "$URL" != " " ]; then
    GRAPHITEURL=$URL
fi

if [ "x$ENABLE_COLLECTD" != "xtrue" ]; then
    echo "${PID}: ${TIMESTAMP}: ${FILENAME}: RFC value for Collectd is $ENABLE_COLLECTD"
    echo "${PID}: ${TIMESTAMP}: ${FILENAME}: Disable Collectd on RDK Platforms!!!"
    echo "${PID}: ${TIMESTAMP}: ${FILENAME}: Following RFC are available to configure Collectd on RDK Platforms!!!"
    echo "${PID}: ${TIMESTAMP}: ${FILENAME}: ${COLLECTD_TR181_NAME}: Set the RFC value to Enable collectd"
    echo "${PID}: ${TIMESTAMP}: ${FILENAME}: ${COLLECTD_URL_TR181_NAME}: Set the URL to upload the collectd data"
    echo "${PID}: ${TIMESTAMP}: ${FILENAME}: ${COLLECTD_PORT_TR181_NAME}: Set the Port number for graphite URL"    
    echo "${PID}: ${TIMESTAMP}: ${FILENAME}: ${COLLECTD_HOSTNAME_TR181_NAME}: Set the hostname for the collectd"    
    isActive=`systemctl is-active collectd`
    if [ $isActive == "active" ];then
        echo "${PID}: ${TIMESTAMP}: ${FILENAME}: Stopping active Collectd service!!!"
        systemctl stop collectd
        systemctl reset-failed collectd
    fi
    echo "${PID}: ${TIMESTAMP}: ${FILENAME}: Collectd service is stopped!!!"
else
    echo "${PID}: ${TIMESTAMP}: ${FILENAME}: RFC value for Collectd is $ENABLE_COLLECTD"
    echo "${PID}: ${TIMESTAMP}: ${FILENAME}: Enable Collectd Configuration on RDK Platforms..."
    #Update hostname(macaddress) of the device
    hostname_conf=`sed "s/^Hostname.*/Hostname \"$MACADDR\"/" /etc/collectd.conf`
    echo "$hostname_conf" > /etc/collectd.conf
    #Update graphite server url to upload data
    url_conf=`sed "/<Carbon>/{n;s/.*/    Host \"$GRAPHITEURL\"/}" /etc/collectd.conf`
    echo "$url_conf" > /etc/collectd.conf
    #Update graphite server port to upload data
    port_conf=`sed "/$GRAPHITEURL/{n;s/.*/    Port \"$PORTNUM\"/}" /etc/collectd.conf`
    echo "$port_conf" > /etc/collectd.conf
    #Update Prefix for Grafana to upload data
    MODEL_NUM=$MODEL_NUM$PREFIX_DELIM
    prefix_conf=`sed "/$PORTNUM/{n;s/.*/    Prefix \"$MODEL_NUM\"/}" /etc/collectd.conf`
    echo "$prefix_conf" > /etc/collectd.conf   
    
    echo "${PID}: ${TIMESTAMP}: ${FILENAME}: Hostname:$MACADDR"
    echo "${PID}: ${TIMESTAMP}: ${FILENAME}: GraphiteUrl:$GRAPHITEURL"
    echo "${PID}: ${TIMESTAMP}: ${FILENAME}: PortNumber:$PORTNUM"
    echo "${PID}: ${TIMESTAMP}: ${FILENAME}: Prefix:$MODEL_NUM"
    ${COLLECTD_BIN} -C ${COLLECTD_CONF} -f
fi
