
.PHONY: directfb-unittest-all directfb-unittest-check-config directfb-unittest-config directfb-unittest directfb-unittest-compile directfb-unittest-install directfb-unittest-uninstall
.PHONY: directfb-unittest-clean directfb-unittest-distclean directfb-unittest-mrproper


############################################################
#
# directfb-unittest-all: force Directfb Unittest to be configured and compiled.
#
directfb-unittest-all: directfb-unittest-config directfb-unittest-compile directfb-unittest-install

##
#
# directfb-unittest-check-config: check to see whether the build environment or build options have changed
#                        since the last build.  If they have, then this will force a clean and
#                        then a rebuild of directfb-unittest.
#
directfb-unittest-check-config: ${DIRECTFB_UNITTEST_CONFIGURATION_FLAG}

##
#
# directfb-unittest-autogen: force configure and autoconf .in files to be regenerated.
#
directfb-unittest-autogen: check-autogen-tools directfb-unittest-check-config
	@$(ECHO) "***********************************************"; \
	$(ECHO)  "* Autogenerating directfb-unittest-${DIRECTFB_UNITTEST_VERSION} Configuration *"; \
	$(ECHO)  "***********************************************"; \
	if [ -e "${DIRECTFB_UNITTEST_CONFIGURED_FLAG}" ]; then \
		$(RM) ${DIRECTFB_UNITTEST_CONFIGURED_FLAG}; \
	fi; \
	$(CD) ${DIRECTFB_UNITTEST_SRC_DIR}; \
	$(EXPORT) CPPFLAGS="${BRCM_CPPFLAGS}"; \
	$(EXPORT) CXXFLAGS="${BRCM_CPPFLAGS}"; \
	$(EXPORT) AS=${AS}; \
	$(EXPORT) LD=${LD}; \
	$(EXPORT) LDFLAGS="${LDFLAGS} -L${DIRECTFB_INSTALL_LIB_DIR}"; \
	$(EXPORT) CC="${CCACHE} ${CC}"; \
	$(EXPORT) CXX="${CCACHE} ${CXX}"; \
	$(EXPORT) AR=${AR}; \
	$(EXPORT) NM=${NM}; \
	$(EXPORT) STRIP=${STRIP}; \
	$(EXPORT) OBJCOPY=${OBJCOPY}; \
	$(EXPORT) OBJDUMP=${OBJDUMP}; \
	$(EXPORT) RANLIB=${RANLIB}; \
	$(EXPORT) PKG_CONFIG_LIBDIR=${DIRECTFB_INSTALL_LIB_DIR}; \
	$(EXPORT) PKG_CONFIG_PATH=${DIRECTFB_INSTALL_PKG_CONFIG_DIR}; \
	autoreconf; \
	./configure $(DIRECTFB_UNITTEST_CONFIG_FLAGS); \
	if [ $$? -ne 0 ]; then \
		$(ECHO) -e "\n******************************************************"; \
	    $(ECHO) "* ERROR: Failed to autogenerate Directfb Unittest - Aborting! *"; \
		$(ECHO) "******************************************************"; \
	    $(FALSE); \
	else \
		$(TOUCH) ${DIRECTFB_UNITTEST_CONFIGURED_FLAG}; \
	fi

##
#
# directfb-unittest-config: force Directfb Unittest to be configured.
#
directfb-unittest-config: directfb-unittest-check-config
	@if [ -e "${DIRECTFB_UNITTEST_CONFIGURED_FLAG}" ]; then \
		$(RM) ${DIRECTFB_UNITTEST_CONFIGURED_FLAG}; \
	fi
	@$(call fn-directfb-unittest-configure)

##
#
# directfb-unittest-compile: force Directfb Unittest to be compiled (tracks changes to source code files)
#
directfb-unittest-compile: ${DIRECTFB_UNITTEST_CONFIGURED_FLAG}
	@if [ -e "${DIRECTFB_UNITTEST_COMPILED_FLAG}" ]; then \
		$(RM) ${DIRECTFB_UNITTEST_COMPILED_FLAG}; \
	fi
	@$(call fn-directfb-unittest-compile)

##
#
# directfb-unittest-install: force Directfb Unittest to be installed (tracks changes to source code files)
#
directfb-unittest-install: ${DIRECTFB_UNITTEST_COMPILED_FLAG}
	@if [ -e "${DIRECTFB_UNITTEST_INSTALLED_FLAG}" ]; then \
		$(RM) ${DIRECTFB_UNITTEST_INSTALLED_FLAG}; \
	fi
	@$(call fn-directfb-unittest-install)

##
#
# directfb-unittest: force Directfb Unittest to be compiled and installed in one pass (tracks changes to source code files)
#
directfb-unittest: directfb-unittest-install

##
#
# directfb-unittest-uninstall: force Directfb Unittest to be uninstalled
#
directfb-unittest-uninstall:
	@if [ -e "${DIRECTFB_UNITTEST_INSTALLED_FLAG}" ]; then \
		$(RM) ${DIRECTFB_UNITTEST_INSTALLED_FLAG}; \
	fi
	@-if [ -e "${DIRECTFB_UNITTEST_SRC_DIR}/Makefile" ]; then \
		${MAKE} -C ${DIRECTFB_UNITTEST_SRC_DIR} uninstall DESTDIR=${DIRECTFB_INSTALL_DIR}; \
	fi

##
#
# directfb-unittest-clean: remove all intermediate object and dependency files.
#
directfb-unittest-clean: directfb-unittest-uninstall
	@if [ -e "${DIRECTFB_UNITTEST_COMPILED_FLAG}" ]; then \
		$(RM) ${DIRECTFB_UNITTEST_COMPILED_FLAG}; \
	fi
	@if [ -e "${DIRECTFB_UNITTEST_FLAG}" ]; then \
		$(RM) ${DIRECTFB_UNITTEST_FLAG}; \
	fi
	@-if [ -e "${DIRECTFB_UNITTEST_SRC_DIR}/Makefile" ]; then \
		${MAKE} -C ${DIRECTFB_UNITTEST_SRC_DIR} clean; \
	fi

##
#
# directfb-unittest-distclean: remove all Directfb Unittest files including the option of
#                     removing the complete source tree.
#
directfb-unittest-distclean: directfb-unittest-clean
	@-$(call fn-directfb-unittest-distclean)

##
#
# directfb-unittest-mrproper: remove all Directfb Unittest compiled files
#
directfb-unittest-mrproper: directfb-unittest-clean
	@-$(call fn-directfb-unittest-distclean)

##
#
# fn-directfb-unittest-configure: function to configure Directfb Unittest.
#
define fn-directfb-unittest-configure
	$(ECHO) "******************************"; \
	$(ECHO) "* Configuring Directfb Unittest-${DIRECTFB_UNITTEST_VERSION} *"; \
	$(ECHO) "******************************"; \
	$(CD) ${DIRECTFB_UNITTEST_SRC_DIR}; \
	$(EXPORT) CPPFLAGS="${BRCM_CPPFLAGS} ${GTEST_CFLAGS} -DBUILD_DIRECTFB_UNITTEST"; \
	$(EXPORT) CXXFLAGS="${BRCM_CPPFLAGS} ${GTEST_CFLAGS} -DBUILD_DIRECTFB_UNITTEST"; \
	$(EXPORT) AS=${AS}; \
	$(EXPORT) LD=${LD}; \
	$(EXPORT) LDFLAGS="${LDFLAGS} -L${DIRECTFB_INSTALL_LIB_DIR} -L${APPLIBS_TARGET_LIB_DIR}"; \
	$(EXPORT) LIBS="$(DFB_LIBS)"; \
	$(EXPORT) CC="${CCACHE} ${CC}"; \
	$(EXPORT) CXX="${CCACHE} ${CXX}"; \
	$(EXPORT) AR=${AR}; \
	$(EXPORT) NM=${NM}; \
	$(EXPORT) STRIP=${STRIP}; \
	$(EXPORT) OBJCOPY=${OBJCOPY}; \
	$(EXPORT) OBJDUMP=${OBJDUMP}; \
	$(EXPORT) RANLIB=${RANLIB}; \
	$(EXPORT) PKG_CONFIG_LIBDIR=${DIRECTFB_INSTALL_LIB_DIR}; \
	$(EXPORT) PKG_CONFIG_PATH=${DIRECTFB_INSTALL_PKG_CONFIG_DIR}; \
	./configure $(DIRECTFB_UNITTEST_CONFIG_FLAGS); \
	if [ $$? -ne 0 ]; then \
		$(ECHO) -e "\n***************************************************"; \
	    $(ECHO) "* ERROR: Failed to configure Directfb Unittest - Aborting! *"; \
		$(ECHO) "***************************************************"; \
	    $(FALSE); \
	else \
		$(TOUCH) ${DIRECTFB_UNITTEST_CONFIGURED_FLAG}; \
	fi
endef

##
#
# fn-directfb-unittest-compile: function to compile Directfb Unittest.
#
define fn-directfb-unittest-compile	
	$(ECHO) "***************************"; \
	$(ECHO) "* Building Directfb Unittest-${DIRECTFB_UNITTEST_VERSION} *"; \
	$(ECHO) "***************************"; \
	if [ -e ${APPLIBS_TOP}/opensource/gtest/gtest-1.6.0/lib/.libs/libgtest.so ]; then \
		$(CP) ${APPLIBS_TOP}/opensource/gtest/gtest-1.6.0/lib/.libs/libgtest* ${DIRECTFB_INSTALL_LIB_DIR}; \
	else \
		$(ECHO) -e "\n******************************************************"; \
		$(ECHO) "* ERROR: Build Gtest Library First Then try building Directfb Unittest - Aborting! *"; \
		$(ECHO) "******************************************************"; \
		$(FALSE); \
	fi;\
	$(CD) ${DIRECTFB_UNITTEST_SRC_DIR}; \
	$(EXPORT) AS=${AS}; \
	$(EXPORT) LD=${LD}; \
	$(EXPORT) LDFLAGS="${LDFLAGS} ${GTEST_LDFLAGS} -L${DIRECTFB_INSTALL_LIB_DIR}"; \
	$(EXPORT) CC="${CCACHE} ${CC}"; \
	$(EXPORT) CXX="${CCACHE} ${CXX}"; \
	$(EXPORT) AR=${AR}; \
	$(EXPORT) NM=${NM}; \
	$(EXPORT) STRIP=${STRIP}; \
	$(EXPORT) OBJCOPY=${OBJCOPY}; \
	$(EXPORT) OBJDUMP=${OBJDUMP}; \
	$(EXPORT) RANLIB=${RANLIB}; \
	$(EXPORT) BUILD_DIR="${DIRECTFB_BUILD_VER_DIR}"; \
	${MAKE} ${MAKE_OPTIONS} DESTDIR=${DIRECTFB_INSTALL_DIR} LIBS=$(DFB_LIBS); \
	if [ $$? -ne 0 ]; then \
		$(ECHO) -e "\n***********************************************"; \
	    $(ECHO) "* ERROR: Failed to build Directfb Unittest - Aborting! *"; \
		$(ECHO) "***********************************************"; \
	    $(FALSE); \
	else \
		$(TOUCH) ${DIRECTFB_UNITTEST_COMPILED_FLAG}; \
	fi
endef

##
#
# fn-directfb-unittest-install: function to install Directfb Unittest.
#
define fn-directfb-unittest-install
	$(ECHO) "*****************************"; \
	$(ECHO) "* Installing Directfb Unittest-${DIRECTFB_UNITTEST_VERSION} *"; \
	$(ECHO) "*****************************"; \
	$(CD) ${DIRECTFB_UNITTEST_SRC_DIR}; \
	$(EXPORT) AS=${AS}; \
	$(EXPORT) LD=${LD}; \
	$(EXPORT) LDFLAGS="${LDFLAGS} -L${DIRECTFB_INSTALL_LIB_DIR}"; \
	$(EXPORT) CC="${CCACHE} ${CC}"; \
	$(EXPORT) CXX="${CCACHE} ${CXX}"; \
	$(EXPORT) AR=${AR}; \
	$(EXPORT) NM=${NM}; \
	$(EXPORT) STRIP=${STRIP}; \
	$(EXPORT) OBJCOPY=${OBJCOPY}; \
	$(EXPORT) OBJDUMP=${OBJDUMP}; \
	$(EXPORT) RANLIB=${RANLIB}; \
	$(EXPORT) BUILD_DIR="${DIRECTFB_BUILD_VER_DIR}"; \
	${MAKE} ${MAKE_OPTIONS} install DESTDIR=${DIRECTFB_INSTALL_DIR}; \
	if [ $$? -ne 0 ]; then \
		$(ECHO) -e "\n*************************************************"; \
	    $(ECHO) "* ERROR: Failed to install Directfb Unittest - Aborting! *"; \
		$(ECHO) "*************************************************"; \
	    $(FALSE); \
	else \
	    $(SED) -i -e "s;'${DIRECTFB_PREFIX};'${DIRECTFB_INSTALL_ROOT_DIR};g" ${DIRECTFB_INSTALL_LIB_DIR}/libdfb_unittest.la; \
	    $(SED) -i -e "s; ${DIRECTFB_PREFIX}; ${DIRECTFB_INSTALL_ROOT_DIR};g" ${DIRECTFB_INSTALL_LIB_DIR}/libdfb_unittest.la; \
	    $(ECHO) "Ver: ${DIRECTFB_UNITTEST_VERSION}"  > ${DIRECTFB_UNITTEST_INSTALLED_FLAG}; \
	    $(ECHO) "Src: ${DIRECTFB_UNITTEST_SRC_DIR}" >> ${DIRECTFB_UNITTEST_INSTALLED_FLAG}; \
	fi
endef

##
#
# fn-directfb-unittest-distclean: function to clean out all files.
#
define fn-directfb-unittest-distclean
	if [ -e "${DIRECTFB_UNITTEST_CONFIGURATION_FLAG}" ]; then \
		$(RM) ${DIRECTFB_UNITTEST_CONFIGURATION_FLAG}; \
	fi; \
	if [ -e "${DIRECTFB_UNITTEST_CONFIGURED_FLAG}" ]; then \
		$(RM) ${DIRECTFB_UNITTEST_CONFIGURED_FLAG}; \
	fi; \
	if [ -e "${DIRECTFB_UNITTEST_SRC_DIR}/Makefile" ]; then \
		${MAKE} -C ${DIRECTFB_UNITTEST_SRC_DIR} distclean; \
	fi;
endef

##
#
# Dependency target not to be called directly.
#
${DIRECTFB_UNITTEST_CONFIGURATION_FLAG}: ALWAYS
	@$(ECHO) -n "GCC_VERSION="                        > ${DIRECTFB_UNITTEST_SRC_DIR}/.config.$$$$; \
	${B_REFSW_CROSS_COMPILE}gcc -dumpversion         >> ${DIRECTFB_UNITTEST_SRC_DIR}/.config.$$$$; \
	$(ECHO) -n "GCC_MACHINE="                        >> ${DIRECTFB_UNITTEST_SRC_DIR}/.config.$$$$; \
	${B_REFSW_CROSS_COMPILE}gcc -dumpmachine         >> ${DIRECTFB_UNITTEST_SRC_DIR}/.config.$$$$; \
	$(ECHO) "KERNEL_VERSION=${KERNEL_VERSION}"       >> ${DIRECTFB_UNITTEST_SRC_DIR}/.config.$$$$; \
	$(ECHO) "B_REFSW_DEBUG=${B_REFSW_DEBUG}"         >> ${DIRECTFB_UNITTEST_SRC_DIR}/.config.$$$$; \
	$(ECHO) "B_REFSW_ARCH=${B_REFSW_ARCH}"           >> ${DIRECTFB_UNITTEST_SRC_DIR}/.config.$$$$; \
	$(ECHO) "B_REFSW_SHAREABLE=${B_REFSW_SHAREABLE}" >> ${DIRECTFB_UNITTEST_SRC_DIR}/.config.$$$$; \
	$(ECHO) "DIRECTFB_PREFIX=${DIRECTFB_PREFIX}"     >> ${DIRECTFB_UNITTEST_SRC_DIR}/.config.$$$$; \
	$(ECHO) "DIRECTFB_SHARED=${DIRECTFB_SHARED}"     >> ${DIRECTFB_UNITTEST_SRC_DIR}/.config.$$$$; \
	if [ -e "${DIRECTFB_UNITTEST_CONFIGURATION_FLAG}" ]; then \
		$(DIFF) ${DIRECTFB_UNITTEST_CONFIGURATION_FLAG} ${DIRECTFB_UNITTEST_SRC_DIR}/.config.$$$$; \
		if [ $$? -eq 1 ] ; then \
			${MAKE} -C ${DIRECTFB_BUILD_VER_DIR} directfb-unittest-clean; \
			$(CP) ${DIRECTFB_UNITTEST_SRC_DIR}/.config.$$$$ ${DIRECTFB_UNITTEST_CONFIGURATION_FLAG}; \
		fi; \
	else \
		$(CP) ${DIRECTFB_UNITTEST_SRC_DIR}/.config.$$$$ ${DIRECTFB_UNITTEST_CONFIGURATION_FLAG}; \
	fi; \
	$(RM) ${DIRECTFB_UNITTEST_SRC_DIR}/.config.$$$$

##
#
# Dependency target not to be called directly.
#
${DIRECTFB_UNITTEST_CONFIGURED_FLAG}: ${DIRECTFB_UNITTEST_CONFIGURATION_FLAG}
	@$(call fn-directfb-unittest-configure)

##
#
# Dependency target not to be called directly.
#
${DIRECTFB_UNITTEST_COMPILED_FLAG}: ${DIRECTFB_UNITTEST_CONFIGURED_FLAG}
	@$(call fn-directfb-unittest-compile)

##
#
# Dependency target not to be called directly.
#
${DIRECTFB_UNITTEST_INSTALLED_FLAG}: ${DIRECTFB_UNITTEST_COMPILED_FLAG}
	@$(call fn-directfb-unittest-install)

##
#
# Dependency target not to be called directly.
#
${DIRECTFB_UNITTEST_FLAG}: ${DIRECTFB_UNITTEST_INSTALLED_FLAG}
	@$(ECHO) -e "${DIRECTFB_UNITTEST_VERSION}\n${BRCM_CPPFLAGS}" > ${DIRECTFB_UNITTEST_SRC_DIR}/.install.$$$$; \
	if [ -e "${DIRECTFB_UNITTEST_FLAG}" ]; then \
		$(DIFF) ${DIRECTFB_UNITTEST_FLAG} ${DIRECTFB_UNITTEST_SRC_DIR}/.install.$$$$; \
		if [ $$? -eq 1 ] ; then \
			$(CP) ${DIRECTFB_UNITTEST_SRC_DIR}/.install.$$$$ ${DIRECTFB_UNITTEST_FLAG}; \
		fi; \
	else \
		$(CP) ${DIRECTFB_UNITTEST_SRC_DIR}/.install.$$$$ ${DIRECTFB_UNITTEST_FLAG}; \
	fi; \
	$(RM) ${DIRECTFB_UNITTEST_SRC_DIR}/.install.$$$$


