/******************************************************************************
 *    (c)2010-2013 Broadcom Corporation
 *
 * This program is the proprietary software of Broadcom Corporation and/or its licensors,
 * and may only be used, duplicated, modified or distributed pursuant to the terms and
 * conditions of a separate, written license agreement executed between you and Broadcom
 * (an "Authorized License").  Except as set forth in an Authorized License, Broadcom grants
 * no license (express or implied), right to use, or waiver of any kind with respect to the
 * Software, and Broadcom expressly reserves all rights in and to the Software and all
 * intellectual property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU
 * HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY
 * NOTIFY BROADCOM AND DISCONTINUE ALL USE OF THE SOFTWARE.
 *
 * Except as expressly set forth in the Authorized License,
 *
 * 1.     This program, including its structure, sequence and organization, constitutes the valuable trade
 * secrets of Broadcom, and you shall use all reasonable efforts to protect the confidentiality thereof,
 * and to use this information only in connection with your use of Broadcom integrated circuit products.
 *
 * 2.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
 * AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
 * WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH RESPECT TO
 * THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND ALL IMPLIED WARRANTIES
 * OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE,
 * LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION
 * OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF
 * USE OR PERFORMANCE OF THE SOFTWARE.
 *
 * 3.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR ITS
 * LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL, INDIRECT, OR
 * EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY RELATING TO YOUR
 * USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM HAS BEEN ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT
 * ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE
 * LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF
 * ANY LIMITED REMEDY.
 *
 *****************************************************************************/

#ifndef __DFB_BCM__M2MC_Task_H__
#define __DFB_BCM__M2MC_Task_H__

#include "bcm_config.h"


#include <direct/LockWQ.h>

#include <core/PacketBuffer.h>
#include <core/Renderer.h>
#include <core/Task.h>
#include <core/Util.h>

extern "C" {
#include <directfb.h>

#include <direct/debug.h>
#include <direct/messages.h>

#include <core/surface_allocation.h>
#include <core/surface_pool.h>
#include <core/system.h>

#include <gfx/convert.h>

#include "bcmnexus_gfx.h"
#include "bcmnexus_pool.h"

}


namespace Broadcom {

class M2MCCore;
class M2MCEngine;



#if 1
D_DEBUG_DOMAIN( M2MC_PacketBuffer, "M2MC/PacketBuffer", "M2MC PacketBuffer" );

// FIXME: move to libdirectfb and use by Genefx as well
class PacketBuffer {
public:
     PacketBuffer( size_t block_size = 0x8000 )
          :
          block_size( block_size ),
          length( 0 )
     {
         D_DEBUG_AT( M2MC_PacketBuffer, "M2MCPacketBuffer::%s( block_size %lu )\n", __FUNCTION__, (unsigned long)block_size );

     }

     ~PacketBuffer()
     {
          D_DEBUG_AT( M2MC_PacketBuffer, "M2MCPacketBuffer::%s()\n", __FUNCTION__ );

          for (std::vector<Buffer*>::const_iterator it = buffers.begin(); it != buffers.end(); ++it)
               delete *it;
     }

     size_t
     GetLength()
     {
         D_DEBUG_AT( M2MC_PacketBuffer, "M2MCPacketBuffer::%s() -> %lu\n", __FUNCTION__, (unsigned long)length );
          return length;
     }

     void *
     GetBuffer( size_t space )
     {
         D_DEBUG_AT( M2MC_PacketBuffer, "M2MCPacketBuffer::%s( %lu )\n", __FUNCTION__, (unsigned long)space );

          size_t count = buffers.size();

          if (count > 0) {
               Buffer *last = buffers[count-1];

               D_DEBUG_AT( M2MC_PacketBuffer, "  -> last has %d/%d\n", last->length, last->size );

               if (last->length + space <= last->size)
                    return (void*)((u8*) last->ptr + last->length);
          }

          if (space < block_size)
               space = block_size;

          D_DEBUG_AT( M2MC_PacketBuffer, "  -> allocating %d bytes\n", space );

          Buffer *buffer = new Buffer( space );

          buffers.push_back( buffer );

          D_DEBUG_AT( M2MC_PacketBuffer, "  => ptr %p\n", buffer->ptr );

          return buffer->ptr;
     }

     void
     PutBuffer( void *ptr )
     {
          D_DEBUG_AT( M2MC_PacketBuffer, "M2MCPacketBuffer::%s( ptr %p )\n", __FUNCTION__, ptr );

          size_t len;
          size_t count = buffers.size();

          D_ASSERT( count > 0 );

          Buffer *last = buffers[count-1];

          D_ASSERT( (unsigned long) ptr >= (unsigned long) last->ptr + last->length );
          D_ASSERT( (unsigned long) ptr <= (unsigned long) last->ptr + last->size );

          len = (unsigned long) ptr - (unsigned long) last->ptr;

          bcmnexus_gfxDumpCommands( (u32*) last->ptr, last->length/4, len/4 - last->length/4 );

          length += len - last->length;

          D_DEBUG_AT( M2MC_PacketBuffer, "  -> length %d -> %d\n", last->length, len );
          D_DEBUG_AT( M2MC_PacketBuffer, "  -> total length %d\n", length );

          last->length = len;
     }

     void
     GetData( void *dst, size_t max )
     {
         D_DEBUG_AT( M2MC_PacketBuffer, "M2MCPacketBuffer::%s( dst %p, max %lu )\n", __FUNCTION__, dst, (unsigned long)max );

          D_DEBUG_AT( M2MC_PacketBuffer, "  -> total length %d\n", length );

          if (max > length)
               max = length;

          for (std::vector<Buffer*>::const_iterator it = buffers.begin(); it != buffers.end(); ++it) {
               Buffer *buffer = *it;

               D_DEBUG_AT( M2MC_PacketBuffer, "  -> copy %lu from %p to %p\n", (unsigned long)buffer->length, buffer->ptr, dst );

               direct_memcpy( dst, buffer->ptr, buffer->length );

               dst = (void*)((u8*) dst + buffer->length);
          }
     }

private:
     size_t                   block_size;
     size_t                   length;

public:
     class Buffer {
     public:
          Buffer( size_t size )
               :
               size( size ),
               length( 0 )
          {
               ptr = malloc( size );
               D_ASSERT( ptr != NULL );
          }

          ~Buffer()
          {
               free( ptr );
          }

          size_t  size;
          size_t  length;
          void   *ptr;
     };

     std::vector<Buffer*>     buffers;
};

#endif



class M2MCTask : public DirectFB::SurfaceTask
{
public:
     //DirectFB::Util::PacketBuffer<> buffer;
     PacketBuffer buffer;

     M2MCTask( M2MCEngine *engine, unsigned int tile_number );

protected:
     virtual DFBResult Setup();
     virtual DFBResult Push();
     virtual DFBResult Run();
     virtual void      Finalise();

     virtual void Describe( Direct::String &string )
     {
          SurfaceTask::Describe( string );

          string.PrintF( "  length %lu", (unsigned long)buffer.GetLength() );
     }

private:
     friend class M2MCCore;
     friend class M2MCEngine;

     M2MCEngine   *engine;

     bcmnexus_gfxDriverData Bdriver;
     bcmnexus_gfxDeviceData Bdevice;
     unsigned int           tile_number;
     DFBRegion              clip;
};


}

#endif

