/***************************************************************************
 *     (c)2007-2013 Broadcom Corporation
 *
 *  This program is the proprietary software of Broadcom Corporation and/or its licensors,
 *  and may only be used, duplicated, modified or distributed pursuant to the terms and
 *  conditions of a separate, written license agreement executed between you and Broadcom
 *  (an "Authorized License").  Except as set forth in an Authorized License, Broadcom grants
 *  no license (express or implied), right to use, or waiver of any kind with respect to the
 *  Software, and Broadcom expressly reserves all rights in and to the Software and all
 *  intellectual property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU
 *  HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY
 *  NOTIFY BROADCOM AND DISCONTINUE ALL USE OF THE SOFTWARE.
 *
 *  Except as expressly set forth in the Authorized License,
 *
 *  1.     This program, including its structure, sequence and organization, constitutes the valuable trade
 *  secrets of Broadcom, and you shall use all reasonable efforts to protect the confidentiality thereof,
 *  and to use this information only in connection with your use of Broadcom integrated circuit products.
 *
 *  2.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
 *  AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
 *  WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH RESPECT TO
 *  THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND ALL IMPLIED WARRANTIES
 *  OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE,
 *  LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION
 *  OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF
 *  USE OR PERFORMANCE OF THE SOFTWARE.
 *
 *  3.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR ITS
 *  LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL, INDIRECT, OR
 *  EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY RELATING TO YOUR
 *  USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM HAS BEEN ADVISED OF
 *  THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT
 *  ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE
 *  LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF
 *  ANY LIMITED REMEDY.
 *
 ***************************************************************************/

#include "bcmnexus.h"
#include "bcmnexus_screen.h"
#include "bcmnexus_layer.h"
#include "bcmnexus_pool.h"
#include "bcmnexus_video.h"

#include "misc/conf.h"
#include "core/core.h"
#include "core/layers_internal.h"
#include "core/screens.h"
#include "core/core_system.h"
#include "direct/conf.h"
#include "fusion/conf.h"
#include "fusion/shmalloc.h"

D_DEBUG_DOMAIN( bcmnexusSystem,  "bcmNexus/System",  "Broadcom NEXUS System module" );
D_DEBUG_DOMAIN( bcmnexusSystemX, "bcmNexus/SystemX", "Broadcom NEXUS System module eXtended debugging" );

DFB_CORE_SYSTEM( bcmnexus )

CoreDFB *dfb_bcmnexus_core = NULL;

/** public **/
static void
system_get_info( CoreSystemInfo *info )
{
    D_DEBUG_AT( bcmnexusSystem, "%s()\n", __FUNCTION__ );

    info->version.major = BCMNEXUS_SYS_MAJOR_VERSION;
    info->version.minor = BCMNEXUS_SYS_MINOR_VERSION;
    info->type = CORE_ANY;
    info->caps = CSCAPS_ACCELERATION;

#if BCM_DFB_USE_TASK_MANAGER
    info->caps |= CSCAPS_DISPLAY_TASKS | CSCAPS_NOTIFY_DISPLAY;
#endif

    snprintf( info->name, DFB_CORE_SYSTEM_INFO_NAME_LENGTH, "BCMNEXUS" );
    snprintf( info->vendor, DFB_CORE_SYSTEM_INFO_VENDOR_LENGTH, "Broadcom Corporation" );
    snprintf( info->url, DFB_CORE_SYSTEM_INFO_URL_LENGTH, "http://www.broadcom.com" );
    snprintf( info->license, DFB_CORE_SYSTEM_INFO_LICENSE_LENGTH, "proprietary" );
}

static void
register_screens_layers( DFBBCMNEXUS *dfb_bcmnexus )
{
    CoreScreen *primary_screen;
#if (NUM_DISPLAYS > 1)
    CoreScreen *secondary_screen;
    DFB_PlatformSettings  platformSettings;
#endif

    /* Register primary screen functions */
    primary_screen = dfb_screens_register( dfb_gfxcard_get_primary(), dfb_bcmnexus, &bcmnexusPrimaryScreenFuncs );

    if (primary_screen == NULL)
    {
        D_ERROR("Cannot register primary screen!");
        return;
    }

    /* Always register primary graphics layer functions FIRST */
    dfb_layers_register( primary_screen, dfb_bcmnexus, &bcmnexusPrimaryGfxLayerFuncs );

#if (NUM_DISPLAYS > 1)
    /* Get the DirectFB Platform settings */
    DFB_Platform_GetSettings(&platformSettings);

    /* Check if our secondary display has been enabled */
    if (platformSettings.display[1].handle != NULL )
    {
        D_DEBUG_AT( bcmnexusSystem, "%s() Enable secondary display\n",__FUNCTION__);

    /* Register secondary screen functions */
    secondary_screen = dfb_screens_register( dfb_gfxcard_get_primary(), dfb_bcmnexus, &bcmnexusSecondaryScreenFuncs );

    if (secondary_screen == NULL)
    {
        D_ERROR("Cannot register secondary screen!");
        return;
    }

    /* Always register secondary graphics layer functions SECOND */
    dfb_layers_register( secondary_screen, dfb_bcmnexus, &bcmnexusSecondaryGfxLayerFuncs );
    }
    else
        D_DEBUG_AT( bcmnexusSystem, "%s() secondary display not initialised - not enabling\n",__FUNCTION__);

#endif

    /* register video layer functions */
    dfb_layers_register( primary_screen, dfb_bcmnexus, &bcmnexusVideoFuncs );

}

static void
unregister_screens_layers( DFBBCMNEXUS *dfb_bcmnexus )
{
#if !BCMNEXUS_NSC_SUPPORT
    NEXUS_StopCallbacks(GET_DISPLAY_HND(dfb_bcmnexus, PRIMARY_DISPLAY_ID));
#if (NUM_DISPLAYS > 1)
    NEXUS_StopCallbacks(GET_DISPLAY_HND(dfb_bcmnexus, SECONDARY_DISPLAY_ID));
#endif
    pthread_mutex_destroy( &GET_DISPLAY_VSYNC_MUTEX(dfb_bcmnexus, PRIMARY_DISPLAY_ID) );
    pthread_cond_destroy( &GET_DISPLAY_VSYNC_SEM(dfb_bcmnexus, PRIMARY_DISPLAY_ID) );
    SET_DISPLAY_VSYNC_CB(dfb_bcmnexus, NULL, PRIMARY_DISPLAY_ID);
#if (NUM_DISPLAYS > 1)
    pthread_mutex_destroy( &GET_DISPLAY_VSYNC_MUTEX(dfb_bcmnexus, SECONDARY_DISPLAY_ID));
    pthread_cond_destroy( &GET_DISPLAY_VSYNC_SEM(dfb_bcmnexus, SECONDARY_DISPLAY_ID) );
    SET_DISPLAY_VSYNC_CB(dfb_bcmnexus, NULL, SECONDARY_DISPLAY_ID);
#endif
#else
    (void)dfb_bcmnexus;
#endif
}

void
option_get_string(const char * name, char **dest)
{
    char *values[10];
    int num;

    D_DEBUG_AT( bcmnexusSystem, "%s() Getting value for %s\n", __FUNCTION__, name);

    if (direct_config_get(name, values, 10, &num) == DR_OK)
    {
        if (*dest)
        {
            D_FREE( *dest );
        }

        if (num > 0)
            *dest = D_STRDUP( values[num - 1] );
        else
            *dest = D_STRDUP( "" );

        D_DEBUG_AT( bcmnexusSystem, "%s() Value for %s is $%s$\n", __FUNCTION__, name, *dest);

    }
    else
    {
        D_DEBUG_AT( bcmnexusSystem, "%s() Failed to get value for %s\n", __FUNCTION__, name);
    }

}

void
system_intiailize_options(BCMNEXUS_Options *options)
{

    char *temp = NULL;

    options->sw_picture_decode = true;

#ifdef NEXUS_HAS_PICTURE_DECODER
    /* For chips with SID always default to h/w decode */
    /*But run-time config can allow switching to s/w decode */
    if(!getenv("sw_picture_decode")) {
        options->sw_picture_decode = false;
    }
#endif

    options->bcmnexus_ir_timeout = direct_config_get_int_value("bcmnexus-ir-timeout");
    if (options->bcmnexus_ir_timeout == 0)
    {
        /*Default value if unset*/
        options->bcmnexus_ir_timeout = 120;
    }

    options->bcmnexus_key_timeout = direct_config_get_int_value("bcmnexus-key-timeout");
    if (options->bcmnexus_key_timeout == 0)
    {
        /*Default value if unset*/
        options->bcmnexus_key_timeout = 150;
    }

    options->bcmnexus_ir_repeat_time = direct_config_get_int_value("bcmnexus-ir-repeat-time");
    options->bcmnexus_key_repeat_time = direct_config_get_int_value("bcmnexus-key-repeat-time");


    options->bcmnexus_key_debounce = direct_config_get_int_value("bcmnexus-key-debounce");

    options->bcmnexus_ir_repeat_skip = direct_config_get_int_value("bcmnexus-ir-repeat-skip");
    options->bcmnexus_key_repeat_skip = direct_config_get_int_value("bcmnexus-key-repeat-skip");

    option_get_string("bcmnexus-ir-protocol", &options->bcmnexus_ir_protocol);
    option_get_string("bcmnexus-ir-keycodes", &options->bcmnexus_ir_keycodes);

    option_get_string("res", &options->res);

    if (options->res) {
        if ((strcmp(options->res, "2160p30") != 0)  &&
            (strcmp(options->res, "2160p25") != 0)  &&
            (strcmp(options->res, "2160p24") != 0)  &&
            (strcmp(options->res, "1080p"  ) != 0)  &&
            (strcmp(options->res, "1080p60") != 0)  &&
            (strcmp(options->res, "1080p50") != 0)  &&
            (strcmp(options->res, "1080p30") != 0)  &&
            (strcmp(options->res, "1080p25") != 0)  &&
            (strcmp(options->res, "1080p24") != 0)  &&
            (strcmp(options->res, "1080i"  ) != 0)  &&
            (strcmp(options->res, "1080i30") != 0)  &&
            (strcmp(options->res, "1080i25") != 0)  &&
            (strcmp(options->res, "720p"   ) != 0)  &&
            (strcmp(options->res, "720ps"  ) != 0)  &&
            (strcmp(options->res, "720p60" ) != 0)  &&
            (strcmp(options->res, "720p50" ) != 0)  &&
            (strcmp(options->res, "720p50s") != 0)  &&
            (strcmp(options->res, "720p30" ) != 0)  &&
            (strcmp(options->res, "720p25" ) != 0)  &&
            (strcmp(options->res, "720p24" ) != 0)  &&
            (strcmp(options->res, "720p24s") != 0)  &&
            (strcmp(options->res, "576p"   ) != 0)  &&
            (strcmp(options->res, "576i"   ) != 0)  &&
            (strcmp(options->res, "480p"   ) != 0)  &&
            (strcmp(options->res, "480i"   ) != 0)  &&
            (strcmp(options->res, "VGA"    ) != 0)  &&
            (strcmp(options->res, "SVGA"   ) != 0)  &&
            (strcmp(options->res, "XGA"    ) != 0))
        {
            D_ERROR("%s: 'res': unsupported resolution specified! $%s$ %d \n", __FUNCTION__, options->res, strcmp(options->res, "720p"   ));
            D_FREE( options->res );
            options->res = D_STRDUP(" ");
        }
    }
    else
    {
            D_ERROR("%s: 'res': unspecified!\n", __FUNCTION__);
            options->res = D_STRDUP(" ");
    }

    option_get_string("ibuffer", &temp);
    if (temp)
    {
        if (sscanf( temp, "%dx%d", &options->ibuffer.width, &options->ibuffer.height ) < 2) {
            D_ERROR("DirectFB/Config '%s': Could not parse width and height!\n", temp);
        }

        D_FREE(temp);
    }

}

static DFBResult
system_initialize( CoreDFB *core, void **data )
{
    DFBResult            ret;
    DFBBCMNEXUS *dfb_bcmnexus = NULL;
    FusionSHMPoolShared *pool;
    DFB_PlatformSettings platformSettings;

    D_DEBUG_AT( bcmnexusSystem, "%s() core=%p\n", __FUNCTION__, (void *)core );
    pthread_mutexattr_t mutexAttr;

#if BCMNEXUS_NXCLIENT_SUPPORT
    DFB_Platform_GetDefaultSettings(DFB_PlatformClientType_eNxClient, &platformSettings);
#else
    DFB_Platform_GetDefaultSettings(DFB_PlatformClientType_eMasterNexusUninitialized, &platformSettings);
#endif
    /* Call to initialise DirectFB Platform code */
    ret = DFB_Platform_Init(&platformSettings);
    if (ret) {
        return ret;
    }

    /* Allocate shared memory state object */
    pool = dfb_core_shmpool( core );
    dfb_bcmnexus = SHCALLOC( pool, 1, sizeof(DFBBCMNEXUS) );
    if (!dfb_bcmnexus) {
        return D_OOSHM();
    }

    /* Save the per-process core handle */
    dfb_bcmnexus_core = core;

    system_intiailize_options(&dfb_bcmnexus->options);

    /* Get the DirectFB Platform settings */
    DFB_Platform_GetSettings(&platformSettings);

    SET_DISPLAY_HEAP_HND(dfb_bcmnexus, platformSettings.displayHeapHandle);
    D_DEBUG_AT( bcmnexusSystem, "%s() display heap handle=%p\n", __FUNCTION__, (void *)GET_DISPLAY_HEAP_HND(dfb_bcmnexus) );
    SET_2ND_DISPLAY_HEAP_HND(dfb_bcmnexus, platformSettings.secondaryDisplayHeapHandle);
    D_DEBUG_AT( bcmnexusSystem, "%s() secondary display heap handle=%p\n", __FUNCTION__, (void *)GET_2ND_DISPLAY_HEAP_HND(dfb_bcmnexus) );
    SET_OFFSCREEN_HEAP_HND(dfb_bcmnexus, platformSettings.offscreenHeapHandle);
    D_DEBUG_AT( bcmnexusSystem, "%s() offscreen heap handle=%p\n", __FUNCTION__, (void *)GET_OFFSCREEN_HEAP_HND(dfb_bcmnexus) );
    SET_PALETTE_HEAP_HND(dfb_bcmnexus, platformSettings.paletteHeapHandle);
    D_DEBUG_AT( bcmnexusSystem, "%s() palette heap handle=%p\n", __FUNCTION__, (void *)GET_PALETTE_HEAP_HND(dfb_bcmnexus) );
    SET_VIDEO_HEAP_HND(dfb_bcmnexus, platformSettings.videoHeapHandle);
    D_DEBUG_AT( bcmnexusSystem, "%s() video heap handle=%p\n", __FUNCTION__, (void *)GET_VIDEO_HEAP_HND(dfb_bcmnexus) );
    SET_GRAPHICS2Dn_HND(dfb_bcmnexus, platformSettings.graphics2d[0].handle, 0);
    D_DEBUG_AT( bcmnexusSystem, "%s() graphics2d[0] handle=%p\n", __FUNCTION__, (void *)GET_GRAPHICS2Dn_HND(dfb_bcmnexus, 0) );
    SET_GRAPHICS2Dn_HND(dfb_bcmnexus, platformSettings.graphics2d[1].handle, 1);
    D_DEBUG_AT( bcmnexusSystem, "%s() graphics2d[1] handle=%p\n", __FUNCTION__, (void *)GET_GRAPHICS2Dn_HND(dfb_bcmnexus, 1) );
    SET_DISPLAY_HND(dfb_bcmnexus, platformSettings.display[0].handle, PRIMARY_DISPLAY_ID);
    D_DEBUG_AT( bcmnexusSystem, "%s() display0 handle=%p\n", __FUNCTION__, (void *)GET_DISPLAY_HND(dfb_bcmnexus, PRIMARY_DISPLAY_ID) );
#if (NUM_DISPLAYS > 1)
    SET_DISPLAY_HND(dfb_bcmnexus, platformSettings.display[1].handle, SECONDARY_DISPLAY_ID);
    D_DEBUG_AT( bcmnexusSystem, "%s() display1 handle=%p\n", __FUNCTION__, (void *)GET_DISPLAY_HND(dfb_bcmnexus, SECONDARY_DISPLAY_ID) );
#endif
#if (NUM_DISPLAYS > 2)
    SET_DISPLAY_HND(dfb_bcmnexus, platformSettings.display[2].handle, TERTIARY_DISPLAY_ID);
    D_DEBUG_AT( bcmnexusSystem, "%s() display2 handle=%p\n", __FUNCTION__, (void *)GET_DISPLAY_HND(dfb_bcmnexus, TERTIARY_DISPLAY_ID) );
#endif

    /* register screens and layers */
    register_screens_layers( dfb_bcmnexus );

    pthread_mutexattr_init(&mutexAttr);
    pthread_mutexattr_setpshared(&mutexAttr, PTHREAD_PROCESS_SHARED);

#if NEXUS_HAS_PICTURE_DECODER
    if (platformSettings.pictureDecoder.handle == NULL)
        dfb_bcmnexus->options.sw_picture_decode = true;
    else
        SET_PICTURE_DECODER_HND(dfb_bcmnexus, platformSettings.pictureDecoder.handle);

    pthread_mutex_init( &GET_PICTURE_DECODER_LOCK(dfb_bcmnexus), &mutexAttr);

    D_DEBUG_AT( bcmnexusSystem, "%s() picture decoder handle=%p\n", __FUNCTION__, (void *)GET_PICTURE_DECODER_HND(dfb_bcmnexus) );
#endif

#if NEXUS_HAS_BCC
        SET_BCC_HND(dfb_bcmnexus, platformSettings.blockCopyCompositor.handle);
#endif

    /* make data accessible via dfb_system_data(); */
    /* must be set before initializing the pools! */
    *data = dfb_bcmnexus;

    dfb_surface_pool_initialize( core, &bcmnexusPoolFunctions,           &GET_POOL_HND(dfb_bcmnexus) );
#ifdef BCMNEXUS_GFX_HAS_V3D
    dfb_surface_pool_initialize( core, &bcmnexusGraphics3DPoolFunctions, &GET_GFX3D_POOL_HND(dfb_bcmnexus) );
#endif

    /* Initialise Primary Screen VSYNC callbacks */
    pthread_mutex_init( &GET_DISPLAY_VSYNC_MUTEX(dfb_bcmnexus, PRIMARY_DISPLAY_ID), &mutexAttr);
    pthread_cond_init( &GET_DISPLAY_VSYNC_SEM(dfb_bcmnexus, PRIMARY_DISPLAY_ID), NULL);

    SET_DISPLAY_VSYNC_CB(dfb_bcmnexus, NULL, PRIMARY_DISPLAY_ID);

#if (NUM_DISPLAYS > 1)
    /* Initialise Secondary Screen VSYNC callbacks */
    pthread_mutex_init( &GET_DISPLAY_VSYNC_MUTEX(dfb_bcmnexus, SECONDARY_DISPLAY_ID), &mutexAttr);
    pthread_cond_init( &GET_DISPLAY_VSYNC_SEM(dfb_bcmnexus, SECONDARY_DISPLAY_ID), NULL);
    SET_DISPLAY_VSYNC_CB(dfb_bcmnexus, NULL, SECONDARY_DISPLAY_ID);
#endif

    pthread_mutexattr_destroy(&mutexAttr);

    DFB_Platform_P_SetSharedSettings(DFB_PlatformSharedSetting_eSurfacePool,
                                     (void*)&GET_POOL_HND(dfb_bcmnexus));

#ifdef BCMNEXUS_GFX_HAS_V3D
    DFB_Platform_P_SetSharedSettings(DFB_PlatformSharedSetting_e3DGraphicsPool,
                                     (void*)&GET_GFX3D_POOL_HND(dfb_bcmnexus));
#endif

    D_DEBUG_AT( bcmnexusSystem, "%s() Exit(%d)\n", __FUNCTION__, DFB_OK);
    return DFB_OK;
}

static DFBResult
system_join( CoreDFB *core, void **data )
{
    DFBResult         ret;
    DFBBCMNEXUS      *dfb_bcmnexus;
    DFB_PlatformSettings platformSettings;
    CoreSurfacePool* pool;

    D_DEBUG_AT( bcmnexusSystem, "%s() core=%p\n", __FUNCTION__, (void *)core );

#if BCMNEXUS_NXCLIENT_SUPPORT
    DFB_Platform_GetDefaultSettings(DFB_PlatformClientType_eNxClient, &platformSettings);
#else
    DFB_Platform_GetDefaultSettings(DFB_PlatformClientType_eSlaveNexusUninitialized, &platformSettings);
#endif

    /* Call to initialise DirectFB Platform code */
    ret = DFB_Platform_Init(&platformSettings);
    if (ret) {
        return ret;
    }

    /* Save the per-process core handle */
    dfb_bcmnexus_core = core;


    dfb_bcmnexus = D_CALLOC( 1, sizeof(DFBBCMNEXUS) );
    if (!dfb_bcmnexus) {
        return D_OOM();
    }

    system_intiailize_options(&dfb_bcmnexus->options);

    SET_OFFSCREEN_HEAP_HND(dfb_bcmnexus, platformSettings.offscreenHeapHandle);
    D_DEBUG_AT( bcmnexusSystem, "%s() offscreen heap handle=%p\n", __FUNCTION__, (void *)GET_OFFSCREEN_HEAP_HND(dfb_bcmnexus) );

    DFB_Platform_P_GetSharedSettings(DFB_PlatformSharedSetting_eSurfacePool,(void*)&pool);
    SET_POOL_HND(dfb_bcmnexus,pool);
    D_DEBUG_AT( bcmnexusSystem, "%s() system pool handle=%p\n", __FUNCTION__, (void *)GET_POOL_HND(dfb_bcmnexus ));

#ifdef BCMNEXUS_GFX_HAS_V3D
    DFB_Platform_P_GetSharedSettings(DFB_PlatformSharedSetting_e3DGraphicsPool,(void*)&pool);
    SET_GFX3D_POOL_HND(dfb_bcmnexus,pool);
    D_DEBUG_AT( bcmnexusSystem, "%s() 3D GFX pool handle=%p\n", __FUNCTION__, (void *)GET_GFX3D_POOL_HND(dfb_bcmnexus ));
#endif

    /* register screens and layers */
    register_screens_layers( dfb_bcmnexus );

    /* set this first before pool join */
    *data = dfb_bcmnexus;

    if (GET_POOL_HND(dfb_bcmnexus))
        dfb_surface_pool_join( core, GET_POOL_HND(dfb_bcmnexus), &bcmnexusPoolFunctions );

    if (GET_GFX3D_POOL_HND(dfb_bcmnexus))
        dfb_surface_pool_join( core, GET_GFX3D_POOL_HND(dfb_bcmnexus), &bcmnexusGraphics3DPoolFunctions );

    return DFB_OK;
}

static DFBResult
system_shutdown( UNUSED_ bool emergency )
{
    DFBBCMNEXUS *dfb_bcmnexus = (DFBBCMNEXUS *) dfb_system_data();

    FusionSHMPoolShared *pool;

    D_DEBUG_AT( bcmnexusSystem, "%s()\n", __FUNCTION__ );

    D_ASSERT( dfb_bcmnexus != NULL );

#if NEXUS_HAS_PICTURE_DECODER
    pthread_mutex_destroy( &GET_PICTURE_DECODER_LOCK(dfb_bcmnexus) );
#endif

    /* Unregister screens */
    unregister_screens_layers(dfb_bcmnexus);

    /* Destroy the surface pool(s) used by Nexus */
    if (GET_GFX3D_POOL_HND(dfb_bcmnexus))
        dfb_surface_pool_destroy( GET_GFX3D_POOL_HND(dfb_bcmnexus) );

    if (GET_POOL_HND(dfb_bcmnexus))
        dfb_surface_pool_destroy( GET_POOL_HND(dfb_bcmnexus) );

    pool = dfb_core_shmpool( dfb_bcmnexus_core );
    SHFREE( pool, dfb_bcmnexus );

    dfb_bcmnexus_core = NULL;

    /* Call to uninitialise platform code */
    DFB_Platform_Uninit();

    return DFB_OK;
}

static DFBResult
system_leave( UNUSED_ bool emergency )
{
    DFBBCMNEXUS *dfb_bcmnexus = (DFBBCMNEXUS *) dfb_system_data();

    D_DEBUG_AT( bcmnexusSystem, "%s()\n", __FUNCTION__ );

    /* Leave the surface pool(s) used by Nexus */
    if (GET_GFX3D_POOL_HND(dfb_bcmnexus))
        dfb_surface_pool_leave( GET_GFX3D_POOL_HND(dfb_bcmnexus) );

    if (GET_POOL_HND(dfb_bcmnexus))
        dfb_surface_pool_leave( GET_POOL_HND(dfb_bcmnexus) );

    D_FREE(dfb_bcmnexus);

    /* Call to uninitialise platform code */
    DFB_Platform_Uninit();

    return DFB_OK;
}

static DFBResult
system_suspend()
{
    D_DEBUG_AT( bcmnexusSystem, "%s()\n", __FUNCTION__ );
    return DFB_UNIMPLEMENTED;
}

static DFBResult
system_resume()
{
    D_DEBUG_AT( bcmnexusSystem, "%s()\n", __FUNCTION__ );
    return DFB_UNIMPLEMENTED;
}

/******************************************************************************/

static volatile void *
system_map_mmio( UNUSED_ unsigned int    offset,
                 UNUSED_ int             length )
{
    return NULL;
}

static void
system_unmap_mmio( UNUSED_ volatile void  *addr,
                   UNUSED_ int             length )
{
    return;
}

static int
system_get_accelerator()
{
    return -1;
}

static VideoMode *
system_get_modes()
{
    /* TODO: Generate and return a list of all video modes
     * possible.  The application will select amongst the mode
     * returned to set the display resolution, etc. */
    return NULL;
}

static VideoMode *
system_get_current_mode()
{
    return NULL;
}

static DFBResult
system_thread_init()
{
        return DFB_UNIMPLEMENTED;
}

static bool
system_input_filter( UNUSED_ CoreInputDevice *device,
                     UNUSED_ DFBInputEvent   *event )
{
    return false;
}

static unsigned long
system_video_memory_physical( UNUSED_ unsigned int offset )
{
    return 0;
}

static void *
system_video_memory_virtual( unsigned int offset )
{
    (void)offset;

    /* "unused" in DirectFB 1.3.x */
    return 0;
}

static unsigned int
system_videoram_length()
{
    unsigned int size = 0;
    NEXUS_HeapHandle heap;
    NEXUS_MemoryStatus status;
    DFBBCMNEXUS *dfb_bcmnexus;

    D_DEBUG_AT( bcmnexusSystem, "%s() Enter\n", __FUNCTION__ );

    dfb_bcmnexus = (DFBBCMNEXUS *) dfb_system_data();


    heap = GET_DISPLAY_HEAP_HND(dfb_bcmnexus);

    if (heap)
    {
        if (NEXUS_Heap_GetStatus(heap, &status) == NEXUS_SUCCESS)
            size = status.size;
    }

    D_DEBUG_AT( bcmnexusSystem, "%s() Exit (size=%d)\n", __FUNCTION__, size );

    return size;
}

static unsigned long
system_aux_memory_physical( UNUSED_ unsigned int offset )
{
    return 0;
}

static void *
system_aux_memory_virtual( UNUSED_ unsigned int offset )
{
    return NULL;
}

static unsigned int
system_auxram_length()
{
    return 0;
}

static void
system_get_busid( int *ret_bus,
                  int *ret_dev,
                  int *ret_func )
{
    *ret_bus  = 0;
    *ret_dev  = 0;
    *ret_func = 0;
}

static void
system_get_deviceid( unsigned int *ret_vendor_id,
                     unsigned int *ret_device_id )
{
    *ret_vendor_id = 0;
    *ret_device_id = 0;
}

#if ((DIRECTFB_MAJOR_VERSION * 1000000 + \
      DIRECTFB_MINOR_VERSION * 1000 + \
      DIRECTFB_MICRO_VERSION) >= 1004013)


static int
system_surface_data_size( void )
{
     /* Return zero because shared surface data is unneeded. */
     return 0;
}

static void
system_surface_data_init( CoreSurface *surface, void *data )
{
     /* Ignore since unneeded. */
    (void)surface;
    (void)data;
     return;
}

static void
system_surface_data_destroy( CoreSurface *surface, void *data )
{
     /* Ignore since unneeded. */
    (void)surface;
    (void)data;
     return;
}
#endif
