Libav
=====

[![Build Status](https://travis-ci.org/libav/libav.svg)](https://travis-ci.org/libav/libav)

Libav is a collection of libraries and tools to process multimedia content
such as audio, video, subtitles and related metadata.

## Libraries

* `libavcodec` provides implementation of a wider range of codecs.
* `libavformat` implements streaming protocols, container formats and basic I/O access.
* `libavutil` includes hashers, decompressors and miscellaneous utility functions.
* `libavfilter` provides a mean to alter decoded Audio and Video through chain of filters.
* `libavdevice` provides an abstraction to access capture and playback devices.
* `libavresample` implements audio mixing and resampling routines.
* `libswscale` implements color conversion and scaling routines.

## Tools

* [avconv](http://libav.org/avconv.html) is a command line toolbox to
  manipulate, convert and stream multimedia content.
* [avplay](http://libav.org/avplay.html) is a minimalistic multimedia player.
* [avprobe](http://libav.org/avprobe.html) is a simple analisys tool to inspect
  multimedia content.
* Additional small tools such as `aviocat`, `ismindex` and `qt-faststart`.

## Documentation

The offline documentation is available in the **doc/** directory.

The online documentation is available in the main [website](http://libav.org)
and in the [wiki](http://wiki.libav.org).

### Examples

Conding examples are available in the **doc/example** directory.

## License

Libav codebase is mainly LGPL-licensed with optional components licensed under
GPL. Please refer to the LICENSE file for detailed information.
