/*
 * Copyright © 2018 Broadcom.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 */

#ifndef __EIO_BOOT_H__
#define __EIO_BOOT_H__

#define EIO_BOOT_MAGIC			0x331100BB
#define EIO_BOOT_VERSION		1
#define EIO_BOOT_NUM_ALT_PART		2
#define EIO_BOOT_SUFFIX_LEN   		8
#define EIO_BOOT_REBOOT_DATA_SPARE_SLOT 0

struct eio_boot_slot {
	char     suffix[EIO_BOOT_SUFFIX_LEN];
	int32_t  valid;
	int32_t  boot_try;
	int32_t  boot_ok;
	int32_t  boot_fail;
	int32_t  dmv_corrupt;
	int32_t  spare[128];
};

struct eio_boot {
	int32_t  magic;
	int32_t  version;
	int32_t  curr;
	struct   eio_boot_slot slot[EIO_BOOT_NUM_ALT_PART];
	int32_t  onboot;
	int32_t  spare[255];
};

#endif
