/******************************************************************************
 *  Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors.
 *  Copyright (C) 2017 Broadcom. The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
 *
 *  This program is the proprietary software of Broadcom and/or its licensors,
 *  and may only be used, duplicated, modified or distributed pursuant to the terms and
 *  conditions of a separate, written license agreement executed between you and Broadcom
 *  (an "Authorized License").  Except as set forth in an Authorized License, Broadcom grants
 *  no license (express or implied), right to use, or waiver of any kind with respect to the
 *  Software, and Broadcom expressly reserves all rights in and to the Software and all
 *  intellectual property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU
 *  HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY
 *  NOTIFY BROADCOM AND DISCONTINUE ALL USE OF THE SOFTWARE.
 *
 *  Except as expressly set forth in the Authorized License,
 *
 *  1.     This program, including its structure, sequence and organization, constitutes the valuable trade
 *  secrets of Broadcom, and you shall use all reasonable efforts to protect the confidentiality thereof,
 *  and to use this information only in connection with your use of Broadcom integrated circuit products.
 *
 *  2.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
 *  AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
 *  WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH RESPECT TO
 *  THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND ALL IMPLIED WARRANTIES
 *  OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE,
 *  LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION
 *  OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF
 *  USE OR PERFORMANCE OF THE SOFTWARE.
 *
 *  3.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR ITS
 *  LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL, INDIRECT, OR
 *  EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY RELATING TO YOUR
 *  USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM HAS BEEN ADVISED OF
 *  THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT
 *  ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE
 *  LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF
 *  ANY LIMITED REMEDY.
 ******************************************************************************/

#include "vlHalSnmpUtils.h"
//#include <rdk_debug.h>
//#include <vlMalloc.h>
//#include "vlMemCpy.h"
#include <string.h>
#include "rdk_debug.h"
#include "rmf_osal_mem.h"
#include <time.h>

//#if defined(USE_PACE_MFR)
#if defined(USE_PACE_MFR_DIAGS) //TBD Replace with Broadcom API
#include "pace_diag_api.h"
#include "pace_diag_common.h"
#include "pace_diag_temperature_api.h"

PACEDIAG_State  vl_gPacediagState;
PACEDIAG_State  *vl_gpPacediagState = NULL;

#endif


#include  "nexus_avs.h"

cVector* vlg_devList = NULL;
static rmf_osal_Mutex vlg_SnmpUtilsMutex=0;
#define LIST_OR_MUTEX_NULL ((NULL == vlg_devList) || (vlg_SnmpUtilsMutex == NULL))
int    gTempMaxValue = 0;

sTempDescrInfo    vlg_HostTempDescInfo[MAX_NUM_TEMP_SENSOR_TYPES];

int CHALSnmp_init()
{
  int i;
  
//#if defined(USE_PACE_MFR)
#if defined(USE_PACE_MFR_DIAGS)

    PACEDIAG_Error status  = PACEDIAG_ERROR_FAILED;
    if ((status =  PACEDIAG_init(&vl_gPacediagState)) != PACEDIAG_ERROR_OK)
    {
     RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.SNMP","%s ERROR : failed to initialise PACEDIAG library - status was %d\n",__FUNCTION__,status);
      return -1;
    }
    
    vl_gpPacediagState = &vl_gPacediagState;

#if 0    
    PACEDIAG_HostSystemTemperatureSensor sensor;
    int sensorType[] = {PACEDIAG_INFO_HOST_SYSTEM_TEMP_SENSOR_ID_CPU, PACEDIAG_INFO_HOST_SYSTEM_TEMP_SENSOR_ID_HARDDISK_INTERNAL, PACEDIAG_INFO_HOST_SYSTEM_TEMP_SENSOR_ID_MAINBOARD};
    int vlSensorType[] = {HOST_SYSTEM_SENSOR_TYPE_CPU, HOST_SYSTEM_SENSOR_TYPE_HDD_INTERNAL, HOST_SYSTEM_SENSOR_TYPE_MAINBOARD};


    for(i = 0; i < MAX_NUM_TEMP_SENSOR_TYPES; i++)
    {
      if ((status = PACEDIAG_getHostSystemTemperatureSensor(vl_gpPacediagState, PACEDIAG_INFO_HOST_SYSTEM_TEMP_SENSOR_ID_CPU, &sensor)) != PACEDIAG_ERROR_OK)
      {
          RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.SNMP","%s ERROR : failed to get HostSystemTemperatureSensor info for %d type and Name %s - status %d\n",__FUNCTION__, sensorType[i], PACEDIAG_hostSystemTemperatureSensorName(&sensor), status);
      }
      else
      {
          vlg_HostTempDescInfo[i].sensorType    = vlSensorType[i];
          vlMemCpy(vlg_HostTempDescInfo[i].name, PACEDIAG_hostSystemTemperatureSensorName(&sensor), PACEDIAG_INFO_HOST_SYSTEM_TEMP_SENSOR_NAME_LENGTH, MAX_DESCR_NAME_LEN);
          
          vlg_HostTempDescInfo[i].length        = strlen(vlg_HostTempDescInfo[i].name);
          vlg_HostTempDescInfo[i].tempValue     = PACEDIAG_hostSystemTemperatureSensorProperty(&sensor, PACEDIAG_INFO_HOST_SYSTEM_TEMP_SENSOR_VALUE);
          vlg_HostTempDescInfo[i].tempLastUpdate= PACEDIAG_hostSystemTemperatureSensorProperty(&sensor, PACEDIAG_INFO_HOST_SYSTEM_TEMP_SENSOR_LAST_VALUE);
          vlg_HostTempDescInfo[i].tempMaxVal    = PACEDIAG_hostSystemTemperatureSensorProperty(&sensor, PACEDIAG_INFO_HOST_SYSTEM_TEMP_SENSOR_MAX_VALUE);
          
          RDK_LOG(RDK_LOG_INFO, "LOG.RDK.SNMP","temp sensor  for '%s' is at %u degrees (max %u) (last update val %u) \n", 
            PACEDIAG_hostSystemTemperatureSensorName(&sensor),vlg_HostTempDescInfo[i].tempValue, vlg_HostTempDescInfo[i].tempMaxVal, vlg_HostTempDescInfo[i].tempLastUpdate);
      }
    }
#endif    
#endif
  return 0;
}

int HAL_SNMP_Get_HostSystemTempDetails(HOST_SYSTEM_SENSOR_TYPE sensorType, sTempDescrInfo  *pTempDescrInfo)
{
    int i;
    int vlSensorType[] = {HOST_SYSTEM_SENSOR_TYPE_CPU, HOST_SYSTEM_SENSOR_TYPE_HDD_INTERNAL, HOST_SYSTEM_SENSOR_TYPE_MAINBOARD};
//#if defined(USE_PACE_MFR)
#if defined(USE_PACE_MFR_DIAGS)
    int sensorTypeArr[] = {PACEDIAG_INFO_HOST_SYSTEM_TEMP_SENSOR_ID_CPU, PACEDIAG_INFO_HOST_SYSTEM_TEMP_SENSOR_ID_HARDDISK_INTERNAL, PACEDIAG_INFO_HOST_SYSTEM_TEMP_SENSOR_ID_MAINBOARD};
#endif
    NEXUS_Error  rc = NEXUS_SUCCESS;
    NEXUS_AvsStatus avsData;
    unsigned char descr[MAX_DESCR_NAME_LEN] = "BCM STB Chip Sensor";
    time_t seconds;
    
    if(NULL == pTempDescrInfo)
    {
      return -1;
    }

    memset(pTempDescrInfo, 0, sizeof(sTempDescrInfo));
    
//#if defined(USE_PACE_MFR)
#if defined(USE_PACE_MFR_DIAGS)
    if(NULL == vl_gpPacediagState)
    {
      return -1;
    }
    
    PACEDIAG_Error status  = PACEDIAG_ERROR_FAILED;
    PACEDIAG_HostSystemTemperatureSensor sensor;
    //PACEDIAG_Error status  = PACEDIAG_ERROR_FAILED;
    
    RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SNMP","%s. for sensorType = %d\n", __FUNCTION__, sensorType);
    for(i = 0; i < MAX_NUM_TEMP_SENSOR_TYPES; i++)
    {
      if(sensorType == vlSensorType[i])
      {
        if ((status = PACEDIAG_getHostSystemTemperatureSensor(vl_gpPacediagState, sensorTypeArr[i], &sensor)) != PACEDIAG_ERROR_OK)
        {
            RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.SNMP","%s ERROR : failed to get HostSystemTemperatureSensor info for %d type and Name %s - status %d\n",__FUNCTION__, sensorTypeArr[i], PACEDIAG_hostSystemTemperatureSensorName(&sensor), status);
        }
        else
        {
            memcpy(pTempDescrInfo->name, PACEDIAG_hostSystemTemperatureSensorName(&sensor), PACEDIAG_INFO_HOST_SYSTEM_TEMP_SENSOR_NAME_LENGTH);
            
            pTempDescrInfo->length        = strlen((const char*)pTempDescrInfo->name);
            pTempDescrInfo->tempValue     = PACEDIAG_hostSystemTemperatureSensorProperty(&sensor, PACEDIAG_INFO_HOST_SYSTEM_TEMP_SENSOR_VALUE);
            pTempDescrInfo->tempLastUpdate= PACEDIAG_hostSystemTemperatureSensorProperty(&sensor, PACEDIAG_INFO_HOST_SYSTEM_TEMP_SENSOR_LAST_VALUE);
            pTempDescrInfo->tempMaxVal    = PACEDIAG_hostSystemTemperatureSensorProperty(&sensor, PACEDIAG_INFO_HOST_SYSTEM_TEMP_SENSOR_MAX_VALUE);
            
            RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SNMP","temp sensor  for '%s' is at %u degrees (max %u) (last update val %u) \n", 
              PACEDIAG_hostSystemTemperatureSensorName(&sensor),pTempDescrInfo->tempValue, pTempDescrInfo->tempMaxVal, pTempDescrInfo->tempLastUpdate);
        }
        
        return 0; 
      }
    }
#endif
/*  for(i = 0; i < MAX_NUM_TEMP_SENSOR_TYPES; i++)
  {
    if(sensorType == vlg_HostTempDescInfo[i].sensorType)
    {
         vlMemCpy(pTempDescrInfo, &vlg_HostTempDescInfo[i], sizeof(sTempDescrInfo), sizeof(sTempDescrInfo));
         return 0; 
    }
  }*/
  
  if ( HOST_SYSTEM_SENSOR_TYPE_CPU == sensorType)
  {
    memcpy(pTempDescrInfo->name, descr, sizeof(descr));
    pTempDescrInfo->length  = strlen((const char*)pTempDescrInfo->name);
    seconds = time(NULL);
	pTempDescrInfo->tempLastUpdate = seconds;
    rc = NEXUS_GetAvsStatus(&avsData);
    if (rc != NEXUS_SUCCESS) return rc;
    if(avsData.enabled){
        pTempDescrInfo->tempValue = avsData.temperature/1000;
        if (pTempDescrInfo->tempValue > gTempMaxValue)
            gTempMaxValue = pTempDescrInfo->tempValue;
        pTempDescrInfo->tempMaxVal = gTempMaxValue;
    }else
    {
        pTempDescrInfo->tempValue = 0;
		pTempDescrInfo->tempMaxVal = 0;
    }
  }
  return 0;
}


unsigned int AddToConnList(ConnDetails* pConnDetails)
{
	int retCode = RMF_SUCCESS;
	ConnDetails* ptConnDetails;
	rmf_osal_memAllocP(RMF_OSAL_MEM_POD, sizeof(ConnDetails), (void **)&ptConnDetails);
	memset(ptConnDetails, 0, sizeof(ConnDetails));
	memcpy(ptConnDetails, pConnDetails, sizeof(ConnDetails));

	if(NULL == vlg_devList)
	{
		retCode = rmf_osal_mutexNew(&vlg_SnmpUtilsMutex);
		if(retCode != RMF_SUCCESS)
		{
			/* coverity fix - 13/5 */
			//RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SNMP", "\n WARNING!!! Could not create snmp utils mutex \n");
			rmf_osal_memFreeP(RMF_OSAL_MEM_POD, ptConnDetails);			
			return retCode;
		}
		vlg_devList = cVectorCreate(10, 10);
	}

	if(LIST_OR_MUTEX_NULL)
	{
		/* coverity fix - 13/5 */
		rmf_osal_memFreeP(RMF_OSAL_MEM_POD, ptConnDetails);	
		return 0;
	}
	rmf_osal_mutexAcquire(vlg_SnmpUtilsMutex);

	cVectorAdd(vlg_devList, (cVectorElement)ptConnDetails);

	rmf_osal_mutexRelease(vlg_SnmpUtilsMutex);

	return retCode;
}

unsigned int RemFromConnList(unsigned long devIndex, deviceType devType)
{
	int listIter = 0;
	ConnDetails* ptConnDetails = NULL;

	if(LIST_OR_MUTEX_NULL)
		return 0;
	
	rmf_osal_mutexAcquire(vlg_SnmpUtilsMutex);

	for(listIter = 0; listIter < cVectorSize(vlg_devList); listIter++)
	{ 
		ptConnDetails = (ConnDetails*) cVectorGetElementAt(vlg_devList, listIter);
		if(ptConnDetails != NULL)
		{
			if((devIndex == ptConnDetails->devIndex) && (devType == ptConnDetails->devType))
			{
		
				cVectorRemoveElementAt(vlg_devList, listIter);
				rmf_osal_memFreeP(RMF_OSAL_MEM_POD, ptConnDetails);
				break;
			}
		}
	}

	if(cVectorSize(vlg_devList) == 0)
	{
		cVectorClear(vlg_devList);
	}

	rmf_osal_mutexRelease(vlg_SnmpUtilsMutex);
    
    return 1;
}


unsigned int GetConnListElement(ConnDetails* pConnDetails, unsigned int listIter)
{
	ConnDetails* ptConnDetails = NULL;

	if(LIST_OR_MUTEX_NULL)
		return 0;

	rmf_osal_mutexAcquire(vlg_SnmpUtilsMutex);

	ptConnDetails = (ConnDetails*) cVectorGetElementAt(vlg_devList, listIter);

	if(ptConnDetails != NULL)
		memcpy(pConnDetails, ptConnDetails, sizeof(ConnDetails));
	
	rmf_osal_mutexRelease(vlg_SnmpUtilsMutex);

    return 1;
}

unsigned int GetConnListSize(unsigned int* listSize)
{
	if(LIST_OR_MUTEX_NULL)
		return 0;

	rmf_osal_mutexAcquire(vlg_SnmpUtilsMutex);
	*listSize = cVectorSize(vlg_devList);
	rmf_osal_mutexRelease(vlg_SnmpUtilsMutex);
    
    return 1;
}
