/* Copyright */
/*******************************************************************************
********************************************************************************
*
*  File        :  
*
*  Description :  APIs to use Front Panel Driver
*
*  Notes       :  Pace has extended this header to include key functionalities
*
*  Author      :  
*
*  Copyright   :  Pace Micro Technology 2010 (c)
*
*                 The copyright of this material is owned by Pace
*                 Microtechnology PLC ("PACE").  This material is
*                 regarded as a highly confidential trade secret of
*                 Pace.  It may not be reproduced, used, sold or in any
*                 other way exploited or transferred to any other
*                 third party without the prior consent of Pace.
*
********************************************************************************
*******************************************************************************/
/* File DOC */

#ifndef __PARKER_FPD_API_H__
#define __PARKER_FPD_API_H__

#ifdef __cplusplus
extern "C" {
#endif

typedef enum _PARKER_FPD_API_RESULT
{
    PARKER_FPD_API_RESULT_SUCCESS = 0,
    PARKER_FPD_API_RESULT_FAILED,
    PARKER_FPD_API_RESULT_NULL_PARAM,
    PARKER_FPD_API_RESULT_INVALID_PARAM

}PARKER_FPD_API_RESULT;

typedef enum _PARKER_FPD_BRIGHTNESS
{
    PARKER_FPD_BRIGHTNESS_OFF = 0,
    PARKER_FPD_BRIGHTNESS_1   = 64,
    PARKER_FPD_BRIGHTNESS_2   = 128,
    PARKER_FPD_BRIGHTNESS_3   = 192,
    PARKER_FPD_BRIGHTNESS_MAX = 100,

}PARKER_FPD_BRIGHTNESS;

typedef enum _PARKER_FPD_COLOR
{
    PARKER_FPD_COLOR_BLUE = 1,
    PARKER_FPD_COLOR_GREEN = 2,
    PARKER_FPD_COLOR_ORANGE = 16,
    PARKER_FPD_COLOR_RED = 4,
    PARKER_FPD_COLOR_YELLOW = 8,

}PARKER_FPD_COLOR;

#define PARKER_FPD_SUPPORTED_COLORS  (PARKER_FPD_COLOR_BLUE | \
                                      PARKER_FPD_COLOR_GREEN | \
                                      PARKER_FPD_COLOR_ORANGE | \
                                      PARKER_FPD_COLOR_RED | \
                                      PARKER_FPD_COLOR_YELLOW )

typedef enum _PARKER_FPD_INDICATOR
{
    PARKER_FPD_INDICATOR_TEXT = 1,
    PARKER_FPD_INDICATOR_MESSAGE = 2,
    PARKER_FPD_INDICATOR_POWER = 4,
    PARKER_FPD_INDICATOR_RECORD = 8,
    PARKER_FPD_INDICATOR_REMOTE = 16,
    PARKER_FPD_INDICATOR_RFBYPASS = 32,

}PARKER_FPD_INDICATOR;

typedef enum _PARKER_FPD_INDICATOR_SUPPORTED_COLORS
{
    PARKER_FPD_INDICATOR_SUPPORTED_COLORS_TEXT      = PARKER_FPD_SUPPORTED_COLORS,
    PARKER_FPD_INDICATOR_SUPPORTED_COLORS_MESSAGE   = PARKER_FPD_SUPPORTED_COLORS,
    PARKER_FPD_INDICATOR_SUPPORTED_COLORS_POWER     = PARKER_FPD_SUPPORTED_COLORS,
    PARKER_FPD_INDICATOR_SUPPORTED_COLORS_RECORD    = PARKER_FPD_SUPPORTED_COLORS,
    PARKER_FPD_INDICATOR_SUPPORTED_COLORS_REMOTE    = PARKER_FPD_SUPPORTED_COLORS,
    PARKER_FPD_INDICATOR_SUPPORTED_COLORS_RFBYPASS  = PARKER_FPD_SUPPORTED_COLORS,

}PARKER_FPD_INDICATOR_SUPPORTED_COLORS;

typedef enum _PARKER_FPD_INDICATOR_MAX_BRIGHTNESS
{
    PARKER_FPD_INDICATOR_MAX_BRIGHTNESS_TEXT          = PARKER_FPD_BRIGHTNESS_MAX,
    PARKER_FPD_INDICATOR_MAX_BRIGHTNESS_MESSAGE       = PARKER_FPD_BRIGHTNESS_MAX,
    PARKER_FPD_INDICATOR_MAX_BRIGHTNESS_POWER         = PARKER_FPD_BRIGHTNESS_MAX,
    PARKER_FPD_INDICATOR_MAX_BRIGHTNESS_RECORD        = PARKER_FPD_BRIGHTNESS_MAX,
    PARKER_FPD_INDICATOR_MAX_BRIGHTNESS_REMOTE        = PARKER_FPD_BRIGHTNESS_MAX,
    PARKER_FPD_INDICATOR_MAX_BRIGHTNESS_RFBYPASS      = PARKER_FPD_BRIGHTNESS_MAX,

}PARKER_FPD_INDICATOR_MAX_BRIGHTNESS;

typedef enum _PARKER_FPD_INDICATOR_MAX_CYCLE_RATES
{
    PARKER_FPD_INDICATOR_MAX_CYCLE_RATES_TEXT          = 2,
    PARKER_FPD_INDICATOR_MAX_CYCLE_RATES_MESSAGE       = 2,
    PARKER_FPD_INDICATOR_MAX_CYCLE_RATES_POWER         = 2,
    PARKER_FPD_INDICATOR_MAX_CYCLE_RATES_RECORD        = 2,
    PARKER_FPD_INDICATOR_MAX_CYCLE_RATES_REMOTE        = 2,
    PARKER_FPD_INDICATOR_MAX_CYCLE_RATES_RFBYPASS      = 2,

}PARKER_FPD_INDICATOR_MAX_CYCLE_RATES;

typedef enum _PARKER_FPD_TIME
{
    PARKER_FPD_TIME_OFF     = 0,
    PARKER_FPD_TIME_12_HOUR = 1,
    PARKER_FPD_TIME_24_HOUR = 2,

}PARKER_FPD_TIME;

typedef enum _PARKER_FPD_KEY
{
    PARKER_FPD_SOFT_KEY_1 = 0x1,
    PARKER_FPD_SOFT_KEY_2 = 0x2,
    PARKER_FPD_POWER_KEY = 0x4,
}PARKER_FPD_KEY;

typedef int (*PARKER_FPD_CALLBACK) (PARKER_FPD_KEY eKeyPressed, char * pCookie);

#define PARKER_FPD_MAX_HORZ_ITERATIONS  5     // the maximum number of times per minute characters can scroll right to left across the display with zero hold time set.
#define PARKER_FPD_MAX_VERT_ITERATIONS  20    // the maximum number of times per minute characters can scroll bottom to top across the display with zero hold time set.
#define PARKER_FPD_MAX_VERT_ROWS        1     // the maximum number of times per minute characters can scroll right to left across the display with zero hold time set.
#define PARKER_FPD_MAX_HORZ_COLS        4     // the maximum number of times per minute characters can scroll bottom to top across the display with zero hold time set.
#define PARKER_FPD_INDICATOR_TOTAL_COUNT 6
    
#define PARKER_FPD_SUPPORTED_CHARACTERS  " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~"

// Initialisation function. MUST be called before any other APIs
PARKER_FPD_API_RESULT parker_FPD_Init(void);

/* API DOC */
// pszChars    : null terminated ascii string
PARKER_FPD_API_RESULT parker_FPD_SetText(char * pszChars);

/* API DOC */
// nCharacters : number of items in array 'paChars'
// paChars     : array of ascii characters (may not be terminated with null)
PARKER_FPD_API_RESULT parker_FPD_SetChars(int nCharacters, char * paChars);

/* API DOC */
// nLines    : number of items in array 'paszLines'
// paszLines : array of null terminated ascii strings
PARKER_FPD_API_RESULT parker_FPD_SetParagraph (int nLines, char * paszLines[]);

/* API DOC */
// eTime   : the time format
// nHours  : the currrent hour (0 - 23)
// paChars : the current minute (0 - 59)
PARKER_FPD_API_RESULT parker_FPD_SetTime (PARKER_FPD_TIME eTime, int nHours, int nMinutes);

/* API DOC */
// nScrollHoldOnDur      : the percentage of time to hold at each character before scrolling it to the next position during one scroll iteration.
// nHorzScrollIterations : the number of times per minute one character will scroll across the display from right to left.
// nVertScrollIterations : the number of times per minute one character will scroll across the display from bottom to top.
PARKER_FPD_API_RESULT parker_FPD_SetScroll(int nScrollHoldOnDur, int nHorzScrollIterations, int nVertScrollIterations);

/* API DOC */
// eIndicator       : the specified indicator
// nBlinkDuration   : the percentage of time the text display will remain on during one blink iteration.
// nBlinkIterations : the number of times per minute data will blink across all of the LEDs.
PARKER_FPD_API_RESULT parker_FPD_SetBlink(PARKER_FPD_INDICATOR eIndicator, int nBlinkDuration, int nBlinkIterations);

/* API DOC */
// eIndicator  : the specified indicator
// eBrightness : the brightness of the indicator.
PARKER_FPD_API_RESULT parker_FPD_SetBrightness(PARKER_FPD_INDICATOR eIndicator, PARKER_FPD_BRIGHTNESS eBrightness);

/* API DOC */
// eIndicator : the specified indicator
// eColor     : the color of this indicator
PARKER_FPD_API_RESULT parker_FPD_SetColor(PARKER_FPD_INDICATOR eIndicator, PARKER_FPD_COLOR eColor);

/* PACE DRIVER */
// eMode : Use PARKER_FPD_TIME_OFF to disable and PARKER_FPD_TIME_xx_HOUR to enable display of clock
PARKER_FPD_API_RESULT parker_FPD_clockDisplay (PARKER_FPD_TIME eMode);

/* PACE DRIVER */
//eSoftKey    : The button to which the text label corresponds to
//pszChars    : Null terminated ascii string
PARKER_FPD_API_RESULT parker_FPD_SetSoftKeyText(PARKER_FPD_KEY eSoftKey, char *pszLabel);

/* PACE DRIVER */
//pCallbackFunction  : Callback function to be registered. This will be called when any key is pressed
//pCookie            : Pointer to retured while calling the callback function
PARKER_FPD_API_RESULT parker_FPD_RegisterKeyCallback(PARKER_FPD_CALLBACK pCallbackFunction, char *pCookie  );

/* PACE DRIVER */
//pCallbackFunction  : Callback function to be un-registered.
PARKER_FPD_API_RESULT parker_FPD_UnRegisterKeyCallback(PARKER_FPD_CALLBACK pCallbackFunction);

#ifdef __cplusplus
}
#endif

#endif // __PARKER_FPD_API_H__
