/******************************************************************************
* Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors. 
* All rights reserved.
*
* This software is the confidential and proprietary information of SeaChange
* ("Confidential Information"). You shall not disclose this source code or 
* such Confidential Information and shall use it only in accordance with the 
* terms of the license agreement you entered into.
*  
* SEACHANGE INERNATIONAL  MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
* SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT 
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SEACHANGE SHALL NOT BE LIABLE FOR 
* ANY DAMAGES SUFFERED BY LICENSEE NOR SHALL THEY BE RESPONSIBLE AS A RESULT 
* OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*******************************************************************************/


#ifndef HAL_MODULE_H
#define HAL_MODULE_H

#include "hal_log.h"
#include "hal_prio.h"

#ifdef __cplusplus
extern "C" {
#endif

/*===================================================================
   INCLUDES AND PUBLIC DATA DECLARATIONS
===================================================================*/

/*-------------------------------------------------------------------
   Defines/Macros
-------------------------------------------------------------------*/

/****************/
/* MODULE NAMES */
/****************/

#define HAL_MAX_LOG_MODULE      64

#define HAL_MODULE_GENERAL_NAME "HAL_GEN"
#define HAL_MODULE_ANAAUD_NAME  "HAL_ANAAUD"
#define HAL_MODULE_ANAVID_NAME  "HAL_ANAVID"
#define HAL_MODULE_CRYPTO_NAME  "HAL_CRYPTO"
#define HAL_MODULE_DISP_NAME    "HAL_DISP"
#define HAL_MODULE_EEPROM_NAME  "HAL_EEPROM"
#define HAL_MODULE_FPD_NAME     "HAL_FPD"
#define HAL_MODULE_GFX_NAME     "HAL_GFX"
#define HAL_MODULE_HID_NAME     "HAL_HID"
#define HAL_MODULE_IRB_NAME     "HAL_IRB"
#define HAL_MODULE_MPAUD_NAME   "HAL_MPAUD"
/*#define HAL_MODULE_MPENC_NAME   "HAL_MPENC" */
#define HAL_MODULE_MPVID_NAME   "HAL_MPVID"
#define HAL_MODULE_SECTFLT_NAME "HAL_SECTFLT"
/*#define HAL_MODULE_PCM_NAME     "HAL_PCM" */
#define HAL_MODULE_SYS_NAME     "HAL_SYS"
#define HAL_MODULE_TUNER_NAME   "HAL_TUNER"
#define HAL_MODULE_VBI_NAME     "HAL_VBI"

#define PDT_TRANS_NAME          "PDT_TRANS"
#define PDT_TSMGR_NAME          "PDT_TSMGR"
#define PDT_PCR_NAME            "PDT_PCR"
#define PDT_UTILS_NAME          "PDT_UTILS"
#define PDT_CC_NAME             "PDT_CC"
#define PDT_POD_NAME            "PDT_POD"

#ifdef USE_POD
#define HAL_MODULE_POD_NAME    "HAL_POD"
#endif

#ifdef USE_DSG
#define HAL_MODULE_DSG_NAME "HAL_DSG"
#endif
    
#ifdef USE_MFR
#define HAL_MODULE_MFR_NAME "HAL_MFR"
#endif
    
#ifdef USE_CDL
#define HAL_MODULE_CDL_NAME "HAL_CDL"
#endif
    
#ifdef USE_1394
#define HAL_MODULE_1394_NAME "HAL_1394"
#endif
    
#define HAL_MODULE_GENERAL  "LOG.RDK.TARGET"
#define HAL_MODULE_ANAVID   "LOG.RDK.MEDIA"
#define HAL_MODULE_ANAAUD   "LOG.RDK.SOUND"
#define HAL_MODULE_CRYPTO   "LOG.RDK.PROD"
#define HAL_MODULE_DISP     "LOG.RDK.DISP"
#define HAL_MODULE_EEPROM   "LOG.RDK.PROD"
#define HAL_MODULE_FPD      "LOG.RDK.FPD"
#define HAL_MODULE_GFX      "LOG.RDK.GFX"
#define HAL_MODULE_HID      "LOG.RDK.SYS"
#define HAL_MODULE_IRB      "LOG.RDK.SYS"
#define HAL_MODULE_MPAUD    "LOG.RDK.SOUND"
#define HAL_MODULE_MPVID    "LOG.RDK.MEDIA"
#define HAL_MODULE_DECODER  "LOG.RDK.MEDIA"
#define HAL_MODULE_SECTFLT  "LOG.RDK.FILTER"
#define HAL_MODULE_SYS      "LOG.RDK.SYS"
#define HAL_MODULE_TUNER    "LOG.RDK.MEDIA"
#define HAL_MODULE_VBI      "LOG.RDK.VBI"
#define PDT_TRANS           "LOG.RDK.MEDIA"
#define PDT_TSMGR           "LOG.RDK.MEDIA"
#define PDT_PCR             "LOG.RDK.MEDIA"
#define PDT_UTILS           "LOG.RDK.SYS"
#define PDT_CC              "LOG.RDK.CC"
#define PDT_POD             "LOG.RDK.POD"

#ifdef USE_POD
#define HAL_MODULE_POD      "LOG.RDK.POD"
#endif

#ifdef USE_DSG
#define HAL_MODULE_DSG      "LOG.RDK.POD"
#endif
    
#ifdef USE_MFR
    #define HAL_MODULE_MFR  "LOG.RDK.SYS"
#endif
    
#ifdef USE_CDL
    #define HAL_MODULE_CDL  "LOG.RDK.CDL"
#endif

#ifdef USE_1394
    #define HAL_MODULE_1394 "LOG.RDK.NET"
#endif
/*-------------------------------------------------------------------
   Types/Structs
-------------------------------------------------------------------*/


/*-------------------------------------------------------------------
   Global Data Declarations
-------------------------------------------------------------------*/

/*===================================================================
   FUNCTION PROTOTYPES
===================================================================*/



#ifdef __cplusplus
}
#endif

#endif /* HAL_MODULE_H */
