/******************************************************************************
* Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors. 
* All rights reserved.
*
* This software is the confidential and proprietary information of SeaChange
* ("Confidential Information"). You shall not disclose this source code or 
* such Confidential Information and shall use it only in accordance with the 
* terms of the license agreement you entered into.
*  
* SEACHANGE INERNATIONAL  MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
* SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT 
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SEACHANGE SHALL NOT BE LIABLE FOR 
* ANY DAMAGES SUFFERED BY LICENSEE NOR SHALL THEY BE RESPONSIBLE AS A RESULT 
* OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*******************************************************************************/
#ifdef USE_POD

/* Top level test function entry point. */
#include <stdio.h>
#include "rdk_debug.h"
#if (defined MR05_P1)

//#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <assert.h>

#include "vlHalApi.h"
#include "hal_module.h"
#include "hal_error.h"

#include "pdt_hal.h"
#include "../pod/pod_low_api.h"
#include "../pod/pod_priv.h"
//#include "vlOcapDebug.h"

DECLARE_LOG_APPTYPE (LOG_APPTYPE_OCAP_HAL_DRIVERS_HALPOD)



//extern UINT8 *pucPODMemory;

extern int POD_Init();


int pod_test(int argc, char *argv[])
{
    int status;
    //int offset;
    //int numbytes;
    //int ack;
    unsigned int usrInput;
    unsigned int loopVar=0;
    char readString[30];
    
       


    status = vlhal_sys_Init();

    if( POD_Init() != POD_SUCCESS )
    {
        RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "POD_Init() Failed\n");
        return 0; // Bail out
    }

    HAL_LogRegister(PDT_POD_NAME);

    if (status < 0 ) 
    {
        RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "\n%s : HAL init failed \n", __FUNCTION__);
    }
   
    do
    {

      RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "\n--------------------------------------------------------");
      RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "\n----------------      POD TEST         --------------");
      RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "\n--------------------------------------------------------");
      RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "\n\t 1.  Card Detection Test         ");
      RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "\n\t 2.  Detection of Device          ");
      RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "\n\t 3.  Initialize POD Module        ");
      RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "\n\t 4.  LPDU Test to POD     ");
      RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "\n\t 5.  Set Log Level for POD     ");
      RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "\n\t 6.     ");
      RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "\n\t 7.    ");
      RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "\n\t 8.  Exam Cimax Configuration Registers    ");
      RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "\n\t 0.  Quit Test");
      RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "\n\t Enter your choice (0...8) :: ") ;

      fflush(stdout);
      fgets( readString, sizeof(readString), stdin );
      usrInput = atoi (readString);
    
    

      switch(usrInput)
      {
      case 1:
          //CardDetectionTest();
          break;
     
      case 2:         
          //PODDetectionTest(); 
          break;

      case 3:
          //POD_Init();
          //POD_ModuleInit();
          break;

      case 4:
          //PODLpduTest();
          break;
          

      case 5:
          RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "Enter the Log Level for POD\n");
          RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "0:\tNoise\n1:\tInfo\n2:\tWarning\n3:\tError\n4:\tFatal\n5:\tMax Level\n");
          fflush(stdout);
          fgets( readString, sizeof(readString), stdin );
          usrInput = atoi (readString);
          HAL_LogSetLvl(PDT_POD, usrInput);
          break;


      case 6:
          
        break;

      case 7:
                    
        break;

      case 8:
          //cimaxDumpRegisters();
          break;
          
      case 0:
	      loopVar = 1;
          break;

      default:
          RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "unknown option\n");
          break;
	   
     }

   }while(!loopVar);

   status = vlhal_sys_Shutdown();
   if (status < 0 ) 
   {
      RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "\n%s : HAL shutdown failed \n", __FUNCTION__);
   }
   
   return 1; 
}

#else

int pod_test(int argc, char *argv[])
{
    RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "POD Is Not Supported on V5 argc %d  argv %s \n", argc, *argv);
    return 1;
}


#endif //  MR05_P1 | defined MR06_P0

#if defined(POWER_CTRL_FROM_3255) || defined(RESET_CTRL_FROM_3255)
#include "bstd.h"           /* standard types */
#include "berr.h"           /* error code */
#include "bkni.h"           /* kernel interface */
#include "bkni_multi.h"           /* kernel interface */
#include "brpc.h"
#include "brpc.h"
#include "brpc_3255.h"
#include "brpc_socket.h"

#ifdef BDBG_WRN
#undef BDBG_WRN
#endif
#define BDBG_WRN(x) printf x

#define sizeInLong(x)   (sizeof(x)/sizeof(uint32_t))
#define CHK_RETCODE( rc, func )             \
do {                                        \
    if( (rc = BERR_TRACE(func)) != BERR_SUCCESS ) \
    {                                       \
        goto done;                          \
    }                                       \
} while(0)

static  BRPC_Handle rpc_handle =NULL;
/* currently there is no notfication sent from 3255 regarding POD stuff*/
/* NOT used here*/
#if 0
static bool check_rpc_enabled = true;
static void bpod_process_notification(int event)
{
    BDBG_WRN(("get 3255 ntotification about POD event is %x\n",event));
}

static void check_rpc(BRPC_Handle *rpc_handle)
{

    while (check_rpc_enabled)
    {
        uint32_t device_id, event;

        BRPC_CheckNotification(*rpc_handle,  &device_id, &event, 0);
        if ((event>>16)) {
            RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "check_rpc(): notified by server (device_id = %08x) event is %x\n", device_id, event);
            switch (device_id) {
                case BRPC_DevId_3255_POD:
                    bpod_process_notification(event);
                    break;
                default:
                    break;
            }
        } else {
            BKNI_Sleep(100); /* this is inefficient. use BRPC_GetSocketDescriptor to be efficient */
        }
    }
}
/* The entry point of the notification thread who listens to NOTIFICAION messages
 * from the server and sends NOTIFICAION_ACK message back to the server
 */
void * notification_thread(void *arg)
{
    check_rpc((BRPC_Handle *)arg);
    return NULL;
}
#endif


int bcm_3255_open_rpc()
{
    BRPC_Param_POD_CardOut  Param;
    BRPC_OpenSocketImplSettings socketSettings;
    BERR_Code retVal;
    BERR_Code retCode = BERR_SUCCESS;

    RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "Initializing Broadcom kernel interface ...\n");
    if (BKNI_Init() != BERR_SUCCESS) {
        return -1;
    }

    BRPC_GetDefaultOpenSocketImplSettings(&socketSettings);

    BDBG_MSG(("rpc_main(): Got default settings: ipaddr = %x port_req = %04x port_ack = %04x\n", socketSettings.host,socketSettings.port_req,socketSettings.port_ack));

    BRPC_Open_SocketImpl(&rpc_handle, &socketSettings);

    if (rpc_handle == NULL) {
        BDBG_ERR((" RPC is NOT initialized between 3255 and 740x"));
        goto done;
    }

    Param.devId = BRPC_DevId_3255_POD;
    CHK_RETCODE( retCode, BRPC_CallProc(rpc_handle, BRPC_ProcId_POD_CardOut,
        (const uint32_t *)&Param, sizeInLong(Param), NULL, 0, &retVal));
    CHK_RETCODE( retCode, retVal );

    return 0;

done:
    BDBG_WRN((" bcm_3255_open_rpc error \n"));
    return 1;

}

int bcm_3255_card_in()
{
#if defined(POWER_CTRL_FROM_3255) && defined(RESET_CTRL_FROM_3255)
    BRPC_Param_POD_CardIn Param;
#elif defined(POWER_CTRL_FROM_3255)
    BRPC_Param_POD_CardApplyPower Param;
#endif
    BERR_Code retVal;
    BERR_Code retCode = BERR_SUCCESS;

    Param.devId = BRPC_DevId_3255_POD;

#if defined(POWER_CTRL_FROM_3255) && defined(RESET_CTRL_FROM_3255)
    CHK_RETCODE( retCode, BRPC_CallProc(rpc_handle, BRPC_ProcId_POD_CardIn,
        (const uint32_t *)&Param, sizeInLong(Param), NULL, 0, &retVal));
#elif defined(POWER_CTRL_FROM_3255)
    Param.powerMode = MCARD_3VOLT;
    CHK_RETCODE( retCode, BRPC_CallProc(rpc_handle, BRPC_ProcId_POD_CardApplyPower,
        (const uint32_t *)&Param, sizeInLong(Param), NULL, 0, &retVal));
#endif
    CHK_RETCODE( retCode, retVal );

    BDBG_MSG(("bcm_3255_card_in OK"));
    return 0;


done:

    BDBG_WRN(("bcm_3255_card_in error \n"));
    return 1;
}

int bcm_3255_card_reset_done()
{
    BRPC_Param_POD_CardInStart Param;
    BERR_Code retVal;
    BERR_Code retCode = BERR_SUCCESS;

    Param.devId = BRPC_DevId_3255_POD;

    CHK_RETCODE( retCode, BRPC_CallProc(rpc_handle, BRPC_ProcId_POD_CardInStart,
        (const uint32_t *)&Param, sizeInLong(Param), NULL, 0, &retVal));
    CHK_RETCODE( retCode, retVal );

    BDBG_MSG(("bcm_3255_card_reset_done OK"));
    return 0;


done:

    BDBG_WRN(("bcm_3255_card_reset_done error \n"));
    return 1;
}

int bcm_3255_card_out()
{
    BRPC_Param_POD_CardOut Param;
    BERR_Code retVal;
    BERR_Code retCode = BERR_SUCCESS;

    Param.devId = BRPC_DevId_3255_POD;
    CHK_RETCODE( retCode, BRPC_CallProc(rpc_handle, BRPC_ProcId_POD_CardOut,
        (const uint32_t *)&Param, sizeInLong(Param), NULL, 0, &retVal));
    CHK_RETCODE( retCode, retVal );

    BDBG_MSG(("bcm_3255_card_out  OK "));
    return 0;


done:
    BDBG_WRN(("bcm_3255_card_out error \n"));
    return 1;
}

int bcm_3255_close_rpc()
{
        BRPC_Param_POD_CardOut Param;
        BERR_Code retVal;
        BERR_Code retCode = BERR_SUCCESS;

        Param.devId = BRPC_DevId_3255_POD;
        CHK_RETCODE( retCode, BRPC_CallProc(rpc_handle, BRPC_ProcId_POD_CardOut,
            (const uint32_t *)&Param, sizeInLong(Param), NULL, 0, &retVal));
        CHK_RETCODE( retCode, retVal );

        BDBG_MSG(("bcm_3255_close_rpc OK "));
        return 0;

    done:
        BDBG_WRN((" bcm_3255_close_rpc error \n"));
        return 1;
}
#endif

#endif // USE_POD
