load(qt_build_config)

CONFIG -= release
CONFIG += debug
CONFIG -= silent
# CONFIG += enable_tcmalloc
# CONFIG += enable_profiler

QMAKE_CXXFLAGS += -Wno-unused-parameter

QT += network

contains(QT_CONFIG, opengl) {
  QT += opengl
}

qtHaveModule(webenginewidgets) {
    QT += webenginewidgets
    HEADERS += browser2.h
    SOURCES += browser2.cpp
    # temporary disable webkit for broadcom devices
    contains(QT_ARCH, "mips"):CONFIG+=disable_webkit
}

!disable_webkit:qtHaveModule(webkitwidgets) {
    QT += webkit webkitwidgets
    HEADERS += browser.h \
        webplugin/webpluginfactoryprototype.h \

    SOURCES += browser.cpp \
        webplugin/webpluginfactoryprototype.cpp \    
}

CONFIG += link_pkgconfig
PKGCONFIG += gstreamer-1.0

enable_breakpad:packagesExist(breakpad) {
    message(ENABLE_GOOGLE_BREAKPAD)
    DEFINES += ENABLE_GOOGLE_BREAKPAD
    PKGCONFIG += breakpad
}

cross_compile:DEFINES+=CROSS_COMPILED_FOR_DEVICE

enable_tcmalloc:packagesExist(libtcmalloc) {
    message(ENABLE LIBTCMALLOC)
    QMAKE_CFLAGS += -fno-builtin-malloc -fno-builtin-calloc -fno-builtin-realloc -fno-builtin-free
    QMAKE_CXXFLAGS += -fno-builtin-malloc -fno-builtin-calloc -fno-builtin-realloc -fno-builtin-free
    PKGCONFIG += libtcmalloc
    DEFINES += ENABLE_HEAP_PROFILER
}

enable_profiler:packagesExist(libprofiler) {
    message(ENABLE LIBPROFILER)
    PKGCONFIG += libprofiler
    DEFINES += ENABLE_CPU_PROFILER
}

enable_ave: {
    #LIBS += -Wl,-verbose
    LIBS += -Wl,-O1  -Wl,--gc-sections
    LIBS += -lavemedia -lfaxportingkit
    LIBS += -ljsbindings-jspsdk -lkernel -lxmlreader -ltinyxml2
    LIBS += -lcrypto -lcryptoModule -lxmlreader -ltinyxml2 -ldl
    LIBS += -lAVEPlayer -lpsdk -ltrace -lAVEnexusMgr -lnexus -lcrypto -lssl -lcurl
    LIBS += -lds -ldshalcli -ldl -lm -lIARMBus
    DEFINES += ENABLE_AVE
}

TEMPLATE = app
SOURCES += main.cpp
HEADERS += main.h
