/******************************************************************************
 *  Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors.
 *  Copyright (c) 2016 RDK Management, LLC. All rights reserved.
 *  Copyright (C) 2017 Broadcom. The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
 *
 *  This program is the proprietary software of Broadcom and/or its licensors,
 *  and may only be used, duplicated, modified or distributed pursuant to the terms and
 *  conditions of a separate, written license agreement executed between you and Broadcom
 *  (an "Authorized License").  Except as set forth in an Authorized License, Broadcom grants
 *  no license (express or implied), right to use, or waiver of any kind with respect to the
 *  Software, and Broadcom expressly reserves all rights in and to the Software and all
 *  intellectual property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU
 *  HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY
 *  NOTIFY BROADCOM AND DISCONTINUE ALL USE OF THE SOFTWARE.
 *
 *  Except as expressly set forth in the Authorized License,
 *
 *  1.     This program, including its structure, sequence and organization, constitutes the valuable trade
 *  secrets of Broadcom, and you shall use all reasonable efforts to protect the confidentiality thereof,
 *  and to use this information only in connection with your use of Broadcom integrated circuit products.
 *
 *  2.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
 *  AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
 *  WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH RESPECT TO
 *  THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND ALL IMPLIED WARRANTIES
 *  OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE,
 *  LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION
 *  OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF
 *  USE OR PERFORMANCE OF THE SOFTWARE.
 *
 *  3.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR ITS
 *  LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL, INDIRECT, OR
 *  EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY RELATING TO YOUR
 *  USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM HAS BEEN ADVISED OF
 *  THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT
 *  ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE
 *  LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF
 *  ANY LIMITED REMEDY.
 ******************************************************************************/

#ifndef __VL_HAL_SNMP_AVINTERFACE_H__
#define __VL_HAL_SNMP_AVINTERFACE_H__

#ifdef __cplusplus
extern "C" {
#endif

//Note: Add analog ports in the begining and digital ports at the end of the enum
typedef enum
{
	HAL_AV_PORT_COMPOSITE,
	HAL_AV_PORT_SVIDEO,
	HAL_AV_PORT_RF,
	HAL_AV_PORT_COMPONENT,
	HAL_AV_PORT_HDMI,
	HAL_AV_PORT_L_R,
	HAL_AV_PORT_SPDIF,
	HAL_AV_PORT_1394,
	HAL_AV_PORT_DVI,
	HAL_AV_PORT_MAX
}HAL_SNMP_AV_PORT_TYPE;

typedef enum
{
	HAL_AV_PORT_STATUS_DISABLED = 0,
	HAL_AV_PORT_STATUS_ENABLED
}HAL_SNMP_AV_PORT_STATUS;


typedef struct{

	HAL_SNMP_AV_PORT_STATUS		portStatus;
	HAL_SNMP_AV_PORT_TYPE		avOutPortType;
	unsigned long   		deviceIndex;

}HAL_SNMP_AV_PORT_INFO;

typedef struct halAVOutInterfaceInfo
{
	unsigned long	numAvOutPorts;
	HAL_SNMP_AV_PORT_INFO avOutPortInfo[HAL_AV_PORT_MAX];

}HAL_SNMP_AVOutInterfaceInfo;

/*
 * enums for ComponentOutput
 */
typedef enum {
	COMPONENTOPFORMAT_480I = 1,
	COMPONENTOPFORMAT_480P = 2,
	COMPONENTOPFORMAT_720P = 3,
	COMPONENTOPFORMAT_1080I = 4,
	COMPONENTOPFORMAT_1080P = 5,
	COMPONENTOPFORMAT_2160P = 6,
	COMPONENTOPFORMAT_INVALID
}HAL_SNMP_ComponentOutputFormat_t;

typedef enum {
	COMPONENTASPECTRATIO_OTHER  =	1,
 	COMPONENTASPECTRATIO_FOURBYTHREE = 	2,
 	COMPONENTASPECTRATIO_SIXTEENBYNINE = 3
}HAL_SNMP_ComponentAspectRatio_t;


typedef struct {
	unsigned char                	   ComponentVideoConstrainedStatus;
	HAL_SNMP_ComponentOutputFormat_t   ComponentOutputFormat;
	HAL_SNMP_ComponentAspectRatio_t    ComponentAspectRatio;
	unsigned char                 	   ComponentVideoMuteStatus;
}HAL_SNMP_ComponentVideoTable_t;



/*
 * enums for column ocStbHostMpeg2Content
 */
typedef enum {
	CCI_COPYFREELY	=	0,
	CCI_COPYNOMORE	=	1,
	CCI_COPYONEGENERATION =	2,
	CCI_COPYNEVER	=	3,
	CCI_UNDEFINED	=	4
}HAL_SNMP_Mpeg2ContentCCIValue_t;

typedef enum {
	APSVALUE_TYPE1		=	1,
	APSVALUE_TYPE2		=	2,
	APSVALUE_TYPE3		=	3,
	APSVALUE_NOMACROVISION	=	4,
	APSVALUE_NOTDEFINED	=	5
}HAL_SNMP_Mpeg2ContentAPSValue_t;

typedef enum {
	NOTLOCKED = 1,
	LOCKED   =  2
}HAL_SNMP_Mpeg2ContentPCRLockStatus_t;

 typedef struct {
    unsigned long           		index;                /*Range: 1..20*/
    unsigned long           		programNumber;
    unsigned long           		transportStreamID;
    unsigned long           		totalStreams;
    unsigned long              		selectedVideoPID;
    unsigned long             		selectedAudioPID; /* Range: -1 | 1..8191*/
    unsigned long                	otherAudioPIDs;
    HAL_SNMP_Mpeg2ContentCCIValue_t	cciValue;
    HAL_SNMP_Mpeg2ContentAPSValue_t	apsValue;
    unsigned long                	citStatus;
    unsigned long                	broadcastFlagStatus;
    unsigned long                	epnStatus;
    unsigned long              		pcrPID;
    HAL_SNMP_Mpeg2ContentPCRLockStatus_t PCRLockStatus;
    unsigned long           		decoderPTS;
    unsigned long           		discontinuities;
    unsigned long           		pktErrors;
    unsigned long           		pipelineErrors;
    unsigned long           		decoderRestarts;
    unsigned long 			LTSID;

}HAL_SNMP_Mpeg2ContentTable_t;

typedef struct {
     unsigned long		audioFormat;
     unsigned long      audioMuteStatus;
}HAL_SNMP_SpdifTable_t;


unsigned int HAL_SNMP_Get_AvOut_Info(void* ptAVOutInterfaceInfo, unsigned int maxNumOfDiplays);

unsigned int HAL_SNMP_Get_Display_Handle_Count(unsigned int* ptDispHandleCount);
unsigned int HAL_SNMP_Get_Display_Handles(unsigned long* ptDispHandles, unsigned int maxNumOfDiplays);

unsigned int HAL_SNMP_Get_ComponentVideo_info(void* pComponentInfo);
unsigned int HAL_SNMP_Get_RFChan_info();
unsigned int HAL_SNMP_Get_AnalogVideo_info();
unsigned int HAL_SNMP_Get_Spdif_info(void *pSpdifInfo);
unsigned int HAL_SNMP_Get_ProgramStatus_info(void* ptConnInfo, unsigned int listIter);
void HAL_SNMP_Get_DevListSize(unsigned int* devListSize);
unsigned int HAL_SNMP_Get_Mpeg2Content_info(void* pMpeg2ContentInfo);




#ifdef __cplusplus
}
#endif

#endif//__VL_HAL_SNMP_AVINTERFACE_H__

