/*****************************************************************************/
/* Galois Field package header file - DFAST eval gfe_ext v3.2.h                              */
/* Mark Schmidt 5/17/95                                                      */
/* Modified by Xin Qiu 09/03/1999                                            */
/*****************************************************************************/


#ifndef GFEPKGHDR
#define GFEPKGHDR

#define gf_m 8				// GF(2^8), gf_m = 8
#define PrimPoly_gen 285	// primitive generator=>in decimal (binary) 285
#define ARR_LIMIT 65536

/*********************************************************************
	Routine:			init_field()
	Description:		establish addition and multiplication look-up
						table over extended Galois Field GF(2^m)
	Input Parameters:	None.
	Return Values:		void.
**********************************************************************/

static void init_field(void);

typedef struct
  {
    unsigned int bin;
    unsigned int expo;
  } GFE;

/*********************************************************************
	Routine:			add()
	Description:		perform addition of two nonbinary elements over
						extended Galois Field GF(2^m)
	Input Parameters:	
						a & b : nonbinary elements in GF(2^m)
	Return Values:		
						result of addition operation.
**********************************************************************/

static GFE add(GFE a, GFE b);

/*********************************************************************
	Routine:			mult()
	Description:		perform multiplication of two nonbinary elements 
						over extended Galois Field GF(2^m).
	Input Parameters:	
						a & b : nonbinary elements in GF(2^m).
	Return Values:		
						result of multiplication operation.
**********************************************************************/

static GFE mult(GFE a, GFE b);


#endif
