/******************************************************************************
* Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors. 
* All rights reserved.
*
* This software is the confidential and proprietary information of SeaChange
* ("Confidential Information"). You shall not disclose this source code or 
* such Confidential Information and shall use it only in accordance with the 
* terms of the license agreement you entered into.
*  
* SEACHANGE INERNATIONAL  MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
* SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT 
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SEACHANGE SHALL NOT BE LIABLE FOR 
* ANY DAMAGES SUFFERED BY LICENSEE NOR SHALL THEY BE RESPONSIBLE AS A RESULT 
* OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*******************************************************************************/


#ifndef HAL_API_H
#define HAL_API_H

#ifdef __cplusplus
extern "C" {
#endif

/*===================================================================
   INCLUDES AND PUBLIC DATA DECLARATIONS
===================================================================*/
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

/*-------------------------------------------------------------------
   Defines/Macros
-------------------------------------------------------------------*/
#define EXTDEV_AUDIOBB_MAX_DEVICES  2
#define EXTDEV_VIDEOBB_MAX_DEVICES  1
#define EXTDEV_POD_MAX_DEVICES      2
#define EXTDEV_IEEE1394_MAX_DEVICES 2

/*-------------------------------------------------------------------
   Types/Structs
-------------------------------------------------------------------*/

typedef unsigned char  UINT8;
typedef unsigned short UINT16;
typedef unsigned long  UINT32;
typedef signed char    INT8;
typedef signed short   INT16;
typedef signed long    INT32;
typedef unsigned char  BOOLEAN;
typedef float          FLOAT32;
typedef unsigned long         DEVICE_HANDLE_t;

#ifndef true
#define true 1
#endif
#ifndef false
#define false 0
#endif


typedef enum
{
    PDT_DEVICE_MINIMUM,
    PDT_DEVICE_ANAAUD,         /* ANALOG AUDIO */
    PDT_DEVICE_ANAVID,         /* ANALOG VIDEO */
    PDT_DEVICE_CRYPTO,         /* Crypto */
    PDT_DEVICE_DISPLAY,        /* Display */
    PDT_DEVICE_EEPROM,         /* EEPROM */
    PDT_DEVICE_FPD,            /* Front Panel Display */
    PDT_DEVICE_GFX,            /* Graphics */
    PDT_DEVICE_HID,            /* Human Interface Device */
    PDT_DEVICE_IRB,            /* IR Blaster */
    PDT_DEVICE_MPAUD,          /* MPEG Audio */
    PDT_DEVICE_MPENC,          /* MPEG Encoder (Not supported) */
    PDT_DEVICE_MPVID,          /* MPEG Video */
    PDT_DEVICE_PCM,            /* PCM (Not supported) */
    PDT_DEVICE_RECODE,         /* Recoder device (Not supported) */
    PDT_DEVICE_SECTFLT,        /* Section Filter */
    PDT_DEVICE_SYS,            /* System Utilities */
    PDT_DEVICE_TUNER,          /* TUNER */
    PDT_DEVICE_DISC,            /*HDD*/
    PDT_DEVICE_VBI,            /* ANALOG VBI */
#ifdef USE_POD
    PDT_DEVICE_POD,           /*CableCard */
#endif
#ifdef USE_DSG
    PDT_DEVICE_DSG,        /*DSG */
#endif
    PDT_DEVICE_IP,            /* IP */

#ifdef USE_MFR
    PDT_DEVICE_MFR,        /*MFR */
#endif
#ifdef USE_CDL
    PDT_DEVICE_CDL,        /*CDL */
#endif
#ifdef USE_1394
    PDT_DEVICE_1394,        /*CDL */
#endif

     PDT_DEVICE_RECORD,
     PDT_DEVICE_PLAYBACK,
     PDT_DEVICE_MCRYPTO,
    PDT_DEVICE_MAXIMUM
} PDT_DeviceType;

typedef enum
{
    PDT_EXT_DEVICE_MINIMUM = PDT_DEVICE_MAXIMUM,
    PDT_EXT_DEVICE_AUDIO,
    PDT_EXT_DEVICE_VIDEO,
    PDT_EXT_DEVICE_POD,
    PDT_EXT_DEVICE_IEEE1394,
    PDT_EXT_DEVICE_IP,
    PDT_EXT_DEVICE_ESATA_HDD,
    PDT_EXT_DEVICE_MAXIMUM
} PDT_ExtDeviceType;

/* Lock gained / Lock Lost enum type */
typedef enum {
      DEVICE_LOCKED,
      DEVICE_UNLOCKED,
      DEVICE_TIMEOUT
} DEVICE_LOCK_t;

typedef enum {
      INPUT_DEVICE,
      OUTPUT_DEVICE
} EXTDEV_MODE_t;

typedef enum {
    VIDEOBB_MODE_YC,
    VIDEOBB_MODE_CVBS
} EXTDEV_VIDEOBB_MODE_t;

typedef enum {
      DEVICE_POWERON,
      DEVICE_POWEROFF,
      DEVICE_STANDBY
} DEVICE_POWER_LEVEL_t;


/* Common callback function for indicating lock lost / lock gained*/
typedef void (*DEVICE_LOCK_FUNC_t) (DEVICE_HANDLE_t    hDeviceHandle,
               DEVICE_LOCK_t eLockStatus,
               void*         puldata );

typedef struct {
    DEVICE_HANDLE_t    hDeviceHandle;
    EXTDEV_MODE_t    eDeviceMode;
} EXTDEV_CAP_t;

typedef struct {
      UINT8        usNumAudioBaseband;
      EXTDEV_CAP_t stAudioBBCapabilities[EXTDEV_AUDIOBB_MAX_DEVICES];
      UINT8        usNumVideoBaseband;
      EXTDEV_CAP_t stVideoBBCapabilities[EXTDEV_VIDEOBB_MAX_DEVICES];
      UINT8        usNumPOD;
      EXTDEV_CAP_t stPODCapabilities[EXTDEV_POD_MAX_DEVICES];
      UINT8        usNumIEEE1394;
      EXTDEV_CAP_t stIEEE1394Capabilities[EXTDEV_IEEE1394_MAX_DEVICES];
} EXTDEV_CAPABILITIES_t;
/* Note : The number of available devices are given by usNumXxx parameter  */
/*        and not by XXX_MAX_DEVICES.                                      */

typedef enum
{
    DISP_FORMAT_480I,        /* 720x480i */
    DISP_FORMAT_480P,        /* 720x480p */
    DISP_FORMAT_720P,        /* 1280x720p */
    DISP_FORMAT_1080I,        /* 1920x1080i */
    DISP_FORMAT_1080P,        /* 1920x1080p 60HZ*/
    DISP_FORMAT_1080P_24HZ, /* 1920x1080p 24HZ*/
    DISP_FORMAT_1080P_30HZ, /* 1920x1080p 30HZ*/
    DISP_FORMAT_2160P, /* 3840x2160p 60HZ*/
    DISP_FORMAT_2160P_30HZ, /* 3840x2160p 30HZ*/
    DISP_FORMAT_PassThru,   /* Pass through mode*/
    DISP_INVALID_FORMAT,
    DISP_MAX_DISPLAY_FORMAT
} DISP_DISPLAY_FORMAT_t ;


typedef enum
{
    MPVID_ASPECT_UNKNOWN=0,    /* Unkown/Reserved = 0*/
    MPVID_ASPECT_SQUARE,     /* square pixel = 1*/
    MPVID_ASPECT_4_3,          /* 4:3 = 2*/
    MPVID_ASPECT_16_9,         /* 16:9 = 3*/
    MPVID_ASPECT_221_1        /* 2.21:1 = 4*/
} MPVID_ASPECT_t;

typedef struct
{
   DISP_DISPLAY_FORMAT_t    eFormat;          /* MPEG video source format */
   MPVID_ASPECT_t            eAspect;          /* MPEG video source aspect ratio */
   UINT32                    ulHorizontalSize;      /* MPEG video source horizontal size */
   UINT32                    ulVerticalSize;     /* MPEG video source vertical size  */
   UINT16                    framerate_code;      /* frame rate of the currently decoded mpeg video */
   BOOLEAN                    bStreamProgressive; /* false:interlaced true:progressive */
   BOOLEAN                    bAnalog;            /* false:analog source true:mpeg source */
} MPVID_SRCINFO_t ;


typedef struct
{
    unsigned char bDigital;
    unsigned long decoderPts;
    unsigned long discontinuities;
    unsigned long pktErrors;
    unsigned long pipelineErrors;
    unsigned long decoderRestarts;

}MPVID_SNMP_Info;

typedef enum
{
    ANALOG_AUDIO_CHANNEL_MODE_MONO,     //Mono Audio
    ANALOG_AUDIO_CHANNEL_MODE_STEREO,   //Stereo Audio
    ANALOG_AUDIO_CHANNEL_MODE_SAP,      //Second Audio Program
    ANALOG_AUDIO_CHANNEL_MODE_SAPMONO,
    ANALOG_AUDIO_CHANNEL_MODE_NONE

} ANALOG_AUDIO_CHANNEL_MODE;


#ifdef __cplusplus
}
#endif

#endif /* HAL_API_H */
