/******************************************************************************
* Copyright (C) 2017 Broadcom. The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
* Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors. 
* All rights reserved.
*
* This software is the confidential and proprietary information of SeaChange
* ("Confidential Information"). You shall not disclose this source code or 
* such Confidential Information and shall use it only in accordance with the 
* terms of the license agreement you entered into.
*  
* SEACHANGE INERNATIONAL  MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
* SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT 
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SEACHANGE SHALL NOT BE LIABLE FOR 
* ANY DAMAGES SUFFERED BY LICENSEE NOR SHALL THEY BE RESPONSIBLE AS A RESULT 
* OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*******************************************************************************/

#include "sys_api.h"
#include "pdt_hal.h"

#include "mfr_types.h"

#include "rmf_osal_thread.h"
#include "rdk_debug.h"
#include "rmf_osal_resreg.h"

#include "nexus_memory.h"
#include "nexus_platform.h"

#include "stdlib.h"
#include <sys/reboot.h>

#include <unistd.h>
#include <linux/reboot.h>
#ifndef HEADLESS_GW
#include "libIBus.h"
#include "pwrMgr.h"
#endif
#define HAL_SUCCESS 0

#if 0
static void  vlSyncAndRebootTask(void * arg);

// XONE-3545: Added new thread to handle reboot
static void  vlSyncAndRebootTask(void * arg)
{
    
    RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "vlSyncAndRebootTask: Received reboot request. Disabling CPU-1.\n");
    rmf_osal_threadSleep(100,0);
    system("echo 0 > /sys/devices/system/cpu/cpu1/online");
    RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "vlSyncAndRebootTask: Received reboot request. Staring Sync...\n");
    rmf_osal_threadSleep(1000,0);
    sync();
    RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "vlSyncAndRebootTask: Received reboot request. System is going down...\n");
    rmf_osal_threadSleep(500,0);
    //cSleep(60000); // test statement to simulate hanging of "sync" or "reboot" command.
    //system("/sbin/reboot -f &");
    system("sh /rebootNow.sh -s HAL_SYS_Reboot &");
}
#endif

/***********************************************************************
 * FUNCTION : HAL_SYS_Reboot
 *
 * PURPOSE : Reboots the platform.
 *
 * PARAMETERS :
 *    n/a
 *
 * RETURNS : This function does not return.
 *           Implemented such that it always succeeds.
 *
 * USAGE :
 *    Used to reboot the system.
 *
 ************************************************************************
 */

// XONE-3545: Added new API to handle reboot
void HAL_SYS_Reboot(const char * pszRequestor, const char * pszReason)
{
    int i = 0;
    const int t = 15;
    rmf_osal_LogRebootEvent(pszRequestor, pszReason);
    //rmf_osal_ThreadId threadId;
    //rmf_osal_threadCreate( vlSyncAndRebootTask, NULL, RMF_OSAL_THREAD_PRIOR_DFLT, RMF_OSAL_THREAD_STACK_SIZE,&threadId,  "vlSyncAndRebootTask");
    RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "HAL_SYS_Reboot: Received reboot request from '%s' for '%s'. System is going down.\n", pszRequestor, pszReason);
    //rmf_osal_threadSleep(30000,0); // wait for sync to complete and reboot box
    //for(i = 0; i < t; i++)
    //{
      //  RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "HAL_SYS_Reboot: vlSyncAndReboot did not succeed / system hang occurred. Will reset H/W in %d seconds.\n", (t - i));
        //rmf_osal_threadSleep(1000,0);
   // }
    fflush(stdout);
    fsync(fileno(stdout));
    RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "HAL_SYS_Reboot: Calling hdparm -f /dev/sda2 \n");
    system("hdparm -f /dev/sda2");
    rmf_osal_threadSleep(1000,0);
    // perform the "last resort" hardware reset. "sync" NOT allowed here.
    // reboot(LINUX_REBOOT_CMD_RESTART);
    system("sh /rebootNow.sh -s HAL_SYS_Reboot -o 'Rebooting the box due to performing last resort hardware reset...'");
}





void HAL_SYS_GetStbHostMemoryInfo(VL_SNMP_HostMemoryInfo   *pStbHostMemoryInfo)
{
   if(pStbHostMemoryInfo)
    {
        //Need to call an bsettop api "bmib_get_params" supplied by Funai.
        memset(pStbHostMemoryInfo, 0 , sizeof(VL_SNMP_HostMemoryInfo));

        //Hardcode for now until the vendor api is avialable
        pStbHostMemoryInfo->largestAvailableBlock   =   8 * 1024;
        pStbHostMemoryInfo->totalVideoMemory        =   128 * 1024;//128 MB or 131072 KB
        pStbHostMemoryInfo->availableVideoMemory    =   64 * 1024; //64 MB or 65536 KB

        NEXUS_MemoryStatus status;
        NEXUS_PlatformConfiguration configuration;
        memset(&status, 0, sizeof(status));
        memset(&configuration, 0, sizeof(configuration));

        int available_video_memory = 0;
        int total_video_memory = 0;
        int largest_available_block = 0;
        int i = 0;

        NEXUS_Platform_GetConfiguration(&configuration);

        /* by default, heap[0] is used for video decoder and display */
        if (configuration.heap[0])
        {
                NEXUS_Heap_GetStatus(configuration.heap[0], &status);
                available_video_memory = status.largestFreeBlock;
                total_video_memory = status.size;
        }

        for (i=0; i<NEXUS_MAX_HEAPS; i++)
        {
                if (configuration.heap[i])
                {
                        NEXUS_Heap_GetStatus(configuration.heap[i], &status);
                        if (status.largestFreeBlock > largest_available_block)
                        {
                                largest_available_block = status.largestFreeBlock;
                        }
                }
        }

        available_video_memory /= 1024;
        total_video_memory /= 1024;
        largest_available_block /= 1024;

        pStbHostMemoryInfo->availableVideoMemory    =   available_video_memory;
        pStbHostMemoryInfo->totalVideoMemory        =   total_video_memory;
        pStbHostMemoryInfo->largestAvailableBlock   =   largest_available_block;
    }

    return;
}

void HAL_SYS_GetStbHostSystemMemoryTable(unsigned int *pMemTableSize, VL_SNMP_SystemMemoryReportEntry *pStbSystemMemoryReportTable)
{
    unsigned deviceMemSize = 0;
    if(pStbSystemMemoryReportTable && pMemTableSize)
    {

        memset(   pStbSystemMemoryReportTable,
                    0,
                    (*pMemTableSize * sizeof(VL_SNMP_SystemMemoryReportEntry) )                    
                );

        //Need to call an platform api to fill the appropriate values. Hardcode for now until the vendor api is avialable

        if(*pMemTableSize > 1)
            *pMemTableSize = 1;

        {
           NEXUS_PlatformConfiguration platformConfig;
           unsigned i;
           NEXUS_Error rc;
           /* call NEXUS_Platform_GetConfiguration to get the heap handles */
           NEXUS_Platform_GetConfiguration(&platformConfig);
           for (i=0;i<NEXUS_MAX_HEAPS;i++) 
           {
                NEXUS_MemoryStatus status;
                NEXUS_HeapHandle heap;
                heap = platformConfig.heap[i];
                if (!heap) continue;
                rc = NEXUS_Heap_GetStatus(heap, &status);
                if (rc!=0) {
                  RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.SYS", "%s: Error %d calling NEXUS_Heap_GetStatus!\n", __FUNCTION__, rc);
                }
                deviceMemSize += status.size;
           }
        }
    	pStbSystemMemoryReportTable[0].memoryType = VL_SNMP_HOST_MIB_MEMORY_TYPE_VIDEOMEMORY;
        pStbSystemMemoryReportTable[0].memSize	  = deviceMemSize/1024; //return device memory instead of video device.

    }

    return;
}


VL_SNMP_API_RESULT HAL_SYS_SnmpRequest(VL_SNMP_REQUEST eRequest, void * _pvStruct)
{
    switch(eRequest)
    {
        case VL_SNMP_REQUEST_GET_SYS_HOST_MEMORY_INFO:
        {
            VL_SNMP_HostMemoryInfo * pHostMemoryInfo = (VL_SNMP_HostMemoryInfo*)_pvStruct;
            HAL_SYS_GetStbHostMemoryInfo(pHostMemoryInfo);
            return VL_SNMP_API_RESULT_SUCCESS;
        }
        break;

        case VL_SNMP_REQUEST_GET_SYS_SYSTEM_MEMORY_REPORT:
        {
            VL_SNMP_SystemMemoryReportTable * pSystemMemoryReport = (VL_SNMP_SystemMemoryReportTable*)_pvStruct;
            pSystemMemoryReport->nEntries = VL_SNMP_HOST_MIB_MEMORY_TYPE_MAX;
            HAL_SYS_GetStbHostSystemMemoryTable(&(pSystemMemoryReport->nEntries), (VL_SNMP_SystemMemoryReportEntry *)&(pSystemMemoryReport->aEntries));
            return VL_SNMP_API_RESULT_SUCCESS;
        }
        break;

        case VL_SNMP_REQUEST_SET_SYS_UNINITIALIZE:
        {
            RDK_LOG(RDK_LOG_INFO, "LOG.RDK.SYS", "%s: Received VL_SNMP_REQUEST_SET_SYS_UNINITIALIZE, Calling HAL_SYS_Shutdown()\n", __FUNCTION__);
            HAL_SYS_Shutdown();
            return VL_SNMP_API_RESULT_SUCCESS;
        }
        break;

        case VL_SNMP_REQUEST_GET_SYS_SYSTEM_POWER_STATE:
        {
            unsigned long *pSysPowerState = (unsigned long *)_pvStruct;

#ifndef HEADLESS_GW
            {
                IARM_Result_t result;
#if 0    
                // TODO: Move IARM_Bus_Init() to main after splitting SNMP to another process.
                static int inited = 0;
                if ( 0 == inited )
                {
                    result  = IARM_Bus_Init("runPod");
                    if (IARM_RESULT_SUCCESS != result )
                    {
                        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s: %d  IARM_Bus_Init failed %d\n", __FUNCTION__ ,__LINE__, result);
                    }
                    result  = IARM_Bus_Connect();
                    if (IARM_RESULT_SUCCESS != result )
                    {
                        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD","%s: %d  IARM_Bus_Connect failed %d\n", __FUNCTION__ ,__LINE__, result);
                    }
                    inited = 1;
                }
#endif    
                IARM_Bus_PWRMgr_GetPowerState_Param_t param;
                param.curState = IARM_BUS_PWRMGR_POWERSTATE_ON;
                            
                IARM_Bus_Call(IARM_BUS_PWRMGR_NAME,IARM_BUS_PWRMGR_API_GetPowerState,
                    (void *)&param,sizeof(param));
                 switch(param.curState)
                 {
                    case IARM_BUS_PWRMGR_POWERSTATE_OFF:
                        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD","%s: %d  IARM_BUS_PWRMGR_POWERSTATE_OFF\n", __FUNCTION__ ,__LINE__);
                         break;

                    case IARM_BUS_PWRMGR_POWERSTATE_STANDBY:
                        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD","%s: %d  IARM_BUS_PWRMGR_POWERSTATE_STANDBY\n", __FUNCTION__ ,__LINE__);
                         *pSysPowerState = VL_SNMP_HOST_POWER_STATUS_STANDBY;
                         break;

                    case IARM_BUS_PWRMGR_POWERSTATE_ON:
                        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD","%s: %d  IARM_BUS_PWRMGR_POWERSTATE_ON\n", __FUNCTION__ ,__LINE__);
                         *pSysPowerState = VL_SNMP_HOST_POWER_STATUS_POWERON;
                         break;
                     default:
                         break;
                 }
            }
#else
            /*  added by Abdu: to be removed  */
            *pSysPowerState = VL_SNMP_HOST_POWER_STATUS_POWERON;

#endif
            //printf("%s: sysPowerState = %d, *pSysPowerState = %d\n", __FUNCTION__, sysPowerState, *pSysPowerState );
            return VL_SNMP_API_RESULT_SUCCESS;
        }
        break;

        default:
        {
            return VL_SNMP_API_RESULT_NOT_IMPLEMENTED;
        }
        break;
    }

    return VL_SNMP_API_RESULT_NOT_IMPLEMENTED;
}

//End - For SNMP api support


/***********************************************************************
 * FUNCTION : HAL_SYS_Shutdown
 *
 * PURPOSE : Shuts down the HAL library.
 *
 * PARAMETERS :
 *    n/a
 *
 * RETURNS :
 *    HAL_SUCCESS                       : On success
 *    ERROR_HAL_INITIALIZATION_FAILED   : If one or modules failed to
 *                                        shutdown.
 *    ERROR_HAL_NOT_INITIALIZED         : Error if HAL lib was not
 *                                        previously initialized.
 *
 * USAGE :
 *    Used to shutdown and clean up the HAL library.
 *
 ************************************************************************
 */

INT32 HAL_SYS_Shutdown (void)
{
   return HAL_SUCCESS;
}


#ifdef __cplusplus
extern "C" {
#endif

VL_SNMP_API_RESULT CHalSys_snmp_request(VL_SNMP_REQUEST eRequest, void * _pvStruct)
{
    return HAL_SYS_SnmpRequest(eRequest, _pvStruct);
}

#ifdef __cplusplus
}
#endif









