/******************************************************************************
* Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors. 
* All rights reserved.
*
* This software is the confidential and proprietary information of SeaChange
* ("Confidential Information"). You shall not disclose this source code or 
* such Confidential Information and shall use it only in accordance with the 
* terms of the license agreement you entered into.
*  
* SEACHANGE INERNATIONAL  MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
* SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT 
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SEACHANGE SHALL NOT BE LIABLE FOR 
* ANY DAMAGES SUFFERED BY LICENSEE NOR SHALL THEY BE RESPONSIBLE AS A RESULT 
* OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*******************************************************************************/



#ifdef USE_POD
/*-------------------------------------------------------------------
   Include Files
-------------------------------------------------------------------*/
#include "hal_module.h"
#include "hal_error.h"
#include <stdio.h>
#include "pod_api.h"
//#include <string.h>
#include "sys_init.h" 
#include "rmfqamsrc.h"
#include "rmf_osal_sync.h"
#include "rmf_osal_thread.h"

#include "bsettop_types.h"
#include "nexus_mpod.h"

// Newly added header files
#include "mpod.h"
//#include "pod_os.h"
#include "mpod_ioctls.h"
#include <asm/ioctl.h>
#include "rmfbase.h"

// Newly added header files
#include "vlEnv.h"
#include "rdk_debug.h"
#ifdef NEXUS_HAS_SECURITY
#include "nexus_security_datatypes.h"            
#include "nexus_security.h"            
#endif

#define VL_HALPOD_MAX_DECODE_PIDS   5
#define VL_HALPOD_MAX_CA_RES        6


typedef enum vlPodCipherDataSet
{
  VL_HALPOD_CIPHER_DATA_NOT_SET = 0,
  VL_HALPOD_CIPHER_DATA_SET = 1
}vlPodCipherDataSet_e;

typedef enum vlPodCipherState
{
  VL_HALPOD_CIPHER_CONFIG_STOP =  0,
  VL_HALPOD_CIPHER_CONFIG_START,
  VL_HALPOD_CIPHER_CONFIG_ERROR
  
}vlPodCipherState_e;
typedef enum vlPodCipherPidFilterState_e
{
  VL_HALPOD_PID_FILTER_NOT_SET = 0,
  VL_HALPOD_PID_FILTER_SET
}vlPodCipherPidFilterState_e;


typedef struct vlPodConfigureCipherData
{
  unsigned char ltsid;
  unsigned short PrgNum;
  vlPodCipherDataSet_e  eDataSet;
  vlPodCipherState_e eCipherState;
  vlPodCipherPidFilterState_e ePidFilterState;
  UINT32 decodePid[VL_HALPOD_MAX_DECODE_PIDS];
  UINT32 numPids;
  UINT32 DesKeyAHi;
  UINT32 DesKeyALo;
  UINT32 DesKeyBHi;
  UINT32 DesKeyBLo;
  void *ptr;
}vlPodConfigureCipherData_t;

#define MAX_PROGRAM_KEYS 6
#define MAX_PIDCHANNELS 10

typedef struct
{
#ifdef NEXUS_HAS_SECURITY
        NEXUS_KeySlotHandle keyslot;
#endif        
        int pidChannelIndex[MAX_PIDCHANNELS];
        unsigned char ltsid;
        NEXUS_PidChannelHandle pidChannels[MAX_PIDCHANNELS];
} ProgramKey_t;

ProgramKey_t g_ccProgramKeys[MAX_PROGRAM_KEYS];

static rmf_osal_Mutex vlg_PodCipherMutex;
static vlPodConfigureCipherData_t vlg_PodConfigCipherData[VL_HALPOD_MAX_CA_RES];
rmf_osal_ThreadId podResetThreadID = 0;

#if (NEXUS_PLATFORM == 97425)
extern int bSWRateSmooth;
#endif

static int vlCipherConfigPidFilterStartDecrypt(vlPodConfigureCipherData_t *pCipherData);
int vlConfigureCipher(unsigned char ltsid,unsigned short PrgNum,UINT32 *decodePid,UINT32 numpids,UINT32 DesKeyAHi,UINT32 DesKeyALo,UINT32 DesKeyBHi,UINT32 DesKeyBLo,void *ptr);
static int getProgramKeyIndexFromLTSID(unsigned char ltsid);

#ifdef MPOD_SUPPORT

//extern "C" unsigned char vl_isFeatureEnabled(unsigned char *featureString);

extern "C" void POD_Reset_Thread(void*);

extern "C" MPOD_RET_CODE VL_MPOD_Start_Reset();

MPOD_RET_CODE VL_MPOD_Start_Reset()
{
    //MPEOS_LOG(MPE_LOG_INFO, MPE_MOD_POD, ("VL_MPOD_Start_Reset: ####start reset thread!!!!\n"));
    RDK_LOG(RDK_LOG_DEBUG,"LOG.RDK.POD","%s(): ####start reset thread!!!!\n", __FUNCTION__);
    rmf_Error err;
    err = rmf_osal_threadCreate(POD_Reset_Thread, NULL,
         250, 4096, &podResetThreadID,
        "VL_MPOD_Reset_Thread");

    if ( RMF_SUCCESS != err)
    {
        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s(): Failed to create PODReset thread\n",__FUNCTION__);
        return MPOD_SYS_ERROR;
    }

    return MPOD_SUCCESS;
}


void vlInitPodCipherConfigData()
{
  rmf_Error err;
  if(!vl_env_get_bool(false, "FEATURE.CIPHER.SYNC"))
  {
    RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s(): Cipher Sync Not supported \n",__FUNCTION__);
    return; 
  }
  
  RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s(): vlInitPodCipherConfigData Entered.... !! \n",__FUNCTION__);
  memset(vlg_PodConfigCipherData,0, sizeof(vlg_PodConfigCipherData));
  err = rmf_osal_mutexNew(&vlg_PodCipherMutex);
  if(RMF_SUCCESS != err)
  {
        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s(): Failed to create vlg_PodCipherMutex \n",__FUNCTION__);
        return;
  }
  RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s(): vlInitPodCipherConfigData Exit.... !! \n",__FUNCTION__);
  return; 
}

static int vlConfigCipherFindFreeResource(unsigned char ltsid,unsigned short PrgNum,UINT32 *decodePid,UINT32 numpids,vlPodConfigureCipherData_t **pCipherData)
{
   int ii, index = 0xFF;;
   vlPodConfigureCipherData_t *pData;
   *pCipherData = NULL;
  
  pData = &vlg_PodConfigCipherData[0];
  RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "%s():  ltsid:%d decodePid[0]:0x%X numpids:%d\n",__FUNCTION__,ltsid,decodePid[0],numpids);  
  for(ii = 0; ii < VL_HALPOD_MAX_CA_RES; ii++ )
  {
    
     if( (pData->ltsid == ltsid) && ( ( pData->decodePid[0]& 0x1FFF ) == (decodePid[0] & 0x1FFF) ) && (pData->ePidFilterState == VL_HALPOD_PID_FILTER_SET))
     {
	*pCipherData = pData;
	RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s(): at index:%d  resource Available with Pid filter set for  ltsid:%d pData->decodePid[0]:0x%X \n",__FUNCTION__,ii,ltsid,pData->decodePid[0]);
	return 0;
     }
     if((pData->eDataSet == VL_HALPOD_CIPHER_DATA_NOT_SET) && (index == 0xFF))
     {
       index = ii;
     }
     pData++;
    
  }
  if(index != 0xFF)
  {
    RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s(): free resource Available at index:%d no pid filter set \n",__FUNCTION__,index);
    vlg_PodConfigCipherData[index].ePidFilterState = (vlPodCipherPidFilterState_e)0; 
    *pCipherData = &vlg_PodConfigCipherData[index];
    return 0;
  }
  
   RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s(): Error No resource available  ltsid:%d PrgNum:%d \n",__FUNCTION__,ltsid,PrgNum);
   return -1;
}

static int getCipherMatchData( unsigned char ltsid,
					unsigned short PrgNum,
					UINT32 *decodePid,
					UINT32 numpids,
					vlPodConfigureCipherData_t **pCipherData )
{
	unsigned int loopVar,index= 0xFF;
	vlPodConfigureCipherData_t *pData;
	*pCipherData = NULL;

	pData = &vlg_PodConfigCipherData[0];
	
	RDK_LOG( RDK_LOG_INFO, "LOG.RDK.POD", 
		"%s():  ltsid:%d decodePid[0]:0x%X numpids:%d\n", __FUNCTION__, ltsid, decodePid[0], numpids );  

	for( loopVar = 0; loopVar < VL_HALPOD_MAX_CA_RES; loopVar++ )
	{
		if( (pData->ltsid == ltsid) && ( ( pData->decodePid[0]& 0x1FFF ) == (decodePid[0] & 0x1FFF) ) )
		{
			*pCipherData = pData;
			RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", 
				"%s():at index:%d found  the match with Cipher data set for ltsid:%d decodePid[0]:0x%X, data status is %d \n",
				__FUNCTION__, loopVar, ltsid, pData->decodePid[0], pData->eDataSet );
			return 0;
		}
		if( (pData->eDataSet == VL_HALPOD_CIPHER_DATA_NOT_SET) && 
			(pData->ePidFilterState == VL_HALPOD_PID_FILTER_NOT_SET) && 
			(index == 0xFF) )
		{
			index = loopVar;
		}
		pData++;

	}
	
	if( index != 0xFF )
	{
		*pCipherData = &vlg_PodConfigCipherData[index];
		RDK_LOG( RDK_LOG_INFO, "LOG.RDK.POD", 
			"%s(): at index:%d Free resource is available, no cipher data set \n",__FUNCTION__, index );
		return 1;
	}
	
	RDK_LOG( RDK_LOG_ERROR, "LOG.RDK.POD", 
		"%s(): Didn't find the match or no free resource for ltsid:%d decodePid[0]:0x%X\n",
		__FUNCTION__, ltsid, decodePid[0] );
	return -1;

}


static int vlConfigCipherMatchData(unsigned char ltsid,unsigned short PrgNum,UINT32 *decodePid,UINT32 numpids,vlPodConfigureCipherData_t **pCipherData)
{
   int ii,index= 0xFF;
   vlPodConfigureCipherData_t *pData;
   *pCipherData = NULL;
  
  pData = &vlg_PodConfigCipherData[0];
   RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "%s():  ltsid:%d decodePid[0]:0x%X numpids:%d\n",__FUNCTION__,ltsid,decodePid[0],numpids);  
  for(ii = 0; ii < VL_HALPOD_MAX_CA_RES; ii++ )
  {
     if( (pData->ltsid == ltsid) && ( ( pData->decodePid[0]& 0x1FFF ) == (decodePid[0] & 0x1FFF) ) && (pData->eDataSet == VL_HALPOD_CIPHER_DATA_SET))
     {
        *pCipherData = pData;
        RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s():at index:%d found  the match with Cipher data set for ltsid:%d decodePid[0]:0x%X \n",__FUNCTION__,ii,ltsid,pData->decodePid[0] );
	return 0;
     }
	 
     if( (pData->ltsid == ltsid) && ( ( pData->decodePid[0]& 0x1FFF ) == (decodePid[0] & 0x1FFF) ) && (pData->eDataSet != VL_HALPOD_CIPHER_DATA_SET) &&  (pData->ePidFilterState == VL_HALPOD_PID_FILTER_SET) )
     {
		*pCipherData = pData;
		RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "%s():at index:%d found  the match with Cipher data NOT set and only filter is set for ltsid:%d decodePid[0]:0x%X \n",__FUNCTION__,ii,ltsid,pData->decodePid[0] );
		return 0;
     }
	 
     if((pData->eDataSet == VL_HALPOD_CIPHER_DATA_NOT_SET) && (index == 0xFF) && (pData->ePidFilterState != VL_HALPOD_PID_FILTER_SET))
     {
       index = ii;
     }
     pData++;
    
  }
  if(index != 0xFF)
  {
     vlg_PodConfigCipherData[index].eDataSet = (vlPodCipherDataSet_e)0;
     *pCipherData = &vlg_PodConfigCipherData[index];
      RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s(): at index:%d Free resource is available, no cipher data set \n",__FUNCTION__,index);
      return 1;
  }
   RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s(): Didn't find the match or no free resource for ltsid:%d decodePid[0]:0x%X\n",__FUNCTION__,ltsid,decodePid[0]);
  return -1;
  
}

static int removePidchannelFromKeyslot(int progKey, int pidChan);
static void vlReleaseKeySlot(unsigned char ltsid);
void resetProgramKey(int index);

int vlConfigCipherStop(unsigned char ltsid,unsigned short PrgNum,UINT32 *decodePid,UINT32 numpids)
{
	int iRet = -1;
	vlPodConfigureCipherData_t *pCipherData = NULL;

	RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s():>>>>>>>>>> ltsid:%d decodePid[0]:0x%X numpids:%d Entered <<<<<<<<<<\n",__FUNCTION__,ltsid,decodePid[0],numpids);
	// return 0;
	rmf_osal_mutexAcquire(vlg_PodCipherMutex);
	if( 0 == getCipherMatchData( ltsid, PrgNum, decodePid, numpids, &pCipherData) )
	{
		if( pCipherData->eDataSet == VL_HALPOD_CIPHER_DATA_SET )
		{
#ifdef NEXUS_HAS_SECURITY    
			// At this point the keyslots are created correctly.
			// If the pidchannels are not open yet, the next part will fail,
			// but we will try to load them again during start decode.
			UINT32 i;

			int progKey;
			progKey = getProgramKeyIndexFromLTSID(ltsid);

			if ( -1 != progKey ) 
			{
				for (i=0; i<numpids; i++) 
				{
					if ( NULL != g_ccProgramKeys[progKey].pidChannels[i] ) 
					{
						removePidchannelFromKeyslot(progKey,(int)g_ccProgramKeys[progKey].pidChannels[i]);
						NEXUS_PidChannel_Close(g_ccProgramKeys[progKey].pidChannels[i]);  
						g_ccProgramKeys[progKey].pidChannels[i] = NULL;
					}
				}
			}

			vlReleaseKeySlot(ltsid);
#endif
		}          
		RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "%s():>>>>>>>>>> Cleaning data for ltsid:%d decodePid[0]:0x%X numpids:%d Entered <<<<<<<<<<\n",__FUNCTION__,ltsid,decodePid[0],numpids);
		memset( pCipherData, 0, sizeof(vlPodConfigureCipherData_t) );
		iRet = 0;
		}
	else
	{
		RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s():>>>>>>>>>>Error Failed to Clean  data for ltsid:%d decodePid[0]:0x%X numpids:%d Exit <<<<<<<<<<\n",__FUNCTION__,ltsid,decodePid[0],numpids);
		iRet = -1;
	}
	rmf_osal_mutexRelease(vlg_PodCipherMutex);
	RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s():>>>>>>>>>> ltsid:%d decodePid[0]:0x%X numpids:%d Exit <<<<<<<<<<\n",__FUNCTION__,ltsid,decodePid[0],numpids);
	return iRet;
}
#if 1 
#ifdef __cplusplus
extern "C"
{
#endif
int podmgrConfigCipher(unsigned char ltsid,unsigned short PrgNum,UINT32 *decodePid,UINT32 numpids);
#ifdef __cplusplus
}
#endif
int podmgrConfigCipher(unsigned char ltsid,unsigned short PrgNum,UINT32 *decodePid,UINT32 numpids)
{
  int iRet = 0;
  int ret;
  vlPodConfigureCipherData_t *pCipherData = NULL;
  RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s(): Entered \n",__FUNCTION__);  
  if(!vl_env_get_bool(false, "FEATURE.CIPHER.SYNC"))
  {
   
    RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s(): Cipher Sync Not supported \n",__FUNCTION__);
    return 0;
  }

  if((decodePid == NULL) || (numpids == 0))
  {
    RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s():Error input data  (decodePid == NULL) || (numpids == %d) \n",__FUNCTION__,numpids );
    return -1;
  }
  RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "%s():Input params ltsid:%d PrgNum:%d numpids:%d decodePid[0]:0x%X\n",__FUNCTION__,ltsid,PrgNum,numpids,decodePid[0] );
  rmf_osal_mutexAcquire(vlg_PodCipherMutex);
  ret = getCipherMatchData( ltsid,PrgNum,decodePid,numpids,&pCipherData );
  if( ( ret == 0) || ( ret == 1) )
  {
	      pCipherData->ePidFilterState = VL_HALPOD_PID_FILTER_SET;
	      //if( (pCipherData->eDataSet == VL_HALPOD_CIPHER_DATA_SET) &&  (pCipherData->eCipherState != VL_HALPOD_CIPHER_CONFIG_START) )
	      if( pCipherData->eDataSet == VL_HALPOD_CIPHER_DATA_SET ) 
	      {
		      iRet = vlCipherConfigPidFilterStartDecrypt(pCipherData);
		      if(iRet != 0 )
		      {
			    pCipherData->eCipherState = VL_HALPOD_CIPHER_CONFIG_ERROR;
		      }
		      else
		      {
			    RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "%s():Cipher configuration is success,cipher start set \n",__FUNCTION__,ltsid,PrgNum,numpids,decodePid[0] );
			    pCipherData->eCipherState = VL_HALPOD_CIPHER_CONFIG_START;
		      }
	      }
	      else if(pCipherData->eDataSet == VL_HALPOD_CIPHER_DATA_NOT_SET)
	      {
		   UINT32 ii;
		   RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s():storing data ltsid:%d PrgNum:%d numpids:%d decodePid[0]:0x%X\n",__FUNCTION__,ltsid,PrgNum,numpids,decodePid[0] );
		    pCipherData->ltsid = ltsid;
		    pCipherData->PrgNum = PrgNum;
		    pCipherData->numPids = numpids;
		    
		    if( VL_HALPOD_MAX_DECODE_PIDS < numpids )
		    {
			RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s(): VL_HALPOD_MAX_DECODE_PIDS:%d  < numpids:%d  \n",__FUNCTION__,VL_HALPOD_MAX_DECODE_PIDS,numpids );
			pCipherData->numPids = VL_HALPOD_MAX_DECODE_PIDS;
		    }
		    
		    for( ii = 0; ii < pCipherData->numPids; ii++)
		    {
			pCipherData->decodePid[ii] = decodePid[ii];
		    }

	      }
  }
  else
  {
      RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s():Error  Didn't find the resource  \n",__FUNCTION__ );
      iRet = -1;
  }
  rmf_osal_mutexRelease(vlg_PodCipherMutex);
  return iRet;
}

int vlCipherConfigPidFilterStartDecrypt(vlPodConfigureCipherData_t *pCipherData)
{
  return vlConfigureCipher(pCipherData->ltsid, pCipherData->PrgNum, pCipherData->decodePid, pCipherData->numPids,
		    pCipherData->DesKeyAHi,pCipherData->DesKeyALo,pCipherData->DesKeyBHi,pCipherData->DesKeyBLo,pCipherData->ptr);
 
}
#endif

int vlStopConfigureCipher(unsigned char ltsid,unsigned short PrgNum,UINT32 *decodePid,UINT32 numpids)
{
  //printf("vlStopConfigureCipher: Entered \n");
  if(!vl_env_get_bool(false, "FEATURE.CIPHER.SYNC"))
  {
  
    RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s(): Cipher Sync Not supported \n",__FUNCTION__);
    return 0;
  }
  return vlConfigCipherStop(ltsid,PrgNum,decodePid,numpids);
  
}

// Returns program key index associated with a given LTSID
// Returns -1 if no program key index exists with the given LTSID
static int getProgramKeyIndexFromLTSID(unsigned char ltsid)
{
    int retValue = -1;
    int i;

    for (i = 0; i < MAX_PROGRAM_KEYS; i++)
    {
        if (g_ccProgramKeys[i].ltsid == ltsid)
        {
            retValue = i;
            break;
        }
    }

    return retValue;
}

static int getFreeProgramKeyIndex()
{
    int retValue = -1;
    int i;

    for (i = 0; i < MAX_PROGRAM_KEYS; i++)
    {
        /* IMS#587247: Use 0xff (Previously 0) to indicate unused ltsid. ltsid(tuner) 0 is valid */
        if (0xff == g_ccProgramKeys[i].ltsid)
        {
            retValue = i;
            break;
        }
    }

    return retValue;
}

#ifdef NEXUS_HAS_SECURITY
// Allocates and configures keyslot and stores handle in program keys array
// Returns -1 on either allocation or configuration failure
static int configureKeyslot(int progKey)
{
    int retValue = -1;
#if (NEXUS_SECURITY_API_VERSION == 2)
    NEXUS_KeySlotAllocateSettings keyslotAllocSettings;
    NEXUS_KeySlotSettings keyslotSettings;
    NEXUS_KeySlotEntrySettings keyslotEntrySettings;
    NEXUS_KeySlotHandle keyslotHandle = NULL;
    NEXUS_KeySlotBlockEntry entry;
    NEXUS_Error rc = NEXUS_UNKNOWN;

    /* allocate keyslot */
    NEXUS_KeySlot_GetDefaultAllocateSettings( &keyslotAllocSettings );
    keyslotAllocSettings.owner = NEXUS_SecurityCpuContext_eHost;
    keyslotAllocSettings.slotType = NEXUS_KeySlotType_eIvPerBlock;
    keyslotAllocSettings.useWithDma = false;
    keyslotHandle = NEXUS_KeySlot_Allocate( &keyslotAllocSettings );
    if( !keyslotHandle ) { goto exit;}

    /*configure keyslot parameters */
    NEXUS_KeySlot_GetSettings( keyslotHandle, &keyslotSettings );
    rc = NEXUS_KeySlot_SetSettings( keyslotHandle, &keyslotSettings );
    if( rc != NEXUS_SUCCESS ) { goto exit; }

    /*configure keyslot entry parameters. setting for all ood, even, and clear */
    entry = NEXUS_KeySlotBlockEntry_eCaOdd;
    for(int i = 0; i < 2 ; i++) {
        NEXUS_KeySlot_GetEntrySettings( keyslotHandle, (NEXUS_KeySlotBlockEntry)(entry+i), 
                &keyslotEntrySettings );
        keyslotEntrySettings.algorithm = NEXUS_CryptographicAlgorithm_e3DesAba;
        keyslotEntrySettings.algorithmMode = NEXUS_CryptographicAlgorithmMode_eEcb;
        keyslotEntrySettings.terminationMode = NEXUS_KeySlotTerminationMode_eCtsEcb;
        keyslotEntrySettings.rPipeEnable = true;
        keyslotEntrySettings.gPipeEnable = true;
        rc = NEXUS_KeySlot_SetEntrySettings( keyslotHandle, (NEXUS_KeySlotBlockEntry)(entry+i), 
                &keyslotEntrySettings );
        if( rc != NEXUS_SUCCESS ) { goto exit;}
    }
    g_ccProgramKeys[progKey].keyslot = keyslotHandle;
    retValue = 0;
    RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "%s: Successfully configured keyslot %p\n", __FUNCTION__, keyslotHandle);
 exit:
    if (retValue != 0) {
        RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "%s: unable to configure key slot %u\n", __FUNCTION__, rc);
    }
     return retValue;
#else /* NEXUS_SECURITY_API_VERSION */

    NEXUS_SecurityKeySlotSettings keySlotSettings;
    NEXUS_SecurityAlgorithmSettings algorithmSettings;
    NEXUS_KeySlotHandle keyslot = NULL;

    // Get common keyslot settings
    NEXUS_Security_GetDefaultKeySlotSettings(&keySlotSettings);
    keySlotSettings.keySlotEngine = NEXUS_SecurityEngine_eCa;

    // Allocate new NEXUS keyslot
    keyslot = NEXUS_Security_AllocateKeySlot(&keySlotSettings);

    if (keyslot != 0)
    {
        // Key allocation was successful
        g_ccProgramKeys[progKey].keyslot = keyslot;
        RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "%s: Successfully created keyslot %p\n", __FUNCTION__, keyslot);

        // Set up security algorithm
        NEXUS_Security_GetDefaultAlgorithmSettings(&algorithmSettings);
        algorithmSettings.modifyScValue[NEXUS_SecurityPacketType_eGlobal]=true;
        algorithmSettings.modifyScValue[NEXUS_SecurityPacketType_eRestricted]=true;
        algorithmSettings.terminationMode = NEXUS_SecurityTerminationMode_eCipherStealing;
        algorithmSettings.algorithm = NEXUS_SecurityAlgorithm_e3DesAba;
        algorithmSettings.algorithmVar = NEXUS_SecurityAlgorithmVariant_eEcb;

        if (0 == NEXUS_Security_ConfigAlgorithm (keyslot, &algorithmSettings))
        {
            retValue = 0;
            RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "%s: Successfully configured keyslot %p\n", __FUNCTION__, keyslot);
        }
        else
        {
            RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "%s: unable to configure key algorithm\n", __FUNCTION__);
        }
    }
    else
    {
        RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "%s: unable to allocate key slot\n", __FUNCTION__);
    }

    return retValue;
#endif /* NEXUS_SECURITY_API_VERSION */
}


// Configures a specified NEXUS keyslot with the given key.
// Returns -1 if loading the key fails.
static int updateKeyslots(int progKey, unsigned char *key, unsigned int keySize)
{
    int retValue = -1;
#if (NEXUS_SECURITY_API_VERSION == 2)
    NEXUS_KeySlotKey slotKey;
    NEXUS_KeySlotBlockEntry entry;
    NEXUS_Error rc = NEXUS_UNKNOWN;
    slotKey.size = keySize;
    memcpy(slotKey.key, key, keySize);
    entry = NEXUS_KeySlotBlockEntry_eCaOdd;
    for(int i = 0; i < 2; i++) {
        rc = NEXUS_KeySlot_SetEntryKey(g_ccProgramKeys[progKey].keyslot, (NEXUS_KeySlotBlockEntry)(entry+i), &slotKey);
        if( rc != NEXUS_SUCCESS ) {
            RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "%s: error loading key %d, rc %u\n", __FUNCTION__, i, rc);
            goto exit;
        }
    }
    RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "%s: key slot configured successfully\n", __FUNCTION__);
    retValue = 0;
exit:
    return retValue;
#else /* NEXUS_SECURITY_API_VERSION */
    NEXUS_SecurityClearKey clearKey;
    NEXUS_Security_GetDefaultClearKey(&clearKey);
    
    if (NULL != g_ccProgramKeys[progKey].keyslot)
    {
        /* Set clear key */
        clearKey.keySize = keySize; /* 16 bytes (128 bits) */
        memcpy(clearKey.keyData, key, keySize);

        // Load odd video key
        clearKey.keyEntryType = NEXUS_SecurityKeyType_eOdd;
        if (0 == NEXUS_Security_LoadClearKey(g_ccProgramKeys[progKey].keyslot, &clearKey))
        {
            // Load even video key
            clearKey.keyEntryType = NEXUS_SecurityKeyType_eEven;
            if (0 == NEXUS_Security_LoadClearKey(g_ccProgramKeys[progKey].keyslot, &clearKey))
            {
                RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "%s: key slot configured successfully\n", __FUNCTION__);
                retValue = 0;
            }
            else
            {
                RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "%s: error loading even key\n", __FUNCTION__);
            }
        }
        else
        {
            RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "%s: error loading odd key\n", __FUNCTION__);
        }
    }
    else
    {
        RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "%s: no keyslot created\n", __FUNCTION__);
    }
    return retValue;
#endif /* NEXUS_SECURITY_API_VERSION */
}

// Adds a pidchannel to the given keyslot
// Returns -1 if unable to add the pidchannel
// Returns 1 if pidChannel has already been attached to this keyslot
static int addPidChannelToKeyslot(int progKey, int pidChan)
{
    int retValue = -1;
    int openSlot = -1;
    int i;
    NEXUS_Error rc = NEXUS_SUCCESS;
    NEXUS_PidChannelStatus pidStatus;

    // Get pidchannel status to get the index
    NEXUS_PidChannel_GetStatus ((NEXUS_PidChannelHandle)pidChan, &pidStatus);
    RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "%s: pidchannel index is 0x%x\n", __FUNCTION__, pidStatus.pidChannelIndex);
    
    for (i = 0; i < MAX_PIDCHANNELS; i++)
    {
        // Check to see if pidChannel is already attached to this keyslot
#if (NEXUS_SECURITY_API_VERSION == 2)
        if ( (int)pidChan == g_ccProgramKeys[progKey].pidChannelIndex[i])
        {
            RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "%s: pidChannel %p has already been attached to this keyslot\n", __FUNCTION__, pidChan);
            retValue = 1;
            break;
        }
        // While stepping through the array, find the first open slot
        else if ((0 == g_ccProgramKeys[progKey].pidChannelIndex[i]) && (-1 == openSlot))
        {
            openSlot = i;
            RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "%s: found open slot at location %d\n", __FUNCTION__, openSlot);
        }
#else
        if ( (int)pidStatus.pidChannelIndex == g_ccProgramKeys[progKey].pidChannelIndex[i])
        {
            RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "%s: pidChannel %p has already been attached to this keyslot\n", __FUNCTION__, pidChan);
            retValue = 1;
            break;
        }
        // While stepping through the array, find the first open slot
        else if ((-1 == g_ccProgramKeys[progKey].pidChannelIndex[i]) && (-1 == openSlot))
        {
            openSlot = i;
            RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "%s: found open slot at location %d\n", __FUNCTION__, openSlot);
        }
#endif
    }

    // If the pidchannel index was not found and there is an open slot, add the pidchannel
    if ((i == MAX_PIDCHANNELS) && (openSlot != -1))
    {
        if (NULL != g_ccProgramKeys[progKey].keyslot)
        {
#if (NEXUS_SECURITY_API_VERSION == 2)
            rc = NEXUS_KeySlot_AddPidChannel(g_ccProgramKeys[progKey].keyslot, (NEXUS_PidChannelHandle)pidChan); 
            if (rc == NEXUS_SUCCESS)
            {
                g_ccProgramKeys[progKey].pidChannelIndex[openSlot] = pidChan;
                RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "%s: Added pidchannel %p to slot %d\n", __FUNCTION__, pidChan, openSlot);
                retValue = 0;
            }
            else
            {
                RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "%s: Error adding pidchannel to key slot\n", __FUNCTION__);
            }
#else
            rc = NEXUS_Security_AddPidChannelToKeySlot(g_ccProgramKeys[progKey].keyslot, pidStatus.pidChannelIndex);
            if (rc == NEXUS_SUCCESS)
            {
                g_ccProgramKeys[progKey].pidChannelIndex[openSlot] = pidStatus.pidChannelIndex;
                RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "%s: Added pidchannel %p to slot %d\n", __FUNCTION__, pidChan, openSlot);
                retValue = 0;
            }
            else
            {
                RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "%s: Error adding pidchannel to key slot\n", __FUNCTION__);
            }
#endif /* NEXUS_SECURITY_API_VERSION */

        }
        else
        {
            RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "%s: Key slot has not been allocated\n", __FUNCTION__);
        }
    }
    else
    {
        if ( i != MAX_PIDCHANNELS ) {
            RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "%s: Pidchannel already attached to keyslot\n",
                __FUNCTION__);
            retValue = 1;
        } else {
            RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "%s: Maximum number of pidchannels have been added\n",
                __FUNCTION__);
        }
    }

    return retValue;
}

// Removes a pidchannel from the given keyslot
static int removePidchannelFromKeyslot(int progKey, int pidChan)
{
    int retValue = -1;
    int i;
    NEXUS_PidChannelStatus pidStatus;
    
    // Get pidchannel status to get the index
    NEXUS_PidChannel_GetStatus((NEXUS_PidChannelHandle)pidChan, &pidStatus);
    
    // Check to see if the pidchannel is already attached to the keyslot
    for (i = 0; i < MAX_PIDCHANNELS; i++)
    {
#if (NEXUS_SECURITY_API_VERSION == 2)
        if ( (int)pidChan == g_ccProgramKeys[progKey].pidChannelIndex[i])
        {
            RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "%s: Found pidchannel %p at slot %d\n", __FUNCTION__, pidChan, i);
            break;
        }
#else
        if ( (int)pidStatus.pidChannelIndex == g_ccProgramKeys[progKey].pidChannelIndex[i])
        {
            RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "%s: Found pidchannel %p at slot %d\n", __FUNCTION__, pidChan, i);
            break;
        }
#endif /* NEXUS_SECURITY_API_VERSION */
    }

    // If the pidchannel was found
    if (i != MAX_PIDCHANNELS)
    {
        if (g_ccProgramKeys[progKey].keyslot != NULL)
        {
#if (NEXUS_SECURITY_API_VERSION == 2)
            NEXUS_KeySlot_RemovePidChannel(g_ccProgramKeys[progKey].keyslot, (NEXUS_PidChannelHandle)pidChan);
            g_ccProgramKeys[progKey].pidChannelIndex[i] = 0;
#else
            NEXUS_Security_RemovePidChannelFromKeySlot(g_ccProgramKeys[progKey].keyslot, pidStatus.pidChannelIndex);
            g_ccProgramKeys[progKey].pidChannelIndex[i] = -1;
#endif /* NEXUS_SECURITY_API_VERSION */
            RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "%s: Removed pidchannel %p from keyslot %p\n", __FUNCTION__, pidChan, g_ccProgramKeys[progKey].keyslot);
            retValue = 0;
        }
        else
        {
            RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "%s: No key slot has been created\n", __FUNCTION__);
        }
    }
    else
    {
        RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "%s: Pidchannel index has not been added to keyslot\n", __FUNCTION__);
    }

    return retValue;
}

static void freeKeyslot(int progKey)
{
    if (NULL != g_ccProgramKeys[progKey].keyslot)
    {
#if (NEXUS_SECURITY_API_VERSION == 2)
        NEXUS_KeySlot_Free(g_ccProgramKeys[progKey].keyslot);
#else
        NEXUS_Security_FreeKeySlot(g_ccProgramKeys[progKey].keyslot);
#endif /* NEXUS_SECURITY_API_VERSION */
        g_ccProgramKeys[progKey].keyslot = NULL;
    }

    return;
}


static void vlReleaseKeySlot(unsigned char ltsid)
{
    int progKey = 0;

    progKey = getProgramKeyIndexFromLTSID(ltsid);

    if (-1 != progKey)
    {
        RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "%s: freeing keyslot %d\n", __FUNCTION__, progKey);
        freeKeyslot(progKey);
        resetProgramKey(progKey);
    }
    else
    {
        RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "%s: Programkey not found\n", __FUNCTION__);
    }

    return;
}
#endif

int vlConfigureCipher(unsigned char ltsid,unsigned short PrgNum,UINT32 *decodePid, UINT32 numpids,UINT32 DesKeyAHi,UINT32 DesKeyALo,UINT32 DesKeyBHi,UINT32 DesKeyBLo,void *ptr)
{
    unsigned char Key128[16];

    unsigned int i;
    int progKey = -1;
    int rc = 0;

    RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "%s: Entering....\n", __FUNCTION__);

#ifdef NEXUS_HAS_SECURITY    

    // If tuner already has a cipher open, just update it where necessary
    progKey = getProgramKeyIndexFromLTSID(ltsid);
    RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "%s: program key %d\n", __FUNCTION__, progKey);
   
    if (-1 == progKey)
    {
        // Get available program key
        progKey = getFreeProgramKeyIndex();
        RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "%s: Got new program key %d\n", __FUNCTION__, progKey);
        rc = configureKeyslot(progKey);

        // Assign ltsid to identify the program keys
        g_ccProgramKeys[progKey].ltsid = ltsid;
    } else {
        // Cleanup all previous pidchannels if any, then we should not have "already attached" case any more
        for (i=0; i<MAX_PIDCHANNELS; i++) {
            if ( NULL != g_ccProgramKeys[progKey].pidChannels[i] ) {
                removePidchannelFromKeyslot(progKey,(int)g_ccProgramKeys[progKey].pidChannels[i]);
#if (NEXUS_PLATFORM == 97425)
/* MOT7425-7248: 6 Tuner support. Add software rate-smoothing. Loop back Tuner 0 through Recpump & Playpump */
                if((bSWRateSmooth) && (SW_RS_LOOPBACK_PLAYPUMP_LTSID == ltsid))
                {
            		NEXUS_Playpump_ClosePidChannel(NEXUS_Playpump_RetrieveHandle(SW_RS_LOOPBACK_PLAYPUMP_INDEX), g_ccProgramKeys[progKey].pidChannels[i]); // the hTxpt of LIVE takse the Tuner Id
                }
                else
                {
#endif
                NEXUS_PidChannel_Close(g_ccProgramKeys[progKey].pidChannels[i]);  
#if (NEXUS_PLATFORM == 97425)
                }
#endif
                g_ccProgramKeys[progKey].pidChannels[i] = NULL;
            }
        }
    }

    if (-1 != progKey)
    {
        // Reset Pidchannels
        memset(g_ccProgramKeys[progKey].pidChannels, 0, sizeof(g_ccProgramKeys[progKey].pidChannels));

        //RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "ltsid is %d, prgnum is %d, numpids is %d\n", ltsid, PrgNum, numpids);

        // Convert key to array
        Key128[0] = (DesKeyAHi >> 24) & 0xFF;
        Key128[1] = (DesKeyAHi >> 16) & 0xFF;
        Key128[2] = (DesKeyAHi >>  8) & 0xFF;
        Key128[3] = (DesKeyAHi >>  0) & 0xFF;
        Key128[4] = (DesKeyALo >> 24) & 0xFF;
        Key128[5] = (DesKeyALo >> 16) & 0xFF;
        Key128[6] = (DesKeyALo >>  8) & 0xFF;
        Key128[7] = (DesKeyALo >>  0) & 0xFF;

        Key128[8] = (DesKeyBHi >> 24) & 0xFF; /* Odd video */
        Key128[9] = (DesKeyBHi >> 16) & 0xFF;
        Key128[10] = (DesKeyBHi >> 8) & 0xFF;
        Key128[11] = (DesKeyBHi >> 0) & 0xFF;
        Key128[12] = (DesKeyBLo >> 24) & 0xFF;
        Key128[13] = (DesKeyBLo >> 16) & 0xFF;
        Key128[14] = (DesKeyBLo >>  8) & 0xFF;
        Key128[15] = (DesKeyBLo >>  0) & 0xFF;

#if 0
        RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "Key being sent to Nexus\n");
        for (j=0; j<16; j++)
        {
            RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "0x%02x ", Key128[j]);
        }
        RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "\n");
#endif

        rc = updateKeyslots(progKey, Key128, 16);
        
        if (-1 != rc)
        {
            // At this point the keyslots are created correctly.
            // If the pidchannels are not open yet, the next part will fail,
            // but we will try to load them again during start decode.

            for (i=0; i<numpids; i++)
            {
                NEXUS_PidChannelHandle hPidChan;
                NEXUS_PidChannelSettings pidChanSettings;
                
                NEXUS_PidChannel_GetDefaultSettings(&pidChanSettings);
                pidChanSettings.pidChannelIndex = NEXUS_PID_CHANNEL_OPEN_MESSAGE_CAPABLE;
                

#if (NEXUS_PLATFORM == 97425)
/* MOT7425-7248: 6 Tuner support. Add software rate-smoothing. Loop back Tuner 0 through Recpump & Playpump */
                        if((bSWRateSmooth) && (SW_RS_LOOPBACK_PLAYPUMP_LTSID == ltsid))
                        {
                            NEXUS_PlaypumpOpenPidChannelSettings playpumpPidChanSettings;
                            NEXUS_Playpump_GetDefaultOpenPidChannelSettings(&playpumpPidChanSettings);		
                            playpumpPidChanSettings.pidType = NEXUS_PidType_eOther;
                            hPidChan = NEXUS_Playpump_OpenPidChannel(NEXUS_Playpump_RetrieveHandle(SW_RS_LOOPBACK_PLAYPUMP_INDEX),decodePid[i], &playpumpPidChanSettings);
                        }
                        else
                        {
#endif    
                hPidChan = NEXUS_PidChannel_Open((NEXUS_ParserBand)ltsid, decodePid[i], &pidChanSettings); 
#if (NEXUS_PLATFORM == 97425)
                        }
#endif
                
                if (0 != hPidChan)
                {
                    rc = addPidChannelToKeyslot(progKey, (int)hPidChan);
                    if ( rc == 0 ) {
                        g_ccProgramKeys[progKey].pidChannels[i] = hPidChan;
                    } else {
                        NEXUS_PidChannel_Close(hPidChan);
                        RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "%s: Close pidchannel %p\n", __FUNCTION__, hPidChan);
                        if ( rc == 1 ) { 
                            rc = 0; 
                        }
                    }
                }
                else
                {
                    RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "%s: no pidchannel for pid 0x%x\n", __FUNCTION__, decodePid[i]);
                }
            }
        }
        else
        {
            RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD",  "%s: Error setting key\n", __FUNCTION__);
        }
    }
    else
    {
        RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "%s: No free program key slots\n", __FUNCTION__);
    }
#endif

    return rc;
}

int vlCipherConfigCopyData(unsigned char ltsid,unsigned short PrgNum,UINT32 *decodePid,UINT32 numpids,UINT32 DesKeyAHi,UINT32 DesKeyALo,UINT32 DesKeyBHi,UINT32 DesKeyBLo,void *ptr,vlPodConfigureCipherData_t *pData)
{
  unsigned int ii;
  if(numpids > VL_HALPOD_MAX_DECODE_PIDS)
  {
     RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s(): Number of elm pids  numpids:%d > %d ltsid:%d PrgNum:%d \n",__FUNCTION__,numpids,VL_HALPOD_MAX_DECODE_PIDS,ltsid,PrgNum);
     numpids = VL_HALPOD_MAX_DECODE_PIDS;
  }
  if(decodePid == NULL )
  {
    RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s(): Error decodePid is NULL pointer ltsid:%d PrgNum:%d \n",__FUNCTION__,ltsid,PrgNum);
    return -1;
  }
  pData->eDataSet = VL_HALPOD_CIPHER_DATA_SET;
  pData->ltsid = ltsid;
  pData->PrgNum = PrgNum;
   for( ii = 0; ii < numpids; ii++)
  {
    pData->decodePid[ii] = decodePid[ii];
  }
  pData->numPids = numpids;
  pData->DesKeyAHi = DesKeyAHi;
  pData->DesKeyALo = DesKeyALo;
  pData->DesKeyBHi = DesKeyBHi;
  pData->DesKeyBLo = DesKeyBLo;
  pData->ptr = ptr;
  return 0;
}

int vlCipherConfigCardStartDecrypt(unsigned char ltsid,unsigned short PrgNum,UINT32 *decodePid,UINT32 numpids,UINT32 DesKeyAHi,UINT32 DesKeyALo,UINT32 DesKeyBHi,UINT32 DesKeyBLo,void *ptr)
{
   int iRet = -1;
   vlPodConfigureCipherData_t *pCipherData = NULL;
   //printf("vlCipherConfigCardStartDecrypt : Entered \n");
     if((decodePid == NULL) || (numpids == 0))
    {
      RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s():Error input data  (decodePid == NULL) || (numpids == %d) \n",__FUNCTION__,numpids );
      return -1;
    }
    RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "%s():Input params ltsid:%d PrgNum:%d numpids:%d decodePid[0]:0x%X\n",__FUNCTION__,ltsid,PrgNum,numpids,decodePid[0] );
  rmf_osal_mutexAcquire(vlg_PodCipherMutex);
  if( -1 != getCipherMatchData( ltsid, PrgNum, decodePid, numpids, &pCipherData ) )
  {
	      if( 0 != vlCipherConfigCopyData(ltsid,PrgNum,decodePid,numpids,DesKeyAHi,DesKeyALo, DesKeyBHi, DesKeyBLo,ptr,pCipherData) )
	      {
		    RDK_LOG( RDK_LOG_ERROR, "LOG.RDK.POD", "%s(): Error Copying data .. returned error by vlCipherConfigCopyData \n",__FUNCTION__);
	      }
	      else if( (pCipherData->ePidFilterState == VL_HALPOD_PID_FILTER_SET) &&  (pCipherData->eDataSet == VL_HALPOD_CIPHER_DATA_SET) )
	      {
		    iRet = vlConfigureCipher(pCipherData->ltsid, pCipherData->PrgNum, pCipherData->decodePid, pCipherData->numPids,
			    pCipherData->DesKeyAHi,pCipherData->DesKeyALo,pCipherData->DesKeyBHi,pCipherData->DesKeyBLo,pCipherData->ptr);
		    if(iRet != 0 )
		    {
			pCipherData->eCipherState = VL_HALPOD_CIPHER_CONFIG_ERROR;
			RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s(): Error Configuring Cipher \n",__FUNCTION__);
			
		    }
		    else
		    {
			pCipherData->eCipherState = VL_HALPOD_CIPHER_CONFIG_START;
			iRet = 0;// Success
		    }
	      }
	      else
	      {
		    RDK_LOG( RDK_LOG_INFO, "LOG.RDK.POD", "%s():Pid Filters not set at this moment. so no cipher configuration done..  ltsid:%d PrgNum:%d \n",__FUNCTION__,ltsid,PrgNum);
	      }

  }
  else
  {
	RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s(): Error No Resource Found\n",__FUNCTION__);
  }
   
  rmf_osal_mutexRelease(vlg_PodCipherMutex);
  return iRet;
}

void resetProgramKey(int index)
{
    int i;
    
    for(i = 0; i < MAX_PIDCHANNELS; i++)
    {
#if (NEXUS_SECURITY_API_VERSION == 2)
        g_ccProgramKeys[index].pidChannelIndex[i] = 0;
#else
        g_ccProgramKeys[index].pidChannelIndex[i] = -1;
#endif
    }
    g_ccProgramKeys[index].keyslot = NULL;
    /* IMS#587247: Use 0xff (Previously 0) to indicate unused ltsid. ltsid(tuner) 0 is valid */
    g_ccProgramKeys[index].ltsid = 0xff;

    return;
}

#endif // MPOD_SUPPORT
//#else
//#error "USE_POD is not defined.."
#endif // USE_POD
