/*
* ============================================================================
* RDK MANAGEMENT, LLC CONFIDENTIAL AND PROPRIETARY
* ============================================================================
* This file (and its contents) are the intellectual property of RDK Management, LLC.
* It may not be used, copied, distributed or otherwise  disclosed in whole or in
* part without the express written permission of RDK Management, LLC.
* ============================================================================
* Copyright (C) 2017 Broadcom. The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
* Copyright (c) 2017 RDK Management, LLC. All rights reserved.
* ============================================================================
*/

#include <map>
#include "rmf_osal_sync.h"
#include "rmf_osal_mem.h"
#include "rdk_debug.h"

#define RMF_OSAL_MEMMAP_MAX_INFO_LENGTH	500	// maximum length of information char string

using namespace std;

typedef map<void *, char *>	mem;		// void * virt_address, char * info_string(caller...)
							mem MEM;	// d/b of the mapped memory
static rmf_osal_Mutex g_OsalMemmapLock;	// the mutex of the d/b

#ifdef __cplusplus
extern "C"
{
#endif

#include "osal_memmap.h"				// <--- the original osal function's header file.

//extern int g_OsalMemmapThreshold;	// dump the d/b if exceeding the level
int g_OsalMemmapThreshold = 9999; //Hardcoded for now... need to get it from mpeenv.ini //TODO

void rmf_osal_memmap_init()
{
        if(RMF_SUCCESS != rmf_osal_mutexNew(&g_OsalMemmapLock))
        {
                RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.FILTER", "%s:: Could not create g_OsalMemmapLock\n", __FUNCTION__);
        }	
}

void rmf_osal_memmap_uninit()
{
        if(RMF_SUCCESS != rmf_osal_mutexDelete(g_OsalMemmapLock))
        {
                RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.FILTER", "%s:: Could not delete g_OsalMemmapLock\n", __FUNCTION__);
        }	
}


/**
 * internal function to store caller's information to the d/b.
 */
static void * rmf_OsMapIoToJournal (const char * macro, unsigned long base_address, void * virt_address, size_t size, char * file, char * function, int line)
{
//{VL_AUTO_LOCK(vlg_vlOsalMemmapLock);
	rmf_osal_mutexAcquire(g_OsalMemmapLock);

	mem::iterator it = MEM.find(virt_address);
	//char * str = (char *)vlMalloc(VL_OSAL_MEMMAP_MAX_INFO_LENGTH);
	char *str = NULL;
	rmf_osal_memAllocP(RMF_OSAL_MEM_GENERAL, RMF_OSAL_MEMMAP_MAX_INFO_LENGTH, (void**)&str);
    if (it == MEM.end()) {
		snprintf(str, RMF_OSAL_MEMMAP_MAX_INFO_LENGTH, "%s(base=%ld, size=%d)@%s:%s:%d", macro, base_address, size, file, function, line);
		MEM.insert(mem::value_type(virt_address, str));
		RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SYS", "%s, the virt_address=%p\n", str, virt_address);
    } else {
		RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.SYS", "%s(base=%ld, size=%d)@%s:%s:%d, but it has already in the d/b = %s. the virt_address=%p\n", macro, base_address, size, file, function, line, it->second, it->first);
	}
//} // <-- VL_AUTO_UNLOCK(vlg_vlOsalMemmapLock);
	rmf_osal_mutexRelease(g_OsalMemmapLock);
	return virt_address;
}

void * rmf_OsMapIoToMemCache (unsigned long base_address, size_t size, char * file, char * function, int line)
{
	return rmf_OsMapIoToJournal("OS_MAP_IO_TO_MEM_CACHE", base_address, OS_MAP_IO_TO_MEM_CACHE(base_address, size), size, file, function, line);
}

void * rmf_OsMapIoToMemNocache (unsigned long base_address, size_t size, char * file, char * function, int line)
{
	return rmf_OsMapIoToJournal("OS_MAP_IO_TO_MEM_NOCACHE", base_address, OS_MAP_IO_TO_MEM_NOCACHE(base_address, size), size, file, function, line);
}

void * rmf_OsMapIoToLargeMemNocache (unsigned long base_address, size_t size, char * file, char * function, int line)
{
	return rmf_OsMapIoToJournal("OS_MAP_IO_TO_LARGE_MEM_NOCACHE", base_address, OS_MAP_IO_TO_LARGE_MEM_NOCACHE(base_address, size), size, file, function, line);
}

void rmf_OsUnmapIoFromMem (void * virt_address, size_t size, char * file, char * function, int line)
{
//{VL_AUTO_LOCK(vlg_vlOsalMemmapLock);
	rmf_osal_mutexAcquire(g_OsalMemmapLock);
	mem::iterator it = MEM.find(virt_address);
    if (it == MEM.end()) {
		RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.SYS", "OS_UNMAP_IO_FROM_MEM(%p, %d)@%s:%s:%d, trying to un-map, but not in the d/b\n", virt_address, size, file, function, line);
    } else {
		RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SYS", "OS_UNMAP_IO_FROM_MEM(%p, %d) is called by %s:%s:%d, was allocated by %s. the virt_address=%p, d/b total reamins=%d\n", virt_address, size, file, function, line, it->second, it->first, MEM.size());
		//vlFree(it->second);
		rmf_osal_memFreeP(RMF_OSAL_MEM_GENERAL, it->second);
		MEM.erase(it);
		if (g_OsalMemmapThreshold < MEM.size()) {
			int i = 0;
			for (it = MEM.begin(); it != MEM.end(); it ++) {
				RDK_LOG(RDK_LOG_INFO, "LOG.RDK.SYS", "VL_OSAL_MEMMAP d/b still holds (%d of %d) %s, the virt_address=%p\n", (i + 1), MEM.size(), it->second, it->first);
				++ i;
			}
		}
	
	}

	rmf_osal_mutexRelease(g_OsalMemmapLock);
//} // <-- VL_AUTO_UNLOCK(vlg_vlOsalMemmapLock);
	OS_UNMAP_IO_FROM_MEM(virt_address, size);
}

/**
 * VL_OSAL_MEMMAP RACK_TEST version
 */
uint64_t g_OsMapIoToMemCount = 0LL;
uint64_t g_OsUnMapIoToMemCount = 0LL;

void * rmf_OsMapIoToMemCacheRackTest (unsigned long base_address, size_t size) {
	++ g_OsMapIoToMemCount;
	return OS_MAP_IO_TO_MEM_CACHE(base_address, size);
}

void * rmf_OsMapIoToMemNocacheRackTest (unsigned long base_address, size_t size) {
	++ g_OsMapIoToMemCount;
	return OS_MAP_IO_TO_MEM_NOCACHE(base_address, size);
}

void * rmf_OsMapIoToLargeMemNocacheRackTest (unsigned long base_address, size_t size) {
	++ g_OsMapIoToMemCount;
	return OS_MAP_IO_TO_LARGE_MEM_NOCACHE(base_address, size);
}

void rmf_OsUnmapIoFromMemRackTest (void * virt_address, size_t size) {
	++ g_OsUnMapIoToMemCount;
	OS_UNMAP_IO_FROM_MEM(virt_address, size);
}

#ifdef __cplusplus
}
#endif

