MODULE = webenginecore
TARGET = QtWebEngineCore

#COMCAST MODIFICATION BEGIN [REMOVE QT QUICK DEPS]
qtHaveModule(quick) {
  QT += qml quick
  QT_PRIVATE += qml-private quick-private 
}
#COMCAST MODIFICATION END [REMOVE QT QUICK DEPS]
#COMCAST MODIFICATION BEGIN [BREAKPAD]
packagesExist(breakpad) {
    message(ENABLE_GOOGLE_BREAKPAD)
    DEFINES += ENABLE_GOOGLE_BREAKPAD
    CONFIG += link_pkgconfig
    PKGCONFIG_PRIVATE += breakpad
}
#COMCAST MODIFICATION END [BREAKPAD]
QT_PRIVATE += gui-private core-private

# Look for linking information produced by gyp for our target according to core_generated.gyp
!include($$OUT_PWD/$$getConfigDir()/$${TARGET}_linking.pri) {
    error("Could not find the linking information that gyp should have generated.")
}

#COMCAST MODIFICATION BEGIN
debug : contains(QT_HOST_ARCH, "i386") : QMAKE_LFLAGS+=-Wl,--no-keep-memory
#COMCAST MODIFICATION END

# We distribute the module binary but headers are only available in-tree.
CONFIG += no_module_headers
load(qt_module)

# Using -Wl,-Bsymbolic-functions seems to confuse the dynamic linker
# and doesn't let Chromium get access to libc symbols through dlsym.
CONFIG -= bsymbolic_functions

contains(QT_CONFIG, egl): CONFIG += egl

#COMCAST MODIFICATION BEGIN [SYMBOL EXTRACTION]
#remove pre-emptive symbol extraction by commenting out the below 3 lines
#linux {
#    CONFIG(release, debug|release) | contains(QT_CONFIG, separate_debug_info): QMAKE_POST_LINK="cd $(DESTDIR) && $(STRIP) --strip-unneeded $(TARGET)"
#}
#COMCAST MODIFICATION END [SYMBOL EXTRACTION]
