/******************************************************************************
 *    (c)2010-2013 Broadcom Corporation
 *
 * This program is the proprietary software of Broadcom Corporation and/or its licensors,
 * and may only be used, duplicated, modified or distributed pursuant to the terms and
 * conditions of a separate, written license agreement executed between you and Broadcom
 * (an "Authorized License").  Except as set forth in an Authorized License, Broadcom grants
 * no license (express or implied), right to use, or waiver of any kind with respect to the
 * Software, and Broadcom expressly reserves all rights in and to the Software and all
 * intellectual property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU
 * HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY
 * NOTIFY BROADCOM AND DISCONTINUE ALL USE OF THE SOFTWARE.
 *
 * Except as expressly set forth in the Authorized License,
 *
 * 1.     This program, including its structure, sequence and organization, constitutes the valuable trade
 * secrets of Broadcom, and you shall use all reasonable efforts to protect the confidentiality thereof,
 * and to use this information only in connection with your use of Broadcom integrated circuit products.
 *
 * 2.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
 * AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
 * WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH RESPECT TO
 * THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND ALL IMPLIED WARRANTIES
 * OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE,
 * LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION
 * OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF
 * USE OR PERFORMANCE OF THE SOFTWARE.
 *
 * 3.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR ITS
 * LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL, INDIRECT, OR
 * EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY RELATING TO YOUR
 * USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM HAS BEEN ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT
 * ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE
 * LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF
 * ANY LIMITED REMEDY.
 *
 *****************************************************************************/

#include "platform_nexus_surface_compositor_display.h"
#include <string>
#include <fstream>
#include <sstream>

#if BCMNEXUS_ASAL_SUPPORT
BDBG_MODULE(nexus_asal_compositor_init);
#else
BDBG_MODULE(nexus_surface_compositor_init);
#endif

#if BCMNEXUS_ASAL_SUPPORT
#include "asal/window.h"
using namespace asal;
static Window *pWindowObj = NULL;
#endif


void  getValue ( const char * string, const char * format, ... )
{
    va_list args;
    va_start (args, format);
    (void) vsscanf (string, format, args);
    va_end (args);

    return;
}

void DFB_Platform_P_SetDefaultClientComposition()
{
    std::ifstream clientConfig(SYSCONFDIR"/directfbrc");
    std::string line;
    DFB_PlatformSurfaceComposition clientComposition;

    if(clientConfig.is_open())
    {
        /*parse string "dfb_nxclient_composition=WidthxHeight@X,Y-Zorder" */
        while (std::getline(clientConfig, line))
        {
            std::string delim("=");
            std::string optionSring("dfb_nxclient_composition");
            std::string valueString, subString;
            unsigned int pos = line.find(optionSring); /*split string "dfb_nxclient_composition" and "WidthxHeight@X,Y-Zorder"*/
            unsigned int pos2= line.find(delim);
            unsigned int width(640), height(480), zOrder(0);
            unsigned short xCoordinate(0), yCoordinate(0);
            std::string::size_type valueLength;

            if(std::string::npos != pos)
            {
                /*Check for # commented option */
                if(std::string::npos != line.find("#"))
                    continue;

                if(std::string::npos != pos2)
                {
                    valueString = line.substr(pos2+1, line.length());
                    valueLength = valueString.length();
                    subString = valueString;
                }
                else
                {
                    break; /*Null value*/
                }

                pos = subString.find("x");
                if(std::string::npos != pos )
                {
                    subString.insert(pos,1,' ');
                    pos = subString.find("x");
                    subString.insert(pos+1,1,' ');
                    pos = subString.find("@");
                    if(std::string::npos != pos)
                    {
                        subString.insert(pos,1,' ');
                    }

                    getValue( subString.c_str(), "%u %*s %u", &width, &height);
                }

                pos = valueString.find("@");
                if(std::string::npos != pos)
                {
                    subString = valueString.substr(pos+1, valueLength);
                }

                pos = subString.find(",");
                if(std::string::npos != pos )
                {
                    subString.insert(pos,1,' ');
                    pos = subString.find(",");
                    subString.insert(pos+1,1,' ');
                    pos = subString.find("-");
                    if(std::string::npos != pos)
                    {
                        subString.insert(pos,1,' ');
                    }
                    getValue ( subString.c_str(), "%d %*s %d", &xCoordinate, &yCoordinate);
                }

                pos = valueString.find("-");
                if(std::string::npos != pos)
                {
                    subString = valueString.substr(pos+1, valueLength);
                    getValue( subString.c_str(), "%d", &zOrder);
                }

                clientConfig.close();
                /*Set specified NxClient composition*/
                DFB_Platform_P_GetClientComposition(&clientComposition);
                clientComposition.position.width = width;
                clientComposition.position.height = height;
                clientComposition.position.x = xCoordinate;
                clientComposition.position.y = yCoordinate;
                clientComposition.zorder = zOrder;
                (void)DFB_Platform_P_SetClientComposition(&clientComposition);
            }
        }
    }

}

#ifdef __cplusplus
extern "C"
{
#endif

#include <stdio.h>
#include <stdarg.h>

void
DFB_Platform_SurfaceClient_GetSettings(DFB_PlatformNexusHandle display, NEXUS_SurfaceClientSettings *nexusSettings)
{
#if BCMNEXUS_ASAL_SUPPORT
    BSTD_UNUSED(display);
    *nexusSettings = pWindowObj->getClientSettings();
#else
    NEXUS_SurfaceClient_GetSettings((NEXUS_SurfaceClient*)display, nexusSettings);
#endif
}

DFB_PlatformResult
DFB_Platform_SurfaceClient_SetSettings(DFB_PlatformNexusHandle display, NEXUS_SurfaceClientSettings *nexusSettings)
{
    NEXUS_Error err;
#if BCMNEXUS_ASAL_SUPPORT
    BSTD_UNUSED(display);
    err = pWindowObj->setClientSettings(*nexusSettings);
#else
    err = NEXUS_SurfaceClient_SetSettings((NEXUS_SurfaceClient*)display, nexusSettings);

    DFB_Platform_P_SetDefaultClientComposition();
#endif

    return (err == NEXUS_SUCCESS) ? DFB_PLATFORM_OK : DFB_PLATFORM_FAILURE;

}

DFB_PlatformResult
DFB_Platform_SurfaceClient_RecycleSurface(
    DFB_PlatformNexusHandle blit_client,
    NEXUS_SurfaceHandle *surface,
    int maxRecycle,
    size_t* num)
{
    NEXUS_Error err;

#if BCMNEXUS_ASAL_SUPPORT
    BSTD_UNUSED(blit_client);
    err = pWindowObj->recycle(surface, maxRecycle, num);
#else
    err = NEXUS_SurfaceClient_RecycleSurface((NEXUS_SurfaceClient*)blit_client, surface, maxRecycle, num);
#endif

    return (err == NEXUS_SUCCESS) ? DFB_PLATFORM_OK : DFB_PLATFORM_FAILURE;
}

DFB_PlatformResult
DFB_Platform_SurfaceClient_PushSurface(
    DFB_PlatformNexusHandle display,
    NEXUS_SurfaceHandle surface,
    const DFB_PlatformRect *pUpdateRect)
{
    NEXUS_Error err;

#if BCMNEXUS_ASAL_SUPPORT
    BSTD_UNUSED(display);
    err = pWindowObj->push(static_cast<Surface> (surface), (NEXUS_Rect *) pUpdateRect, false);
#else
    err = NEXUS_SurfaceClient_PushSurface((NEXUS_SurfaceClient*)display, surface, (NEXUS_Rect *) pUpdateRect, false);
#endif

    return (err == NEXUS_SUCCESS) ? DFB_PLATFORM_OK : DFB_PLATFORM_FAILURE;
}

DFB_PlatformResult
DFB_Platform_SurfaceClient_SetSurface(DFB_PlatformNexusHandle display, NEXUS_SurfaceHandle surface)
{
    NEXUS_Error err;

#if BCMNEXUS_ASAL_SUPPORT
    BSTD_UNUSED(display);
    err = pWindowObj->set(static_cast<Surface> (surface));
#else
    err = NEXUS_SurfaceClient_SetSurface((NEXUS_SurfaceClient*)display, surface);
#endif

    return (err == NEXUS_SUCCESS) ? DFB_PLATFORM_OK : DFB_PLATFORM_FAILURE;
}

DFB_PlatformResult
DFB_Platform_SurfaceClient_UpdateSurface(
    DFB_PlatformNexusHandle display,
    const DFB_PlatformRect *pUpdateRect)
{
    NEXUS_Error err;

#if BCMNEXUS_ASAL_SUPPORT
    BSTD_UNUSED(display);
    err = pWindowObj->update((NEXUS_Rect *) pUpdateRect);
#else
    err = NEXUS_SurfaceClient_UpdateSurface((NEXUS_SurfaceClient*)display, (NEXUS_Rect *) pUpdateRect);
#endif

    return (err == NEXUS_SUCCESS) ? DFB_PLATFORM_OK : DFB_PLATFORM_FAILURE;
}

DFB_PlatformResult
DFB_Platform_SurfaceClient_PublishSurface(DFB_PlatformNexusHandle display)
{
    NEXUS_Error err;

#if BCMNEXUS_ASAL_SUPPORT
    /* Trellis ASAL::Window does not support publish() API.*/
    err = NEXUS_NOT_SUPPORTED;
#else
    err = NEXUS_SurfaceClient_PublishSurface((NEXUS_SurfaceClient*)display);
#endif

    return (err == NEXUS_SUCCESS) ? DFB_PLATFORM_OK : DFB_PLATFORM_FAILURE;
}

void
DFB_Platform_SurfaceClient_Clear(DFB_PlatformNexusHandle display)
{
#if BCMNEXUS_ASAL_SUPPORT
    BSTD_UNUSED(display);
    pWindowObj->clear();
#else
    NEXUS_SurfaceClient_Clear((NEXUS_SurfaceClient*)display);
#endif
}

DFB_PlatformNexusHandle
DFB_Platform_SurfaceClient_Acquire(int clientId, DFB_Platform_SlaveType slaveType)
{
#if BCMNEXUS_ASAL_SUPPORT

    DFB_PlatformNexusHandle pHandle = NULL;

#if BCMNEXUS_NXCLIENT_SUPPORT
    if (slaveType == DFB_Platform_SlaveType_NxClient)
    {

        pHandle = NEXUS_SurfaceClient_Acquire(clientId);

        if(pWindowObj == NULL)
        {
            pWindowObj = new Window(static_cast<ClientHandle> (pHandle), clientId);
        }

    }
    else
#endif
    if (slaveType == DFB_Platform_SlaveType_Trellis)
    {
        BDBG_MSG(("%s: Acquiring surface with clientId id=%d", __FUNCTION__, clientId));
        /* Use clientId provided by the Trellis server, INT_MAX is used to indicate the default configuration. */
        if(clientId != INT_MAX)
        {
           pHandle = NEXUS_SurfaceClient_Acquire(clientId);

           if(pHandle)
           {
               if(!pWindowObj)
               {
                   pWindowObj = new Window(static_cast<ClientHandle> (pHandle), clientId);
               }
           }
           else
           {
               BDBG_ERR(("%s: Cannot open surface compositor with given clientId %d!", __FUNCTION__, clientId));
           }
        }

    }
    else if(pWindowObj == NULL)
    {
        pWindowObj = new Window(NULL, clientId);
    }
    return static_cast<DFB_PlatformNexusHandle> (pWindowObj->getClientHandle());
#else
    BSTD_UNUSED(slaveType);
    return NEXUS_SurfaceClient_Acquire(clientId);
#endif
}

void
DFB_Platform_SurfaceClient_Release(DFB_PlatformNexusHandle handle)
{
#if BCMNEXUS_ASAL_SUPPORT
    BSTD_UNUSED(handle);
    if (pWindowObj != NULL)
        delete pWindowObj;
    pWindowObj = NULL;
#else
    NEXUS_SurfaceClient_Release((NEXUS_SurfaceClient*)handle);
#endif
}

#ifdef __cplusplus
} // extern "C"
#endif
