/******************************************************************************
 *  Copyright (c) 2017 RDK Management, LLC. All rights reserved.
 *  Copyright (C) 2017 Broadcom. The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
 *
 *  This program is the proprietary software of Broadcom and/or its licensors,
 *  and may only be used, duplicated, modified or distributed pursuant to the terms and
 *  conditions of a separate, written license agreement executed between you and Broadcom
 *  (an "Authorized License").  Except as set forth in an Authorized License, Broadcom grants
 *  no license (express or implied), right to use, or waiver of any kind with respect to the
 *  Software, and Broadcom expressly reserves all rights in and to the Software and all
 *  intellectual property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU
 *  HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY
 *  NOTIFY BROADCOM AND DISCONTINUE ALL USE OF THE SOFTWARE.
 *
 *  Except as expressly set forth in the Authorized License,
 *
 *  1.     This program, including its structure, sequence and organization, constitutes the valuable trade
 *  secrets of Broadcom, and you shall use all reasonable efforts to protect the confidentiality thereof,
 *  and to use this information only in connection with your use of Broadcom integrated circuit products.
 *
 *  2.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
 *  AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
 *  WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH RESPECT TO
 *  THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND ALL IMPLIED WARRANTIES
 *  OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE,
 *  LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION
 *  OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF
 *  USE OR PERFORMANCE OF THE SOFTWARE.
 *
 *  3.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR ITS
 *  LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL, INDIRECT, OR
 *  EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY RELATING TO YOUR
 *  USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM HAS BEEN ADVISED OF
 *  THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT
 *  ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE
 *  LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF
 *  ANY LIMITED REMEDY.
 ******************************************************************************/

#include "dvrmanager-socif.h"
#include <memory.h>
#include "rdk_debug.h"

#if USE_SYSRES_MLT
#include "rpl_malloc.h"
#include "rpl_new.h"
#endif


//#ifdef NEXUS_HAS_SECURITY
#if defined(NEXUS_HAS_SECURITY) && (NEXUS_PLATFORM!=97125)

#define USE_OTP_KEY 1
// for new platforms, use VKL alloc
#if (NEXUS_PLATFORM_VERSION_MAJOR >= 16) 
#define ALLOC_VKL 1
#endif
#include "nexus_dma.h"
#include "nexus_memory.h"
#include "nexus_security.h"
#include "nexus_keyladder.h"
#ifdef RDK_USE_NXCLIENT
#include "nexus_platform_client.h"
#endif

#define INT_FATAL(FORMAT, ...)      RDK_LOG(RDK_LOG_FATAL, "LOG.RDK.DVR", FORMAT "\n", __VA_ARGS__)
#define INT_ERROR(FORMAT, ...)      RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.DVR", FORMAT "\n", __VA_ARGS__)
#define INT_WARNING(FORMAT, ...)    RDK_LOG(RDK_LOG_WARN, "LOG.RDK.DVR", FORMAT "\n",  __VA_ARGS__)
#define INT_INFO(FORMAT, ...)       RDK_LOG(RDK_LOG_INFO, "LOG.RDK.DVR", FORMAT "\n",  __VA_ARGS__)
#define INT_DEBUG(FORMAT, ...)      RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.DVR", FORMAT "\n", __VA_ARGS__)
#define INT_TRACE1(FORMAT, ...)     RDK_LOG(RDK_LOG_TRACE1, "LOG.RDK.DVR", FORMAT "\n",  __VA_ARGS__)
#define INT_TRACE2(FORMAT, ...)     RDK_LOG(RDK_LOG_TRACE2, "LOG.RDK.DVR", FORMAT "\n",  __VA_ARGS__)
#define INT_TRACE3(FORMAT, ...)     RDK_LOG(RDK_LOG_TRACE3, "LOG.RDK.DVR", FORMAT "\n",  __VA_ARGS__)
#define INT_TRACE4(FORMAT, ...)     RDK_LOG(RDK_LOG_TRACE4, "LOG.RDK.DVR", FORMAT "\n",  __VA_ARGS__)
#define INT_TRACE5(FORMAT, ...)     RDK_LOG(RDK_LOG_TRACE5, "LOG.RDK.DVR", FORMAT "\n",  __VA_ARGS__)

#define FATAL(...)                  INT_FATAL(__VA_ARGS__, "")
#define ERROR(...)                  INT_ERROR(__VA_ARGS__, "")
#define WARNING(...)                INT_WARNING(__VA_ARGS__, "")
#define INFO(...)                   INT_INFO(__VA_ARGS__, "")
#define DEBUG(...)                  INT_DEBUG(__VA_ARGS__, "")
#define TRACE1(...)                 INT_TRACE1(__VA_ARGS__, "")
#define TRACE2(...)                 INT_TRACE2(__VA_ARGS__, "")
#define TRACE3(...)                 INT_TRACE3(__VA_ARGS__, "")
#define TRACE4(...)                 INT_TRACE4(__VA_ARGS__, "")
#define TRACE5(...)                 INT_TRACE5(__VA_ARGS__, "")

extern "C" void BKNI_Delay(unsigned int microsec);
#if NEXUS_PLATFORM_VERSION_MAJOR < 19
extern "C" BERR_Code BKNI_Sleep(unsigned int millisec);
#endif

NEXUS_DmaHandle dma = NULL;
NEXUS_KeySlotHandle encKeyHandle = NULL;
NEXUS_KeySlotHandle decKeyHandle = NULL;
NEXUS_KeySlotHandle encKeyHandle_192 = NULL;
NEXUS_KeySlotHandle decKeyHandle_192 = NULL;
// SOC specific crypto state data is stored in DVRCryptoState
typedef struct _DVRCryptoState
{
  unsigned int hEncrypt;
  unsigned int hDecrypt;
} DVRCryptoState;

static DVRCryptoState cryptoState;

#ifdef USE_OTP_KEY
static const uint8_t ucProcInForKey3[16] = { 0x11, 0x11, 0x22, 0x22, 0x12, 0x34, 0x56, 0x78, 0x98, 0x76, 0x54, 0x32, 0x09, 0x23, 0x45, 0x56 };
static const uint8_t ucProcInForKey4[16] = { 0x2e, 0xf6, 0xb6, 0xcc, 0x5b, 0x6c, 0x86, 0xf7, 0x92, 0xa2, 0x48, 0x70, 0xac, 0xd9, 0x46, 0x73 };
#else
static const uint8_t keys[16] =  { 0xbe, 0xf9, 0xb0, 0x67,0x13, 0xb8, 0xbc, 0x87, 0xbc, 0xfb, 0xb2, 0x69,0x13, 0xba, 0xbe, 0x8b };
static const uint8_t iv[16] = { 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xAA, 0xBB, 0xCC, 0xDD, 0xEE, 0xFF };
#endif

NEXUS_SecurityAlgorithmSettings algConfig;
NEXUS_SecurityClearKey key;
NEXUS_SecurityKeySlotSettings keySettings;

#define BUFFER_SIZE   (192*1024)
#define BUFFER_COUNT 10

struct crypto_t{
    static pthread_mutex_t mutex;

    uint8_t *buffer[BUFFER_COUNT];
    bool buffer_allocated[BUFFER_COUNT];

    //Get block from circular buffer, return buffer size could be smaller than requested.
    uint32_t get_buffer(uint32_t length, uint8_t **p /*out*/);  
    //Release buffer
    void put_buffer(uint8_t *p);

    crypto_t();
    ~crypto_t();
}; 

pthread_mutex_t crypto_t::mutex = PTHREAD_MUTEX_INITIALIZER;

crypto_t::crypto_t()
{
    NEXUS_MemoryAllocationSettings memSettings;
    int i;
    uint8_t *buf;

#ifdef RDK_USE_NXCLIENT
    NEXUS_ClientConfiguration platformConfig;
    NEXUS_Platform_GetClientConfiguration(&platformConfig);

    NEXUS_Memory_GetDefaultAllocationSettings(&memSettings);
    memSettings.heap = platformConfig.heap[1]; /* protected and un-prot */
#else    
    memSettings.heap = NULL;
#endif
    for (i=0; i<BUFFER_COUNT; i++) {
        buffer[i]=NULL;
        buffer_allocated[i]=true;
    }
    NEXUS_Memory_Allocate(BUFFER_SIZE*BUFFER_COUNT, &memSettings, (void **)&buf);
    if (buf != NULL) {
        for (i=0; i<BUFFER_COUNT; i++) {
            buffer[i]=buf+(BUFFER_SIZE*i);
            buffer_allocated[i]=false;
        }
    }
}

crypto_t::~crypto_t()
{
    int i;
    if (buffer[0]) {
        NEXUS_Memory_Free(buffer[0]);
        for (i=0; i<BUFFER_COUNT; i++) {
            buffer[i]=NULL;
            buffer_allocated[i]=true;
        }
    }
}

uint32_t crypto_t::get_buffer(uint32_t length,uint8_t **p)
{
    uint32_t ret = 0;
    *p = NULL;
    int i;
    pthread_mutex_lock( &mutex );

    for (i=0;i<BUFFER_COUNT;i++) {
        if (!buffer_allocated[i]) {
            buffer_allocated[i]=true;
            *p = buffer[i];

            if (length < BUFFER_SIZE) 
                ret = length;
            else
                ret = BUFFER_SIZE;

            break;
        }
    }
    
    pthread_mutex_unlock( &mutex );

    return ret;
}

void crypto_t::put_buffer(uint8_t *p)
{
    int i;
    pthread_mutex_lock( &mutex );

    for (i=0;i<BUFFER_COUNT;i++) {
        if (buffer[i] == p) {
            buffer_allocated[i]=false;
            break;
        }
    }

    pthread_mutex_unlock( &mutex );
}


#ifdef USE_OTP_KEY
static void __Configure_Keyladder(NEXUS_KeySlotHandle keyHandle)
{
    NEXUS_SecurityEncryptedSessionKey encryptedSessionkey;
    NEXUS_SecurityEncryptedControlWord encryptedCW;
#if ALLOC_VKL
    NEXUS_SecurityVKLSettings vklSettings;
    NEXUS_VirtualKeyLadderInfo vklInfo;
    NEXUS_VirtualKeyLadderHandle vklHandle = NULL;
#endif
    
    NEXUS_Security_GetDefaultSessionKeySettings(&encryptedSessionkey);
    NEXUS_Security_GetDefaultControlWordSettings(&encryptedCW);

    /* Load session key - key3 */
    encryptedSessionkey.keyladderID         = NEXUS_SecurityKeyladderID_eA;
    encryptedSessionkey.keyladderType       = NEXUS_SecurityKeyladderType_e3Des;
    encryptedSessionkey.swizzleType         = NEXUS_SecuritySwizzleType_eNone;
    encryptedSessionkey.dest = NEXUS_SecurityAlgorithmConfigDestination_eMem2Mem;

    /* -------- */
    encryptedSessionkey.keyGenCmdID         = NEXUS_SecurityKeyGenCmdID_eKeyGen;
    encryptedSessionkey.sessionKeyOp        = NEXUS_SecuritySessionKeyOp_eNoProcess;
    encryptedSessionkey.bASKMMode           = false;
#if (BCHP_CHIP==74371)
    encryptedSessionkey.rootKeySrc          = NEXUS_SecurityRootKeySrc_eOtpKeyB;
#else
    encryptedSessionkey.rootKeySrc          = NEXUS_SecurityRootKeySrc_eOtpKeyA;
#endif
    encryptedSessionkey.bSwapAESKey         = false;
    encryptedSessionkey.keyDestIVType       = NEXUS_SecurityKeyIVType_eNoIV;

    /* -------- */
    encryptedSessionkey.bRouteKey           = false;
    encryptedSessionkey.operation           = NEXUS_SecurityOperation_eDecrypt;
    encryptedSessionkey.operationKey2       = NEXUS_SecurityOperation_eEncrypt;

    /* ++++++++ */
    encryptedSessionkey.custSubMode        = NEXUS_SecurityCustomerSubMode_eGeneric_CP_128_4;
#if ALLOC_VKL
    NEXUS_Security_GetDefaultVKLSettings ( &vklSettings );
                
#if (BCHP_CHIP==7429 || BCHP_CHIP==7425 || BCHP_CHIP==7435 || BCHP_CHIP== 7125 || BCHP_CHIP==74371)
    vklSettings.custSubMode = NEXUS_SecurityCustomerSubMode_eGeneric_CP_128_4;
#endif
    vklHandle = NEXUS_Security_AllocateVKL( &vklSettings );
                
    if ( !vklHandle )
    {
        ERROR ( "\nAllocate VKL failed \n" );                
        return;    
    }
    memset(&vklInfo, 0, sizeof(vklInfo));
    NEXUS_Security_GetVKLInfo ( vklHandle, &vklInfo );
    encryptedSessionkey.virtualKeyLadderID = vklInfo.vkl;    
#else
    encryptedSessionkey.virtualKeyLadderID = NEXUS_SecurityVirtualKeyladderID_eVKL4;
#endif
    encryptedSessionkey.keyMode            = NEXUS_SecurityKeyMode_eRegular;
    /* ++++++++ */

    memcpy(encryptedSessionkey.keyData, ucProcInForKey3, sizeof(ucProcInForKey3));

    encryptedSessionkey.keyEntryType        = NEXUS_SecurityKeyType_eOdd;
    if (NEXUS_Security_GenerateSessionKey(keyHandle, &encryptedSessionkey) !=0)
    {
        ERROR("%s: Loading session key failed\n", __FUNCTION__);
    }

    /* Load CW - key4 --- routed out */
    encryptedCW.keyladderID = NEXUS_SecurityKeyladderID_eA;
    encryptedCW.keyladderType = NEXUS_SecurityKeyladderType_e3Des;
    encryptedCW.keySize = 16;

    /* ++++++++ */
    encryptedCW.custSubMode        = NEXUS_SecurityCustomerSubMode_eGeneric_CP_128_4;
#if ALLOC_VKL
    encryptedCW.virtualKeyLadderID = vklInfo.vkl;    
#else
    encryptedCW.virtualKeyLadderID = NEXUS_SecurityVirtualKeyladderID_eVKL4;
#endif
    encryptedCW.keyMode            = NEXUS_SecurityKeyMode_eRegular;
    /* ++++++++ */

    /*encryptedCW.pKeyData = ucProcInKey4;*/
    memcpy(encryptedCW.keyData, ucProcInForKey4, encryptedCW.keySize);
    encryptedCW.operation = NEXUS_SecurityOperation_eDecrypt;
    encryptedCW.bRouteKey = true;
    encryptedCW.dest = NEXUS_SecurityAlgorithmConfigDestination_eMem2Mem;
    encryptedCW.keyDestIVType = NEXUS_SecurityKeyIVType_eNoIV;
    encryptedCW.keyGenCmdID   = NEXUS_SecurityKeyGenCmdID_eKeyGen;
    encryptedCW.bSwapAESKey   = false;

    encryptedCW.keyEntryType = NEXUS_SecurityKeyType_eOdd;
    if (NEXUS_Security_GenerateControlWord(keyHandle, &encryptedCW))
    {
        ERROR("%s: Loading Control Word failed\n", __FUNCTION__);
    }
#if ALLOC_VKL
    if (vklHandle) NEXUS_Security_FreeVKL(vklHandle);
#endif    
}
#endif    

bool dvrcryptoifc::initCrypto()
{
    bool result= false;
    int rc;

    if ( !dma) 
    { 
#if (NEXUS_HAS_XPT_DMA == 1)
#if defined(NEXUS_DMA_ID_RESERVED_FOR_TSB)
        dma = NEXUS_Dma_Open(NEXUS_DMA_ID_RESERVED_FOR_TSB, NULL);
#else
        dma = NEXUS_Dma_Open(NEXUS_ANY_ID, NULL);
#endif
#else
        dma = NEXUS_Dma_Open(0, NULL); 
#endif
    }


    //ERROR("%s: dma:%p\n", __FUNCTION__, dma);
    cryptoState.hEncrypt = 0;
    cryptoState.hDecrypt = 0;

    if ( encKeyHandle == NULL ) {
        // Set up Keyslot
        NEXUS_Security_GetDefaultKeySlotSettings(&keySettings);
        keySettings.keySlotEngine = NEXUS_SecurityEngine_eM2m;
        encKeyHandle = NEXUS_Security_AllocateKeySlot(&keySettings);

        if (0 != encKeyHandle)
        {
            // Configure security algorithm
            NEXUS_Security_GetDefaultAlgorithmSettings(&algConfig);
            algConfig.operation = NEXUS_SecurityOperation_eEncrypt;
            algConfig.algorithm = NEXUS_SecurityAlgorithm_e3DesAba;
            algConfig.algorithmVar = NEXUS_SecurityAlgorithmVariant_eEcb;
            algConfig.terminationMode = NEXUS_SecurityTerminationMode_eClear;
            algConfig.ivMode        = NEXUS_SecurityIVMode_eRegular;
            algConfig.solitarySelect = NEXUS_SecuritySolitarySelect_eClear;
            algConfig.caVendorID     = 0x1234;
            algConfig.askmModuleID   = NEXUS_SecurityAskmModuleID_eModuleID_4;
            algConfig.otpId          = NEXUS_SecurityOtpId_eOtpVal;
            algConfig.key2Select     = NEXUS_SecurityKey2Select_eReserved1;
            algConfig.dest           = NEXUS_SecurityAlgorithmConfigDestination_eMem2Mem;
            algConfig.enableTimestamps = FALSE;
            
            NEXUS_Security_ConfigAlgorithm(encKeyHandle, &algConfig);

            // Load recpump key
#ifndef USE_OTP_KEY
            NEXUS_Security_GetDefaultClearKey(&key);
            key.keyEntryType = NEXUS_SecurityKeyType_eOdd;
            key.keySize = sizeof(keys);
            memcpy(key.keyData, keys, 16);
            if (NEXUS_Security_LoadClearKey(encKeyHandle, &key) != 0)
            {
                ERROR("%s: Failed to load recpump clear key\n", __FUNCTION__);
            }
#else
            __Configure_Keyladder(encKeyHandle);
#endif
        }
    }

    if ( encKeyHandle_192 == NULL ) {
        // Set up Keyslot
        NEXUS_Security_GetDefaultKeySlotSettings(&keySettings);
        keySettings.keySlotEngine = NEXUS_SecurityEngine_eM2m;
        encKeyHandle_192 = NEXUS_Security_AllocateKeySlot(&keySettings);

        if (0 != encKeyHandle_192)
        {
            // Configure security algorithm
            NEXUS_Security_GetDefaultAlgorithmSettings(&algConfig);
            algConfig.operation = NEXUS_SecurityOperation_eEncrypt;
            algConfig.algorithm = NEXUS_SecurityAlgorithm_e3DesAba;
            algConfig.algorithmVar = NEXUS_SecurityAlgorithmVariant_eEcb;
            algConfig.terminationMode = NEXUS_SecurityTerminationMode_eClear;
            algConfig.ivMode        = NEXUS_SecurityIVMode_eRegular;
            algConfig.solitarySelect = NEXUS_SecuritySolitarySelect_eClear;
            algConfig.caVendorID     = 0x1234;
            algConfig.askmModuleID   = NEXUS_SecurityAskmModuleID_eModuleID_4;
            algConfig.otpId          = NEXUS_SecurityOtpId_eOtpVal;
            algConfig.key2Select     = NEXUS_SecurityKey2Select_eReserved1;
            algConfig.dest           = NEXUS_SecurityAlgorithmConfigDestination_eMem2Mem;
            algConfig.enableTimestamps = TRUE;
            
            NEXUS_Security_ConfigAlgorithm(encKeyHandle_192, &algConfig);

            // Load recpump key
#ifndef USE_OTP_KEY
            NEXUS_Security_GetDefaultClearKey(&key);
            key.keyEntryType = NEXUS_SecurityKeyType_eOdd;
            key.keySize = sizeof(keys);
            memcpy(key.keyData, keys, 16);
            if (NEXUS_Security_LoadClearKey(encKeyHandle_192, &key) != 0)
            {
                ERROR("%s: Failed to load recpump clear key\n", __FUNCTION__);
            }
#else
            __Configure_Keyladder(encKeyHandle_192);
#endif
        }
    }

    if ( cryptoState.hEncrypt == 0 ) {
        cryptoState.hEncrypt = (unsigned int) new crypto_t;
    }

    if ( decKeyHandle == NULL ) {
        // Set up Keyslot
        NEXUS_Security_GetDefaultKeySlotSettings(&keySettings);
        keySettings.keySlotEngine = NEXUS_SecurityEngine_eM2m;
        decKeyHandle = NEXUS_Security_AllocateKeySlot(&keySettings);

        if (0 != decKeyHandle)
        {
            // Configure security algorithm
            NEXUS_Security_GetDefaultAlgorithmSettings(&algConfig);
            algConfig.operation = NEXUS_SecurityOperation_eDecrypt;
            algConfig.algorithm = NEXUS_SecurityAlgorithm_e3DesAba;
            algConfig.algorithmVar = NEXUS_SecurityAlgorithmVariant_eEcb;
            algConfig.terminationMode = NEXUS_SecurityTerminationMode_eClear;
            algConfig.ivMode        = NEXUS_SecurityIVMode_eRegular;
            algConfig.solitarySelect = NEXUS_SecuritySolitarySelect_eClear;
            algConfig.caVendorID     = 0x1234;
            algConfig.askmModuleID   = NEXUS_SecurityAskmModuleID_eModuleID_4;
            algConfig.otpId          = NEXUS_SecurityOtpId_eOtpVal;
            algConfig.key2Select     = NEXUS_SecurityKey2Select_eReserved1;
            algConfig.dest           = NEXUS_SecurityAlgorithmConfigDestination_eMem2Mem;
            algConfig.enableTimestamps = FALSE;
            NEXUS_Security_ConfigAlgorithm(decKeyHandle, &algConfig);

            // Load playpump key
#ifndef USE_OTP_KEY            
            NEXUS_Security_GetDefaultClearKey(&key);
            key.keyEntryType = NEXUS_SecurityKeyType_eOdd;
            key.keySize = sizeof(keys);
            memcpy(key.keyData, keys, 16);
            if (NEXUS_Security_LoadClearKey(decKeyHandle, &key) != 0)
            {
                ERROR("%s: Failed to load playpump clear key\n", __FUNCTION__);
            }
#else
            __Configure_Keyladder(decKeyHandle);
#endif
        }
    }


    if ( decKeyHandle_192 == NULL ) {
        // Set up Keyslot
        NEXUS_Security_GetDefaultKeySlotSettings(&keySettings);
        keySettings.keySlotEngine = NEXUS_SecurityEngine_eM2m;
        decKeyHandle_192 = NEXUS_Security_AllocateKeySlot(&keySettings);

        if (0 != decKeyHandle_192)
        {
            // Configure security algorithm
            NEXUS_Security_GetDefaultAlgorithmSettings(&algConfig);
            algConfig.operation = NEXUS_SecurityOperation_eDecrypt;
            algConfig.algorithm = NEXUS_SecurityAlgorithm_e3DesAba;
            algConfig.algorithmVar = NEXUS_SecurityAlgorithmVariant_eEcb;
            algConfig.terminationMode = NEXUS_SecurityTerminationMode_eClear;
            algConfig.ivMode        = NEXUS_SecurityIVMode_eRegular;
            algConfig.solitarySelect = NEXUS_SecuritySolitarySelect_eClear;
            algConfig.caVendorID     = 0x1234;
            algConfig.askmModuleID   = NEXUS_SecurityAskmModuleID_eModuleID_4;
            algConfig.otpId          = NEXUS_SecurityOtpId_eOtpVal;
            algConfig.key2Select     = NEXUS_SecurityKey2Select_eReserved1;
            algConfig.dest           = NEXUS_SecurityAlgorithmConfigDestination_eMem2Mem;
            algConfig.enableTimestamps = TRUE;
            NEXUS_Security_ConfigAlgorithm(decKeyHandle_192, &algConfig);

            // Load playpump key
#ifndef USE_OTP_KEY            
            NEXUS_Security_GetDefaultClearKey(&key);
            key.keyEntryType = NEXUS_SecurityKeyType_eOdd;
            key.keySize = sizeof(keys);
            memcpy(key.keyData, keys, 16);
            if (NEXUS_Security_LoadClearKey(decKeyHandle_192, &key) != 0)
            {
                ERROR("%s: Failed to load playpump clear key\n", __FUNCTION__);
            }
#else
            __Configure_Keyladder(decKeyHandle_192);
#endif
        }
    }

    if ( cryptoState.hDecrypt == 0 ) {
        cryptoState.hDecrypt = (unsigned int) new crypto_t;
    }

    return true;
}

void dvrcryptoifc::termCrypto()
{
	if ( cryptoState.hEncrypt ) {
        //NEXUS_Memory_Free( (void *)m_cryptoState.hEncrypt);
        delete (crypto_t *)cryptoState.hEncrypt;
		cryptoState.hEncrypt = 0;
	}
  if ( cryptoState.hDecrypt ) {
        //NEXUS_Memory_Free( (void *) m_cryptoState.hDecrypt);
        delete (crypto_t *)cryptoState.hDecrypt;
        cryptoState.hDecrypt= 0;
	}
}

static void dma_crypto_engine(void *pSrc, int length, bool isEnc, bool isTTS)
{
    NEXUS_DmaJobSettings jobSettings;
    NEXUS_DmaJobHandle dmaJob;
    NEXUS_DmaJobBlockSettings blockSettings;
    NEXUS_DmaJobStatus jobStatus;
    int i = 0;

    if((isTTS ? (length % 192) : (length % 188)) != 0)
    {
        ERROR("%s: pacakge [length = %d] is not multiple of  %d \n",__FUNCTION__, length, (isTTS ? 192 : 188));
        return;
    }

    NEXUS_DmaJob_GetDefaultSettings(&jobSettings);
    jobSettings.numBlocks                   = 1;
    if ( isTTS ) {
        jobSettings.keySlot                     = isEnc ? encKeyHandle_192 : decKeyHandle_192;
#if (NEXUS_HAS_XPT_DMA == 1)
        jobSettings.timestampType = NEXUS_TransportTimestampType_eMod300;
#endif
    } else {
        jobSettings.keySlot                     = isEnc ? encKeyHandle : decKeyHandle;
    }
    jobSettings.dataFormat                  = NEXUS_DmaDataFormat_eMpeg;
    jobSettings.completionCallback.callback = NULL;

    dmaJob = NEXUS_DmaJob_Create(dma, &jobSettings);

    NEXUS_DmaJob_GetDefaultBlockSettings(&blockSettings);
    blockSettings.pSrcAddr                  = pSrc;
    blockSettings.pDestAddr                 = pSrc;
    blockSettings.blockSize                 = length;
    blockSettings.resetCrypto               = true;
    blockSettings.scatterGatherCryptoStart  = true;
    blockSettings.scatterGatherCryptoEnd    = true;
    blockSettings.cached                    = true;

    NEXUS_DmaJob_ProcessBlocks(dmaJob, &blockSettings, 1);
    for(;;)
    {
        NEXUS_DmaJob_GetStatus(dmaJob, &jobStatus);

        if(jobStatus.currentState == NEXUS_DmaJobState_eComplete )
        {
            break;
        }
        if ( length < 1500 ) {        
            BKNI_Delay(1);
            i += 1;
        } else {
            BKNI_Sleep(1);
            i += 1000;
        }
        if ( i > 10000000 ) {
            ERROR("%s: DMA job time out after 10s: (length = %d) \n",__FUNCTION__, length);
            break;
        }
    }
    NEXUS_DmaJob_Destroy(dmaJob);
    
    if ( i > 10000000 ) {
        if (dma) 
        { 
            ERROR("%s: restart DMA \n",__FUNCTION__);        	
            NEXUS_Dma_Close(dma);
#if (NEXUS_HAS_XPT_DMA == 1)
#if defined(NEXUS_DMA_ID_RESERVED_FOR_TSB)
            dma = NEXUS_Dma_Open(NEXUS_DMA_ID_RESERVED_FOR_TSB, NULL);
#else
            dma = NEXUS_Dma_Open(NEXUS_ANY_ID, NULL);
#endif
#else
            dma = NEXUS_Dma_Open(0, NULL); 
#endif
        }
    }    
    return;
}

void dvrcryptoifc::decryptPackets( unsigned char *packets, int packetSize, int headerSize,int length,unsigned char *physicalAddress)
{
    crypto_t *p = (crypto_t *)cryptoState.hDecrypt;
    uint8_t *buf = NULL;
    uint32_t n = 0;

    do {
        while ( 1 ) {
            n = p->get_buffer(length, &buf );
            if ( n != 0 ) { break;}
            // No buffer available,wait here, unlikely
            BKNI_Sleep(1);
        };
        memcpy((void *)buf, packets, n);
        dma_crypto_engine((void *)buf, n, FALSE, (headerSize==16));
        memcpy(packets, buf, n);

        p->put_buffer(buf);
        packets += n;
        length -= n;
    } while ( length != 0 );

//    memcpy((void *)m_cryptoState.hDecrypt, packets, length);
//    dma_crypto_engine((void *)m_cryptoState.hDecrypt, length, FALSE, (headerSize==16));
//    memcpy(packets, (void *)m_cryptoState.hDecrypt, length);
}

void dvrcryptoifc::encryptPackets( unsigned char *packets, int packetSize, int headerSize,int length,unsigned char *physicalAddress)
{
    crypto_t *p = (crypto_t *)cryptoState.hEncrypt;
    uint8_t *buf = NULL;
    uint32_t n = 0;

    do {
        while ( 1 ) {
            n = p->get_buffer(length, &buf );
            if ( n != 0 ) { break;}
            // No buffer available,wait here, unlikely
            BKNI_Sleep(1);
        };
        memcpy((void *)buf, packets, n);
        dma_crypto_engine((void *)buf, n, TRUE, (headerSize==16));
        memcpy(packets, buf, n);

        p->put_buffer(buf);
        packets += n;
        length -= n;
    } while ( length != 0 );
//    memcpy((void *)m_cryptoState.hEncrypt, packets, length);
//    dma_crypto_engine((void *)m_cryptoState.hEncrypt, length, TRUE, (headerSize==16));
//    memcpy(packets, (void *)m_cryptoState.hEncrypt, length);
}

#else
bool dvrcryptoifc::initCrypto(){return TRUE;}
void dvrcryptoifc::termCrypto(){}
void dvrcryptoifc::decryptPackets( unsigned char *packets, int packetSize, int headerSize, int length,unsigned char*physicalAddress){}
void dvrcryptoifc::encryptPackets( unsigned char *packets, int packetSize, int headerSize, int length,unsigned char* physicalAddress){}
#endif
bool dvrcryptoifc::allocateDeviceBuffer( size_t size, void **virtualAddress, void **physicalAddress)
{
    bool result= false;
    void *buffer= 0;
    
    *physicalAddress= 0;
    buffer= malloc( size );
    if ( buffer )
    {
        *virtualAddress= buffer;
        result= true;
    }
    else
    {
        *virtualAddress= 0;
        result= false;
    }
    return result;
}

bool dvrcryptoifc::allocateDeviceBufferAligned( size_t size, int alignment, void **virtualAddress, void **physicalAddress )
{
    bool result= false;
    void *buffer= 0;
    
    *physicalAddress= 0;
    if(0 == posix_memalign(virtualAddress,alignment,size))
        return true;
    else
        return false;
}
void dvrcryptoifc::freeDeviceBuffer( void *virtualAddress )
{
       free( virtualAddress );
}
