/*******************************************************************************
 * Project Name : OCAP (OpenCable Application Platform)
 *
 * Developed by DVS Division, Samsung Electronics
 * Copyright (c) 2004 Samsung Electronics Inc.
 * All Rights Reserved
 *
 * This  software  may  not, in  whole  or in  part, be  copied, photocopied,
 * reproduced,  translated,  or  reduced to any  electronic  medium or  machine
 * readable form without prior written consent from Samsung Electronics Inc.
 * 
 * Project Description: This project is to implement a middleware solution that 
 * completely satisfies the OCAP specfication (version 1.0).
 *              
 *******************************************************************************
 *
 * Module       : Porting Interafce Header File
 *
 * File Name    : pl_nvmem.h
 * Date Created : 2009/07/03
 * Author       : 
 * Dept.        : Network InternetInfra Divsion, S/W R&D Group 
 *
 * File Description :
 *                        
 *******************************************************************************
 * Notes 
 *
 *                           
 *******************************************************************************
 * History
 * 
 *                              
 ******************************************************************************/
#ifndef _PL_NVMEM_H
#define  _PL_NVMEM_H

/* block info*/
#define E2P_ADDR_LOW         					  	0x0000
#define E2P_ADDR_HIGH          					0x7FFF
#define E2P_PHYSICAL_SIZE	       				(E2P_ADDR_HIGH-E2P_ADDR_LOW+1)

#define E2P_MW_LOW								0x0000
#define E2P_MW_HIGH							0x7EFF
#define E2P_MW_SIZE	       					(E2P_MW_HIGH-E2P_MW_LOW+1)

#define E2P_NAPP_LOW							0x7F00
#define E2P_NAPP_HIGH							0x7FFF
#define E2P_NAPP_SIZE	       					(E2P_NAPP_HIGH-E2P_NAPP_LOW+1)


#define E2P_BASE_OF_MW						(0x0000)
#define E2P_BASE_OF_MW_MAGIC					(0x0000)
#define E2P_BASE_OF_MW_KEY					(0x0008)
#define E2P_BASE_OF_MW_CERTI					(0x00C5)
#define E2P_BASE_OF_MW_PIN					(0x6500)
#define E2P_BASE_OF_MW_COM					(0x7500)
#define E2P_BASE_OF_MW_SH						(0x7E00)
#define E2P_BASE_OF_NAPP						(0x7F00)

#define E2P_SIZE_OF_MW							(0x7eFF+1)
#define E2P_SIZE_OF_MW_MAGIC					(E2P_BASE_OF_MW_KEY-E2P_BASE_OF_MW_MAGIC)
#define E2P_SIZE_OF_MW_KEY					(E2P_eCM_PCI_MAC_Addr_BASE-E2P_CP_DHSK_BASE)
#define E2P_SIZE_OF_MW_CERTI					(E2P_ParentContrPINs_BASE-E2P_eCM_PCI_MAC_Addr_BASE)
#define E2P_SIZE_OF_MW_PIN					(E2P_GRAPHIC_RESOLUTION_MODE_BASE-E2P_ParentContrPINs_BASE)
#define E2P_SIZE_OF_MW_COM					(E2P_LUHN_HOST_ID_BASE-E2P_GRAPHIC_RESOLUTION_MODE_BASE)
#define E2P_SIZE_OF_MW_SH						(E2P_NAPP_LOW-E2P_LUHN_HOST_ID_BASE)
#define E2P_SIZE_OF_NAPP						(0x0100)


/* Magic Code*/
#define E2P_MAGIC_CODE_BASE					(E2P_BASE_OF_MW_MAGIC)
#define E2P_MAGIC_CODE_SIZE					4										
#define E2P_MAGIC_CODE_INFO					"E2P_MAGIC_CODE"
                                                                                                                                                
#define E2P_VERSION_BASE						(E2P_MAGIC_CODE_BASE+E2P_MAGIC_CODE_SIZE)			
#define E2P_VERSION_SIZE						4									
#define E2P_VERSION_INFO						"E2P_VERSION"

/* Key*/
#define E2P_CP_DHSK_BASE						(E2P_BASE_OF_MW_KEY)									
#define E2P_CP_DHSK_SIZE						(128+8)									
#define E2P_CP_DHSK_INFO						"E2P_CP_DHSK"
                                                                                                                                                
#define E2P_CP_AUTHKEY_BASE					(E2P_CP_DHSK_BASE+E2P_CP_DHSK_SIZE)				
#define E2P_CP_AUTHKEY_SIZE					(32+8)										
#define E2P_CP_AUTHKEY_INFO					"E2P_CP_AUTHKEY"
                                                                                                                                                
#define E2P_CP_PODID_BASE						(E2P_CP_AUTHKEY_BASE+E2P_CP_AUTHKEY_SIZE)				
#define E2P_CP_PODID_SIZE						8									
#define E2P_CP_PODID_INFO						"E2P_CP_PODID"
                                                                                                                                                
#define E2P_CP_HOSTID_BASE						(E2P_CP_PODID_BASE+E2P_CP_PODID_SIZE)					
#define E2P_CP_HOSTID_SIZE						5									
#define E2P_CP_HOSTID_INFO						"E2P_CP_HOSTID"

/* Certi*/
#define E2P_eCM_PCI_MAC_Addr_BASE            		(E2P_BASE_OF_MW_CERTI)
#define E2P_eCM_PCI_MAC_Addr_SIZE            		6
#define E2P_eCM_PCI_MAC_Addr_INFO				"E2P_eCM_PCI_MAC_Addr"
                                                    
#define E2P_eCM_RF_MAC_Addr_BASE           		(E2P_eCM_PCI_MAC_Addr_BASE+E2P_eCM_PCI_MAC_Addr_SIZE)            
#define E2P_eCM_RF_MAC_Addr_SIZE              		6         
#define E2P_eCM_RF_MAC_Addr_INFO				"E2P_eCM_RF_MAC_Addr"             

#define E2P_eSTB_PCI_MAC_Addr_BASE           		(E2P_eCM_RF_MAC_Addr_BASE+E2P_eCM_RF_MAC_Addr_SIZE)
#define E2P_eSTB_PCI_MAC_Addr_SIZE          		6
#define E2P_eSTB_PCI_MAC_Addr_INFO			"E2P_eSTB_PCI_MAC_Addr"
        
#define E2P_eSTB_ETH_MAC_Addr_BASE           		(E2P_eSTB_PCI_MAC_Addr_BASE+E2P_eSTB_PCI_MAC_Addr_SIZE)
#define E2P_eSTB_ETH_MAC_Addr_SIZE          		6
#define E2P_eSTB_ETH_MAC_Addr_INFO			"E2P_eSTB_ETH_MAC_Addr"

#define E2P_CMCI_Eth_MAC_Addr_BASE           		(E2P_eSTB_ETH_MAC_Addr_BASE+E2P_eSTB_ETH_MAC_Addr_SIZE)
#define E2P_CMCI_Eth_MAC_Addr_SIZE          		6
#define E2P_CMCI_Eth_MAC_Addr_INFO			"E2P_CMCI_Eth_MAC_Addr"
        
#define E2P_USB_MAC_Addr_1_BASE           		(E2P_CMCI_Eth_MAC_Addr_BASE+E2P_CMCI_Eth_MAC_Addr_SIZE)
#define E2P_USB_MAC_Addr_1_SIZE          		6
#define E2P_USB_MAC_Addr_1_INFO			"E2P_USB_MAC_Addr_1"

#define E2P_USB_MAC_Addr_2_BASE           		(E2P_USB_MAC_Addr_1_BASE+E2P_USB_MAC_Addr_1_SIZE)
#define E2P_USB_MAC_Addr_2_SIZE          		6
#define E2P_USB_MAC_Addr_2_INFO			"E2P_USB_MAC_Addr_2"
        
#define E2P_eCM_CPE_MAC_Addr_BASE           		(E2P_USB_MAC_Addr_2_BASE+E2P_USB_MAC_Addr_2_SIZE)
#define E2P_eCM_CPE_MAC_Addr_SIZE          		6
#define E2P_eCM_CPE_MAC_Addr_INFO			"E2P_eCM_CPE_MAC_Addr"

#define E2P_eCM_17_UINCAST_Addr_BASE           		(E2P_eCM_CPE_MAC_Addr_BASE+E2P_eCM_CPE_MAC_Addr_SIZE)
#define E2P_eCM_17_UINCAST_Addr_SIZE          		6
#define E2P_eCM_17_UINCAST_Addr_INFO			"E2P_eCM_17_UINCAST_Addr"
        
#define E2P_eCM_18_DSG_MAC_Addr_BASE           		(E2P_eCM_17_UINCAST_Addr_BASE+E2P_eCM_17_UINCAST_Addr_SIZE)
#define E2P_eCM_18_DSG_MAC_Addr_SIZE          		6
#define E2P_eCM_18_DSG_MAC_Addr_INFO			"E2P_eCM_18_DSG_MAC_Addr"

#define E2P_eSTB_MOCA_MAC_Addr_BASE           		(E2P_eCM_18_DSG_MAC_Addr_BASE+E2P_eCM_18_DSG_MAC_Addr_SIZE)
#define E2P_eSTB_MOCA_MAC_Addr_SIZE          		6
#define E2P_eSTB_MOCA_MAC_Addr_INFO			"E2P_eSTB_MOCA_MAC_Addr"
   	
#define E2P_eSTB_MAC_RESEVED_B_BASE           		(E2P_eSTB_MOCA_MAC_Addr_BASE+E2P_eSTB_MOCA_MAC_Addr_SIZE)
#define E2P_eSTB_MAC_RESEVED_B_SIZE          		6
#define E2P_eSTB_MAC_RESEVED_B_INFO			"E2P_eSTB_MAC_RESEVED_B"

#define E2P_eSTB_MAC_RESEVED_C_BASE           		(E2P_eSTB_MAC_RESEVED_B_BASE+E2P_eSTB_MAC_RESEVED_B_SIZE)
#define E2P_eSTB_MAC_RESEVED_C_SIZE			6
#define E2P_eSTB_MAC_RESEVED_C_INFO			"E2P_eSTB_MAC_RESEVED_C"
        
#define E2P_eSTB_MAC_RESEVED_D_BASE           		(E2P_eSTB_MAC_RESEVED_C_BASE+E2P_eSTB_MAC_RESEVED_C_SIZE)
#define E2P_eSTB_MAC_RESEVED_D_SIZE          		6
#define E2P_eSTB_MAC_RESEVED_D_INFO			"E2P_eSTB_MAC_RESEVED_D"

#define E2P_eSTB_MAC_RESEVED_E_BASE           		(E2P_eSTB_MAC_RESEVED_D_BASE+E2P_eSTB_MAC_RESEVED_D_SIZE)
#define E2P_eSTB_MAC_RESEVED_E_SIZE          		6
#define E2P_eSTB_MAC_RESEVED_E_INFO			"E2P_eSTB_MAC_RESEVED_E"
        
#define E2P_HOST_CERT_STATUS_BASE           		(E2P_eSTB_MAC_RESEVED_E_BASE+E2P_eSTB_MAC_RESEVED_E_SIZE)
#define E2P_HOST_CERT_STATUS_SIZE          		6
#define E2P_HOST_CERT_STATUS_INFO			"E2P_HOST_CERT_STATUS"

#define E2P_HOST_ROOT_CERT_BASE           		(E2P_HOST_CERT_STATUS_BASE+E2P_HOST_CERT_STATUS_SIZE)
#define E2P_HOST_ROOT_CERT_SIZE			2056
#define E2P_HOST_ROOT_CERT_INFO			"E2P_HOST_ROOT_CERT"
        
#define E2P_HOST_MAN_CERT_BASE           		(E2P_HOST_ROOT_CERT_BASE+E2P_HOST_ROOT_CERT_SIZE)
#define E2P_HOST_MAN_CERT_SIZE			2056
#define E2P_HOST_MAN_CERT_INFO			"E2P_HOST_MAN_CERT"

#define E2P_HOST_DEV_CERT_BASE           		(E2P_HOST_MAN_CERT_BASE+E2P_HOST_MAN_CERT_SIZE)
#define E2P_HOST_DEV_CERT_SIZE			2056
#define E2P_HOST_DEV_CERT_INFO			"E2P_HOST_DEV_CERT"
        
#define E2P_HOST_P_KEY_BASE           		(E2P_HOST_DEV_CERT_BASE+E2P_HOST_DEV_CERT_SIZE)
#define E2P_HOST_P_KEY_SIZE			1032
#define E2P_HOST_P_KEY_INFO			"E2P_HOST_P_KEY"

#define E2P_HOST_DH_P_BASE           		(E2P_HOST_P_KEY_BASE+E2P_HOST_P_KEY_SIZE)
#define E2P_HOST_DH_P_SIZE			136
#define E2P_HOST_DH_P_INFO			"E2P_HOST_DH_P"
        
#define E2P_HOST_DH_G_BASE           		(E2P_HOST_DH_P_BASE+E2P_HOST_DH_P_SIZE)     
#define E2P_HOST_DH_G_SIZE    			136 
#define E2P_HOST_DH_G_INFO			"E2P_HOST_DH_G"     

#define E2P_eCM_CVC_Root_CERT_BASE           		(E2P_HOST_DH_G_BASE+E2P_HOST_DH_G_SIZE)
#define E2P_eCM_CVC_Root_CERT_SIZE		2056
#define E2P_eCM_CVC_Root_CERT_INFO			"E2P_eCM_CVC_Root_CERT"
        
#define E2P_eCM_CVC_MAN_CERT_BASE           		(E2P_eCM_CVC_Root_CERT_BASE+E2P_eCM_CVC_Root_CERT_SIZE)
#define E2P_eCM_CVC_MAN_CERT_SIZE			2056
#define E2P_eCM_CVC_MAN_CERT_INFO			"E2P_eCM_CVC_MAN_CERT"

#define E2P_eCM_DEV_CERT_BASE           		(E2P_eCM_CVC_MAN_CERT_BASE+E2P_eCM_CVC_MAN_CERT_SIZE	)
#define E2P_eCM_DEV_CERT_SIZE		2056
#define E2P_eCM_DEV_CERT_INFO			"E2P_eCM_DEV_CERT"
        
#define E2P_eCM_P_KEY_BASE           		(E2P_eCM_DEV_CERT_BASE+E2P_eCM_DEV_CERT_SIZE)
#define E2P_eCM_P_KEY_SIZE		1032
#define E2P_eCM_P_KEY_INFO			"E2P_eCM_P_KEY"

#define E2P_COMDWNLD_CLABS_CVC_ROOT_CA_BASE           		(E2P_eCM_P_KEY_BASE+E2P_eCM_P_KEY_SIZE)
#define E2P_COMDWNLD_CLABS_CVC_ROOT_CA_SIZE		2056
#define E2P_COMDWNLD_CLABS_CVC_ROOT_CA_INFO			"E2P_COMDWNLD_CLABS_CVC_ROOT_CA"
        
#define E2P_COMDWNLD_CLABS_CVC_CA_BASE            		(E2P_COMDWNLD_CLABS_CVC_ROOT_CA_BASE+E2P_COMDWNLD_CLABS_CVC_ROOT_CA_SIZE)
#define E2P_COMDWNLD_CLABS_CVC_CA_SIZE 		2056
#define E2P_COMDWNLD_CLABS_CVC_CA_INFO 			"E2P_COMDWNLD_CLABS_CVC_CA"

#define E2P_COMDWNLD_MAN_CVC_CA_BASE           		(E2P_COMDWNLD_CLABS_CVC_CA_BASE+E2P_COMDWNLD_CLABS_CVC_CA_SIZE)
#define E2P_COMDWNLD_MAN_CVC_CA_SIZE		2056
#define E2P_COMDWNLD_MAN_CVC_CA_INFO			"E2P_COMDWNLD_MAN_CVC_CA"
        
#define E2P_HDMI_HDCP_BASE           		(E2P_COMDWNLD_MAN_CVC_CA_BASE+E2P_COMDWNLD_MAN_CVC_CA_SIZE)
#define E2P_HDMI_HDCP_SIZE		1148
#define E2P_HDMI_HDCP_INFO			"E2P_HDMI_HDCP"

#define E2P_1394_DTCP_BASE           		(E2P_HDMI_HDCP_BASE+E2P_HDMI_HDCP_SIZE)
#define E2P_1394_DTCP_SIZE		2048
#define E2P_1394_DTCP_INFO			"E2P_1394_DTCP"

#define E2P_CERTI_CRC_BASE				(E2P_1394_DTCP_BASE+E2P_1394_DTCP_SIZE)
#define E2P_CERTI_CRC_SIZE				4
#define E2P_CERTI_CRC_INFO				"E2P_CERTI_CRC"
        
#define E2P_QAMTuner_Params_BASE   	(E2P_CERTI_CRC_BASE+E2P_CERTI_CRC_SIZE)		                                	
#define E2P_QAMTuner_Params_SIZE		(468)	                                	
#define E2P_QAMTuner_Params_INFO		"E2P_QAMTuner_Params"               	

#define E2P_STB_Manufact_Date_BASE				(E2P_QAMTuner_Params_BASE+E2P_QAMTuner_Params_SIZE)			                                 
#define E2P_STB_Manufact_Date_SIZE					(32)                                               
#define E2P_STB_Manufact_Date_INFO				"E2P_STB_Manufact_Date"  

#define E2P_eSTB_DevSerialNum_BASE			(E2P_STB_Manufact_Date_BASE+E2P_STB_Manufact_Date_SIZE)			                                 
#define E2P_eSTB_DevSerialNum_SIZE				(32)                                               
#define E2P_eSTB_DevSerialNum_INFO			"E2P_eSTB_DevSerialNum"  


#define E2P_eSTB_DHCP_43_BASE					(E2P_eSTB_DevSerialNum_BASE+E2P_eSTB_DevSerialNum_SIZE)
#define E2P_eSTB_DHCP_43_SIZE					(256)
#define E2P_eSTB_DHCP_43_INFO					"E2P_eSTB_DHCP_43"

#define E2P_eSTB_DHCP_60_BASE					(E2P_eSTB_DHCP_43_BASE+E2P_eSTB_DHCP_43_SIZE)
#define E2P_eSTB_DHCP_60_SIZE					(256)
#define E2P_eSTB_DHCP_60_INFO					"E2P_eSTB_DHCP_60"

#define E2P_SYS_ObjectID_BASE					(E2P_eSTB_DHCP_60_BASE+E2P_eSTB_DHCP_60_SIZE)
#define E2P_SYS_ObjectID_SIZE					(20)
#define E2P_SYS_ObjectID_INFO					"E2P_SYS_ObjectID "

/* PIN*/
#define E2P_ParentContrPINs_BASE   				(E2P_BASE_OF_MW_PIN)         	
#define E2P_ParentContrPINs_SIZE				(40)	                                	
#define E2P_ParentContrPINs_INFO				"E2P_ParentContrPINs"           

#define E2P_IPPV_PIN_BASE   						(E2P_ParentContrPINs_BASE+E2P_ParentContrPINs_SIZE)		                                	        
#define E2P_IPPV_PIN_SIZE						(1024)	                                	        
#define E2P_IPPV_PIN_INFO						"E2P_IPPV_PIN"               	        

#define E2P_IPPV_PURCHASEHISTORY_BASE   		(E2P_IPPV_PIN_BASE+E2P_IPPV_PIN_SIZE)
#define E2P_IPPV_PURCHASEHISTORY_SIZE			(2048)	                                	
#define E2P_IPPV_PURCHASEHISTORY_INFO		"E2P_IPPV_PURCHASEHISTORY"               	

/* Common*/
#define E2P_GRAPHIC_RESOLUTION_MODE_BASE	(E2P_BASE_OF_MW_COM)
#define E2P_GRAPHIC_RESOLUTION_MODE_SIZE	1											
#define E2P_GRAPHIC_RESOLUTION_MODE_INFO	"E2P_GRAPHIC_RESOLUTION_MODE"
                                                                                                                                                
#define E2P_DISPLAY_ASPECT_BASE				(E2P_GRAPHIC_RESOLUTION_MODE_BASE+E2P_GRAPHIC_RESOLUTION_MODE_SIZE)	
#define E2P_DISPLAY_ASPECT_SIZE				1										
#define E2P_DISPLAY_ASPECT_INFO				"E2P_DISPLAY_ASPECT"
                                                                                                                                                
#define E2P_VOLUME_LEVEL_BASE					(E2P_DISPLAY_ASPECT_BASE+E2P_DISPLAY_ASPECT_SIZE)				
#define E2P_VOLUME_LEVEL_SIZE					1									
#define E2P_VOLUME_LEVEL_INFO					"E2P_VOLUME_LEVEL"
                                                                                                                                                
#define E2P_DISPLAY_OUTPUT_FORMAT_BASE		(E2P_VOLUME_LEVEL_BASE+E2P_VOLUME_LEVEL_SIZE)							
#define E2P_DISPLAY_OUTPUT_FORMAT_SIZE		1											
#define E2P_DISPLAY_OUTPUT_FORMAT_INFO		"E2P_DISPLAY_OUTPUT_FORMAT"
                                                                                                                                                
#define E2P_DISPLAY_RESOLUTION_BASE			(E2P_DISPLAY_OUTPUT_FORMAT_BASE+E2P_DISPLAY_OUTPUT_FORMAT_SIZE)			
#define E2P_DISPLAY_RESOLUTION_SIZE			2											
#define E2P_DISPLAY_RESOLUTION_INFO			"E2P_DISPLAY_RESOLUTION"
                                                                                                                                                
#define E2P_SCAN_TYPE_BASE						(E2P_DISPLAY_RESOLUTION_BASE+E2P_DISPLAY_RESOLUTION_SIZE)		
#define E2P_SCAN_TYPE_SIZE						1									
#define E2P_SCAN_TYPE_INFO						"E2P_SCAN_TYPE"

#define E2P_EventTablesCFE_BASE   				(E2P_SCAN_TYPE_BASE+E2P_SCAN_TYPE_SIZE)		                                  	
#define E2P_EventTablesCFE_SIZE					(8)	                                  	
#define E2P_EventTablesCFE_INFO				"E2P_EventTablesCFE"                

#define E2P_LastCH_BASE  						(E2P_EventTablesCFE_BASE+E2P_EventTablesCFE_SIZE)		                                	        
#define E2P_LastCH_SIZE							(100)	                                	        
#define E2P_LastCH_INFO							"E2P_LastCH"               	        

#define E2P_docsDevNmAccessTable_BASE			(E2P_LastCH_BASE+E2P_LastCH_SIZE)			                             
#define E2P_docsDevNmAccessTable_SIZE			(1024)                                           
#define E2P_docsDevNmAccessTable_INFO			"E2P_docsDevNmAccessTable"                          

#define E2P_docsDevEvControlTable_BASE			(E2P_docsDevNmAccessTable_BASE+E2P_docsDevNmAccessTable_SIZE)			                            
#define E2P_docsDevEvControlTable_SIZE			(256)                                          
#define E2P_docsDevEvControlTable_INFO			"E2P_docsDevEvControlTable"                         

#define E2P_AnalogAudio_BASE					(E2P_docsDevEvControlTable_BASE+E2P_docsDevEvControlTable_SIZE)			                                 
#define E2P_AnalogAudio_SIZE					(1)                                               
#define E2P_AnalogAudio_INFO					"E2P_AnalogAudio"    

#define E2P_ClosedCaption_BASE					(E2P_AnalogAudio_BASE+E2P_AnalogAudio_SIZE)			                                 
#define E2P_ClosedCaption_SIZE					(1)                                               
#define E2P_ClosedCaption_INFO					"E2P_ClosedCaption"    

#define E2P_AnalogCC_BASE						(E2P_ClosedCaption_BASE+E2P_ClosedCaption_SIZE)			                                 
#define E2P_AnalogCC_SIZE						(1)                                               
#define E2P_AnalogCC_INFO						"E2P_AnalogCC"    

#define E2P_DigitalCC_BASE						(E2P_AnalogCC_BASE+E2P_AnalogCC_SIZE)			                                 
#define E2P_DigitalCC_SIZE						(1)                                               
#define E2P_DigitalCC_INFO						"E2P_DigitalCC"    

#define E2P_SerialOffMode_BASE					(E2P_DigitalCC_BASE+E2P_DigitalCC_SIZE)
#define E2P_SerialOffMode_SIZE					(1)
#define E2P_SerialOffMode_INFO					"E2P_SerialOffMode"

#define E2P_PreVersion_BASE						(E2P_SerialOffMode_BASE+E2P_SerialOffMode_SIZE)			                                 
#define E2P_PreVersion_SIZE						(32)                                               
#define E2P_PreVersion_INFO						"E2P_PreVersion"    

#define E2P_BootCnt_BASE						(E2P_PreVersion_BASE+E2P_PreVersion_SIZE)			                                 
#define E2P_BootCnt_SIZE						(4)                                               
#define E2P_BootCnt_INFO						"E2P_BootCnt"    

#define E2P_BSLVersion_BASE						(E2P_BootCnt_BASE+E2P_BootCnt_SIZE)			                                 
#define E2P_BSLVersion_SIZE						(32)                                               
#define E2P_BSLVersion_INFO						"E2P_BSLVersion"    

#define E2P_STT_BASE							(E2P_BSLVersion_BASE+E2P_BSLVersion_SIZE)			                                 
#define E2P_STT_SIZE							(32)                                               
#define E2P_STT_INFO							"E2P_STT"    

#define E2P_LastReBootReason_BASE				(E2P_STT_BASE+E2P_STT_SIZE)			                                 
#define E2P_LastReBootReason_SIZE				(1)                                               
#define E2P_LastReBootReason_INFO				"E2P_BootReason"    

#define E2P_LastBootSuccess_BASE				(E2P_LastReBootReason_BASE+E2P_LastReBootReason_SIZE)			                                 
#define E2P_LastBootSuccess_SIZE				(1)                                               
#define E2P_LastBootSuccess_INFO				"E2P_LastBootSuccess"    

#define E2P_SvcStartUpFail_BASE					(E2P_LastBootSuccess_BASE+E2P_LastBootSuccess_SIZE)			                                 
#define E2P_SvcStartUpFail_SIZE					(1)                                               
#define E2P_SvcStartUpFail_INFO					"E2P_SvcStartUpFail"    

#define E2P_DISPLAY_RESOLUTION_MODE_BASE	(E2P_SvcStartUpFail_BASE+E2P_SvcStartUpFail_SIZE)			                                 
#define E2P_DISPLAY_RESOLUTION_MODE_SIZE		(1)                                               
#define E2P_DISPLAY_RESOLUTION_MODE_INFO	"E2P_DISPLAY_RESOLUTION_MODE"    
                                                                                                                                                
#define E2P_docsDevEvent_BASE					(E2P_DISPLAY_RESOLUTION_MODE_BASE+E2P_DISPLAY_RESOLUTION_MODE_SIZE)	
#define E2P_docsDevEvent_SIZE					(32)                                                   
#define E2P_docsDevEvent_INFO					"E2P_docsDevEvent"                                  

#define E2P_DS_EXT_AUDIO0_BASE				(E2P_docsDevEvent_BASE+E2P_docsDevEvent_SIZE)
#define E2P_DS_EXT_AUDIO0_SIZE				(4)
#define E2P_DS_EXT_AUDIO0_INFO				"E2P_DS_EXT_AUDIO0"

#define E2P_DS_EXT_AUDIO1_BASE				(E2P_DS_EXT_AUDIO0_BASE+E2P_DS_EXT_AUDIO0_SIZE)
#define E2P_DS_EXT_AUDIO1_SIZE				(4)
#define E2P_DS_EXT_AUDIO1_INFO				"E2P_DS_EXT_AUDIO1"

#define E2P_LAST_FREQ_BASE						(E2P_DS_EXT_AUDIO1_BASE+E2P_DS_EXT_AUDIO1_SIZE)
#define E2P_LAST_FREQ_SIZE						(2)
#define E2P_LAST_FREQ_INFO						"E2P_LAST_FREQ"

#define E2P_LAST_QAM_BASE						(E2P_LAST_FREQ_BASE+E2P_LAST_FREQ_SIZE)
#define E2P_LAST_QAM_SIZE						(2)
#define E2P_LAST_QAM_INFO						"E2P_LAST_QAM"

#define E2P_CC_SIZE_BASE						(E2P_LAST_QAM_BASE+E2P_LAST_QAM_SIZE)			                                 
#define E2P_CC_SIZE_SIZE						(2)                                               
#define E2P_CC_SIZE_INFO						"E2P_CC_SIZE"    

#define E2P_CC_FONT_BASE						(E2P_CC_SIZE_BASE+E2P_CC_SIZE_SIZE)			                                 
#define E2P_CC_FONT_SIZE						(1)                                               
#define E2P_CC_FONT_INFO						"E2P_CC_FONT"    

#define E2P_CC_FG_COLOR_BASE					(E2P_CC_FONT_BASE+E2P_CC_FONT_SIZE)			                                 
#define E2P_CC_FG_COLOR_SIZE					(1)                                               
#define E2P_CC_FG_COLOR_INFO					"E2P_CC_FG_COLOR"    

#define E2P_CC_FG_BG_COLOR_BASE				(E2P_CC_FG_COLOR_BASE+E2P_CC_FG_COLOR_SIZE)			                                 
#define E2P_CC_FG_BG_COLOR_SIZE				(1)                                               
#define E2P_CC_FG_BG_COLOR_INFO				"E2P_CC_FG_BG_COLOR"    

#define E2P_CC_BG_COLOR_BASE					(E2P_CC_FG_BG_COLOR_BASE+E2P_CC_FG_BG_COLOR_SIZE)			                                 
#define E2P_CC_BG_COLOR_SIZE					(1)                                               
#define E2P_CC_BG_COLOR_INFO					"E2P_CC_BG_COLOR"    

#define E2P_CC_FG_OPACITY_BASE				(E2P_CC_BG_COLOR_BASE+E2P_CC_BG_COLOR_SIZE)			                                 
#define E2P_CC_FG_OPACITY_SIZE					(1)                                               
#define E2P_CC_FG_OPACITY_INFO				"E2P_CC_FG_OPACITY"    

#define E2P_CC_FG_BG_OPACITY_BASE				(E2P_CC_FG_OPACITY_BASE+E2P_CC_FG_OPACITY_SIZE)			                                 
#define E2P_CC_FG_BG_OPACITY_SIZE				(1)                                               
#define E2P_CC_FG_BG_OPACITY_INFO				"E2P_CC_FG_BG_OPACITY"    

#define E2P_CC_BG_OPACITY_BASE				(E2P_CC_FG_BG_OPACITY_BASE+E2P_CC_FG_BG_OPACITY_SIZE)			                                 
#define E2P_CC_BG_OPACITY_SIZE					(1)                                               
#define E2P_CC_BG_OPACITY_INFO				"E2P_CC_BG_OPACITY"  


/* System History*/
#define E2P_LUHN_HOST_ID_BASE					(E2P_BASE_OF_MW_SH)
#define E2P_LUHN_HOST_ID_SIZE					(16)                                               
#define E2P_LUHN_HOST_ID_INFO					"E2P_LUHN_HOST_ID"    

#define E2P_CntOfEraseUA_BASE					(E2P_LUHN_HOST_ID_BASE+E2P_LUHN_HOST_ID_SIZE)			                                 
#define E2P_CntOfEraseUA_SIZE					(1)                                               
#define E2P_CntOfEraseUA_INFO					"E2P_CntOfEraseUA"    

#define E2P_CntOfRfsFormat_BASE					(E2P_CntOfEraseUA_BASE+E2P_CntOfEraseUA_SIZE)			                                 
#define E2P_CntOfRfsFormat_SIZE					(1)                                               
#define E2P_CntOfRfsFormat_INFO					"E2P_CntOfRfsFormat"    

#define E2P_LastCDName_BASE					(E2P_CntOfRfsFormat_BASE+E2P_CntOfRfsFormat_SIZE)
#define E2P_LastCDName_SIZE					(32)
#define E2P_LastCDName_INFO					"E2P_E2P_LastCDName"

#define E2P_REBOOT_MODE_BASE					(E2P_LastCDName_BASE+E2P_LastCDName_SIZE)			                                 
#define E2P_REBOOT_MODE_SIZE					(1)                                               
#define E2P_REBOOT_MODE_INFO					"E2P_REBOOT_MODE"    

#define E2P_BSLLastCDName_BASE				(E2P_REBOOT_MODE_BASE+E2P_REBOOT_MODE_SIZE)
#define E2P_BSLLastCDName_SIZE					(32)
#define E2P_BSLLastCDName_INFO				"E2P_BSLLastCDName"

#define E2P_BootCodeVer_BASE					(E2P_BSLLastCDName_BASE+E2P_BSLLastCDName_SIZE)
#define E2P_BootCodeVer_SIZE					(16)
#define E2P_BootCodeVer_INFO					"E2P_BootCodeVer"

#define E2P_BOOT_MODE_BASE					(E2P_BootCodeVer_BASE+E2P_BootCodeVer_SIZE)
#define E2P_BOOT_MODE_SIZE					(1)
#define E2P_BOOT_MODE_INFO					"E2P_BOOT_MODE"

#define E2P_FTM_MODE_BASE						(E2P_BOOT_MODE_BASE+E2P_BOOT_MODE_SIZE)
#define E2P_FTM_MODE_SIZE						(1)
#define E2P_FTM_MODE_INFO						"E2P_FTM_MODE"

/* for RDK, VL - SAMSUNG Nvmem Interface */
#define E2P_PREVIOUS_IMAGENAME_BASE			(E2P_FTM_MODE_BASE+E2P_FTM_MODE_SIZE)
#define E2P_PREVIOUS_IMAGENAME_SIZE			(32)
#define E2P_PREVIOUS_IMAGENAME_INFO			"E2P_PREVIOUS_IMAGE_NAME"

#define E2P_CURRENT_IMAGENAME_BASE			(E2P_PREVIOUS_IMAGENAME_BASE+E2P_PREVIOUS_IMAGENAME_SIZE)
#define E2P_CURRENT_IMAGENAME_SIZE			(32)
#define E2P_CURRENT_IMAGENAME_INFO			"E2P_CURRENT_IMAGE_NAME"

#define E2P_UPGRADE_IMAGENAME_BASE			(E2P_CURRENT_IMAGENAME_BASE+E2P_CURRENT_IMAGENAME_SIZE)
#define E2P_UPGRADE_IMAGENAME_SIZE			(32)
#define E2P_UPGRADE_IMAGENAME_INFO			"E2P_UPGRADE_IMAGE_NAME"


/* SNA Map*/
#define E2P_SNA_NVRAM_NVM_ID_BASE							(E2P_BASE_OF_NAPP)
#define E2P_SNA_NVRAM_NVM_ID_SIZE							4
#define E2P_SNA_NVRAM_NVM_ID_INFO							"E2P_SNA_NVRAM_NVM_ID"

#define E2P_SNA_NVRAM_NVM_VERSION_BASE						(E2P_SNA_NVRAM_NVM_ID_BASE+E2P_SNA_NVRAM_NVM_ID_SIZE)	
#define E2P_SNA_NVRAM_NVM_VERSION_SIZE						1
#define E2P_SNA_NVRAM_NVM_VERSION_INFO						"E2P_SNA_NVRAM_NVM_VERSION"

#define E2P_SNA_NVRAM_NVM_TIME_BASE							(E2P_SNA_NVRAM_NVM_VERSION_BASE+E2P_SNA_NVRAM_NVM_VERSION_SIZE)	
#define E2P_SNA_NVRAM_NVM_TIME_SIZE							8
#define E2P_SNA_NVRAM_NVM_TIME_INFO							"E2P_SNA_NVRAM_NVM_TIME"

#define E2P_SNA_SIM_EEPROM_AIR_CHANNELMAP_BASE				(E2P_SNA_NVRAM_NVM_TIME_BASE+E2P_SNA_NVRAM_NVM_TIME_SIZE)	
#define E2P_SNA_SIM_EEPROM_AIR_CHANNELMAP_SIZE				1
#define E2P_SNA_SIM_EEPROM_AIR_CHANNELMAP_INFO				"E2P_SNA_SIM_EEPROM_AIR_CHANNELMAP"

#define E2P_SNA_SIM_EEPROM_CABLE_CHANNELMAP_BASE			(E2P_SNA_SIM_EEPROM_AIR_CHANNELMAP_BASE+E2P_SNA_SIM_EEPROM_AIR_CHANNELMAP_SIZE)	
#define E2P_SNA_SIM_EEPROM_CABLE_CHANNELMAP_SIZE			1
#define E2P_SNA_SIM_EEPROM_CABLE_CHANNELMAP_INFO			"E2P_SNA_SIM_EEPROM_CABLE_CHANNELMAP"

#define E2P_SNA_SIM_EEPROM_CABLEWITHCC_CHANNELMAP_BASE	(E2P_SNA_SIM_EEPROM_CABLE_CHANNELMAP_BASE+E2P_SNA_SIM_EEPROM_CABLE_CHANNELMAP_SIZE)	
#define E2P_SNA_SIM_EEPROM_CABLEWITHCC_CHANNELMAP_SIZE	1
#define E2P_SNA_SIM_EEPROM_CABLEWITHCC_CHANNELMAP_INFO	"E2P_SNA_SIM_EEPROM_CABLEWITHCC_CHANNELMAP"

#define E2P_SNA_SIM_EEPROM_PODCM_LVCT_VERSION_BASE		(E2P_SNA_SIM_EEPROM_CABLEWITHCC_CHANNELMAP_BASE+E2P_SNA_SIM_EEPROM_CABLEWITHCC_CHANNELMAP_SIZE)	
#define E2P_SNA_SIM_EEPROM_PODCM_LVCT_VERSION_SIZE			1
#define E2P_SNA_SIM_EEPROM_PODCM_LVCT_VERSION_INFO		"E2P_SNA_SIM_EEPROM_PODCM_LVCT_VERSION"

#define E2P_SNA_SIM_EEPROM_PODCM_LVCT_MAPID_BASE			(E2P_SNA_SIM_EEPROM_PODCM_LVCT_VERSION_BASE+E2P_SNA_SIM_EEPROM_PODCM_LVCT_VERSION_SIZE)	
#define E2P_SNA_SIM_EEPROM_PODCM_LVCT_MAPID_SIZE			1
#define E2P_SNA_SIM_EEPROM_PODCM_LVCT_MAPID_INFO			"E2P_SNA_SIM_EEPROM_PODCM_LVCT_MAPID_SIZE"

#define E2P_SNA_SIM_EEPROM_FIRST_POD_ID_BASE				(E2P_SNA_SIM_EEPROM_PODCM_LVCT_MAPID_BASE+E2P_SNA_SIM_EEPROM_PODCM_LVCT_MAPID_SIZE)	
#define E2P_SNA_SIM_EEPROM_FIRST_POD_ID_SIZE				1
#define E2P_SNA_SIM_EEPROM_FIRST_POD_ID_INFO				"E2P_SNA_SIM_EEPROM_FIRST_POD_ID"

#define E2P_SNA_SIM_EEPROM_SECOND_POD_ID_BASE				(E2P_SNA_SIM_EEPROM_FIRST_POD_ID_BASE+E2P_SNA_SIM_EEPROM_FIRST_POD_ID_SIZE)	
#define E2P_SNA_SIM_EEPROM_SECOND_POD_ID_SIZE				1
#define E2P_SNA_SIM_EEPROM_SECOND_POD_ID_INFO				"E2P_SNA_SIM_EEPROM_SECOND_POD_ID"

#define E2P_SNA_SIM_EEPROM_THIRD_POD_ID_BASE				(E2P_SNA_SIM_EEPROM_SECOND_POD_ID_BASE+E2P_SNA_SIM_EEPROM_SECOND_POD_ID_SIZE)	
#define E2P_SNA_SIM_EEPROM_THIRD_POD_ID_SIZE				1
#define E2P_SNA_SIM_EEPROM_THIRD_POD_ID_INFO				"E2P_SNA_SIM_EEPROM_THIRD_POD_ID"

#define E2P_SNA_SIM_EEPROM_FORTH_POD_ID_BASE				(E2P_SNA_SIM_EEPROM_THIRD_POD_ID_BASE+E2P_SNA_SIM_EEPROM_THIRD_POD_ID_SIZE)	
#define E2P_SNA_SIM_EEPROM_FORTH_POD_ID_SIZE				1
#define E2P_SNA_SIM_EEPROM_FORTH_POD_ID_INFO				"E2P_SNA_SIM_EEPROM_FORTH_POD_ID"

#define E2P_SNA_SIM_EEPROM_CLOCK_SET_MODE_BASE				(E2P_SNA_SIM_EEPROM_FORTH_POD_ID_BASE+E2P_SNA_SIM_EEPROM_FORTH_POD_ID_SIZE)	
#define E2P_SNA_SIM_EEPROM_CLOCK_SET_MODE_SIZE 				1
#define E2P_SNA_SIM_EEPROM_CLOCK_SET_MODE_INFO				"E2P_SNA_SIM_EEPROM_CLOCK_SET_MODE"

#define E2P_SNA_SIM_EEPROM_NTT_LIST_BASE					(E2P_SNA_SIM_EEPROM_CLOCK_SET_MODE_BASE+E2P_SNA_SIM_EEPROM_CLOCK_SET_MODE_SIZE)	
#define E2P_SNA_SIM_EEPROM_NTT_LIST_SIZE						1
#define E2P_SNA_SIM_EEPROM_NTT_LIST_INFO						"E2P_SNA_SIM_EEPROM_NTT_LIST"

#define E2P_SNA_SVM_NVR_CHANNEL_PARAM_ADDR_BASE			(E2P_SNA_SIM_EEPROM_NTT_LIST_BASE+E2P_SNA_SIM_EEPROM_NTT_LIST_SIZE)	
#define E2P_SNA_SVM_NVR_CHANNEL_PARAM_ADDR_SIZE			92
#define E2P_SNA_SVM_NVR_CHANNEL_PARAM_ADDR_INFO			"E2P_SNA_SVM_NVR_CHANNEL_PARAM_ADDR"

#define E2P_SNA_SVM_NVR_SVM_DATA_ADDR_BASE					(E2P_SNA_SVM_NVR_CHANNEL_PARAM_ADDR_BASE+E2P_SNA_SVM_NVR_CHANNEL_PARAM_ADDR_SIZE)	
#define E2P_SNA_SVM_NVR_SVM_DATA_ADDR_SIZE					12
#define E2P_SNA_SVM_NVR_SVM_DATA_ADDR_INFO					"E2P_SNA_SVM_NVR_SVM_DATA_ADDR"

#define E2P_SNA_AM_STANDBY_BASE								(E2P_SNA_SVM_NVR_SVM_DATA_ADDR_BASE+E2P_SNA_SVM_NVR_SVM_DATA_ADDR_SIZE)	
#define E2P_SNA_AM_STANDBY_SIZE								1        
#define E2P_SNA_AM_STANDBY_INFO								"E2P_SNA_AM_STANDBY"

#define E2P_SNA_AM_AUTO_POWER_OFF_BASE						(E2P_SNA_AM_STANDBY_BASE+E2P_SNA_AM_STANDBY_SIZE)	
#define E2P_SNA_AM_AUTO_POWER_OFF_SIZE						1
#define E2P_SNA_AM_AUTO_POWER_OFF_INFO						"E2P_SNA_AM_AUTO_POWER_OFF"

#define E2P_SNA_SWU_PREVIOUS_VERSION_BASE					(E2P_SNA_AM_AUTO_POWER_OFF_BASE+E2P_SNA_AM_AUTO_POWER_OFF_SIZE)	
#define E2P_SNA_SWU_PREVIOUS_VERSION_SIZE					4
#define E2P_SNA_SWU_PREVIOUS_VERSION_INFO					"E2P_SNA_SWU_PREVIOUS_VERSION"

#define E2P_SNA_NVM_CC_MODE_BASE								(E2P_SNA_SWU_PREVIOUS_VERSION_BASE+E2P_SNA_SWU_PREVIOUS_VERSION_SIZE)	
#define E2P_SNA_NVM_CC_MODE_SIZE								1
#define E2P_SNA_NVM_CC_MODE_INFO								"E2P_SNA_NVM_CC_MODE"

#define E2P_SNA_NVM_CC_SERVICE_BASE							(E2P_SNA_NVM_CC_MODE_BASE+E2P_SNA_NVM_CC_MODE_SIZE)	
#define E2P_SNA_NVM_CC_SERVICE_SIZE							1
#define E2P_SNA_NVM_CC_SERVICE_INFO							"E2P_SNA_NVM_CC_SERVICE"

#define E2P_SNA_NVM_CC_SIZE_BASE								(E2P_SNA_NVM_CC_SERVICE_BASE+E2P_SNA_NVM_CC_SERVICE_SIZE)	
#define E2P_SNA_NVM_CC_SIZE_SIZE								1
#define E2P_SNA_NVM_CC_SIZE_INFO								"E2P_SNA_NVM_CC_SIZE"

#define E2P_SNA_NVM_CC_FONT_BASE								(E2P_SNA_NVM_CC_SIZE_BASE+E2P_SNA_NVM_CC_SIZE_SIZE)	
#define E2P_SNA_NVM_CC_FONT_SIZE								1
#define E2P_SNA_NVM_CC_FONT_INFO								"E2P_SNA_NVM_CC_FONT"

#define E2P_SNA_NVM_CC_FG_COLOR_BASE						(E2P_SNA_NVM_CC_FONT_BASE+E2P_SNA_NVM_CC_FONT_SIZE)	
#define E2P_SNA_NVM_CC_FG_COLOR_SIZE							1
#define E2P_SNA_NVM_CC_FG_COLOR_INFO							"E2P_SNA_NVM_CC_FG_COLOR"

#define E2P_SNA_NVM_CC_BG_COLOR_BASE						(E2P_SNA_NVM_CC_FG_COLOR_BASE+E2P_SNA_NVM_CC_FG_COLOR_SIZE)	
#define E2P_SNA_NVM_CC_BG_COLOR_SIZE							1
#define E2P_SNA_NVM_CC_BG_COLOR_INFO							"E2P_SNA_NVM_CC_BG_COLOR"

#define E2P_SNA_NVM_CC_FG_OPACITY_BASE						(E2P_SNA_NVM_CC_BG_COLOR_BASE+E2P_SNA_NVM_CC_BG_COLOR_SIZE)	
#define E2P_SNA_NVM_CC_FG_OPACITY_SIZE						1
#define E2P_SNA_NVM_CC_FG_OPACITY_INFO						"E2P_SNA_NVM_CC_FG_OPACITY"

#define E2P_SNA_NVM_CC_BG_OPACITY_BASE						(E2P_SNA_NVM_CC_FG_OPACITY_BASE+E2P_SNA_NVM_CC_FG_OPACITY_SIZE)	
#define E2P_SNA_NVM_CC_BG_OPACITY_SIZE						1
#define E2P_SNA_NVM_CC_BG_OPACITY_INFO						"E2P_SNA_NVM_CC_BG_OPACITY"

#define E2P_SNA_NVM_CC_SOURCE_BASE							(E2P_SNA_NVM_CC_BG_OPACITY_BASE+E2P_SNA_NVM_CC_BG_OPACITY_SIZE)	
#define E2P_SNA_NVM_CC_SOURCE_SIZE							1
#define E2P_SNA_NVM_CC_SOURCE_INFO							"E2P_SNA_NVM_CC_SOURCE"

#define E2P_SNA_NVM_CC_ON_BASE								(E2P_SNA_NVM_CC_SOURCE_BASE+E2P_SNA_NVM_CC_SOURCE_SIZE)	
#define E2P_SNA_NVM_CC_ON_SIZE								1
#define E2P_SNA_NVM_CC_ON_INFO								"E2P_SNA_NVM_CC_ON"

#define E2P_SNA_MENU_MTL_BASE								(E2P_SNA_NVM_CC_ON_BASE+E2P_SNA_NVM_CC_ON_SIZE)	
#define E2P_SNA_MENU_MTL_SIZE									1
#define E2P_SNA_MENU_MTL_INFO									"E2P_SNA_MENU_MTL"

#define E2P_SNA_MENU_TIMEZONE_BASE							(E2P_SNA_MENU_MTL_BASE+E2P_SNA_MENU_MTL_SIZE)	
#define E2P_SNA_MENU_TIMEZONE_SIZE							1
#define E2P_SNA_MENU_TIMEZONE_INFO							"E2P_SNA_MENU_TIMEZONE"

#define E2P_SNA_MENU_TIMEMODE_BASE							(E2P_SNA_MENU_TIMEZONE_BASE+E2P_SNA_MENU_TIMEZONE_SIZE)	
#define E2P_SNA_MENU_TIMEMODE_SIZE							1
#define E2P_SNA_MENU_TIMEMODE_INFO							"E2P_SNA_MENU_TIMEMODE"

#define E2P_SNA_MENU_DST_BASE								(E2P_SNA_MENU_TIMEMODE_BASE+E2P_SNA_MENU_TIMEMODE_SIZE)	
#define E2P_SNA_MENU_DST_SIZE									1
#define E2P_SNA_MENU_DST_INFO									"E2P_SNA_MENU_DST"

#define E2P_SNA_MENU_MANTIME_MONTH_BASE					(E2P_SNA_MENU_DST_BASE+E2P_SNA_MENU_DST_SIZE)	
#define E2P_SNA_MENU_MANTIME_MONTH_SIZE					1
#define E2P_SNA_MENU_MANTIME_MONTH_INFO					"E2P_SNA_MENU_MANTIME_MONTH"

#define E2P_SNA_MENU_MANTIME_DAY_BASE						(E2P_SNA_MENU_MANTIME_MONTH_BASE+E2P_SNA_MENU_MANTIME_MONTH_SIZE)	
#define E2P_SNA_MENU_MANTIME_DAY_SIZE						1
#define E2P_SNA_MENU_MANTIME_DAY_INFO						"E2P_SNA_MENU_MANTIME_DAY"

#define E2P_SNA_MENU_MANTIME_YEAR_BASE						(E2P_SNA_MENU_MANTIME_DAY_BASE+E2P_SNA_MENU_MANTIME_DAY_SIZE)	
#define E2P_SNA_MENU_MANTIME_YEAR_SIZE						2
#define E2P_SNA_MENU_MANTIME_YEAR_INFO						"E2P_SNA_MENU_MANTIME_YEAR"

#define E2P_SNA_MENU_MANTIME_HOUR_BASE						(E2P_SNA_MENU_MANTIME_YEAR_BASE+E2P_SNA_MENU_MANTIME_YEAR_SIZE)	
#define E2P_SNA_MENU_MANTIME_HOUR_SIZE						1
#define E2P_SNA_MENU_MANTIME_HOUR_INFO						"E2P_SNA_MENU_MANTIME_HOUR"

#define E2P_SNA_MENU_MANTIME_MIN_BASE						(E2P_SNA_MENU_MANTIME_HOUR_BASE+E2P_SNA_MENU_MANTIME_HOUR_SIZE)	
#define E2P_SNA_MENU_MANTIME_MIN_SIZE						1
#define E2P_SNA_MENU_MANTIME_MIN_INFO						"E2P_SNA_MENU_MANTIME_MIN"

#define E2P_SNA_MENU_MANTIME_AMPM_BASE						(E2P_SNA_MENU_MANTIME_MIN_BASE+E2P_SNA_MENU_MANTIME_MIN_SIZE)	
#define E2P_SNA_MENU_MANTIME_AMPM_SIZE						1
#define E2P_SNA_MENU_MANTIME_AMPM_INFO						"E2P_SNA_MENU_MANTIME_AMPM"

#define E2P_SNA_MENU_LANGUAGE_BASE							(E2P_SNA_MENU_MANTIME_AMPM_BASE+E2P_SNA_MENU_MANTIME_AMPM_SIZE)	
#define E2P_SNA_MENU_LANGUAGE_SIZE							1
#define E2P_SNA_MENU_LANGUAGE_INFO							"E2P_SNA_MENU_LANGUAGE"

#define E2P_SNA_MENU_TRANSPARENCY_BASE						(E2P_SNA_MENU_LANGUAGE_BASE+E2P_SNA_MENU_LANGUAGE_SIZE)	
#define E2P_SNA_MENU_TRANSPARENCY_SIZE						1
#define E2P_SNA_MENU_TRANSPARENCY_INFO						"E2P_SNA_MENU_TRANSPARENCY"

#define E2P_SNA_MENU_HELP_ONOFF_BASE						(E2P_SNA_MENU_TRANSPARENCY_BASE+E2P_SNA_MENU_TRANSPARENCY_SIZE)	
#define E2P_SNA_MENU_HELP_ONOFF_SIZE							1
#define E2P_SNA_MENU_HELP_ONOFF_INFO						"E2P_SNA_MENU_HELP_ONOFF"

#define E2P_SNA_MENU_BORDER_COLOR_BASE						(E2P_SNA_MENU_HELP_ONOFF_BASE+E2P_SNA_MENU_HELP_ONOFF_SIZE)	
#define E2P_SNA_MENU_BORDER_COLOR_SIZE						1
#define E2P_SNA_MENU_BORDER_COLOR_INFO						"E2P_SNA_MENU_BORDER_COLOR"

#define E2P_SNA_MENU_NATIVE_AUTOCHANGE_ONOFF_BASE		(E2P_SNA_MENU_BORDER_COLOR_BASE+E2P_SNA_MENU_BORDER_COLOR_SIZE)	
#define E2P_SNA_MENU_NATIVE_AUTOCHANGE_ONOFF_SIZE			1
#define E2P_SNA_MENU_NATIVE_AUTOCHANGE_ONOFF_INFO		"E2P_SNA_MENU_NATIVE_AUTOCHANGE_ONOFF"

#define E2P_SNA_MENU_NATIVE_ASPECT_MODE_BASE		(E2P_SNA_MENU_NATIVE_AUTOCHANGE_ONOFF_BASE+E2P_SNA_MENU_NATIVE_AUTOCHANGE_ONOFF_SIZE)
#define E2P_SNA_MENU_NATIVE_ASPECT_MODE_SIZE			1
#define E2P_SNA_MENU_NATIVE_ASPECT_MODE_INFO		"E2P_SNA_MENU_NATIVE_ASPECT_MODE"

#define E2P_SNA_MENU_NATIVE_DIGITAL_AUDIO_BASE		(E2P_SNA_MENU_NATIVE_ASPECT_MODE_BASE+E2P_SNA_MENU_NATIVE_ASPECT_MODE_SIZE)
#define E2P_SNA_MENU_NATIVE_DIGITAL_AUDIO_SIZE			1
#define E2P_SNA_MENU_NATIVE_DIGITAL_AUDIO_INFO		"E2P_SNA_MENU_NATIVE_DIGITAL_AUDIO"

#endif

