/******************************************************************************
* Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors. 
* All rights reserved.
*
* This software is the confidential and proprietary information of SeaChange
* ("Confidential Information"). You shall not disclose this source code or 
* such Confidential Information and shall use it only in accordance with the 
* terms of the license agreement you entered into.
*  
* SEACHANGE INERNATIONAL  MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
* SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT 
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SEACHANGE SHALL NOT BE LIABLE FOR 
* ANY DAMAGES SUFFERED BY LICENSEE NOR SHALL THEY BE RESPONSIBLE AS A RESULT 
* OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*******************************************************************************/



/*-------------------------------------------------------------------
   Include Files
-------------------------------------------------------------------*/
#ifdef USE_POD

#ifdef USE_NEW_MSPOD_DRIVER

#define DEPRECATED_INTERFACE_SUPPORT
#endif

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <poll.h>
#include <errno.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <assert.h>
#include "rmf_osal_sync.h"
#include "rmf_osal_thread.h"
#include "rmfqamsrc.h"

#include "mpod_ioctls.h"
#include <asm/ioctl.h>
#include "pod_interface.h"
#include "pod_low_api.h"
#include "ci.h"
#include "poderror.h"
#include "link.h"
#include "pod_api.h"
#include "pod_priv.h"
#include "pod_module.h"

#include "hal_api.h"

#include "sys_init.h"

#include "bsettop_types.h"
#include "nexus_mpod.h"
#include "rmf_osal_event.h"
#include "rmf_osal_mem.h"


#include "pdt_hal.h"
#include "coreUtilityApi.h"
#include "hal_error.h"
#include "hal_module.h"
//#include "trnspt_interface.h"
#include "sys_api.h"
#include "pod_api.h"
#include "vlEnv.h"


typedef struct
{
    UCHAR type;
    int size;
    UCHAR *data;
    long lFlowId;
} CARDMsg;
typedef enum
{
    CARD_DETECTION=0,
    CARD_READ=1,
    EXT_CARD_READ,
    CARD_WRITE
} CARD_MSG_TYPE;

#define MAX_PROGRAM_KEYS 6
#define MAX_PIDCHANNELS 10

#define CABLECARD_DEVICE        "/dev/pod"
#define MAX_MPEG_SECTION_LEN    4096
#define VL_ROUTE_TS_THROUGH_POD

#ifdef POWER_CTRL_FROM_3255
extern int bcm_3255_open_rpc();
extern int bcm_3255_close_rpc();
extern int bcm_3255_card_in();
extern int bcm_3255_card_out();
extern int bcm_3255_card_reset_done();
#endif

//long mcardWriteMsgQ;
POD_BASE_t stHalPODBase;
static int     vlg_bBootUpPodInsertionNotified = 0;
static int     vlg_bPodInserted = -1;

rmf_osal_eventqueue_handle_t sendMsgQ = 0;
rmf_osal_eventqueue_handle_t ext_channel_Queue = 0;
rmf_osal_eventqueue_handle_t recvMsgQ = 0;

rmf_osal_ThreadId RcvTaskID = 0;
rmf_osal_ThreadId SndTaskID = 0;
rmf_osal_ThreadId ExtChnlTaskID = 0;


void PODIntNotifyTask (void *);
void PODReadNotifyTask(void *);
void PODMsgHandlerTask(void *);

#ifdef __cplusplus
extern "C" {
#endif
void POD_Link_Data_Rcv_Thread(void *);
void POD_Link_Data_Snd_Thread(void *);
void POD_Link_ExtChnl_Snd_Thread(void *);
void POD_Reset_Thread(void*);

extern void initializeRFC();

#ifdef __cplusplus
}
#endif

void CardDetectionCallback(void);


void clearEventQueue(rmf_osal_eventqueue_handle_t eventQ);

void POD_LinkConnActivate();
void POD_LinkConnStop();
void POD_Api_Det_Out_Callback();
void POD_Api_Det_In_Callback();

int gmspodOpened;
rmf_osal_Mutex vlg_podSendMutex;
//ericz_10_23_TODO !!!! remove NEXUS_MpodHandle vlg_CableCardHandle;

static unsigned char   vlg_bGotDataFromCard = 0;
static unsigned char   vlg_bResetInProgress = 0;
static unsigned int    vlg_bCardResetCount = 0;

void vlInitPodCipherConfigData();
void resetProgramKey(int index);

static unsigned char checkHostCardInterfaceStatus();

static char vlg_szSystemRebootOnMspodError[] = {"SYSTEM.REBOOT.ON.MSPOD.ERROR"};
static unsigned int  vlg_SystemRebootOnMspodError = 0;
static char vlg_szEnableCardResetOnCardHostCommFailure[] = {"ENABLE.CARD.RESET.ON.CARDHOST.COMM.FAILURE"};
static unsigned int  vlg_EnableCardResetOnCardHostCommFailure = 0;
static int vlg_bReset_in_process;

void MPOD_RouteXptThruCard(unsigned char bRouteXpt)
{
//ericz_10_23_TOOD!!!!        rmf_qamsrc_routeXptThruCard((unsigned int)vlg_CableCardHandle, bRouteXpt);
}

void VL_MPOD_PCMCIA_Reset_Thread()
{
    int err;
    extern int errno;

    vlg_bReset_in_process = 1;
    POD_LinkConnStop ();
    vlg_bReset_in_process = 0;

#ifdef POWER_CTRL_FROM_3255
    /* tri-state POD signal */
    bcm_3255_card_out();
#endif
    POD_Api_Det_Out_Callback();

    //MPEOS_LOG(MPE_LOG_INFO, MPE_MOD_POD, "VL_MPOD_PCMCIA_Reset_Thread: Reseting the POD interface ...\n");
        RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD","%s(): Reseting the POD interface ...\n", __FUNCTION__);
    err = ioctl(stHalPODBase.podDrvHandle,IOCTL_MPOD_PCMCIA_RESET, 0);
    if (err<0)
    {
        //MPEOS_LOG(MPE_LOG_INFO, MPE_MOD_POD, "VL_MPOD_PCMCIA_Reset_Thread: IOCTL_MPOD_INTERF_RESET failed!\n");
                RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD","%s():ERROR......  IOCTL_MPOD_INTERF_RESET failed!\n", __FUNCTION__);
        //VL_MPOD_Api_Det_Error_Callback();
        //POD_thread_exit;
        return;
    }

#ifdef POWER_CTRL_FROM_3255
    err= bcm_3255_card_in();
//err = 0;
    if (err == 0)
        err = ioctl(stHalPODBase.podDrvHandle,IOCTL_MPOD_CARD_INIT, (unsigned long)0);
    else
    {
        //MPEOS_LOG(MPE_LOG_INFO, MPE_MOD_POD, "VL_MPOD_PCMCIA_Reset_Thread: 3255 RPC failed!\n");
                RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD","%s():ERROR......  3255 RPC failed!!\n", __FUNCTION__);
        //VL_MPOD_Api_Det_Error_Callback();
        //POD_thread_exit;
        return;
    }
#endif

#ifdef RESET_CTRL_FROM_3255
    err = bcm_3255_card_reset_done();
    if (err == 0)
        err = ioctl(stHalPODBase.podDrvHandle,IOCTL_MPOD_CARD_HOST_READY, (unsigned long)0);
    else
    {
        //MPEOS_LOG(MPE_LOG_INFO, MPE_MOD_POD, "VL_MPOD_PCMCIA_Reset_Thread: RPC failed on Card In Start.\n");
                RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD","%s():ERROR......  RPC failed on Card In Start.\n", __FUNCTION__);
        //VL_MPOD_Api_Det_Error_Callback();
        //POD_thread_exit;
        return;
    }
#endif

    {
        // empty stale messages sent from stack to card
        //vlMpodEmptySendQueues();
        clearEventQueue(ext_channel_Queue);
        clearEventQueue(sendMsgQ);
    }

    POD_Api_Det_In_Callback();

    POD_LinkConnActivate();

    //POD_thread_exit;
}

void free_fn(void *data)
{
    if(data)
    	{
		rmf_osal_memFreeP(RMF_OSAL_MEM_POD, data);
	}
  
}

static void initializeKeyslots()
{
    int i;

    for (i = 0; i < MAX_PROGRAM_KEYS; i++)
    {
        RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "%s: resetting program key %d\n", __FUNCTION__, i);
        resetProgramKey(i);
    }

    return;
}

void clearEventQueue(rmf_osal_eventqueue_handle_t eventQ)
{
    while (1)
    {
        rmf_osal_event_handle_t event_handle_rcv;
        rmf_osal_event_params_t event_params_rcv;
        rmf_osal_event_category_t event_category;
        uint32_t event_type;
        rmf_Error err;

        err = rmf_osal_eventqueue_try_get_next_event( eventQ,
                &event_handle_rcv, &event_category, &event_type, &event_params_rcv);
        if(RMF_SUCCESS != err)
        {
            RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "clearEventQueue: event recv Failed \n");
            break;
        }

        if(event_params_rcv.data != NULL)
        {
            rmf_osal_memFreeP(RMF_OSAL_MEM_POD, event_params_rcv.data);
            event_params_rcv.data = NULL;
        }
        rmf_osal_event_delete(event_handle_rcv);
    }
}

int POD_Init (void)
{
    UINT32 indx,i;
    UINT8 *pusPOD;
    rmf_Error err;


#ifdef POWER_CTRL_FROM_3255
    bcm_3255_open_rpc();
    bcm_3255_card_out();
#endif

    RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s(): Entry\n", __FUNCTION__);
    RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "....................POD_Init() called....................\n");
    RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "calling vlInitPodCipherConfigData ...... !!!!\n");
    vlInitPodCipherConfigData();
    // Initialize instance capabilities
    for (indx = 0; indx < HAL_POD_MAX_PODS; indx++ )
    {
        stHalPODBase.stCapabilities.astInstanceCapabilities[indx].hPODHandle =
            PDT_HandleCreate(PDT_DEVICE_POD, indx);
    }

    stHalPODBase.stCapabilities.usNumPODs = HAL_POD_MAX_PODS;

    // Open the driver and do the initialization
    stHalPODBase.podDrvHandle = open(CABLECARD_DEVICE, O_RDWR);

    if (stHalPODBase.podDrvHandle < 0)
    {
        RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "Unable to open cablecard device: %s\n", CABLECARD_DEVICE);
        return ERROR_HAL_OS_GENERAL;
    }

    // At this point, I know the hardware is ready so I need my software reset thread
    cwt_POD_reset_init();
    RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "Pod Driver Handle for the cablecard device :is %d \n", stHalPODBase.podDrvHandle);
    RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "%s():Pod Driver Handle for the cablecard device : is %d \n", __FUNCTION__, stHalPODBase.podDrvHandle);


    if(vl_env_get_bool(false, vlg_szSystemRebootOnMspodError))
    {
      RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "%s : SYSTEM.REBOOT.ON.MSPOD.ERROR flag ENABLED\n", __FUNCTION__);
      vlg_SystemRebootOnMspodError = 1;
    }

    if(vl_env_get_bool(false, vlg_szEnableCardResetOnCardHostCommFailure))
    {
      RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "%s : ENABLE.CARD.RESET.ON.CARDHOST.COMM.FAILURE flag ENABLED\n", __FUNCTION__);
      vlg_EnableCardResetOnCardHostCommFailure = 1;
    }

    //Create MsgQ for reading data from MCARD
    err = rmf_osal_eventqueue_create ( (const uint8_t* ) "linkSndMsgQ",
		&sendMsgQ);
    if (RMF_SUCCESS != err)//Changing to unsigned long It is very important to have it as UNSIGNED as this can be < 0 in success case.
    {
        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "linkSndMsgQ create failed\n");
        return ERROR_HAL_OS_GENERAL;
    }

    err = rmf_osal_eventqueue_create ( (const uint8_t* ) "linkExtChnlSndMsgQ",
		&ext_channel_Queue);
    if (RMF_SUCCESS != err)//Changing to unsigned long It is very important to have it as UNSIGNED as this can be < 0 in success case.
    {
        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "ext_channel_Queue create failed\n");
        return ERROR_HAL_OS_GENERAL;
    }

    err = rmf_osal_eventqueue_create ( (const uint8_t* ) "recvMsgQ",
		&recvMsgQ);
    if (RMF_SUCCESS != err)//Changing to unsigned long It is very important to have it as UNSIGNED as this can be < 0 in success case.
    {
        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "recvMsgQ create failed\n");
        return ERROR_HAL_OS_GENERAL;
    }

    clearEventQueue(sendMsgQ);
    clearEventQueue(ext_channel_Queue);
    clearEventQueue(recvMsgQ);
    
#if 0
    err = rmf_osal_threadCreate(PODIntNotifyTask, NULL,
         250, 4096, &stHalPODBase.podIntNotifyThreadId,
        "PODIntNotifyTask");

    if ( RMF_SUCCESS != err)
    {
        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s(): Failed to create PODIntNotification thread\n",__FUNCTION__);
        return ERROR_HAL_OS_GENERAL;
    }
	
    err = rmf_osal_threadCreate(PODReadNotifyTask, NULL,
         250, 4096, &stHalPODBase.podReadNotifyThreadId,
        "PODReadNotifyTask");

    if ( RMF_SUCCESS != err)
    {
        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s(): Failed to create PODReadNotification thread\n",__FUNCTION__);
        return ERROR_HAL_OS_GENERAL;
    }
    err = rmf_osal_threadCreate(PODMsgHandlerTask, NULL,
         200, 4096, &stHalPODBase.podMsgHandlerThreadId,
        "PODMsgHandlerTask");

    if ( RMF_SUCCESS != err)
    {
        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s(): Failed to create PODMsgHandlerTask thread\n",__FUNCTION__);
        return ERROR_HAL_OS_GENERAL;
    }
#endif
    err = rmf_osal_mutexNew(&vlg_podSendMutex);

    if (RMF_SUCCESS != err)
    {
        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s(): Failed to create podSendMutex \n",__FUNCTION__);
        return ERROR_HAL_OS_GENERAL;
    }

    for (indx = 0; indx < stHalPODBase.stCapabilities.usNumPODs; indx++)
    {
        pusPOD = (UINT8*)&stHalPODBase.astPOD[indx];

        //Reset the structure instance
        for (i = 0; i < sizeof(POD_t); i++)
        {
            *(pusPOD+i) = 0;
        }

        stHalPODBase.astPOD[indx].usIndex   = indx;
        stHalPODBase.astPOD[indx].bFree     = true;
        stHalPODBase.astPOD[indx].IsPresent = false;
    }

    stHalPODBase.bIsInitialized = true;

    initializeKeyslots();

    initializeRFC();

    RDK_LOG(RDK_LOG_DEBUG, HAL_MODULE_POD,"%s(): Exit\n", __FUNCTION__);
    return (HAL_SUCCESS);
}


void POD_Api_StartInsertTask()
{
    rmf_Error err;
    err = rmf_osal_threadCreate(PODIntNotifyTask, NULL,
         250, 4096, &stHalPODBase.podIntNotifyThreadId,
        "PODIntNotifyTask");

    if ( RMF_SUCCESS != err)
    {
        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s(): Failed to create PODIntNotification thread\n",__FUNCTION__);
        return;
    }
}

void vlConfigureCipher(unsigned char ltsid,unsigned short PrgNum,UINT32 *decodePid,UINT32 numpids,UINT32 DesKeyAHi,UINT32 DesKeyALo,UINT32 DesKeyBHi,UINT32 DesKeyBLo,void *ptr);

static int cardReInserted = 0;
static POD_STATUS_t presentCardStatus = POD_CARD_REMOVED;
static POD_STATUS_t prevCardStatus = POD_CARD_REMOVED;

void POD_Api_Det_In_Callback()
{
    ULONG   cardType = stHalPODBase.astPOD[0].cardType = POD_MCARD;
    POD_MANUFACTURER_t bPodManufacturer = UNKNOWN_POD;
    vlg_bPodInserted = 1;

#ifdef VL_ROUTE_TS_THROUGH_POD 
        //Route the XPT thru card interface
        MPOD_RouteXptThruCard(true);
#endif // VL_ROUTE_TS_THROUGH_POD

    if(NULL != stHalPODBase.astPOD[0].card_detection_cb)
    {
        vlg_bBootUpPodInsertionNotified = 1;
        // empty the queue
        clearEventQueue(ext_channel_Queue);
        clearEventQueue(sendMsgQ);
        rmf_osal_threadSleep(1000,0);
        stHalPODBase.astPOD[0].card_detection_cb((int)NULL, cardType, POD_CARD_INSERTED, &bPodManufacturer, 1, NULL);
    }
}

void POD_Api_Det_Out_Callback()
{

    ULONG   cardType = stHalPODBase.astPOD[0].cardType = POD_MCARD;
    POD_MANUFACTURER_t bPodManufacturer = UNKNOWN_POD;
    vlg_bPodInserted = 0;
#ifdef LOCAL_STREAMING
        return;
#endif //LOCAL_STREAMING

#ifdef VL_ROUTE_TS_THROUGH_POD
        //Do not route the XPT thru card interface
        MPOD_RouteXptThruCard(false);
#endif // VL_ROUTE_TS_THROUGH_POD

    if(NULL != stHalPODBase.astPOD[0].card_detection_cb)
    {
        stHalPODBase.astPOD[0].card_detection_cb((int)NULL, cardType, POD_CARD_REMOVED, &bPodManufacturer, 1, NULL);
    }
}

void POD_LinkConnActivate()
{
    rmf_Error err;

    if(RcvTaskID==0)
    {
        err = rmf_osal_threadCreate(POD_Link_Data_Rcv_Thread, NULL,
              250, 4096, &RcvTaskID,
             "POD_Link_Data_Rcv_Thread");

        if ( RMF_SUCCESS != err)
        {
            RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s(): Failed to create POD_Link_Data_Rcv_Thread thread\n",__FUNCTION__);
            return ;
        }
    }
        
    if(SndTaskID==0)
    {
        err = rmf_osal_threadCreate(POD_Link_Data_Snd_Thread, NULL,
              250, 4096, &SndTaskID,
              "POD_Link_Data_Snd_Thread");

        if ( RMF_SUCCESS != err)
        {
            RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s(): Failed to create POD_Link_Data_Snd_Thread thread\n",__FUNCTION__);
            return ;
        }
    }

    if(ExtChnlTaskID==0)
    {
        err = rmf_osal_threadCreate(POD_Link_ExtChnl_Snd_Thread, NULL,
              200, 4096, &ExtChnlTaskID,
              "POD_Link_ExtChnl_Snd_Thread");

        if ( RMF_SUCCESS != err)
        {
            RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s(): Failed to create POD_Link_ExtChnl_Snd_Thread thread\n",__FUNCTION__);
            return ;
        }
    }

}

void POD_LinkConnStop()
{
    //MPEOS_LOG(MPE_LOG_INFO, MPE_MOD_POD, "Killing Link receive threads!!\n");
    RDK_LOG(RDK_LOG_DEBUG,"LOG.RDK.POD","%s():Killing Link receive threads!!\n", __FUNCTION__);
    clearEventQueue(ext_channel_Queue);
    clearEventQueue(sendMsgQ);
    ioctl(stHalPODBase.podDrvHandle,IOCTL_MPOD_KILL_DATA_LINK, (unsigned long)0);
}

void POD_Reset_Thread(void*)
{
    int err;
    extern int errno;

    vlg_bReset_in_process = 1;
    POD_LinkConnStop ();
    vlg_bReset_in_process = 0;

#ifdef POWER_CTRL_FROM_3255
    /* tri-state POD signal */
    bcm_3255_card_out();
#endif
    POD_Api_Det_Out_Callback();

    //Xport_Wait_Close_Drv (stHalPODBase.podDrvHandle);

    //MPEOS_LOG(MPE_LOG_INFO, MPE_MOD_POD, "VL_MPOD_Reset_Thread: Reseting the POD interface ...\n");
    RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD","%s(): Reseting the POD interface ... \n", __FUNCTION__);
    err = ioctl(stHalPODBase.podDrvHandle, IOCTL_MPOD_INTERF_RESET, 0);
    if (err<0)
    {
        //MPEOS_LOG(MPE_LOG_INFO, MPE_MOD_POD, "VL_MPOD_Reset_Thread: IOCTL_MPOD_INTERF_RESET failed!\n");
                RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD","%s():ERROR..... IOCTL_MPOD_INTERF_RESET failed!\n", __FUNCTION__);
        //VL_MPOD_Api_Det_Error_Callback();
        return;
    }
#ifdef POWER_CTRL_FROM_3255
    err= bcm_3255_card_in();
//err = 0;
    if (err == 0)
        err = ioctl(stHalPODBase.podDrvHandle,IOCTL_MPOD_CARD_INIT, (unsigned long)0);
    else
    {
        //MPEOS_LOG(MPE_LOG_INFO, MPE_MOD_POD, "VL_MPOD_Reset_Thread: 3255 RPC failed!\n");
                RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD","%s(): ERROR.......3255 RPC failed!!\n", __FUNCTION__);
        //VL_MPOD_Api_Det_Error_Callback();
        POD_thread_exit;
    }
#endif

#ifdef RESET_CTRL_FROM_3255
    err = bcm_3255_card_reset_done();
    if (err == 0)
        err = ioctl(stHalPODBase.podDrvHandle,IOCTL_MPOD_CARD_HOST_READY, (unsigned long)0);
    else
    {
        //MPEOS_LOG(MPE_LOG_INFO, MPE_MOD_POD, "VL_MPOD_Reset_Thread: RPC failed on Card In Start.\n");
                RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD","%s(): ERROR.......RPC failed on Card In Start!!\n", __FUNCTION__);
        //VL_MPOD_Api_Det_Error_Callback();
        return;
    }
#endif

    {
        // empty stale messages sent from stack to card
        clearEventQueue(ext_channel_Queue);
        clearEventQueue(sendMsgQ);
    }

    POD_Api_Det_In_Callback();

    POD_LinkConnActivate();

    return;
}


void POD_Api_Det_Error_Callback()
{
    rmf_Error err;
    rmf_osal_ThreadId podResetThreadId;
    ULONG   cardType = stHalPODBase.astPOD[0].cardType = (POD_MODE_t)(-1);
    POD_MANUFACTURER_t bPodManufacturer = UNKNOWN_POD;
    if(NULL != stHalPODBase.astPOD[0].card_detection_cb)
    {
        RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD","%s() : Posting POD_CARD_ERROR\n", __FUNCTION__);
        stHalPODBase.astPOD[0].card_detection_cb((int)NULL, cardType, POD_CARD_ERROR, &bPodManufacturer, 1, NULL);
    }
    // Nov-18-2008: Attempt recover for bad pod message
    //VL_MPOD_Start_Reset();
    cwt_POD_signal_reset(ePOD_RESET_FULL); // VL_MPOD_Start_Reset();

#if 0
    err = rmf_osal_threadCreate(POD_Reset_Thread, NULL,
         250, 4096, &podResetThreadId,
        "VL_MPOD_Reset_Thread");

    if ( RMF_SUCCESS != err)
    {
        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", "%s(): Failed to create PODIntNotification thread\n",__FUNCTION__);
    }
#endif
}

void PODIntNotifyTask (void *)
{
    struct pollfd poll_list[1];
    int retval;
    poll_list[0].fd = stHalPODBase.podDrvHandle;
	    
    unsigned char bCardDetectionThreadDisable = vl_env_get_bool(0, "CARD.DETECTION.THREAD.DISABLE");


    RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", "PODIntNotifyTask(): Thread created\n");

    //RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "PODIntNotifyTask(): Before While Loop\n");
    while (1)
    {
POLL_IN:
                poll_list[0].events = POLLIN|POLLPRI;   /*for detect card plug in*/

                RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "\n start to poll card in event \n");
                retval = poll(poll_list,1,-1);

                if(retval < 0)
                {
                        RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "poll failed : %s\n",strerror(errno));
                        return;
                }

                /* remember poll() will return when the interested event OR the following three happens*/
                if(((poll_list[0].revents&POLLHUP) == POLLHUP) ||
                        ((poll_list[0].revents&POLLERR) == POLLERR) ||
                        ((poll_list[0].revents&POLLNVAL) == POLLNVAL))
                {
                        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD","%s() : we got the pod module error \n", __FUNCTION__);
                        POD_Api_Det_Error_Callback();
                }
                if((poll_list[0].revents&POLLIN) == POLLIN)
                {
                        RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "\n ==> VL_MPOD_IntNotifyTask calling POD_Api_Det_In_Callback and POD_LinkConnActivate \n");
                        /* inform the host app level that POD is in. */
                        POD_Api_Det_In_Callback();
                        {
                                int32_t err;
                                err = ioctl(stHalPODBase.podDrvHandle, IOCTL_MPOD_CARD_INIT_RESET_NEGATE, (unsigned long)0);
                                if (err && errno == EINTR)
                                {
                                        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD","%s() : IOCTL_MPOD_CARD_INIT_RESET_NEGATE error \n", __FUNCTION__);
                                        break;
                                }
                        }
                        /* we have detected that the card id present and card is initialized properly. */
                        POD_LinkConnActivate();
                }
                else
                {
			rmf_osal_threadSleep(500, 0);
                        goto POLL_IN;
                }


                if(bCardDetectionThreadDisable)
                {
                  RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "%s: FOR TESTING     CARD.DETECTION.THREAD.DISABLE is set to TRUE in mpeenv.ini. ********* QUITTING THE CARD DETECTION THREAD *********\n", __FUNCTION__);
                  RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "%s: NOTE: The stack wont detect further CARD INSERTIONS when there are genuine failures like ER bit in SEND/RECEIVE PATH and RESET is issued\n", __FUNCTION__);
                  break;
                }

		rmf_osal_threadSleep(500, 0); /* delay before checking for remove */

POLL_OUT:
                /*we should poll on out or any other error again here*/
                poll_list[0].events = POLLOUT;  /*for detect card plug out, watch for POLLOUT, which has the different meaning*/

                RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "\n start to poll card out event \n");
                retval = poll(poll_list,1,-1);

                if(retval < 0)
                {
                        RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "poll failed : %s\n",strerror(errno));
                        return;
                }

                if(((poll_list[0].revents&POLLHUP) == POLLHUP) ||
                        ((poll_list[0].revents&POLLERR) == POLLERR) ||
                        ((poll_list[0].revents&POLLNVAL) == POLLNVAL))
                {
                        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD","%s() : we got the pod module error \n", __FUNCTION__);
                        POD_Api_Det_Error_Callback();
                }

                if((poll_list[0].revents&POLLOUT) == POLLOUT)
                {
                        RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "%s: we got the pod module out \n", __FUNCTION__);
                        /* inform the host app level that POD is out. */
                        POD_Api_Det_Out_Callback();
                
                        /* card is gone. everything should be killed automatically. just wait a while. */
                        POD_LinkConnStop();
                }
                else
                {
		    rmf_osal_threadSleep(500, 0); /* delay before checking for remove */
                    goto POLL_OUT;
                }

		rmf_osal_threadSleep(500, 0); /* delay before checking for remove */
                RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", "%s: Det thread loop\n", __FUNCTION__);
    } // while(1)
}

/////////////////////////////////////////////////////////////
//  RESET CODE
#include <sys/time.h>
static pthread_cond_t s_reset_condition = PTHREAD_COND_INITIALIZER;
static pthread_mutex_t s_reset_mutex = PTHREAD_MUTEX_INITIALIZER;

static podresettype s_pod_reset_type = ePOD_RESET_NONE;
static const unsigned sMAX_EVENT_WAIT_TIME_MS = 500;
static const unsigned long sDEFAULT_MPOD_SECONDS_BETWEEN_RESETS = 60; //Set to 1 minute

static int s_run = 0;
static rmf_osal_ThreadId s_pod_thread_id = 0;
static struct timeval s_last_time;

#undef LOGINFO
#define LOGINFO(module, format, args...)   RDK_LOG(RDK_LOG_INFO, "LOG.RDK.POD", #module " : " format, args)
#define LOGDEBUG(module, format, args...)  RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.POD", #module " : " format, args)
#define LOGERROR(module, format, args...)  RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.POD", #module " : " format, args)


/////////////////////////////////////////////////////////////
// Internal functions
static unsigned long s_cwt_get_elapsed_seconds(struct timeval* pLastTime)
{
    int r;
    long elapsed = 0;
    struct timeval current_time;

    r = gettimeofday(&current_time, NULL);
    assert(r == 0);

    if (pLastTime->tv_sec > current_time.tv_sec)
    {
        // wrapped
        elapsed = (0-pLastTime->tv_sec) + current_time.tv_sec;
    }
    else
    {
        elapsed = current_time.tv_sec - pLastTime->tv_sec;
    }

    return elapsed;    
}

static int s_cwt_POD_do_reset(podresettype reset_type)
{
    int err;
    extern int errno;
    LOGDEBUG(HAL_MODULE_POD,"%s(): Starting...\n", __FUNCTION__);
    
    POD_Api_Det_Out_Callback();
    LOGDEBUG(HAL_MODULE_POD,"%s(): TS not routed to M-CARD.\n", __FUNCTION__);

    err = ioctl(stHalPODBase.podDrvHandle,IOCTL_MPOD_KILL_DATA_LINK, (unsigned long)0);
    if (err<0) LOGERROR(HAL_MODULE_POD,"%s(): IOCTL_MPOD_KILL_DATA_LINK FAILED Error = %d, errno = %d.\n", __FUNCTION__, err, errno);
    else LOGDEBUG(HAL_MODULE_POD,"%s(): M-CARD data link killed.\n", __FUNCTION__);

    switch (reset_type)
    {
    case ePOD_RESET_FULL:    
        LOGINFO(HAL_MODULE_POD,"%s(): FULL reset (reset_type=%d) of the POD interface ... \n", __FUNCTION__, reset_type);
        err = ioctl(stHalPODBase.podDrvHandle, IOCTL_MPOD_INTERF_RESET, 0);
        break;
        
    case ePOD_RESET_PCMCIA:        
        LOGINFO(HAL_MODULE_POD,"%s(): PCMCIA reset (reset_type=%d) of the POD interface ...\n", __FUNCTION__, reset_type);
        system("echo PCMCIA reset dump >> /opt/logs/top_log.txt" );
        system("top -b -n 1 | grep -e load -e Tasks -e Cpu -e Mem -e Swap -e COMMAND -e rmfStreamer -e runSnmp -e Receiver -e lighttpd -e IARMDaemonMain -e dsMgrMain -e runPod -e Main >> /opt/logs/top_log.txt");
        system("echo Complete top log >> /opt/logs/top_log.txt" );
        system("top -b -n 1 >> /opt/logs/top_log.txt");

        err = ioctl(stHalPODBase.podDrvHandle,IOCTL_MPOD_PCMCIA_RESET, 0);
        break;

    default:
        assert(0);
    }
    if (err<0)
    {
        LOGERROR(HAL_MODULE_POD,"%s(): reset_type=%d FAILED Error = %d, errno = %d.\n", __FUNCTION__, err, errno);
        return -1;
    }
    else LOGDEBUG(HAL_MODULE_POD,"%s(): M-CARD reset=%d ioctl no error.\n", __FUNCTION__, reset_type);

    // empty stale messages sent from stack to card
    //vlMpodEmptySendQueues();
    clearEventQueue(ext_channel_Queue);
    clearEventQueue(sendMsgQ);
    LOGDEBUG(HAL_MODULE_POD,"%s(): M-CARD transmit queues emptied after reset.\n", __FUNCTION__);
    
    POD_Api_Det_In_Callback();
    LOGDEBUG(HAL_MODULE_POD,"%s(): Attempted to route TS to M-CARD.\n", __FUNCTION__);

    POD_LinkConnActivate();
    LOGDEBUG(HAL_MODULE_POD,"%s(): Created M-CARD data tasks, RESET IS COMPLETE.\n", __FUNCTION__);

    return 0;
    /* Useless things removed from the code:
    vlg_bReset_in_process = 1;  // This is useless.  No one checks.
    VL_MPOD_LinkConnStop (); // This is a bad function and it also tries to empty queues.
    */
}

static void s_cwt_POD_reset_thread(void* pArg)
{
    int r = 0;
    int wait_status = 0;
    unsigned long RESET_TIME_S = sDEFAULT_MPOD_SECONDS_BETWEEN_RESETS;
    (void) pArg;

    RESET_TIME_S = vl_env_get_int(sDEFAULT_MPOD_SECONDS_BETWEEN_RESETS, "FEATURE.MPOD_SECONDS_BETWEEN_RESETS");
    if (sDEFAULT_MPOD_SECONDS_BETWEEN_RESETS != RESET_TIME_S)
    {
        LOGDEBUG(HAL_MODULE_POD,"%s():%d Time between mpod resets changed from default=%ld to %lu\n",
            __FUNCTION__, __LINE__, sDEFAULT_MPOD_SECONDS_BETWEEN_RESETS, RESET_TIME_S);
    }

    while(s_run == 1)
    {
        r = pthread_mutex_lock(&s_reset_mutex);
        assert(r == 0);

        if (s_run == 0)
        {
            r = pthread_mutex_unlock(&s_reset_mutex);
            assert(r == 0);
            break;
        }

        wait_status = pthread_cond_wait(&s_reset_condition, &s_reset_mutex);
        if (wait_status == 0 && s_run == 1)
        {
            podresettype reset_type = s_pod_reset_type;
            unsigned long seconds_since_last_reset = s_cwt_get_elapsed_seconds(&s_last_time);
            s_pod_reset_type = ePOD_RESET_NONE;
            r = pthread_mutex_unlock(&s_reset_mutex);
            assert(r == 0);

            if (seconds_since_last_reset > RESET_TIME_S)
            {
                r = s_cwt_POD_do_reset(reset_type);
                // It logs it's own error.

                // Update the last reset time
                r = pthread_mutex_lock(&s_reset_mutex);
                assert(r == 0);
                r = gettimeofday(&s_last_time, NULL);
                assert(r == 0);
                r = pthread_mutex_unlock(&s_reset_mutex);
                assert(r == 0);
            }
            else
            {
                // I'm throwing away multiple consecutive resets within cMAXTIME.
                if (reset_type == ePOD_RESET_FULL)
                {
                    r = pthread_mutex_lock(&s_reset_mutex);
                    assert(r == 0);
                    s_pod_reset_type = reset_type;
                    r = pthread_mutex_unlock(&s_reset_mutex);
                    assert(r == 0);
                    LOGERROR(HAL_MODULE_POD,"%s():%d reset_type=(%d FULL) desired but postponed until next request.\n", 
                             __FUNCTION__, __LINE__, reset_type);
                }
                else
                {
                    LOGERROR(HAL_MODULE_POD,"%s():%d reset_type=(%d) desired but ignored.\n", 
                            __FUNCTION__, __LINE__, reset_type);
                }
            }
        }
        else if (wait_status == 0 && s_run == 0)
        {
            // Signaled to exit
            r = pthread_mutex_unlock(&s_reset_mutex);
            assert(r == 0);
        }
        else if (wait_status != 0)
        {
            r = pthread_mutex_unlock(&s_reset_mutex); /*CID - 18915 unlock before ret*/
            assert(r == 0);
            LOGERROR(HAL_MODULE_POD,"%s():%d - exiting, s_run = %d, wait_status = %d...\n", 
                     __FUNCTION__, __LINE__,
                     s_run, wait_status);
            return;
        }
        else
        {
            r = pthread_mutex_unlock(&s_reset_mutex); /*CID - 18915 unlock before loop*/
            assert(r == 0);
        }
    }

    LOGERROR(HAL_MODULE_POD,"%s():%d - exiting, s_run = 0...\n", 
             __FUNCTION__, __LINE__);
    return;
}


/////////////////////////////////////////////////////////////
// API
void cwt_POD_reset_init()
{
    rmf_Error err;

    int r;
    gettimeofday(&s_last_time, NULL);
    s_pod_reset_type = ePOD_RESET_NONE;
    s_run = 1;

//    r = pthread_create(&s_pod_thread_id, NULL, (void*) s_cwt_POD_reset_thread, NULL);
    err = rmf_osal_threadCreate(s_cwt_POD_reset_thread, NULL,
         250, 4096, &s_pod_thread_id,
        "MPOD_Reset_Thread");
        
    if (RMF_SUCCESS !=  err )
    {
        s_run = 0;
        LOGERROR(HAL_MODULE_POD,"%s():%d - FAILED, pthread_create(s_cwt_POD_reset_task) FAILED\n", 
                 __FUNCTION__, __LINE__);
        return;
    }

    LOGDEBUG(HAL_MODULE_POD,"%s():%d completed!  ready...\n", __FUNCTION__, __LINE__);
    return;
}

void cwt_POD_reset_uninit()
{
    int r;

    LOGDEBUG(HAL_MODULE_POD,"%s():%d entry...\n", __FUNCTION__, __LINE__);    
    assert(s_run == 1);

    r = pthread_mutex_lock (&s_reset_mutex);
    assert(r == 0);
    s_run = 0;

    r = pthread_cond_signal(&s_reset_condition);
    assert(r == 0);

    r = pthread_mutex_unlock (&s_reset_mutex);
    assert(r == 0);

    usleep(0); // switch myself out

    r = pthread_join(s_pod_thread_id, NULL);
    assert(r == 0);
    
    usleep((sMAX_EVENT_WAIT_TIME_MS * 2 + 5000) * 1000);

    // pthread mutex destroy + =0
    // pthread_cond_destroy (s_reset_condition);
    // s_reset_condition = 0;

    LOGDEBUG(HAL_MODULE_POD,"%s():%d has completed graceful shutdown.\n", __FUNCTION__, __LINE__);    
    return;
}

void cwt_POD_signal_reset(podresettype p)
{
    int r;

    assert (s_run == 1);

    LOGDEBUG(HAL_MODULE_POD,"%s():%d trying to submit a reset_type=%d request\n", __FUNCTION__, __LINE__, p);
    
    r = pthread_mutex_lock(&s_reset_mutex);
    assert(r == 0);
    if (s_pod_reset_type != ePOD_RESET_FULL) s_pod_reset_type = p;

    r = pthread_cond_signal(&s_reset_condition);
    assert(r == 0);
    r = pthread_mutex_unlock(&s_reset_mutex);
    assert(r == 0);
}
// END
///////////////////////////////////////////////////////////// 

#endif
