/******************************************************************************
* Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors. 
* All rights reserved.
*
* This software is the confidential and proprietary information of SeaChange
* ("Confidential Information"). You shall not disclose this source code or 
* such Confidential Information and shall use it only in accordance with the 
* terms of the license agreement you entered into.
*  
* SEACHANGE INERNATIONAL  MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
* SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT 
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SEACHANGE SHALL NOT BE LIABLE FOR 
* ANY DAMAGES SUFFERED BY LICENSEE NOR SHALL THEY BE RESPONSIBLE AS A RESULT 
* OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*******************************************************************************/




#ifndef __MODULE_H
#define	__MODULE_H

//#if (defined MR05_P0 | defined MR05_P1)

#ifdef __cplusplus
extern "C" {
#endif

/* CI module registers */
#define REG_DATA       0 /* Data register offset                        */
#define REG_CMD_STATUS 1 /* Command/Status register offset              */
#define REG_SIZE_LS    2 /* Size Least Significant byte register offset */
#define REG_SIZE_MS    3 /* Size Most  Significant byte register offset */

/* Status register bits */
#define BIT_DA  BIT7        /* Data Available (from POD) */
#define BIT_FR  BIT6        /* POD Free */
#define BIT_IIR BIT4        /* Initialize Interface Request */
#define BIT_WE  BIT1        /* Write Error */
#define BIT_RE  BIT0        /* Read Error */

/* Command Register bits */
#define BIT_DAIE 0x80       /* Enable Data Available Interrupt  */
#define BIT_FRIE 0x40       /* Enable Pod Free Interrupt */
#define BIT_RS   0x08       /* Reset Interface */
#define BIT_SR   0x04       /* Read Size of data */
#define BIT_SW   0x02       /* Write Size of data */
#define BIT_HC   0x01       /* Host Control wants to write 'flag' */

/**************************  Module State status *******************/

#define MODULE_STATE_OUT            0 /* Module removed -- no POD I/O allowed */
#define MODULE_STATE_UNINITIALIZED  1 /* Module inserted but not initialized yet -- Only initialization I/O is allowed */
#define MODULE_STATE_OK             2 /* Module inserted and initialized -- Full I/O is allowed */
#define MODULE_STATE_RW_ERRORS      3 /* Error occured while reading, not sure what the state is -- test the module */
#define MODULE_STATE_EJECTING       4 /* Module is no longer detected but it had previously been in -- cleanup all POD sessions */
#define MODULE_STATE_DETECTED       5 /* Module has been detected, may or may not actually change state since detection occurs constantly in a polling loop */
#define MODULE_STATE_NOT_A_POD      6 /* PCMCIA card, but not a pod, has been inserted -- flash card? */

/* The above states define the valid values for the bModuleState. */

    extern UINT8 bModuleState;

/**************************  End Module State status *******************/

/* Module status informations */

typedef struct
{
 UINT8   bStatus;
 UINT8   bError;
 UINT8   bType;
 UINT16  wBufSizeData;
 UINT16  wBufSizeExt;
 UINT8   szManufacturer[20]; /* CIS_LGMAX_MANUFAC */
}T_MODULE;

extern UINT16  usChannelSize;              /* Negotiated size of the data channel */
extern UINT16  usExtChannelChannelSize;    /* Negotiated size of the OOB channel */

/* Module type */
#define MODULE_TYPE_NONE   0x00
#define MODULE_TYPE_PCCARD 0x01
#define MODULE_TYPE_POD    0x03
#define MODULE_TYPE_DVB    0x02

/**************************  Module State status *******************/

#define MODULE_STATE_OUT            0 /* Module removed -- no POD I/O allowed */
#define MODULE_STATE_UNINITIALIZED  1 /* Module inserted but not initialized yet -- Only initialization I/O is allowed */
#define MODULE_STATE_OK             2 /* Module inserted and initialized -- Full I/O is allowed */
#define MODULE_STATE_RW_ERRORS      3 /* Error occured while reading, not sure what the state is -- test the module */
#define MODULE_STATE_EJECTING       4 /* Module is no longer detected but it had previously been in -- cleanup all POD sessions */
#define MODULE_STATE_DETECTED       5 /* Module has been detected, may or may not actually change state since detection occurs constantly in a polling loop */
#define MODULE_STATE_NOT_A_POD      6 /* PCMCIA card, but not a pod, has been inserted -- flash card? */




/* Module Access Types */
#define MODULE_ATTRIBUTE_MEMORY_ACCESS    0xF3
#define MODULE_IO_ACCESS                  0xF7
#define MODULE_COMMON_MEMORY_ACCESS       0xFB
#define MODULE_EXTENDED_CHANNEL           0xFF


/* TIMEOUT for acceding the module. */
#define MODULE_TIMEOUT_INIT     5000 /*  */
#define MODULE_TIMEOUT_READ     100   /* 20 ms, maximum value */

/*------------------------------------- Local Types -----------------------------------*/

typedef struct
{
  UINT8   TcId;
  BOOLEAN  bMore;
  UINT8   *pData;
  UINT16  wDataSize;
}T_LPDU;

/* Return Status */
typedef enum
{
    STAT_COMPLETE,
    STAT_PENDING,
    STAT_FAIL,
    STAT_TIMEOUT
} STATUS_T;



/*----------------------------------- Local functions ---------------------------------*/

BOOLEAN POD_ModuleWaitForStatus ( UINT8, UINT8, UINT16);

BOOLEAN POD_ModuleSetAccessMode (UINT8);
  /* Reads the Module's CIS in Memory Mode */
BOOLEAN POD_ModuleGetCis (UINT8 *, UINT8 *);
  /* negotiate the IO data buffer size */
BOOLEAN POD_ModuleNegotiateBufferSize (UINT16*);
  /* inits one module */
BOOLEAN POD_ModuleInit ();
BOOLEAN MPOD_ModuleInit();

/*---------------------------------- Global functions ---------------------------------*/

STATUS_T POD_ModuleReset (Cimax_Handle	*hCimax);
  /* Writes data to the module in I/O Mode */
UINT8 POD_ModuleWrite (UINT8 *, UINT8 *, UINT16);

UINT8 POD_ModuleWriteExtended (UINT8   *pucHeader, UINT8 *pucData, UINT16  usDataLength);

UINT16 POD_ModuleReadLpdu (UINT8, UINT8* );
UINT16 POD_ModuleReadLpduOOB (UINT8, UINT8 *header, UINT8 *pBuf);

STATUS_T POD_ModuleReadExtended (void);

/* Change the Transport stream bypass mode */
STATUS_T POD_ModuleTSBypassModule ( /*Cimax_Handle	*hCimax,*/ BOOLEAN bBypass, UCHAR tuner_id );

/* Resets just the POD interface */

STATUS_T POD_ModuleResetPodInterface (/*Cimax_Handle	*hCimax*/);

/* checks module state when one has been removed/inserted */
BOOLEAN POD_ModuleCheck ();

/* Check POD for the IIR (Initialize Interface Request) bit being set */
BOOLEAN POD_ModuleDetectIIR (void);

UINT16 POD_Module_GetDataBufferSize();
void POD_Module_SetDataBufferSize(UINT16 size);

UINT16 POD_Module_GetExtChBufferSize();

#define CI_LPDU_HEADER_SIZE   2    /* size in byte of a LPDU header */
#define CI_LPDU_HEADER_EXTENDED_SIZE   4    /* size in byte of a LPDU header in extended mode*/

#define CI_LPDU_TCID_BYTE       0
#define CI_LPDU_MORE_LAST_BYTE  1


#define CI_EXT_FIRST_LPDU		0x40
#define CI_EXT_FRAGMENT_LPDU	0x00
#define CI_EXT_LAST_LPDU		0x80


#ifdef __cplusplus
}
#endif

//#endif //MR05_P0 | MR05_P1

#endif // __MODULE_H
