#ifndef WEBPLUGINFACTORYPROTOTYPE_H
#define WEBPLUGINFACTORYPROTOTYPE_H

#include <QWebPluginFactory>

#include <QWidget>
#include <QGraphicsWidget>

#include <QStyleOptionGraphicsItem>
#include <QDebug>
#include <QPainter>

class XREHolePuncherPlugin;
class XREMediaPlayerPlugin;

class WebPluginFactoryPrototype : public QWebPluginFactory
{
    Q_OBJECT

public:
    WebPluginFactoryPrototype(QObject  *parent = 0);

    QObject* create(const QString &mimeType, const QUrl &, const QStringList &argumentNames, const QStringList &argumentValues) const;

    QList<Plugin> plugins() const;

private:

};


class XREHolePuncherPlugin : public QGraphicsWidget
{
    Q_OBJECT

public:
    XREHolePuncherPlugin(QGraphicsItem *parent = 0) : QGraphicsWidget(parent)
    {
        qDebug() << "creating hole punching plugin";
    }

    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget = 0)
    {
        qDebug() << "filling rect : " << option->rect;

        painter->fillRect(option->rect, Qt::red);

    }

};


//QWidget based: not going to be supported (just an example)
class XREMediaPlayerPlugin: public QWidget
{
    Q_OBJECT

public:
    XREMediaPlayerPlugin(QWidget *parent = 0);

    void paintEvent(QPaintEvent * event);

};



#endif // WEBPLUGINFACTORYPROTOTYPE_H
