/*
 * Copyright (C) 2013 TopCoder Inc., All Rights Reserved.
 */

#ifndef QUSERMEDIAPERMISSIONWINDOW_H
#define QUSERMEDIAPERMISSIONWINDOW_H

#include <QtWebKit/qwebkitglobal.h>
#include <QtWebKit/qwebsettings.h>

#include <QtCore/qobject.h>
#include <QtCore/qurl.h>
#include <QtWidgets/qwidget.h>
#include <QDialog>
#include <QComboBox>
#include <QPushButton>
#include <QLabel>
#include <QTableWidget>
#include <QTableWidgetItem>
#include <QString>
#include <QHBoxLayout>
#include <QGridLayout>
#include <QHeaderView>
#include <QVector>
#include <QSharedPointer>
#include <QWebFrame>
#include <QCloseEvent>

class QDevice;
class QWebPage;

class QWEBKITWIDGETS_EXPORT QUserMediaPermissionWindow : public QDialog
{
    Q_OBJECT

public:
    QUserMediaPermissionWindow(QWebPage* webPage, QWebFrame* webFrame, QWidget* parent = 0);
    bool init();

public Q_SLOTS:
    void acceptRequest();
    void denyRequest();
    void audioDeviceChanged(int index);
    void videoDeviceChanged(int index);

protected:
    virtual void closeEvent(QCloseEvent* event);

private:
    QPushButton *createButton(const QString &text, const char *member);
    QComboBox *createComboBox(const char *member);

    QComboBox *m_videoComboBox;
    QComboBox *m_audioComboBox;

    QLabel *m_firstLabel;
    QLabel *m_secondLabel;

    QPushButton *m_yesButton;
    QPushButton *m_noButton;

    QWebPage* m_webPage;
    QWebFrame* m_webFrame;

    QVector< QSharedPointer<QDevice> > m_audioDevices;
    QVector< QSharedPointer<QDevice> > m_videoDevices;

    QSharedPointer<QDevice> m_audioDevice;
    QSharedPointer<QDevice> m_videoDevice;
};


#endif
