# WebRTC Conversational Speech dataset

This dataset includes *conversational speech* and *breathing* recordings,
and the audio files are named
``<langCode>_script<num>_<speakerGender>_sp<speakerId>_<turnId>.wav`` and
``breathing_<speakerGender>_sp<speakerId>_<num>.wav`` respectively.

The conversational speech part consists of *turns*. Each turn belongs to a
*script*, and a script involves two *speakers* named A and B.

The scripts have been designed spanning short and long turns. Also, the scripts
are gender neutral, which allows to let A and B turns be recorded by both male
and female speakers.

All the audio files have a single channel and a sample rate of 48000 Hz with 16
bit samples.

## English scripts (EN)
### Script 1
- A1: How is your day going?
- B1: Quite busy. I'm preparing for my presentation on our marketing strategy.
- A2: You must feel stressed out now.
- B2: That's an understatement.
### Script 2
- A1: Which book are you reading?
- B1: Let’s see if you can guess it, listen carefully. She tries to open the
doors. They are all locked; she begins to weep. She walks weeping to a high
glass table and sits down on its lower ledge. She sits on a big golden key and
picks it up in surprise. She tries it on all the doors but it does not fit.
- A2: Too hard, yet another hint.
- B2: Ok. “Would you tell me, please, which way I ought to go from here?” “That
depends a good deal on where you want to get to”, said the Cat. “I don't much
care where” she replied.
- A3: Stop, I know the rest! “Then it doesn't matter which way you go”, said the
Cat. “So long as I get somewhere” she added as an explanation. “Oh, you're sure
to do that, if you only walk long enough.”
- B3: So, what’s the title?
- A4: Alice in Wonderland!
- B4: Well done
## Swedish scripts (SE)
### Script 1
- A1: Hur är det?
- B1: Rätt upptagen. Jag förbereder mig inför min presentation om
marknadsföringsstrategi.
- A2: Då är du säkert riktigt stressad nu.
- B2: Det skulle man kunna säga.
### Script 2
- A1: Vilken bok läser du?
- B1: Jag ska läsa högt för dig. Försök gissa nu! “Dörren är ändå alldeles för
liten för mig. Och jag kan ju inte flyga upp igenom kaninhålet. Hon får syn på
en flaska på bordet. Drick mig. Bäst att vara försiktig. Om man dricker en
flaska där det står gift så får man nog ångra det förr eller senare. Men det
står ju bara drick mig.”
- A2: Det är för svårt! Får jag försöka igen?
- B2: Ok. “Åt vilket håll ska jag gå?” “Det beror på vart du vill komma”, sa
katten. “Det spelar ingen roll.” svarade hon.
- A3: Sluta, jag kan fortsättningen: “Då spelar det heller ingen roll åt vilket
håll du går." sa katten.
“…så länge som jag kommer någonstans”, fortsatte hon. “Åh, det kommer du att
göra”, sa katten, “bara du går tillräckligt långt”.
- B3: Så vad heter boken?
- A4: Alice i Underlandet
- B4: Jättebra
