# -*- coding: utf-8 -*-
# Generated by Django 1.11.20 on 2019-03-26 20:30
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Build',
            fields=[
                ('uid', models.TextField(primary_key=True, serialize=False)),
                ('builder_id', models.IntegerField()),
                ('builder_name', models.TextField()),
                ('builder_display_name', models.TextField()),
                ('number', models.IntegerField()),
                ('result', models.IntegerField(blank=True, null=True)),
                ('state_string', models.TextField()),
                ('started_at', models.IntegerField(blank=True, null=True)),
                ('complete_at', models.IntegerField(blank=True, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='BuildbotInstance',
            fields=[
                ('instance_id', models.AutoField(primary_key=True, serialize=False)),
                ('hostname', models.TextField()),
                ('active', models.BooleanField(default=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='Patch',
            fields=[
                ('patch_id', models.IntegerField(primary_key=True, serialize=False)),
                ('bug_id', models.IntegerField()),
                ('obsolete', models.BooleanField(default=False)),
                ('sent_to_buildbot', models.BooleanField(default=False)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='Step',
            fields=[
                ('uid', models.TextField(primary_key=True, serialize=False)),
                ('result', models.IntegerField(blank=True, null=True)),
                ('state_string', models.TextField()),
                ('started_at', models.IntegerField(blank=True, null=True)),
                ('complete_at', models.IntegerField(blank=True, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('build_uid', models.ForeignKey(db_column='build_uid', db_constraint=False, on_delete=django.db.models.deletion.CASCADE, to='ews.Build')),
            ],
        ),
        migrations.AddField(
            model_name='build',
            name='patch',
            field=models.ForeignKey(db_constraint=False, on_delete=django.db.models.deletion.CASCADE, to='ews.Patch'),
        ),
    ]
