/******************************************************************************
 *  Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors.
 *  Copyright (C) 2017 Broadcom. The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
 *
 *  This program is the proprietary software of Broadcom and/or its licensors,
 *  and may only be used, duplicated, modified or distributed pursuant to the terms and
 *  conditions of a separate, written license agreement executed between you and Broadcom
 *  (an "Authorized License").  Except as set forth in an Authorized License, Broadcom grants
 *  no license (express or implied), right to use, or waiver of any kind with respect to the
 *  Software, and Broadcom expressly reserves all rights in and to the Software and all
 *  intellectual property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU
 *  HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY
 *  NOTIFY BROADCOM AND DISCONTINUE ALL USE OF THE SOFTWARE.
 *
 *  Except as expressly set forth in the Authorized License,
 *
 *  1.     This program, including its structure, sequence and organization, constitutes the valuable trade
 *  secrets of Broadcom, and you shall use all reasonable efforts to protect the confidentiality thereof,
 *  and to use this information only in connection with your use of Broadcom integrated circuit products.
 *
 *  2.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
 *  AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
 *  WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH RESPECT TO
 *  THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND ALL IMPLIED WARRANTIES
 *  OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE,
 *  LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION
 *  OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF
 *  USE OR PERFORMANCE OF THE SOFTWARE.
 *
 *  3.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR ITS
 *  LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL, INDIRECT, OR
 *  EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY RELATING TO YOUR
 *  USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM HAS BEEN ADVISED OF
 *  THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT
 *  ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE
 *  LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF
 *  ANY LIMITED REMEDY.
 ******************************************************************************/

#ifndef __VL_HAL_SNMP_HDMI_INTERFACE_H__
#define __VL_HAL_SNMP_HDMI_INTERFACE_H__

#include "SnmpIORM.h"

#ifdef __cplusplus
extern "C" {
#endif

#define MAXCHARLEN	256

typedef enum
{
	HDCP_DEVICE_STATUS_NON_COMPLIANT,
	HDCP_DEVICE_STATUS_COMPLIANT,
	HDCP_DEVICE_STATUS_REVOKED,
	HDCP_DEVICE_STATUS_RESERVED
}HDCP_DEVICE_STATUS;

typedef enum
{
	HDMI_AVIFRAME_COLOR_SPACE_RGB = 0,
	HDMI_AVIFRAME_COLOR_SPACE_YCbCr422,
	HDMI_AVIFRAME_COLOR_SPACE_YCbCr444,
	HDMI_AVIFRAME_COLOR_SPACE_RSVD

}HDMI_AVIFRAME_COLOR_SPACE;

typedef enum
{
   AUDIO_FMT_MPEG12,  /* MPEG layer 1 and layer 2*/
   AUDIO_FMT_MPEG2,
   AUDIO_FMT_MP3,     /* MPEG Layer 3        */
   AUDIO_FMT_AAC,     /* Advanced Audio Coding. Part of MPEG-4 */
   AUDIO_FMT_AAC_PLUS,/* AAC plus SBR. aka MPEG-4 High Efficiency (AAC-HE) */
   AUDIO_FMT_AC3,     /* Dolby Digital AC3 audio */
   AUDIO_FMT_AC3_PLUS,     /* Dolby Digital Plus or Enhanced AC3 audio */
   AUDIO_FMT_DTS,      /* Digital Surround sound. */
   AUDIO_FMT_ATRAC,
   AUDIO_FMT_LPCM,      /*PULSE CODE MODULATION. */
   AUDIO_FMT_OTHER
} AUDIO_FMT_t;

typedef enum
{
	AUDIO_Sample_Rate_32kHz,
	AUDIO_Sample_Rate_44kHz,
	AUDIO_Sample_Rate_48kHz,
	AUDIO_Sample_Rate_88kHz,
	AUDIO_Sample_Rate_96kHz,
	AUDIO_Sample_Rate_176kHz,
	AUDIO_Sample_Rate_192kHz,
	AUDIO_Sample_Rate_Other
} AUDIO_Sample_Rate_t;

typedef enum
{
	AUDIO_Sample_Size_Unknown = 0,
    	AUDIO_Sample_Size_16,
    	AUDIO_Sample_Size_20,
    	AUDIO_Sample_Size_24
}AUDIO_Sample_Size;

typedef enum
{
    VIDEO_Frame_Rate_unknown = 0,
    VIDEO_Frame_Rate_23_976,
    VIDEO_Frame_Rate_24,
    VIDEO_Frame_Rate_25,
    VIDEO_Frame_Rate_29_97,
    VIDEO_Frame_Rate_30,
    VIDEO_Frame_Rate_50,
    VIDEO_Frame_Rate_59_94,
    VIDEO_Frame_Rate_60,
    VIDEO_Frame_Rate_14_985,
#ifndef LEGACY_NEUXS
    VIDEO_Frame_Rate_7_493,
#else
    VIDEO_Frame_Rate_7_943,
#endif // LEGACY_NEUXS
    VIDEO_Frame_Rate_Max

}VIDEO_Frame_Rate;

typedef enum
{
	ASPECT_RATIO_UNKNOWN = -1,
	ASPECT_RATIO_4_3 = 2,
	ASPECT_RATIO_16_9,
	ASPECT_RATIO_2_21_1,
	MAX_ASPECT_RATIO
}DISPLAY_ASPECT_RATIO_t ;

typedef enum
{
	DISP_FORMAT_480I,		/* 720x480i */
	DISP_FORMAT_480P,		/* 720x480p */
	DISP_FORMAT_720P,		/* 1280x720p */
	DISP_FORMAT_1080I,		/* 1920x1080i */
	DISP_FORMAT_1080P,		/* 1920x1080p 60HZ*/
	DISP_FORMAT_1080P_24HZ, /* 1920x1080p 24HZ*/
	DISP_FORMAT_1080P_30HZ, /* 1920x1080p 30HZ*/
	DISP_FORMAT_2160P, /* 3840x2160p 60HZ*/
	DISP_FORMAT_2160P_30HZ, /* 3840x2160p 30HZ*/
	DISP_FORMAT_PassThru,   /* Pass through mode*/
	DISP_INVALID_FORMAT,
	DISP_MAX_DISPLAY_FORMAT
}DISPLAY_FORMAT_t ;


typedef struct
{
	unsigned char		 isHdmi;
	unsigned long          	 index;
	unsigned long            outputType;
	unsigned long            connStatus;
	unsigned long            repStatus;
	unsigned long            videoXmisStatus;
        unsigned long            hdcpStatus;
	unsigned long            videoMuteStatus;
	DISPLAY_FORMAT_t         videoFormat;
	DISPLAY_ASPECT_RATIO_t   aspectRatio;
    unsigned char            bHDCPEnabled;
    HDCP_DEVICE_STATUS       connectedDeviceHDCPStatus;
	AUDIO_FMT_t              audioFormat;
	AUDIO_Sample_Rate_t      audioSampleRate;
	unsigned long          	 audioChanCount;
	unsigned long            audioMuteStatus;
	AUDIO_Sample_Size        audioSampleSize;
	HDMI_AVIFRAME_COLOR_SPACE   colorSpace;

    //Video format related
    int                     horizontal_lines;
    int                     vertical_lines;
	VIDEO_Frame_Rate         videoFrameRate;
    unsigned char           bInterlaced;

	unsigned long            attachedDevType;
	unsigned char            edid[3*MAXCHARLEN];
	unsigned int          	 edid_len;
	unsigned long            lipSyncDelay;
	unsigned char            cecFeatures[MAXCHARLEN];
	unsigned int          	 cecFeatures_len;
	unsigned char            features[MAXCHARLEN];
	unsigned int          	 features_len;
	unsigned long            maxDevCount;
	
}SNMP_INTF_DVIHDMI_Info;


unsigned int HAL_SNMP_Get_DviHdmi_info(SNMP_INTF_DVIHDMI_Info* ptDviHdmiInfo);
unsigned int HAL_SNMP_ocStbHostDVIHDMIVideoFormatTableData(SNMPocStbHostDVIHDMIVideoFormatTable_t* vl_DVIHDMIVideoFormatTable, int *pnCount);

void vl_Get_DviHdmi_info(SNMP_INTF_DVIHDMI_Info* ptDviHdmiInfo);

#ifdef __cplusplus
}
#endif

#endif
