/******************************************************************************
 *  Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors.
 *  Copyright (C) 2017 Broadcom. The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
 *
 *  This program is the proprietary software of Broadcom and/or its licensors,
 *  and may only be used, duplicated, modified or distributed pursuant to the terms and
 *  conditions of a separate, written license agreement executed between you and Broadcom
 *  (an "Authorized License").  Except as set forth in an Authorized License, Broadcom grants
 *  no license (express or implied), right to use, or waiver of any kind with respect to the
 *  Software, and Broadcom expressly reserves all rights in and to the Software and all
 *  intellectual property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU
 *  HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY
 *  NOTIFY BROADCOM AND DISCONTINUE ALL USE OF THE SOFTWARE.
 *
 *  Except as expressly set forth in the Authorized License,
 *
 *  1.     This program, including its structure, sequence and organization, constitutes the valuable trade
 *  secrets of Broadcom, and you shall use all reasonable efforts to protect the confidentiality thereof,
 *  and to use this information only in connection with your use of Broadcom integrated circuit products.
 *
 *  2.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
 *  AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
 *  WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH RESPECT TO
 *  THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND ALL IMPLIED WARRANTIES
 *  OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE,
 *  LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION
 *  OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF
 *  USE OR PERFORMANCE OF THE SOFTWARE.
 *
 *  3.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR ITS
 *  LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL, INDIRECT, OR
 *  EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY RELATING TO YOUR
 *  USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM HAS BEEN ADVISED OF
 *  THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT
 *  ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE
 *  LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF
 *  ANY LIMITED REMEDY.
 ******************************************************************************/

#include "vlHalSnmpTunerInterface.h"
//#include "vlMpeosTunerImpl.h"
#include "rdk_debug.h"
#include "string.h"
#include "vlHalSnmpUtils.h"
#include "QAMSrcDiag.h"
#include "rmf_qamsrc_common.h"

#include "nexus_frontend.h"
#ifdef LEGACY_NEXUS
#include "nexus_frontend_3255.h"
#endif
#include "nexus_platform.h"
#include "nexus_timebase.h"

#include<stdlib.h>
#ifdef USE_POD_IPC
#include "rmf_osal_ipc.h"
#endif
#include "ipcclient_impl.h"

#ifdef USE_POD_IPC	
#define POD_HAL_SERVICE_CMD_DFLT_PORT_NO 50509
#define POD_HAL_SERVER_CMD_GET_TUNER_INFO 1
#define POD_HAL_SERVER_CMD_GET_TUNER_COUNT 2
#endif

#define TUNER_FREQ_RANGE_MIN    (55000000)
//#define TUNER_FREQ_RANGE_MAX    (996000000)
#define TUNER_FREQ_RANGE_MAX    (1002000000)

static int asyncQamStatus_dsChannelPower = 0; /* BPV-2678 */

#ifdef LEGACY_NEXUS
static void vlhal_QamStatusCallback(void *context, int param)
{
    NEXUS_FrontendHandle    frontend = (NEXUS_FrontendHandle)context;
    NEXUS_Error             err = NEXUS_SUCCESS;
    NEXUS_FrontendQamStatus qamStatus;

    BSTD_UNUSED(param);
    RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SNMP", "%s: begin\n", __FUNCTION__);
    err = NEXUS_Frontend_3255_GetAsyncQamStatus(frontend, &qamStatus);
    if (err != NEXUS_SUCCESS)
    {
        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.SNMP", "%s: error %d returned from call to NEXUS_Frontend_3255_GetAsyncQamStatus\n",
                 __FUNCTION__, err);
    }
    asyncQamStatus_dsChannelPower = qamStatus.dsChannelPower;
    RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SNMP", "%s: asyncQamStatus_dsChannelPower set to %d\n", __FUNCTION__,
            asyncQamStatus_dsChannelPower);
}
#endif

#ifdef USE_POD_IPC
unsigned int sendCMDGetTunerInfo( uint32_t tunerIndex, TunerData* tunerData )
{
	rmf_Error ret = RMF_SUCCESS;
	int32_t result_recv = 0;
	int8_t res = 0;
	const char *hal_port;	
	uint16_t pod_hal_service_cmd_port_no = 0;
	
	hal_port = rmf_osal_envGet( "POD_HAL_SERVICE_CMD_PORT_NO" );
	if( NULL == hal_port)
	{
		RDK_LOG( RDK_LOG_ERROR, "LOG.RDK.SNMP", "%s: NULL POINTER  received for name string\n", __FUNCTION__ );
		return RMF_OSAL_EINVAL;
	}
	pod_hal_service_cmd_port_no = atoi( hal_port );
	
	IPCBuf ipcBuf = IPCBuf( ( uint32_t ) POD_HAL_SERVER_CMD_GET_TUNER_INFO);		
	result_recv |= ipcBuf.addData( ( const void * ) &tunerIndex, sizeof( tunerIndex ) );
	
	if( result_recv < 0)
	{
		RDK_LOG( RDK_LOG_ERROR, "LOG.RDK.POD", 
			"\nPOD Comm add data failed in %s:%d: %d\n",
				 __FUNCTION__, __LINE__ , result_recv);	
		return RMF_OSAL_ENODATA;			
	}	

	res = ipcBuf.sendCmd( pod_hal_service_cmd_port_no );
	if ( 0 != res )
	{
		RDK_LOG( RDK_LOG_ERROR, "LOG.RDK.POD", 
			"POD Comm failure in %s:%d: ret = %d\n",
				 __FUNCTION__, __LINE__, res );
		return RMF_OSAL_ENODATA;
	}	
	
	result_recv = ipcBuf.getResponse( &ret );
	if( result_recv < 0)
	{
		RDK_LOG( RDK_LOG_ERROR, "LOG.RDK.POD", 
			"POD Comm get response failed in %s:%d ret = %d\n",
				 __FUNCTION__, __LINE__, result_recv );	
		return RMF_OSAL_ENODATA;			
	}
	result_recv = ipcBuf.collectData(tunerData, sizeof(TunerData));
	if( result_recv < 0)
	{
		RDK_LOG( RDK_LOG_ERROR, "LOG.RDK.POD", 
			"POD Comm get response failed in %s:%d ret = %d\n",
				 __FUNCTION__, __LINE__, result_recv );	
		return RMF_OSAL_ENODATA;			
	}	
	return ret;

}
#endif

static NEXUS_PlatformConfiguration s_platformConfig;
static int is_platformconfig_set = 0;

unsigned int HAL_SNMP_Get_Tuner_Info(void* ptSnmpHALTunerInfo, unsigned long tunerIndex)
{
    NEXUS_Error err = NEXUS_SUCCESS;
    NEXUS_FrontendHandle frontend = NULL;
    SNMP_INTF_TUNER_INFO_t *objSnmpHALTunerInfo=(SNMP_INTF_TUNER_INFO_t *)ptSnmpHALTunerInfo;
    TunerData tuneParams;

    /* Ensure everything is 0 */
    memset(objSnmpHALTunerInfo, 0, sizeof(SNMP_INTF_TUNER_INFO_t));

    /* Get the platform config once */
    if ( !is_platformconfig_set )  {
        NEXUS_Platform_GetConfiguration(&s_platformConfig);
        is_platformconfig_set = 1;
    }

    /* Get tuner info and initialize what we can */
#ifdef USE_POD_IPC
    if (sendCMDGetTunerInfo(tunerIndex, &tuneParams) != RMF_SUCCESS)
#else
    if (getTunerInfo(tunerIndex, &tuneParams) != RMF_SUCCESS)
#endif
    {
        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.SNMP", "%s: Unable to get info for tuner %d\n", __FUNCTION__, tunerIndex);
        return true; /* We should return false here (indicate failure) but the code calling this fuction doesn't seem to handle this well. For now we will return success */
    }

    objSnmpHALTunerInfo->tunerIndex = tunerIndex;
    objSnmpHALTunerInfo->enTunerMode = (tuneParams.modulation == RMF_MODULATION_QAM_NTSC) ? TUNER_ANALOG : (SNMP_INTF_TUNER_MODE_t)tuneParams.modulation;
    objSnmpHALTunerInfo->ulFrequency = tuneParams.frequency*1000;
    objSnmpHALTunerInfo->totalTuneCount = tuneParams.totalTuneCount; //tunerData;
    objSnmpHALTunerInfo->tuneFailCount = tuneParams.tuneFailCount; //tunerData;
    objSnmpHALTunerInfo->lastTuneFailFreq = tuneParams.lastTuneFailFreq; //tunerData;
    objSnmpHALTunerInfo->lockedTimeInSecs = tuneParams.lockedTimeInSecs; //tunerData;
    objSnmpHALTunerInfo->carrierLockLostCount = tuneParams.carrierLockLostCount; //tunerData;

    frontend = s_platformConfig.frontend[tunerIndex];
    if (objSnmpHALTunerInfo->totalTuneCount==0) {
        /* If we haven't tried to tune yet the tuner is unlocked */
        objSnmpHALTunerInfo->enLockStatus = TUNER_DEVICE_UNLOCKED;
    }
    else if (!frontend) {
        /* If we don't have a frontend, assign the lock status based on tunerinfo */
        switch(tuneParams.tunerState)
        {
        case TUNER_STATE_TUNED_NOSYNC:
            objSnmpHALTunerInfo->enLockStatus = TUNER_DEVICE_UNLOCKED;
            break;
        case TUNER_STATE_TUNED_SYNC:
            objSnmpHALTunerInfo->enLockStatus = TUNER_DEVICE_LOCKED;
            break;
        default:
            objSnmpHALTunerInfo->enLockStatus = TUNER_DEVICE_TIMEOUT;
            break;
        }
    }
    else {
        /* If we have a Nexus frontend tuner, and have made at least one tune, get the status */
        NEXUS_FrontendQamStatus qamStatus;

        /* Try to get async if available */
        err = NEXUS_Frontend_RequestQamAsyncStatus(frontend);
        if (err == NEXUS_SUCCESS) {
            RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SNMP","%s: Getting **asynchronous** status for %d:%p\n", __FUNCTION__, tunerIndex, frontend );
            usleep(100*1000);
            err = NEXUS_Frontend_GetQamAsyncStatus(frontend, &qamStatus );
            if (err != NEXUS_SUCCESS) {
                RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.SNMP", "%s: error %d returned from call to NEXUS_Frontend_GetQamAsyncStatus\n", __FUNCTION__, err);
                return true; /* We should return false here (indicate failure) but the code calling this fuction doesn't seem to handle this well. For now we will return success */
            }
        }
        else if (err == BERR_NOT_SUPPORTED) {
            /* Async is not available, fall back to synchronous */
            RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SNMP","%s: Getting **synchronous** status for %d:%p\n", __FUNCTION__, tunerIndex, frontend );
            err = NEXUS_Frontend_GetQamStatus(frontend, &qamStatus );
            if (err != NEXUS_SUCCESS) {
                RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.SNMP", "%s: error %d returned from call to NEXUS_Frontend_GetQamStatus\n", __FUNCTION__, err);
                return true; /* We should return false here (indicate failure) but the code calling this fuction doesn't seem to handle this well. For now we will return success */
            }
        }
        else {
            RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.SNMP", "%s: error %d returned from call to NEXUS_Frontend_RequestQamAsyncStatus\n", __FUNCTION__, err);
            return true; /* We should return false here (indicate failure) but the code calling this fuction doesn't seem to handle this well. For now we will return success */
        }

        objSnmpHALTunerInfo->enLockStatus = qamStatus.receiverLock ? TUNER_DEVICE_LOCKED : TUNER_DEVICE_UNLOCKED;
        if (objSnmpHALTunerInfo->enLockStatus == TUNER_DEVICE_LOCKED) {
            NEXUS_TimebaseStatus tbStatus;

            objSnmpHALTunerInfo->enLockStatus = TUNER_DEVICE_LOCKED;
            objSnmpHALTunerInfo->stFEC_Status.ulTimeForBER = 0;
            objSnmpHALTunerInfo->ulRangeMin = TUNER_FREQ_RANGE_MIN;
            objSnmpHALTunerInfo->ulRangeMax = TUNER_FREQ_RANGE_MAX;
            objSnmpHALTunerInfo->bandwidthCode = BandWidth_mHz1002;
            objSnmpHALTunerInfo->ulPTSErrors = 0; // getPTSErrorCount(); // TODO: SS-POD Find the proper PTS Rate
            objSnmpHALTunerInfo->ulTotalExtChBytesRead = 0;
            if (NEXUS_Timebase_GetStatus(NEXUS_Timebase_e0, &tbStatus) == NEXUS_SUCCESS) {
                objSnmpHALTunerInfo->ulPCRErrors = tbStatus.pcrCount;
            }
            else {
                RDK_LOG(RDK_LOG_WARN, "LOG.RDK.SNMP", "%s: Failed calling NEXUS_Timebase_GetStatus!\n", __FUNCTION__);
            }

            /* Initialize based on qamStatus */
            objSnmpHALTunerInfo->ulPower = qamStatus.dsChannelPower;
            objSnmpHALTunerInfo->stFEC_Status.ulCorrBytes = qamStatus.fecCorrected;
            objSnmpHALTunerInfo->stFEC_Status.ulUnCorrBlocks = qamStatus.fecUncorrected;
            objSnmpHALTunerInfo->stFEC_Status.ulUnerroreds = qamStatus.fecClean;
            objSnmpHALTunerInfo->ulAGC = qamStatus.digitalAgcGain/100;
            objSnmpHALTunerInfo->ulSNR = qamStatus.snrEstimate/10;
            objSnmpHALTunerInfo->ulInterleaver = (qamStatus.interleaveDepth == 0) ? 1 : qamStatus.interleaveDepth;
            objSnmpHALTunerInfo->ulEqGain = qamStatus.equalizerGain;
            objSnmpHALTunerInfo->ulMainTapCoeff = qamStatus.mainTap;

            {
                #define BIT_ERROR_CONVERSION (float)2147483648.0
                #define BER_10eneg2          (float)1.35335283
                #define BER_10eneg4          (float)0.18315639
                #define BER_10eneg6          (float)0.02478752
                #define BER_10eneg8          (float)0.00335463
                #define BER_10eneg12         (float)0.00006144

                float fBer ;
                fBer = (float)qamStatus.viterbiErrorRate / BIT_ERROR_CONVERSION ;
                if (fBer <= BER_10eneg12)
                {
                    objSnmpHALTunerInfo->ulBER = berEqualToOrLessThan10e12 ;
                }
                else if((fBer > BER_10eneg12) && (fBer <= BER_10eneg8))
                {
                    objSnmpHALTunerInfo->ulBER = berRange10e8ToGreaterThan10e12 ;
                }
                else if((fBer > BER_10eneg8) && (fBer <= BER_10eneg6))
                {
                    objSnmpHALTunerInfo->ulBER = berRange10e6ToGreaterThan10e8 ;
                }
                else if((fBer > BER_10eneg6) && (fBer <= BER_10eneg4))
                {
                    objSnmpHALTunerInfo->ulBER = berRange10e4ToGreaterThan10e6 ;
                }
                else if((fBer > BER_10eneg4) && (fBer <= BER_10eneg2))
                {
                    objSnmpHALTunerInfo->ulBER = berRange10e2ToGreaterThan10e4 ;
                }
                else if(fBer > BER_10eneg2)
                {
                    objSnmpHALTunerInfo->ulBER = berGreaterThan10e2 ;
                }
            }
        }
    }
    
#ifdef LEGACY_NEXUS
    NEXUS_CallbackDesc infoCb;

    infoCb.callback = vlhal_QamStatusCallback;
    infoCb.context  = frontend;

    if (tuneParams.tunerState == TUNER_STATE_TUNED_SYNC)
    {
        RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SNMP", "%s: call NEXUS_Frontend_3255_RequestAsyncQamStatus\n", __FUNCTION__);
        err = NEXUS_Frontend_3255_RequestAsyncQamStatus(frontend, &infoCb);
    }
    else
    {
        RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SNMP",
                "%s: do not call NEXUS_Frontend_3255_RequestAsyncQamStatus as tunerStatus is not MPE_TUNE_SYNC\n",
                __FUNCTION__);
    }

    if (err != NEXUS_SUCCESS)
    {
        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.SNMP",
                 "%s: error %d returned from call to NEXUS_Frontend_3255_RequestAsyncQamStatus\n",
                 __FUNCTION__, err);
    }
#endif

    #define DUMP_INFO_LEVEL RDK_LOG_DEBUG
    RDK_LOG(DUMP_INFO_LEVEL, "LOG.RDK.SNMP", "************  Returning status for tuner %d ************\n", tunerIndex);
    RDK_LOG(DUMP_INFO_LEVEL, "LOG.RDK.SNMP", "tunerIndex:%d\n", objSnmpHALTunerInfo->tunerIndex);
    RDK_LOG(DUMP_INFO_LEVEL, "LOG.RDK.SNMP", "enLockStatus:%s\n", (objSnmpHALTunerInfo->enLockStatus == TUNER_DEVICE_LOCKED) ? "LOCKED" : (objSnmpHALTunerInfo->enLockStatus == TUNER_DEVICE_UNLOCKED) ? "UNLOCKED" : "TIMEOUT");
    RDK_LOG(DUMP_INFO_LEVEL, "LOG.RDK.SNMP", "enTunerMode:%d\n", objSnmpHALTunerInfo->enTunerMode);
    RDK_LOG(DUMP_INFO_LEVEL, "LOG.RDK.SNMP", "ulFrequency:%d\n", objSnmpHALTunerInfo->ulFrequency);
    RDK_LOG(DUMP_INFO_LEVEL, "LOG.RDK.SNMP", "ulRangeMin:%d\n", objSnmpHALTunerInfo->ulRangeMin);
    RDK_LOG(DUMP_INFO_LEVEL, "LOG.RDK.SNMP", "ulRangeMax:%d\n", objSnmpHALTunerInfo->ulRangeMax);
    RDK_LOG(DUMP_INFO_LEVEL, "LOG.RDK.SNMP", "ulAGC:%d\n", objSnmpHALTunerInfo->ulAGC);
    RDK_LOG(DUMP_INFO_LEVEL, "LOG.RDK.SNMP", "ulSNR:%d\n", objSnmpHALTunerInfo->ulSNR);
    RDK_LOG(DUMP_INFO_LEVEL, "LOG.RDK.SNMP", "ulBER:%d\n", objSnmpHALTunerInfo->ulBER);
    RDK_LOG(DUMP_INFO_LEVEL, "LOG.RDK.SNMP", "ulPower:%d\n", objSnmpHALTunerInfo->ulPower);
    RDK_LOG(DUMP_INFO_LEVEL, "LOG.RDK.SNMP", "ulInterleaver:%d\n", objSnmpHALTunerInfo->ulInterleaver);
    RDK_LOG(DUMP_INFO_LEVEL, "LOG.RDK.SNMP", "ulEqGain:%d\n", objSnmpHALTunerInfo->ulEqGain);
    RDK_LOG(DUMP_INFO_LEVEL, "LOG.RDK.SNMP", "ulMainTapCoeff:%d\n", objSnmpHALTunerInfo->ulMainTapCoeff);
    RDK_LOG(DUMP_INFO_LEVEL, "LOG.RDK.SNMP", "ulPCRErrors:%d\n", objSnmpHALTunerInfo->ulPCRErrors);
    RDK_LOG(DUMP_INFO_LEVEL, "LOG.RDK.SNMP", "ulPTSErrors:%d\n", objSnmpHALTunerInfo->ulPTSErrors);
    RDK_LOG(DUMP_INFO_LEVEL, "LOG.RDK.SNMP", "totalTuneCount:%d\n", objSnmpHALTunerInfo->totalTuneCount);
    RDK_LOG(DUMP_INFO_LEVEL, "LOG.RDK.SNMP", "tuneFailCount:%d\n", objSnmpHALTunerInfo->tuneFailCount);
    RDK_LOG(DUMP_INFO_LEVEL, "LOG.RDK.SNMP", "lastTuneFailFreq:%d\n", objSnmpHALTunerInfo->lastTuneFailFreq);
    RDK_LOG(DUMP_INFO_LEVEL, "LOG.RDK.SNMP", "lockedTimeInSecs:%d\n", objSnmpHALTunerInfo->lockedTimeInSecs);
    RDK_LOG(DUMP_INFO_LEVEL, "LOG.RDK.SNMP", "carrierLockLostCount:%d\n", objSnmpHALTunerInfo->carrierLockLostCount);
    RDK_LOG(DUMP_INFO_LEVEL, "LOG.RDK.SNMP", "bandwidthCode:%d\n", objSnmpHALTunerInfo->bandwidthCode);
    RDK_LOG(DUMP_INFO_LEVEL, "LOG.RDK.SNMP", "ulTotalExtChBytesRead:%d\n", objSnmpHALTunerInfo->ulTotalExtChBytesRead);
    RDK_LOG(DUMP_INFO_LEVEL, "LOG.RDK.SNMP", "ulCorrBytes:%d\n", objSnmpHALTunerInfo->ulCorrBytes);
    RDK_LOG(DUMP_INFO_LEVEL, "LOG.RDK.SNMP", "ulUnCorrBlocks:%d\n", objSnmpHALTunerInfo->ulUnCorrBlocks);
    RDK_LOG(DUMP_INFO_LEVEL, "LOG.RDK.SNMP", "ulUnerroreds:%d\n", objSnmpHALTunerInfo->ulUnerroreds);
    RDK_LOG(DUMP_INFO_LEVEL, "LOG.RDK.SNMP", "channelMapId:%d\n", objSnmpHALTunerInfo->channelMapId);
    RDK_LOG(DUMP_INFO_LEVEL, "LOG.RDK.SNMP", "dacId:%d\n", objSnmpHALTunerInfo->dacId);
    RDK_LOG(DUMP_INFO_LEVEL, "LOG.RDK.SNMP", "stFEC_Status.ulCorrBytes:%d\n", objSnmpHALTunerInfo->stFEC_Status.ulCorrBytes);
    RDK_LOG(DUMP_INFO_LEVEL, "LOG.RDK.SNMP", "stFEC_Status.ulUnCorrBlocks:%d\n", objSnmpHALTunerInfo->stFEC_Status.ulUnCorrBlocks);
    RDK_LOG(DUMP_INFO_LEVEL, "LOG.RDK.SNMP", "stFEC_Status.ulUnerroreds:%d\n", objSnmpHALTunerInfo->stFEC_Status.ulUnerroreds);
    RDK_LOG(DUMP_INFO_LEVEL, "LOG.RDK.SNMP", "stFEC_Status.ulTimeForBER:%d\n", objSnmpHALTunerInfo->stFEC_Status.ulTimeForBER);
    RDK_LOG(DUMP_INFO_LEVEL, "LOG.RDK.SNMP", "%s: *******************************************************\n\n", __FUNCTION__);
    RDK_LOG(DUMP_INFO_LEVEL, "LOG.RDK.SNMP", "%s: Channel Map ID = %d, Dac ID = %d\n", __FUNCTION__, objSnmpHALTunerInfo->channelMapId, objSnmpHALTunerInfo->dacId);
    return true;
}

unsigned int HAL_SNMP_Get_Tuner_Count(unsigned int* ptTunerCount)
{
	unsigned int retStatus=0;
        
        *ptTunerCount = 0;

#ifdef USE_POD_IPC
        int32_t result_recv = 0;
        int8_t res = 0;

	const char *hal_port;	
	uint32_t pod_hal_service_cmd_port_no = 0;
	
	hal_port = rmf_osal_envGet( "POD_HAL_SERVICE_CMD_PORT_NO" );
	if( NULL == hal_port)
	{
		RDK_LOG( RDK_LOG_ERROR, "LOG.RDK.SNMP", "%s: NULL POINTER  received for name string\n", __FUNCTION__ );
		return RMF_OSAL_EINVAL;
	}
	pod_hal_service_cmd_port_no = atoi( hal_port );
        IPCBuf ipcBuf = IPCBuf( ( uint32_t ) POD_HAL_SERVER_CMD_GET_TUNER_COUNT);
	res = ipcBuf.sendCmd( pod_hal_service_cmd_port_no );
        if ( 0 != res )
        {
                RDK_LOG( RDK_LOG_ERROR, "LOG.RDK.SNMP",
                        "POD Comm failure in %s:%d: ret = %d\n",
                                 __FUNCTION__, __LINE__, res );
                return 0;
        }

        result_recv = ipcBuf.getResponse( ptTunerCount );
        if( result_recv < 0)
        {
                RDK_LOG( RDK_LOG_ERROR, "LOG.RDK.SNMP",
                        "POD Comm get response failed in %s:%d ret = %d\n",
                                 __FUNCTION__, __LINE__, result_recv );
                return 0;
        }
#else
        *ptTunerCount = getTunerCount();
#endif
	RDK_LOG( RDK_LOG_DEBUG, "LOG.RDK.SNMP",
			"*ptTunerCount in %s:%d ret = %d\n",
			__FUNCTION__, __LINE__, *ptTunerCount );
        
        return *ptTunerCount;
}
