 /******************************************************************************
* Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors. 
* All rights reserved.
*
* This software is the confidential and proprietary information of SeaChange
* ("Confidential Information"). You shall not disclose this source code or 
* such Confidential Information and shall use it only in accordance with the 
* terms of the license agreement you entered into.
*  
* SEACHANGE INERNATIONAL  MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
* SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT 
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SEACHANGE SHALL NOT BE LIABLE FOR 
* ANY DAMAGES SUFFERED BY LICENSEE NOR SHALL THEY BE RESPONSIBLE AS A RESULT 
* OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*******************************************************************************/

#ifndef __FPD_DEFS_H__
#define __FPD_DEFS_H__

#ifdef __cplusplus
extern "C" {
#endif

typedef enum _FPD_API_RESULT
{
    FPD_API_RESULT_SUCCESS = 0,
    FPD_API_RESULT_FAILED,
    FPD_API_RESULT_NULL_PARAM,
    FPD_API_RESULT_INVALID_PARAM,
    FPD_API_RESULT_NOT_INITIALIZED

}FPD_API_RESULT;

//typedef enum _FPD_BRIGHTNESS
//{
//    FPD_BRIGHTNESS_OFF = 0,
//    FPD_BRIGHTNESS_1,
//    FPD_BRIGHTNESS_2,
//    FPD_BRIGHTNESS_3,
//    FPD_BRIGHTNESS_MAX = 255
//}FPD_BRIGHTNESS;

typedef int FPD_BRIGHTNESS;
#define FPD_BRIGHTNESS_MAX 100

typedef enum _FPD_COLOR
{
    FPD_COLOR_BLUE = 1,
    FPD_COLOR_GREEN = 2,
    FPD_COLOR_RED = 4,
    FPD_COLOR_YELLOW = 8,
    FPD_COLOR_ORANGE = 16
}FPD_COLOR;

typedef enum _FPD_KEY
{
    FPD_SOFT_KEY_1 = 0x1,
    FPD_SOFT_KEY_2 = 0x2,
    FPD_POWER_KEY = 0x4,
}FPD_KEY;

#define FPD_SUPPORTED_COLORS  (FPD_COLOR_BLUE | \
                               FPD_COLOR_GREEN | \
                               FPD_COLOR_ORANGE | \
                               FPD_COLOR_RED | \
                               FPD_COLOR_YELLOW )

typedef enum _FPD_INDICATOR
{
    FPD_INDICATOR_TEXT = 1,
    FPD_INDICATOR_MESSAGE = 2,
    FPD_INDICATOR_POWER = 4,
    FPD_INDICATOR_RECORD = 8,
    FPD_INDICATOR_REMOTE = 16,
    FPD_INDICATOR_RFBYPASS = 32,

}FPD_INDICATOR;

typedef enum _FPD_INDICATOR_SUPPORTED_COLORS
{
    FPD_INDICATOR_SUPPORTED_COLORS_TEXT      = FPD_SUPPORTED_COLORS,
    FPD_INDICATOR_SUPPORTED_COLORS_MESSAGE   = FPD_SUPPORTED_COLORS,
    FPD_INDICATOR_SUPPORTED_COLORS_POWER     = FPD_SUPPORTED_COLORS,
    FPD_INDICATOR_SUPPORTED_COLORS_RECORD    = FPD_SUPPORTED_COLORS,
    FPD_INDICATOR_SUPPORTED_COLORS_REMOTE    = FPD_SUPPORTED_COLORS,
    FPD_INDICATOR_SUPPORTED_COLORS_RFBYPASS  = FPD_SUPPORTED_COLORS,

}FPD_INDICATOR_SUPPORTED_COLORS;

typedef enum _FPD_INDICATOR_MAX_BRIGHTNESS
{
    FPD_INDICATOR_MAX_BRIGHTNESS_TEXT          = FPD_BRIGHTNESS_MAX,
    FPD_INDICATOR_MAX_BRIGHTNESS_MESSAGE       = FPD_BRIGHTNESS_MAX,
    FPD_INDICATOR_MAX_BRIGHTNESS_POWER         = FPD_BRIGHTNESS_MAX,
    FPD_INDICATOR_MAX_BRIGHTNESS_RECORD        = FPD_BRIGHTNESS_MAX,
    FPD_INDICATOR_MAX_BRIGHTNESS_REMOTE        = FPD_BRIGHTNESS_MAX,
    FPD_INDICATOR_MAX_BRIGHTNESS_RFBYPASS      = FPD_BRIGHTNESS_MAX,
}FPD_INDICATOR_MAX_BRIGHTNESS;

typedef enum _FPD_INDICATOR_MAX_CYCLE_RATES
{
    FPD_INDICATOR_MAX_CYCLE_RATES_TEXT          = 2,
    FPD_INDICATOR_MAX_CYCLE_RATES_MESSAGE       = 2,
    FPD_INDICATOR_MAX_CYCLE_RATES_POWER         = 2,
    FPD_INDICATOR_MAX_CYCLE_RATES_RECORD        = 2,
    FPD_INDICATOR_MAX_CYCLE_RATES_REMOTE        = 2,
    FPD_INDICATOR_MAX_CYCLE_RATES_RFBYPASS      = 2,

}FPD_INDICATOR_MAX_CYCLE_RATES;

typedef enum _FPD_TIME
{
    FPD_TIME_12_HOUR = 0,
    FPD_TIME_24_HOUR = 1,
}FPD_TIME;


#define FPD_MAX_HORZ_ITERATIONS  5     // the maximum number of times per minute characters can scroll right to left across the display with zero hold time set.
#define FPD_MAX_VERT_ITERATIONS  20    // the maximum number of times per minute characters can scroll bottom to top across the display with zero hold time set.
#define FPD_MAX_VERT_ROWS        1     // the maximum number of times per minute characters can scroll right to left across the display with zero hold time set.
#define FPD_MAX_HORZ_COLS        4     // the maximum number of times per minute characters can scroll bottom to top across the display with zero hold time set.
#define FPD_INDICATOR_TOTAL_COUNT 6
    
typedef char FPD_STR[256];
#define FPD_SUPPORTED_CHARACTERS  " AbCdEFgHiJLnoPrStUy0123456789-"
typedef int (*FPD_CALLBACK) (FPD_KEY eKeyPressed, char * pCookie);

#ifdef __cplusplus
}
#endif

#endif // __FPD_DEFS_H__
