/*-----------------------------------------------------------------*/
/******************************************************************************
* Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors. 
* All rights reserved.
*
* This software is the confidential and proprietary information of SeaChange
* ("Confidential Information"). You shall not disclose this source code or 
* such Confidential Information and shall use it only in accordance with the 
* terms of the license agreement you entered into.
*  
* SEACHANGE INERNATIONAL  MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
* SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT 
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SEACHANGE SHALL NOT BE LIABLE FOR 
* ANY DAMAGES SUFFERED BY LICENSEE NOR SHALL THEY BE RESPONSIBLE AS A RESULT 
* OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*******************************************************************************/


/*-----------------------------------------------------------------*/
#ifndef __VL_CDL_PRIV_H__
#define __VL_CDL_PRIV_H__
/*-----------------------------------------------------------------*/
#ifdef __cplusplus
extern "C" {
#endif
/*-------------------------------------------------------------------
    Include Files
-------------------------------------------------------------------*/
#include "hal_api.h"
#include "vl_cdl_api.h"

typedef void * CDLHAL_HANDLE;
typedef void * CDL_HANDLE;

/*-------------------------------------------------------------------
    Defines/Macros
-------------------------------------------------------------------*/

typedef enum _CDL_RESULT
{
    CDL_OK,
    CDL_ERROR
}CDL_RESULT;

/*-------------------------------------------------------------------
   Types/Structs
-------------------------------------------------------------------*/

#define VL_MAX_CDL_CLIENTS  32

typedef struct
{
    unsigned char                       usIndex;
    int                                 bFree;            // Whether the POD Module is free/already requested
    CDLHAL_HANDLE                       hHal;
    CDL_HANDLE                          hCdlDriver;

}CDL_t;

typedef struct
{
    int                     bIsInitialized;         // Whether HAL CDL is initialized
    VL_CDL_CAPABILITIES_t   stCapabilities;
    CDL_t                   astCDL[VL_MAX_CDL_DEVICES]; // Array of CDL modules
} CDL_BASE_t;
typedef struct
{
    VL_CDL_NOTIFY_TYPE_t    eCBType;
    VL_CDL_VOID_CBFUNC_t    pCallback;
    void                *   pCBData;
} VL_CDL_NOTIFY_VOID_CLIENT_t;

/*-------------------------------------------------------------------
   Global Data Declarations
-------------------------------------------------------------------*/
//extern CDL_BASE_t stHalCDLBase;

/*-----------------------------------------------------------------*/
#ifdef __cplusplus
}
#endif
/*-----------------------------------------------------------------*/
#endif //__VL_CDL_PRIV_H__
/*-----------------------------------------------------------------*/
