/*-----------------------------------------------------------------*/
/******************************************************************************
* Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors. 
* All rights reserved.
*
* This software is the confidential and proprietary information of SeaChange
* ("Confidential Information"). You shall not disclose this source code or 
* such Confidential Information and shall use it only in accordance with the 
* terms of the license agreement you entered into.
*  
* SEACHANGE INERNATIONAL  MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
* SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT 
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SEACHANGE SHALL NOT BE LIABLE FOR 
* ANY DAMAGES SUFFERED BY LICENSEE NOR SHALL THEY BE RESPONSIBLE AS A RESULT 
* OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*******************************************************************************/


/*-----------------------------------------------------------------*/
#ifndef __VL_DSG_API_H__
#define __VL_DSG_API_H__
/*-----------------------------------------------------------------*/
#ifdef __cplusplus
extern "C" {
#endif
/*-------------------------------------------------------------------
   Include Files
-------------------------------------------------------------------*/
#include "dsg_types.h"
#include "hal_api.h"

/*-------------------------------------------------------------------
   Defines/Macros
-------------------------------------------------------------------*/



/*-------------------------------------------------------------------
   Types/Structs
-------------------------------------------------------------------*/

/*===================================================================
   FUNCTION PROTOTYPES
===================================================================*/

/**
 * Forwards a DSG control message (from the cable card) to the DSG capability.
 * @param hDSGHandle handle of the DSG capability.
 * @param pCtrlMsgData the pointer to the control message buffer.
 * @param dataLength the size of the control message buffer.
 *
 * @return 0 for success.
 */
int HAL_DSG_Send_ControlMessage(DEVICE_HANDLE_t hDSGHandle, unsigned char *pCtrlMsgData, unsigned short dataLength);

/**
 * Registers a callback function with the DSG capability.
 * @param hDSGHandle handle of the DSG capability.
 * @param pfnNotifyFunc the callback function.
 * @param notifyType the type of callback function being registered.
 * @param pulData other data (ignored).
 *
 * @return 0 for success.
 */
int HAL_DSG_SetNotify( DEVICE_HANDLE_t hDSGHandle, void * pfnNotifyFunc, VL_DSG_NOTIFY_TYPE_t notifyType, void* pulData);

/**
 * Applies configuration data to the DSG capability.
 * @param hDSGHandle handle of the DSG capability.
 * @param ulTag the type of config data.
 * @param pvConfig pointer to the config data structure.
 *
 * @return 0 for success.
 */
int HAL_DSG_SetConfig( DEVICE_HANDLE_t hDSGHandle, unsigned long ulTag, void* pvConfig);

/*-----------------------------------------------------------------*/
#ifdef __cplusplus
}
#endif
/*-----------------------------------------------------------------*/
#endif //__VL_DSG_API_H__
/*-----------------------------------------------------------------*/
