/******************************************************************************
* Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors. 
* All rights reserved.
*
* This software is the confidential and proprietary information of SeaChange
* ("Confidential Information"). You shall not disclose this source code or 
* such Confidential Information and shall use it only in accordance with the 
* terms of the license agreement you entered into.
*  
* SEACHANGE INERNATIONAL  MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
* SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT 
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SEACHANGE SHALL NOT BE LIABLE FOR 
* ANY DAMAGES SUFFERED BY LICENSEE NOR SHALL THEY BE RESPONSIBLE AS A RESULT 
* OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*******************************************************************************/



#ifndef USE_VIVID_MFR
/*-------------------------------------------------------------------
   Include Files
-------------------------------------------------------------------*/
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <openssl/aes.h>
#include "mfr_types.h"
#include "vl_sample_mfr_api.h"
#include "rmf_osal_mem.h"
#include "rdk_debug.h"

#define NVRAM_TEST_SIZE     128

static void vl_set_rand_seed()
{// this function should be static

    struct timeval ts;
    long tickcount = 0;
    gettimeofday(&ts,NULL);
    tickcount = (long)(ts.tv_sec + ts.tv_usec);
    srand(tickcount);
}

static long vl_get_rand_char()
{// this function should be static
    return ((rand()&0xFF)^0xFF);
}

static void vl_create_key(const VL_NVRAM_DATA * pSerialNumber, unsigned char * keybuf, unsigned char * ivec)
{// this function should be static

    int i = 0, j = 0, k = 0, keylen = pSerialNumber->nActualBytes;
    unsigned char normalizedkeybuf[VL_CRYPTO_KEY_LENGTH];
    unsigned char refkey[VL_CRYPTO_KEY_LENGTH] = {  0xF0, 0xE1, 0xD2, 0xC3, 0xB4, 0xA5, 0x96, 0x87,
            0x78, 0x69, 0x5A, 0x4B, 0x3C, 0x2D, 0x1E, 0x0F};
    if(keylen > VL_CRYPTO_KEY_LENGTH) keylen = VL_CRYPTO_KEY_LENGTH;
    memset(keybuf           , 0, VL_CRYPTO_KEY_LENGTH);
    memset(normalizedkeybuf , 0, VL_CRYPTO_KEY_LENGTH);
    // normalize the key strength
    for(i = 0, k = 0; i < VL_CRYPTO_KEY_LENGTH; i+= keylen, k = !k)
    {
        for(j = 0; (j < keylen) && ((j+i) < VL_CRYPTO_KEY_LENGTH); j++)
        {
            unsigned char ix  = ((i+j)*3)%VL_CRYPTO_KEY_LENGTH;
            unsigned char cSN = (pSerialNumber->pData[ix]);

            if(0==cSN) cSN = refkey[ix];

            if(k)
            {
                normalizedkeybuf[i+j] = (cSN^0xFF);
            }
            else
            {
                normalizedkeybuf[i+j] = (cSN);
            }
        }
    }

    // create a digested version of the normalized key
    {
        AES_KEY ctx;
        unsigned char digestkeybuf[VL_CRYPTO_KEY_LENGTH];
        unsigned char iv[AES_BLOCK_SIZE];
        memset(iv, 0, VL_CRYPTO_IVEC_LENGTH);
        memset(digestkeybuf, 0, VL_CRYPTO_KEY_LENGTH);


        memcpy(digestkeybuf, pSerialNumber->pData, keylen);
        /* set up the AES key structure */
        AES_set_encrypt_key(digestkeybuf, 128, &ctx);
        // generate the digested key
        AES_cbc_encrypt(normalizedkeybuf, keybuf, AES_BLOCK_SIZE, &ctx, iv, AES_ENCRYPT);
        // generate the digested ivec
        AES_cbc_encrypt(keybuf, ivec, AES_BLOCK_SIZE, &ctx, iv, AES_ENCRYPT);
    }
}

/********************************************
int vl_aes_encrypt (char*, unsigned char*, size_t, char*)
Encrypts the supplied buffer using AES-128-CBC
Parameters: const VL_NVRAM_DATA * pSerialNumber - the encryption key
            const VL_NVRAM_DATA * pPlainText - the data to be encrypted
            VL_NVRAM_DATA * pCipherText - resulting encrypted data
Returns: VL_MFR_API_RESULT_SUCCESS on success
*/
static VL_MFR_API_RESULT vl_aes_encrypt(const VL_NVRAM_DATA * pSerialNumber, const VL_NVRAM_DATA * pPlainText, VL_NVRAM_DATA * pCipherText)
{// this function should be static

    AES_KEY ctx;
    unsigned char keybuf[VL_CRYPTO_KEY_LENGTH];
    int count = 0;
    unsigned char iv[AES_BLOCK_SIZE];
    int nBytes           = pCipherText->nBytes = pPlainText->nBytes;
    unsigned char * pbuf = pPlainText->pData;
    unsigned char * cbuf = NULL;

    pCipherText->pData = NULL;

    // parameter check
    if(NULL == pSerialNumber) return VL_MFR_API_RESULT_NULL_KEY;
    if(NULL == pSerialNumber->pData) return VL_MFR_API_RESULT_NULL_KEY;
    if(pSerialNumber->nActualBytes <= 0) return VL_MFR_API_RESULT_NULL_KEY;
    if(NULL == pbuf) return VL_MFR_API_RESULT_NULL_PARAM;

    // block size check
    if(0 != (nBytes%AES_BLOCK_SIZE))
    {
        // fix block size
        pCipherText->nBytes = nBytes = ((nBytes/AES_BLOCK_SIZE)+1)*AES_BLOCK_SIZE;
        pbuf = (unsigned char *)malloc(nBytes);
        if(NULL == pbuf) return VL_MFR_API_RESULT_MALLOC_FAILED;
        memset(pbuf, 0, nBytes);
        memcpy(pbuf, pPlainText->pData, pPlainText->nBytes);
    }
    // allocate output buffer
    cbuf = pCipherText->pData = (unsigned char *)malloc(nBytes);

    // check for alloc failure
    if(NULL == cbuf)
    {
    // free any duplicate pbuf
        if(pbuf != pPlainText->pData)
        {
            free(pbuf);
        }
        return VL_MFR_API_RESULT_MALLOC_FAILED;
    }

    // redundant check for block size
    if(0 != (nBytes%AES_BLOCK_SIZE))
    {
            // free any duplicate pbuf
        if(pbuf != pPlainText->pData)
        {
            free(pbuf);
        }
        return VL_MFR_API_RESULT_INVALID_BUFFER_LENGTH;
    }

    /* set up the AES key structure */
    vl_create_key(pSerialNumber, keybuf, iv);
    AES_set_encrypt_key(keybuf, 128, &ctx);

    /* encrypt the data */
    while (count < nBytes)
    {
        /* encrypt the data */
        AES_cbc_encrypt(pbuf+count, cbuf+count, AES_BLOCK_SIZE, &ctx, iv, AES_ENCRYPT);
        count += AES_BLOCK_SIZE;
    }

    // free any duplicate pbuf
    if(pbuf != pPlainText->pData)
    {
        free(pbuf);
    }

    pCipherText->nActualBytes = pPlainText->nActualBytes;

    // return success
    return VL_MFR_API_RESULT_SUCCESS;
}


/********************************************
int vl_aes_decrypt (char*, unsigned char*, size_t, char*)
Decrypts the supplied buffer using AES-128-CBC
Parameters: const VL_NVRAM_DATA * pSerialNumber - the encryption key
            const VL_NVRAM_DATA * pCipherText - the data to be decrypted
            VL_NVRAM_DATA * pPlainText - resulting decrypted data
Returns: VL_MFR_API_RESULT_SUCCESS on success
*/
static VL_MFR_API_RESULT vl_aes_decrypt(const VL_NVRAM_DATA * pSerialNumber, const VL_NVRAM_DATA * pCipherText, VL_NVRAM_DATA * pPlainText)
{// this function should be static

    AES_KEY ctx;
    unsigned char keybuf[VL_CRYPTO_KEY_LENGTH];
    int count = 0;
    unsigned char iv[AES_BLOCK_SIZE];
    int nBytes           = pPlainText->nBytes = pCipherText->nBytes;
    unsigned char * cbuf = pCipherText->pData;
    unsigned char * pbuf = NULL;

    pPlainText->pData = NULL;

    // parameter check
    if(NULL == pSerialNumber) return VL_MFR_API_RESULT_NULL_KEY;
    if(NULL == pSerialNumber->pData) return VL_MFR_API_RESULT_NULL_KEY;
    if(pSerialNumber->nActualBytes <= 0) return VL_MFR_API_RESULT_NULL_KEY;
    if(NULL == cbuf) return VL_MFR_API_RESULT_NULL_PARAM;

    // block size check
    if(0 != (nBytes%AES_BLOCK_SIZE))
    {
        // fix block size
        pPlainText->nBytes = nBytes = ((nBytes/AES_BLOCK_SIZE)+1)*AES_BLOCK_SIZE;
	rmf_osal_memAllocP(RMF_OSAL_MEM_POD, nBytes, (void **)&cbuf);
        if(NULL == cbuf)
        {
                // free any duplicate cbuf
            if(cbuf != pCipherText->pData)
            {
                        rmf_osal_memFreeP(RMF_OSAL_MEM_POD,cbuf);
            }
            return VL_MFR_API_RESULT_MALLOC_FAILED;
        }
        memset(cbuf, 0, nBytes);
        memcpy(cbuf, pCipherText->pData, pCipherText->nBytes);
    }
    // allocate output buffer
    pbuf = pPlainText->pData = (unsigned char *)malloc(nBytes);

    // check for alloc failure
    if(NULL == pbuf)
    {
                        // free any duplicate cbuf
        if(cbuf != pCipherText->pData)
        {
                    rmf_osal_memFreeP(RMF_OSAL_MEM_POD,cbuf);
        }
        return VL_MFR_API_RESULT_MALLOC_FAILED;
    }

    // redundant check for block size
    if(0 != (nBytes%AES_BLOCK_SIZE))
    {
            // free any duplicate cbuf
        if(cbuf != pCipherText->pData)
        {
            free(cbuf);
        }
        return VL_MFR_API_RESULT_INVALID_BUFFER_LENGTH;
    }

    /* set up the AES key structure */
    vl_create_key(pSerialNumber, keybuf, iv);
    AES_set_decrypt_key(keybuf, 128, &ctx);

    /* decrypt the data */
    while (count < nBytes)
    {
        /* decrypt the data */
        AES_cbc_encrypt(cbuf+count, pbuf+count, AES_BLOCK_SIZE, &ctx, iv, AES_DECRYPT);
        count += AES_BLOCK_SIZE;
    }

    // free any duplicate cbuf
    if(cbuf != pCipherText->pData)
    {
        free(cbuf);
    }

    pPlainText->nActualBytes = pCipherText->nActualBytes;

// return success
    return VL_MFR_API_RESULT_SUCCESS;
}

static VL_MFR_API_RESULT vl_mfr_read_sn_seed(VL_NVRAM_DATA * pNvRamData)
{
    unsigned char seed[VL_CRYPTO_KEY_LENGTH] = {0x91, 0x71, 0x8E, 0xF1, 0x93, 0x36, 0x78, 0x44,
                                                0x0C, 0x4B, 0x7F, 0x8F, 0x6C, 0x5A, 0x35, 0xE7};
    pNvRamData->nActualBytes = VL_CRYPTO_KEY_LENGTH;
    pNvRamData->pData  = (unsigned char *)malloc(VL_CRYPTO_KEY_LENGTH);
    memset(pNvRamData->pData, 0, VL_CRYPTO_KEY_LENGTH);
    memcpy(pNvRamData->pData, seed, VL_CRYPTO_KEY_LENGTH);

    return VL_MFR_API_RESULT_SUCCESS;
}

static VL_MFR_API_RESULT vl_mfr_read_secure_nvram_data(VL_SECURE_NVRAM_DATA_TYPE eType, int nOffset, int nBytes, VL_NVRAM_DATA * pNvRamData)
{// this function should be static

    // sample implementation
    // just allocate some buffer
    // it is assumed that the data is stored in the nvram in encrypted format
    // this function decrypts the buffer when data is read from nvram
    // using an undocumented method only known by this function.
    // the OCAP stack will perform a second decryption of this buffer using the
    // method described in the confidential document
    int i = 0; unsigned long nActualBytes = 0;
    VL_MFR_API_RESULT result = VL_MFR_API_RESULT_SUCCESS;
    unsigned char * pBuffer = NULL;
    VL_NVRAM_DATA nvSerialNumber    = {0,0,NULL};
    VL_NVRAM_DATA nvDecryptedData   = {0,0,NULL};
    memset(pNvRamData, 0, sizeof(*pNvRamData));

    if(VL_SECURE_NVRAM_DATA_SERIAL_NUMBER == eType)
    {
        result = vl_mfr_read_sn_seed(&nvSerialNumber);
    }
    else
    {
        result = vl_mfr_read_secure_nvram(VL_SECURE_NVRAM_DATA_SERIAL_NUMBER, &nvSerialNumber);
    }

    if(VL_MFR_API_RESULT_SUCCESS != result)
    {
        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.SYS", "vl read nvram: null key 1\n");
        return result;
    }

    if((0 == nvSerialNumber.nActualBytes) || (NULL == nvSerialNumber.pData))
    {
        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.SYS", "vl read nvram: null key 2\n");
        return VL_MFR_API_RESULT_NULL_KEY;
    }

    {
        unsigned char nullbuf[VL_CRYPTO_KEY_LENGTH] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                                       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

        if(0 == memcmp(nullbuf, nvSerialNumber.pData, VL_CRYPTO_KEY_LENGTH))
        {
            RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.SYS", "vl read nvram: null key 3\n");
            return VL_MFR_API_RESULT_NULL_KEY;
        }
    }

    // simulated read operation
    {
        int nRead = 0;
        char szFileName[128];
        snprintf(szFileName, sizeof(szFileName), "/tmp/vl_secure_nvram_0x%X.bin", eType);
        struct stat statFile;
        FILE * fp = fopen(szFileName, "rb");
        stat(szFileName, &statFile);
        if(NULL != fp)
        {
            if(statFile.st_size > 0)
            {
                /* ignore parameter nBytes // if((statFile.st_size > nBytes+AES_BLOCK_SIZE) || (statFile.st_size < nBytes))
                {
                    RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.SYS", "vl read nvram: size mismatch (expected %d, found %d) for eType = 0x%X\n", nBytes, statFile.st_size, eType);
                    result = VL_MFR_API_RESULT_SIZE_MISMATCH;
                }
                if(statFile.st_size > nBytes)*/
                nBytes = statFile.st_size;
                nBytes -= sizeof(pNvRamData->nActualBytes);
                pBuffer = (unsigned char*)malloc(nBytes);

                if(NULL != pBuffer)
                {
                    fread(&nActualBytes, sizeof(pNvRamData->nActualBytes), 1, fp);
                    memset(pBuffer, 0, nBytes);
                    nRead = fread(pBuffer, 1, nBytes, fp);
                    if(nRead != nBytes)
                    {
                        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.SYS", "vl read secure nvram: size mismatch (expected %d, read %d) for eType = 0x%X\n", nBytes, nRead, eType);
                        result = VL_MFR_API_RESULT_READ_FAILED;
                    }
                }
                else
                {
                    RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.SYS", "vl read secure nvram: alloc failed for eType = 0x%X\n", eType);
                    result = VL_MFR_API_RESULT_MALLOC_FAILED;
                }
            }
            else
            {
                RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.SYS", "vl read secure nvram: could not stat nvram for eType = 0x%X\n", eType);
                result = VL_MFR_API_RESULT_NOT_EXISTING;
            }
            fclose(fp);
        }
        else
        {
            RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.SYS", "vl read secure nvram: could not open nvram for eType = 0x%X\n", eType);
            result = VL_MFR_API_RESULT_OPEN_FAILED;
        }

        if(nRead != nBytes)
        {
            // return failure
            result = VL_MFR_API_RESULT_FAILED;
        }
    }

    // prepare encrypted data
    pNvRamData->nBytes  = nBytes;
    pNvRamData->pData   = pBuffer;

    // simulated decrypt operation
    if(VL_MFR_API_RESULT_SUCCESS == result)
    {
        result  = vl_aes_decrypt(&nvSerialNumber, pNvRamData, &nvDecryptedData);
    }

    if(NULL != nvSerialNumber.pData ) free(nvSerialNumber.pData );
    if(NULL != pNvRamData->pData    ) free(pNvRamData->pData    );

    // prepare the nvram struct for return
    memset(pNvRamData, 0, sizeof(*pNvRamData));
    pNvRamData->nActualBytes    = nActualBytes;
    pNvRamData->nBytes          = nvDecryptedData.nBytes;
    pNvRamData->pData           = nvDecryptedData.pData;

    // return success
    return result;
}

static VL_MFR_API_RESULT vl_mfr_write_secure_nvram_data(VL_SECURE_NVRAM_DATA_TYPE eType, int nOffset, const VL_NVRAM_DATA * pNvRamData)
{// this function should be static

    // sample implementation
    // just return success
    // the OCAP stack will encrypt this buffer as mentioned in the document
    // this function then re-encrypts the data again using an undocumented method
    // before storing to nvram

    int i = 0;
    VL_MFR_API_RESULT result = VL_MFR_API_RESULT_SUCCESS;
    VL_NVRAM_DATA nvSerialNumber    = {0,0,NULL};
    VL_NVRAM_DATA nvEncryptedData   = {0,0,NULL};

    if(VL_SECURE_NVRAM_DATA_SERIAL_NUMBER == eType)
    {
        result = vl_mfr_read_sn_seed(&nvSerialNumber);
    }
    else
    {
        result = vl_mfr_read_secure_nvram(VL_SECURE_NVRAM_DATA_SERIAL_NUMBER, &nvSerialNumber);
    }

    if(VL_MFR_API_RESULT_SUCCESS != result)
    {
        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.SYS", "vl write nvram: null key 1\n");
        return result;
    }

    if((0 == nvSerialNumber.nActualBytes) || (NULL == nvSerialNumber.pData))
    {
        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.SYS", "vl write nvram: null key 2\n");
        return VL_MFR_API_RESULT_NULL_KEY;
    }

    {
        unsigned char nullbuf[VL_CRYPTO_KEY_LENGTH] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                                       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

        if(0 == memcmp(nullbuf, nvSerialNumber.pData, VL_CRYPTO_KEY_LENGTH))
        {
            RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.SYS", "vl write nvram: null key 3\n");
            return VL_MFR_API_RESULT_NULL_KEY;
        }
    }

    // get the correct byte count
    if(0 == pNvRamData->nBytes)
    {
        memcpy((void *)&(pNvRamData->nBytes), &(pNvRamData->nActualBytes), sizeof(pNvRamData->nBytes));
    }

    // simulated encrypt operation
    vl_aes_encrypt(&nvSerialNumber, pNvRamData, &nvEncryptedData);
    // simulated write operation
    {
        char szFileName[128];
        snprintf(szFileName, sizeof(szFileName), "/tmp/vl_secure_nvram_0x%X.bin", eType);
        FILE * fp = fopen(szFileName, "wb");
        if(NULL != fp)
        {
            int nWritten = 0;
            fwrite(&(pNvRamData->nActualBytes), sizeof(pNvRamData->nActualBytes), 1, fp);
            nWritten = fwrite(nvEncryptedData.pData, 1, nvEncryptedData.nBytes, fp);
            fclose(fp);
            if(nWritten < nvEncryptedData.nBytes)
            {
                result = VL_MFR_API_RESULT_WRITE_FAILED;
                RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.SYS", "vl write secure nvram: could not write all bytes to nvram for eType = 0x%X\n", eType);
            }
        }
        else
        {
            result = VL_MFR_API_RESULT_OPEN_FAILED;
            RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.SYS", "vl write secure nvram: could not open nvram for eType = 0x%X\n", eType);
        }
    }

    if(NULL != nvSerialNumber.pData ) free(nvSerialNumber.pData );
    if(NULL != nvEncryptedData.pData) free(nvEncryptedData.pData);

    return result;
}

VL_MFR_API_RESULT vl_mfr_read_secure_nvram (VL_SECURE_NVRAM_DATA_TYPE eType, VL_NVRAM_DATA * pNvRamData)
{
    memset(pNvRamData, 0, sizeof(*pNvRamData));

    // for the time being use the following values
    int nSize = NVRAM_TEST_SIZE;
    int nOffset = 0;
    return vl_mfr_read_secure_nvram_data(eType, nOffset, nSize, pNvRamData);
}

VL_MFR_API_RESULT vl_mfr_write_secure_nvram(VL_SECURE_NVRAM_DATA_TYPE eType, const VL_NVRAM_DATA * pNvRamData)
{
    // for the time being use the following values
    int nOffset = 0;
    return vl_mfr_write_secure_nvram_data(eType, nOffset, pNvRamData);
}

#endif// USE_VIVID_MFR



