/******************************************************************************
* Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors. 
* All rights reserved.
*
* This software is the confidential and proprietary information of SeaChange
* ("Confidential Information"). You shall not disclose this source code or 
* such Confidential Information and shall use it only in accordance with the 
* terms of the license agreement you entered into.
*  
* SEACHANGE INERNATIONAL  MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
* SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT 
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SEACHANGE SHALL NOT BE LIABLE FOR 
* ANY DAMAGES SUFFERED BY LICENSEE NOR SHALL THEY BE RESPONSIBLE AS A RESULT 
* OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*******************************************************************************/




/*-------------------------------------------------------------------
   Include Files
-------------------------------------------------------------------*/
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <openssl/aes.h>
#include <pthread.h>
#include "mfr_types.h"
#include "vl_mfr_stack_api.h"
#include "vl_sample_mfr_api.h"
#include "rdk_debug.h"

static VL_MFR_VOID_CBFUNC_t    fg_apCallbacks[VL_MFR_NOTIFY_MAX_TYPES] = {0};
#if 0
void vl_mfr_cable_card_dfast2(unsigned int *SeedIn, unsigned int *KeyOut);
#endif

// cable card settings
void * vl_mfr_fp_run(void * arg);

VL_MFR_API_RESULT vl_mfr_init()
{
    pthread_t threadid = 0;
    void * arg = NULL;
    pthread_create(&threadid, NULL, vl_mfr_fp_run, arg);
    return VL_MFR_API_RESULT_SUCCESS;
}

VL_MFR_API_RESULT vl_mfr_shutdown()
{
    return VL_MFR_API_RESULT_SUCCESS;
}

VL_MFR_API_RESULT vl_mfr_set_notify(VL_MFR_NOTIFY_TYPE_t notifyType, VL_MFR_VOID_CBFUNC_t pfnNotifyFunc)
{
    if(((int)notifyType >= 0) && ((int)notifyType < VL_MFR_NOTIFY_MAX_TYPES))
    {
        if(NULL != pfnNotifyFunc)
        {
            fg_apCallbacks[notifyType] = pfnNotifyFunc;
            return VL_MFR_API_RESULT_SUCCESS;
        }
    }

    return VL_MFR_API_RESULT_FAILED;
}

VL_MFR_API_RESULT vl_mfr_get_version_name(VL_PLATFORM_VERSION_TYPE eVersionType, char ** ppString)
{
    if(NULL == ppString)
    {
        return VL_MFR_API_RESULT_NULL_PARAM;
    }

    switch(eVersionType)
    {
    case VL_PLATFORM_VERSION_TYPE_BOARD_VERSION         : *ppString  = "Board Version"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_BOARD_SERIAL_NO       : *ppString  = "Board Serial Number"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_CM_CHIP_VERSION       : *ppString  = "Cable Modem Version"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_CM_CHIP_SERIAL_NO     : *ppString  = "Cable Modem Serial Number"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_CM_SW_VERSION         : *ppString  = "Cable Modem Software Version"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_DECODER_CHIP_VERSION  : *ppString  = "Decoder Version"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_DECODER_CHIP_SERIAL_NO: *ppString  = "Decoder Serial Number"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_DECODER_SW_VERSION    : *ppString  = "Decoder Software Version"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_OS_KERNEL_VERSION     : *ppString  = "OS Version"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_SDK_TOOLCHAIN_VERSION : *ppString  = "Tool Chain Version"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_SDK_RELEASE_VERSION   : *ppString  = "SDK Version"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_MFR_LIB_VERSION       : *ppString  = "Mfr Lib Version"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_FRONT_PANEL_VERSION   : *ppString  = "Front Panel Version"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_FRONT_PANEL_SERIAL_NO : *ppString  = "Front Panel Serial Number"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_SOFTWARE_IMAGE_VERSION: *ppString  = "Software Image Version"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_SOFTWARE_IMAGE_SERIAL_NO : *ppString  = "Software Image Serial Number"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_OCHD_VERSION          : *ppString  = "OCHD Version"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_OCHD_SERIAL_NO        : *ppString  = "OCHD Serial Number"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_OCAP_VERSION          : *ppString  = "OCAP Version"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_OCAP_SERIAL_NO        : *ppString  = "OCAP Serial Number"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_BOOT_ROM_VERSION      : *ppString  = "Boot ROM Version"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_BOOT_ROM_SERIAL_NO    : *ppString  = "Boot ROM Serial Number"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_MODEL_NUMBER          : *ppString  = "Model Number"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_MODEL_SERIAL_NO       : *ppString  = "Model Serial Number"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_VENDOR_NAME           : *ppString  = "Vendor Name"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_VENDOR_SERIAL_NO      : *ppString  = "Vendor Serial Number"; return VL_MFR_API_RESULT_SUCCESS;
    }

    *ppString  = "Non-Exisiting";

    return VL_MFR_API_RESULT_NOT_EXISTING;
}

VL_MFR_API_RESULT vl_mfr_get_version     (VL_PLATFORM_VERSION_TYPE eVersionType, char ** ppString)
{
    if(NULL == ppString)
    {
        return VL_MFR_API_RESULT_NULL_PARAM;
    }

    switch(eVersionType)
    {
    case VL_PLATFORM_VERSION_TYPE_BOARD_VERSION         : *ppString  = "bcmXXXXXX"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_BOARD_SERIAL_NO       : *ppString  = "1234567890"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_CM_CHIP_VERSION       : *ppString  = "bcmXXXX"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_CM_CHIP_SERIAL_NO     : *ppString  = "1234567890"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_CM_SW_VERSION         : *ppString  = "x.x"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_DECODER_CHIP_VERSION  : *ppString  = "Chip-Version"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_DECODER_CHIP_SERIAL_NO: *ppString  = "1234567890"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_DECODER_SW_VERSION    : *ppString  = "x.x"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_OS_KERNEL_VERSION     : *ppString  = "x.x"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_SDK_TOOLCHAIN_VERSION : *ppString  = "x.x"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_SDK_RELEASE_VERSION   : *ppString  = "4.1"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_MFR_LIB_VERSION       : *ppString  = "1.0"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_FRONT_PANEL_VERSION   : *ppString  = "1.0"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_FRONT_PANEL_SERIAL_NO : *ppString  = "1234567890"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_SOFTWARE_IMAGE_VERSION: *ppString  = "1.1"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_SOFTWARE_IMAGE_SERIAL_NO: *ppString  = "1234567890"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_OCHD_VERSION          : *ppString  = "2.0"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_OCHD_SERIAL_NO        : *ppString  = "1234567890"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_OCAP_VERSION          : *ppString  = "1.0.1"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_OCAP_SERIAL_NO        : *ppString  = "1234567890"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_BOOT_ROM_VERSION      : *ppString  = "1.1"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_BOOT_ROM_SERIAL_NO    : *ppString  = "1234567890"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_MODEL_NUMBER          : *ppString  = "XYZ123"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_MODEL_SERIAL_NO       : *ppString  = "1234567890"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_VENDOR_NAME           : *ppString  = "vl"; return VL_MFR_API_RESULT_SUCCESS;
    case VL_PLATFORM_VERSION_TYPE_VENDOR_SERIAL_NO      : *ppString  = "1234567890"; return VL_MFR_API_RESULT_SUCCESS;
    }

    *ppString  = "Not-Specified";
    return VL_MFR_API_RESULT_NOT_EXISTING;
}

VL_MFR_API_RESULT vl_mfr_notify_get_mfr_data_from_stack(VL_MFR_2_STACK_EVENT_TYPE eEvent, void * _pvData)
{
    if(NULL != fg_apCallbacks[VL_MFR_NOTIFY_GET_MFR_DATA])
    {
        VL_MFR_NOTIFY_MFR_GET_DATA_CBFUNC_t pCallback  =
            (VL_MFR_NOTIFY_MFR_GET_DATA_CBFUNC_t)(fg_apCallbacks[VL_MFR_NOTIFY_GET_MFR_DATA]);
        return pCallback(0, eEvent, _pvData);
    }

    return VL_MFR_API_RESULT_FAILED;
}

VL_MFR_API_RESULT vl_mfr_notify_mfr_event_to_stack(VL_MFR_2_STACK_EVENT_TYPE eEvent, void * _pvData)
{
    if(NULL != fg_apCallbacks[VL_MFR_NOTIFY_MFR_EVENT])
    {
        VL_MFR_NOTIFY_MFR_EVENT_CBFUNC_t pCallback  =
            (VL_MFR_NOTIFY_MFR_EVENT_CBFUNC_t)(fg_apCallbacks[VL_MFR_NOTIFY_MFR_EVENT]);
        return pCallback(0, eEvent, _pvData);
    }

    return VL_MFR_API_RESULT_FAILED;
}

VL_MFR_API_RESULT vl_mfr_get_config_path(VL_MFR_CONFIG_TYPE eConfigType, char * pszConfigPath)
{
    strncpy(pszConfigPath, "/opt/",6);

    switch(eConfigType)
    {
        case VL_MFR_CONFIG_TYPE_STATIC:
        {
            strncpy(pszConfigPath, "/opt/",6);
        }
        break;

        case VL_MFR_CONFIG_TYPE_DYNAMIC:
        {
            strncpy(pszConfigPath, "/opt/",6);
        }
        break;

        case VL_MFR_CONFIG_TYPE_VOLATILE:
        {
            strncpy(pszConfigPath, "/opt/",6);
        }
        break;

        default:
        {
            strncpy(pszConfigPath, "/opt/",6);
        }
        break;
    }

    return VL_MFR_API_RESULT_SUCCESS;
}

VL_MFR_API_RESULT vl_mfr_set_mfr_data(VL_STACK_2_MFR_EVENT_TYPE eEvent, void * _pvData)
{
    RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SYS", "%s: Received MFR Event 0x%08X\n", __FUNCTION__, eEvent);
    switch(eEvent)
    {
        case VL_STACK_2_MFR_EVENT_SET_UPGRADE_TO_IMAGE         :
        {
            VL_MFR_UPGRADE_IMAGE* pStruct = (VL_MFR_UPGRADE_IMAGE*)_pvData;
            RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SYS", "%s: Received VL_STACK_2_MFR_EVENT_UPGRADE_TO_IMAGE\n", __FUNCTION__);
            RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SYS", "%s: Performing Software Upgrade with image '%s' ...\n", __FUNCTION__, pStruct->pszUpgradeImagePathName);
            RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SYS", "%s: ...Software Upgrade...TBD...\n", __FUNCTION__);
        }
        break;

        case VL_STACK_2_MFR_EVENT_SET_REBOOT_WITH_UPGRADED_IMAGE:
        {
            RDK_LOG(RDK_LOG_INFO, "LOG.RDK.SYS", "%s: Received VL_STACK_2_MFR_EVENT_REBOOT_WITH_UPGRADED_IMAGE\n", __FUNCTION__);
            RDK_LOG(RDK_LOG_INFO, "LOG.RDK.SYS", "%s: Rebooting...\n", __FUNCTION__);
            system("sh /rebootNow.sh -s vlAPI_Caller_Upgrade -o 'Rebooting the box after performing Software Upgrade...'");
        }
        break;

        case VL_STACK_2_MFR_EVENT_SET_UPGRADE_IMAGE_NAME:
        {
            VL_MFR_SOFTWARE_IMAGE_NAME* pStruct = (VL_MFR_SOFTWARE_IMAGE_NAME*)_pvData;
            VL_NVRAM_DATA nvData;
            memset(&nvData, 0, sizeof(nvData));
            RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SYS", "%s: Received VL_STACK_2_MFR_EVENT_SET_UPGRADE_IMAGE_NAME\n",  __FUNCTION__);
            nvData.nActualBytes = sizeof(pStruct->szSoftwareImageName);
            nvData.nBytes       = nvData.nActualBytes;
            nvData.pData        = (unsigned char*)(pStruct->szSoftwareImageName);
            vl_mfr_write_normal_nvram(VL_NORMAL_NVRAM_DATA_UPGRADE_IMAGE_NAME, &nvData);
        }
        break;

        case VL_STACK_2_MFR_EVENT_SET_UPGRADE_FAILED:
        {
            VL_MFR_SOFTWARE_IMAGE_NAME nextName;
            memset(&nextName    , 0, sizeof(nextName    ));
            RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SYS", "%s: Received VL_CDL_MANAGER_EVENT_SET_UPGRADE_FAILED\n",  __FUNCTION__);
            vl_mfr_set_mfr_data(VL_STACK_2_MFR_EVENT_SET_UPGRADE_IMAGE_NAME, &nextName);
        }
        break;

        case VL_STACK_2_MFR_EVENT_SET_UPGRADE_SUCCEEDED:
        {
            VL_NVRAM_DATA nvData;
            VL_MFR_SOFTWARE_IMAGE_NAME previousName, currentName, nextName;
            memset(&nvData      , 0, sizeof(nvData      ));
            memset(&previousName, 0, sizeof(previousName));
            memset(&currentName , 0, sizeof(currentName ));
            memset(&nextName    , 0, sizeof(nextName    ));
            RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SYS", "%s: Received VL_STACK_2_MFR_EVENT_SET_UPGRADE_SUCCEEDED\n",  __FUNCTION__);

            // get image names
            vl_mfr_get_mfr_data(VL_STACK_2_MFR_EVENT_get_PREVIOUS_BOOT_IMAGE_NAME, &previousName );
            vl_mfr_get_mfr_data(VL_STACK_2_MFR_EVENT_get_CURRENT_BOOT_IMAGE_NAME , &currentName  );
            vl_mfr_get_mfr_data(VL_STACK_2_MFR_EVENT_get_UPGRADE_IMAGE_NAME      , &nextName     );

            // write current name as previous name
            nvData.nActualBytes = sizeof(currentName.szSoftwareImageName);
            nvData.nBytes       = nvData.nActualBytes;
            nvData.pData        = (unsigned char*)(currentName.szSoftwareImageName);
            vl_mfr_write_normal_nvram(VL_NORMAL_NVRAM_DATA_PREVIOUS_IMAGE_NAME, &nvData);

            // write next name as current name
            nvData.nActualBytes = sizeof(nextName.szSoftwareImageName);
            nvData.nBytes       = nvData.nActualBytes;
            nvData.pData        = (unsigned char*)(nextName.szSoftwareImageName);
            vl_mfr_write_normal_nvram(VL_NORMAL_NVRAM_DATA_BOOT_IMAGE_NAME, &nvData);

            // set next name as empty
            memset(&nextName    , 0, sizeof(nextName    ));
            vl_mfr_set_mfr_data(VL_STACK_2_MFR_EVENT_SET_UPGRADE_IMAGE_NAME, &nextName);
        }
        break;

        default:
        {
            RDK_LOG(RDK_LOG_INFO, "LOG.RDK.SYS", "%s: Received VL_STACK_2_MFR_EVENT 0x%08X\n",  __FUNCTION__, eEvent);
        }
        break;
    }
    return VL_MFR_API_RESULT_SUCCESS;
}

VL_MFR_API_RESULT vl_mfr_get_mfr_data(VL_STACK_2_MFR_EVENT_TYPE eEvent, void * _pvData)
{
    //RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SYS", "%s: Populating data for MFR Event 0x%08X\n", __FUNCTION__, eEvent);
    switch(eEvent)
    {
        case VL_STACK_2_MFR_EVENT_get_PREVIOUS_BOOT_IMAGE_NAME:
        {
            VL_MFR_SOFTWARE_IMAGE_NAME* pStruct = (VL_MFR_SOFTWARE_IMAGE_NAME*)_pvData;
            VL_NVRAM_DATA nvData;
            memset(pStruct, 0, sizeof(*pStruct));
            RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SYS", "%s: Received VL_STACK_2_MFR_EVENT_get_PREVIOUS_BOOT_IMAGE_NAME\n",  __FUNCTION__);
            memset(&nvData, 0, sizeof(nvData));
            vl_mfr_read_normal_nvram(VL_NORMAL_NVRAM_DATA_PREVIOUS_IMAGE_NAME, &nvData);
            if(NULL != nvData.pData)
            {
                strncpy(pStruct->szSoftwareImageName, (char*)(nvData.pData),VL_MAX_MFR_STR_SIZE-1);
                free(nvData.pData);
            }
        }
        break;

        case VL_STACK_2_MFR_EVENT_get_CURRENT_BOOT_IMAGE_NAME:
        {
            VL_MFR_SOFTWARE_IMAGE_NAME* pStruct = (VL_MFR_SOFTWARE_IMAGE_NAME*)_pvData;
            VL_NVRAM_DATA nvData;
            memset(pStruct, 0, sizeof(*pStruct));
            RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SYS", "%s: Received VL_STACK_2_MFR_EVENT_get_CURRENT_BOOT_IMAGE_NAME\n",  __FUNCTION__);
            memset(&nvData, 0, sizeof(nvData));
            vl_mfr_read_normal_nvram(VL_NORMAL_NVRAM_DATA_BOOT_IMAGE_NAME, &nvData);
            if(NULL != nvData.pData)
            {
                strncpy(pStruct->szSoftwareImageName, (char*)(nvData.pData),VL_MAX_MFR_STR_SIZE-1);
                free(nvData.pData);
            }
        }
        break;

        case VL_STACK_2_MFR_EVENT_get_UPGRADE_IMAGE_NAME:
        {
            VL_MFR_SOFTWARE_IMAGE_NAME* pStruct = (VL_MFR_SOFTWARE_IMAGE_NAME*)_pvData;
            VL_NVRAM_DATA nvData;
            memset(pStruct, 0, sizeof(*pStruct));
            RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SYS", "%s: Received VL_STACK_2_MFR_EVENT_get_UPGRADE_IMAGE_NAME\n",  __FUNCTION__);
            memset(&nvData, 0, sizeof(nvData));
            vl_mfr_read_normal_nvram(VL_NORMAL_NVRAM_DATA_UPGRADE_IMAGE_NAME, &nvData);
            if(NULL != nvData.pData)
            {
                strncpy(pStruct->szSoftwareImageName, (char*)( nvData.pData),VL_MAX_MFR_STR_SIZE-1);
                free(nvData.pData);
            }
        }
        break;

        case VL_STACK_2_MFR_EVENT_get_CONFIG_PATH         :
        {
            VL_MFR_CONFIG_PATH * pStruct = (VL_MFR_CONFIG_PATH*)_pvData;
            //RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SYS", "%s: Received VL_STACK_2_MFR_EVENT_get_CONFIG_PATH\n",  __FUNCTION__);
            return vl_mfr_get_config_path(pStruct->eConfigType, pStruct->szConfigPath);
        }
        break;

        case VL_STACK_2_MFR_EVENT_get_IS_USING_PRODUCTION_KEYS:
        {
            VL_MFR_IS_PRODUCTION_KEY_QUESTION * pStruct = (VL_MFR_IS_PRODUCTION_KEY_QUESTION*)_pvData;
            memset(pStruct, 0, sizeof(*pStruct));
            RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SYS", "%s: Received VL_STACK_2_MFR_EVENT_get_IS_USING_PRODUCTION_KEYS\n",  __FUNCTION__);
            pStruct->bUsingProductionKeys = 0;
            return VL_MFR_API_RESULT_SUCCESS;
        }
        break;

        case VL_STACK_2_MFR_EVENT_get_CALL_DFAST2         :
        {
            VL_MFR_DFAST2_PARAMS * pStruct = (VL_MFR_DFAST2_PARAMS*)_pvData;
            //RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.SYS", "%s: Received VL_STACK_2_MFR_EVENT_get_CALL_DFAST2\n",  __FUNCTION__);
#if 0
            vl_mfr_cable_card_dfast2(pStruct->SeedIn, pStruct->KeyOut);
#endif
            return VL_MFR_API_RESULT_SUCCESS;
        }
        break;

        default:
        {
            RDK_LOG(RDK_LOG_INFO, "LOG.RDK.SYS", "%s: Received VL_STACK_2_MFR_EVENT 0x%08X\n",  __FUNCTION__, eEvent);
        }
        break;
    }
    return VL_MFR_API_RESULT_SUCCESS;
}

VL_MFR_API_RESULT vl_mfr_read_normal_nvram(VL_NORMAL_NVRAM_DATA_TYPE eType, VL_NVRAM_DATA * pNvRamData)
{

    // sample implementation
    int nBytes = 0; unsigned long nActualBytes = 0;
    VL_MFR_API_RESULT result = VL_MFR_API_RESULT_SUCCESS;
    unsigned char * pBuffer = NULL;
    memset(pNvRamData, 0, sizeof(*pNvRamData));

    // simulated read operation
    {
        int nRead = 0;
        char szFileName[128];
        snprintf(szFileName, sizeof(szFileName), "/tmp/vl_normal_nvram_0x%X.bin", eType);
        struct stat statFile;
        FILE * fp = fopen(szFileName, "rb");
        int nStat = stat(szFileName, &statFile);
        if((0 == nStat) && (NULL != fp))
        {
            if(statFile.st_size > 0)
            {
                nBytes = statFile.st_size;
                nBytes -= sizeof(pNvRamData->nActualBytes);
                pBuffer = (unsigned char*)malloc(nBytes);

                if(NULL != pBuffer)
                {
                    fread(&nActualBytes, sizeof(pNvRamData->nActualBytes), 1, fp);
                    memset(pBuffer, 0, nBytes);
                    nRead = fread(pBuffer, 1, nBytes, fp);
                    if(nRead != nBytes)
                    {
                        RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.SYS", "%s: size mismatch (expected %d, read %d) for eType = 0x%X\n", __FUNCTION__, nBytes, nRead, eType);
                        result = VL_MFR_API_RESULT_READ_FAILED;
                    }
                }
                else
                {
                    RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.SYS", "%s: alloc failed for eType = 0x%X\n", __FUNCTION__, eType);
                    result = VL_MFR_API_RESULT_MALLOC_FAILED;
                }
            }
            else
            {
                RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.SYS", "%s: could not stat nvram for eType = 0x%X\n", __FUNCTION__, eType);
                result = VL_MFR_API_RESULT_NOT_EXISTING;
            }
            fclose(fp);
        }
        else
        {
            RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.SYS", "%s: could not open nvram for eType = 0x%X\n", __FUNCTION__, eType);
	    //Coverity fix for 11251 week24.DELIA-4567
            if(fp)
            {
                fclose(fp);
                fp = NULL;
            }
            result = VL_MFR_API_RESULT_OPEN_FAILED;
        }

        if(nRead != nBytes)
        {
            // return failure
            result = VL_MFR_API_RESULT_FAILED;
        }
    }

    // prepare the nvram struct for return
    memset(pNvRamData, 0, sizeof(*pNvRamData));
    pNvRamData->nActualBytes    = nActualBytes;
    pNvRamData->nBytes          = nActualBytes;
    pNvRamData->pData           = pBuffer;

    // return success
    return result;
}

VL_MFR_API_RESULT vl_mfr_write_normal_nvram(VL_NORMAL_NVRAM_DATA_TYPE eType, const VL_NVRAM_DATA * pNvRamData)
{

    // sample implementation
    VL_MFR_API_RESULT result = VL_MFR_API_RESULT_SUCCESS;

    // get the correct byte count
    if(0 == pNvRamData->nBytes)
    {
        memcpy((void *)&(pNvRamData->nBytes), &(pNvRamData->nActualBytes), sizeof(pNvRamData->nBytes));
    }

    // simulated write operation
    {
        char szFileName[128];
        snprintf(szFileName, sizeof(szFileName), "/tmp/vl_normal_nvram_0x%X.bin", eType);
        FILE * fp = fopen(szFileName, "wb");
        if(NULL != fp)
        {
            int nWritten = 0;
            fwrite(&(pNvRamData->nActualBytes), sizeof(pNvRamData->nActualBytes), 1, fp);
            nWritten = fwrite(pNvRamData->pData, 1, pNvRamData->nBytes, fp);
            fclose(fp);
            if(nWritten < pNvRamData->nBytes)
            {
                result = VL_MFR_API_RESULT_WRITE_FAILED;
                RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.SYS", "%s: could not write all bytes to nvram for eType = 0x%X\n", __FUNCTION__, eType);
            }
        }
        else
        {
            result = VL_MFR_API_RESULT_OPEN_FAILED;
            RDK_LOG(RDK_LOG_ERROR, "LOG.RDK.SYS", "%s: could not open nvram for eType = 0x%X\n", __FUNCTION__, eType);
        }
    }

    return result;
}

