
.PHONY: nexus nexus-install nexus-uninstall

##
#
# nexus: ensure that Nexus has already been built.
#
nexus: nexus-master nexus-client nxclient-lib nxclient-server

##
#
# nxClient-lib: build the nxClient library
#
nxclient-lib:
ifeq ($(BUILD_NXCLIENT_LIBRARY),y)
	@$(ECHO) "Building nxClient Library (Nexus mode env: $(NEXUS_MODE))";
	@$(MAKE)  ${MAKE_OPTIONS} -C ${NEXUS_TOP}/nxclient/build
	@if [ ! -e "${NEXUS_BIN_DIR}/libnxclient.so" ]; then \
		$(ECHO) "WARNING: nxClient library not built"; \
		$(FALSE); \
	fi
endif

##
#
# nxclient-server: build the reference software NSC and NIR server application
#
nxclient-server:
ifeq ($(DIRECTFB_MASTER_LIB),y)
ifeq ($(DIRECTFB_NXCLIENT_SUPPORT),y)
	@if [ ! -e "${NEXUS_BIN_DIR}/${NXCLIENT_SERVER}" ]; then \
		$(ECHO) "Building nxClient ${NXCLIENT_SERVER} app (Nexus mode env: $(NEXUS_MODE))"; \
		$(MAKE)  ${MAKE_OPTIONS} NEXUS_LIB_SUFFIX= -C ${NEXUS_TOP}/nxclient server; \
		if [ ! -e "${NEXUS_BIN_DIR}/${NXCLIENT_SERVER}" ]; then \
			$(ECHO) "WARNING: nxClient ${NXCLIENT_SERVER} app not built"; \
			$(FALSE); \
		fi; \
	fi
endif
endif

##
#
# nexus-client: create client Nexus library for use as Nexus slave app.
#
nexus-client:
ifeq ($(DIRECTFB_CLIENT_LIB),y)
	@$(ECHO) "Building client Nexus library (Nexus mode env: $(NEXUS_MODE))";
	@$(MAKE) ${MAKE_OPTIONS} ${NEXUS_MAKE_FLAGS} ${NEXUS_CLIENT_FLAGS} -C ${NEXUS_TOP}/build
	@if [ ! -e "${NEXUS_BIN_DIR}/libnexus${NEXUS_CLIENT_LIB_SUFFIX}.so" -o ! -e "${NEXUS_BIN_DIR}/${NEXUS_DRIVER}" ]; then \
		$(ECHO) "ERROR: Nexus driver not built - please build it first!"; \
		$(FALSE); \
	fi;
ifeq ($(DIRECTFB_NEXUS_AV_SUPPORT),y)
	@$(ECHO) "Building Playback IP library  (Nexus mode env: $(NEXUS_MODE))";
	@$(MAKE)  ${MAKE_OPTIONS} ${NEXUS_MAKE_FLAGS} ${NEXUS_CLIENT_FLAGS} -C ${NEXUS_TOP}/lib/playback_ip/apps install
endif
endif

##
#
# nexus-master: create Nexus library
#
nexus-master:
ifeq ($(DIRECTFB_MASTER_LIB),y)
	@$(ECHO) "Building master Nexus library  (Nexus mode env: $(NEXUS_MODE))";
	@$(MAKE)  ${MAKE_OPTIONS} ${NEXUS_MAKE_FLAGS} NEXUS_LIB_SUFFIX= -C ${NEXUS_TOP}/build
	@if [ ! -e "${NEXUS_BIN_DIR}/libnexus.so" -o ! -e "${NEXUS_BIN_DIR}/${NEXUS_DRIVER}" ]; then \
		$(ECHO) "ERROR: Nexus driver not built - please build it first!"; \
		$(FALSE); \
	fi;
ifeq ($(DIRECTFB_NEXUS_AV_SUPPORT),y)
	@$(ECHO) "Building Playback IP library  (Nexus mode env: $(NEXUS_MODE))";
	@$(MAKE)  ${MAKE_OPTIONS} ${NEXUS_MAKE_FLAGS} NEXUS_LIB_SUFFIX= -C ${NEXUS_TOP}/lib/playback_ip/apps install
endif
endif

##
#
# nexus-install: install necessary nexus files into installation directory.
#
nexus-install: nexus nexus-uninstall
	@$(INSTALL) -m 644 -D ${NEXUS_BIN_DIR}/${NEXUS_DRIVER} ${DIRECTFB_INSTALL_LIB_MODULES_DIR}/${NEXUS_DRIVER};
ifeq  ($(DIRECTFB_MASTER_LIB),y)
	@$(INSTALL) -m 644 -D ${NEXUS_BIN_DIR}/libnexus.so ${DIRECTFB_INSTALL_LIB_DIR}/libnexus.so;
ifeq ($(DIRECTFB_NXCLIENT_SUPPORT),y)
	@$(INSTALL) -m 775 -D ${NEXUS_BIN_DIR}/${NXCLIENT_SERVER} ${DIRECTFB_INSTALL_BIN_DFB_VER_DIR}/${NXCLIENT_SERVER};
endif
endif
ifeq ($(BUILD_NXCLIENT_LIBRARY),y)
	@$(INSTALL) -m 644 -D ${NEXUS_BIN_DIR}/libnxclient.so ${DIRECTFB_INSTALL_LIB_DIR}/libnxclient.so;
endif
ifeq  ($(DIRECTFB_CLIENT_LIB),y)
	@$(INSTALL) -m 644 -D ${NEXUS_BIN_DIR}/libnexus${NEXUS_CLIENT_LIB_SUFFIX}.so ${DIRECTFB_INSTALL_LIB_DIR}/libnexus${NEXUS_CLIENT_LIB_SUFFIX}.so;
endif
ifeq ($(DIRECTFB_NEXUS_AV_SUPPORT),y)
	@$(INSTALL) -m 644 -D ${NEXUS_BIN_DIR}/libb_playback_ip.a ${DIRECTFB_INSTALL_LIB_DIR}/libb_playback_ip.a;
	@$(FIND) $(BSEAV)/lib/livemedia/ -name "lib*.a" -exec $(INSTALL) -m 644 -D {} ${DIRECTFB_INSTALL_LIB_DIR} \; ;
	$(FIND) $(OPENSSL_PATH)/lib -name "lib*.a" -exec $(INSTALL) -m 644 -D {} ${DIRECTFB_INSTALL_LIB_DIR} \; ;
	@if [ -d  "$(NEXUS_TOP)/lib/build/nexus/bin/$(NEXUS_PLATFORM).$(B_REFSW_OS).$(B_REFSW_ARCH).$(B_REFSW_BUILD_TYPE)" ]; then \
		$(FIND) $(NEXUS_TOP)/lib/build/nexus/bin/$(NEXUS_PLATFORM).$(B_REFSW_OS).$(B_REFSW_ARCH).$(B_REFSW_BUILD_TYPE) -name "lib*.a" -exec $(INSTALL) -m 644 -D {} ${DIRECTFB_INSTALL_LIB_DIR} \; ; \
	else \
		$(FIND) $(LIVEMEDIA_DIR) -name "lib*.a" -exec $(INSTALL) -m 644 -D {} ${DIRECTFB_INSTALL_LIB_DIR} \; ; \
	fi
endif

##
#
# nexus-uninstall: uninstall nexus files from the installation directory.
#
nexus-uninstall:

	@if [ -e "${DIRECTFB_INSTALL_LIB_DIR}/libnexus.so" ]; then \
		$(RM) ${DIRECTFB_INSTALL_LIB_DIR}/libnexus.so; \
	fi
	@if [ -e "${DIRECTFB_INSTALL_LIB_DIR}/libnexus${NEXUS_CLIENT_LIB_SUFFIX}.so" ]; then \
		$(RM) ${DIRECTFB_INSTALL_LIB_DIR}/libnexus${NEXUS_CLIENT_LIB_SUFFIX}.so; \
	fi
	@if [ -e "${DIRECTFB_INSTALL_LIB_MODULES_DIR}/nexus.ko" ]; then \
		$(RM) ${DIRECTFB_INSTALL_LIB_MODULES_DIR}/nexus.ko; \
	fi
	@if [ -e "${DIRECTFB_INSTALL_LIB_MODULES_DIR}/bcmdriver.ko" ]; then \
		$(RM) ${DIRECTFB_INSTALL_LIB_MODULES_DIR}/bcmdriver.ko; \
	fi
	@if [ -e "${DIRECTFB_INSTALL_BIN_DFB_VER_DIR}/${NXCLIENT_SERVER}" ]; then \
		$(RM) ${DIRECTFB_INSTALL_BIN_DFB_VER_DIR}/${NXCLIENT_SERVER}; \
	fi
	@if [ -e "${DIRECTFB_INSTALL_LIB_DIR}/libnxclient.so" ]; then \
		$(RM) ${DIRECTFB_INSTALL_LIB_DIR}/libnxclient.so; \
	fi
	@if [ -e "${NEXUS_FLAG}" ]; then \
		$(RM) ${NEXUS_FLAG}; \
	fi

nexus-clean:
ifeq ($(DIRECTFB_NEXUS_AV_SUPPORT),y)
	@$(ECHO) "Cleaning PlaybackIP"
	@$(MAKE)  ${MAKE_OPTIONS} ${NEXUS_MAKE_FLAGS} ${NEXUS_CLIENT_FLAGS} -C ${NEXUS_TOP}/lib/playback_ip/apps clean
	@$(ECHO) "Cleaning LiveMedia"
	@$(MAKE)  ${MAKE_OPTIONS} ${NEXUS_MAKE_FLAGS} ${NEXUS_CLIENT_FLAGS} -C ${BSEAV}/lib/livemedia/blive_ext/build/ clean
endif
ifeq ($(BUILD_NXCLIENT_LIBRARY),y)
	@$(ECHO) "Cleaning NxClient"
	@$(MAKE)  ${MAKE_OPTIONS} -C ${NEXUS_TOP}/nxclient/build clean
endif
	@$(ECHO) "Cleaning Nexus"
	@$(MAKE)  ${MAKE_OPTIONS} -C ${NEXUS_TOP}/build clean
	@if [ -e "${NEXUS_FLAG}" ]; then \
		$(RM) ${NEXUS_FLAG}; \
	fi;
	@$(ECHO) "RefSW clean complete"
##
#
# Dependency target not to be called directly.
#
${NEXUS_FLAG}: check
	@$(ECHO) -e "KERNELMODE=${KERNELMODE}\nNEXUS_MODE=${NEXUS_MODE}" > ${NEXUS_FLAG}.$$$$; \
	if [ -e "${NEXUS_FLAG}" ]; then \
		$(DIFF) ${NEXUS_FLAG} ${NEXUS_FLAG}.$$$$; \
		if [ $$? -eq 1 ] ; then \
			$(CP) ${NEXUS_FLAG}.$$$$ ${NEXUS_FLAG}; \
		fi; \
	else \
		$(CP) ${NEXUS_FLAG}.$$$$ ${NEXUS_FLAG}; \
	fi; \
	$(RM) ${NEXUS_FLAG}.$$$$
