

##
#
# sys-defines: create the directfb system defines.
#
sys-defines:
	@if [ -e "${DIRECTFB_UNPACKED_FLAG}" ]; then \
		$(call fn-create-sys-defines); \
	fi

##
#
# ir-inputmode: create the directfb input defines.
#
ir-inputmode:
	@if [ -e "${DIRECTFB_UNPACKED_FLAG}" ]; then \
		$(call fn-create-ir-inputmode); \
	fi

##
#
# directfb-defines: autogenerate the directfb defines include files.
#
directfb-defines: directfb-source sys-defines ir-inputmode

.PHONY: direcftb-defines sys-defines ir-inputmode

# Find some refsw files ...

ifeq ($(shell test -e ${NEXUS_TOP}/modules/core/include/nexus_video_types.h && echo "y"),y)
NEXUS_VIDEO_TYPES_H := ${NEXUS_TOP}/modules/core/include/nexus_video_types.h
else
NEXUS_VIDEO_TYPES_H := $(shell find ${NEXUS_TOP}/ -name nexus_video_types.h)
ifeq (${NEXUS_VIDEO_TYPES_H}, "")
$(error unknown location of nexus_video_types.h in nexus)
endif
endif

SED_VF = $(SED) -ne "/^typedef enum NEXUS_VideoFormat/,/} NEXUS_VideoFormat/p" "${NEXUS_VIDEO_TYPES_H}"


ifeq ($(shell test -e ${NEXUS_TOP}/modules/ir_input/include/nexus_ir_input.h && echo "y"),y)
NEXUS_IR_INPUT_H := ${NEXUS_TOP}/modules/ir_input/include/nexus_ir_input.h
else
NEXUS_IR_INPUT_H := $(shell find ${NEXUS_TOP}/modules/ir_input -name nexus_ir_input.h)
ifeq (${NEXUS_IR_INPUT_H}, "")
$(error unknown location of nexus_ir_input.h in nexus)
endif
endif

ifeq ($(shell test -e ${MAGNUM}/portinginterface/vdc/include/bvdc.h && echo "y"),y)
MAGNUM_VDC_H := ${MAGNUM}/portinginterface/vdc/include/bvdc.h
else
MAGNUM_VDC_H := $(shell find ${MAGNUM}/portinginterface/vdc/ -name bvdc.h)
ifeq (${MAGNUM_VDC_H},"")
$(error unknown location for bvdc.h in magnum)
endif
endif

ifeq ($(shell test -e ${NEXUS_TOP}/modules/surface_compositor/include/nexus_surface_compositor_types.h && echo "y"),y)
NSC_TYPES_H := ${NEXUS_TOP}/modules/surface_compositor/include/nexus_surface_compositor_types.h
else
NSC_TYPES_H := $(shell find ${NEXUS_TOP}/ -name nexus_surface_compositor_types.h)
ifeq (${NSC_TYPES_H}, "")
$(error unknown location of nexus_surface_compositor_types.h in nexus)
endif
endif

SED_NSC_COMP = $(SED) -ne "/^typedef struct NEXUS_SurfaceComposition/,/} NEXUS_SurfaceComposition/p" "${NSC_TYPES_H}"

ifeq ($(shell test -e ${NEXUS_TOP}/nxclient/include/nxclient_global.h && echo "y"),y)
NXCLIENT_H := ${NEXUS_TOP}/nxclient/include/nxclient_global.h
else
ifeq ($(shell test -e ${NEXUS_TOP}/nxclient/include/nxclient.h && echo "y"),y)
NXCLIENT_H := ${NEXUS_TOP}/nxclient/include/nxclient.h
endif
endif

ifeq ($(DIRECTFB_NXCLIENT_SUPPORT),y)
ifeq (${NXCLIENT_H}, "")
$(error unknown location of nxclient.h or nxclient_global.h in nexus)
endif
endif

SED_NSC_DISP = $(SED) -ne "/^typedef struct NxClient_DisplaySettings/,/} NxClient_DisplaySettings/p" "${NXCLIENT_H}"

##
#
# Function to auto-generate the Broadcom DirectFB System Defines file.
#
define fn-create-sys-defines
	$(CAT) ${DIRECTFB_BRCM_HEADER_FILE} > ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	$(ECHO) "/* This file has been auto-generated by the Broadcom DirectFB Makefile - do NOT delete! */" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	$(ECHO) "#ifndef __BCMNEXUS_SYS_DEFINES_H__" >>  ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	$(ECHO) "#define __BCMNEXUS_SYS_DEFINES_H__" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_eVesa1280x800p_60Hz"); then \
		$(ECHO) "" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_VESA1280X800P_60HZ_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_eVesa1440x900p60hz"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_VESA1440X900P_60HZ_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_eVesa1680x1050p_60Hz"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_VESA1680X1050P_60HZ_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_eVesa1280x800p_60Hz_Red"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_VESA1280X800P_60HZ_RED_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_eVesa1600x1200p_75Hz"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_VESA1600X1200P_75HZ_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_eVesa1600x900p_60Hz_Red"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_VESA1600X900P_60HZ_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_eVesa1680x1050p_60Hz_Red"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_VESA1680X1050P_60HZ_RED_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_eVesa1920x1200p_60Hz"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_VESA1920X1200P_60HZ_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_eVesa1920x1200p_60Hz_Red"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_VESA1920X1200P_60HZ_RED_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_eVesa1152x720p_60Hz"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_VESA1152X720P_60HZ_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_eVesa1152x720p_75Hz"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_VESA1152X720P_75HZ_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_eVesa1152x720p_85Hz"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_VESA1152X720P_85HZ_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_eVesa1152x864p_60Hz"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_VESA1152X864P_60HZ_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_eVesa1152x864p_85Hz"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_VESA1152X864P_85HZ_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_eVesa1152x870p_75Hz"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_VESA1152X870P_75HZ_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_eVesa1152x900p_66Hz"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_VESA1152X900P_66HZ_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_eVesa1152x900p_76Hz"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_VESA1152X900P_76HZ_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_eVesa1170x584p_50Hz"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_VESA1170X584P_50HZ_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_eVesa1280x1024p_70Hz"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_VESA1280X1024P_70HZ_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_eVesa1280x1024p_72Hz"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_VESA1280X1024P_72HZ_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_eVesa1280x1024p_76Hz"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_VESA1280X1024P_76HZ_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_eVesa1280x768p_50Hz"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_VESA1280X768P_50HZ_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_eVesa1280x960p_75Hz"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_VESA1280X960P_75HZ_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_eVesa1600x1024p_60Hz"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_VESA1600X1024P_60HZ_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_eVesa1600x1024p_76Hz"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_VESA1600X1024P_76HZ_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_eVesa1728x1080p_60Hz"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_VESA1728X1080P_60HZ_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_eVesa800x600p_100Hz"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_VESA800X600P_100HZ_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_eVesa800x600p_90Hz"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_VESA800X600P_90HZ_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_eVesa848x480p_75Hz"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_VESA848X480P_75HZ_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_eVesa848x480p_85Hz"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_VESA848X480P_85HZ_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_eVesa852x480p_60Hz"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_VESA852X480P_60HZ_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_e720p_3DOU_AS"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_720P_3DOU_AS_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_e720p50hz_3DOU_AS"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_720P50HZ_3DOU_AS_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_e720p30hz_3DOU_AS"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_720P30HZ_3DOU_AS_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_e720p24hz_3DOU_AS"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_720P24HZ_3DOU_AS_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_e1080p24hz_3DOU_AS"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_1080P24HZ_3DOU_AS_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_e1080p30hz_3DOU_AS"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_1080P30HZ_3DOU_AS_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_eCustom_3D_720p"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_CUSTOM_3D_720P_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_eCustom_3D_720p_50hz"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_CUSTOM_3D_720P_50HZ_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_eCustom_3D_720p_30hz"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_CUSTOM_3D_720P_30HZ_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_eCustom_3D_720p_24hz"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_CUSTOM_3D_720P_24HZ_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_eCustom_3D_1080p_24hz"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_CUSTOM_3D_1080P_24HZ_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if ($(SED_VF) | $(GREP) -qw "NEXUS_VideoFormat_eCustom_3D_1080p_30hz"); then \
		$(ECHO) "#define BCMNEXUS_VIDEOFORMAT_CUSTOM_3D_1080P_30HZ_SUPPORTED" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	$(ECHO) "#define BCMNEXUS_MAX_HD_DISPLAY_WIDTH  1920" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	$(ECHO) "#define BCMNEXUS_MAX_HD_DISPLAY_HEIGHT 1080" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	$(ECHO) "#define BCMNEXUS_MAX_SD_DISPLAY_WIDTH   720" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	$(ECHO) "#define BCMNEXUS_MAX_SD_DISPLAY_HEIGHT  576" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	$(ECHO) -n "#define BCMNEXUS_Z_ORDER_MAX " >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	$(GREP) "#define BVDC_Z_ORDER_MAX" ${MAGNUM_VDC_H} | \
	$(CUT) -d\  -f3- >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	if [ "${DIRECTFB_NSC_SUPPORT}" = "y" -o "${DIRECTFB_NSC_SUPPORT}" = "multibuffer" ]; then \
		$(ECHO) "#define BCMNEXUS_NSC_SUPPORT BCMNEXUS_NSC_MULTIBUFFER_MODE" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if [ "${DIRECTFB_NSC_SUPPORT}" = "tunnelled" ]; then \
		$(ECHO) "#define BCMNEXUS_NSC_SUPPORT BCMNEXUS_NSC_TUNNELLED_MODE" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
		$(ECHO) "DIRECTFB_GFX_PACKET_BUFFER $${DIRECTFB_GFX_PACKET_BUFFER}"; \
	fi; \
	if [ "${DIRECTFB_NIR_SUPPORT}" = "y" ]; then \
		$(ECHO) "#define BCMNEXUS_NIR_SUPPORT 1" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if [ "${DIRECTFB_NXCLIENT_SUPPORT}" = "y" ]; then \
		$(ECHO) "#define BCMNEXUS_NXCLIENT_SUPPORT 1" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
		if ($(SED_NSC_COMP) | $(GREP) -qw "colorKey"); then \
			$(ECHO) "#define BCMNEXUS_NSC_COLORKEY_SUPPORT 1" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
		else \
			$(ECHO) "#define BCMNEXUS_NSC_COLORKEY_SUPPORT 0" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
		fi; \
		if ($(SED_NSC_DISP) | $(GREP) -qw "backgroundColor"); then \
			$(ECHO) "#define BCMNEXUS_NSC_DISPLAY_BGCOLOR_SUPPORT 1" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
		else \
			$(ECHO) "#define BCMNEXUS_NSC_DISPLAY_BGCOLOR_SUPPORT 0" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
		fi; \
		if ($(SED_NSC_DISP) | $(GREP) -qw "display3DSettings"); then \
			$(ECHO) "#define BCMNEXUS_NSC_DISPLAY_3D_SUPPORT 1" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
		else \
			$(ECHO) "#define BCMNEXUS_NSC_DISPLAY_3D_SUPPORT 0" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
		fi; \
	fi; \
	if [ "${DIRECTFB_ASAL_SUPPORT}" = "y" ]; then \
		$(ECHO) "#define BCMNEXUS_ASAL_SUPPORT 1" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if [ "${DIRECTFB_GFX_3D}" = "v3d" ]; then \
		$(ECHO) "#define BCMNEXUS_GFX_HAS_V3D" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if [ "${DIRECTFB_GFX_PACKET_BUFFER}" = "y" ]; then \
	        $(ECHO) "#define BCMNEXUS_GFX_PACKET_BUFFER" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
        fi; \
	if [ "${DIRECTFB_HW_DITHERING}" = "y" ]; then \
		$(ECHO) "#define BCMNEXUS_HW_DITHERING 1" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if [ "${NEXUS_PLATFORM}" = "97445" -o "${NEXUS_PLATFORM}" = "97251" -o "${DIRECTFB_4K_DISPLAY_SUPPORT}" = "y" ]; then \
		$(ECHO) "#define BCMNEXUS_HAS_4K_DISPLAY_SUPPORT 1" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	else \
		$(ECHO) "#define BCMNEXUS_HAS_4K_DISPLAY_SUPPORT 0" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if [ "${DIRECTFB_SET_HDMI_INFO_FRAME}" = "y" ]; then \
		$(ECHO) "#define BCMNEXUS_SET_HDMI_INFO_FRAME 1" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	else \
		$(ECHO) "#define BCMNEXUS_SET_HDMI_INFO_FRAME 0" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	if [ "${DIRECTFB_SET_HDMI_COLORSPACE}" = "y" ]; then \
		$(ECHO) "#define BCMNEXUS_SET_HDMI_COLORSPACE 1" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	else \
		$(ECHO) "#define BCMNEXUS_SET_HDMI_COLORSPACE 0" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	fi; \
	$(ECHO) "#endif /* __BCMNEXUS_SYS_DEFINES_H__ */" >> ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
	if [ -e "${DIRECTFB_SYS_DEFINES_FILE}" ]; then \
		$(DIFF) ${DIRECTFB_SYS_DEFINES_FILE} ${DIRECTFB_SYS_DEFINES_FILE}.$$$$; \
		if [ $$? -eq 1 ] ; then \
			$(CP) ${DIRECTFB_SYS_DEFINES_FILE}.$$$$ ${DIRECTFB_SYS_DEFINES_FILE}; \
		fi; \
	else \
		$(CP) ${DIRECTFB_SYS_DEFINES_FILE}.$$$$ ${DIRECTFB_SYS_DEFINES_FILE}; \
	fi; \
	$(RM) ${DIRECTFB_SYS_DEFINES_FILE}.$$$$
endef

##
#
# Function to auto-generate the Broadcom DirectFB IR InputMode file.
#
define fn-create-ir-inputmode
	$(CAT) ${DIRECTFB_BRCM_HEADER_FILE} > ${DIRECTFB_IR_INPUTMODE_FILE}.$$$$; \
	$(ECHO) "/* This file has been auto-generated by the Broadcom DirectFB Makefile - do NOT modify! */" >> ${DIRECTFB_IR_INPUTMODE_FILE}.$$$$; \
	$(ECHO) "#ifndef __BCMNEXUS_IR_INPUTMODE_H__" >>  ${DIRECTFB_IR_INPUTMODE_FILE}.$$$$; \
	$(ECHO) "#define __BCMNEXUS_IR_INPUTMODE_H__" >> ${DIRECTFB_IR_INPUTMODE_FILE}.$$$$; \
	$(ECHO) "" >> ${DIRECTFB_IR_INPUTMODE_FILE}.$$$$; \
	$(ECHO) "#include <strings.h>" >> ${DIRECTFB_IR_INPUTMODE_FILE}.$$$$; \
	$(ECHO) "" >> ${DIRECTFB_IR_INPUTMODE_FILE}.$$$$; \
	$(ECHO) "typedef enum DFB_PlatformIrInputMode_s" >> ${DIRECTFB_IR_INPUTMODE_FILE}.$$$$; \
	$(ECHO) "{" >> ${DIRECTFB_IR_INPUTMODE_FILE}.$$$$; \
	$(ECHO) "    DFB_PlatformIrInputMode_eMin = 0," >> ${DIRECTFB_IR_INPUTMODE_FILE}.$$$$; \
	for ir in `$(CPP) -dD ${BRCM_CFLAGS} ${NEXUS_IR_INPUT_H} | \
	$(SED) -ne "/^typedef enum NEXUS_IrInputMode/,/} NEXUS_IrInputMode/p" | $(SED) -ne "/NEXUS_IrInputMode_e/p" | \
	$(SED) -e "/NEXUS_IrInputMode_eMax/d" | $(CUT) -d, -f1|cut -d= -f1 | $(SED) -e "s/NEXUS_IrInputMode_//g"`; do \
	    $(ECHO) "    DFB_PlatformIrInputMode_$$ir," >> ${DIRECTFB_IR_INPUTMODE_FILE}.$$$$; \
	       done; \
	$(ECHO) "    DFB_PlatformIrInputMode_eMax">> ${DIRECTFB_IR_INPUTMODE_FILE}.$$$$; \
	$(ECHO) "} DFB_PlatformIrInputMode;" >> ${DIRECTFB_IR_INPUTMODE_FILE}.$$$$; \
	$(ECHO) "" >> ${DIRECTFB_IR_INPUTMODE_FILE}.$$$$; \
	$(ECHO) "static const char *DFB_PlaformIrInputModeName_Table[] = " >> ${DIRECTFB_IR_INPUTMODE_FILE}.$$$$; \
	$(ECHO) "{" >> ${DIRECTFB_IR_INPUTMODE_FILE}.$$$$; \
	$(ECHO) " \"CirNone\"," >> ${DIRECTFB_IR_INPUTMODE_FILE}.$$$$; \
	for ir in `$(CPP) -dD ${BRCM_CFLAGS} "${NEXUS_IR_INPUT_H}" | \
	$(SED) -ne "/^typedef enum NEXUS_IrInputMode/,/} NEXUS_IrInputMode/p" | $(SED) -ne "/NEXUS_IrInputMode_e/p" | \
	$(SED) -e "/NEXUS_IrInputMode_eMax/d" | $(CUT) -d, -f1|cut -d= -f1 | $(SED) -e "s/NEXUS_IrInputMode_e//g"`; do \
	    $(ECHO) " \"$$ir\"," >> ${DIRECTFB_IR_INPUTMODE_FILE}.$$$$; \
	       done; \
	$(ECHO) "};" >> ${DIRECTFB_IR_INPUTMODE_FILE}.$$$$; \
	$(ECHO) "" >> ${DIRECTFB_IR_INPUTMODE_FILE}.$$$$; \
	$(ECHO) "static inline DFB_PlatformIrInputMode DFB_PlatformLookupIrInputmode (const char* name) {" >> ${DIRECTFB_IR_INPUTMODE_FILE}.$$$$; \
               $(ECHO) "    unsigned int inputMode;" >> ${DIRECTFB_IR_INPUTMODE_FILE}.$$$$; \
               $(ECHO) "    for (inputMode = 0; inputMode < DFB_PlatformIrInputMode_eMax; inputMode++)" >> ${DIRECTFB_IR_INPUTMODE_FILE}.$$$$; \
               $(ECHO) "    { " >> ${DIRECTFB_IR_INPUTMODE_FILE}.$$$$; \
               $(ECHO) "        if (strcasecmp(name, DFB_PlaformIrInputModeName_Table[inputMode]) == 0)" >> ${DIRECTFB_IR_INPUTMODE_FILE}.$$$$; \
               $(ECHO) "            return (DFB_PlatformIrInputMode)inputMode;" >> ${DIRECTFB_IR_INPUTMODE_FILE}.$$$$; \
               $(ECHO) "    }" >> ${DIRECTFB_IR_INPUTMODE_FILE}.$$$$; \
               $(ECHO) "" >> ${DIRECTFB_IR_INPUTMODE_FILE}.$$$$; \
               $(ECHO) "    return DFB_PlatformIrInputMode_eMax;" >> ${DIRECTFB_IR_INPUTMODE_FILE}.$$$$; \
               $(ECHO) "}" >> ${DIRECTFB_IR_INPUTMODE_FILE}.$$$$; \
	$(ECHO) "" >> ${DIRECTFB_IR_INPUTMODE_FILE}.$$$$; \
	$(ECHO) "#ifdef __cplusplus" >> ${DIRECTFB_IR_CONVERT_FILE}.$$$$; \
	$(ECHO) "}" >> ${DIRECTFB_IR_CONVERT_FILE}.$$$$; \
	$(ECHO) "#endif" >> ${DIRECTFB_IR_CONVERT_FILE}.$$$$; \
	$(ECHO) "" >> ${DIRECTFB_IR_INPUTMODE_FILE}.$$$$; \
	$(ECHO) "#endif /* __BCMNEXUS_IR_INPUTMODE_H__ */" >> ${DIRECTFB_IR_INPUTMODE_FILE}.$$$$; \
	if [ -e "${DIRECTFB_IR_INPUTMODE_FILE}" ]; then \
		$(DIFF) ${DIRECTFB_IR_INPUTMODE_FILE} ${DIRECTFB_IR_INPUTMODE_FILE}.$$$$; \
		if [ $$? -eq 1 ] ; then \
			$(CP) ${DIRECTFB_IR_INPUTMODE_FILE}.$$$$ ${DIRECTFB_IR_INPUTMODE_FILE}; \
		fi; \
	else \
		$(CP) ${DIRECTFB_IR_INPUTMODE_FILE}.$$$$ ${DIRECTFB_IR_INPUTMODE_FILE}; \
	fi; \
	$(RM) ${DIRECTFB_IR_INPUTMODE_FILE}.$$$$; \
	$(CAT) ${DIRECTFB_BRCM_HEADER_FILE} > ${DIRECTFB_IR_CONVERT_FILE}.$$$$; \
	$(ECHO) "/* This file has been auto-generated by the Broadcom DirectFB Makefile - do NOT delete! */" >> ${DIRECTFB_IR_CONVERT_FILE}.$$$$; \
	$(ECHO) "#ifndef __BCMNEXUS_IR_CONVERT_H__" >>  ${DIRECTFB_IR_CONVERT_FILE}.$$$$; \
	$(ECHO) "#define __BCMNEXUS_IR_CONVERT_H__" >> ${DIRECTFB_IR_CONVERT_FILE}.$$$$; \
	$(ECHO) "" >> ${DIRECTFB_IR_CONVERT_FILE}.$$$$; \
	$(ECHO) "#ifdef __cplusplus" >> ${DIRECTFB_IR_CONVERT_FILE}.$$$$; \
	$(ECHO) "extern \"C\"" >> ${DIRECTFB_IR_CONVERT_FILE}.$$$$; \
	$(ECHO) "{" >> ${DIRECTFB_IR_CONVERT_FILE}.$$$$; \
	$(ECHO) "#endif" >> ${DIRECTFB_IR_CONVERT_FILE}.$$$$; \
	$(ECHO) "" >> ${DIRECTFB_IR_CONVERT_FILE}.$$$$; \
	$(ECHO) "const NEXUS_IrInputMode " >> ${DIRECTFB_IR_CONVERT_FILE}.$$$$; \
	$(ECHO) "DFB_Platform_P_DFBtoNexusIrModeTable[] =" >> ${DIRECTFB_IR_CONVERT_FILE}.$$$$; \
	$(ECHO) "{" >> ${DIRECTFB_IR_CONVERT_FILE}.$$$$; \
	for ir in `$(CPP) -dD ${BRCM_CFLAGS} "${NEXUS_IR_INPUT_H}" | \
	$(SED) -ne "/^typedef enum NEXUS_IrInputMode/,/} NEXUS_IrInputMode/p" | $(SED) -ne "/NEXUS_IrInputMode_e/p" | \
	$(SED) -e "/NEXUS_IrInputMode_eMax/d" | $(CUT) -d, -f1|cut -d= -f1 | $(SED) -e "s/NEXUS_IrInputMode_e//g"`; do \
	    $(ECHO) "    [DFB_PlatformIrInputMode_e$$ir] = NEXUS_IrInputMode_e$$ir," >> ${DIRECTFB_IR_CONVERT_FILE}.$$$$; \
	       done; \
	$(ECHO) "};" >> ${DIRECTFB_IR_CONVERT_FILE}.$$$$; \
	$(ECHO) "" >> ${DIRECTFB_IR_CONVERT_FILE}.$$$$; \
	$(ECHO) "" >> ${DIRECTFB_IR_CONVERT_FILE}.$$$$; \
	$(ECHO) "const DFB_PlatformIrInputMode " >> ${DIRECTFB_IR_CONVERT_FILE}.$$$$; \
	$(ECHO) "DFB_Platform_P_NexustoDFBIrModeTable[] =" >> ${DIRECTFB_IR_CONVERT_FILE}.$$$$; \
	$(ECHO) "{" >> ${DIRECTFB_IR_CONVERT_FILE}.$$$$; \
	for ir in `$(CPP) -dD ${BRCM_CFLAGS} "${NEXUS_IR_INPUT_H}" | \
	$(SED) -ne "/^typedef enum NEXUS_IrInputMode/,/} NEXUS_IrInputMode/p" | $(SED) -ne "/NEXUS_IrInputMode_e/p" | \
	$(SED) -e "/NEXUS_IrInputMode_eMax/d" | $(CUT) -d, -f1|cut -d= -f1 | $(SED) -e "s/NEXUS_IrInputMode_e//g"`; do \
	    $(ECHO) "    [NEXUS_IrInputMode_e$$ir] = DFB_PlatformIrInputMode_e$$ir," >> ${DIRECTFB_IR_CONVERT_FILE}.$$$$; \
	       done; \
	$(ECHO) "};" >> ${DIRECTFB_IR_CONVERT_FILE}.$$$$; \
	$(ECHO) "" >> ${DIRECTFB_IR_CONVERT_FILE}.$$$$; \
	$(ECHO) "#endif /* __BCMNEXUS_IR_CONVERT_H__ */" >> ${DIRECTFB_IR_CONVERT_FILE}.$$$$; \
	if [ -e "${DIRECTFB_IR_CONVERT_FILE}" ]; then \
		$(DIFF) ${DIRECTFB_IR_CONVERT_FILE} ${DIRECTFB_IR_CONVERT_FILE}.$$$$; \
		if [ $$? -eq 1 ] ; then \
			$(CP) ${DIRECTFB_IR_CONVERT_FILE}.$$$$ ${DIRECTFB_IR_CONVERT_FILE}; \
		fi; \
	else \
		$(CP) ${DIRECTFB_IR_CONVERT_FILE}.$$$$ ${DIRECTFB_IR_CONVERT_FILE}; \
	fi; \
	$(RM) ${DIRECTFB_IR_CONVERT_FILE}.$$$$
endef
