 /******************************************************************************
* Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors. 
* All rights reserved.
*
* This software is the confidential and proprietary information of SeaChange
* ("Confidential Information"). You shall not disclose this source code or 
* such Confidential Information and shall use it only in accordance with the 
* terms of the license agreement you entered into.
*  
* SEACHANGE INERNATIONAL  MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
* SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT 
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SEACHANGE SHALL NOT BE LIABLE FOR 
* ANY DAMAGES SUFFERED BY LICENSEE NOR SHALL THEY BE RESPONSIBLE AS A RESULT 
* OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*******************************************************************************/



#include "rmf_osal_event.h"

#include "halpodclass.h"
#include "pod_api.h"
#include "vlpluginapp_halpodapi.h"
#include <string.h>

#include "rdk_debug.h"

static DEVICE_HANDLE_t		hPODHandle[MAX_CABLECARD_DEVICES];
static POD_CAPABILITIES_t	stPodCap;
static EXTDEV_CAPABILITIES_t 	stExtDevCapabilities;
static BOOLEAN			connectedToPOD		;
static unsigned long		prevTunerHandle;

CHALPod::CHALPod()
 : cableCardDriver()
{
    RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.TARGET","CHALPod::CHALPod\n");
    prevTunerHandle = 0;
    connectedToPOD = 0;
}

CHALPod::~CHALPod()
{
    RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.TARGET","CHALPod::~CHALPod\n");
}


void CHALPod::initialize()
{
   	RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.TARGET","CHALPod::initialize start...\n");

	for(int i=0; i < MAX_CABLECARD_DEVICES ; i++)
	{

		hPODHandle[i] = 0;
	}

	HAL_POD_GetCapabilities(&stPodCap);
    RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.TARGET","\tNum POD Devices: %d\n", stPodCap.usNumPODs);
    for( int i = 0; i < stPodCap.usNumPODs; i++ )
    {
        RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.TARGET","\t  POD %d hDeviceHandle  :    %08X\n", i,
               (unsigned int)stPodCap.astInstanceCapabilities[i].hPODHandle);
    }

    //HAL_EXTDEV_GetCapabilities(&stExtDevCapabilities);
    memset(&stExtDevCapabilities, 0, sizeof(stExtDevCapabilities));
    RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.TARGET","\tNum EXTDEV POD Devices: %d\n", stExtDevCapabilities.usNumPOD);
    for( int i = 0; i < stExtDevCapabilities.usNumPOD; i++ )
    {
        RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.TARGET","\t  POD %d hDeviceHandle  :    %08X\n", i,
            (unsigned int)stExtDevCapabilities.stPODCapabilities[i].hDeviceHandle);
        RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.TARGET","\t  POD %d eDeviceMode    :    %08X\n", i,
            (unsigned int)stExtDevCapabilities.stPODCapabilities[i].eDeviceMode);
    }

	return;
}

int CHALPod::get_device_count()
{

	return stPodCap.usNumPODs;
}

int
CHALPod::open_device(int device_instance)
{
    DEVICE_HANDLE_t shPODHandle;
	RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.TARGET","CHALPod::open_device %d ...\n",device_instance);

	shPODHandle = stPodCap.astInstanceCapabilities[device_instance].hPODHandle;

	HAL_POD_Request(shPODHandle);

	hPODHandle[device_instance] = shPODHandle;

    return shPODHandle;
}


int
CHALPod::close_device(int device_instance)
{
	RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.TARGET","CHALPod::close_device  ...\n");



	//HAL_POD_Release(hPODHandle);
	hPODHandle[device_instance] = 0;

	return 0;
}



int
CHALPod::register_callback(eCallbackType type, void *func_ptr, int device_instance)
{
DEVICE_HANDLE_t hPODHandle = GetHandleFromInstance(device_instance);

	if(type == NOTIFY_CARD_DETECTION_CB)
	{
		HAL_POD_SetNotify ( hPODHandle, func_ptr, POD_NOTIFY_CARD_DETECT, NULL);
	}
	else if(type == NOTIFY_POD_POLL_CMD_CB)
	{
		HAL_POD_SetNotify ( hPODHandle, func_ptr, POD_NOTIFY_SEND_POD_POLL, NULL);
	}
	else if(type == NOTIFY_DATA_AVAILABLE_CB)
	{
		HAL_POD_SetNotify ( hPODHandle, func_ptr, POD_NOTIFY_DATA_AVAILABLE, NULL);
	}
	else if(type == NOTIFY_EXTCH_DATA_AVAILABLE_CB)
	{
		HAL_POD_SetNotify ( hPODHandle,func_ptr, POD_NOTIFY_EXTCH_DATA_AVAILABLE, NULL);
	}

	return 0;
}



int
CHALPod::send_data(void *ptr, CHANNEL_TYPE_T  type, int device_instance)
{
    DEVICE_HANDLE_t hPODHandle = GetHandleFromInstance(device_instance);
	HAL_POD_Send_Data( hPODHandle, (POD_BUFFER*)ptr, (POD_CHANNEL_TYPE_T) type, NULL);
	return 0;
}


int  CHALPod::configPodCipher(unsigned char ltsid,unsigned short PrgNum,unsigned long *decodePid,unsigned long numpids,unsigned long DesKeyAHi,unsigned long DesKeyALo,unsigned long DesKeyBHi,unsigned long DesKeyBLo,void *pStrPtr)
{
  return HAL_POD_CONFIG_CIPHER(ltsid,PrgNum,decodePid,numpids,DesKeyAHi,DesKeyALo,DesKeyBHi,DesKeyBLo,pStrPtr);
}

int  CHALPod::stopconfigPodCipher(unsigned char ltsid,unsigned short PrgNum,unsigned long *decodePid,unsigned long numpids)
{
  //printf("stopconfigPodCipher: calling HAL_POD_STOP_CONFIG_CIPHER \n");
  return HAL_POD_STOP_CONFIG_CIPHER(ltsid,PrgNum,decodePid,numpids);
}
DEVICE_HANDLE_t
CHALPod::GetHandleFromInstance(int device_instance)
{
//	return hPODHandle[device_instance];
    return (DEVICE_HANDLE_t)stPodCap.astInstanceCapabilities[device_instance].hPODHandle;
	//return stExtDevCapabilities.stPODCapabilities[device_instance].hDeviceHandle;
}


void	CHALPod::ConnectSourceToPOD(unsigned long tuner_in_handle)
{
 DEVICE_HANDLE_t    hPODSourceHandle,hPODDestinationHandle;
	if((!connectedToPOD) || (prevTunerHandle != tuner_in_handle))
	{
	 	RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.TARGET","CHALPod::ConnectSourceToPOD\n");
		hPODSourceHandle = stExtDevCapabilities.stPODCapabilities[0].hDeviceHandle;
		hPODDestinationHandle = stExtDevCapabilities.stPODCapabilities[1].hDeviceHandle;
		//HAL_EXTDEV_AddSource( hPODDestinationHandle, (DEVICE_HANDLE_t)tuner_in_handle ); //connect tuner to
		//HAL_EXTDEV_AddSource( hPODDestinationHandle, tuner_in_handle );

		connectedToPOD = 1;
		prevTunerHandle = tuner_in_handle;
	}
}



void	CHALPod::DisconnectSourceFromPOD(unsigned long tuner_in_handle)
{




}

extern "C" int    CHALPod_oob_control(int device_instance, VL_OOB_COMMAND eCommand, void * pData)
{
    HAL_POD_OOB_Control( 0, (UINT32*)pData, eCommand);
    return 0;
}

extern "C" int    CHALPod_if_control(int device_instance, VL_POD_IF_COMMAND eCommand, void * pData)
{
    HAL_POD_IF_Control( 0, (UINT32*)pData, eCommand);
    return 0;
}

int    CHALPod::oob_control(int device_instance, unsigned long eCommand, void * pData)
{

    DEVICE_HANDLE_t hPODHandle = GetHandleFromInstance(device_instance);

    HAL_POD_OOB_Control( hPODHandle, (UINT32*)pData, eCommand);
    return 0;
}

int    CHALPod::if_control(int device_instance, unsigned long eCommand, void * pData)
{

    DEVICE_HANDLE_t hPODHandle = GetHandleFromInstance(device_instance);

    HAL_POD_IF_Control( hPODHandle, (UINT32*)pData, eCommand);
    return 0;
}



