/******************************************************************************
* Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors. 
* All rights reserved.
*
* This software is the confidential and proprietary information of SeaChange
* ("Confidential Information"). You shall not disclose this source code or 
* such Confidential Information and shall use it only in accordance with the 
* terms of the license agreement you entered into.
*  
* SEACHANGE INERNATIONAL  MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
* SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT 
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SEACHANGE SHALL NOT BE LIABLE FOR 
* ANY DAMAGES SUFFERED BY LICENSEE NOR SHALL THEY BE RESPONSIBLE AS A RESULT 
* OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*******************************************************************************/



#ifndef POD_PRIV_H
#define POD_PRIV_H

#ifdef __cplusplus
extern "C" {
#endif

/*-------------------------------------------------------------------
   Include Files
-------------------------------------------------------------------*/



/*-------------------------------------------------------------------
   Defines/Macros
-------------------------------------------------------------------*/
 #define POD_NUM_OF_MODES   1


 // Please Reference ../Refsw/mangnum/portinterface/i2c/i2c_pio/i2c_pio.h
#ifndef I2C_SUCCESS
#define I2C_SUCCESS             1
#endif

 #define CIMAX_MOD_CTRL               0x00
#define CIMAX_A_AUTOSEL_MASK_H       0x01
#define CIMAX_A_AUTOSEL_MASK_L       0x02
#define CIMAX_A_AUTOSEL_PAT_H        0x03
#define CIMAX_A_AUTOSEL_PAT_L        0x04
#define CIMAX_A_ACCESS_TIME          0x05
#define CIMAX_B_AUTOSEL_MASK_H       0x0A
#define CIMAX_B_AUTOSEL_MASK_L       0x0B
#define CIMAX_B_AUTOSEL_PAT_H        0x0C
#define CIMAX_B_AUTOSEL_PAT_L        0x0D
#define CIMAX_B_ACCESS_TIME          0x0E
#define CIMAX_XAUTOSEL_MASK_H        0x12
#define CIMAX_DEST_SEL               0x17
#define CIMAX_PWR_CTRL               0x18
#define CIMAX_INT_STAT               0x1A
#define CIMAX_INT_MASK               0x1B
#define CIMAX_INT_CNF                0x1C
#define CIMAX_PROC_CNF               0x1D
#define CIMAX_ACK_CNF                0x1E
#define CIMAX_CIM_CTRL               0x1F
#define CIMAX_TS_CNF                 0x20    /* Transport Stream Configuration reg */
#define CIMAX_SYNC                   0x21    /* Synchronization Reg */

#define BIT0                         ( 1 << 0 )
#define BIT1                         ( 1 << 1 )
#define BIT2                         ( 1 << 2 )
#define BIT3                         ( 1 << 3 )
#define BIT4                         ( 1 << 4 )
#define BIT5                         ( 1 << 5 )
#define BIT6                         ( 1 << 6 )
#define BIT7                         ( 1 << 7 )

#define CIMAX_MOD_CTRL_RST           BIT7
#define CIMAX_MOD_CTRL_TSOEN         BIT6
#define CIMAX_MOD_CTRL_TSIEN         BIT5
#define CIMAX_MOD_CTRL_HAD           BIT4
#define CIMAX_MOD_CTRL_ACS1          BIT3
#define CIMAX_MOD_CTRL_ACS0          BIT2
#define CIMAX_MOD_CTRL_AUTO          BIT1
#define CIMAX_MOD_CTRL_DET           BIT0

/* These are bit masks that apply to the TS_CNF (transport configuration) reg */
#define CIMAX_TS_CNF_SERI            BIT0    /* Serial Input / Parallel input */
#define CIMAX_TS_CNF_ICE             BIT1    /* Input TS Clock Edge in serial mode */
#define CIMAX_TS_CNF_SERO            BIT4    /* Serial Output / Parallel output */
#define CIMAX_TS_CNF_OCE             BIT5    /* Output TS clock edge select in serial mode */


/* The following section is used for GPIO purpose */
#define GPIO_20                      20
#define GPIO_32                      32
#define GPIO_42                      42
#define GPIO_43                      43
#define GPIO_44                      44
#define GPIO_46                      46
#define GPIO_53                      53
#define GPIO_54                      54

#define GPIO_20_BIT_POS              1 << GPIO_20
#define GPIO_42_BIT_POS              1 << (GPIO_42 - GPIO_32)
#define GPIO_43_BIT_POS              1 << (GPIO_43 - GPIO_32)
#define GPIO_44_BIT_POS              1 << (GPIO_44 - GPIO_32)
#define GPIO_46_BIT_POS              1 << (GPIO_46 - GPIO_32)
#define GPIO_53_BIT_POS              1 << (GPIO_53 - GPIO_32)
#define GPIO_54_BIT_POS              1 << (GPIO_54 - GPIO_32)

#define GPIO_20_PIN_MUX_SEL          0x01C00000         // Bits Position 24:22 in SUN_TOP_CTRL_PIN_MUX_CTRL_6
#define GPIO_42_PIN_MUX_SEL          0x001C0000         // Bits Position 20:18 in SUN_TOP_CTRL_PIN_MUX_CTRL_8
#define GPIO_43_PIN_MUX_SEL          0x00E00000         // Bits Position 23:21 in SUN_TOP_CTRL_PIN_MUX_CTRL_8
#define GPIO_44_PIN_MUX_SEL          0X07000000         // Bits Position 26;24 in SUN_TOP_CTRL_PIN_MUX_CTRL_8
#define GPIO_46_PIN_MUX_SEL          0x00000007         // Bits Position 2:0 in SUN_TOP_CTRL_PIN_MUX_CTRL_9
#define GPIO_53_PIN_MUX_SEL          0x00E00000         // Bits Position 23:21 in SUN_TOP_CTRL_PIN_MUX_CTRL_9
#define GPIO_54_PIN_MUX_SEL          0x07000000         // Bits Position 26:24 in SUN_TOP_CTRL_PIN_MUX_CTRL_9


#define POD_ADDR_SIZE                0x00800000         // 8MB for POD

#ifndef MR06_P0
#define POD_PHYS_ADDR                0x19800000
#else
#define POD_PHYS_ADDR                0x1a000000
#endif

//#define POD_FPGA_ADDR_SIZE                0x00800000         // 8MB for POD
#ifdef MR06_P0
#define POD_FPGA_PHYS_ADDR                0x1a008000    //0x19800000
#endif

#define POD_EBI_CONFIG               ( BCHP_EBI_CS_CONFIG_4_mask_en_MASK  | BCHP_EBI_CS_CONFIG_4_m68k_MASK |     \
                                       BCHP_EBI_CS_CONFIG_4_le_MASK       | BCHP_EBI_CS_CONFIG_4_size_sel_MASK | \
                                       BCHP_EBI_CS_CONFIG_4_sync_MASK     | BCHP_EBI_CS_CONFIG_4_enable_MASK )

#ifdef	MR06_P0
#define POD_FPGA_EBI_CONFIG               ( BCHP_EBI_CS_CONFIG_4_m68k_MASK |     \
                                       BCHP_EBI_CS_CONFIG_4_le_MASK      |   BCHP_EBI_CS_CONFIG_4_size_sel_MASK | \
                                       BCHP_EBI_CS_CONFIG_4_sync_MASK     | BCHP_EBI_CS_CONFIG_4_enable_MASK )
#endif

#define POLL_FOR_READY_TIMEOUT          500
#define MAX_POLL_FOR_READY_DURATION     5000
#define POD_REG_MASK_IRQ_IRQA           0x04



#define POD_FPGA_PC_CARD_MODE		0x1
#define POD_FPGA_SCARD_MODE		0x2
#define POD_FPGA_MCARD_MODE		0x3

#define CHIPSET_CIMAX			0
#define CHIPSET_SONY			1

/*-------------------------------------------------------------------
   Types/Structs
-------------------------------------------------------------------*/
/*
typedef enum
{
    SHUTDOWN,
    TUNE,
    LOCK_STATUS,
    GEN_STATUS
} POD_CMD_t;
*/





typedef enum
{
    POD_STAND_BY_MODE,
    POD_PROHIBIT_MODE,
    POD_3_VOTS_MODE,
    POD_5_VOTS_MODE,
    POD_UNKNOW_MODE
}POD_OPERATION_MODE_t;



typedef enum
{
    POD_MODULE_ATTRIBUTE_MODE,
    POD_MODULE_IO_MODE,
    POD_MODULE_COMMON_MODE,
    POD_MODULE_EXT_CHANNEL_MODE
}POD_MODULE_ACCESS_MODE_t;


typedef enum
{
    vlPOD_SUCCESS,
    vlPOD_FAIL,
	vlPOD_NODATA,
 }POD_STATUS;

typedef struct Cimax_Handle
{
//    BREG_I2C_Handle  hI2c;              /* handle to the master I2C device */
//      vlHANDLE  hI2c;              /* handle to the master I2C device */
#if 0
    void (*interruptEnableFunc)(bool);  /* callback function for enabling/disabling L1 interrupt */
    BKNI_EventHandle hInterruptEvent;   /* interrupt event handle */
    BKNI_EventHandle hLockChangeEvent;  /* change of lock status event handle */
    BKNI_EventHandle hInitDoneEvent;    /* AP initialization done event handle */
    BKNI_EventHandle hHabDoneEvent;     /* HAB done event handle */
    BKNI_EventHandle hMi2cDoneEvent;    /* MI2C done event handle */

    bool             lock;              /* Lock status from STAT2 register */
    uint8_t          last_page_16_15;   /* most recent position of the 128 byte window into the AP address space */
    uint8_t          last_page_14_7;    /* most recent position of the 128 byte window into the AP address space */
    uint8_t          last_mbox_15_8;    /* most recent position of the IO MBOX window */
    uint8_t          mi2c_slave_addr;   /* last mi2c slave addr */
	/* master i2c addr */
    //a kanari 2004.10.6 AP Microcode Version
    // this value is set by b3520_get_version() in b3520.c only.
    uint8_t          ap_microcode_vers;
    uint8_t          mi2c_speed;   	/* mi2c speed */
 #endif
    UINT8	     i2c_addr;
    UINT8	     index;		/* tuner index (0 or 1) */
} Cimax_Handle;

//For ATI

#if 0

typedef struct
{
    CORE_QUEUE_ID podNotifyQueue; // Queue receiving notification about CableCard
    UINT32 cardInserted;  // boolean indicating whether a card has been inserted or no
    UINT32 validCablecard; // boolean indicating that card is a cablecard (passes CIS checks)
    UINT32 CORAddr; // address of the COR register
    UINT32 TPCE_Indx; // value that needs to written to COR for personality change
    T_HAL_POD_MODULE_MODE cardType;
    UINT32 testModeAuto;  // To keep the auto-mode level
    CORE_TASK_ID mspiPktProcTaskId; // A task that waits for packets and processes them when received.
    CORE_TASK_ID mspiMCardStatusTaskId; // A task that waits for changes in the Card status on MSPI
    UINT32 pktCount;
    BOOL writePktTaskRunning; // For the test command, to determine if a write is blocked
    BOOL readPktTaskRunning;  // For the test command, to determine if a read is blocked
    CORE_TASK_ID mcardTestTaskId; // For the test command, a test task running in background
    UINT32 testNum; // For the test command, to remember the test number being run in background
    UINT32 step;    // For the test command, to find out the last step that was executed if a test blocked while being run in background.
    UINT32 testbyte; //For the test command, to control the background test task
} CCARD_INFO;

#endif

  //Cimax_Handle    POD_CimaxHandle[HAL_POD_MAX_PODS];


/*===================================================================
   FUNCTION PROTOTYPES
===================================================================*/
//POD_STATUS POD_ResetCimax(Cimax_Handle	*hCimax);
//POD_STATUS POD_PCMCIA_Reset(Cimax_Handle	*hCimax);
BOOLEAN	Is_POD_Present();
unsigned long ByteStreamGetWord24(const unsigned char *stream);
unsigned long GetTimeSinceBootMs (unsigned char bPrintAlso); // Get time since boot in milliseconds
unsigned long ElapsedTimeMs( unsigned long baseTime );
//void reportPodError( int error );


//TSControl() // for TS bypass /through module



//MGP TODO removed call to BREG
//#define cimax_i2c_read(i2c_handle, i2c_addr, sub_addr, pBuf, n)  BREG_I2C_Read(i2c_handle, i2c_addr, sub_addr, pBuf, n)

//#define cimax_i2c_write(i2c_handle, i2c_addr, sub_addr, pBuf, n) BREG_I2C_Write(i2c_handle, i2c_addr, sub_addr, pBuf, n)



#ifdef __cplusplus
}
#endif

#endif //POD_PRIVATE_H






