// SPDX-License-Identifier: GPL-2.0
/* Copyright (c) 2019, Broadcom */
#ifndef __BCM7271_UART_H__
#define __BCM7271_UART_H__

/* Register definitions for UART DMA block. Version 1.1 or later. */
#define UDMA_ARB_RX		0x00
#define UDMA_ARB_TX		0x04
#define		UDMA_ARB_REQ				0x00000001
#define		UDMA_ARB_GRANT				0x00000002

#define UDMA_RX_REVISION	0x00
#define UDMA_RX_REVISION_REQUIRED			0x00000101
#define UDMA_RX_CTRL		0x04
#define		UDMA_RX_CTRL_BUF_CLOSE_MODE		0x00010000
#define		UDMA_RX_CTRL_MASK_WR_DONE		0x00008000
#define		UDMA_RX_CTRL_ENDIAN_OVERRIDE		0x00004000
#define		UDMA_RX_CTRL_ENDIAN			0x00002000
#define		UDMA_RX_CTRL_OE_IS_ERR			0x00001000
#define		UDMA_RX_CTRL_PE_IS_ERR			0x00000800
#define		UDMA_RX_CTRL_FE_IS_ERR			0x00000400
#define		UDMA_RX_CTRL_NUM_BUF_USED_MASK		0x000003c0
#define		UDMA_RX_CTRL_NUM_BUF_USED_SHIFT	6
#define		UDMA_RX_CTRL_BUF_CLOSE_CLK_SEL_SYS	0x00000020
#define		UDMA_RX_CTRL_BUF_CLOSE_ENA		0x00000010
#define		UDMA_RX_CTRL_TIMEOUT_CLK_SEL_SYS	0x00000008
#define		UDMA_RX_CTRL_TIMEOUT_ENA		0x00000004
#define		UDMA_RX_CTRL_ABORT			0x00000002
#define		UDMA_RX_CTRL_ENA			0x00000001
#define UDMA_RX_STATUS		0x08
#define		UDMA_RX_STATUS_ACTIVE_BUF_MASK		0x0000000f
#define UDMA_RX_TRANSFER_LEN	0x0c
#define UDMA_RX_TRANSFER_TOTAL	0x10
#define UDMA_RX_BUFFER_SIZE	0x14
#define UDMA_RX_SRC_ADDR	0x18
#define UDMA_RX_TIMEOUT		0x1c
#define UDMA_RX_BUFFER_CLOSE	0x20
#define UDMA_RX_BLOCKOUT_COUNTER 0x24
#define UDMA_RX_BUF0_PTR_LO	0x28
#define UDMA_RX_BUF0_PTR_HI	0x2c
#define UDMA_RX_BUF0_STATUS	0x30
#define		UDMA_RX_BUFX_STATUS_OVERRUN_ERR		0x00000010
#define		UDMA_RX_BUFX_STATUS_FRAME_ERR		0x00000008
#define		UDMA_RX_BUFX_STATUS_PARITY_ERR		0x00000004
#define		UDMA_RX_BUFX_STATUS_CLOSE_EXPIRED	0x00000002
#define		UDMA_RX_BUFX_STATUS_DATA_RDY		0x00000001
#define UDMA_RX_BUF0_DATA_LEN	0x34
#define UDMA_RX_BUF1_PTR_LO	0x38
#define UDMA_RX_BUF1_PTR_HI	0x3c
#define UDMA_RX_BUF1_STATUS	0x40
#define UDMA_RX_BUF1_DATA_LEN	0x44

#define UDMA_TX_REVISION	0x00
#define UDMA_TX_REVISION_REQUIRED			0x00000101
#define UDMA_TX_CTRL		0x04
#define		UDMA_TX_CTRL_ENDIAN_OVERRIDE		0x00000080
#define		UDMA_TX_CTRL_ENDIAN			0x00000040
#define		UDMA_TX_CTRL_NUM_BUF_USED_MASK		0x00000030
#define		UDMA_TX_CTRL_NUM_BUF_USED_1		0x00000010
#define		UDMA_TX_CTRL_ABORT			0x00000002
#define		UDMA_TX_CTRL_ENA			0x00000001
#define UDMA_TX_DST_ADDR	0x08
#define UDMA_TX_BLOCKOUT_COUNTER 0x10
#define UDMA_TX_TRANSFER_LEN	0x14
#define UDMA_TX_TRANSFER_TOTAL	0x18
#define UDMA_TX_STATUS		0x20
#define UDMA_TX_BUF0_PTR_LO	0x24
#define UDMA_TX_BUF0_PTR_HI	0x28
#define UDMA_TX_BUF0_STATUS	0x2c
#define		UDMA_TX_BUFX_LAST			0x00000002
#define		UDMA_TX_BUFX_EMPTY			0x00000001
#define UDMA_TX_BUF0_DATA_LEN	0x30
#define UDMA_TX_BUF0_DATA_SENT	0x34
#define UDMA_TX_BUF1_PTR_LO	0x38

#define UDMA_INTR_STATUS	0x00
#define		UDMA_INTR_ARB_TX_GRANT			0x00040000
#define		UDMA_INTR_ARB_RX_GRANT			0x00020000
#define		UDMA_INTR_TX_ALL_EMPTY			0x00010000
#define		UDMA_INTR_TX_EMPTY_BUF1			0x00008000
#define		UDMA_INTR_TX_EMPTY_BUF0			0x00004000
#define		UDMA_INTR_TX_ABORT			0x00002000
#define		UDMA_INTR_TX_DONE			0x00001000
#define		UDMA_INTR_RX_ERROR			0x00000800
#define		UDMA_INTR_RX_TIMEOUT			0x00000400
#define		UDMA_INTR_RX_READY_BUF7			0x00000200
#define		UDMA_INTR_RX_READY_BUF6			0x00000100
#define		UDMA_INTR_RX_READY_BUF5			0x00000080
#define		UDMA_INTR_RX_READY_BUF4			0x00000040
#define		UDMA_INTR_RX_READY_BUF3			0x00000020
#define		UDMA_INTR_RX_READY_BUF2			0x00000010
#define		UDMA_INTR_RX_READY_BUF1			0x00000008
#define		UDMA_INTR_RX_READY_BUF0			0x00000004
#define		UDMA_INTR_RX_READY_MASK			0x000003fc
#define		UDMA_INTR_RX_READY_SHIFT		2
#define		UDMA_INTR_RX_ABORT			0x00000002
#define		UDMA_INTR_RX_DONE			0x00000001
#define UDMA_INTR_SET		0x04
#define UDMA_INTR_CLEAR		0x08
#define UDMA_INTR_MASK_STATUS	0x0c
#define UDMA_INTR_MASK_SET	0x10
#define UDMA_INTR_MASK_CLEAR	0x14


#define UDMA_RX_INTERRUPTS ( \
	UDMA_INTR_RX_ERROR | \
	UDMA_INTR_RX_TIMEOUT | \
	UDMA_INTR_RX_READY_BUF0 | \
	UDMA_INTR_RX_READY_BUF1 | \
	UDMA_INTR_RX_READY_BUF2 | \
	UDMA_INTR_RX_READY_BUF3 | \
	UDMA_INTR_RX_READY_BUF4 | \
	UDMA_INTR_RX_READY_BUF5 | \
	UDMA_INTR_RX_READY_BUF6 | \
	UDMA_INTR_RX_READY_BUF7 | \
	UDMA_INTR_RX_ABORT | \
	UDMA_INTR_RX_DONE)

#define UDMA_RX_ERR_INTERRUPTS ( \
	UDMA_INTR_RX_ERROR | \
	UDMA_INTR_RX_TIMEOUT | \
	UDMA_INTR_RX_ABORT | \
	UDMA_INTR_RX_DONE)

#define UDMA_TX_INTERRUPTS ( \
	UDMA_INTR_TX_ABORT | \
	UDMA_INTR_TX_DONE)

#define UDMA_IS_RX_INTERRUPT(status) ((status) & UDMA_RX_INTERRUPTS)
#define UDMA_IS_TX_INTERRUPT(status) ((status) & UDMA_TX_INTERRUPTS)


/* Current devices have 8 sets of RX buffer registers */
#define UDMA_RX_BUFS_COUNT	8
#define UDMA_RX_BUFS_REG_OFFSET (UDMA_RX_BUF1_PTR_LO - UDMA_RX_BUF0_PTR_LO)
#define UDMA_RX_BUFx_PTR_LO(x)	(UDMA_RX_BUF0_PTR_LO + \
				 ((x) * UDMA_RX_BUFS_REG_OFFSET))
#define UDMA_RX_BUFx_PTR_HI(x)	(UDMA_RX_BUF0_PTR_HI + \
				 ((x) * UDMA_RX_BUFS_REG_OFFSET))
#define UDMA_RX_BUFx_STATUS(x)	(UDMA_RX_BUF0_STATUS + \
				 ((x) * UDMA_RX_BUFS_REG_OFFSET))
#define UDMA_RX_BUFx_DATA_LEN(x) (UDMA_RX_BUF0_DATA_LEN + \
				  ((x) * UDMA_RX_BUFS_REG_OFFSET))

/* Current devices have 2 sets of TX buffer registers */
#define UDMA_TX_BUFS_COUNT	2
#define UDMA_TX_BUFS_REG_OFFSET (UDMA_TX_BUF1_PTR_LO - UDMA_TX_BUF0_PTR_LO)
#define UDMA_TX_BUFx_PTR_LO(x)	(UDMA_TX_BUF0_PTR_LO + \
				 ((x) * UDMA_TX_BUFS_REG_OFFSET))
#define UDMA_TX_BUFx_PTR_HI(x)	(UDMA_TX_BUF0_PTR_HI + \
				 ((x) * UDMA_TX_BUFS_REG_OFFSET))
#define UDMA_TX_BUFx_STATUS(x)	(UDMA_TX_BUF0_STATUS + \
				 ((x) * UDMA_TX_BUFS_REG_OFFSET))
#define UDMA_TX_BUFx_DATA_LEN(x) (UDMA_TX_BUF0_DATA_LEN + \
				  ((x) * UDMA_TX_BUFS_REG_OFFSET))
#define UDMA_TX_BUFx_DATA_SENT(x) (UDMA_TX_BUF0_DATA_SENT + \
				   ((x) * UDMA_TX_BUFS_REG_OFFSET))
#endif /* __BCM7271_UART_H__ */
