DESCRIPTION = "Broadcom Linux Kernel"
SECTION = "kernel"
LICENSE = "GPLv2"

DEFAULT_PREFERENCE = "-1"

FILESEXTRAPATHS_prepend := "${THISDIR}/stblinux-5.4-1.1:"

LIC_FILES_CHKSUM = "file://COPYING;md5=bbea815ee2795b2f4230826c0c6b8814" 
SRC_URI += "${@bb.utils.contains('PREFERRED_VERSION_stblinux', 'android-5.4-r-ab1', 'https://partners.artifactory.comcast.com/artifactory/broadcom_sdk_shared/linux/5/4-r-ab1/stblinux-android-5.4-r-ab1/2.1/stblinux-android-5.4-r-ab1-2.1.tar.bz2', 'https://partners.artifactory.comcast.com/artifactory/broadcom_sdk_shared/linux/5_4-1_1/stblinux-5.4-1.1/2.1/stblinux-5.4-1.1-2.1.tar.bz2',d)}"

SRC_URI[md5sum] = "${@bb.utils.contains('PREFERRED_VERSION_stblinux', 'android-5.4-r-ab1', '19ac53cb126af04594c6d4aa49076734', '53971114ea013a2d78e3f8ddc3ffe559', d)}"

SRC_URI += " file://cgroups.cfg \
            file://9996-fs_squashfs_improve_squashfs_error_resistance.patch;striplevel=1 \
            file://stblinux_watchdog_nmi.patch;striplevel=1 \
            file://reboot_info.patch;striplevel=1 \
            file://boops.patch;striplevel=1 \
            file://inet.cfg \
            file://ipsec.cfg \
            file://netfilter.cfg \
            file://overlay.cfg \
            file://stblinux-5.4.cfg \
            file://nfsdisable.cfg \
            file://disable_cdrom_fs.cfg \
            file://ecryptfs.cfg \
            file://dm_crypt.cfg \
            file://stblinux_disable_pcie_powersave.cfg \
            file://dvfs_null_check.patch \
            file://SWLINUX-6279.patch \
	    file://SWLINUX-6721.patch \
	    file://perf_hw_events.patch \
            file://cma_debugfs.cfg \
            file://eth_crash_after_s2.patch \
	    file://SWLINUX-6655_eee.patch \
	    file://BT_hci0_resume_after_s3.patch \
"

SRC_URI += "file://0010-RDK-37394-workaround-for-DS4-dongle-hotplug-kernel-crash.patch "
SRC_URI += "file://0011-RDK-37394-don-t-use-fw_version-hw_version-for-sysfs-cleanup.patch "
SRC_URI += "${@bb.utils.contains('PREFERRED_VERSION_stblinux','android-5.4-r-ab1','','file://0012-RDK-37394-adding-sony-dualsense-PS5-support.patch',d)}"
SRC_URI += "file://0013-RDK-37394-exclude-PS5-controller-from-hid-generic.patch "
SRC_URI += "file://0014-RDK-37392-fix-for-xbox-pairing-issue.patch "
SRC_URI += "${@bb.utils.contains('PREFERRED_VERSION_stblinux','android-5.4-r-ab1','','file://0019-RDK-37392-linux-stability-changes-5-4-217.patch',d)}"
SRC_URI += "${@bb.utils.contains('PREFERRED_VERSION_stblinux','android-5.4-r-ab1','file://0020-RDK-37392-android-fix-for-xbox-mapping.patch','file://0020-RDK-37392-fix-for-xbox-mapping.patch',d)}"
SRC_URI += "file://0022-RDK-37394-fix-to-remove-noise-events-playstation.patch "
SRC_URI += "${@bb.utils.contains('PREFERRED_VERSION_stblinux','android-5.4-r-ab1','file://0024-RDK-39137-android-xbox-mapping.patch','file://0024-RDK-39137-nonandroid-xbox-mapping.patch',d)}"
SRC_URI += "file://0025-DELIA-62832-fix-for-delay-on-node-creation-issue.patch "
SRC_URI += "file://0001-CPESP-3698-Nintendo-Switch-ProController_Support.patch "
SRC_URI += "file://stblinux_adaptive_controller_support.patch "
SRC_URI += "file://Google_Stadia_Controller_Support.patch "
SRC_URI += "${@bb.utils.contains('PREFERRED_VERSION_stblinux','android-5.4-r-ab1','file://Revert-eCryptfs-don-t-pass-up-plaintext-names-when-u.patch','',d)}"

# enable zram module
SRC_URI_append_rdkzram += "\
    file://zram.cfg \
"

SRC_URI_append = " \
    file://bluetooth.cfg \
"
#Enable CMA_DEBUGFS for Memcapture
SRC_URI += "${@bb.utils.contains('DISTRO_FEATURES', 'memcapture', 'file://cma_debugfs.cfg', '', d)}"

COMPATIBLE_HOST = "arm.*|aarch64.*"

KERNEL_VERSION = "5.4-1.1"
KERNEL_MAJOR_VERSION = "5.4"

LINUX_VERSION ?= "5.4"
LINUX_VERSION_EXTENSION ?= "-brcm"

DEPENDS += "xz-native bc-native lzop-native"

inherit kernel

S = "${WORKDIR}/linux"

do_configure_prepend () {
	# copy desired defconfig so we pick it up for the real kernel_do_configure
	sh ${S}/scripts/kconfig/merge_config.sh -m ${KERNEL_DEFCONFIG} `ls ${WORKDIR}/*.cfg 2>/dev/null`
	mv .config ${WORKDIR}/defconfig
}

KERNEL_CONFIG_COMMAND ?= "oe_runmake oldnoconfig || yes '' | oe_runmake oldconfig"

kernel_do_configure() {
	touch ${B}/.scmversion ${S}/.scmversion
	# Copy defconfig to .config if .config does not exist. This allows
	# recipes to manage the .config themselves in do_configure_prepend().
	if [ -f "${WORKDIR}/defconfig" ] && [ ! -f "${B}/.config" ]; then
		cp "${WORKDIR}/defconfig" "${B}/.config"
	fi
	${KERNEL_CONFIG_COMMAND}
}
# Many scripts want to look in arch/$arch/boot for the bootable
# image. This poses a problem for vmlinux based booting. This
# task arranges to have vmlinux appear in the normalized directory
# location.

do_kernel_link_vmlinux() {
	if [ ! -d "${B}/arch/${ARCH}/boot" ]; then
		mkdir ${B}/arch/${ARCH}/boot
	fi
	cd ${B}/arch/${ARCH}/boot
	ln -sf ../../../vmlinux
}

addtask kernel_link_vmlinux after do_compile before do_install
RDEPENDS_kernel-base = ""
INHIBIT_PACKAGE_STRIP = "1"
