// Copyright 2017, the V8 project authors. All rights reserved.
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above
//       copyright notice, this list of conditions and the following
//       disclaimer in the documentation and/or other materials provided
//       with the distribution.
//     * Neither the name of Google Inc. nor the names of its
//       contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

// Generated by tools/bigint-tester.py.

var data = [{
  a: 0x505cc3cc1f7d5df94e5542ea84db824117280f12bn,
  b: -0xe51d5b25e49be04a94c8138d2793615073f1914462285f2abca69e2be4d89a62ab8377n,
  r: -0xe51d5b25e49be04a94c8138d27935c4aa7b4cf4c8c48ca456877f5de2cb488f02a924cn
}, {
  a: 0x19fd6b3d3366825677b171341b9da0dcba3d236d4ee3305760639an,
  b: 0x610n,
  r: 0x19fd6b3d3366825677b171341b9da0dcba3d236d4ee330576069aan
}, {
  a: -0xfce38fb1d951cc328584825a9769256e8e5d51fe2c9b8220e242d0c0da78fe37a058e2n,
  b: -0xc3779160fde58dff420d32248eecb654c2f358a2d26d26n,
  r: -0xfce38fb1d951cc328584825b5ae0b6cf8c42dffd6ea8b445712f87159d6c56da72c608n
}, {
  a: -0xb628b93c7a481cn,
  b: 0xf3ec36b3n,
  r: -0xb628b8488e1169n
}, {
  a: -0xdbd854980794095346077c00327a50e414a3cf10786n,
  b: -0xc87e5ce98686ed13257a0f2en,
  r: -0xdbd8549807940953461403e60112b952e5d626b16b4n
}, {
  a: 0xc9314162af170d0n,
  b: -0xc2c8303b70dn,
  r: 0xc9307e9a7edb9c3n
}, {
  a: 0x1355bad325a7dfce51e69n,
  b: 0x748518a40c57b022038a9c2639d5a631n,
  r: 0x748518a40c58e57db0bcf6a436bac49an
}, {
  a: 0xef1dc9397c87f97n,
  b: -0xb1faf2b1e2daecded5f2bc5267d87e3988b9395d5410500538n,
  r: -0xb1faf2b1e2daecded5f2bc5267d87e3988aa4780c0788785a1n
}, {
  a: -0x16acbe39d9cc736471df9c038n,
  b: -0xfe1b0d78447bb4475ebn,
  r: -0x16acbf37f4d9eba8ed93e3623n
}, {
  a: 0x89968ffbd8429064bc0f2455f9e140560be414186f7627deabb4e76ae7n,
  b: -0x996da1b6615c4b5213e07b9257a01d0c1190877n,
  r: 0x89968ffbd8429064bc058d7bde7b2a9156c2d610b650addcdaf3ce6270n
}, {
  a: -0x4cba543ab96ac2ad5n,
  b: 0x72de026c4234d118n,
  r: -0x458c7413f547759bdn
}, {
  a: 0x96cc7af79148d1c6df3b31b1fe49ea3d49a52229a4ecbf4f12c5c87b4fdfdfn,
  b: 0x91ac3b91a61b4628e965210c7fee861n,
  r: 0x96cc7af79148d1c6df3b31b1fe49ea466468db4406a121dda917d9434ec840n
}, {
  a: 0xb345ca56fb05c1e1a6904e5c644d8f1300cf3e5847582f4n,
  b: 0x41411cb4c60659d43477b7db62c91010d91cfc5c764997e4ed9ecn,
  r: 0x41411d680bd0b0cf3a399981f3176c7526ac0f5d4587f02c45ce0n
}, {
  a: 0x4f917c2fd5fb0ae1cf91b11e96d7b946461603b298b71a4e178dc26bec0ebn,
  b: 0x9b16cedcdb7a71764e606n,
  r: 0x4f917c2fd5fb0ae1cf91b11e96d7b946461603b333cde92af30833e23a6f1n
}, {
  a: 0x8n,
  b: 0x3c0490a254a100b71aab86f27151fce6d294b763d2n,
  r: 0x3c0490a254a100b71aab86f27151fce6d294b763dan
}, {
  a: 0x248f6023990e02c10b5d4ae92e4n,
  b: -0x918e7a483044fdc19e8n,
  r: 0x248f6023077f8878db184d278fcn
}, {
  a: -0x80803cfd9b1153ce3ea4fcn,
  b: -0xd01c69bf88667688185489a0a9d8068cd05520a0a1f3c9fcdfbb7b0a85e1c4fd49bn,
  r: -0xd01c69bf88667688185489a0a9d8068cd05520a0a1f3d204e38b54bb9b1ea8e7997n
}, {
  a: -0xd3baf3b13e5e6e60a645c692en,
  b: 0x76ef85bba9e841d5608c15d9dabdf21e7eb7218n,
  r: 0x76ef85bba9e84101a598649b7c4f917838f08ean
}, {
  a: 0x35bc46ccee6a1e11dfc648cb4f5cb955399044f9fbbbc98be014d8be25b75an,
  b: 0xb9aee7f215948132bcc1f4a3789320a2293n,
  r: 0x35bc46ccee6a1e11dfc648cb4f685443b8b19e420ee795ab2a4c61f02fd9edn
}, {
  a: 0x2f4e6b9700b70599n,
  b: -0x7b25ff1eb25ca92082df200e00ad676bn,
  r: -0x7b25ff1eb25ca9205390b476fff661d2n
}, {
  a: -0x74802f8da8ca5ce421d90eef4091c0063b2366020528d19f5f507n,
  b: -0xeada024302729922c629a3b29079cc2dccf1d6004c7e152n,
  r: -0x7480307882cc9fe6947231b56a357296b4ef93cef6fed1ebdd659n
}, {
  a: -0x55364e3ab4efb8fc4cn,
  b: -0xfccf94601dcb3f405143c48cd7cf884b95d530ae19ad4bb2629f107474en,
  r: -0xfccf94601dcb3f405143c48cd7cf884b95d530ae1f00b0960dee0c0439an
}, {
  a: -0x85216f28c02eb81456c0d4d5c6d60c43e4a47227572470e544302ed7n,
  b: 0x1n,
  r: -0x85216f28c02eb81456c0d4d5c6d60c43e4a47227572470e544302ed6n
}, {
  a: -0xc2d497dcb27d110319a8c074862962dbf51c4b99f88de88d5b1639f54883bbca691749n,
  b: -0x2410604ba6fe8b78ca64e7615a032254e11e0f26544b7f6b8631e546ad3fn,
  r: -0xc2d497dcb2a12163654fbefffef3c7c356764ebc4d6f069c816a8574b409edafafc488n
}, {
  a: -0x969cec3c08d88cf9d0c91ab79fce388n,
  b: -0x225fb6ec99c8ba46f497cf988580735a3f060df9e75e70a5c20d73fb1d7n,
  r: -0x225fb6ec99c8ba46f497cf98858109f72b4216d27458416edcc513c955fn
}, {
  a: 0xe7d59e7eaa12cd38e0f2f04f830cf0b272n,
  b: 0xe8c22d51a8bcdb0255565f5dn,
  r: 0xe7d59e7eaafb8f66329bad2a85624711cfn
}, {
  a: -0xb2260a8a165b3cfc2f5fb5ac6f004b8e755bd2296b45e6f8n,
  b: 0x556abe19d178a776fe45b204775dn,
  r: -0xb2260a8a165b3cfc2f5f6041b0e67a15cde4d3e3b9416f9bn
}, {
  a: 0xec0c672fdn,
  b: -0x9a25a976c187e491003726954f20985a2618cc6n,
  r: -0x9a25a976c187e491003726954f20976e19b19c9n
}, {
  a: -0xb1758bde9623dd6b1b4c55f640fa122de07a3cf71e3f5cf1en,
  b: 0x399d02380cabd6d5a652426764f59be89d14123e53ad28d04n,
  r: -0x77d889a68978069574fa138edc04764543662ab8ca923421an
}, {
  a: -0xfd72082298a2d4b4d01b8543c9c05b991594n,
  b: -0x40c195f303ea4663efa66fd940eb305e770948a96ef13fe192a6fa769fd68577a5fcn,
  r: -0x40c195f303ea4663efa66fd940eb305f747b50cc0794149662c27fba6996e110bb90n
}, {
  a: 0x1e3e00517170a9ec3b22b350c7dc40296af664028c299c0b66fn,
  b: 0xf8483931204382an,
  r: 0x1e3e00517170a9ec3b22b350c7dc40296af75c4ac55abc4ee99n
}, {
  a: -0xba3179418a90c5733659756eac7e633b95n,
  b: 0xf1a0c547e3763fe190859a5dfc77c183a0e99711dd993f1138eab9ad1be444773e3en,
  r: 0xf1a0c547e3763fe190859a5dfc77c183a02f65989c0eae4bc5b46037ad37c61402a9n
}, {
  a: 0x38a7c292ae365ac65c03d8b0de5ed5757befen,
  b: -0xa689f55053n,
  r: 0x38a7c292ae365ac65c03d8b0de546cd626eabn
}, {
  a: -0x3c366f3n,
  b: -0xd961566d2a5cda5b4ebb997feb957eb51927fn,
  r: -0xd961566d2a5cda5b4ebb997feb957ef14f972n
}, {
  a: 0xc59f60en,
  b: -0x170cc9b87395dbe219790b1f80c1337f0n,
  r: -0x170cc9b87395dbe219790b1f7ffb941e2n
}, {
  a: 0x215a4ae5c883af31b1f1a7eeebdd712ec1fca3dd00a8497cdd0ec56bf8a8n,
  b: 0xf962af2fd9a3b9546dbec9084aa21c66193322b112251cf719147e2dcn,
  r: 0x2169e110bb81496d473883db7c621b50885e370f2bb96bceac8056b3db84n
}, {
  a: -0x6f0f51729eb9fe8c5b74e4a028df5ec6552146f4ca3ef0cn,
  b: 0xa68996eee7e1987d286f693e061927dca5d61dc0bf1565cc0n,
  r: 0xa61a879d7542de7e9c13f45965f0487ddf80fc79ca4b26db4n
}, {
  a: -0xen,
  b: -0xc8ed0aa0a322cfee61884n,
  r: -0xc8ed0aa0a322cfee61892n
}, {
  a: 0x6b79f238ca22b6882374132418f2f1c68abd8cfec894b8ce0bb81146n,
  b: 0xba59dbca9f5db48n,
  r: 0x6b79f238ca22b6882374132418f2f1c68abd8cfed43a568ab5adec8en
}, {
  a: -0x48n,
  b: -0x615fa4ae7428c6966daa51731719302e4n,
  r: -0x615fa4ae7428c6966daa517317193032cn
}, {
  a: -0xc63fbaf4ce8e2bb30381314d4b219cc7810b0513180638n,
  b: 0x1e54c6cf1c3n,
  r: -0xc63fbaf4ce8e2bb30381314d4b219cc781091fc6ab1475n
}, {
  a: -0xc1d664c5803c711324cf795a9412361529b64dd22ac394f95970e367884675e4n,
  b: 0x18c158c8e9d724956ded757b3a66ec3a4ccbfba3a4e0092c06n,
  r: -0xc1d664c5803c70fa6376b070bceda0a73c40d297c3d75aac8d753fc2a83d49den
}, {
  a: 0xc4ab2ab4f86b24bb813e689640b91f8aea7ff4ff5311b5991cn,
  b: 0x15d7ec9ad7dca1cf487d4047ecc6efd83ef62e3ee61fa7b6917406b28f59103f5an,
  r: 0x15d7ec9ad7dca1d00d286afce5321493c03496d526d8c7417bf3fbb1e26ac5d876n
}, {
  a: -0x3287c9aa77aa6ac274an,
  b: 0x54bec674fc01614bddba543f147d97c760dbe8c4b5d6e6f0e1b7cn,
  r: 0x54bec674fc01614bddba543f147d97c760a960fb0b5f3c861f432n
}, {
  a: 0n,
  b: 0x8cff6567d7e27n,
  r: 0x8cff6567d7e27n
}, {
  a: -0x720b92113b4n,
  b: -0x56b379df8e05a26472d433214c1d3b74aa3508239bfb17ee002an,
  r: -0x56b379df8e05a26472d433214c1d3b74aa350823a31bd10f13den
}, {
  a: -0xb027a758735721dcd4a8578fe14163a3cc09eef7cdf19d9e04118e47a763adc3b674n,
  b: 0x6374392n,
  r: -0xb027a758735721dcd4a8578fe14163a3cc09eef7cdf19d9e04118e47a763a78c72e2n
}, {
  a: 0x23ecfea773fa46e2bfbn,
  b: 0xf928e9ba6dd7edaeee529f41a10n,
  r: 0xf928e9ba91c4ec56624ce62460bn
}, {
  a: -0xadd22490b2a04fd48b71bf146n,
  b: -0xeecee21bc97ff3d68f77eeabb0e6f026b3d9af86329aaaeedb18e254fbn,
  r: -0xeecee21bc97ff3d68f77eeabb0e6f026beb6d1cf3dc4afec23cffe4641n
}, {
  a: -0xbdf0438d8c0f098bcbae4n,
  b: 0xcd6b7338a7a90b9d0c22a12e9cc0cb7d37ceabcc71221e8e5475cd25n,
  r: 0xcd6b7338a7a90b9d0c22a12e9cc0cb7d37c2ccc838495d9dbbb91241n
}, {
  a: -0x1f41ddad4dbb7ec71c5086a25e89cf51b9e4b04451cn,
  b: -0x95e1cf325bn,
  r: -0x1f41ddad4dbb7ec71c5086a25e89cf51c342cd37777n
}, {
  a: 0x4499061c6b37bb9a36ad3157e44939fff9n,
  b: 0x8383708ef04fb29da2cf5db551c5066ea0b0050c7eb85n,
  r: 0x8383708ef053fc2e049611310b687141b62e49a01eb7en
}, {
  a: 0x197de9ad31179f4038169fbb7f55956a09c3f6n,
  b: 0x474c1b28b5678ff9679c7c020e6an,
  r: 0x197de9ad315eeb5b60cc074b78bd31e60bd260n
}, {
  a: -0xddfb1ae0d3575fef2n,
  b: 0x715d19f3bd50a3c842a158598f776c79a86519b1an,
  r: 0x715d19f3bd50a3c842a15858b17c5198d50db9c28n
}, {
  a: 0x8e1b861c796e415718b0302efc73447cb1dn,
  b: 0x82af15cc12aa7046b2a8defd90ed925eae5a11e06fn,
  r: 0x82af15d4f462d20e498cf46f1bf0954e758e59ab8cn
}, {
  a: 0xf3168208928aca3c61aea67db4463dab090e326fdef286d15cf6e0n,
  b: -0xc9dc889a140a2a558f622f8f5cn,
  r: 0xf3168208928aca3c61aea67db44573ce80741e65b49cf76f2d6784n
}, {
  a: -0xc0ade64bdfb6f7a41c1be0155383n,
  b: 0x5a4b036a4b8ce4c7025274n,
  r: -0xc0ade5f194b38d588f371913010fn
}, {
  a: -0xb979da7eca08e21e5008b886864en,
  b: 0x6dde0d9521b9aea97628a74a05f56887bda7cn,
  r: 0x6dde0d95162211018988192820f4dcff5542en
}, {
  a: -0x5877e3bf9b2881e7b8b95ee6ba575f7e08b7b090d476ff0d05c5386405ef8061a3n,
  b: -0x7258235ea0133a1c2e4e5a4d89a59e662c6b32fe228c726b7300n,
  r: -0x5877e3bf9b28825a10dcbd86cd917bac5711fe1a7a15653970f836869261ebd4a3n
}, {
  a: -0x3fd85ec8f83e3e2855a5b50d00ed4c277322e799fc149fb95n,
  b: 0xb1e7120761b30656d81385cn,
  r: -0x3fd85ec8f83e3e2855a5b50d003b65156bc13493a53c8c339n
}, {
  a: -0x29e1d8950a0b61f899c1cfe682a30c443n,
  b: 0x91531dfaf67dn,
  r: -0x29e1d8950a0b61f899c1c6d150c35cdc6n
}, {
  a: -0x545ec6595791a15dbedfn,
  b: -0x1c9f8a3f759dac4n,
  r: -0x545ec823503598b799a3n
}, {
  a: -0x9867e24264a118ced9n,
  b: -0xcn,
  r: -0x9867e24264a118cee5n
}, {
  a: 0x11a2d5cn,
  b: 0xb38c5d64n,
  r: 0xb4a68ac0n
}, {
  a: -0x2960030f81d90ec507eab93c99c0764c89759b104b534e0627dcb13750cdn,
  b: 0xce6e979db16a7a175b3d4f7768af3dabbf96244667c72c65477720649f88n,
  r: 0xa50e948e2f916b525352963aceeec75f362089361c73de5f1f9a6f2d4ebbn
}, {
  a: 0x39a280de8c559feb690a7n,
  b: -0x5bd07n,
  r: 0x39a280de8c559feb0d3a0n
}, {
  a: 0x2837c4b7f6f71bb1abcb4f09a3a5ffc92ad89ee67c03f48e5d57n,
  b: -0xff939af61cd46b46c8498ffa0ab52a20b3n,
  r: 0x2837c4b7f6f71bb1aacbbb6ead892b5de410555681f93f643ca4n
}, {
  a: 0x4f7ff122dec35296225de7f21b0e87641eec65n,
  b: 0x92a8467an,
  r: 0x4f7ff122dec35296225de7f21b0e87f6c732dfn
}, {
  a: 0x47bbccf561adacf87b1ca85248b8edac69ac585n,
  b: 0x26b8b3n,
  r: 0x47bbccf561adacf87b1ca85248b8edac6c17e38n
}, {
  a: 0xca80ba999f6af8b1818ea553a9e634b7042e6n,
  b: -0x3fda4n,
  r: 0xca80ba999f6af8b1818ea553a9e634b6c4542n
}, {
  a: 0x278d199f5a377a8beeb71ff67f3fb315b8034386e50n,
  b: 0x3274e0d979344526115c748f6f36f6086c60n,
  r: 0x278d19a28185882381fb72579506fc0cab72a40dab0n
}, {
  a: -0xb146097cc8d36ad39445b22550a8ea5744435d8b166b8588c0n,
  b: -0x456b364a0bb8deb3n,
  r: -0xb146097cc8d36ad39445b22550a8ea574488c8c160773e6773n
}, {
  a: 0x18f57f1n,
  b: 0xeab79f25e30966551a894f672aa3d4d4b2b54a96f342868c3fe7n,
  r: 0xeab79f25e30966551a894f672aa3d4d4b2b54a96f342881b97d8n
}, {
  a: 0xcd44180da640566d4d387944599e06626dd6452c91a37ec501fn,
  b: -0x497e80a4e7ef0544f9a420n,
  r: 0xcd44180da640566d4d387944599e01ca85cbf6ada14f2f2abffn
}, {
  a: -0x906e181ea5de4c05610f657d0782246299d6e5848449960f63b092n,
  b: 0x8699dca208d162n,
  r: -0x906e181ea5de4c05610f657d0782246299d6e583fdafb96d5adf30n
}, {
  a: 0xae821162e9f334205a7b4cdcec4658f09f6905bb4058b3d946182f8c800c0f59696n,
  b: -0x77582585be6f39558ee1e6be2e048f20n,
  r: 0xae821162e9f334205a7b4cdcec4658f09f619038e7fccce5b0bf416e14292f10776n
}, {
  a: 0x4bcbc7191bca53cc50f07f6d489209e66205e40a12f71d9d7247eed32d0921438n,
  b: -0xf120a74c5a99a157d818n,
  r: 0x4bcbc7191bca53cc50f07f6d489209e66205e40a12f70e8b67d3292992f3a3c20n
}, {
  a: 0x2c05efc2c50en,
  b: -0x59576c6ec132e949d2bn,
  r: -0x59576c6c00d3ed1d81dn
}, {
  a: -0x28b67b837a91cb2e5c5ff8876b9n,
  b: 0x992a8a1fb6745cbaba27dfcc2450e8f3081203e1aab9fa7n,
  r: 0x992a8a1fb6745cbaba27b715a8cd6e613ce3a781b2328een
}, {
  a: -0x93adecc405ac7550383n,
  b: -0x4fb0bb1f2424efe38d521de02ed5d2c0de9aa1925a574611cfb817edba07d139be3dcn,
  r: -0x4fb0bb1f2424efe38d521de02ed5d2c0de9aa1925a574611d04bc5da7e0d7daf0e75fn
}, {
  a: -0x10d4d77f2482d2faf9744f4af058ff3c45563e58dcbn,
  b: 0x287015c500412395822ec2n,
  r: -0x10d4d77f2482d2faf9744cc3eefcaf38331ce635f09n
}, {
  a: 0n,
  b: -0x7n,
  r: -0x7n
}, {
  a: -0xbe636b04fe14fe99423953667938791c79afb45451d63f39e4e8e6bn,
  b: 0xf9e7c59f8e012e21d8a71103d3c325df984fd2303b8778c0bn,
  r: -0xbe636a0b164f5f0b410b318dd2277548b689d4bc02040efe5d70260n
}, {
  a: 0x18d2890ea98571a5f7dan,
  b: -0xd7ed07165aa4068943563n,
  r: -0xd65fde85700baf6ee3d89n
}, {
  a: 0x93n,
  b: -0x4d3b3319dbbe30daaa5d3e7648b776n,
  r: -0x4d3b3319dbbe30daaa5d3e7648b6e3n
}, {
  a: 0x5a9bcce2d96016a45864fc06e048179c5fn,
  b: -0x34222c4a64600b9n,
  r: 0x5a9bcce2d96016a45861b9e41ba1d19ba6n
}, {
  a: 0xdd5c2e61fc1d7d57ca18a94ca2ff40cf5b0ccfc3fb1ae55c5c88990c23aec7fecan,
  b: -0x1085cb66924bc8d704132223e6e3333bae4842d7c942b16233d7ecn,
  r: 0xdd5c2e61fc1d6cd1feb21700da283cbc38e8e8e0c7df371419b0cfc9724c9426den
}, {
  a: 0x5134fc19c4296946e5cf9f1372dfbe5fdf724653c8e3cc99aee6ee15an,
  b: -0x70ea9378n,
  r: 0x5134fc19c4296946e5cf9f1372dfbe5fdf724653c8e3cc99a7d844de2n
}, {
  a: 0x77cc18610d482b62055f2cc991378ea3766ebb0b5769587bd99dd0f8dn,
  b: 0n,
  r: 0x77cc18610d482b62055f2cc991378ea3766ebb0b5769587bd99dd0f8dn
}, {
  a: -0xc669babfdbn,
  b: -0x6f9c820e1c682dbcn,
  r: -0x6f9c82d48622ed97n
}, {
  a: -0xb40c67f9cea83a07e1393c79028729e7d223dc00bb859a0n,
  b: -0xd98f2d00130n,
  r: -0xb40c67f9cea83a07e1393c79028729e7d224b58fe885ad0n
}, {
  a: 0xa59772069771f08cdbcb7n,
  b: 0xb5570b61aebafc64cbabc36ea51299c372bc905b8327d875579n,
  r: 0xb5570b61aebafc64cbabc36ea5129a690a2e96f2f5186551230n
}, {
  a: 0xb7141b3445a17a6fe4758bf70c2c9c530cb3n,
  b: 0xb4bfefae1f2438aa8dfn,
  r: 0xb7141b3445a17a6fefc18af1ee1edfddb592n
}, {
  a: -0x9267aaabb867fce73ba3263fbf252a5143b0b3710a37e6e06ee642n,
  b: -0xa4d95560f9ea375af1b0570d8b2a792b7034bf8e7fa5de2656537n,
  r: -0x9cb54001c806a05ceabe2bb097d7d1e3fab3ff69f23244c2d44b79n
}, {
  a: -0x4daf8a51867db5ea3b68e454af085b1a4e94e0b82f1f23fn,
  b: -0xf19df9b20cfebb1fafc07211c40c9837acc6254c65bab6n,
  r: -0x5cc969eca74da19c3664eb75cb49249dc961430cf57acf5n
}, {
  a: -0x71c34a586625fn,
  b: -0x1992d65b58a17935bn,
  r: -0x1993481ea2f9df5ban
}, {
  a: 0xb2f17c518dcc3dd191cfbd3da9cef442ac4ce540110105191925436b043484a8704d6n,
  b: -0x2c4c3e514e85a5n,
  r: 0xb2f17c518dcc3dd191cfbd3da9cef442ac4ce54011010519192543683f709f9387f31n
}, {
  a: 0xb3ebe4259d96a22bac5bc1d747ffc3n,
  b: -0xbed84c53a7b2c8506d3561530dc3b20bf5ab87d003a7b487457b5cdcn,
  r: -0xbed84c53a7b2c8506d3561530d0fc627d00df12dd7fb58c56e335d19n
}, {
  a: -0x7d9e3b323a25299c99f39e1d8e2abab0273e9d45ecf4d30c39a281dfec1an,
  b: 0x70708a6e532b58251e57077en,
  r: -0x7d9e3b323a25299c99f39e1d8e2abab0273e2cd562867fe0e17d6388e49cn
}, {
  a: -0xc990e30e5d1e2acd90beff68e82148b40f8e75efe468aef5fe576a7cdce51fe63d8cc9n,
  b: -0xaff5470d00491b937f2baf94255087277f0f32516b1f72998eea6n,
  r: -0xc990e30e5d1e2acd9bbe53d9b825da6d478130e926bdb76876485da1f397170fd67b6fn
}, {
  a: -0x99db72013954ed07569b3f7168c0bc05bb6f8e5ae7431c8f07d77ec6c592n,
  b: 0xadc98a5e23en,
  r: -0x99db72013954ed07569b3f7168c0bc05bb6f8e5ae7431c8efcfae620e354n
}, {
  a: -0xee3dea97316d120f6a35cddn,
  b: -0x93dac6e238065c613ab6a19e72960acn,
  r: -0x93dac6e3264446f86c23b3addccbd89n
}, {
  a: 0xc7f052c7c2fc219bf8150e7n,
  b: 0xf366181058fn,
  r: 0xc7f052c7c2fd15021025676n
}, {
  a: -0x2c851731b21b13f6997bc768e9ffa53793c0bf5daf6393ac2baeeeb56en,
  b: 0xcc2f72b7430bfb4ba91088872636a0ea5202fe23bcc6ab3072dfa3e8bf339cfn,
  r: 0xcc2f6feef198e029f7d11eef69c0124a57af84e7b0d0d03a39a4e12dd048461n
}, {
  a: 0x918604bdcc3e785f04cefe92738efab76cfb6babd0513e6n,
  b: 0xdd34e98f6d01407cdd75ace248557becn,
  r: 0x918604bdcc3e786cd81d978943a30285445639d055a8fd2n
}, {
  a: -0xe2bcc7cb067044832b25442f47577b7cac45203f7dbfc6b464b1en,
  b: -0x51454474a1f5dea5b8a54d8951af3416b22ac8635feafc1n,
  r: -0xe2bcc81c4bb4b9252103e9e7eca504ce5b7936f1a8882a144fadfn
}, {
  a: 0x92e07fe6eaf1264c51ef108c8e6ae367ac05b277b085a48d0a68ff91587dcd8n,
  b: -0x27e40781c7ef2bd650fe1431d17e780f3f7b4a48b9n,
  r: 0x92e07fe6eaf1264c51ef0e0e4df2c6e8b9484d67cf42877522e80b99a3d941fn
}, {
  a: -0x72d47ad5c958bc3c864a95023cf2fe962n,
  b: 0x118d6757194a02841acafa8a510e7n,
  r: -0x72d469486201a2f283c67a374268ad87bn
}, {
  a: -0x4ee5e0fec747834a1c50a5a167399926121549633f74b125da672cae9ean,
  b: -0xd3dba941e1ed252c579568ed10b317477589af01276d72c7b069cddn,
  r: -0x4ee6b4da70896537417cfd36d026a9d9295cbeecee75d8934d2edd186c7n
}, {
  a: -0xe21n,
  b: 0xb0323f13cffcbe493d3f5919f52928120c3n,
  r: 0xb0323f13cffcbe493d3f5919f52928112a2n
}, {
  a: -0xb2913ean,
  b: 0x900855964ee53b9dc37790325cde06163c629c06b09699f5d680b06n,
  r: 0x900855964ee53b9dc37790325cde06163c629c06b09699f523ef71cn
}, {
  a: -0xc76fdccn,
  b: 0x94cc4de98f3e4ec126f59b9a0266f0731bbde807f2d38dn,
  r: 0x94cc4de98f3e4ec126f59b9a0266f0731bbde7fb7bd5c1n
}, {
  a: 0xd5c962bef13f190d090f3e931f598n,
  b: -0x364d3395022c1e8cecd672e2b63fe67512ff00d4f8db462eb37d442b2428en,
  r: -0x364d3395022c1e8cecd672e2b63fe6743d359e16079c2d21aa6e059804cf6n
}, {
  a: 0x1a2ccf20bb2d7f1f27260a46bfn,
  b: -0xf944729c728bed9ef94800aff4f87ddcfc8734006b1539257bd3afa221160ce9655n,
  r: -0xf944729c728bed9ef94800aff4f87ddcfc87340069726c337020d7b02ea3ac44f96n
}, {
  a: 0x5b7df07f3c2d19d7acdd2fe9a8a1f62fbb5n,
  b: 0x60b48a0cbe246a6df07c67d606a5cba4782d8ffb40dcd34e80bd778c58n,
  r: 0x60b48a0cbe246a6df07c67dbbe84d3983aff2d760eafd1e90adcda880dn
}, {
  a: 0x24c5263n,
  b: 0x1034cf92dfn,
  r: 0x10371be542n
}, {
  a: 0x17a7953a24b09541570d6329ce472427ad3fd0d007ba67065ea4856cn,
  b: -0x9d03bb50282af7e30fa60fe5n,
  r: 0x17a7953a24b09541570d6329ce472427103c157fdf8f6f234efe7587n
}, {
  a: -0x3307e0f08429ede8dc02e51f8c7e06b1ceb3942622982c4fb033b7d22n,
  b: 0xa4a47465560ee7d6c046dd4e5fe29f685c787304e22b9017455cb012998n,
  r: 0xa4716c84658abde8d76ada6940562161aaa9bf70bc08f7eaf5ac7c5ac76n
}, {
  a: 0x3855d660ed91857176741b6f84d19c8abfbn,
  b: -0x634deced4720a6b632953bf1ced51548abf130c540147bf2n,
  r: -0x634deced4720a330d52f2d18b67dfde16a3a3878264bcff7n
}, {
  a: -0x3d3196f6493ccdaa7000a1300f902741af8976ec54b42bbbde30cf04a09f3n,
  b: 0xc6f5b1c36dd8b0150f791e06c7bdc80c73a4ed27919a4103392db26d93c81en,
  r: 0xc32298540944e33a687913f3c6c4c59858ac55b8cc4efe477b4aa57d49be2bn
}, {
  a: 0x534a0d5fa717b0cb0c8a263fa37c225169bfb3c4b62222c1767c11n,
  b: 0x254a5c78472426694e9c09acad27d3637316d9e3b57c0a256e3d86n,
  r: 0x789469d7ee3bd7345b262fec50a3f5b4dcd68da86b9e2ce6e4b997n
}, {
  a: 0x78c53a39898cbbda16bb2n,
  b: -0x2fd25de16eb60426f6b6101b6c5afe25d32bf6f0680365fadafd8757n,
  r: -0x2fd25de16eb60426f6b6101b6c5afe25d3246a9cc46acd2f1d5c1ba5n
}, {
  a: 0x1762261a8f519a79dad680639acd71d4068ed59c5718e4a2574fn,
  b: -0xac0da51cb1f627n,
  r: 0x1762261a8f519a79dad680639acd71d4068ed4f04973c7f06128n
}, {
  a: 0x9b8e2e1a00942an,
  b: 0x45a4112c85ddaa7f2472713970f1b76be7b7f10283b6ad7dc9edbb2n,
  r: 0x45a4112c85ddaa7f2472713970f1b76be7b7f1028d6f905f69f6fdcn
}, {
  a: 0x266e875381cebbf0fbe551929dn,
  b: 0xa467e2dd37ed75cbf069dd4392c901839dca32b34f362b95abd591df36fd4017a7n,
  r: 0xa467e2dd37ed75cbf069dd4392c901839dca32b375a4b2e92da44dd032e291aa44n
}, {
  a: 0x33a5f4bb3c1cfa7ff3a44beac3fd86c4bd63e6d73ecd36f625c3763004eecan,
  b: 0x4c8a870238474c69a12117b2448ba048fc3ab805aca1708a5323f0f64fab17d875fn,
  r: 0x4c8a8a3c9793002b70c916ec894a4c88d4a703dbeb0ee47726935352870e1827629n
}, {
  a: -0xf76572223f16cccc8f36740df028a839e30de03eff48b7ab0044704f23d629580858n,
  b: -0xb3f72e81c99b28a63214c7n,
  r: -0xf76572223f16cccc8f36740df028a839e30de03eff48b85ef772f218befecf8a1d1fn
}, {
  a: -0x7737096bcc13e8c7a2e31b97367ab112bcfa68cbd17d34fac20948167n,
  b: 0x72f40c2b9013n,
  r: -0x7737096bcc13e8c7a2e31b97367ab112bcfa68cbd17d2dcb81468f154n
}, {
  a: -0x1a14015n,
  b: 0x9397f5ac679fd74f742f48c7914f795956dc85a0b676a9e9be9a1313165ba92ccn,
  r: 0x9397f5ac679fd74f742f48c7914f795956dc85a0b676a9e9be9a13131641952b7n
}, {
  a: 0x2af6bf94853ec4be8226524e3dc64b1b41e89bfbfb7d68n,
  b: -0x30536a33f15813da38dbn,
  r: 0x2af6bf94853ec4be8226524e3d95f7b10df743e821448dn
}, {
  a: 0xcf9b31280f87b3827f069c83272d12a4c249c56en,
  b: 0x1b9f19098cf0208f57dda0ff9b38e2d38b0a29e53ad5b30d7daecf62d166d2984656cn,
  r: 0x1b9f19098cf0208f57dda0ff9b38efcd3e1caaddb60ddafde77701d5a2911ebce2adan
}, {
  a: 0xea4fb0e586e5dcdea51cf19ecdadcdff133730b69cn,
  b: -0x59390acc09e218055n,
  r: 0xea4fb0e586e5dcdea51cf19ec81a3d5252990f3647n
}, {
  a: 0x509c7a76eec75749c0377ce2fdf378b8efb7afbab66daede1bf2beb961cn,
  b: 0x22ce4150f2d5e2b8787241b29d4fcc6a5c91787f5caafe11d8c6f38ed4e0c7c1dn,
  r: 0x22ce41a18f5059a73fc98b72d4ccaf68500a316f145ab8c84675d1aac79f81239n
}, {
  a: -0x22b3ae35e65d120b195e122abaded141423f759de4bn,
  b: 0xb5b4n,
  r: -0x22b3ae35e65d120b195e122abaded141423f7592897n
}, {
  a: 0xffa01343846fa1eb66n,
  b: -0x44d7cc612aa34971ebe50690574159501b38dce294456f3d57fac5b3d61f2n,
  r: -0x44d7cc612aa34971ebe50690574159501b38dce29435753c23c27eb9b768cn
}, {
  a: 0xab7e8972b1b099bd3de092c69241c62720475723e9010n,
  b: 0xce40f8b2e21d8cbe76c7fbd81c1e1b53dbabb11d1580dc25a9n,
  r: 0xce41036acab4b7d98063cfb6254a8477f80e23218af31ab5b9n
}, {
  a: -0xe8ea35c94394dccfc32b92b79f8f251d2664fd11b228c258n,
  b: -0x52076ff7c5c1db19afcec8aedn,
  r: -0xe8ea35c94394dccfc32b92bcc00624998282aeacaf154d45n
}, {
  a: 0xd2372749fd9252d54e7c2c1f6b7ca7e602b23415c8an,
  b: 0x9f9268e8724e94eb0684ca7n,
  r: 0xd2372749fd9252d54e7ccbb1d4651a34979d3a9a931n
}, {
  a: -0x69423fded6c02cd04dfda12b7d64ed97ad3313e9da67a727d13e2b5ff90ee8493n,
  b: -0x95f113ce18e93fn,
  r: -0x69423fded6c02cd04dfda12b7d64ed97ad3313e9da67a727d1478a7135f076dd2n
}, {
  a: 0xc386b2aff67136f66b0a10d92ea1be6e8a7699c5b3f182dn,
  b: 0x6924440b2n,
  r: 0xc386b2aff67136f66b0a10d92ea1be6e8a769a2ed8358dfn
}, {
  a: 0x31n,
  b: 0n,
  r: 0x31n
}, {
  a: -0xcee49a274d2ade4289706f7756ba2e3298b388257d5816n,
  b: -0x8229c6f99n,
  r: -0xcee49a274d2ade4289706f7756ba2e3298b3904819c7afn
}, {
  a: -0xd64d3bb478b78e4a6ab1786fn,
  b: 0x774880c26347be8e794aa6n,
  r: -0xd5d5f333b654468bdc382dc9n
}, {
  a: 0x2e90ab20a6664324d2f82e31bd67a71b0770d8655f30378b7032bc09fc3366f4ec4an,
  b: -0x360837dae99b97313206466ae34dd05609bc9658afbbn,
  r: 0x2e90ab20a6664324d2f82e31875f6f401dd541342d29f1208ce4ebb3f276d09c3c8fn
}, {
  a: -0xdad60a5f94f22en,
  b: -0x3686c0ad6c9786d16f30d133d0c229331d2d39225c0d36f102e4n,
  r: -0x3686c0ad6c9786d16f30d133d0c229331d2d39fd32179685f512n
}, {
  a: -0xe1d118799bb210f80cdfa8fb0fe7e97203b9efbac6775a50d1d111dcef695acc441n,
  b: 0x9381b507fd88b7864e0e887n,
  r: -0xe1d118799bb210f80cdfa8fb0fe7e97203b9efbac676c6cf1cc9145437e30cbdbban
}, {
  a: 0xce331ace87b08a95040ced6cb34be995bb30e836ef2a60n,
  b: 0xc755b259836ec68706c3e3c6978a23cd93423b5690ab75338496a05165afda29an,
  r: 0xc755b259836ec68706d0c6f844729ed63c927c256776a9f21df2535fe91ecccfan
}, {
  a: 0x70eb0625565e972319b9611n,
  b: 0xb4eb637eeea7c92853fa7e9f127d5d1d709eab4df0d54a70ecf7a45n,
  r: 0xb4eb637eeea7c92853fa7e9f127d5d1de189b1734733e19406b1056n
}, {
  a: 0xd9d70f485c7871f3n,
  b: -0x9c371aff763298e0969a77a5390bc6751b1e027d0cfc37284229b247921n,
  r: -0x9c371aff763298e0969a77a5390bc6751b1e027d0cee99b74da3eac072en
}, {
  a: -0x16833884911b05fbb548234996ece3432aaf511ea0fb4b03aa628n,
  b: 0x3ee1a72360db1e115ade4b5c3n,
  r: -0x16833884911b05fbb548234996eca461838bf04382e9f0255f065n
}, {
  a: 0x2c11711a3de3n,
  b: -0xaec4bn,
  r: 0x2c11710f5198n
}, {
  a: 0x8acn,
  b: -0x535ab777c1faa6235f5ab3d49dc67a5536ea9962n,
  r: -0x535ab777c1faa6235f5ab3d49dc67a5536ea90b6n
}, {
  a: 0x771ccf01a40a26aa2fbn,
  b: 0xbc305638de4f8n,
  r: 0x771ccfbdd4605f887f3n
}, {
  a: -0xb673c93e505d53facn,
  b: -0x34b237n,
  r: -0xb673c93e50609f1e3n
}, {
  a: 0x99513bf454584f334e74a906n,
  b: 0x159dd7122da9bf11fba8493a1092bef83b9e8ffn,
  r: 0x159dd7122da9bf1b90bc087f5617b22d22e9205n
}, {
  a: -0x961ac806a08325951ee3f8f1e31502e575e8fe44n,
  b: 0x764d40a120759bdfe46e38ec7fc7737e2ca38n,
  r: -0x9613633296711e3b60e5b20e544d066e3e06340cn
}, {
  a: -0x3876ca33ff10bf8a86cffcc7b33d0ed6n,
  b: -0x69eb6fac85eac8b2n,
  r: -0x3876ca33ff10bf8af0bb6c743927d788n
}, {
  a: -0x38936dbb0524d74d3df37ed406f34n,
  b: 0xc59083f997422f2f24d0fn,
  r: -0x38936dba3f945353a6b14fa4e2225n
}, {
  a: 0xa0ef73en,
  b: 0xd0219eeeee7bc33f2f4c944e7e6541464194b36567b14dn,
  r: 0xd0219eeeee7bc33f2f4c944e7e6541464194b36f76a88bn
}, {
  a: 0xaa053a72cca46f27fb7707adffd9f77n,
  b: -0xdac86f5f92132e0b53b0n,
  r: 0xaa053a72cc96c2a1057de67b1f24bc7n
}, {
  a: -0xfce541ed7eeeecd62d05611195966b92cef99400c6c30d1b4e8n,
  b: -0xa7dee2338dedbn,
  r: -0xfce541ed7eeeecd62d05611195966b92cef994a8a5a540a93c3n
}, {
  a: -0xc9b0b13b07167ad5n,
  b: -0xad9ae2cf6a889e1a63997b0f5a6e50fc18f428d75b443ecf6505bdn,
  r: -0xad9ae2cf6a889e1a63997b0f5a6e50fc18f429a10bf579d67b8092n
}, {
  a: -0xd94094337d0e11951ae6931662e402bf27027fe4b534fdn,
  b: 0xbedf89b709f892b413f25ca32cb76c88ac6f1cn,
  r: -0xd9409432be2e87de10ee00624ef1a61bfa4b135c08c5e1n
}, {
  a: -0x14828c25dd3b457ba0b9497123a50591a0382c6f3d3207894d1be30n,
  b: 0x8be3cf2a00075de2f995cccff43f65d6f34e110c05c394c87dd080e86d832n,
  r: 0x8be3cf157d7b3805be50512f3af5f4b34e487f6bcd97258b4bc8f79b51a02n
}, {
  a: 0x9790932139c1829f0d23cb3f83241c37bda34c10e2b9a21n,
  b: 0x8afd683d0249eb7a59n,
  r: 0x9790932139c1829f0d23cb3f832424e794271c35817147an
}, {
  a: -0xfbdd4fa7bn,
  b: 0x10edbde3c2cd06df6415cc3n,
  r: 0x10edbde3c2cd05e386c6248n
}, {
  a: -0xc65985feebe8fa955089399a5a63d8n,
  b: 0xdc3b2025d724552144c690f6fd59228e17640ba26ba8d5bn,
  r: 0xdc3b2025d72455213860f8970e9a92e4c25b7808c602983n
}, {
  a: 0xb96cdfcc48337en,
  b: -0xfe68707247b51ef2d4a731927n,
  r: -0xfe68707247a98824d7e2ae5a9n
}, {
  a: -0x79003dacb9a7d500a9143b0a2e1c020d9dea2fn,
  b: -0x6dcac69128a1877cb15ce873e042ebf8cb3dc3318f5507d7n,
  r: -0x6dcac691291a87ba5e169048e0ec0033d56bdf339cf2f206n
}, {
  a: -0x8551b672035f0c7b29d3944e3488cb6347096c09a945a7d3n,
  b: 0xdd3a2e459ea06d3e6932c63911af53f1320a66963c0c830cd21efaa9c18c6945645an,
  r: 0xdd3a2e459ea06d3e693240e75b3d5092258f3cc2a7be4e8406bbb3a05582bfffbc87n
}, {
  a: -0xa78bf4e5df9e7d073206ce65bacd4bfa346dc122ff4b90ae5n,
  b: -0x6226bbeedffb93e444212639a430n,
  r: -0xa78bf4e5df9e7d073206d488268c39f9edac056511af2af15n
}, {
  a: -0x1535da5e990802a543f0a153134883dn,
  b: 0xc86dcc80e446dff70d113f04d7273d3c1ad72d380f97da8b1a3a61d4n,
  r: 0xc86dcc80e446dff70d113f04d5d3df963146ad0dbb58d075e905d997n
}, {
  a: 0n,
  b: -0xed3cf715107cfd8e2c1150e31d08306eace8e6aa949dn,
  r: -0xed3cf715107cfd8e2c1150e31d08306eace8e6aa949dn
}, {
  a: 0x2d002b18098c2an,
  b: 0xe59efa8d1c529e6c8c1n,
  r: 0xe59efd5d1f041f054ebn
}, {
  a: 0x5f86a9a59fe4db08923d730ef664528a05bf542aaan,
  b: 0xd06dc6d00988a907f3cc1f5353b1n,
  r: 0x5f86a9a59fe4dbd9000443187f0d5a7dd1dea77e5bn
}, {
  a: -0x611c849ed2f02afd3900d155f06aab186b4629cb2b7ecn,
  b: 0x9c9b8f73dac4dc4404cc93c983b4de9e7456f9b6677245b764e6859bn,
  r: 0x9c9b8f73dabeca7bbadf64c6d3e14e915ef7f30bb5eb9154c833cdafn
}, {
  a: 0x924n,
  b: -0xed233725302fan,
  r: -0xed2337252f9d6n
}, {
  a: 0x5n,
  b: 0x579550c3747400e6e37e68a8e5a99c011c4d9d6n,
  r: 0x579550c3747400e6e37e68a8e5a99c011c4d9dbn
}, {
  a: -0xf958234eb054a132b0ab9f91d2c33b7aecff4fb57158ae12b6bbeca002528f7045f77bn,
  b: 0x22e48c86300bd398bn,
  r: -0xf958234eb054a132b0ab9f91d2c33b7aecff4fb57158ae12b6bbea71b98a2c6f88bdf0n
}, {
  a: 0x4a7bd984149e5043bb4dcacca3f8dc380n,
  b: 0n,
  r: 0x4a7bd984149e5043bb4dcacca3f8dc380n
}, {
  a: 0x7d8c2c445f5d6cca3e14155613acc034782feb96c7ce5bn,
  b: -0x7n,
  r: 0x7d8c2c445f5d6cca3e14155613acc034782feb96c7ce54n
}, {
  a: -0x5e002fb83bf23c2aad8af84b4239n,
  b: -0xb00cd0b1e383c6ff47d72n,
  r: -0x5e002fc33cbf4748e5c7683fbfabn
}, {
  a: 0xa73522f59ab96612757e54323c6f1031de4198b3d2bfe0b42e809c366622f3d20n,
  b: -0xf2d4b64e8defcd74ecc28841a2a67a5d6ba3dn,
  r: 0xa73522f59ab96612757e54323c6e1d5d27f30ac4054af3f1a63ef98febc5882e3n
}, {
  a: -0xf7n,
  b: -0x9e53dacb91fa4e2bdc71282274df776aaf5984n,
  r: -0x9e53dacb91fa4e2bdc71282274df776aaf5a7bn
}, {
  a: 0x4f556529a4c7c7552c8b799cd4f5d86321f20a11199b985fan,
  b: 0xefe0n,
  r: 0x4f556529a4c7c7552c8b799cd4f5d86321f20a11199ba75dan
}, {
  a: 0x100bn,
  b: 0n,
  r: 0x100bn
}, {
  a: 0x66bf1ff6cd1a4b7707e92cf3682e44e83d425f64141a5aaf4e2e4n,
  b: 0x3dff49170eed58d0b58ab9c336cfn,
  r: 0x66bf1ff6cd1a4b7707e92cf36c0e3979ae3134f11f73064b819b3n
}, {
  a: 0x1d4aaae67b50741124b1157ffe2ec49c95n,
  b: 0xd26f00163ca5a988df5f81949caa4770e8cc600eb38a6c71c65453n,
  r: 0xd26f00163ca5a988df5f9edf4790c2c15cdd84bfc90a6aa08af0e8n
}, {
  a: 0x16c597992695eb3a032b934bc27f45a89d53033844c376dd6d7a83b890dcn,
  b: 0xab55d0498301c0511cddd7d0592629dd0b67ec2d43n,
  r: 0x16c597992695eb3a03d6e91c0c024768ee6fe110151c9d074a85eba4be1fn
}, {
  a: -0xbf5298b7fc54f17f22dbc82caf67d38d93d38757d244bd7b7fab5b65n,
  b: 0x33c5522c1df9323f10f71e4d685adc93a6019cn,
  r: -0xbf5298b7fc54f17f22a802da8349da5b54c2903984dc629eec0559c9n
}, {
  a: 0xb6bc07bn,
  b: 0xe03ae88739d00a7cb9234b26deab319c83db7fe81bdf84n,
  r: 0xe03ae88739d00a7cb9234b26deab319c83db7ff3879fffn
}, {
  a: 0x8ec64239c55eda42180cf10ee3545547034696f4a2456e04860bf01878f27369a8f7n,
  b: -0x42677ecab9f7an,
  r: 0x8ec64239c55eda42180cf10ee3545547034696f4a2456e04860bf014527a86be097dn
}, {
  a: -0x40c9cbaebdan,
  b: -0x348n,
  r: -0x40c9cbaef22n
}, {
  a: -0x7c97c9431909d74982n,
  b: 0x8338de9ca1f7937n,
  r: -0x7c8f95b52f3fb7d04bn
}, {
  a: 0xe95cf7342n,
  b: 0x3b5bd256dd5aebc237060040730115ae1n,
  r: 0x3b5bd256dd5aebc2370600415c5e0ce23n
}, {
  a: -0xcd1726c8453c0cf985489138d6ae08ed0fed2n,
  b: -0xd3c38d74cdf0014e07a62dad05f95a2835n,
  r: -0xcd2463011c88ebf99a290b9bb17e6882b2707n
}, {
  a: -0xd6bbc202c86c2a0bb706cea9aca5a6867e00304751a4e48fn,
  b: 0x4cd791f5e25e173c0312d4abd0b73d19208fd06c33d47d7bc5n,
  r: 0x4c00d633df95ab11f75bcddd270a97729a11d03bec82d89736n
}, {
  a: -0x57cb700n,
  b: 0xa69b417792333faabaeb0cbf8cfcc03d051647ab3a283dn,
  r: 0xa69b417792333faabaeb0cbf8cfcc03d051647a5bd713dn
}, {
  a: -0xa28n,
  b: -0x237bf5c2f32183821ef07n,
  r: -0x237bf5c2f32183821f92fn
}, {
  a: -0x703e1542e09f379f9f247574a77n,
  b: 0xbaa83a87a80347e435ec924619c9444b19ff0068fan,
  r: 0xbaa83a87a80347dd320b3e180fd5ca5127b7a91e83n
}, {
  a: -0x9b102586e617ee7a4fcfbae95c01a5bbd4f20ff301e51c4b6ffc0n,
  b: 0x9n,
  r: -0x9b102586e617ee7a4fcfbae95c01a5bbd4f20ff301e51c4b6ffb7n
}, {
  a: 0x8f15572e02a30485f5ee79e6f349e5cf294c993d08a5ae21be47b167b9096831dc59c1n,
  b: -0x85df761n,
  r: 0x8f15572e02a30485f5ee79e6f349e5cf294c993d08a5ae21be47b167b90968297e6260n
}, {
  a: -0x2968a9d4921bba52b680ab928643028fcc70b769cdda412ef24c58a26bacbn,
  b: -0x165959728ee0b93c0c88e04fc117510fcabf772da2551d24589e348119cbbc9a5n,
  r: -0x165982db38b54b57c6db96d06ca9d752cd4f439e59beeafe99cd26cd726e28470n
}, {
  a: 0x3b5550eda1e06d8c48ffedef72e7dccec5adce81c9b94584f45bn,
  b: 0xfbe05af476aen,
  r: 0x3b5550eda1e06d8c48ffedef72e7dccec5adce82c599a0796b09n
}, {
  a: 0x97da4a678d2b5d66e0513398b4486d7dfd7cfa19ed1c7cffdd1760f79f063cea5b86n,
  b: 0x5f2c8606d168dc1458783c4f3378e4cee33050c495eb71a7d20359n,
  r: 0x97da4a678d2b5dc60cd73a6a1d2481d675b9494d66014be30d68258d8a77e4bc5edfn
}, {
  a: -0x589a341788fe7a4bc25832d9c48726287f50e3n,
  b: 0n,
  r: -0x589a341788fe7a4bc25832d9c48726287f50e3n
}, {
  a: -0xd635d6309n,
  b: 0x3df3402f53fe7486854027b4f39bc2e8d779f9ffe6f58849742dce721n,
  r: 0x3df3402f53fe7486854027b4f39bc2e8d779f9ffe6f588489df7f8418n
}, {
  a: 0xe444231742n,
  b: -0x2516376f279104ec91a4294581dn,
  r: -0x2516376f279104ec835fe7140dbn
}, {
  a: -0x26f9405deb1f59e8183878n,
  b: -0x3599998c4a207234245127n,
  r: -0x5c92d9ea353fcc1c3c899fn
}, {
  a: -0x34258013c30dafbb6a49fd29n,
  b: -0x7d7223c919849d73fcd2aa7ccdf147804037325fn,
  r: -0x7d7223c919849d7430f82a9090fef73baa812f88n
}, {
  a: 0x6e45799299351110ab29441541e5666e4ed00e227f6e496e6a9c2n,
  b: -0x86a97d60e6103642253an,
  r: 0x6e45799299351110ab29441541e5666e4665764c710d460a48488n
}, {
  a: 0xdff72125af83676443d2a94d1c98016595dfc80fca11c792n,
  b: 0xb4c1c185c5cf3b5efe6cba398ab001d0c52d01478cd2bfed686aafn,
  r: 0xb4c1c265bcf0610e81d41e7d5d594eed5d2e66dd6c9acfb77a3241n
}, {
  a: -0xc43n,
  b: -0xd9f1cd700cff65dea8078b01dd53cfb23009bd942e0db2n,
  r: -0xd9f1cd700cff65dea8078b01dd53cfb23009bd942e19f5n
}, {
  a: 0x845713c414cbb49c60bea9en,
  b: 0x1300e4cecd517bbfb133n,
  r: 0x845843d261b889b41cb9bd1n
}, {
  a: 0xe047b45f15cb05973718d2954852ab69806c9a505217n,
  b: -0x2023dac4c9830230e5e180c8ae04b9f409e655197af4366ad979d24c5an,
  r: -0x2023dac4c98301509e2d21b2e2ff22bcf113bfd12848ccea6cdf81fa43n
}, {
  a: 0x16b3423294c3cb1fa9b62e5233896682b4733cn,
  b: 0n,
  r: 0x16b3423294c3cb1fa9b62e5233896682b4733cn
}, {
  a: 0xb80a6c11fa6b951f7cd17d8205ab8n,
  b: -0x4een,
  r: 0xb80a6c11fa6b951f7cd17d82055can
}, {
  a: 0x2ff15357942fef641c8668325f09764e7f291ff65568626815e738c319c63n,
  b: -0x1698a18e9d260189900d8180da5e910eac956b74e3f8b9d88f8ff1n,
  r: 0x2ff153562aa5d67a4a264f995e315e40d9400f0b8c11ab19d65b9b3a20c72n
}, {
  a: 0x69f6ea9b060cbdebd22daef4312112858c30e2739cn,
  b: -0xb83e7bc30d320een,
  r: 0x69f6ea9b060cbdebd22daef431158e9dd0000f52aen
}, {
  a: 0x86700ac7e2d3db9n,
  b: -0xeb062160f6cdc383275de4463eaed398f404e5a239ca16974db53fad8345e5edn,
  r: -0xeb062160f6cdc383275de4463eaed398f404e5a239ca1697454e3f010518a834n
}, {
  a: 0xc5845703bad516bf21941611205540e10d09577ce647ba9568n,
  b: 0n,
  r: 0xc5845703bad516bf21941611205540e10d09577ce647ba9568n
}, {
  a: -0x3bbb2ddfa1bc2e623b6f56535b5c0n,
  b: 0xd9eaae559e5a7c9n,
  r: -0x3bbb2ddfa1bc2d8850c100b500df7n
}, {
  a: -0xa03ea7cf0aff71f3f4370a0a13502c7cd46fn,
  b: -0x9fa3bd429baa214a92981e8e83aan,
  r: -0xa03ea7cfaaa32f368fe12b54a5e84b0b5819n
}, {
  a: 0x88121765322ea1c7c02d526n,
  b: 0x92e50c4e95e21d3d02d909e8cc723a1af65f2ffn,
  r: 0x92e50c4e95e21d3d8aeb214dfea0dbe2b68c825n
}, {
  a: 0x4a8f2994976a727886de9b8f0e7431f921b87f0e53d11an,
  b: -0xb2eb7c8c710d0c32487f7a2n,
  r: 0x4a8f2994976a727886de9b83dfbc693210e7bbe9cbd978n
}, {
  a: -0x4ed74597cc45784e86c7fd764a1346e4b9a5bd4931a720db698be8e15a0ff28cbaadn,
  b: -0x9c2d6d649ba140c427639e6967bbadcc5f53e184f16ac6n,
  r: -0x4ed74597cc45784e86c7fe127780ab805ae6817095458a432539b540adf1777e2573n
}, {
  a: -0x458814634b7fd667b8an,
  b: 0x778c0071deaa75da16744e8106ba4n,
  r: 0x778c0071de64edc5b328ceaa9f01an
}, {
  a: -0x6d36496536d6de42e3af198e02ca122e49d9c5524cbabn,
  b: -0x1bbf9910871e33a19f97n,
  r: -0x6d36496536d6de42e3af198e04860bbf524ba88c66b42n
}, {
  a: 0x47a4caf114a2e88c4e70e0ca7918n,
  b: 0x640064e747606519571858e59aed75d1856008625c2n,
  r: 0x640064e74760651dd16507f6e51bfe966c6e1509edan
}, {
  a: -0xacf123n,
  b: 0x3a247bf49c51df9fdf81cdc8880n,
  r: 0x3a247bf49c51df9fdf81c2f975dn
}, {
  a: -0x9bb700d57d6n,
  b: 0x700716ebf9505a728b9ca40e9a19690c764e528441ba06b253893n,
  r: 0x700716ebf9505a728b9ca40e9a19690c764e5284411e4fb17e0bdn
}, {
  a: -0xdcn,
  b: -0x42739ca76a585aebeec09255ab408fn,
  r: -0x42739ca76a585aebeec09255ab416bn
}, {
  a: 0x850c303a2c51fb265dc74b45f94c81a788b4ff5c7128b0a05bb18c3cn,
  b: 0xbc4b887d2aa18d29e753a3a33f49ef4fba9aa861c22cn,
  r: 0x850c303a2c52b771e64475e7867668fb2c583ea660786b3b04134e68n
}, {
  a: 0x259d1232d1f8e296d305b0562aaf9a132380b624f13c6e4d5a301aafeca645n,
  b: 0xcea6648f714302e7n,
  r: 0x259d1232d1f8e296d305b0562aaf9a132380b624f13c6f1c0094aa212fa92cn
}, {
  a: 0x7f6b5be82a8a9191d62c8c20cdfbf00fe96c90867ae623n,
  b: 0xae1a05ed8df6c9n,
  r: 0x7f6b5be82a8a9191d62c8c20cdfbf0109786967408dcecn
}, {
  a: 0xa8adb4761ed8356ebde6d66eeddcab6c9bcfe5f0an,
  b: 0xa65308a92b01c58900fn,
  r: 0xa8adb4761ed8356ebde6d71540e554979d956ef19n
}, {
  a: 0x12de8160752631bbda0618051b5868bb11bf9792cn,
  b: 0xa88542bfa0d927d4c2acd7ee16a525d8f49f3e799f1660ded7n,
  r: 0xa88542bfa2070feac9ff3b09d44587594654c50550325a5803n
}, {
  a: 0x2751d1f51e188e6n,
  b: 0x279bd53aafb7c9e948c6e412114590n,
  r: 0x279bd53aafb7c9ebbde40363f2ce76n
}, {
  a: -0x85ee868b0c9b1e1f0f02c27e20a415646517dbb7b87a0719064c59f4332f5c87en,
  b: -0x517adf37d6ba73d383019cdd83eab9fa7a46a4abc7a43fe3438fa58b2519f06an,
  r: -0x8b06347e8a06c55c4732dc4bf8e2c1040cbc460274f44b173a85544ce580fb8e8n
}, {
  a: -0x702115ff1a264f19e6b8113896045eac7281592cb2653d00de3053b17d628a0fca4n,
  b: -0x5c0d5a4en,
  r: -0x702115ff1a264f19e6b8113896045eac7281592cb2653d00de3053b17d684ae56f2n
}, {
  a: 0x9f1ef04dc571cb628e14cc15cbe4beea93d3e3b84a112a87609c987f947a3202d1c340n,
  b: -0x91cfc7cdd681fca55642d7e4n,
  r: 0x9f1ef04dc571cb628e14cc15cbe4beea93d3e3b84a1129f590d4caa9127d8cac8eeb5cn
}, {
  a: 0x898929a271477a65fb38757027b9bb2ddeb1b32f0f31683474d9a1bn,
  b: 0x9b78ad6d55f5832c0ab1e5af9c7c0d53fcf9510c3d32ca9e5db5b987c7c2fbn,
  r: 0x9b78ad75ee881d531f298c0f50036456789503ea284dfd8f50cc3ccf155d16n
}, {
  a: 0x6ee8dce54313d483616e9a07c93n,
  b: -0x3b55619d122466d62dd0b319dfc613265d5e451c8641a95n,
  r: -0x3b55619d122466d62dd0443102e0d01288dae3adec39e02n
}, {
  a: -0x99679fdb12d146b6ab1n,
  b: 0xe6b85n,
  r: -0x99679fdb12d145cff2cn
}, {
  a: -0x4e6c182n,
  b: -0x832d168716a3ef4ba9521789c7a86c5a7f3c35c309a64bn,
  r: -0x832d168716a3ef4ba9521789c7a86c5a7f3c35c7f067cdn
}, {
  a: -0xc87n,
  b: -0xf199e286ac68f5247fd5f3ad6d8bae290a70b2303d3c20a82a70db8n,
  r: -0xf199e286ac68f5247fd5f3ad6d8bae290a70b2303d3c20a82a71a3fn
}, {
  a: -0x8178799n,
  b: 0xe5e00f3841e6a1dc72da9edffc1e47ee73bd3cc2n,
  r: 0xe5e00f3841e6a1dc72da9edffc1e47ee6ba5b529n
}, {
  a: 0x2d7c42e13f9f582209a5ca275an,
  b: 0xef22e4d673afc60d7882e0462548e6cefan,
  r: 0xef22e4d6a12c08eeb82238682eeeb0f654n
}, {
  a: 0x398d13c58e92b59d71f0f3d236de7ae8391ab84e0f07caec88c0c94a3de7461n,
  b: 0x7b2e61a99f2ece20a6fab7f690685e9a2e0db4f85ae1eb0851n,
  r: 0x398d13c58e92bd50580b8dc523c08557e49a215494f16dcd64104ef85c97cb2n
}, {
  a: 0xb5186de86042af0d2e540e4cba175b0e83118bea8e895b4e789an,
  b: -0xb1d26874f6233ade102n,
  r: 0xb5186de86042af0d2e540e4cba175b0e77f465633f2727a09798n
}, {
  a: -0x7fn,
  b: -0x532f2ded8c00e6ec46a008b24d221e3c772de26c9c8b69n,
  r: -0x532f2ded8c00e6ec46a008b24d221e3c772de26c9c8be8n
}, {
  a: -0x9c99855cc37449629053d44d2a0a79319166n,
  b: -0x265f6c086adn,
  r: -0x9c99855cc37449629053d44d2c706ff21813n
}, {
  a: -0x458c948a54n,
  b: 0x62n,
  r: -0x458c9489f2n
}, {
  a: 0x5174a01bf9c6a083f8d40eaffbda65e097db58ebbf152a5cc367df93dn,
  b: 0x7165f7dde4d193f6242fcbae5adfn,
  r: 0x5174a01bf9c6a083f8d40eaffbda6cf6f7593738d8548c9fc022c541cn
}, {
  a: 0x690cd0837cd92fae237e5027a121fc8f6a5n,
  b: -0x6fde213a53e4a49d5d3ee5b5fc14e054750a2789e4661b1n,
  r: -0x6fde213a53e43b908cbb68dccc66bcd624e28667e7d6b0cn
}, {
  a: 0x8b7a6adb7983fad72ba9c8c427927256c412fad6708ab5b3014ddf53n,
  b: -0x8add5217e42a18555f6e319ed7118b3268e9008n,
  r: 0x8b7a6adb7983fad722fbf3a2a94fd0d16e1c17bc83199cffdabf4f4bn
}, {
  a: -0xd2227156a1966be577d42984da0c557eee5356bdf69926en,
  b: 0x76dn,
  r: -0xd2227156a1966be577d42984da0c557eee5356bdf698b01n
}, {
  a: -0x50973083d8f88f5bc9f255d58253e230052dn,
  b: -0xde2f09c16905a8n,
  r: -0x50973083d8f88f5bc9f256b3b15da3990ad5n
}, {
  a: -0xe5fa483c0330df859631f68bcdcc1c552368c95f25fcb789n,
  b: 0x460ef7ca29b98b1437e71e1526a5b56b9fc528a980fn,
  r: -0xe5fa43db13b43ce9fd80b30d5beac9eac8120f62d3721f7an
}, {
  a: -0x6ef4f9cfn,
  b: -0x9f365053c77fcbb83e5bb045daadf432919173fa3757831n,
  r: -0x9f365053c77fcbb83e5bb045daadf4329191740126a7200n
}, {
  a: 0xe83e4131bd74f5418fc7bn,
  b: 0xa1934a29c2d6662fde87bf65613a527cf8b3e1c86a8f1a07b36641f54e04de12n,
  r: 0xa1934a29c2d6662fde87bf65613a527cf8b3e1c86a9d9debc6821944a21dda8dn
}, {
  a: 0xcb32b36722f20595fada3b5ca84861e43f2f0ef58c493dca2e872b42ea91d108bf7308n,
  b: 0x8c12494f3dd3c1da78d9f9807320c1b4a8e07e750d1bf0992n,
  r: 0xcb32b36722f20595fada441dccdd55c17b4cb6832be144fc3aa275d0f27921da7e7c9an
}, {
  a: -0xa02a57a0e7eac2b48d46f77b71c6d19ab5b95858f6729be895d43b128b7fb76n,
  b: -0x77654bacc5d044c3641b5261a2e06909fb7fee6n,
  r: -0xa02a57a0e7eac2b48d46f77be92c1d477b899d1c5a8dee4a38b4a41c86ffa5cn
}, {
  a: 0xcd52abde1330dbbb53c382b8334086a86ba8443f128c8346bn,
  b: 0x683d38783f59fe125fbc720c7a0fe0e25fb15bdn,
  r: 0xcd52abde139918f3cc02dcb645a0431a7822541ff4ec34a28n
}, {
  a: 0x10087ce62b5467ab2ad13d47af0fn,
  b: 0x37189f4443a5a7179303052603f7d416ad86c5c4e5f4882de252c8843b7677ef15ae1n,
  r: 0x37189f4443a5a7179303052603f7d416ad86c5c4e6f50ffc45080efeee238bc3909f0n
}, {
  a: 0x15c35bda50e7d9225e52c223be239348e4a68df4b801a273be8dn,
  b: -0xbc81dd2fac98d50588c22fc6e73c29fc78fn,
  r: 0x15c35bda50e7d922528aa450c35a05f88c1a6af8498ddfd3f6fen
}, {
  a: 0x5245de7cfc101cn,
  b: 0x52dc620e12381ad597080126d615a9961166badb6b751469886n,
  r: 0x52dc620e12381ad597080126d615a9961166bfffc95ce42a8a2n
}, {
  a: 0x905cf21324a1d3cb513b1d8n,
  b: 0xb70ba95c895c04731acd84e059ddaec88610040c1708ac3n,
  r: 0xb70ba95c895c04731acd84e0ea3aa0dbaab1d7d76843c9bn
}, {
  a: -0x88e59n,
  b: 0xf871e69098006c44a8d0bf9e7f1b16bb8b34ecdc672d79418e5f9918a165a2fd777en,
  r: 0xf871e69098006c44a8d0bf9e7f1b16bb8b34ecdc672d79418e5f9918a165a2f4e925n
}, {
  a: -0xafa5c440b6145e462abe7e480afa3d94026f7ae52126fd9fc466359a563a6600n,
  b: -0xc640046ebafecf38cd4ca5e976e09791c9a29b91a1569f708dd6a0n,
  r: -0xafa5c440b6da9e4a99797d1743c78a39ebe65b7cb2f0a03b56078c39c6c83ca0n
}, {
  a: -0x36d2f6c463423290e9990f66e4eaba5dcff2ac37c046dc8b327dd74bde618cf65654n,
  b: -0xa9dc1dee77fb209286baf3ed7675dba72b0f8b96517en,
  r: -0x36d2f6c463423290e9990f678ec6d84c47edccca4701d078a8f3b2f30971188ca7d2n
}, {
  a: 0xdde78c65c34c82fn,
  b: -0x8452d1fb92f1cc2448ed34d3f31e5ae9ecd22afc953c28a6d76e66ec57c2en,
  r: -0x8452d1fb92f1cc2448ed34d3f31e5ae9ecd22afc953c27c8efe201290b3ffn
}, {
  a: -0x987c71d94c8cd739f956014a7865f71434887fad2ed0adb06c4b04ebe6509b81en,
  b: -0x50767c99b9735cdedc15a85bb4n,
  r: -0x987c71d94c8cd739f956014a7865f71434887fb23638774c0380d2d9a7ab213d2n
}, {
  a: 0x5c8ff3215a63d452fa5eaa0b6ccd5cea10147d43622544b72c2e093922994078n,
  b: 0xe8416652740d43e304fb8e6f09f7ec25e4cb47a1f7b62aa5ab4c2e84630c83adbc41n,
  r: 0xe841c2e2672e9e46d94e88cdb40358f341b557b674f98ccaf0035ab26c45a646fcb9n
}, {
  a: -0xbc54d7a0c82665ddc81813d2e9532d4n,
  b: 0x71102a49c2b5c8e57bc2ef9a7650d802de4cdd70dbb7149bf24db07f8n,
  r: 0x71102a49c2b5c8e57bc2ef9a7594832b3d84b70afdeefc881f645d524n
}, {
  a: -0xd61437c2f0b8fdn,
  b: 0x24497ea9047cbc2195b1efb3ffd02a58f6n,
  r: 0x24497ea9047cbc2195b1199fc80d399ff9n
}, {
  a: 0x86d5d2ff348cf2a7c7d846008d3ab7fd07c4df002899c3ecaa7c2cn,
  b: 0x82f12e57b59e7cd132835c361b5aa51n,
  r: 0x86d5d2ff348cf2a7c7d84608bc4d9d7861acac1350cf874e60267dn
}, {
  a: -0x1b36e1d21268fe0e20acb1a3n,
  b: -0x2d6f94d98d8a1f964n,
  r: -0x1b36e1d4e9624ba6f94eab07n
}, {
  a: 0xc206en,
  b: -0xcd8cefc296d3f9f7bf218f97590750917c3662c9bdfa58306a4e2176d2c8f81n,
  r: -0xcd8cefc296d3f9f7bf218f97590750917c3662c9bdfa58306a4e2176d206f13n
}, {
  a: 0xfcn,
  b: -0xe21bcb591acd1aeaa1405b3c038c095f5489en,
  r: -0xe21bcb591acd1aeaa1405b3c038c095f547a2n
}, {
  a: 0x96fecd3eb56cbe766dcdfb9732c1b2c03n,
  b: -0xef08575b221ef758bf13aa693n,
  r: 0x96fecd3dc664671b4baf043e73ae08570n
}, {
  a: -0xc0ada7938c945acfbaf4an,
  b: -0x45b8ee96fab90c98bcd4688f369da93c8b8109e9a164n,
  r: -0x45b8ee96fab90c98bcd4689b4178227554c6b6e550aen
}, {
  a: 0x80d19a61fa2e0b4ef94c2b268510039a1ef23711b2484c4269dc5934181f354a7n,
  b: -0x25dfd507011a4e186acf698008ed7038b290b0548230en,
  r: 0x80d19a61fa2e0b4ef94c0546b009027fd0d9cc4248c84354f9a3a6a367cab3199n
}, {
  a: 0xe4725eaae01e0201a6bb604b4b122n,
  b: -0x9ac7f5c2445d433f0437aa262a3a25884961ead1bc344c7fcf472263ee15feb810e58bn,
  r: -0x9ac7f5c2445d433f0437aa262a3a25884961ead1aded269521454243d3aa48b35c3469n
}, {
  a: 0x79f4a6dfb470d066edd82aa3264fef8fae6n,
  b: 0x72284a0697669b8862bn,
  r: 0x79f4a6dfb470d067600074a9bdb68b18111n
}, {
  a: 0x78d4e2b1870177f6994b5ab3181682b0b5e3e9593480b7cfb4en,
  b: 0xc601b30235449b28f2d4b93ffbe4546ed1150807ab41n,
  r: 0x78d4e2bde71ca819ed950d42456216b07429304645d1384a68fn
}, {
  a: -0xeaf694ddfdb9dee0ed83233a5941bf4a150f6n,
  b: 0xd264605cc075ffaf5dd112164e67014ca87f08229n,
  r: 0xd26375662b9801f57ef024932b2ca80ae934f3133n
}, {
  a: -0x632e7a30ead4d73ee770a23n,
  b: 0x6b4cda34797ea4103b6c6f4fe9a087f7d99n,
  r: 0x6b4cda34797e40e1c13b847b1261a087376n
}, {
  a: -0x418afe362e7f0d85503d7cf16b282175a9n,
  b: -0x892be5e934cdd44898335c91e18a61fa9n,
  r: -0x4a1dbc94c1cbeac9d9c0b2ba8940c79552n
}, {
  a: 0x13f1dbe90eb6ae6a149938b99fd29e6c997a32n,
  b: -0x28ed49a8c6c740d522c7f12679e27b153ac657189846bc980n,
  r: -0x28ed49a8c6c601b7643705bb93413181af2c59eeb17d24f4en
}, {
  a: -0xa7f8a3f15d06d7bce03211d80e6536175a748aff14b9c38b9a2ab16184632n,
  b: -0xa94fd5a9ecb43aedda3a01571e9c73ef94cabf6609dd0cba8e1f7c080n,
  r: -0xa7f94d4132b0c4711b1fec120fbc54b3ce641fc9d41fcd68a6e53f81006b2n
}, {
  a: 0xbc861df03827c3ccb88418c6a67599b647646478n,
  b: 0x2e46892de0e823122aaf6d2c261c8b38b934fc32n,
  r: 0xeacca71e190fe6dee33385f2cc9224ef009960aan
}, {
  a: 0x1168adc50a026374a5bbe22ec964n,
  b: 0x35067n,
  r: 0x1168adc50a026374a5bbe23219cbn
}, {
  a: 0x734985dc7d85025bee1add2n,
  b: -0xa41292189d0065b30803e5905145f45ed8eb31c69925cc45a5dn,
  r: -0xa41292189d0065b30803e59051458115530eb44196c9de2ac8bn
}, {
  a: 0x46f33444n,
  b: 0xf0ea8940c1f703b6da9ff0n,
  r: 0xf0ea8940c1f703fdcdd434n
}, {
  a: -0xcdc2bc1912c56ee9bb167d1052a6d12c17837d57a90b9b1cc59b5d244db2ca9n,
  b: 0x560e5203921213121b6bb164e8abb9e01c9f03690e3dc32d4f7fn,
  r: -0xcdc2bc1912c00e049add5bef21851a710134f29c0b09d12c8f0a79481addd2an
}, {
  a: -0x2e9f4bffe5caf398254c58a28f88540a11287506c8e5bcbd73a59ddd7606b31d47b2an,
  b: 0x7f464bb147c3125907214fc12957e83848f47e45811c4f577897e8459f3dad3n,
  r: -0x2e9f4b809f7f42506239ff9b6e3892e0b9403cbdd467773c57564664de1e6d7e0a057n
}, {
  a: 0x24d12eb9b1dec82d88c78eeb820b3d8de1be22e0d4e4bfbd0ce01949e119a4n,
  b: 0xb1a2e2e0c0e0a70b0n,
  r: 0x24d12eb9b1dec82d88c78eeb820b3d8de1be22e0d4e4cad73b0e2557eb8a54n
}, {
  a: -0x583568f9f35cca1260a0776n,
  b: 0x761d56101961b15c07e862ebbe0ca041c718646b36ea2d546d746e47bb84ede6n,
  r: 0x761d56101961b15c07e862ebbe0ca041c718646b3166d6c4ce3ea1a6957ae670n
}, {
  a: -0xcaafee1c077beff20f15a45508823454cd1ef2cb05a5b4e6146bf6df21ba1c1n,
  b: 0x251467f0fadb7edbd39n,
  r: -0xcaafee1c077beff20f15a45508823454cd1ef2cb05a58fd1ac7afc03a2de488n
}, {
  a: -0x5c96dff82b63726b7a15904cbe282n,
  b: 0x5021f42d960814b01818cc0dan,
  r: -0x5c968fd63735dc6365657833f21a8n
}, {
  a: -0x2869b7509944dee5c93a47c2f4d1df354fb87b3f33eedd12956db0n,
  b: -0x4429a77cc970c726e01n,
  r: -0x2869b7509944dee5c93a47c2f4d1df354fbcbdd9abbb741f07dbb1n
}, {
  a: -0xf9285ac81ae1f3eed89cf38fn,
  b: -0xc42dcd11a5f685499183c80c9a5be7863en,
  r: -0xc42dcd11a6efada4599eaa0089348479cdn
}, {
  a: 0x37e1743b299b90c7c17d52846e4b4dbac0f50604ec31n,
  b: -0x415fe2bacc5a3af891087fa1b37e9d703072ebd4c50381dc077df091n,
  r: -0x415fe2bacc5a03171ccd560622b6dbf2ddee7d897748c0e701790460n
}, {
  a: -0xaeb64c0aac2a6d5e521cf855191n,
  b: -0x2n,
  r: -0xaeb64c0aac2a6d5e521cf855193n
}, {
  a: -0xfbe8977d4b62119b501267d32dcn,
  b: 0x5661f64bc7b715920eee2n,
  r: -0xfbe89726e96bc5d398fcd5c43fan
}, {
  a: -0xe8a2845bdc2399n,
  b: 0x99n,
  r: -0xe8a2845bdc2300n
}, {
  a: 0x7522fc6b127ecc84153f9n,
  b: -0x14cf3043371bb820095324d7a9656642e974bcn,
  r: -0x14cf3043371bb8200200f510f83d797aa820c3n
}, {
  a: -0x1b4dd4860f6d4fe59e5ba4e71c2a809ce8an,
  b: -0x23cdf5288b143507d70726f1d1a0271568b45979d67b239ec53038f35308f7bc8f58c9n,
  r: -0x23cdf5288b143507d70726f1d1a0271568b60e571edc1a73c38a1eada17aba64992753n
}, {
  a: -0xbf10af90a270bn,
  b: -0x3057d67cf984e446edad369096ee885a5927b7cf0476f8b6849cd646n,
  r: -0x3057d67cf984e446edad369096ee885a5927b7cf0482e9c17da6fd51n
}, {
  a: -0xe0d91a9a4a08b2n,
  b: 0x458d3b9fc82785306fda2n,
  r: 0x458d3b91ba95db8bcf4f0n
}, {
  a: 0n,
  b: 0xff9c54924f41b59f0f4bf569539165b2n,
  r: 0xff9c54924f41b59f0f4bf569539165b2n
}, {
  a: 0x99f7df148998n,
  b: -0xf2c03b7ca5696f2f3e1b4c2e0b1152983eaed4df50b5a2c418dn,
  r: -0xf2c03b7ca5696f2f3e1b4c2e0b1152983eaed4d5b137b17b7f5n
}, {
  a: 0x635f7312a9c4fa9813b3aab6520b3aacd4c68e91130179caf853ee7c2546c4495n,
  b: -0xe1c669da9b3908d6d2c27159bc3b4440bb81b2952773n,
  r: 0x635f7312a9c4fa9813b39c99eb6d90f944392164ebebde07440fe2c40a1d71d22n
}, {
  a: 0x5c18d9d030d7648776ade5d2d6a037f43d9dc9fb10e7c6a01df9a7b6e614e03n,
  b: 0x9580c75718dc0192f59043b64d10c8b891ae73n,
  r: 0x5c18d9d030d7648776ade5d2dff84469af2b8a144040cadb82cab4426f2fc76n
}, {
  a: -0x9ef45ec99f5ac38c9a25c4e766d05484eea91c36a35ceb3fe15841431ac8a0761c76n,
  b: -0xd294a8c0be9c7ac92b84f3226afe82028c8f4790a5ac5a80259n,
  r: -0x9ef45ec99f5ac38ca74f0f7372ba1c3181616b68ca0cd3600a2135bc2523661e1ecfn
}, {
  a: -0x4d2b59d12f0c47dbd9a9271226f40eb1163579ee8db7e28a7b345c7c84n,
  b: 0xe45bfe2a39208952417e1c1df5b3n,
  r: -0x4d2b59d12f0c47dbd9a9271226f40dccba374fb56d2e9048fd183e86d1n
}, {
  a: 0xb3cd5d494afd2n,
  b: 0xc645fda19d041c11c7fe339140ed46n,
  r: 0xc645fda19d041c11d33b0965d59d18n
}, {
  a: -0xf537eca689045bbf5efca5605d9bc651db3c56f933bd229df796339483714a9e4310een,
  b: -0x253eda4862c9c79ef16644a27cc1461a89f1128348c68ef8a88af77719n,
  r: -0xf537eca6890480fe3945082a253ab7b81fded3ba79d7ac8f0a197c5b1269f3293a8807n
}, {
  a: -0x73af84384fde05cc8bcbf93c1995f515261e5b2780e1c9c3e2b5000090n,
  b: -0x9009c334e94b4cb248398f6722cc5c6n,
  r: -0x73af84384fde05cc8bcbf93c199ef5b1596cefdc4c064d5cd9272cc656n
}, {
  a: 0xc72aa398669ea5d3b32b661a9cba57aa5239n,
  b: 0x92955fbbb4ce1ben,
  r: 0xc72aa398669ea5d3b32b6f43f2b612f733f7n
}, {
  a: 0xbedccbdd9f1c8620147943e6f107da0en,
  b: 0x35da466bf157132f72e5ce969a32cd635d03bb1d5d05f35aec5876758441be9n,
  r: 0x35da466bf157132f72e5ce969a32cd6f4ad078f74ece555c33ecb4e494bf5f7n
}, {
  a: -0x9bbc95c5391af5cf55d7eb1ddae34ec40f76fcn,
  b: 0xe8e1c7c2e4986e78e0bdbaf91a1979b0af7d67ece10n,
  r: 0xe8e1be071b3c1ae73160c59b9b679c027a9126f5714n
}, {
  a: 0x26b5814e8220c80c54d1771ad391f2862381514a8e2770c6ea10dbfn,
  b: 0xe4d425f0b4602831aee9be0b32ab346962n,
  r: 0x26b5814e8220c80c54d1856815f0fdcc26046c392a0823f19d57721n
}, {
  a: -0xe8d07ae376fa52n,
  b: -0x16dd19a5bb743f94an,
  r: -0x16eba6ad69abaf39cn
}, {
  a: 0x2b6de10f5410c07b2b764d27818f61ff58e5f9284e5ee60e7a4c12ae9082d5182208cn,
  b: 0x3c2536f2n,
  r: 0x2b6de10f5410c07b2b764d27818f61ff58e5f9284e5ee60e7a4c12ae9082d8da7577en
}, {
  a: 0xb67b3915b6a97c5ef0cd1a6e1fa9df24df4en,
  b: 0xbec2146699d38n,
  r: 0xb67b3915b6a97c5ef0cd1a7a0bcb258e7c86n
}, {
  a: 0xbf78acf13b24d911n,
  b: -0xdn,
  r: 0xbf78acf13b24d904n
}, {
  a: 0xaa46c41625d116496fcf6fc52f4671n,
  b: 0xa0a487cc75787d2f70406c4222c562de43b992ab0f699aeb3f01df323f74742ec35n,
  r: 0xa0a487cc75787d2f70406c4222c562de43b99d4f7baafd485066762f3670c7232a6n
}, {
  a: 0xc18cb0f3a0c1c8896f76580004531n,
  b: -0x6a34d58c194a19fb1063b94294fba0eb17342547803650346169f905c343804159f120n,
  r: -0x6a34d58c194a19fb1063b94294fba0eb17342547741d8525275ddc7d2c4c1ac159abefn
}, {
  a: -0x3e6a50e85ad6411337c6953d041a7d5e154817b8n,
  b: -0xb66d8d3b66a929d63df3155fbf10e257ae88135d8f50f871d06d848a8a8725507f43n,
  r: -0xb66d8d3b66a929d63df3155fbf1120c1ff706e33d064303865aa88a507e53a9896fbn
}, {
  a: 0x55f5aa37aae8d269365ac44fe4daac9258a7daf607cf912264f1d13401an,
  b: 0xe9aa84e35e28bb63d97753c2e833cac25b6dc2959d73bn,
  r: 0x55f5aa37aae8d352e0dfa7ae0d96106bcffb9dde3b9a537dd2b466d1755n
}, {
  a: 0xdc9f0731338e0037a8bc6e26a4dbf2n,
  b: 0xef3917f311ddf27e2d4527e2c0fdd19afdd7a58805ce8185cc585ce675248add89146cn,
  r: 0xef3917f311ddf27e2d4527e2c0fdd19afdd7a588e26d88b6ffe65d1e1de0f9042df05en
}, {
  a: -0x301293414e35ffcdfe8029306d1725ce6666n,
  b: -0x94e8850c54b6ef7b056567a4671589bf8580c33b764b981n,
  r: -0x94e8850c54b9f0a4397a4b0463f571c2188794add331fe7n
}, {
  a: 0x3n,
  b: -0xc972e03a802da908ecd8fn,
  r: -0xc972e03a802da908ecd8cn
}, {
  a: -0xbd31410fn,
  b: 0x42801a97515ce4407901e2ec2dfb9058362edbd441a0a463n,
  r: 0x42801a97515ce4407901e2ec2dfb9058362edbd3846f6354n
}, {
  a: 0x2d51901e4002c26c6d877073c9b6f4e14b86c4ae247fb492d920112n,
  b: 0x21c19c26c4cc7a4144d7e12175b136c88942960307918een,
  r: 0x2d51901e61c45e933253eab50e8ed602c137fb76adc24a95e0b1a00n
}, {
  a: -0xce6bac9f1fa261e396acc46n,
  b: -0xd317da61c9974d15d01d01c145c9cf95abad2ed2749b72568543fn,
  r: -0xd317da61c9974d15d01d01c145c9d0641759cdf216fd55ed32085n
}, {
  a: -0x2492ef64f615c84298e72e2ee322084eabaa966b14ac1fbn,
  b: -0x9dba7e8735c6762bad0cdn,
  r: -0x2492ef64f615c84298e72e2ee3bfc2cd32e05ce140592c8n
}, {
  a: 0xb801a2f21b440b3c7ca990a751003196fc9bb2f259538bd2d9ab95ca7b4447612c3n,
  b: -0x340564n,
  r: 0xb801a2f21b440b3c7ca990a751003196fc9bb2f259538bd2d9ab95ca7b444420d5fn
}, {
  a: 0xe2n,
  b: -0xdd5906673c197609c07033d6a6dbn,
  r: -0xdd5906673c197609c07033d6a5f9n
}, {
  a: -0xbcb077e45b351a8b552a4356ded588b21ab6032e99331a11n,
  b: -0x6ba7n,
  r: -0xbcb077e45b351a8b552a4356ded588b21ab6032e993385b8n
}, {
  a: 0xd32816abafc756dd9108d25978bn,
  b: -0xa1n,
  r: 0xd32816abafc756dd9108d2596ean
}, {
  a: 0xb546777c3fe1b605debd6b338c22ecn,
  b: 0x760df44e72cd22ba7b363758c4n,
  r: 0xb546ed8a343028d30177e669c37bb0n
}, {
  a: -0x957e3a9cb2e6abd9b1ceef5ff584e7aa5b7bb2b35666a5aafad4c5n,
  b: -0x3e7f23f44887b8d4fa4b6930531e4fb5f308678n,
  r: -0x957e3a9cb2e6abdd99c12ea47e0074fa003245b8884ba10a2b5b3dn
}, {
  a: -0x179a159ed4ead835cb58ac9bcn,
  b: 0x3c6a2f7a2a765c08499ed1a6b7ae961827d2cf3ace333169cf9a8ee2f7929an,
  r: 0x3c6a2f7a2a765c08499ed1a6b7ae961827d2cdc12cd9441b2217322d6cc8den
}, {
  a: -0xa2dd78be59bf6be59ab074cfc6a7ce3e1124b30521a11e63a7e1b8130596f786ac71en,
  b: -0xbeed5n,
  r: -0xa2dd78be59bf6be59ab074cfc6a7ce3e1124b30521a11e63a7e1b8130596f7876b5f3n
}, {
  a: 0x4da41151e2a6744dfd4784n,
  b: 0xba411b6886c46a36bedfd45d02e4cba3eb253058e87600ccecca01n,
  r: 0xba411b6886c46a36bedfd45d02e4cba438c941aacb1c751aea1185n
}, {
  a: -0x2630b2efccdd8afebeef80ebb7539eean,
  b: -0xe3d860f59en,
  r: -0x2630b2efccdd8afebeef81cf8fb49488n
}, {
  a: 0x3358f05f1c93bb2n,
  b: 0xe940af6befc005cfb3f897eac6d6e88n,
  r: 0xe940af6befc005cfe7518849e36aa3an
}, {
  a: -0x66c7f23cea7fc6ffn,
  b: 0x3e5554f342250978ca22522f5b607c0aca8d0b82b8e081de647n,
  r: 0x3e5554f342250978ca22522f5b607c0aca869f039511d9e1f48n
}, {
  a: 0x9e5d2b2726b0en,
  b: 0x7a23cde1c7b86a8n,
  r: 0x7ac22b0ceedf1b6n
}, {
  a: 0xb564f001cc5c2ed9da7734945457cd3b358bn,
  b: -0x77be387d4d1a61c2a1a0751240a9e35fdb9a9e33616487efff189e94cf02n,
  r: -0x77be387d4d1a61c2a1a075118b44f35e0f3e6f5986ed535baac0d1599977n
}, {
  a: -0x43126bb8ffc10245304867fb14ef1ed9e450750e1f0074ba93dd463dea34941n,
  b: -0xdb7c4ac3b085968f0a6b918f0ca3c34026650253803db0cb372206ccaf686ecf482fn,
  r: -0xdb7c4ef4d741268b1a8fe4939323748f1852a098878e92bb3e6db00a83cc4d729170n
}, {
  a: -0x4a65de1fa86fc9e2b25f5ed1aec3756d39fc643cdaec2fn,
  b: -0x1406afbd33n,
  r: -0x4a65de1fa86fc9e2b25f5ed1aec3756d39fc78438aa962n
}, {
  a: -0x357a75dadd2b30a1374cef2875638532e18n,
  b: 0x4db3f92b31730740ead439n,
  r: -0x357a75dadd2b2bc5f7ba3c1144ef76859dfn
}, {
  a: 0x37baf9c6a73d5ce36d35b743e12401cac0d6f4895d56aeb3n,
  b: -0x74c6de70fcd0744307259211136a79affdde67de2f20a2880e70a73d22bf40n,
  r: -0x74c6de70fcd0740b4c2bcb69d60d9642c82723fd0b1ed7c7377c1ddfcc108dn
}, {
  a: -0xfan,
  b: 0xce7b19c1435d66a1152fe55ad4430b5e5ffb90794a4422a786n,
  r: 0xce7b19c1435d66a1152fe55ad4430b5e5ffb90794a4422a68cn
}, {
  a: -0xcbn,
  b: -0xb6336c290n,
  r: -0xb6336c35bn
}, {
  a: 0xb82dbe32e0273a42775ffb6585ebec278872b4df1c9ed8b2f04e03cd4ee38n,
  b: 0x9038e60911f4e095037c76442b6c529cedefbffbd73c9en,
  r: 0xb82dbe32e0273a4b7aee5bf6a539f577c03a1921d3640281cf4a038ac2ad6n
}, {
  a: -0x39c1f5cn,
  b: -0xf15a43029aac9967c33d6377d73f5c0c0e2f800358194a5d2a7n,
  r: -0xf15a43029aac9967c33d6377d73f5c0c0e2f80035819841f203n
}, {
  a: 0x2cbee31810cb2n,
  b: 0xfd8003475854f70580b7266eb37ebe3ae8b08f856459n,
  r: 0xfd8003475854f70580b7266eb37ebe3db49ec106710bn
}, {
  a: -0xca45713a5ea7e1c864cbn,
  b: -0x172e7f618fa3d63797bc1n,
  r: -0x23d2d675358e54541e08cn
}, {
  a: 0x93f09a14bc140b74c863c60a8dd3307dn,
  b: 0n,
  r: 0x93f09a14bc140b74c863c60a8dd3307dn
}, {
  a: 0n,
  b: -0x47f9e39e53809726fa62fdc451f03f9e1a0f3d29e1afd276524ebdf7bfaa20e7ab72n,
  r: -0x47f9e39e53809726fa62fdc451f03f9e1a0f3d29e1afd276524ebdf7bfaa20e7ab72n
}, {
  a: 0xd7464250c2n,
  b: -0xecd74dfef7c5b3600e942cac5134903a6d5d7ef1abad1dbc00c5f65a6bd6f5d15bfn,
  r: -0xecd74dfef7c5b3600e942cac5134903a6d5d7ef1abad1dbc00c5f65a5e6291ac4fdn
}, {
  a: 0x8666aac69cdb72aa3165cd4e6b693cf1c5185a5172158c3f3424fn,
  b: 0xf841270aebe2a46fdc3d82n,
  r: 0x8666aac69cdb72aa3165cd4e6b693d01492acb00303fd33cf7fd1n
}, {
  a: -0x98904b9da2c813aae4c79dd70cddc363d92b9d340438a0f79cb3a8f519b34c1b90926en,
  b: 0x18c1375eef75282ab0c02b33d414b3ed3d0bb67069d702d6a3e059b6n,
  r: -0x98904b9da2c8139223903ee797b598b31900695fef84b3ba90fd388b42b07577b038b8n
}, {
  a: 0x19cc66a1db170f1183c51540bbbd13596ae75f4065462e843870n,
  b: 0x8b426f4ed705318214c7c346498ae77eaa59e4d6829cccf4b37056c29f77ec9dcn,
  r: 0x8b426f4ed705331edb31e0f7ba7bffbafbadf09253d263a329645d1702603024cn
}, {
  a: -0xc432d29cfe9a735568a73fa731649a8c52fe35e7b0706475b3ebce55dda0c1a86afbdn,
  b: 0xe3af51d6e5e50aaad8321bf3b708964n,
  r: -0xc432d29cfe9a735568a73fa731649a8c52fe3504011e8d8fcee1237dab84cdf162659n
}, {
  a: 0x263005152b8752c8aa8a3a62bdf17n,
  b: 0xb633875ebb0c56c72b30427d4192f2be6146b097274cf6db571e4cb1n,
  r: 0xb633875ebb0c56c72b30427d419555beb299690c53d79f7efd4a2bc8n
}, {
  a: -0x2ff56b7f9792b070a93b6e12205fadc30c7fe6cdcf8a827ab15an,
  b: -0x93cn,
  r: -0x2ff56b7f9792b070a93b6e12205fadc30c7fe6cdcf8a827aba96n
}, {
  a: -0x2a7c8n,
  b: 0xc824f6ac7733147a4b0fa881a127f9b4490f6b629a2d2c819e5994402eab963bcn,
  r: 0xc824f6ac7733147a4b0fa881a127f9b4490f6b629a2d2c819e5994402eab6bbf4n
}, {
  a: -0x67258bf6e89151c319a098f050e0159d877n,
  b: -0xd9a06793b85b95596946aed0f4f1f2e122fe9eeb4381471d3fa6799749a845e46n,
  r: -0xd9a06793b85b95596946aed0f4f1f348488a95d3d4d30a36e03f69e829bde36bdn
}, {
  a: 0x5a26cc430442e4b55c3f821e3e670ae89580fcf7624f7c845673bfn,
  b: -0xd6562312c52ab8323aa8c97059403e6072d34f9f6f9455fd7a5dd1183n,
  r: -0xd65080a600fa7403ef530578375c57efc449f78fa01e3105b21869dc4n
}, {
  a: 0xa59edcdeee28e2a45d6952d95d443afd86b95f474684bn,
  b: -0xb34097e89cn,
  r: 0xa59edcdeee28e2a45d6952d95d443afd86ae2b3dc7fafn
}, {
  a: -0x2376908b0c97dc6dd69394a76d39n,
  b: 0x660c146e18728132cf72828bb1n,
  r: -0x231084769e7f69eca3c42224e188n
}, {
  a: -0x75220fed513ae5176ec2c340732dfec2eca0a9d77b81baded25a313a4b206665f09n,
  b: -0x345e304e320a68abb3464e3c6a380d14896652cn,
  r: -0x75220fed513ae5176ec2c340732e33211ceedbe1e42d6e2520969b725834efcc435n
}, {
  a: 0x53ecb19d64ac5e433693466f9db1f5b0c88f0b33d9d5515462310dfc6c6e34a0a548e4n,
  b: 0xb80d3dd8243519e2d97c2cd41ef288f90b3710ca9e8cdfbcn,
  r: 0x53ecb19d64ac5e4336934727aaefcdd4fda8ee0d5602257354ba0707a37eff3f3228a0n
}, {
  a: 0xcd4e9ec3aabc39f21364b5227d84d264aben,
  b: 0xa9dc2e3n,
  r: 0xcd4e9ec3aabc39f21364b5227d857c40da1n
}, {
  a: -0xb72fn,
  b: 0x24c07d7aa8d2615ff3d0n,
  r: 0x24c07d7aa8d2615f3ca1n
}, {
  a: 0x902711dce53a4n,
  b: 0xa3ec4d58ef0cf3ce5093a7b99cdf901ff2ac08aab1a5f1da2e51ba5e1ban,
  r: 0xa3ec4d58ef0cf3ce5093a7b99cdf901ff2ac08aab1a5f26a5563974355en
}, {
  a: 0x6687d85014148f6cn,
  b: 0xe396dc142abda887d6edaf5835199342dd0ea7b0n,
  r: 0xe396dc142abda887d6edaf589ba16b92f123371cn
}, {
  a: 0xcb69893a1d02c288dc437f86c85d948723bb6793bn,
  b: 0x86ab79d619da6d315ce56f2678e435b116152e29797076n,
  r: 0x86ab868cb26e0f01890dfceab0dca236ef5da0652fe9b1n
}, {
  a: 0x87c145f12f953e1bc3839n,
  b: -0x71cn,
  r: 0x87c145f12f953e1bc311dn
}, {
  a: 0x14a077c79f8b5e553e224b0e40332089ddec46c9cc59bd787657d0def52n,
  b: -0x84ca0de8f76938e6c8cdc7a300n,
  r: 0x14a077c79f8b5e553e224b0e40332089d59fa5eb3ce329ea09caf464c52n
}, {
  a: -0xa63d676eb7afab0b3a260a0112cn,
  b: 0n,
  r: -0xa63d676eb7afab0b3a260a0112cn
}, {
  a: 0x2cd86100699820dc381ca20e5cb7896a4fb0c9n,
  b: 0xb8ca42a49574b22bcdab136688a697a3ee526en,
  r: 0xe5a2a3a4ff0cd30805c7b574e55e210e3e0337n
}, {
  a: -0x2305109639f63ef604989f9369bcb1838030d497b26b9n,
  b: 0x7b58482e2cd9236e5d3e98n,
  r: -0x2305109639f63ef604989f8bb4382ea0b29e9db1de821n
}, {
  a: 0x7197b206aaa3eb27102fd7b839e835e68acce3a85e6eebffan,
  b: 0x2719472c829235e7c36c11f86cde3ac485ee7340dcb9b3e23a294d3a0d680f7053n,
  r: 0x2719472c829235e7ca858d18d7887976f6f170bc60583740a2d61b74934efe304dn
}, {
  a: -0x85acn,
  b: 0xb8c3b64c973b3b15e81bb37fa6eda62117186b297c087f120a97437d8c621fd7bn,
  r: 0xb8c3b64c973b3b15e81bb37fa6eda62117186b297c087f120a97437d8c62177cfn
}, {
  a: -0x65dafd73958c42c3ea90b5bb0e3eae6f7531316849n,
  b: -0x315ae5fc092228d0acd8f408de828e2d5d72197356b20734891n,
  r: -0x315ae5fc0f7fd8a7e631b8351d2b99890e56045a4e051a4b0dan
}, {
  a: -0xba6e8d18be7670n,
  b: 0x2786b80b5d3ead5d3dc8640a7ebd13431n,
  r: 0x2786b80b5d3ead5d3dbcbd21ad312bdc1n
}, {
  a: -0x82df4n,
  b: -0x2737bef5n,
  r: -0x273fece9n
}, {
  a: -0x41n,
  b: -0xa8adca08c9eb1983bbe0a3d11e1954a9708e2f69053a9efen,
  r: -0xa8adca08c9eb1983bbe0a3d11e1954a9708e2f69053a9f3fn
}, {
  a: -0x3b24ff87a835c735a47n,
  b: -0xf50n,
  r: -0x3b24ff87a835c736997n
}, {
  a: 0x6n,
  b: 0x64408ban,
  r: 0x64408c0n
}, {
  a: -0x927e90425af08e88a3f36e2860b4368ed6f3931d065bf49420bafd2000783fe8n,
  b: -0xba18a4c383n,
  r: -0x927e90425af08e88a3f36e2860b4368ed6f3931d065bf49420bafdda191d036bn
}, {
  a: 0x34bda38d891ba95d0e3484ba9e74b9158e1bbb7aca6dn,
  b: 0x26779f5b432de1783fecec1a0030e31dbd6n,
  r: 0x34bda38d8b832352c26762d2227387d72e1ec9aca643n
}, {
  a: -0x15770cc4e283ef857a31834961c6e5aa3b20ecaa924164c06n,
  b: 0x6d74e604ac41ed494c912abc7c2a73c016b96380b3a1a1a38e5b8177c05253n,
  r: 0x6d74e604ac41ebf1dbc4dc943d321c1cfe84cd644546fdf17f90d853aa064dn
}, {
  a: 0xb5e8aafb951ce7e61fbn,
  b: 0x6d262a8b10d7d1245fn,
  r: 0xbcbb0da4462a64f865an
}, {
  a: -0xe68c88604afef8c2b455d9bced4dcb77e20af812decfebdn,
  b: -0x6c104323816eff7964a90e9c4b88dcd8a35d4782fn,
  r: -0xe68c88cc5b421c4423555321965c67c36ae7d0b63c176ecn
}, {
  a: 0xb586f6bn,
  b: 0x36fe5a9319cbc5ad0cbc2eedc15dcb56c77c3b8b7f2941a0f4c2f30794f8a0b47e18a6n,
  r: 0x36fe5a9319cbc5ad0cbc2eedc15dcb56c77c3b8b7f2941a0f4c2f30794f8a0bfd68811n
}, {
  a: 0xacbc815e22e1n,
  b: -0x5e8118149441b9c33d99167f9c4abb6813615c17ccc11712bb650088d7c242903544n,
  r: -0x5e8118149441b9c33d99167f9c4abb6813615c17ccc11712bb6500882b05c1321263n
}, {
  a: 0n,
  b: -0xeab0be0f274b4c65614f9ee8f640f95eb32742dc7f855efee1aa13574f5dn,
  r: -0xeab0be0f274b4c65614f9ee8f640f95eb32742dc7f855efee1aa13574f5dn
}, {
  a: 0x84b11ae4dd1505f13c531a27n,
  b: 0xf4caf8n,
  r: 0x84b11ae4dd1505f13d47e51fn
}, {
  a: -0x19af978d0bb083f83e968304cf63cf61935f5fdbn,
  b: 0x5742d092656b3261e091120302e34eeb9e282bd842c1cc98n,
  r: 0x5742d0924bbb9ad4d4e08e0ac44ccbe6cec45c76af626cbdn
}, {
  a: -0xd9f2b51e251b3a1192056cc7ef7b967d53593fca8a527191en,
  b: -0xa3en,
  r: -0xd9f2b51e251b3a1192056cc7ef7b967d53593fca8a527235cn
}, {
  a: -0x8f0e83b0640n,
  b: -0xbc3f26d319ffc0dbc4443940ab86428119a56a28e60d0fabebn,
  r: -0xbc3f26d319ffc0dbc4443940ab86428119a56a31d6f54ab22bn
}, {
  a: -0x566f09883f99cc0ad48cfdcf49f12a83e6c183f8d1a0339f3af78105d683a76bn,
  b: -0xe121a22c1e90676c49n,
  r: -0x566f09883f99cc0ad48cfdcf49f12a83e6c183f8d1a034805c99ad2466eb13b4n
}, {
  a: 0xf30bd45550a0cf27e06acn,
  b: 0xf6084821473653ce58n,
  r: 0xf31b34d9d2b5428d1d504n
}, {
  a: -0xf43ba051ec6a513c183c7945919683d07bcc6d2e872e0dd8c0dac2dee5ac3cbcd1e2efn,
  b: -0x2591645c8646n,
  r: -0xf43ba051ec6a513c183c7945919683d07bcc6d2e872e0dd8c0dac2dee5d1ce212e6935n
}, {
  a: -0x8ba7a48da95a89eb84aa790c789fdc2912571968a7364cd89bfb6438efc6128280a0a2n,
  b: 0x1a53ca8b03428eb9298bcd40ba8c7c6f0495d36eca5fc9b074n,
  r: -0x8ba7a48da95a89eb84aa5eb8ae14d8e6839defdcd9f5924c1f8c5fa31c574822b6f02en
}, {
  a: 0x792c0bf3fa8823b5f250f3d9870fabd755a5c680303571f378976fca449c0f454ca12n,
  b: 0x38b091d9898d798b4804d625cn,
  r: 0x792c0bf3fa8823b5f250f3d9870fabd755a5c6803035aaa40a70f957be27574a22c6en
}, {
  a: 0x3n,
  b: 0xcfb40a8e33c3bcf928eb580n,
  r: 0xcfb40a8e33c3bcf928eb583n
}, {
  a: -0xb462b82a3feb6e62168ffdfe796e40824f72cff64f68ef23b7n,
  b: -0x413db3b1f406c7ba181b174670c0508f4029215301ed3fbn,
  r: -0xb466cc057b0aaece92317fafedd54c875866d28864990df7b2n
}, {
  a: -0x6c7485f943528127a6a192bf51c47c4bb22872d522ad33288882n,
  b: 0xb9989a3en,
  r: -0x6c7485f943528127a6a192bf51c47c4bb22872d522ac798fee44n
}, {
  a: -0x1d86ef5eb9n,
  b: -0x59af8b3cb42bacdc9f88438ead284c91fd95f52655a7328e17418ca93a9dc38n,
  r: -0x59af8b3cb42bacdc9f88438ead284c91fd95f52655a7328e17418e81a993af1n
}, {
  a: 0xe271c7c717aa73caf44e0ac5bd47eb6cb7921f7039886ba1dad1f1e9fe1c80n,
  b: 0x1cn,
  r: 0xe271c7c717aa73caf44e0ac5bd47eb6cb7921f7039886ba1dad1f1e9fe1c9cn
}, {
  a: 0x95a76d0f44e186089593878a6ac02ea9efe5n,
  b: -0x3a11c784be640514780232dcn,
  r: 0x95a76d0f44e14bf6ce0ec92665abb6a7bd09n
}, {
  a: 0xbb632n,
  b: 0x6b018df90372e7b164b762f416b0b025fab26n,
  r: 0x6b018df90372e7b164b762f416b0b026b6158n
}, {
  a: 0x397b865270fc1805a560f61b99b8071d56948862535e8b9c5eedd3d75n,
  b: -0xcccc59ab7e99b94499cd2n,
  r: 0x397b865270fc1805a560f61b99b8071d5693bb95f9b30d02a5a93a0a3n
}, {
  a: 0x72ebcae648b620ceea9f9f61eb398afd5942834n,
  b: -0x876acfea3fe060fec517e1b19148c70003c974924a73944579da8an,
  r: -0x876acfea3fe060f7965b334d05e6ba1159cf7e7396dae46fe5b256n
}, {
  a: 0x9805n,
  b: 0x4f093e0n,
  r: 0x4f12be5n
}, {
  a: 0x8bddf0d15458a74be7d9f18n,
  b: 0x4dcfd6386d46e7e61159d9fb670n,
  r: 0x4dd062165e183c3eb8a5c1d5588n
}, {
  a: 0x648164dbe3ff1152d609268d677162ef7da31044889b00n,
  b: 0x469ea3f0008c0bf5n,
  r: 0x648164dbe3ff1152d609268d677163361c47004514a6f5n
}, {
  a: 0x5fe075d66215n,
  b: 0x39e349022451e847n,
  r: 0x39e3a8e29a284a5cn
}, {
  a: 0xc3100eca4786180d48fc81bn,
  b: 0x40e0bb1da215e3a72e51c146861b2be297c917n,
  r: 0x40e0bb1da215e3b35f52adeafe7cacb7279132n
}, {
  a: 0xec3209db0d3cd7185c926f2aaeeb7ffb641dca0038f8a3en,
  b: -0xe69e56f902eca7af3f7b8c79e3e250ad70578edb8022c574c872ff5f40n,
  r: -0xe69e56f902dde48ea1cab8ac725c87867daca023806c8398286f6fd502n
}, {
  a: 0xea823e4c586f620a0e477c22df6b51504780369c09970f1a812n,
  b: 0xcb697ad4e830c80c58422e1a4b42c2f4308b75f8536666e9f1n,
  r: 0xf738d5f9a6f26e8ad3cb9f04841f7d7f8a88edfb8ecd7589203n
}, {
  a: 0xd43c0048a68c46669de39ffd40n,
  b: -0x1973f20f3949870f43e546408f69358b3e3c94a334c0acf77n,
  r: -0x1973f20f3949870f43e546334ba93100d5782e395686ad237n
}, {
  a: 0x5f11fd9a6353f989fd1f7182727b9d952241225fn,
  b: 0x3d274b8a628632dn,
  r: 0x5f11fd9a6353f989fd1f7182764e124dc869858cn
}, {
  a: -0x48574b39fan,
  b: -0x92c7c77bae151aa38eb236c596b371c669af14db2n,
  r: -0x92c7c77bae151aa38eb236c596b371caef23c87acn
}, {
  a: 0x71b584d7b941b10f962a61e13914ed65331671fe9f1e98614f6284b249n,
  b: -0xd54346c41a5eab63650cf116f38e412d3e37b34f15c6c73ea10b4b602fn,
  r: -0x638dc1ec611cfa53cee28f35ba7953c80b21415076a82edd51a8c6ade6n
}, {
  a: 0x2bd82beeb20d4f3928aaa32a992f99dfb0d6e58f20339ad9c3d8n,
  b: -0x54819746a0ec9e7595c2896f3c53f59007011e11d06n,
  r: 0x2bd82beeacc535c4be9bd9433fd37148bd11a6361fc388f8a6d2n
}, {
  a: -0xb30cfcbbaf7n,
  b: -0xb7e492f1029960de4269961210932aa113n,
  r: -0xb7e492f1029960de4269961d4162f65c0an
}, {
  a: 0x7557c00b6254b64a24767b676bf2228665c12e8f132cbb4b04d5939n,
  b: -0x1e5618cf83cd92f49c26a0n,
  r: 0x7557c00b6254b64a24767b676bf2228663dbcd021aefe21bbb13299n
}, {
  a: 0xccf965ee385400c8989fn,
  b: 0x9cf4ca65159536a70n,
  r: 0xcd03353adea55a1c030fn
}, {
  a: 0xf8b10e7db3bad90b5b108709135674ff58769an,
  b: -0x11faa58a8d51161n,
  r: 0xf8b10e7db3bad90b5b108707f3ac1c56836539n
}, {
  a: -0xe00bc4420c655a57c011561a65e87463806a3b9aa2n,
  b: -0x2b11896ffd0c4e66bd3922b2c543c6829cca317814d90bebd26d93ac72d5en,
  r: -0x2b11896ffd0c4e66bd47236f09648cd84246328d767f6a7318a59a502c800n
}, {
  a: 0x833bef2c2de69af42e0f0dea70dd5e2b58cda5863df8396410n,
  b: -0x5412b762040953266563f9c2022038e9544234ae274cbb0c809n,
  r: -0x4bdef86f412ae977228308e35b1263069eb55a55c36d37763f9n
}, {
  a: 0x85054e0e2d7684f4755dd30b15301ef56cb9d40n,
  b: -0xd91e6f13f7647ccb7e1b5be483aan,
  r: 0x85054e0e2d68f30d841e5cc348783d3fae71996n
}, {
  a: 0xb3985n,
  b: 0xcef4ad60c29f5cfa880a6c0432392n,
  r: 0xcef4ad60c29f5cfa880a6c04e5d17n
}, {
  a: -0xfb0c97ea645d1c47d76154aaf91ad44e38c2a797c15579032c27a8ede7n,
  b: -0x654150ca2dn,
  r: -0xfb0c97ea645d1c47d76154aaf91ad44e38c2a797c15579039168f9b814n
}, {
  a: 0xf7096c1d0388b0f4ecd04093093f80b6651fcd4d334d54n,
  b: 0x3216ae93766daa39601b42818bc7ef67aabdd90n,
  r: 0xf7096c2024f39a2c53aae4290af3a8cf219ec3c7df2ae4n
}, {
  a: 0x77222de6n,
  b: -0x63eb6f0ae0b6f19508e160d5cd4eb7707bfaafn,
  r: -0x63eb6f0ae0b6f19508e160d5cd4eb6f959ccc9n
}, {
  a: 0x92an,
  b: -0x9fan,
  r: -0xd0n
}, {
  a: 0x3470e9abdf80f6ca9507d0f0a3031dcen,
  b: -0x1713c964b93845cd49545n,
  r: 0x3470e9abdf7f858dfebc3d6c462e8889n
}, {
  a: -0xc93180841ed7258344f07n,
  b: -0x2807152b294d6b4b37c43cfb12e3797293798d38n,
  r: -0x2807152b294d6b4b37d0d0131b2566e4ebaddc3fn
}, {
  a: -0xc75babd328f9d4953d81e3n,
  b: -0x7d37e384ed148f8443264c23865895ba88e894da3dc22bc736c4281396bb5d4730n,
  r: -0x7d37e384ed148f8443264c23865895ba88e894da3dc2f322e297510d6b509ac913n
}, {
  a: 0xcf14026069897ad6ea28fda152d9ed9acbc5b77adc8n,
  b: 0x55d92ade66d7ecbfae9417fbf5828237478aece6d46n,
  r: 0x124ed2d3ed061679698bd159d485c6fd21350a461b0en
}, {
  a: -0xd509991102fbe2a858e6cf841981c76a192n,
  b: -0x7c73ca0e0922e29adcb5c14ce55a6cd3d8c0e2e6cd677155cf3759376n,
  r: -0x7c73ca0e0922e29adcb5c221eef37dd6d4a38b3fb436f56f50fec3508n
}, {
  a: -0x607cdae2cfe6dcd73n,
  b: 0xd17an,
  r: -0x607cdae2cfe6cfbf9n
}, {
  a: 0x4f7bc57a161c385n,
  b: -0x71a6b9aca606ef4664990f826ca51852a18e519513f7078bn,
  r: -0x71a6b9aca606ef4664990f826ca518529c96953d72954406n
}, {
  a: -0x3fccbdcaa9c25ed3ac2dcf979869c6af735fdcn,
  b: -0x1eabfa15d9db54fe2b81c9c1b16acb4fdec7b377bn,
  r: -0x1eaff6e1b685f12418bc8c9eaae451ec49bee9757n
}, {
  a: 0xc5a1e75a99f1397084d0a675498c8098an,
  b: 0x2fad838bf11n,
  r: 0xc5a1e75a99f1397084d0a6a4f7100c89bn
}, {
  a: 0xc16e203ab5ebf2b412c84cf9bn,
  b: 0xa2e83d2056d47f6436c62284264n,
  r: 0xa3a9ab40918a6b56ead8ead11ffn
}, {
  a: 0x59cdb0n,
  b: 0n,
  r: 0x59cdb0n
}, {
  a: -0xeec720df85b0d3632e7e068eb4a094a0020e209ed3466e87f4974229a68ea04ab3372n,
  b: 0xc3b10a7797f6403032c2f94e07bb01cf8321698c86cabn,
  r: -0xeec720df85b0d3632e7e068df0ef8a286a17e06ea0837539ecdc405a236d36be2c6c7n
}, {
  a: 0x5b622dbdd3f047f518fa66236ec509c43f95b47n,
  b: -0x5f8e13d274f1a7f61de81234fe80d92n,
  r: 0x5b622dbd74623422a408be2d50dcf78f4114db5n
}, {
  a: 0x271f825fn,
  b: 0xadc001550ca0n,
  r: 0xadc028748effn
}, {
  a: -0x26281fbad7f2190cc6edcd2a8af6202e9cn,
  b: 0xee1n,
  r: -0x26281fbad7f2190cc6edcd2a8af6201fbbn
}, {
  a: -0x2aabc27db0c334ac25b5a739fb910fd549884e3a82c1626404410dc2fn,
  b: 0xd7n,
  r: -0x2aabc27db0c334ac25b5a739fb910fd549884e3a82c1626404410db58n
}, {
  a: 0x9e0ecf20e8392fae050f86d24cd6b7d582356791b020cbfn,
  b: 0x1802a32f01b555ba6eba049c19412972e3f3052829870f22cb0f7aan,
  r: 0x1802a32f9fc424db56f3344a1e50b04530c9bcfdabbc76b47b30469n
}, {
  a: 0xbc6c5a322b582d4711ef8100e055fa1e769ff5f83dcdc2061fc374e99771810an,
  b: -0x42b7b97ca5ef3221462bb31cd79112e981a5cb827ac12409a4734en,
  r: 0xbc6c5a322b15758d954991cebf0fce6b59c864e5544c1c3a9d48b3c58dcd0dbcn
}, {
  a: -0x25e5c8f9f216add6601a54280c24645953n,
  b: 0x4a33cb0e1282374898d9cd5828edn,
  r: -0x25e5c8afbe4b9fc3dde30b8f32570c3066n
}, {
  a: 0xb2n,
  b: 0x23e9cd802546bed12n,
  r: 0x23e9cd802546bedc4n
}, {
  a: 0n,
  b: -0xd14771487aad2934f29fd2856bf4b1d463n,
  r: -0xd14771487aad2934f29fd2856bf4b1d463n
}, {
  a: 0x1b6a0beba23b681b1c3b359b0feb84n,
  b: 0xd99a570cc9f55a7ea8af2073d760ae175a86e7a241a6ad69e6c4d63c52a7a36n,
  r: 0xd99a570cc9f55a7ea8af2073d760ae175c3d8860fbca63eb9888899603a65ban
}, {
  a: 0n,
  b: -0x3aee7bb08323eeb8ca1607c31b804e5f5cn,
  r: -0x3aee7bb08323eeb8ca1607c31b804e5f5cn
}, {
  a: 0xf3d27e14354cd9bd3398a7989eb4230ef8507f01927b0120ce5a33007a312baa9ac8dn,
  b: -0xe526eb4aff26a3ab3e599cn,
  r: 0xf3d27e14354cd9bd3398a7989eb4230ef8507f01927b01127beb7e5087c6f0f6b52f1n
}, {
  a: 0x82e047ccd18c3cfa410bd30b44cccc1466f4c28dd657cb8bdeaacn,
  b: 0x930fa5974950aafa9e0816b9dd1f867n,
  r: 0x82e047ccd18c3cfa410bd39e5472635db79fbd2bde6e8568fe313n
}, {
  a: 0x12a44ad8d2ae6n,
  b: -0xa5d2f5efn,
  r: 0x12a4407ba34f7n
}, {
  a: -0x45bd582f7393831839f2f72be959ee58a04en,
  b: 0x4c8685f77ab2n,
  r: -0x45bd582f7393831839f2f72b9cd36861259cn
}, {
  a: 0xcf1e85613930463a30b28n,
  b: 0xefcd7d919145e3416d3ded7017ad556f33b8ca4162754485dd981e424cb157n,
  r: 0xefcd7d919145e3416d3ded7017ad556f33b8ca416f672cdbf12b22a5efbc7fn
}, {
  a: 0x769b7ebc4269a250d331123e560c5d2e9de05cd4bac1b40db325n,
  b: 0x423d4d53n,
  r: 0x769b7ebc4269a250d331123e560c5d2e9de05cd4bac1f64b0078n
}, {
  a: -0x41e282298defc6c72baa3e3f41e9341aa5024ca7c36e465c65bcde8a309890n,
  b: 0xfc841154d3729cd2d5d88f6d8860d6128b1438f14b7abn,
  r: -0x41e282298defc6c71be1fd29f4b20a4d77a4c3b0eae838fb3d0b9afb1be0e5n
}, {
  a: -0xfdf136d64cd32bn,
  b: -0x83f691776eddb03843819adfabb9280ba0f640984n,
  r: -0x83f691776eddb03843819adfabc9071f0e5b0dcafn
}, {
  a: 0x8626b605aa972ad13c3445b9499696c7af4962eea8598645b31629db11e643d391n,
  b: 0x44e0075645e7a0cae13a3ce2aef6e4dfa57e06f9d68f387fbebce4cn,
  r: 0x8626b605aa9b78d1b198a4335644aa6b7d74525cf653de2622b392ce99e22fa1ddn
}, {
  a: -0x5a1fd26dd1e27d2n,
  b: -0x58cbdc44f6f05f4n,
  r: -0xb2ebaeb2c8d2dc6n
}, {
  a: -0xa55258fc00735a7777n,
  b: 0x2b0432ed692e1e05d8666237b0ae52c1n,
  r: 0x2b0432ed692e1d60860d66373d53db4an
}, {
  a: 0x7n,
  b: 0x839daca6ce6a1607777c395dbbde46949bf5245a1ee29b41082d36bf7f0b7dd4n,
  r: 0x839daca6ce6a1607777c395dbbde46949bf5245a1ee29b41082d36bf7f0b7ddbn
}, {
  a: 0x82dddffd4e0c4b7784289b4639f67cbe4b24117f588d5ecbn,
  b: 0x9fn,
  r: 0x82dddffd4e0c4b7784289b4639f67cbe4b24117f588d5f6an
}, {
  a: -0x9c47c7a6c238eda655084c348f82n,
  b: 0xd2fef3959c5d6ba1a3c8a2aee6b95n,
  r: 0xc93a771b3039dcc73e781deb9dc13n
}, {
  a: 0x161bb902fc65afeb5c81294d9cb004392fd0dbc6f5c44ccb938e3c8c3778d897n,
  b: -0xd050a755eacn,
  r: 0x161bb902fc65afeb5c81294d9cb004392fd0dbc6f5c44ccb938e2f872d0379ebn
}, {
  a: -0xf4dde7463074c1e98b5757d60a7a1ff72b322382cbb834f1dcbce6c6dn,
  b: 0xd8d46c1e8f8adc699cf9bac29afabae5e2b2d6e92a60e40n,
  r: -0xf4dde7462f9bed7d6cc7ccf9a0dd263c689728c7e5d5821af39285e2dn
}, {
  a: -0x4bffd1667c3ba402e2d3511c88b83106n,
  b: -0x4bf1f4c0fd3759c96d10f7eddb39a86de30178a614b4735597c4065e7ba37an,
  r: -0x4bf1f4c0fd3759c96d10f7eddb39a8b9e2d2df22505876386b1522e733d480n
}, {
  a: -0xb5800de8956a7470c7b95c273cn,
  b: 0x3e4a10935fe9n,
  r: -0xb5800de8956a74327da8c8c753n
}, {
  a: 0x71n,
  b: -0x8248099533422610d225160d83cd96bc05e00d59262774c9ecen,
  r: -0x8248099533422610d225160d83cd96bc05e00d59262774c9e5dn
}, {
  a: 0xc75e6f16ffb143780249f92cbaeda3b3330fc58ac20692b48n,
  b: -0xec56b4b176571094f9a2273705a6c2d42e911819dd34bfc1d46b333691558ae328f3n,
  r: -0xec56b4b176571094f995b1501436c7bff710f37a4a6910e79938023a38a96a79fdabn
}, {
  a: -0xeecf2677b1daeb2d8a5234cf06a0fcbcf0ben,
  b: 0x4defa8079faaff0cb8e8fa6a71783e598705n,
  r: -0xa0df7e70122fec20d1693a649528be6369b9n
}, {
  a: -0xd91dbece25fb963e236dfce9b1d04ac6f987819n,
  b: 0xfaf6ea6619057ffeab7159444072229769476197fa4fc680n,
  r: 0xfaf6ea660b73a411c9119fe05e3b42c8ce2a5ceb8ab74e67n
}, {
  a: 0xceb43bf535e8906f001dn,
  b: 0xafdad50dea1fc0b8df12dec50cd4f37fb03n,
  r: 0xafdad50dea1fc0c5ca569e186b5dfa6fb20n
}, {
  a: 0xc8ac9a92a074b95c2598ec43f3febf757b783fn,
  b: 0xe01dc1470263b0de660c7993f0de6ff31e4bd5bff91fa8836e5n,
  r: 0xe01dc1470263bd692fb5a39b3c74324cad1014ffe517003af24n
}, {
  a: 0xffe2263744a727cc29ef52a138a727f9436bbc39bb5bf64187ad290n,
  b: 0x8e066a6e5585239c012d59b467de8029464an,
  r: 0xffe2263744a727cc29f83307df8c804b7d2bcf0f56a274298a418dan
}, {
  a: -0xa7169aa74b3321c8e0363ac059d93194f189df82586ff3ab1d39n,
  b: -0xd84e6c01e049dc2415e7c2ec5088fc6538b6306216f0fb6c3n,
  r: -0xa7241f8e0b512666a277993c889e3a24b7dd6ae55e9162bad3fcn
}, {
  a: -0x4a73b30829f3ced58cea9dd5685545a3d45addf8eff6e5468aeddca8256n,
  b: 0xaa37d0ef91ab34de6e03a048a502b16e152461ce117a5267613843ba7ea1c4efb4f0n,
  r: 0xaa37d0ef8d03f9adeb64635b4c340790be9f0d73d434a487d238d56615f2e725329an
}, {
  a: 0x7fe2d93455ac543f4398819c7n,
  b: -0x6b38ad1f992229n,
  r: 0x7fe2d93455a5a0b4719eef79en
}, {
  a: -0xe7cbdcfcd234829d63801d84n,
  b: 0x769db2db881ec9473145202fefac989b1a7d8fbec63754370c99e0a41eac711301n,
  r: 0x769db2db881ec9473145202fefac989b1a7d8fbec54f885a0fc7ac218148f0f57dn
}, {
  a: -0x9111d1de924ddb3n,
  b: -0x99d90fe261efb02b2f52055d892d56bdd2de78850d8a37d3e32n,
  r: -0x99d90fe261efb02b2f52055d892d56bdd2df0996df68ca21be5n
}, {
  a: 0x6de7effec19cbade41e124040e5c46e8836239cd643c902n,
  b: -0x35d7db6n,
  r: 0x6de7effec19cbade41e124040e5c46e8836239cd2e64b4cn
}, {
  a: 0xfd7667b1ab58e4dc9338296432e632e248e6fd3394b1fb8afffbd46e5n,
  b: 0xa202138095bf0d696d033952be678c469e9659392d1fc29c6b32fn,
  r: 0xfd7709b3bed97a9ba0a196676c38f149d52d9bc9edeb28aac2983fa14n
}, {
  a: 0x3cb84ec58e73d1c15ebbdf2c441ed97c3720bd6ed80d68a786c6504d07a1f129n,
  b: -0x95422bc34dedcbc539d64fcf4908d791d04c7bb6ffe1662d66a0b78c1beef0n,
  r: 0x3c230c99cb25e3f5998208dc74d5d0a4a55070f3210d8741595faf957b860239n
}, {
  a: -0xfd13n,
  b: 0xadf7b3c94bn,
  r: 0xadf7b2cc38n
}, {
  a: -0x2affaff57d2f78faf2a7en,
  b: 0xeb126e27b24dcb9551ba4625a60ffdbec941caddfeae98d63n,
  r: 0xeb126e27b24dcb9551ba4625a60fd2bf194c4dae85b3a62e5n
}, {
  a: 0x972d363f82346f197dbe6e7n,
  b: -0xc5dde57695760c188631eb3b94738af012ff5b8348a951f02a03934f8da644n,
  r: -0xc5dde57695760c188631eb3b94738af012ff5b79d5d5edf806bca1b7b1bf5dn
}, {
  a: -0x60803ab9a7edae0c7759ad973944573e886acf5afde7aa4386n,
  b: 0xf48fea012b94c07cef2de5e3f06d2b57n,
  r: -0x60803ab9a7edae0c76651dad3818c27e0b7ba17519f73d182fn
}, {
  a: 0x67ba916d1cbe68da42a9905cde71bf99b5a843140010818adf701d3ef36dae7e2d3b9n,
  b: -0x908329a8ab7c0f250859daan,
  r: 0x67ba916d1cbe68da42a9905cde71bf99b5a84314001080fa5c467493775e8975d360fn
}, {
  a: -0x79669e2aedd8cb12723b9d20b8d1e1b78ebn,
  b: -0xebe8471cab5eb2d2bd4135fb197c1921411bf31884n,
  r: -0xebe8472441c895819acde7223d35eb2cce3a0e916fn
}, {
  a: -0x922f1d6379a98308571bb0bf23c8c7ccfa7f06c8eca0d08n,
  b: 0xfc83b2b96bc3bd0960390db0ecn,
  r: -0x922f1d6379a98308571ba0f6e89d3110beae70c55bc5c1cn
}, {
  a: -0x3b8f49175e65f93dd3bb428b8n,
  b: 0xaf84d373cfe95n,
  r: -0x3b8f49175e6549b9004772a23n
}, {
  a: 0xf4c34b58e691be7a3452a6b07159a9e6866c1d5229aa6n,
  b: -0xe9bc3597fefc2afff1a4b9978882bcb5dbf7fb4212e3f5c2fe3n,
  r: -0xe9bc34a33bb0d2195fe63f6335dc0c44824e14bba6c6a39953dn
}, {
  a: 0xf2799ad38a12af4a85488aba44808b803ead60f5643ae39bf09969bf56c2ded7an,
  b: -0x16a14036fa6b8afc98d1870cc63b6890924325452ad014820eef7f29e2b499bf51an,
  r: -0x15aec69c26e1784d4e4c3e820bf6e805120477e4356bd99e72fee5c0235dd6e07a0n
}, {
  a: -0x23932df5a426fe73a5fd79985673a350cn,
  b: 0xc244bcf965a60800116b7a456af764f4128dfeed38cbn,
  r: 0xc244bcf965a3cecd321137d583bd051c790897b303bfn
}, {
  a: 0x796a2fa039126ffc91f772b64d926cca77c0d052d2e673e6be2e025bn,
  b: -0x8f8d03449320035a4dd363b59cd4n,
  r: 0x796a2fa039126ffc91f772b64d91dd3d747c3d32cf8c26135a786587n
}, {
  a: -0x4991012eb903adebb4cb79de6f7d9en,
  b: 0xbd9af576a09f00f1a37e11d2ec9c3ae453e536ffed00eeeaadf59e7dac8cfbf055n,
  r: 0xbd9af576a09f00f1a37e11d2ec9c3ae453e4ed6eebd235e70009e9b232ae8c72b7n
}, {
  a: -0x3911ff69ed6c28ba4e772f5ccb4f39acc325c4604bf4349dcbcea226f48fbeef03bn,
  b: -0x18e7b9f2dc9fdbdb06ba4acd74a3b484a74c3d46c78n,
  r: -0x3911ff69ed6c28ba4e772f5ce436f39f9fc5a03b52ae7f6b407256ab9bdbfc35cb3n
}, {
  a: 0xf4833b2acb2195d128f554de4bbb1b09e7baf953661cc2cn,
  b: -0xdc28e2745dde3bf0e1ec3e450af9072eb93a9b87c5f7n,
  r: 0xf475789ca3dbb7ed69e7361a676a6b7974cf65a9ada0635n
}, {
  a: 0xabc628b2b9bcbacd7b34930baea78e4865567294464b8d223e27544e7n,
  b: -0xb3f2b4eabe4b1a631dc33167505107n,
  r: 0xabc628b2b9bcbacd7b34930bae9c4f1d16aa8de2a019b0ef27b24f3e0n
}, {
  a: -0x55de431d673a4966850dda2cc4c1a381d3bc849ef661bfd1db6ae3en,
  b: -0x1d898aca6e381f9af8679e1bd74600bb96a1e44f9c5af9f1en,
  r: -0x55de433af0c513d4bd2d75252c5fbf5919bd403598460f6e3664d5cn
}, {
  a: -0xcf7476ebc03de1144d970e5c7c439cefdfc7bbab7285f2f6c977f0cf425n,
  b: -0x9de479fed48a621a94ffan,
  r: -0xcf7476ebc03de1144d970e5c7c439cefdfc7bc4956fff1cb53da0b6441fn
}, {
  a: -0x2297cc2a37n,
  b: 0xe53408b2b9f539450f154b1aaab8f3384bdbn,
  r: 0xe53408b2b9f539450f154b1aaa965b6c21a4n
}, {
  a: 0x5a95c7cf9824ea2a48826451f0db77n,
  b: 0x8827cd745a36044d78a564344b3892a4ecc9e25c4e33n,
  r: 0x8827cd745a3604a80e6d33cc7022bced6f2e344d29aan
}, {
  a: 0x6fb96424f6b1c7ecbaf0460d4cn,
  b: -0x3f2dacdn,
  r: 0x6fb96424f6b1c7ecbaec53327fn
}, {
  a: 0x3e0dcn,
  b: -0x925337b6bfa6c2b40a64b31ad00ec9b3776f4f3n,
  r: -0x925337b6bfa6c2b40a64b31ad00ec9b37731417n
}, {
  a: -0x9e706b0d051d7cd64191fb51a87310357af2ee385522n,
  b: 0xe0180b4a8a07fd410a818472868734d45f3376eba3db87d195ab21ce8ba33b120e80cn,
  r: 0xe0180b4a8a07fd410a8184727ca02e238ee19f1e3fc2681c7b23f0cb33f40c2e892ean
}, {
  a: 0xee266d97d5e224a50b22b72dd78ca41f81ec8c0ae7698de32eb40d26115n,
  b: 0xa03a39bbe0f571526cd86e12fcfd633n,
  r: 0xee266d97d5e224a50b22b72dd78d4459bba86d0058bbfabb9cc70a23748n
}, {
  a: 0x611be954a5b0872e5d9d8f2ba832c4f727b8e67dfba4ff29f0adc28bn,
  b: -0x54d9f0f7d7b8070502991155cf51eb9c6n,
  r: 0x611be954a5b0872e5d9d8f265a93b579ac38762dd213e9ccfb8f08c5n
}, {
  a: -0x3c42c10f762957c85654bbfn,
  b: 0x47a4dc012dc96745a69n,
  r: -0x3c42796a9a2829feef0f156n
}, {
  a: -0x4d7cabbcb35f14badd93e29f7244e1dn,
  b: -0x5d5567a04f2eca26e64cc799n,
  r: -0x4d7cabc288b58ebfd080850dd7115b6n
}, {
  a: 0x1ba5ba35f88d376127aa5da2a5a98503ab8790bdbd55bn,
  b: -0xe7a9bcad6fe7b6fd3bb33d59cn,
  r: 0x1ba5ba35f88d376127a975f8e8fc151bf48a550a7ffbfn
}, {
  a: -0x4399b66631553b323399560e1dd039ea20f08359ceb8d0n,
  b: -0x44d9f4638901b33b3855976f06aa2e6f218b494c78138522cadfn,
  r: -0x44d9f4a722b8196c8d90c9a2a0003c8cf1c5336d6896def183afn
}, {
  a: 0n,
  b: -0x40294b2caaf10df3e2f19401172bdn,
  r: -0x40294b2caaf10df3e2f19401172bdn
}, {
  a: -0xed5910280cba9272281b00b860973cc8992db76351a3f35d0592an,
  b: 0x5868a5d161dd26a9df2003456831d852581c995c7812970883633d4fn,
  r: 0x5859d0405f5c5b00b7fd81955cabcede8b93068101dd7cc94d92e425n
}, {
  a: -0xe7042ccdc9df8fd72c8ba4c3818n,
  b: -0xf3fb8dfb7fe9bcf2ec850142bn,
  r: -0xe7f8285bc55f79941f7829c4c43n
}, {
  a: 0x17f967d3d7dc15495e5cad7e3f18853bcfd415a863968e07n,
  b: 0xe9c92fa94e274f34e87288dn,
  r: 0x17f967d3d7dc15495e5cad7e4db5183664b68a9bb21db694n
}, {
  a: 0xf843f39cd94c2648e8d4982c315aa0d91ecbef82e9ee253d8a5cfdf9b35efn,
  b: 0x90178f7cc6514a4a35c5dbac5e1259eee6ec84fc27ef4d7d779e87499242en,
  r: 0x1885b83199f9d70931e9a73d88f6cfac805b8747f11dd72bb01fb854345a1dn
}, {
  a: -0xa31b7581a502b9f4f14977afb2511aa3a4f2a5073da75730473193c57cn,
  b: 0xe9bc884816c7bd5daf422de6141207e7c8b06d5ff17036c89ffn,
  r: -0xa31b7573093a357384cda1d4be2e3c4263d2268ab2a08131302e273b7dn
}, {
  a: 0x3a483n,
  b: -0xf43b24b1ab9f4dcd74d7d6e587f231d45ddab61f4c3b81f59f9fef61n,
  r: -0xf43b24b1ab9f4dcd74d7d6e587f231d45ddab61f4c3b81f59f9c4aden
}, {
  a: -0x11d5n,
  b: -0xafdn,
  r: -0x1cd2n
}, {
  a: 0x73dca6afedfe4d118d804c3755c13e69bn,
  b: -0xa466b874c3bf73590bded9a629648bc814434274279ac2c71def41n,
  r: -0xa466b874c3bf73590bded2685ef98ce82f72299c22d74d6b0a08a6n
}, {
  a: -0x842cfa2623d20bf7b7b2aaadcb70be7d4dd7c1eb1e0039bbc0212115337c49n,
  b: -0x9c6n,
  r: -0x842cfa2623d20bf7b7b2aaadcb70be7d4dd7c1eb1e0039bbc021211533860fn
}, {
  a: -0xaa2a7a73aa4d55de4acd369a67ee17c2bf5b1e7ae170a60a43n,
  b: -0x5b0f7729cacee1ae958b1e84ded5bced67n,
  r: -0xaa2a7a73aa4d55dea5dcadc432bcf97154e63cffc04662f7aan
}, {
  a: 0x37e24f7893ae533ce4505dan,
  b: -0x958d9bae897ddd1a2f5c5aae781300ebfbd32c5571bd34e8bad10cc5b4caban,
  r: -0x958d9bae897ddd1a2f5c5aae781300ebfbd32c51f3983d5f7febd8f76fc4e0n
}, {
  a: -0xa491fddcf8510834n,
  b: -0xa7664701aa4823c6985fe86eefd1f9d616c7b478d0455b3f73dn,
  r: -0xa7664701aa4823c6985fe86eefd1f9d616d1fd98ae14e04ff71n
}, {
  a: 0xaaf565b1b49cee0n,
  b: -0x78485cdcab65a5e75836f8ca618da9a1cc83244n,
  r: -0x78485cdcab65a5e75836f8c9b69843f017e6364n
}, {
  a: 0x65498ba3b18d87f4c32d36cc52df453c7f069daa56ea665a3c21f1f5831bdbc1n,
  b: -0xce80ee69f3ca8cc9en,
  r: 0x65498ba3b18d87f4c32d36cc52df453c7f069daa56ea664d54130b5646730f23n
}, {
  a: -0xfn,
  b: 0xf49ec4e812b2cf9ea4an,
  r: 0xf49ec4e812b2cf9ea3bn
}, {
  a: 0xf2c7276c955e0e24c44f1cad5a90e2e11f18n,
  b: -0x4e1b98d7f70b26224n,
  r: 0xf2c7276c955e0e24c44a3af3cd11722ebcf4n
}, {
  a: 0x8fa5ba409788bn,
  b: 0xa6d5965ecaa7eb8118b2f5864e76bc7ccb511d10n,
  r: 0xa6d5965ecaa7eb8118b2f5864e7fb6d86f5a959bn
}, {
  a: -0x1505c0e6465571ac9e11192d45fba2c849e86ee2ae08fc5817f5e4b7188dbc7a70n,
  b: 0xdaf1e365f2daedcfed5698166b1b4aef995f653en,
  r: -0x1505c0e6465571ac9e11192d4520b0e4e3f593f4de1ba5c0018ac96c28f45d1532n
}, {
  a: 0x8cb84f48e825056119a67220d72c48de707f157e2ccd13d32e6b941bce1cf8n,
  b: 0xfd66652f959e9217e15598f451322fef151e6e62a19bn,
  r: 0x8cb84f48e82505611aa3d88606c1e77088606b17211e46031d80b28a30be93n
}, {
  a: -0xe4e02f0cd594195f54977d142fcca4a71932f609b5bfdbb834a0n,
  b: -0x6ffb0ca90f0fe64f44489a465d7n,
  r: -0xe4e02f0cd594195f54977d1436cc5571aa23f46eaa04655c9a77n
}, {
  a: 0xdbfb0c97d3be6c77d986d14316n,
  b: -0xf7917f5bdcaa4805ab1f1cd1c13f5b2ad6a59275e0620f0be4a7ffec468c9en,
  r: -0xf7917f5bdcaa4805ab1f1cd1c13f5b2ad6a4b67ad3ca3b4d78302665754988n
}, {
  a: -0x34a37c2e36ec46511a241246cf776b0f150a3fb46806bc152274152952b08e0ad8n,
  b: -0xdb52d2fbcd1n,
  r: -0x34a37c2e36ec46511a241246cf776b0f150a3fb46806bc152274153707ddbdc7a9n
}, {
  a: 0xc078edee73ccb27085241dc982ca9d6fee1c59e9d4b90049bca83e52cff8056bn,
  b: -0x1e79a649fcf7f7ec324230e07e090fed864d455434588458a1f8497aad37df2n,
  r: 0xbe915389d3fd32f1c1fffabb7aea0c7115b78594917378043288b9bb25248779n
}, {
  a: -0xa1bb0f85d1adf48fd2974f509175413ea7b8c0efbf991c6n,
  b: -0x781cc07n,
  r: -0xa1bb0f85d1adf48fd2974f509175413ea7b8c0f037b5dcdn
}, {
  a: -0x7114c1c932a2aa1b1n,
  b: -0x4b0e8b919dfc97b20ab6a212159969a77177c09a0082791021104e878n,
  r: -0x4b0e8b919dfc97b20ab6a212159969a77177c09a71973ad953b2f8a29n
}, {
  a: -0x34690888557298984517a13a30cea5d252a824b94614efcaf3fe36n,
  b: -0x6ed59f350e7fb6d87f82e95f45cddad9f6dce48d87a420b010020838f1bb7en,
  r: -0x6ed59f3542e8bf60d4f581f78ae57c1427ab8a5fda4c45695616f803e5b9b4n
}, {
  a: -0xd1b2fd35daean,
  b: -0xc729e208ebd4e2fb67d97n,
  r: -0xc729e208f8f012cec5881n
}, {
  a: 0x8c63acn,
  b: -0xa52d434a65d9e7d9dad90n,
  r: -0xa52d434a65d9e7d1149e4n
}, {
  a: 0x30bn,
  b: 0x4bc72866b34d7d6003297e1a0301n,
  r: 0x4bc72866b34d7d6003297e1a060cn
}, {
  a: 0x14e17729e76509c008f70dc4d15065fb8d32c7f66d10adc69e294c9n,
  b: -0x2bc0402cdeb553d2bed73303e392df88b0426d94a7a495f32n,
  r: 0x14e176fe2724dce153a33b05fa1d6217fa533f462aa3191ef993597n
}, {
  a: 0xbdfad3aa4983404a277e95b788ddb0830e1n,
  b: -0xfn,
  r: 0xbdfad3aa4983404a277e95b788ddb0830d2n
}, {
  a: -0xe39e3237f6cn,
  b: -0x4db78d5dad57f7d028a3ee0efbd5811c93de4c6n,
  r: -0x4db78d5dad57f7d028a3ee0efbd664bac616432n
}, {
  a: 0xee190f97d60e80062be763bda5d58n,
  b: 0x6a8d1550n,
  r: 0xee190f97d60e80062be76a66772a8n
}, {
  a: 0x5889ed6267b2f30de7ac9fa0ad2bde706d51fd94ce2839ff89n,
  b: 0xfab46e0637726339ff5d9005n,
  r: 0x5889ed6267b2f30de7ac9fa0ae2692de73896ff80827978f8en
}, {
  a: -0x4ccn,
  b: 0xa4158d6f4d3bdbfn,
  r: 0xa4158d6f4d3b8f3n
}, {
  a: 0x6ff27028324bce0bdf3963008601cc618031c2aa1f90dac263f6c519dn,
  b: 0xfb5cb099f8ca69810590ca6cde35d597853n,
  r: 0x6ff27028324bce0bdf3963fbe2b2665a4a9b43afb05b47a099cc5c9f0n
}, {
  a: -0x9da31b8a011558b6f7399205442cn,
  b: 0x1e31010498ec96a65d0564a0670e801a3e9b84n,
  r: 0x1e310104984ef38ad3044f47b0174688395758n
}, {
  a: 0xde2830fd51193d3097ef402118b8fe018d6c4bb82e8122e1a4398c2fb6ae140dn,
  b: -0x9767ff06e6a6c88082ec7a3af266b3df1d0d04n,
  r: 0xde2830fd51193d3097ef4021182196028685a4efadfe36676947257bd7910709n
}, {
  a: 0x4997c31827c331e0a081db6e59bf2ee7f58e5d4a0bbb716d1d74ea7b3dc6d483a15cn,
  b: 0x2b150e47d8c0984d9n,
  r: 0x4997c31827c331e0a081db6e59bf2ee7f58e5d4a0bbb716d1d779bcc2244608d2635n
}, {
  a: 0x5d0b370cf3e7334e3c634fb7eb452edae1ec473de1n,
  b: 0x21af1b56c474e2f088a028e7a0e0b6e065d66n,
  r: 0x5d0b3927e59c9f958a925841edd3a8e8ed5a4d9b47n
}, {
  a: 0xa6db7ecc1434cfb5ab49a858373acc0d205af9e5d1n,
  b: 0xfd2cda4ebb7a0822f2b4d20ddbdab95392n,
  r: 0xa6db7ecd1161aa0466c3b07b29ef9e1afc35b33963n
}, {
  a: 0x63637339n,
  b: 0x898220de53933dd0109961aea7c44792bb8553cn,
  r: 0x898220de53933dd0109961aea7c44798f1bc875n
}, {
  a: 0x1d1dd68e961677b11b5f76fbdc728932e2dbc463f76e030683373838ca518c11fn,
  b: 0xffa46df60f8733addfc2ed68dad245a3564n,
  r: 0x1d1dd68e961677b11b5f76fbdc728a328749ba737ea1b0e64624a1139c972f683n
}, {
  a: -0xb3en,
  b: 0x49f64f524ea54d0e9d136fd3n,
  r: 0x49f64f524ea54d0e9d136495n
}, {
  a: 0xdfbf82f8ebe9cff87444fd9388942399e640a4cd06fa7c9f6ccaf6e9en,
  b: -0x42aae39a6466e8902dd19930ef5bce01eeb37e992f49db288edc7566n,
  r: 0xdb94d4bf45a3616f7167e400799e66b9c7556ce37405deece3dd2f938n
}, {
  a: 0xaeae9c0f5189b5e3b17c50bc5ae6n,
  b: -0xb32e6893c129795c86b4e13779cc1b9f3a4526c290c2387an,
  r: -0xb32e6893c129795c86b43288ddbcca15846175464005dd94n
}, {
  a: -0x3a0d366e8a901eef8f3e2362edd65543a466f366974fe869c38fbn,
  b: -0x80d02228f0976a675aea61e0ed9b4e597af88b68db5fa03d6n,
  r: -0x3a0db73eacb90f86f9a57e4d4fb742def2c06e5f22b8c3c963cd1n
}, {
  a: -0x7534513f533669bb77c0ecd83b2e414f343b0f8e6faa51c5n,
  b: 0x48b45n,
  r: -0x7534513f533669bb77c0ecd83b2e414f343b0f8e6fa5c680n
}, {
  a: 0x55dc345f2cebe3c66dcd9bf6b89b3bdcc3eacbe933679bfeecf80edb2c195547a164n,
  b: -0xdf3d7d8c1994363ea73b7b5a2bb9cbcaeeba0a635501678d734d0573d0fa9f2n,
  r: 0x55dc266b5513222d2a69b18300e59921272e1cfd92c166aed67f37a65bc21837f772n
}, {
  a: -0x4376a923c61f7e0a84036186da85ccaf786636826cbc9n,
  b: -0x54a536d14db73984ad3dfc3477eb9e1da5b2990daan,
  r: -0x437bf3773334597e1c4e35669dcd4b695a4091abfd973n
}, {
  a: -0x8a4bcd8f1da948n,
  b: 0x2a8f407bbe66a394270f3476618685n,
  r: 0x2a8f407bbe66a3939cc366e743dd3dn
}, {
  a: -0x7d21c15e48bn,
  b: -0x76abb375880e38b828bdfc5ec77b94f8362b12dee48c963b0n,
  r: -0x76abb375880e38b828bdfc5ec77b94f8362b135c064df483bn
}, {
  a: 0xddf217895542cde302c491dec54c34670405c37ceb9f3e9en,
  b: 0xef0292bfd6d4b5a9670a3a5b551bn,
  r: 0xddf217895542cde302c580e1580c0b3bb9af2a8725fa93b9n
}, {
  a: -0x8809b6e639539ab9dc4e9110de89n,
  b: -0xce29c31776a5664fe0a160fe8fbec3b1891f2a718e4eced20205745a10a2b8b577n,
  r: -0xce29c31776a5664fe0a160fe8fbec3b1891f2af99805b50b55a02e365f33c99400n
}, {
  a: -0x68ca20a374n,
  b: -0xb559ee455ba32b2f3b73ec47c50cc3e4c30744ae1428351e6e869n,
  r: -0xb559ee455ba32b2f3b73ec47c50cc3e4c30744ae142ec1c078bddn
}, {
  a: 0xe4cc4b9db71feff343b674e11002c51b01e0e7a154057c4b60ca8d6d6a2d97afa3ac5n,
  b: 0xd7b92430e489a20b8n,
  r: 0xe4cc4b9db71feff343b674e11002c51b01e0e7a154057c4b60cb65268e5e7c3945b7dn
}, {
  a: -0xdceda937728b75464752c0b711b29f0e4n,
  b: 0x53f9d5756c52400n,
  r: -0xdceda937728b754646fec6e19c464cce4n
}, {
  a: 0x5d91605c528ae40e91885704cd993c27479dn,
  b: -0xadc9d24679407f4ea84eb6871c413d02dd3a53ded38d826dn,
  r: -0xadc9d246794021bd47f263fc3832ab7a8635864597663ad0n
}, {
  a: 0x48111b0900cbe2a1a10edcd10ccc1eb9591818a5ba31d2ff32ccad518cf7807b9n,
  b: -0xd3979032b487ac0043802a90207cb9a80a44f5893baan,
  r: 0x48111b0900cbe2a1a10ecf9793c8f370de58146db788d0f767322cad3d9eecc0fn
}, {
  a: -0xf1fd499cdb0b4deb461e68348159865e8864ebd795fbb8a10cn,
  b: 0n,
  r: -0xf1fd499cdb0b4deb461e68348159865e8864ebd795fbb8a10cn
}, {
  a: -0x313cb06f9a5e7bed7eb98dcd5da3601efc398e790c22571dec636n,
  b: -0x328d077aa12e4434a1498d314c18e05344b932n,
  r: -0x313cb06f9a5e7bf0a78a05777087a36910d2618dcdb05c5237f68n
}, {
  a: -0x8cb91d5b2fd274064ee19n,
  b: 0xa8d8f459an,
  r: -0x8cb91d5b2fd1cb2d5a87fn
}, {
  a: -0x442ae8579501b7fd4561bedd75dc020b342fbad711c34227a58n,
  b: 0x762bf1056b74c23b5b480ab1bdc9b9d0a750e45a629d73ecn,
  r: -0x4423859884ab00b121ac0a5ccac0256f972545c8cc1d185066cn
}, {
  a: 0x542b0d8032b60bda10b803n,
  b: 0xbb890f86b29359f4c036a70291ca6b225c9b8a3e7dd288ac9de2n,
  r: 0xbb890f86b29359f4c036a70291ca6b7687a90a7133de62bd55e5n
}, {
  a: -0xbd0bf1c8aa64bf5a4n,
  b: -0x8427a769f4n,
  r: -0xbd0bf1d0ecdf35f98n
}, {
  a: -0xc9b0be0fcfaae1dd64cd1685331d66cf3b38ab8bd7eb3f4121e00c83875a32b32635n,
  b: 0xecb3f16118e060fabb8b2447n,
  r: -0xc9b0be0fcfaae1dd64cd1685331d66cf3b38ab8bd7ea528d307ef3a3265f772801een
}, {
  a: -0x7ae1e84e552aa5571f36ddc3283cba8b97n,
  b: 0x6acc66ed3c4fcn,
  r: -0x7ae1e84e552aa5571f36d71661cde6c69bn
}, {
  a: 0xd1ef7edd42b245dfbc43c6cfae6a4efedn,
  b: -0x843be4bn,
  r: 0xd1ef7edd42b245dfbc43c6cfade6131a2n
}, {
  a: 0x120443c504fdc5c5bdf08742b79b95ae492e06fbde2a91n,
  b: 0n,
  r: 0x120443c504fdc5c5bdf08742b79b95ae492e06fbde2a91n
}, {
  a: 0x215ccad1d08f16151da2d097d731e38db0b7f0d15d77a281bn,
  b: -0xbf740f707887caaadf9cdb9a2fb6e2be1012b469an,
  r: 0x215ccad1111b06a4a51b05ecf79507f381010e134d64ee181n
}, {
  a: -0x81fc5df799042bn,
  b: 0xf3481n,
  r: -0x81fc5df789cfaan
}, {
  a: -0x7d2d2cd1c14232e38a7b3b0166f572089a256c4ae26d84n,
  b: 0x35bd4a183810e04f80a4c95n,
  r: -0x7d2d2cd1c14232e38a7b3afe0b20d08519176752d820efn
}, {
  a: 0x2bbd85e804a0c69c41ba305f1cfe148295d2acd4d22d6438e7n,
  b: 0x8249567e8fd19c18ad283d9778df31797ef75bba388de39n,
  r: 0x2bc5aa7d6c89c3b6034502e2f675a275ad6a9c4a8dd0ed1720n
}, {
  a: 0x40d5n,
  b: -0xd27aa267a3d0879en,
  r: -0xd27aa267a3d046c9n
}, {
  a: 0x76720bbab15f920cfd5f37beafb4c7ce13dde2047ac678e9bbd0ea500b82ac0f0bn,
  b: 0xb483cbc2d0a6da05a7412b43db3b30ebfa4b33bd83dn,
  r: 0x76720bbab15f920cfd5f37c9f7f183fb1e4b825eeed92d276f83f90fb035e7e748n
}, {
  a: 0xaan,
  b: -0x139d06528ffc0d2467108e6bfc70fca1193e47420a9n,
  r: -0x139d06528ffc0d2467108e6bfc70fca1193e4741fffn
}, {
  a: 0xf4843ed5884b6f078917bffe22cb9a8454f996dn,
  b: 0x95a820d9ffbade3b7dee461f14adn,
  r: 0xf4843ed58854c98996b7bbac06837968b6eae1an
}, {
  a: 0x12e4adbee43d3e8cf9faaa63f0f713587046f428cd0d34n,
  b: 0x8b4d3c80223ec14e14a28n,
  r: 0x12e4adbee43d3e8cf9faaa63f9abe720726ae03dae575cn
}, {
  a: 0x67c50d9ac3314998aace1d39f8b73d24a953188d5123a35cf99a02daa4n,
  b: 0x436d2d316c8d77bb2e23b22535b78e665011af09df1b78e7en,
  r: 0x67c50d9ac7681c6bc196f4b5ab997846fcae9173b624be4d978bba6922n
}, {
  a: -0x2a997dd2f352501f862d9dcc8c3ae8ca3b12489c886d3f5n,
  b: 0x480821n,
  r: -0x2a997dd2f352501f862d9dcc8c3ae8ca3b12489c83ecbd4n
}, {
  a: -0xa7a2d4feen,
  b: -0x4641f3294c3b6e08cc99308443bdff1c65b9326dcn,
  r: -0x4641f3294c3b6e08cc99308443bdff1d0d5c076can
}, {
  a: -0x225ed299931b9f28n,
  b: -0x48691ad3n,
  r: -0x225ed299db84b9fbn
}, {
  a: -0x710ee6bd869f7025286b15e4f5a60b2e82691c6070ba6848d46f03fn,
  b: -0x6ceebe8953a25c58c5514c2e7dfab59e57c16n,
  r: -0x710ee6bd869f702528d804a37ef9ad8adb2e6dac9f3862fe72c6c55n
}, {
  a: 0x5b536390c2ea9ddf7aaf417e19fn,
  b: -0x13421dd2071ea7189fef9b20579a63c368fcee817eeb83faf53bf6n,
  r: -0x13421dd2071ea7189fef9b205794ae8d2ff0bfd7a0f3d906dd5a57n
}, {
  a: 0xf448ea93efbecf3abd1c982e81d2ee1c7744252badc4a397d55c66ed3n,
  b: 0xc563a1a9bdf6b3d91d3n,
  r: 0xf448ea93efbecf3abd1c982e81d2ee1c774425f111664d55cc10400a6n
}, {
  a: 0x1c70e4db816e1b69170cc9e7745274a7d1b647e5294874f28e57de1c7n,
  b: -0xd6dba7a9ffbc0fe989f8adb9438a2701ffn,
  r: 0x1c70e4db816e1b69170cc9da0697fa07d5f5494c89bd995e55b56dfc8n
}, {
  a: -0x359886c65d84281fa00486e8c1e18cd177c255d23041035dn,
  b: 0xb35d219bacca045cn,
  r: -0x359886c65d84281fa00486e8c1e18cd0c46534368376ff01n
}, {
  a: -0xd45e71ce900f7ed447670c1ef8360ce4e246f9ac49ff57612c3fa348ae6n,
  b: -0x5101adc67c033bf9d111710fca229fc1n,
  r: -0xd45e71ce900f7ed447670c1ef83b1cffbeaeb9e0099c68783d3c4572aa7n
}, {
  a: -0xd4b2b0dbdc6c81c3fe8e624d55c64df9128b895n,
  b: 0x3525177e0f644dc92b69f8dfc654895db365cc27dbecn,
  r: 0x35250a32e4569002634db8f6e02fb4014e863aff2357n
}, {
  a: -0xdb6e2d436cc36d18addc1199f8cee59b365bbc0b18da750779281e8n,
  b: -0x5197b2cff03a89993e826ad942bcdccd4185c35bn,
  r: -0xdb6e2d436cc36d1dc7573e98fc777f2f1e82699f44a841db9184543n
}, {
  a: -0x63f784b5ac140c979a26be4ee440d646f43dca033f40df66ae587n,
  b: 0xe0821adefa8b88a3c88df7d60eec7cfee5c7d2b2230e703a930n,
  r: -0x6317029acd19810ef65e30570e31e9c9f55802308d1dd0f673c57n
}, {
  a: -0xcf5553df04e5945ac7400b803n,
  b: 0x2b560bf696ea76be2eaa63e392affe9bcd49d6290f88fad41bae3c4544ed7d4fn,
  r: 0x2b560bf696ea76be2eaa63e392affe9bcd49d61c1a33bce3cd54f698d0ecc54cn
}, {
  a: -0xcdbe2bb4075bd50257792ba1595e5db0b40879e7fea28670ea9eb73feb78n,
  b: 0xdd93feca0555d711ab7650a174a35f9f22e6c3en,
  r: -0xcdbe2bb4075bd50257791dc81971bd5b56975f3099986f26b4a4c5117f3an
}, {
  a: 0xdfa7b130124b45772b1f6b559b71089ff826a8bae8fc38112fb39ca73a7da68c0n,
  b: 0xe2b8d91151860d3cc6598c7bb41566e9b0ad921c0a984b78fe38d376f3bcn,
  r: 0xdfa7bf5b9fdc5a8f8bf337bb3438c3e14e9543c5c21df8bab46b2c8ac7b515c7cn
}, {
  a: -0x3ce603b285465c8ccb8ab8841c3bfe59982dd8ea27166bn,
  b: 0xaf48ec34667257946851dcc6ff11b5b4a824d30307f875fe284e3f8dd134502afan,
  r: 0xaf48ec346672579468519fe0fb5f306e4b9807784f7459c229f4a75ff84a29148fn
}, {
  a: -0x49c63fc850n,
  b: 0x2161e796cn,
  r: -0x47b0214ee4n
}, {
  a: -0xf27204983e0b576890193b5e24ada46aba0f0c426795c8b5c3c1f6n,
  b: 0x86d0e606889575ceeb16c216e3775c15a7c06330f90bc36n,
  r: -0xf272048fd0fcf70006c1de6f734182fc82994ae7eb8f95a63305c0n
}, {
  a: 0xecaa4e6010eacfa2348e1en,
  b: -0xb0cb819b30c7273431adcf053bca4d3a68ed8abc2d00e2d14df5fa28bec6f8cfdde2b1n,
  r: -0xb0cb819b30c7273431adcf053bca4d3a68ed8abc2d00e2d0614babc8addc292da95493n
}, {
  a: -0xea9edecbf2e036caab9511fc0e9e03162de35acbcn,
  b: 0x6adb43a1e9e79de454b5b94a306648bf75efacc1eef1b7e13082dea77c8fb4997dd6n,
  r: 0x6adb43a1e9e79de454b5b94a30579ed189307ebe8246fe9010c1f4c74b2cd663d11an
}, {
  a: 0xe4b5ce850506n,
  b: 0x2009cn,
  r: 0xe4b5ce8705a2n
}, {
  a: -0x4af3a358619c22c12c082430673442n,
  b: 0n,
  r: -0x4af3a358619c22c12c082430673442n
}, {
  a: 0x639bfe168d31fc7952b2ebfbc0b3a3c79830ae2b3605bb067d085f007de5247a614n,
  b: 0xe119bcb0b5712c783f2d40d69n,
  r: 0x639bfe168d31fc7952b2ebfbc0b3a3c79830ae2b36e6d4c32dbdd02cf62451bb37dn
}, {
  a: 0x537ee3922ba6dad4f5d5ebce06e0a4e74a9390844cb2fe39271c5ae89cen,
  b: -0x579458dbf0dfff550773e3d5c846a0f5f2462a24fee746705a90a7b3621009n,
  r: -0x578f20edb7bd44e75a2486770b6632eba3d180ebf6a27b4076fe35edb3863bn
}, {
  a: 0x2c8c7db3fe23e0e96934a6a970e87d0130a214324293adf4f845c7f6d0e0f400n,
  b: -0x7e193287c884a49ea684n,
  r: 0x2c8c7db3fe23e0e96934a6a970e87d0130a2143242932fdbc5bdff722c424d7cn
}, {
  a: -0xen,
  b: 0x2c8880a1334960aa745b2ffdbb9176c2e66715f4e394f44an,
  r: 0x2c8880a1334960aa745b2ffdbb9176c2e66715f4e394f43cn
}, {
  a: 0x1338e007d541165d3bcc9260c28b087c1ad52de1a693n,
  b: 0xee82133d93b61ce900d1aan,
  r: 0x1338e007d541165d3bcc934f449e460fd0f216e2783dn
}, {
  a: -0x88b88e1d8622971e92f43a7681647079bacb69e5n,
  b: 0x422e50e50debfc4853443c00a55a42feb3282c44a921ab92a8322d0798ee36n,
  r: 0x422e50e50debfc4853443b77eccc257890910db1b4e7351143c1b34ccd8451n
}, {
  a: -0xe9574c8fc8e6793756a87fd6n,
  b: 0x644n,
  r: -0xe9574c8fc8e6793756a87992n
}, {
  a: 0n,
  b: 0x442a3e54366e4038b4c489c6e80ccf05b109bn,
  r: 0x442a3e54366e4038b4c489c6e80ccf05b109bn
}, {
  a: 0xc9af8d21fffa6206df2faf2ae086b317c6f7cc936n,
  b: -0xc790637996b5f87958e08756b6074f04af3a3ce0d8ef1e7394714f2588641ce12n,
  r: -0xc790637996b5f87958e08755ec57c1e2af3fdad9f9bf6f48b3ea9c0dc16c504dcn
}, {
  a: 0x5af979aff8f128c8d26f6e17cdd15f421cc36dff46549b07e05065dd1n,
  b: -0xe31ccb574d4da2f268b13c9913538d733ab783cbe8ddc3n,
  r: 0x5af979aff8e2f6fc1cfa993d9eaad42e533238c66f20ef8fa391d800en
}, {
  a: 0xe05f9df3025e8feb7e619f121f35447dd91ccfc247659a54b7e7909497e2n,
  b: -0x968245964741007c316cea9n,
  r: 0xe05f9df3025e8feb7e619f121f35447dd91cc65a230c35e0a7dfcd7dc939n
}, {
  a: -0xdd107n,
  b: -0xbb9db22981f99ca37a0c91c22cbf70019cd1b79df93b59fb171c0n,
  r: -0xbb9db22981f99ca37a0c91c22cbf70019cd1b79df93b59fbf42c7n
}, {
  a: -0xabe737eb298cb2b9c8fd8388b8af31c30c5aa8882e61097e37n,
  b: -0x5e9ea4af15a9e28a0cf851715660a2f1906n,
  r: -0xabe737eb298cb2bfb2e7ce7a134d5a63dbdfbf9d946b38973dn
}, {
  a: -0x938f6b0n,
  b: 0x2c5cb424769d3150f7bed3023977f9d7ba5n,
  r: 0x2c5cb424769d3150f7bed302397766484f5n
}, {
  a: 0x8b618daf3d2288d200e26eeb71bb655e81d71d9f71d1f660f26e52n,
  b: 0x542a98138e2cbb41a52a0d688n,
  r: 0x8b618daf3d2288d200e26eeb71bb6aa12b5856823d8610b39344dan
}, {
  a: 0xcb956c393abae22f58f1an,
  b: 0x2ed18129179e36f1dd0f3fc35b9c9776c68e8899d2e84ac1e53961a8206c76ee39122fn,
  r: 0x2ed18129179e36f1dd0f3fc35b9c9776c68e8899d2e84ac1f1f2b86bb41825112ea149n
}, {
  a: 0xa4a1292e0f96740a7904e1c377960cfb7ce06a27fc1ec2fd3n,
  b: 0xaabb2f16a05ca39f05ef99fd611fbec59c02d791ff0c0cd970cc6185fc48f2a040c6aan,
  r: 0xaabb2f16a05ca39f05efa44773b29fbf03437f224d284452d19c195402eb72622cf67dn
}, {
  a: -0xbdc17069034a891b9dc994cb078519e1c856afn,
  b: 0x4200327571f23bedc8n,
  r: -0xbdc17069034a891b9dc952cad50fa7ef8c68e7n
}, {
  a: -0xc33d36c5f8470fe2d617fac5da61n,
  b: -0xe623641a3ea3fe9cn,
  r: -0xc33d36c5f847f6063a323969d8fdn
}, {
  a: 0xc30d33a71b9c06n,
  b: -0xcf25a9e3cb7710617bff6adc6b62d06f79fe284354d2820d4d7f8ebe79ca89e3n,
  r: -0xcf25a9e3cb7710617bff6adc6b62d06f79fe284354d2820d4cbc818ad2aeedddn
}, {
  a: -0x599286d487cffdfcbdf823eba937459a596a868449f65532202eb4n,
  b: 0x504818n,
  r: -0x599286d487cffdfcbdf823eba937459a596a868449f65531cfe69cn
}, {
  a: -0x2ecde2562dafbeca31284a1cb788b4dd26d085df08bfa9f8291261ee9n,
  b: 0x83n,
  r: -0x2ecde2562dafbeca31284a1cb788b4dd26d085df08bfa9f8291261e66n
}, {
  a: -0x779795100fde8eb96f4a575a71n,
  b: -0xcf4ef9245d09f3fae8365023e9n,
  r: -0x146e68e346ce882b45780a77e5an
}, {
  a: 0x3224b3d3a5bn,
  b: -0xbfdb1dd6f4c706c8d2f9defd7565b7n,
  r: -0xbfdb1dd6f4c706c8d2f6bcb2382b5cn
}, {
  a: -0x98ee6616863e7e9fb0dc9381de1f786964beab6fe8n,
  b: -0xd2900dce99f163a3a265bbccn,
  r: -0x98ee6616863e7e9fb1af238facb969cd0861112bb4n
}, {
  a: 0xc4bcbaaf12bd13b91bd410d6a7fce4ece55601f31a268ee2bn,
  b: 0xd6d5b0d48a43bbb4ee25c8e302a2edc3bb0n,
  r: 0xc4bcbaaf12bd148ff184e560ebb899db0b1ee4f5bd14529dbn
}, {
  a: 0x4b115f856de2948f38cdcafde82e676c0d6385bfc0cf91e5d1ddc4e693671n,
  b: 0x22768d8914d82e8aa0en,
  r: 0x4b115f856de2948f38cdcafde82e676c0d6385bfc0f208735af29d151e07fn
}, {
  a: 0n,
  b: -0xe854bb3a15e50d8643225fn,
  r: -0xe854bb3a15e50d8643225fn
}, {
  a: -0x75ff563acc2173f5abf73b8a24bb7fb5fa46e7d5en,
  b: 0x567e93ae66deen,
  r: -0x75ff563acc2173f5abf73b8a24bb2937669880f70n
}, {
  a: 0xa901afb688163e6101265c3c324391f4c312537d5ee6fe77765ce0b923571c6cdda6dn,
  b: -0x2e68e796ccb33717ed76c2cd0cb93n,
  r: 0xa901afb688163e6101265c3c324391f4c312537d307e16e0a9a9a9a135e0599fd0edan
}, {
  a: 0x1f2c9f14b6ca0eac29037281afb1549e26256781976f5963fe97351235c1n,
  b: 0x4n,
  r: 0x1f2c9f14b6ca0eac29037281afb1549e26256781976f5963fe97351235c5n
}, {
  a: -0x4079342015484862ea58n,
  b: 0xeb333a0fdf57ccabb3aa0862fa796c13190d5a649fbe72f2232a09087n,
  r: 0xeb333a0fdf57ccabb3aa0862fa796c13190d565d0c7c719d9ea3da62fn
}, {
  a: 0xc13868an,
  b: 0x622866ef49efb6501824eb1412n,
  r: 0x622866ef49efb6501830fe9a9cn
}, {
  a: -0x6844a0a49191cbc4193cb5e65176c2a04e181e606ba0ab197c57dc663638644918274n,
  b: -0x52e6cd1aaaeb099342411652913a9358dc06b89682322e9e3cb85b9ac9b024n,
  r: -0x6844a0a9bffe9d6ec7ed4f1a758827c961c153ee2c0c34819f7ac64a01be1df5b3298n
}, {
  a: -0xc5f41288560cae48941f944f9210522674d74b10912a97bb30624606n,
  b: -0x5d3b69b70ca30ee099n,
  r: -0xc5f41288560cae48941f944f9210522674d74b6dcc944ec7d371269fn
}, {
  a: 0x412c6aea1e59b2dcf1411dca66faa015d2554ef31b45d97d23b4dfe90fn,
  b: 0xcd51aa77c4f1c3d7f70187d8897747e598367c6cd982dda7f3e592153d7a9495187dn,
  r: 0xcd51aa77c532f042e11fe18b66688903629d770cef5532f6e700d7eeba9e4975018cn
}, {
  a: -0x418fc5bce307abf25e7cc1d4dd2e54609551611cfa034ab6f9c209n,
  b: -0x1e864493557c086965155324cdf04d8abf6a8fcca01ef23c5d0f5ecn,
  r: -0x229f40ef23ac83288afd1f421bc332d0c8bfa5de6fbf26e7ccab7f5n
}, {
  a: -0xb36f191c0a178f8f748907170a936799f8025385282299239664a20a2856a5f4n,
  b: -0xb7727f93n,
  r: -0xb36f191c0a178f8f748907170a936799f8025385282299239664a20adfc92587n
}, {
  a: -0x4690faa0d2a74a4c8a6d6c5150baaccf004930f95acn,
  b: 0x18d0906dbbeb49e7cn,
  r: -0x4690faa0d2a74a4c8a6d6c5150a1dc3e928d45af730n
}, {
  a: 0xad295ca74aac6da31bbe6a4e03bef5e972953n,
  b: 0xbef4dcbd88f233712e1516f17bbcdb16374cb53f097db91e99dacb47n,
  r: 0xbef4dcbd88f233712e1fe987463185dd117e7125ae5df50df871f49an
}, {
  a: -0x276e2332ce4n,
  b: -0xfb7b654e2a0c7n,
  r: -0xfba2d3715cdabn
}, {
  a: -0xdb80en,
  b: -0xa1c91ffda8f63063ca25fdd9deaafccfff473fba357cd7a27b1dn,
  r: -0xa1c91ffda8f63063ca25fdd9deaafccfff473fba357cd7b0332bn
}, {
  a: -0x230ea43cn,
  b: -0xd3914138de5ffaed25ec60en,
  r: -0xd3914138de5ffaef56d6a4an
}, {
  a: 0xb2870886c4f5190e280562b894065e26068e8bde83eb9c92496e7ff6dn,
  b: 0x17c1449885cfe4b250830eac3n,
  r: 0xb2870886c4f5190e280562b894065e261e4fd07709bb814499f18ea30n
}, {
  a: -0xa61565dcb1ab7dc43fd6f00b1caac7fb91282975fcbd3c97fn,
  b: -0x76959922fc41743cba0beaa7b1ac6ffd15aeb8fa29fdn,
  r: -0xa6156d460b3dad88571abbabdb5543165827fad0e84cdf37cn
}, {
  a: 0x6a8b3fd7697b14e96885350ed415bbc5c00n,
  b: -0xffcde94f3n,
  r: 0x6a8b3fd7697b14e96885350ed315eddc70dn
}, {
  a: -0xf8d3cf34d4362db588bd39059a379a5426ad2d47ea9n,
  b: -0x2ca965c6ca0ea11n,
  r: -0xf8d3cf34d4362db588bd39059a37c6fd8c73f7568ban
}, {
  a: 0x24a65275dd475dd11bd9f69a92ban,
  b: 0xe905f379a93aaffbb80558fbn,
  r: 0x24a73b7bd0c1070bcbd5ae9febb5n
}, {
  a: -0x6db2b3f6565a0f713249bb2349n,
  b: 0xf7ae9c18297e89af62dd0af7dbab441ee0905ea476f5d2740n,
  r: 0xf7ae9c18297e89af62dd0af1008004b97aef6791525a203f7n
}, {
  a: -0x1dc73cc47b1d451bec9e29ad5f32b3950369f7ac7d5dc5f9c4b6085n,
  b: -0x8d31e7317b0e11eef2db1c3167fa87608b9371f5dcb31857d1dcn,
  r: -0x1dd00fe2ee34f5fd0b8d575f2249333d7972b0e39cbb912b4a33261n
}, {
  a: -0x10fc9be5026ab3a3d8c20a56de6cddd9af4fea4b7n,
  b: -0xac26bbd5333b30f431bada0227cd46b2491ca2ee199111n,
  r: -0xac26bce4fcf9811adcf5178e4872b49916fa3de31835c8n
}, {
  a: 0x4ac2528cdd126cfd31a789e880f6a22c137493f5ad47637d9f65c83a3d310b182254f2n,
  b: -0xc778f247b91dn,
  r: 0x4ac2528cdd126cfd31a789e880f6a22c137493f5ad47637d9f65c83a3c699225da9bd5n
}, {
  a: -0x4170a95b08aaa2f1f4d162fcb22ac6n,
  b: 0x7c6f177fc1feb71d7429eb8d20079de6275951ea2ean,
  r: 0x7c6f177fc1feb30669943b0275d87e99112986c7824n
}, {
  a: -0xb4ebb98n,
  b: -0x24e11761dd6f641d0627d3c3b19c0d33642223ea3f4e5d5628367076n,
  r: -0x24e11761dd6f641d0627d3c3b19c0d33642223ea3f4e5d5633852c0en
}, {
  a: 0x30f2e3aa091545020d0839459c1dc01cf1987c7f3e23846589ef703374afc5737n,
  b: 0xb24640afe32528105e5f21207n,
  r: 0x30f2e3aa091545020d0839459c1dc01cf1987c7ff069c5156d149843d30ee693en
}, {
  a: -0x8834593792b3fc55a4aa27f290cadeb204e366573a67d3dfc2b0bc44ed28e2d75c3d4en,
  b: -0xd923497d8db4e71f487611f7fe13f31b7b8f57fffbae1f7795843b9e92ba359c6n,
  r: -0x883466c9c74bd530f31c1c79f1ea5e9344151e102fe7d39aa4a8359d30e2cc02ff9714n
}, {
  a: -0x4839n,
  b: -0xc7eed0f62n,
  r: -0xc7eed579bn
}, {
  a: 0x6731fb4131976223d539256262dc1d896085n,
  b: 0x30c07c35ea31a08d72d56a93154e58b60e2ec7dc43445f5n,
  r: 0x30c07c35ea3813ad26e88409378bac486454f59e1bda67an
}, {
  a: -0x72d4n,
  b: -0x9f5525d104f400e135b3562542b9accea5799e7602ab59162cb62abe4b28ccn,
  r: -0x9f5525d104f400e135b3562542b9accea5799e7602ab59162cb62abe4b9ba0n
}, {
  a: 0xda80aa0bdd39ed01d245ccc487a7b67n,
  b: -0x7338ad3f489d6cee45773acn,
  r: 0xda80aa0b6a013fc289a85fd642307bbn
}, {
  a: -0x21bed382ef82b910585c799b940e1e1624c70137eeb5b1cbb3bfffc829073f5a0n,
  b: 0xd94e1adcc5de8f25fn,
  r: -0x21bed382ef82b910585c799b940e1e1624c70137eeb5b1cada71e4eb6328b0341n
}, {
  a: 0xfe59d55e89b00eeb3ec1e19845b6d8cb6275n,
  b: -0xfd4169ff56a43791a3e6f82942266da19265cdcfa655e0bdea37844f91134ca2ea47n,
  r: -0xfd4169ff56a43791a3e6f82942266da0940bf8711ca5d1d2ab75a2b74b5c73d787d2n
}, {
  a: 0xfc5859c13705687719b237db89a62fn,
  b: -0xf8b3a1b91318c87febcd5n,
  r: 0xfc5859c1277a2e5b8880ab538ae95an
}, {
  a: 0xd90dcn,
  b: 0xf5f445e592bc14n,
  r: 0xf5f445e5a04cf0n
}, {
  a: 0x3cf23ae5010bd1en,
  b: 0x664c55f3n,
  r: 0x3cf23aeb65d1311n
}, {
  a: 0x3f6c202ac86b66fa9fb7a7f9bd58df321db54d17a2300cd908n,
  b: 0x9c9d06d6030dbd2e9e64548358e3c68n,
  r: 0x3f6c202ac86b66fa9fc171ca2ab9100df09f335cea659b1570n
}, {
  a: -0xf343fb0ab310640a0cn,
  b: 0x2925982b9a43bf6fa7649985f22547c25d91f331a364e879eed3eeb753n,
  r: 0x2925982b9a43bf6fa7649985f22547c25d91f330b020ed6f3bc38aad47n
}, {
  a: 0x17549f3d79ac38a846f06e280de95182fbef22621bc721bf00c36772ea5c3c71bdf1n,
  b: -0x3ad7aa82d6870n,
  r: 0x17549f3d79ac38a846f06e280de95182fbef22621bc721bf00c3676f3ce194445581n
}, {
  a: 0x948eb5b972605191e21426b6e983767add31e79455be367e58ac2n,
  b: 0x23f0eab862ca8a3964784519994d7899f621c0n,
  r: 0x948eb5b9726051942122d23d162c1a1124b6392dea95c01dbac82n
}, {
  a: 0x3708b96cn,
  b: 0xbd5cbda69d2ecf023ae5n,
  r: 0xbd5cbda69d2f060af451n
}, {
  a: 0x22a340c82e3035c07ae59e628n,
  b: 0x2d70019b58bc2f913e550eca4860f15e366503b1c8a92d0f78dc0f9915ff63375n,
  r: 0x2d70019b58bc2f913e550eca4860f15e366503b1eb4c6dd7a70c455990e50199dn
}, {
  a: 0xf6a901d89e67e87af2ad02a9bf4cf69bd34faen,
  b: -0x3d01eefc8ae16e7b9cn,
  r: 0xf6a901d89e67e87af2acc5a7d0506bba64d412n
}, {
  a: -0x76n,
  b: -0x565793f51af519e50195dbd6b31ecd1c51e7af727516602018ed79f133b1an,
  r: -0x565793f51af519e50195dbd6b31ecd1c51e7af727516602018ed79f133b90n
}, {
  a: 0xfa662n,
  b: -0xb5e50dc7cef878cdbad96dd649cfdbc79d441c66b8c4c473ab97e799a0b8n,
  r: -0xb5e50dc7cef878cdbad96dd649cfdbc79d441c66b8c4c473ab97e789fa56n
}, {
  a: 0xd7bb9dd40a85c2acc47eab1d5441227a6bn,
  b: -0x64b5480c9a4449c0094bd080199dc11afe55ec0624913460f0d6dec1dbe9n,
  r: -0x64b5480c9a4449c0094bd08018c6057d2a4b664377ccb5b5d3829d9f617en
}, {
  a: 0x4a56046a770n,
  b: -0x51f727860da499b1a4feben,
  r: -0x51f727860d9ff4515e574en
}, {
  a: 0x54ceedd5f83103febe6e9b0a16b4ee7bf70efe9d166510f2d0b7611bbba958394698ddn,
  b: 0xafa99ab0d6bfe83b3b0edb2c6507036c95686184a8aa57d6556e7f6b50dn,
  r: 0x54ceedd5f83bfe98697c07089a689f69a9d54f0d4d2e6778e901ebc1390eaf213d4dean
}, {
  a: -0x935edd5972e5a358d7e60e8bea574de4n,
  b: -0x52c90ce6bb51ca1a0e7e82b78e8fb8f8341c44bfdd9n,
  r: -0x52c90ce6bb5b0007e415b111c41d37591cdaea34bbdn
}, {
  a: -0xb146963947606ea3e572n,
  b: -0x4f3ea788b98496207bb48fcb75425ec81n,
  r: -0x4f3ea788b984a134e51824417c2c9d1f3n
}, {
  a: 0x6010a36267021351e7e381720cc89cd7f1bd13092an,
  b: 0x153e86f5c5021db54f1n,
  r: 0x6010a36267021351e7e3817360b10c3441deee5e1bn
}, {
  a: -0x2c81aa26291b25b6d56a248n,
  b: -0x16a762ad6b7b5384n,
  r: -0x2c81aa279391508d8d1f5ccn
}, {
  a: -0x8798081f2e08af2f9a15375e2675626b596b1e73b07ffa79b9866a1af4d3een,
  b: -0xd496dec82ffea9802a43b0fn,
  r: -0x8798081f2e08af2f9a15375e2675626b596b1e80f9ede6fcb971021d990efdn
}, {
  a: -0x7b55c01301an,
  b: -0x34390b20c2a23aad41c266fb50a68e8bbdc36dd4b10df4n,
  r: -0x34390b20c2a23aad41c266fb50a68e8bbdcb2330b23e0en
}, {
  a: 0x8b6a3e42060780677d33ec649a9a19e594b01733f7f31bn,
  b: 0x9e53bc77f1be9n,
  r: 0x8b6a3e42060780677d33ec649a9a19e59e9552fb770f04n
}, {
  a: 0xe59246bn,
  b: 0x84b90f1a6d66a3a6efad1d2d4fa4caa5n,
  r: 0x84b90f1a6d66a3a6efad1d2d5dfdef10n
}, {
  a: 0x8fb8b8c2cfaecbd6c28879de9c1d83a7b7addcdedaabfn,
  b: -0xe7ceb89f214e5fc336fce4a3c53eff20ff7df344313f19d5465b62133476d6a2c137n,
  r: -0xe7ceb89f214e5fc336fce49ac9b372f4049135d808b77beb84832797b99908b51678n
}, {
  a: -0x7fa9b223f9d187192be96e81c9ce8bce96e8d3d0e76n,
  b: 0xa8d2888edaf83eecd5eee40ff9a637b1f2dd6ccn,
  r: -0x7fa909517142ac20ecfc9892e5be92285f36e0f37aan
}, {
  a: 0xeb49bc07f63fb598c977a6a9dc28d2a9d42ea6dfd11a2e02320510d0a4eb3b51cfa4n,
  b: -0x3898b09919dbbeb9ee5f0c6f8e70463a0d2c769acb25f8685844dc0f73n,
  r: 0xeb49bc07f6071ce8305dcaeb223a739d64a03699970d018b9739ead83c92f675c031n
}, {
  a: 0x28877241b9fdfca11341ed349c0cc11043fcc1cf352f5fa3703491cb6n,
  b: 0xc4fd08f09n,
  r: 0x28877241b9fdfca11341ed349c0cc11043fcc1cf352f5fa435319abbfn
}, {
  a: -0x6e649ee3cc637ec174c963d0cc3813d895b17dn,
  b: -0x1n,
  r: -0x6e649ee3cc637ec174c963d0cc3813d895b17en
}, {
  a: 0x7f0381e637db8772c7ccdafbbca76fcab2b72a605f1bc1425b4a93860dc8c386747n,
  b: 0x59eb92fa23276f7832f03ea8170b19d3fec0f6361b1a52d3d770172b86d4b6240an,
  r: 0x84a23b15da0dfe6a4afbdee63e182167f2a339c3c0cd666f98c194f8c6360ee8b51n
}, {
  a: 0x777e9139fe2e0c5cb4479n,
  b: -0x8e484e666fb0914f07dec0b70e3973a011e219bn,
  r: -0x8e484e666fb0914f07674225d43b4593b52dd22n
}, {
  a: 0x1bc9cf8c57251be7b5c0a90b04196c1n,
  b: -0xc50ceaf0n,
  r: 0x1bc9cf8c57251be7b5c0a8feb34abd1n
}, {
  a: 0xbe5dfe5e812cn,
  b: -0xe129710409bb10001d8648197fd0n,
  r: -0xe129710409bb0fff5f2849bafea4n
}, {
  a: 0x42c5476d5655dn,
  b: -0xef4da6a19df8f940a0780494f45682373bn,
  r: -0xef4da6a19df8f940a07800689fdfacd1den
}, {
  a: 0x293a0ae55aadc8c2d6710289e859a04177a95n,
  b: 0x86d68a3400f718b1407076e4893138bn,
  r: 0x293a0b6c3137fcc3cd89b3ca58d084caa8e20n
}, {
  a: -0x9d24fbb568eb73cn,
  b: 0x815630759071102617cb7983f8b778d16bc0667d314e01cff33461db9ef8n,
  r: 0x815630759071102617cb7983f8b778d16bc0667d314df7fda3790b4ce7bcn
}, {
  a: -0x4f72cd1678n,
  b: -0xb6c5f1231f470982a590bd68d0a69e9fa50a2n,
  r: -0xb6c5f1231f470982a590bd68d0ab95cc7671an
}, {
  a: 0x260c4c7d961100a2a6521724119n,
  b: 0x98743309cn,
  r: 0x260c4c7d961100a2a6ea8b571b5n
}, {
  a: -0x60f646ebaa144026ec2260fcaa7a66f108cf7910d7285ecf83444206b48febab4bn,
  b: -0xdedc828f9600abc6n,
  r: -0x60f646ebaa144026ec2260fcaa7a66f108cf7910d7285ecf84231e894425ec5711n
}, {
  a: -0x56034c6b30dd08657b9d11d8a6a6195e55add7d8f1a816aa61e3n,
  b: -0x49280063bf5e107937fa79e5d3db5b61900df9c870n,
  r: -0x56034c6b31263065df5c6fe91fde13d83b81b334533824a42a53n
}, {
  a: 0xd21c29028e8b4eaffac0cc6275ac602f11bfbd2ab32n,
  b: -0xe7295be4247b4ad2adf2837a162da407n,
  r: 0xd21c29028e7cdc1a3c7e84adc8818106da1e5a5072bn
}, {
  a: 0x2bb4411b503c1f98ca4ec5e2080a333e03f4a875360f9a9509b6cab682n,
  b: 0xe0855ce71942e7fbe7ce585e123b1c03fc1e8ba7n,
  r: 0x2bb4411b503c1f98cb2f4b3eef237625ffdc76cd9421d5b10db2e94229n
}, {
  a: 0xe8f5fd3bba6bb37aeac49a20cc2139c59c60664f95b5f6a75an,
  b: 0x2d4afe3e349908c279dc20b6ab70be89n,
  r: 0xe8f5fd3bba6bb37aeaf1e51f0a55d2ce5eda42704c616765e3n
}, {
  a: -0x7278e56fc314c7860506234c890237ed8aaca4f1a83dc56e887n,
  b: 0x99127a99a68fn,
  r: -0x7278e56fc314c7860506234c890237ed8aaca4e817161bd41f8n
}, {
  a: 0xcdd914f8ffa15ab246dace8f7e7a0dfe1d0fccen,
  b: 0xf57e632696421acd088c73b9433682b16e44de4296ea8544b205an,
  r: 0xf57e632696421b9ae1a16cb8e49134f849136dc110f88361c1d28n
}, {
  a: 0x2635111c82da52d7eec4bb4618bcf79510400537b7369a983fb398n,
  b: 0x3e6fe548107cc53823e4573a3ed8f83b54c42cb2dd0e427ad7a4en,
  r: 0x2a1c0f7103e21f2b710300b9bcaa8718c58c4802e5077ebfed2de6n
}, {
  a: -0xc9d86c216aeae2065b44a6c92b3270a93f420an,
  b: -0x6e5a4890a4d3f985b17bb015a7db8e7c764bbbe0934fc30cfd0dcec720ef9072c1fn,
  r: -0x6e5a4890a4d3f985b17bb015a7db9b19fd0dd28f417028c1477a617a47fa2466e29n
}, {
  a: -0xfc5f4cade38803599ebebdf291348459b26bab8f96a3af43365113dfe63fc133dn,
  b: -0x938329846c05c05e44c17a9e88e981een,
  r: -0xfc5f4cade38803599ebebdf291348459bba3de27dd640b491a9d2b89cece5952bn
}, {
  a: 0x5eeda4deb3dc7f6b18dd4758f394abd4a11cn,
  b: -0x4b20077e462da9a0f3c22618e513ccae403532691b5b123n,
  r: -0x4b20077e4627bac6a5d6e850ee623ed9caa5f91e5e11007n
}, {
  a: -0xa4d3d55a150fc31c90ee6001f07735c9n,
  b: 0xa5bf32a5194b92140459a943286ae76ca6d5f248594da59b6b975540ee5n,
  r: 0xa5bf32a5194b92140459a94328609a2f5134a14c278496b56b784dcd91cn
}, {
  a: -0x520347n,
  b: 0x3n,
  r: -0x520344n
}, {
  a: -0x9f2n,
  b: 0xf4f849446a334de825f9cba8346d997ee3n,
  r: 0xf4f849446a334de825f9cba8346d9974f1n
}, {
  a: 0x5c5ec3fcd8b5cf5d16f4a442e48abdafef638f26b70n,
  b: 0x39n,
  r: 0x5c5ec3fcd8b5cf5d16f4a442e48abdafef638f26ba9n
}, {
  a: -0x8047eaa1c7cd0den,
  b: 0x2e2e0df3fc95283896bcd7b4ce9a67e19935efdbf75104f752f217ce8b305cf9afn,
  r: 0x2e2e0df3fc95283896bcd7b4ce9a67e19935efdbf75104f752ea134fe113e028d1n
}, {
  a: -0x26903a2e7d524a2e3e70f37086ff085af8an,
  b: -0x1522db56ae031d389n,
  r: -0x26903a2e7d524a2e3e86164bddad0b78313n
}, {
  a: -0x240b7d6127c9db12b1d6e1ff1f7c490c51af80486cd93f4f64146aa914f772ea3n,
  b: 0x3d1f72f5e584284e3n,
  r: -0x240b7d6127c9db12b1d6e1ff1f7c490c51af80486cd93f4f26f4f7b32f734a9c0n
}, {
  a: -0xc23d9630a6aa35c1c31ad12d5f992c19106ac9c31e8d43ce0a0ab5b46fn,
  b: -0x4f813e2bdb141d76399edf2db4bd7ed30962b1c385e88e5466b330dn,
  r: -0xc2428e448967e7039a7e6b1b527477f0fd9b5fee3ac5a256ef5120e77cn
}, {
  a: -0x4d7945481e0d8367e1a29456b6c22e9f936d58a5c9287n,
  b: 0x6ea061291616aa652c8ef9bddn,
  r: -0x4d7945481e0d8367e1a225b655991888e9082c16cf6aan
}, {
  a: -0x8d5b1c9c89431dc72633d329a07d15fn,
  b: 0xf69eefeecc927ee2548f68fa2eb473933a75f91a9bd5963n,
  r: 0xf69eefeecc927ee1c7344c5da57155cc144225f0fb58804n
}, {
  a: -0xed8865ead330f9cd05427bd3357046d1b229fa2deeb029ec745n,
  b: -0x4ad05411fe5e58d03b4b194ec1bd146a64e7771aba768a46c3d8bd98d719af52an,
  r: -0x4ad05411fe5e59bdc3b10421f2b6e16fa7634a502abd5bf8edd2eb8787439bc6fn
}, {
  a: -0x7c41abn,
  b: 0x79cea6747116d668ee5f9e99ecb1f7e3a376b1292n,
  r: 0x79cea6747116d668ee5f9e99ecb1f7e3a36eed0e7n
}, {
  a: 0x21ed109a5c477c2a4a06202cd885bfb45052n,
  b: 0xef1891691e08ff40ebc08ac36c35861054800099df432da9ban,
  r: 0xef1891691e08ff62d8d1251fb3b1b05a5aa02d726502e1fa0cn
}, {
  a: 0x68627f8c1ab98b6863a0844b8b2d63f49b9e61780cn,
  b: 0xe74cbc29718a0c56526a1502778938n,
  r: 0x68627f8c1aba72b51fc9f5d59783b65eb0a0d90144n
}, {
  a: 0xbcd8e24940d5a17887d9c48eeacbe1a1a2f36c2bd5acn,
  b: -0x584f6f3abf603fd053ca1959fd111d3ad46e05ed840n,
  r: 0xb753eb5594df9d7b829d22f94afacfcdf5ac8bccfd6cn
}, {
  a: 0x71c33878aaba722f77496611003e8d1216249824c2f57ef3e16n,
  b: -0xdcdaf0e6a7fd6621a787a5e76aab1d169a2145fcen,
  r: 0x71c33878a9dd973e90a168aade97056c2eb9ed07ac5b5dade48n
}, {
  a: -0x13b4080f4e9acc72198cda26e15ff96d1c13b10b77b15fe126ed450f3ff631093c6n,
  b: -0xc4c0352f29aae151e760dc3e37c2e63n,
  r: -0x13b4080f4e9acc72198cda26e15ff96d1c1475cbace0898c083f2c701c3468cc229n
}, {
  a: 0x71df7cebcb8c09a5211af45d4ea9021309aa83ef6cbb4d0ce904444aa282n,
  b: 0xb1fc67e14b82f24a4920a9fadb0eb9035a5f7921cb75255d49c58dcfc886836n,
  r: 0xb20385d91a3fab0ae372bbaa20e3a3937b9013ca0a6bf1121a941e140d30ab8n
}, {
  a: 0x7c681c315510fd3d291bec85b51ae0348b8ddc74f0b56b2a5n,
  b: 0x7a503f61f1901f3685cd253c17d16223c80ac7ed16d38792eeb9n,
  r: 0x7a5805e3b4a57046599fb6fae02cb3d1cb5380cade2292e9a15en
}, {
  a: 0xc92ede22bac69309092731b1e1a46an,
  b: 0x548b83735c3de95810dd2d0b2842n,
  r: 0xc98369a62e22d0f261380edeecccacn
}, {
  a: -0x328ecb7e05fba9720an,
  b: -0x39870493bb04abfb1f80820872n,
  r: -0x39870493ed937779257c2b7a7cn
}, {
  a: 0xf9538bc83fn,
  b: 0x65d4498c52dn,
  r: 0x75698248d6cn
}, {
  a: 0x565fa73265049c85e8d1434203n,
  b: 0x8a3f10429e4eadadebe5ed843c1986dca3b982d45ff4b76372b2f52430n,
  r: 0x8a3f10429e4eadadebe5ed843c1986dcfa192a06c4f953e95b84386633n
}, {
  a: 0x4n,
  b: 0xf92ecf1bd07f341ce655c91e4c4d9319e256aa1371cc9bb53944eff21326f29d8ed3en,
  r: 0xf92ecf1bd07f341ce655c91e4c4d9319e256aa1371cc9bb53944eff21326f29d8ed42n
}, {
  a: 0xccd6bef7ff3da11n,
  b: 0xb31e6fe4187e1ed4651eea3b232bc1be9f1644956061f1da1f6422ecff3bac54bda182n,
  r: 0xb31e6fe4187e1ed4651eea3b232bc1be9f1644956061f1da1f6422f9cca79bd4b17b93n
}, {
  a: -0x97d8fn,
  b: -0x592ecd9e8d1eb8fb0285b685cba2e02aced880fbff421b19fe40099584f5a67n,
  r: -0x592ecd9e8d1eb8fb0285b685cba2e02aced880fbff421b19fe400995858d7f6n
}, {
  a: 0x59652e31d44d44e560b089f681eafb1781812fc5503e61en,
  b: -0x5036e6abf3b422836b69f285f8a735n,
  r: 0x59652e31d44d44e55bad1b8bc2afb8ef4aca909cf0b3ee9n
}, {
  a: 0x4a8aeb8007n,
  b: 0xfbc3adc3663a4de41149ae34d87de271a064b2f8f0f77928674f56dc5n,
  r: 0xfbc3adc3663a4de41149ae34d87de271a064b2f8f0f7792d0ffe0edccn
}, {
  a: 0x38ffb872c31de12b3f17b41531bf12841n,
  b: -0xa807a0360b0n,
  r: 0x38ffb872c31de12b3f17b36d2a1edc791n
}, {
  a: 0xc76d8b22032428b6274an,
  b: 0x81d9e3ba22063fdbfd4aa9b5f81c2fe389aa95c38ad59b1c1fc9e70ad237345f3n,
  r: 0x81d9e3ba22063fdbfd4aa9b5f81c2fe389aa95c38ad5a792f87c073d14c296d3dn
}, {
  a: 0xbabeea86a261f2219abfn,
  b: 0xcb87aabad29e4d2504b30b0bcb7aa0n,
  r: 0xcb87aabad3590c0f8b556cfded155fn
}, {
  a: 0x6d28c15d1ea774381ae082633289da4a07483cda3e8da9n,
  b: 0x7n,
  r: 0x6d28c15d1ea774381ae082633289da4a07483cda3e8db0n
}, {
  a: -0x990aafb1cca4f084ae6f390c79ad0ebcc60649b91en,
  b: 0n,
  r: -0x990aafb1cca4f084ae6f390c79ad0ebcc60649b91en
}, {
  a: 0x35c3c77130a759bd6b53ab5cec71n,
  b: 0xf6735c2294ecfbe443c39b6d26bd2a7785aab6f71707bcd142296c8fn,
  r: 0xf6735c2294ecfbe443c39b6d26bd603b4d1be79e70c52824ed865900n
}, {
  a: -0xf1c2af1156507740n,
  b: 0xc1448f0bd4ab96254a1cc26ee98826cd6340d5b73bc0557a7b8427bfd565a82ec3n,
  r: 0xc1448f0bd4ab96254a1cc26ee98826cd6340d5b73bc0557a7a926510c40f57b783n
}, {
  a: 0x2306071526fbf571d162b446cda2321c612c4a52613121154bb1d0fc588f1e5db45n,
  b: 0xd56be366aa72a2d101fb7215a2710e503568a9adf97477dd1afe1ddfcb80c0b8n,
  r: 0x23135dd35d669c9bfe72d3fdeefc592d462fa0dcfc10b85cc98380de368bd669bfdn
}, {
  a: -0xc0734269e1a335bc2fb89ce2c5a30848b6aece2f62041e0071712n,
  b: -0x449f61ff79875fn,
  r: -0xc0734269e1a335bc2fb89ce2c5a30848b6aece33abfa3df809e71n
}, {
  a: -0xdda704c35f7d5a33161e583acd0cb600e2b14432db20a77b5n,
  b: -0x224b474950ffa432c30a238cd5a74899n,
  r: -0xdda704c35f7d5a3318430caf621cb0440ee1e66ba87b1c04en
}, {
  a: -0xdbdafbb855f3414d74f5108117547a80an,
  b: -0x15d16ad63823c18a92f93104n,
  r: -0xdbdafbb8575057fad8774c99c0840d90en
}, {
  a: -0xd9aedf4en,
  b: -0x81f9cbebc2c9d428c4d3359f565n,
  r: -0x81f9cbebc2c9d428c4e0d08d4b3n
}, {
  a: 0x5c3303c75f782c72ee9384b2a722ca8fc8157a05a38762ea6f63bc7ecfbc883ade0687n,
  b: -0x71068b26f95c60d5362e94e2b56facb2446ce7n,
  r: 0x5c3303c75f782c72ee9384b2a722ca8f570eeedeaa2b02153935279c1a4cdb889999a0n
}, {
  a: 0x87c029c0e71d7n,
  b: -0x5751714cba3205f73ce6e488433fb932fb07c45f36874424n,
  r: -0x5751714cba3205f73ce6e488433fb932faff485c9a78d24dn
}, {
  a: -0x23e9b1c70bff162ab28d928b62e15b6526c67ac8276064b4dffe84db3ae5eb56n,
  b: 0x1871e16a5a510ea9aa413a7370b0e94b124823b6793f5n,
  r: -0x23e9b1c70bff162ab28c0b6d4c3bb6543c2bd6b4802959a64b4d6058ff7e5761n
}, {
  a: 0xa3c327f5a96e4n,
  b: -0xf6bc35883b2b231fdf574d88a6369a8fdfa8b8n,
  r: -0xf6bc35883b2b231fdf574d889bfa68108511d4n
}, {
  a: -0x175fb8a597c6n,
  b: -0x23bn,
  r: -0x175fb8a59a01n
}, {
  a: 0x4d59a15d2a47a7ff4b339a749cb5452n,
  b: -0x3dd2c5fbcb95f22df6a994f1311bc12a599d8ac73966f2c13764n,
  r: -0x3dd2c5fbcb95f22df6a9901b9705ee85df1d9613ffbfa8f5e312n
}, {
  a: -0x539dcd802ea21d95e2cb7b8111n,
  b: 0xf8dfc799adbf8d6a8697ce60d1afb26e88c9050a745052507f687f73a583150890a18en,
  r: 0xf8dfc799adbf8d6a8697ce60d1afb26e88c9050a744ffeb2b1e850d187ed323d15207dn
}, {
  a: 0x120cb969n,
  b: -0x296ce0def8b3bf081b5179n,
  r: -0x296ce0def8b3bef60e9810n
}, {
  a: -0x335a99c98fbd64b84b15212dd3b672dd3c03451cda8ffbdd101c89ea35fe82n,
  b: -0xe15bbc8a9facbb663n,
  r: -0x335a99c98fbd64b84b15212dd3b672dd3c03451cda9009f2cbe533e501b4e5n
}, {
  a: -0xa710fdc275f99429de4db3f875887a9af37fbada56cbe0en,
  b: 0x1017eb3bc84a4b3156430abc9ac3f4fa683bdd747d1261625dc7n,
  r: 0x1017e0cab86e23d1bd006cd7bf846da1e0922e3c8164bbf59fb9n
}, {
  a: -0x68a8321dbbb713fe7fd2135n,
  b: -0xecc3f2309944a0ac5505ccecad2de1bn,
  r: -0xecc3f23101ecd2ca10bce0eb2cfff50n
}, {
  a: 0xc42b0949886ab94bdbc949dcaf24bcf5b9bba5en,
  b: 0x82666f4df8118c5c6ea84b81e2d2f3ad68eb646932366af84861b4cdn,
  r: 0x82666f4df8118c5c7aeafc167b599f4226a7f906fd28b6c7a3fd6f2bn
}, {
  a: -0xce8e62a369a344e6cb9801f596d19f9cbc51cc8ae533cf2cbn,
  b: 0x7c9fb907n,
  r: -0xce8e62a369a344e6cb9801f596d19f9cbc51cc8add69d39c4n
}, {
  a: -0x95d68ad07535c5ec2dab0fa5ce61d257a4933d6c0bn,
  b: 0x54085eb469c695982647574dc62441075e4837642831431c53a703826fdn,
  r: 0x54085eb469c695981ce9eea0bed0e4a89b6d8669cb4b25f6d95dcfabaf2n
}, {
  a: -0xf00d9fc6461fc8078ff531e7fb60e9cec93d23d8d37f3b70n,
  b: 0xb447cb9d447a679f75af577b8df186a1e415ea8803dfc5ef2981359c5118ea3n,
  r: 0xb447cb9d447a679074d55b172bf50628e4c2cc084dd1290295aef80f1925333n
}, {
  a: -0x6b83b500f406b1e840701131192fb321b15aeb1902da37db0fd3b7170e3b4f628n,
  b: 0xd450cb5c9ba280d95b35n,
  r: -0x6b83b500f406b1e840701131192fb321b15aeb1902da2a96031ded5ce62db9af3n
}, {
  a: 0x531bf1921f4906683aa72aebe2566c64beea704ac190dc438486f7cb33150d344f77en,
  b: 0xced672n,
  r: 0x531bf1921f4906683aa72aebe2566c64beea704ac190dc438486f7cb33150d413cdf0n
}, {
  a: -0xba9e6e2edd13b191947703681c30c5847b3c5n,
  b: 0x6cb12be3d5079c62a53ede4961f336a426f903c58e78f85145331f57a8fcfcfabac8n,
  r: 0x6cb12be3d5079c62a53ede4961f336987d1220d7bd3ddf37fdc2e8d5e5f0a4b30703n
}, {
  a: -0xd70e49n,
  b: -0xfb781555a568fbcd3493ae7afcff39n,
  r: -0xfb781555a568fbcd3493ae7bd40d82n
}, {
  a: -0xec229f5b6bae5e76b928677f52c22c8cdd6fddn,
  b: 0x150870b2927f8ce92cae9d976c22f0d559255caea5977937n,
  r: 0x150870b291936a49d142ef38f569c86dd9d29a8218ba095an
}, {
  a: 0x3f04eb4d4a88388549498378c78c6f6bcb04ed6f610bfa5ebcbdb861ec4cfdn,
  b: 0n,
  r: 0x3f04eb4d4a88388549498378c78c6f6bcb04ed6f610bfa5ebcbdb861ec4cfdn
}, {
  a: -0x4e2f169f418bc74272d1b384ee572a0ae936fa5b5df8733c54083bd6dn,
  b: 0x88d31acf7fdd868127034b2c1415ce87aa8fe2a817d037822n,
  r: -0x4e2f169eb8b8ac72f2f42d03c753deded5212bd3b36890943c380454bn
}, {
  a: -0xcacbd88a55n,
  b: -0x6370a56c211fae11e98c17876a072b0b0bada1a10558bb2c8784d27024cf88a3n,
  r: -0x6370a56c211fae11e98c17876a072b0b0bada1a10558bb2c8784d33af0a812f8n
}, {
  a: -0x418ff99f0f261d6fbe6n,
  b: -0x257a1284aa8b5c7f5280512c650af2d7535792ebc3f227dan,
  r: -0x257a1284aa8b5c7f5280512c650af6f052f183de25c923c0n
}, {
  a: 0x7758d426386a5b11b30d5b4n,
  b: -0x383ed2d911c6a78c3c52be74e4c8ada957bn,
  r: -0x383ed2d911c63033682c860a89b6fa9bfc7n
}, {
  a: -0x3a749b80c7ba17280543e1b73c5n,
  b: -0x7f3n,
  r: -0x3a749b80c7ba17280543e1b7bb8n
}, {
  a: 0x401edd61df6dc66f0e51cdfb03f93c72adcca10a746ad43991398252bbc4n,
  b: -0x9491eb5ba8d59c451b773d0c30323752454474e831ddbb0cc8fe5fdn,
  r: 0x401ed418c0b80be1b48d7c439028796f8a577cb62d1c511bb588b5c2d5c7n
}, {
  a: -0x4636389n,
  b: 0x5324d5727052f27ee65830c9cc3b636fe73924d88ddae7005f8e94bd13c00n,
  r: 0x5324d5727052f27ee65830c9cc3b636fe73924d88ddae7005f8e9476dd877n
}, {
  a: 0xa89530acf2ac3d77cedb6d754e4d61f08337a7eae4fn,
  b: -0x31ea57f97062d81aef6123f7d93f8801d70a5da6a04612ca69099f113df1b80d89n,
  r: -0x31ea57f97062d81aef6123ed4fec7d32ac468629b28f3b75843380090a77395f3an
}, {
  a: 0x3c1a2ea65128c7ee504853n,
  b: 0xf58bba1f1916672cf7b4727b663a4f7f0dcfn,
  r: 0xf58bba1f1916676911e318cc8f023dcf5622n
}, {
  a: 0xab750165bb8n,
  b: 0xfef2a16015b7c24n,
  r: 0xfef34cd5171d7dcn
}, {
  a: 0x410ad78f462cd39e92dc9858cd774ab0e0c11264fff5b1c71123n,
  b: 0xca7cd3ab5621aan,
  r: 0x410ad78f462cd39e92dc9858cd774ab0e0c1132f7cc95d1d32cdn
}, {
  a: 0xaabf5d467b7415b83a5bdfe7c4afc41bff8285009795cc4abd2ae1ba12497n,
  b: 0xd9e4e0a1364503d6a0633585bfbed081b859b1n,
  r: 0xaabf5d467b7415b83a5bdff562fdce2f63d2c26a9dc924a6b917e9d597e48n
}, {
  a: 0x85d63f56c0n,
  b: -0xc6c4531c251d8fb2f9bdae362d35450d3e0df0c7c0bb5n,
  r: -0xc6c4531c251d8fb2f9bdae362d35450d3e059363cb4f5n
}, {
  a: -0x67ed9843ff88f1b2d59fd6bbf3ca3c3780324baen,
  b: -0xabfe14dbe9c61ab4370aa892ea1566an,
  r: -0x67ed98440a48d300943c3867373ae6c0aed3a218n
}, {
  a: -0xb0351e85a5281dddn,
  b: -0xdaa139ce13ee5fd019b0fc89n,
  r: -0xdaa139cec4237e55bed91a66n
}, {
  a: 0xab19b2210cn,
  b: 0x961747b8d9b945ab2d377cbcd5c555af7922c196en,
  r: 0x961747b8d9b945ab2d377cbcd5c555ba2abde3a7an
}, {
  a: 0x68175358a94699e5b66f40eb8796cc9fd7an,
  b: -0xbe0f8df8edb8bee5a52eb38c746e3f318b6db11a0f11n,
  r: -0xbe0f8df8e73749b01a9a49ee19074b22d2f444501197n
}, {
  a: -0x9b88f40d8537323718d2df682e98c68cb37931ff5ff0d13fc9365738a86c45ef044776n,
  b: -0x403eec64f4414ca8f512f7a0dceac3b81d0a45129cd5a1678ccea49ffe2f3d0d229n,
  r: -0x9b8cf7fc4b86764be3623097a8a69538eefb02a3b11a9e99dfaf2422f26c28e2d5199fn
}, {
  a: -0x9aadc184164n,
  b: 0x260a9b32a86834d21e9ad95ff5ce6bn,
  r: 0x260a9b32a86834d21e912e83dd8d07n
}, {
  a: -0x7a69792bb17c213fc7799e2ce72593365ecen,
  b: 0x3cfb2fe056d84e0615034b3483ef30ec4c2dd25cc3eeb5a8bda8800n,
  r: 0x3cfb2fe056d84e0614fba49cf134192a38315ac2e120434f8a42932n
}, {
  a: -0xdb0d717b57cc899f89860fe744299094f4802443f24454b94854144a8463a96156an,
  b: 0xb9d5c8acbn,
  r: -0xdb0d717b57cc899f89860fe744299094f4802443f24454b94854144a83a9d398a9fn
}, {
  a: 0x7265a148136f9f1n,
  b: 0x7aab1098n,
  r: 0x7265a14fbe20a89n
}, {
  a: 0x7849f49d52c154edfcd50fdf17e9800cb3a790fcd73fa97506aeb85fn,
  b: -0x42a9dea074d9f27288d5f4b88fe917n,
  r: 0x7849f49d52c154edfcd50fdf17a6d62e1332b70a64b6d3804e1ecf48n
}, {
  a: 0xd3ff2cn,
  b: -0x639af0a46246d71bc473de1a8e03n,
  r: -0x639af0a46246d71bc473dd468ed7n
}, {
  a: -0xed489aa4c15501ff1cdcbcd638410ecn,
  b: 0x50407aa991bbc6617ba42dd9d07ee575080fc654f0a3cc69e1802500874d4c6a3ddn,
  r: 0x50407aa991bbc6617ba42dd9d07ee575080ed90c55ff0b14df810823ca7714292f1n
}, {
  a: -0xc18bc31a72cf52aa91038869a74d49b4dd0e6078113a7672c2cd843db06c6343fd31dn,
  b: -0xb9f108bda1ce7abad65afbd525d3708b1bcff5ae1ae053cde5c1c160037e87c7badf8n,
  r: -0x17b7ccbd8149dcd65675e843ecd20ba3ff8de56262c1aca40a88f459db3eaeb0bb8115n
}, {
  a: 0x56cfa778227002a8fd8e11cff8f4de1098n,
  b: 0x2a62a8f8390e5e39309385ba8eb608f5afn,
  r: 0x813250705b7e60e22e21978a87aae70647n
}, {
  a: 0x9115cf2e32d465575ac72cd179n,
  b: 0x77bec0e66077e3e3edbe3130d5c19bb8d1d90dc5ben,
  r: 0x77bec0e66077e3e47ed4005f089601102ca03a9737n
}, {
  a: 0xb5060fa1735471779e38c6bb6b97d61b4b6d78ffn,
  b: 0xcad5bd54adb206e12d7dbb6e4b40e7ccf2bcdbacb4c37af3a5199d7n,
  r: 0xcad5bd54adb206ec7ddeb5858087ff46d64947636e40dca85bf12d6n
}, {
  a: -0xe15ca4734d3a8051326a59593f404e62f39d41812bdd001a51002c96d524afa27n,
  b: 0xf03af357b63384f902b920ff558cc9f3b62a19cd5b86a66fb5af622bn,
  r: -0xe15ca4733e36d11bb7072109af14bc52fe4474e1f07a5e7d7b47c22fd9c9b97fcn
}, {
  a: -0x1cc799121a753a39a1e6e97f2b7a662dafb095fd7e16b2n,
  b: 0x9c4b7273d9b6b0ad1ec203139b7ca6779159912f4e294066689904c322e7076181n,
  r: 0x9c4b7273d9b6b0ad1ec1e64c026a8c02571fef4864aa14ec026b55128ce9894acfn
}, {
  a: 0xd16a970c60a66ff630ddd486b628c969c4ab32en,
  b: 0x417c9bc68e9f60ca367f185e6201adf17262d3609d444111c817e85n,
  r: 0x417c9bc68e9f60cb07e9af6ac2a81de7a340a7e7536d0a7b8cc31b3n
}, {
  a: 0x59e2f3eaeda6dd221cda59b0ce7dc0c5a1112806dn,
  b: -0x59d1d60acc2236c8043653ffcf78346755024bf59123449aeac5f355cb1n,
  r: -0x59d1d60acc2236c803dc710be48a8d8a32e5719be054c6da2524e22dc44n
}, {
  a: -0x281f8cn,
  b: -0xa11880861ef445048982b5dbe00f564fbb831b983f1408e9bb25089c64ff283e395n,
  r: -0xa11880861ef445048982b5dbe00f564fbb831b983f1408e9bb25089c64ff2ac0321n
}, {
  a: -0x2044b53c8219147a391a4052en,
  b: 0x351b15d48718c277151cc5n,
  r: -0x2041638b24d0a2ee11a8ee869n
}, {
  a: 0x8c5d89582b5a97aa4f1e3b92984b0159c9ca6af72241e86d7ac37f1439n,
  b: 0x1d870b87717ab69c25d1836b67c603d29ebn,
  r: 0x8c5d89582b5a97aa4f1e3b9470bbb9d0e175d4b97f5a1f23f723bc3e24n
}, {
  a: 0xf8723f77cd945c292d8f4fa9d347aaa43afbd258000096n,
  b: 0xae3a42608fc5428e5b56c485d45c39786cdn,
  r: 0xf8723f77cd9f3fcd53984bfdfc2d60108359181b978763n
}, {
  a: 0x87fa01787a86450fd62b10ea0675581df06ffdd5f33bd53633992aead5n,
  b: 0xf795602cac2ae10c529e816807bd481a6n,
  r: 0x87fa01787a86450fd62b10ea15eeae20bb32abe6b865bd4cb414ff6c7bn
}, {
  a: 0n,
  b: -0xa54366eac0n,
  r: -0xa54366eac0n
}, {
  a: 0n,
  b: 0x9cd6b9n,
  r: 0x9cd6b9n
}, {
  a: 0xfa1640d2a68b5c00cceed9a52b7654f059744fbdcb3ffbba260c5bdcn,
  b: 0x43b4b9bf683a441b5cd6cf0a5edc962f777c90e831b4934bbf580402n,
  r: 0x13dcafa920ec5a01c29c5a8af8a52eb1fd0f0e0a5fcf48f05e5645fden
}, {
  a: 0xcb9884308d178508n,
  b: 0x947b6f12ed9046d8a8760b14899134783cb87a7c21990cdn,
  r: 0x947b6f12ed9046d8a8760b1489913484f640bd84f3115d5n
}, {
  a: 0x5df8aa13420be10af8d5a780n,
  b: 0x5ee7205n,
  r: 0x5df8aa13420be10afec41985n
}, {
  a: 0x55078a468e5d34f3c426f72c46ebad19e60ceec8ad261f9e96a87047f69b54eb9n,
  b: 0x261d291ce9266fb9603n,
  r: 0x55078a468e5d34f3c426f72c46ebad19e60ceec8ad261fc4b3d18d311d0b0e4bcn
}, {
  a: -0xe6018dfd4f08eb8860351577n,
  b: 0xac1a06c5n,
  r: -0xe6018dfd4f08eb87b41b0eb2n
}, {
  a: 0xa233c52c4aec0b99cn,
  b: 0x3cc9e395cb38ded14ef6c2400a6e9c64n,
  r: 0x3cc9e395cb38dedb72331504b92f5600n
}, {
  a: -0x774c8d0cefc0b56b1ea9a1d7db1e1b0ffa0c8a0829b37c4af30691n,
  b: -0x648e2ef0db3d0ad82d0bc899987a221d4b954n,
  r: -0x774c8d0cefc0b56b24f284c6e8d1ebbd7cdd4691c33b1e6cc7bfe5n
}, {
  a: -0xc6d53166a82e5e2ddf31a75e24e531205dcda734a1a83332afn,
  b: 0x776424f9975a6c7c831fb3a105df5b6880bd34d671ead5e6e5n,
  r: -0x4f710c6d10d3f1b15c11f3bd1f05d5b7dd10725e2fbd5d4bcan
}, {
  a: -0xfc6b48c3972671dc9dd3a5e7f0e361f485f222cece93d9661215611578bafe7228b7bdn,
  b: -0xf46552eb622bb95ecc0240f07f4fb56861d3b23ac15a0n,
  r: -0xfc6b48c3972671dc9dd3a5e80029b7233c14de64bb53fd751a0a5c6bfed83995d4cd5dn
}, {
  a: -0xb3d5bdbc75d0d0e13c82bcb3820093ff644896ef3474199d6e1dan,
  b: 0x55f8bn,
  r: -0xb3d5bdbc75d0d0e13c82bcb3820093ff644896ef3474199d1824fn
}, {
  a: 0xba01a2ef4cfe99a3f8ab6e72b6b14d687291f0a58n,
  b: 0xb11e4a8n,
  r: 0xba01a2ef4cfe99a3f8ab6e72b6b14d6873430ef00n
}, {
  a: -0x4d5n,
  b: 0x1901a57ec742237b30n,
  r: 0x1901a57ec74223765bn
}, {
  a: 0x317d0fe563b3221126c11e087d9a3133254d52b172305f4083n,
  b: -0x490258f3d663c5e6bd11a0232e83e4dn,
  r: 0x317d0fe563b3221126bc8de2ee5ccaf6c6e181976ffd770236n
}, {
  a: 0xdc6bd3ef6d6b81e77cb13b8a80347d93n,
  b: -0x4c7510fe909a48a7ba732da2cbd6baeb9b26c4a75b644eb349c7e134n,
  r: -0x4c7510fe909a48a7ba732da1ef6ae6fc2dbb42bfdeb31328c99363a1n
}, {
  a: -0xf121906f7bb6a873c86037c3ba6n,
  b: -0xa71eedafe1f87a68ffd7eccea651e7dfd3d421cn,
  r: -0xa71eedafe1f96b8a904768854ec5b0400b97dc2n
}, {
  a: -0x5e033f309113677a74af847a3440d4ac21523d3d121933e595n,
  b: 0x88a26bf0fn,
  r: -0x5e033f309113677a74af847a3440d4ac21523d3d098f0d2686n
}, {
  a: -0x3bfd821fb2914306d8722411faf4c7n,
  b: -0x16d3n,
  r: -0x3bfd821fb2914306d8722411fb0b9an
}, {
  a: -0x85a520bc279744f07097e38699f9f1db3e6b85d064c5acbf60abbb7162372b1951ecn,
  b: -0x5725edn,
  r: -0x85a520bc279744f07097e38699f9f1db3e6b85d064c5acbf60abbb7162372b7077d9n
}, {
  a: 0x75e3c1ee045447067den,
  b: 0xd48c6105366a661ef50807d78ceb5e0206b96d9a07e02f3a234f160c143n,
  r: 0xd48c6105366a661ef50807d78ceb5e0206b96d9a7dc3f12827a35d12921n
}, {
  a: 0x3596a9b0872c0ebef92b5e7ae50c5bcaf18bf5dn,
  b: 0xcfb5e65b121453253f15f011c4n,
  r: 0x3596a9b0872c1bba57910f9c2a3eafbc508d121n
}, {
  a: -0x73c5fn,
  b: 0xe79f9bd161fb4c22295242c62acff12e079067483f7d3bcd098f6846de6n,
  r: 0xe79f9bd161fb4c22295242c62acff12e079067483f7d3bcd098f67d3187n
}, {
  a: -0x2ffb182ee139e52cc99bca56d3f1fa62edb554e78946ad01545430aa0n,
  b: 0x1991f1b54dfa5c101febdc6en,
  r: -0x2ffb182ee139e52cc99bca56d3f1fa62ec1c35cc34670740525572e32n
}, {
  a: -0xbdd547bf11cbb665a86f7493cb18af29fbd6850b136b63b8c2c3ab0f94n,
  b: -0x132530d87011d8d55dfeb7ba43d33f5080f276b62f564e6e0ac5effn,
  r: -0xbdd67a121f52b78335c5547f46bcec5df0de94327ece591da9a4576e93n
}, {
  a: -0x49b4c4ded0e16a00a7cf5been,
  b: -0x7a2c06db4e6593caab26a342265effaa67ff240abe5cn,
  r: -0x7a2c06db4e6593caab26ecf6eb3dd08bd1ffcbda1a4an
}, {
  a: -0xb1a6a6f1172a44fca8b91fd400d98c5c76856402222af4n,
  b: -0x197cb4c7ecf515046b0930c47n,
  r: -0xb1a6a6f1172a44fca8b9216bcc260b2bc7d5aab2b5373bn
}, {
  a: -0x52e3a73e24ad1ec4ad09c9ecbd8dada731ab762fbc8b16452346n,
  b: -0x8cbf0aa00a19cbad3faa33c4830eb6f7037290637c529aa1ec6n,
  r: -0x5baf97e8254ebb7f81046d2905be9916a1e29f35f4503fef420cn
}, {
  a: 0x60435112c0c5n,
  b: 0x861de97000ba5ec00e8fd2c19b82b923cf61b1891ce81d0c5c51n,
  r: 0x861de97000ba5ec00e8fd2c19b82b923cf61b1897d2b6e1f1d16n
}, {
  a: 0x6002c58d77df3e8335be18277c28db2c1453d35c3e5fa21bf54cd00c0bd1512d496n,
  b: 0xf92f2251b3630722a943f440bn,
  r: 0x6002c58d77df3e8335be18277c28db2c1453d35c3f58d13e470033132e7a95218a1n
}, {
  a: 0x2eba94d07131df7810766e4aef4cf23a45800cn,
  b: -0xae6687300120e79ffc40eb3abffb902d1a00224abaca1e3059023ce2875d0017en,
  r: -0xae6687300120e79ffc40eb3abff8a483ccf90f2cc34916c97453481363b8a8172n
}, {
  a: 0x3a6199cb826d8a5e4beddea85d2f75fcf041eacdfcf4782n,
  b: -0xea3e2ac6fbedcc486e109c1eb7bd516616eb8814c253a85da488ff21e62169416n,
  r: -0xea3e2ac6fbedcc486dd63a84ec3ae3dbb89f9a3619f678e7a798bd37182474c94n
}, {
  a: 0xe14058n,
  b: 0xc1a27c2e5b1ccd446e5aecb65f113e69e6fae2bcb86db6d1e6e97af854bd9n,
  r: 0xc1a27c2e5b1ccd446e5aecb65f113e69e6fae2bcb86db6d1e6e97b0668c31n
}, {
  a: -0xd7916n,
  b: -0x1d069569eea260abb5e99c00859n,
  r: -0x1d069569eea260abb5e99cd816fn
}, {
  a: -0x679fc14f9614105c8535c0ccbe198897255667c68fn,
  b: 0x8c380bf0a1b521f0a3b756f3a11n,
  r: -0x679fc14f96141053c1b501c2a2c7698ce9e0f88c7en
}, {
  a: -0xb6d2759fn,
  b: -0xf71390c9ca8f09822n,
  r: -0xf71390c9d5fc30dc1n
}, {
  a: -0xe6bn,
  b: 0xbb62e3934413n,
  r: 0xbb62e39335a8n
}, {
  a: -0x4ec7623dn,
  b: -0xbe3d6a00bb9617d03ee21n,
  r: -0xbe3d6a00bb961cbcb505en
}, {
  a: -0xdf6e6f2ab3de9afaa35728eb576fd383731e7bn,
  b: 0xb988a5281f1b0d5d42808d9263a02fd93f8521dcbf0252n,
  r: 0xb988a5273fac9e328ea1f297c04906ede8154e594be3d7n
}, {
  a: -0x369ff12n,
  b: -0xf4f033aa7eb940e035a5676caaa3bd1f9221429ad34en,
  r: -0xf4f033aa7eb940e035a5676caaa3bd1f92214604d260n
}, {
  a: -0x3a0893f64d51997708a1176a239f1636326ecac834a7b6c08976b18eba20770a0n,
  b: 0x9cdba63343fc13e0c6ad46bf42f7fdb2bf5a3f3b2fdd7924a0ce31e3e4d4b26f9290f4n,
  r: 0x9cdba292babcaf0bad15d63531815b78cdf6dc144330f5da2562294c79bbc6cd8b2054n
}, {
  a: 0x17a3879b67098c58f7053cbf149cde94b330c6dc23229be5f4cf33c9a6ea03eefc2291n,
  b: -0x7811b971613666aee53a81f9325d3eddcba2dcdf893ce8bb2a892n,
  r: 0x17a3879b67098c58ef842127fe897829c4dd1ebc8ffcc7f8181505fbae5635634979ffn
}, {
  a: -0x7b1ebb6228502816d853e7ac7b2ce07f56fdbc010c3a73f18a442e3n,
  b: 0x8896c1670552a7a672e4b59954b9f3a48694f1f41a823862n,
  r: -0x7b1ebb599ee411a683296d454ce186ea0b5e81b8a2eb54afe220a81n
}, {
  a: 0xbb77d695c68130930741cf1361365644n,
  b: 0x2dfe69a86473dc9e2465f487039ee5f324c7f54eb02bn,
  r: 0x2dfe69a864749815fafbbb083431ed34f3db5685066fn
}, {
  a: -0x13ecc93fb1dn,
  b: -0xc0dbb0c3f8f24e586acd6fa87ba83037c0d7569c1a5d6fca9d72597c5e57n,
  r: -0xc0dbb0c3f8f24e586acd6fa87ba83037c0d7569c1a5d6fca9eb126105974n
}, {
  a: -0xf299c458adn,
  b: -0xf9980aed24bf5116ac056fed10ae882e981b61aa17f8b9a5670287c6f0c1a64119n,
  r: -0xf9980aed24bf5116ac056fed10ae882e981b61aa17f8b9a5670287c7e35b6a99c6n
}, {
  a: -0xca3d57affbe2ce37a95f6003da1dc69a0ec20c80703906f7d7283fb18e09083n,
  b: -0xe39b3d12804bda24625d66243aa60e5bdf59f3fe1fb5d7d6f9bedn,
  r: -0xca3d57affcc66974bbdfabddfe80240032fcb28ecc1860ebd547f5896502c70n
}, {
  a: -0xa0d97d728d98e2e9b6b3n,
  b: -0x1281e0ef809197b200a9fe02e0ba6en,
  r: -0x1281e0ef8132712f733796e5ca7121n
}, {
  a: -0x94dceb26282a8382de311212d8a04fe35a099b9ad833c4226bdbfefee08fc1727fd756n,
  b: -0xf78cb62714194n,
  r: -0x94dceb26282a8382de311212d8a04fe35a099b9ad833c4226bdbfefef0088cd4f118ean
}, {
  a: 0xfd659d91c6d54c5f6e6689aca66cc6d3cdfc6a0f44f0f1dbdn,
  b: 0xdda4fbc534850d50ba0854304d04a3675778b0a9b22537b95f5c2e69cd7n,
  r: 0xdda4fbc5358272ee4bcf297cac7309f1041f1d7085f334236ea11f5ba94n
}, {
  a: -0xb8n,
  b: 0x707334ac19dd2e50ee38d820f07b3479b434b52775e9b78ea1dan,
  r: 0x707334ac19dd2e50ee38d820f07b3479b434b52775e9b78ea122n
}, {
  a: 0x66a0a225281ff83f08f8b27567c24f0d8e4a91a93444a630bn,
  b: -0xe5648d0dc0cf59f13d1893c4362f6fe0591361ad6659d3db1n,
  r: -0x7ec3eae898af61b2341fe14ece6d20d2cac8d00432152daa6n
}, {
  a: 0xb3dbcd1babd5bb6084d325364n,
  b: -0xded1c2dbcn,
  r: 0xb3dbcd1babd5bb5fa601625a8n
}, {
  a: -0x865be1a05b91755932f1d2ac99978770d9030183ad210e4c3a6a1b8503c584a21e75n,
  b: 0x854e4b65137ab4n,
  r: -0x865be1a05b91755932f1d2ac99978770d9030183ad210e4c3a6a1affb57a1f8ea3c1n
}, {
  a: 0x7cn,
  b: 0xan,
  r: 0x86n
}, {
  a: -0x8d3ea8d33154e1cb36ffb23936efc837e499a057622e5e4c75b50c4f8fac6n,
  b: -0xe99f1cedea8963503233196590d387eb2981f5c483f3ef3f1bd6dn,
  r: -0x8d3ea8d41af3feb9218915896922e19d756d28428bb05410f9a8fb8eab833n
}, {
  a: 0xeddd9fff5d499784ccb3d9e316ed6adf9904d40111db87dee8adn,
  b: 0xafcaf916275ba26e623df0ea414b5002a0ccedcb9bad5fn,
  r: 0xeddda0af2842adac2856484554de5520e454d6a1dec9537a960cn
}, {
  a: -0x9f2bf61af5165c0e70b5eb99a0c489c54e706c63af24f4480ff56f85dfffn,
  b: -0x6de9acc3e84664de3b8b44fe2d46fc724fbf53d14dffa38d74cb84fa89f7beban,
  r: -0x6dea4befde6159f49799b5b418e09d36d984a241ba6352b2691394eff97d9eb9n
}, {
  a: 0xfc14785f7d8d6ed22c76767eeb2748e2n,
  b: -0xb17e416f84bc57e4cac595e831bab780n,
  r: 0x4a9636eff8d116ed61b0e096b96c9162n
}, {
  a: 0x8d4d2135e6f659b492a9ad85c71d935c9c6240bffdc1ea367f74756en,
  b: 0xdc44d0e17ee485n,
  r: 0x8d4d2135e6f659b492a9ad85c71d935c9c6240bffe9e2f0760f359f3n
}, {
  a: -0xe76ba9504bad1a435425dba2d4n,
  b: 0x8c6dac7ffd6cn,
  r: -0xe76ba9504bad19b6e6795ba568n
}, {
  a: -0x90c2a684e87f3a918455fcde9204853ec2c5b5d5n,
  b: 0xc1aed702b79d71c51569beef2ec491ac868e2727c071dn,
  r: 0xc1aecdf68d35233d21c0a6a9cef6a88c3e3a3afb65148n
}, {
  a: 0xb7f6e06c89255f1c26248fd42254n,
  b: -0x203ec7f11a7c43f7396490728feec684ca026eea3d12e32f9f923e4fdcn,
  r: -0x203ec7f11a7c43f7396490728feec5ccd322026117b3c7097b026a2d88n
}, {
  a: 0x11531ef3fc82b548bf29c44dc57b067bcab1768754906d63de0e794da4d0378n,
  b: 0x61604da92c86694n,
  r: 0x11531ef3fc82b548bf29c44dc57b067bcab1768754906d643f6ec6f6d156a0cn
}, {
  a: -0x1d3522a8ac059901e2a0be4ea9ed2n,
  b: -0x50601bed616d4d57a2abe82c3259c37b4d8607fcd4130ca06e962f63aa0eab91bfb550n,
  r: -0x50601bed616d4d57a2abe82c3259c37b4d8607fcd5e65ecaf95688f3c838b776aa5422n
}, {
  a: 0x8e6fe5617f2b3cadd63a1003ca64d0ced044dn,
  b: 0x3f675ebe0b1e4d9b017a0e7aba97773a5f1b30bc1a4f3f51n,
  r: 0x3f675ebe0b2734995792012e8574dadb5f57d709273c439en
}, {
  a: 0x446aec4b53cbd61f2f244b132n,
  b: -0x56638b7d6n,
  r: 0x446aec4b53cbd61ed8c0bf95cn
}, {
  a: 0x58a8b08b2ea264ff88312c5n,
  b: -0x3a4dd54c449f2n,
  r: 0x58a8b08b2e68172a3bec8d3n
}, {
  a: 0x75d0dab0b7c015c44b71d0d4a5e537bd0210b9923a67a09b6523005c82e9dddae49n,
  b: 0xc1a65eaaf0c91931beb6a6d4e86df08bac82d33n,
  r: 0x75d0dab0b7c015c44b71d0d4a5e5f96360bbaa5b53995f520bf7e8ca73758a5db7cn
}, {
  a: 0xda337abe6e00n,
  b: 0x57f2f65c9516c2eea21688e18881c97781fn,
  r: 0x57f2f65c9516c2eea21688ef2bb9755e61fn
}, {
  a: 0xc2f523cc06784cb59feb513edee5c4ca074f2210415a32a7fbc6244d97449300n,
  b: -0x25f556b1319d37f74faan,
  r: 0xc2f523cc06784cb59feb513edee5c4ca074f2210415a0cb2a514f2b05f4d4356n
}, {
  a: 0xe8876712466bb74eaff35a0558866494bf4f903fb204c8a6en,
  b: -0xa78020c994eb369ef3ff5892696n,
  r: 0xe8876712466bb74eaff3595dd8659affd418f14bb2ac363d8n
}, {
  a: -0xe67cf6dfc7088a2de5fb00e3625754167bec7ca4e348247c5fe86n,
  b: 0x39e33b0b168651d772027283c7cda1659dbd6e5fn,
  r: -0xe67cf6dfc708868fb24a4f7afd39dcf654c440280931caa089027n
}, {
  a: -0x4e8n,
  b: 0x65e690a822c0fd52981a0f2e42dc59b23eff2308f2n,
  r: 0x65e690a822c0fd52981a0f2e42dc59b23eff23040an
}, {
  a: -0x7b6d7388c36dad30ad15522cc8855f03f4c73239cc8b8n,
  b: -0x73e4e562c60c04525ef975aa9d49afe8n,
  r: -0x7b6d7388c36db46efb6b7e8d88ca84f38c21dc0e678a0n
}, {
  a: -0xfaf1662a9307e415a3e0n,
  b: 0x760816cbfc29f0cb4acc92971de9e63fca4553c6346bcb391406fca0bfc1491080dn,
  r: 0x760816cbfc29f0cb4acc92971de9e63fca4553c6346bcb2964f099f78f4307b642dn
}, {
  a: -0xbf5664defed7bc7ae4n,
  b: -0xd904c6ffe5765688a78e048482346367ccc534209686b4a17174ae0n,
  r: -0xd904c6ffe5765688a78e048482346367ccc54015fcd4a48eed3c5c4n
}, {
  a: 0xf1352f3f2aa39ecafbe6b206c68a41n,
  b: 0xc603cdc0781dd4n,
  r: 0xf1352f3f2aa39ecbc1ea7fc73ea815n
}, {
  a: -0x7e715b3166n,
  b: -0x6d544an,
  r: -0x7e71c885b0n
}, {
  a: -0x827cccc19817ccc8bbc4866986de7dd0n,
  b: 0xc56ed5c54119c0548e5b995a401e9e0e9d2a9d0742faf6445003ec1d6n,
  r: 0xc56ed5c54119c0548e5b995a37f6d14283a9203ab73eadddb79604406n
}, {
  a: 0x2be68171f2645eb55b4dfae10f12129bf8bdc3a1862c62n,
  b: 0x63baa9d2eb813b1926bfb059c1450686764b141492c7a6f9394ef7n,
  r: 0x63baa9d31767bc8b19240f0f1c930167855d26b08b856a9abf7b59n
}, {
  a: -0xeabc4950en,
  b: -0x2adc0n,
  r: -0xeabc742cen
}, {
  a: -0xac021822ed425bacb6c0n,
  b: 0xf50d2f46478b8a35c42e1d3081984f390228c31a53138753e9fbff2bdb9c4f3e3e3an,
  r: 0xf50d2f46478b8a35c42e1d3081984f390228c31a531387533df9e708ee59f391877an
}, {
  a: 0xe07339c0ff7850dd063dbn,
  b: 0x96219cda231d63e5262d7df839b7bd5fe1298c7a73282ae46ac1712c8b4n,
  r: 0x96219cda231d63e5262d7df839b7bd5fe1298d5ae661ebe3e3124e32c8fn
}, {
  a: -0x43facd760f6f436ed201e73aea6eeb14319fd06c46e02122cn,
  b: 0xef0a00ae4f70cc52n,
  r: -0x43facd760f6f436ed201e73aea6eeb1422af306161e9145dan
}, {
  a: -0x7c07aff9a403493a81e86eaf7d4de13bb10n,
  b: 0xdb5060221c5dd9f0cac254715384ba890d3bb0fe31e33f12c8d58c63d62ea02aen,
  r: 0xdb5060221c5dd9f0cac254715384ba0d058bb75a2e9a0490e066dce6884d6479en
}, {
  a: 0xae5196c8ed4fcf551e4eea41248fd79e03d6f8e8b60afb29dd5n,
  b: 0xf7af759f366b046065d86a4f1c83n,
  r: 0xae5196c8ed4fcf551e4eea509f8731916a873eef1391a01ba58n
}, {
  a: -0x47ba82b44ea23b7a5b44n,
  b: 0xa9b531482188253f3b7a48128n,
  r: 0xa9b52ccc795ce05517c2a25e4n
}, {
  a: -0x1b253f3db5eecfb3df96523ab75a164783b0eb42af879n,
  b: 0x2be599cn,
  r: -0x1b253f3db5eecfb3df96523ab75a164783b0eb16c9eddn
}, {
  a: -0xcb885c219e0737e8e6c18ca1n,
  b: 0x532a9671e02c5d06a0e4e40bac2e6e208f84n,
  r: 0x532a9671e02b917e44c346047445875f02e3n
}, {
  a: -0x6787e95ae442eecbc1abc3639n,
  b: 0x643adf055dc23b2bf5208337fa417e464917d8d919f6c2n,
  r: 0x643adf055dc23b2bf5207cbf7babd0021a2b1cbe5dc089n
}, {
  a: 0xa3n,
  b: 0x72fcba1ed1ecb08f84a0f38e0946f8bd820b404c67545c1bc10ad0dfcdn,
  r: 0x72fcba1ed1ecb08f84a0f38e0946f8bd820b404c67545c1bc10ad0e070n
}, {
  a: -0x63c3db1792f675d66d14d7caa745df2e6d32n,
  b: 0x671fen,
  r: -0x63c3db1792f675d66d14d7caa745df27fb34n
}, {
  a: 0xc8b14b781f7b2836e3f303e591e88c93482n,
  b: -0x1ac0f669318dc4d34dcb90f420cf5c71d10422fd439f2a4662e87d11ad9n,
  r: -0x1ac0f669318dc4d34dcb90f3581e10f9b188fac65fac2660d0fff07e657n
}, {
  a: -0x7a5ab4d72ebb5a37b64c520112cebdc3ee48c63d571ba0n,
  b: 0x1174c7b3ee75db243b7ce8512dfec24c8db39202ce7c368a3fn,
  r: 0x11744d59399eac68e1453204dbfdaf7dcfefa3ba083edf6e9fn
}, {
  a: -0x3f0f71804a98480bb88b0742bd9fc5fd9013cn,
  b: -0x9d8d609575798a9304e420n,
  r: -0x3f0f71804a9848159161109a15386f2dde55cn
}, {
  a: 0xce889469598a84n,
  b: -0x5b2db1015242d1f3dc17fcb89168645163a8c546n,
  r: -0x5b2db1015242d1f3dc17fcb89099dbbcfa4f3ac2n
}, {
  a: -0xc7e3a298ea4352d531834bn,
  b: -0xbd2440816a1701dn,
  r: -0xc7e3a2a4bc875aebd2f368n
}, {
  a: 0x49ca1619e142a720c1f61n,
  b: 0xfe659dda9670e96n,
  r: 0x49ca171846e081b732df7n
}, {
  a: -0xddfa8n,
  b: 0x7279bcc8a446ddea1a412bc11b2a2729193dfb4b459n,
  r: 0x7279bcc8a446ddea1a412bc11b2a2729193dfa6d4b1n
}, {
  a: -0x82512030c7d25d728e908a701491a8b4n,
  b: 0xfa1613c2c98965656612bd496dn,
  r: -0x82511f36b1be9aa9052b250a01d45f47n
}, {
  a: 0x85416e1bffeeaa27415917e9957f9d38582f6de3f0b0e36e5dc2b08b5aeda8cn,
  b: 0xe3cfa349d459ceccd05182dd6de31f13n,
  r: 0x85416e1bffeeaa27415917e9957f9d469529a281364dd03b62dade62391f99fn
}, {
  a: -0xe45bc1701fd62c596b6124a39aa11fd884dn,
  b: -0xc45740e51f8dbfc1e51d5386270cb790131e987d6f93cb80ea3eb61n,
  r: -0xc45740e51f8dbfc1e51e37e1e87cd7663f7803de943766220a173aen
}, {
  a: -0xd9c73c8bae50c6185e00c76284b2cc122820977cn,
  b: -0xed98190fadcf46c02071dd84b027f4d1c732eee59f6a856ecdf6ce0f597cf26c9e7936n,
  r: -0xed98190fadcf46c02071dd84b027f5ab8e6f7a93f0309dcccebe30940c490494bf10b2n
}, {
  a: -0x6n,
  b: -0x32176n,
  r: -0x3217cn
}, {
  a: 0xffc792b5c401ef0eaa10e890ee03ef0bafaff440c65565df37450n,
  b: 0xe16b6d2735cfbaf1b4344aab01cn,
  r: 0xffc792b5c401ef0eaa10e890eee55a78d6e5c3fbb8099a29e246cn
}, {
  a: 0xf33d52d3a765fc139f69eb589fb6c04f4ec671dee044251453816e2d3ccdn,
  b: 0xeab035110762e0e67273ca9e068ef86d5fd0d71d344611481d2341b4a072ba62cn,
  r: 0xeab04444dc901b5cd2350494a5448268cbd5cc099b63ff4c5f7486ecb7558e2f9n
}, {
  a: -0xebea1ef889b0d273da63d11ceb819525de9291072ee08a8fn,
  b: -0xe34fb05c9e4d428f2779679dba8a81f7fe3fb92738ee492d85e9218d2a5a29a54fn,
  r: -0xe34fb05c9e4d428f286551bcb31432ca721a1cf855d9cac2abc7b41e31890a2fden
}, {
  a: -0xc9ca1e0889b471c0a9af2d2fd4ae2768db4b484b2a3a1cbac1e54n,
  b: -0xf9c2d26526f9ca6a9b05c65456ebbce3abc981543cc456e4f1b8a30399dn,
  r: -0xf9c2d32ef117d2f44f7786fe0618ecb859f0ea2f880ca20f2bd55dc57f1n
}, {
  a: -0xan,
  b: -0xd4558fca8a3ad9c9can,
  r: -0xd4558fca8a3ad9c9d4n
}, {
  a: -0x56cb692e2d5da5caa6ab5dc6966ee1a8n,
  b: 0xe11f4f90b819db0eb22ea6506f36134fb44920e0eff31894cc1d9234n,
  r: 0xe11f4f90b819db0eb22ea650186aaa2186eb7b164947bace35aeb08cn
}, {
  a: -0x97c9607d266ca0bb622d0e8d24b965212b01bb8fdb46bdea29241786e5ac476n,
  b: -0x2fce23baddd73d17d401022d83062ec5ddb95a720a060a39d87fc3n,
  r: -0x97c9607d296982f7100a825ea1f9754403321e7c3922539149c4782a8334439n
}, {
  a: 0xdde02a7e5e6ccfb2f449d722n,
  b: -0xbdf1b3218fb10eea6n,
  r: 0xdde02a727f519d99f938e87cn
}, {
  a: 0xcfd4bbe2807319c54dcad6af03e4n,
  b: -0x89232269d8c76aa9a309d4e572d27387b8208a5bcdf6f04b300d6ceb240n,
  r: -0x89232269d8c76aa9a309d4e572d2737abad4cc33c6c553f6536001fae5cn
}, {
  a: -0x27154b2a951d46aedf6c2890db522cf925b82e41d9096a14n,
  b: 0xfd0d5ab8066043eb4d508a700f818f6c39734470n,
  r: -0x27154b29980febf6d90be4a58e01a28916369ed59f9625a4n
}, {
  a: 0x58ffd62a014fdeddf6a986a6a1936en,
  b: -0xdcdb21bcb5a4f16ffba93e7aab271f4373639b81124864cca9e14d92443n,
  r: -0xdcdb21bcb5a4f16ffba93e7aab2719b37600fb6c145a85621176e3790d5n
}, {
  a: -0x7f05beb2c8b3ec1284060daf7dc69c5ef754de7818770n,
  b: 0xb039cd62ea9261e52663d081b9103e42ban,
  r: -0x7f05beb2c8a8e875add764895f743621ef394d74344b6n
}, {
  a: -0x96a67588b8fcb8n,
  b: -0x8520cd83e683f2d5d67308c80a147652df17d85176fba78cn,
  r: -0x8520cd83e683f2d5d67308c80a147652dfae7ec6ffb4a444n
}, {
  a: 0x75977089e9ec40ab6512a84dad2f6167f82b694e9a4d7870c623a17f033894en,
  b: 0x2c6bf4cd1aan,
  r: 0x75977089e9ec40ab6512a84dad2f6167f82b694e9a4d7870c623cdeaf805af8n
}, {
  a: 0x345b198bd3f1bd1cd76n,
  b: 0n,
  r: 0x345b198bd3f1bd1cd76n
}, {
  a: 0xf9cd68b938a20cf2cc5067ea9961b8db84171e8e798fa9ddd47n,
  b: -0xc9d17c00a8b2747347dd2e7d067464508672a1115612c1n,
  r: 0xf9cd5c1c20e20267a509336cc679e8743dd216274f7e947ca86n
}, {
  a: -0xb074bd216c64cd3d54270c05efde3a76972c054fc02fad45aa58n,
  b: -0xd56aa120efc0ffc3b6dad72a36db5faa5d782f654fn,
  r: -0xb074bd216d3a37de7516cd05b395154dc162e0af6a8d25750fa7n
}, {
  a: -0x62ff016366e504610139714920n,
  b: 0x3c34f3071d851688246fb2507fa94662f158cdc9ca81a952a9158035eb7509917749n,
  r: 0x3c34f3071d851688246fb2507fa94662f158cdc9ca1eaa5145ae9b318a73d0202e29n
}, {
  a: -0xcd2fc62743173779791bc442c6ba310c2b3528b2a73e7a925bdb504cf156c83c6472n,
  b: 0x181249168c6f6fb37d9548fbf6cc6551edce431e8159ca8ac84n,
  r: -0xcd2fc62743173779779a9fb15df33a10f35bd422e7d1b43d3cfe6c1b09412b93b7een
}, {
  a: 0x2276ee176ab88fea8cdc4d60d88b1021cadca166d1cf3ee660n,
  b: -0xb344ee9978fea934b38147c3839978870e749d005edc6bf889d4530c871498ebn,
  r: -0xb344ee9978fea9123c933058cb098dfa32273c27d3cc4a2dad32ec3ab7d5b28bn
}, {
  a: 0xf2b20dafcf864ceee4be74dcdb7107543740d3c5f6e026f597e370f9eb084cfn,
  b: 0x1ee36947390114a4dd5e8849420f42aa3d34334585116435005388c6368c9dd319n,
  r: 0x1ef2946813fe0d09ac4cd4308fdcf9bab277a752c170d2376fad06fd462b4e57e8n
}, {
  a: -0x4ffc604bfbd2567841989ffc85aabbd3524f216940df8fb60c8e0a18954n,
  b: -0x26d9c51cef8b120ab2c3a64887cn,
  r: -0x4ffc604bfbd2567841989ffc85aabbd37928e686306aa1c0bf51b0611d0n
}, {
  a: -0x114085n,
  b: 0x8ad30d73f7a4747c2f328e961c451a2483885bda4d61319576e6n,
  r: 0x8ad30d73f7a4747c2f328e961c451a2483885bda4d6131843661n
}, {
  a: -0x72c2n,
  b: -0xd9db08cad639d2271239c49b7f8304004f222d56aa851n,
  r: -0xd9db08cad639d2271239c49b7f8304004f222d56b1b13n
}, {
  a: 0xaceb7d2eac0d4d5842bc46de548208bedcb190c4ce37f9777bde66fbn,
  b: 0x6n,
  r: 0xaceb7d2eac0d4d5842bc46de548208bedcb190c4ce37f9777bde6701n
}, {
  a: 0xea516fe0630b959e9aan,
  b: 0x2cac0792e419d83ad337a8693fe833aeb0e102df576b42n,
  r: 0x2cac0792e419d83ad337a8693ff6d8c5aee73398b154ecn
}, {
  a: 0x211afc041d76bc1dbd273c58fe2be7e731115d04638ab41dec58e4fc748ab7n,
  b: 0xf5f9754b950cd4ebc63aee92b638793c59da26d15b9c4an,
  r: 0x211afc041d76bc1eb320b1a49338bcd2f74c4b9719c32d5a46330bcdd02701n
}, {
  a: -0x4d43efe678b295d9be3dc3277a41130bb6496a67ef6cb5n,
  b: 0x117an,
  r: -0x4d43efe678b295d9be3dc3277a41130bb6496a67ef5b3bn
}, {
  a: 0xd023e82n,
  b: 0xdbb9bbec3f7182a09f341335f51f3199c99c9aedccda0n,
  r: 0xdbb9bbec3f7182a09f341335f51f3199c99c9bbdf0c22n
}, {
  a: 0xde33b9c1497de6d6b891457d4e8e7b40ddc91f60n,
  b: 0x4d47076af3bb8ed969733dd6n,
  r: 0xde33b9c1497de6d705d84ce8424a0a1a473c5d36n
}, {
  a: -0x5142a904065a44e7a0c03f7bcc3ff77e0f03742840dab7f09242n,
  b: 0x962fd3ddcc57f0fcfca8bcbc735d0a40e2c5d57a38395e9836b3601bd561fa6cn,
  r: 0x962fd3ddcc579fba53a4b6622e756980a34a093a40bb4f94c28b1f411d71682an
}, {
  a: -0x7e9dcd4f5fec283fa35053dd7e58f51637341c23dbc5624414e430n,
  b: -0xe178a893e9d4b789cfd3aabf8c6cdd81656120050n,
  r: -0x7e9dcd4f5fec36572dd9927ac9d1921371e014eaa99d789a26e480n
}, {
  a: -0x9bb135d99e59c71e18072an,
  b: -0x2490d9065080450b1dc647762b1bdf8caa2f637b1dbn,
  r: -0x2490d9065080450b1dc651313e79797246a144fb905n
}, {
  a: 0xd87291a64379a2f5ad71bb225777fb556c46dd230b19n,
  b: -0x9cbff426b0fe6155a53888011fc3ef747628b2an,
  r: 0xd87287da443737e5c75c60cecef7e9592d4f95c07fefn
}, {
  a: 0xc9c0n,
  b: -0xe78a0adn,
  r: -0xe77d6edn
}, {
  a: -0x3fea9c98f60b6751fb7f41cfa0efn,
  b: -0x935b3cf1fb6091b913c29ab138da82b7ce1665fdn,
  r: -0x935b3cf1fb60d1a3b05b90bca02c7e370fe606ecn
}, {
  a: -0x78db60e05ee2ad5e6bdn,
  b: -0xa174995b5f7d450a7cb589d94e818633e51df760fdaean,
  r: -0xa174995b5f7d450a7cb589d94efa6194c57cda0e5c1a7n
}, {
  a: 0xa9154aab64bbbn,
  b: 0xd9267247025c6a1cb185a2fa4761d7c0131ee19a2795446f80bfedc400f4e13615e2n,
  r: 0xd9267247025c6a1cb185a2fa4761d7c0131ee19a2795446f80bfedce92498bec619dn
}, {
  a: -0xb14a78an,
  b: -0x2078ef38b52813582efc4bb21a86bbb0d7f72e62125a133a49n,
  r: -0x2078ef38b52813582efc4bb21a86bbb0d7f72e62126527e1d3n
}, {
  a: -0x6146f1416d6n,
  b: -0x2a9a99b86a244b89352fea54e596e2f63d72n,
  r: -0x2a9a99b86a244b89352fea54ebab520a5448n
}, {
  a: 0xa1934d06099b73a2e63a6b2705281633d437cebb4496bf5d8fd85dd1be6b9558n,
  b: 0x8f51838a4999b08531c4fd7615b9e369571e6408ae25c1b747ae5c0d4n,
  r: 0xa1934d0efeb3ac477fd5737a2177ed952fd60550b67cffe8723479463951562cn
}, {
  a: -0x1afc3933f465008f9e371220c0b34a251308n,
  b: 0x5ac88cc255af9ab9adb7d8abd01fb87a3e5ef224d1d5112d4555bfc0n,
  r: 0x5ac88cc255af9ab9adb7bdaf96ebc4153dcf53edbfb45079fb30acb8n
}, {
  a: 0x1ea405636cc42eb4f02ced6fa24f6abn,
  b: 0x3an,
  r: 0x1ea405636cc42eb4f02ced6fa24f6e5n
}, {
  a: 0xcd828c8b2631277ef23fe6fa174dd9f17c4cn,
  b: -0xfb5f58e9e889e9fb3dc7dfa524894a5eb663n,
  r: -0x2ddccc5ec258c27c4b87f8ab0d3b706d3a17n
}, {
  a: -0xc0dca18868fe2a7b5e45cn,
  b: 0x76c2e96ea11864212cn,
  r: -0xc0d53559d21418f51c330n
}, {
  a: 0x95e7106ee78ea114de2004a95a215fb24a80cb512ae7fn,
  b: 0x948b2bb30a81b7b3aa355de6n,
  r: 0x95e7106ee78ea114de200df20cdc905a65fc05f480c65n
}, {
  a: 0xc2f5896352468532e380aaea981ad56a4n,
  b: -0x86e023cf8a448faan,
  r: 0xc2f5896352468532db12a8ad9f768c6fan
}, {
  a: -0x4ea9a39e76n,
  b: 0x6e0d59cb15634f8a02b2e28a7896n,
  r: 0x6e0d59cb15634f8a026438e6da20n
}, {
  a: 0x9bf562676b90cb90020232fce4b9007552affdeb4fan,
  b: -0xc9e33b79bb9125991fbc49d40fa01a12b9b20e7b21d83n,
  r: -0xc9474617542594cd8fba47a112bb6112445f5e7d36889n
}, {
  a: 0xbe38663e21145cc99495ba1e5ce2ec03b347f4f439fbc4ca21n,
  b: -0xaa25ee1d6a777dcde0ed36f3472c106fd7n,
  r: 0xbe38663e21145cc8ea6fcc00f26b6e35d25abe00f2cfb45a4an
}, {
  a: 0xadd95542b6a1b838f9an,
  b: 0x8961d5f334c83296d6d4057d603cf234a6c3cd198ed0ac54d74104be0bef3n,
  r: 0x8961d5f334c83296d6d4057d603cf234a6c3cd198f7e85aa19f7a67644e8dn
}, {
  a: 0x181f9d2eb51eedce49299f7f3e4fc72056c0c94925e83n,
  b: 0xa0c08f7862d8e4756ec1e84c27e9779744d7fdc46a0c62927de75f74d62ffd2239d1n,
  r: 0xa0c08f7862d8e4756ec1e84da9e34a8296c6daa8fca65a8662e3d17a423c91b49854n
}];

var error_count = 0;
for (var i = 0; i < data.length; i++) {
  var d = data[i];
  var r = d.a + d.b;
  if (d.r !== r) {
    print("Input A:  " + d.a.toString(16));
    print("Input B:  " + d.b.toString(16));
    print("Result:   " + r.toString(16));
    print("Expected: " + d.r);
    print("Op: +");
    error_count++;
  }
}
if (error_count !== 0)
  throw new Error("Finished with " + error_count + " errors.")

