/******************************************************************************
**
** Copyright (C) 2015 The Qt Company Ltd.
** Contact: http://www.qt.io/licensing/
**
** This file is part of the Qt Virtual Keyboard module.
**
** $QT_BEGIN_LICENSE:COMM$
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see http://www.qt.io/terms-conditions. For further
** information use the contact form at http://www.qt.io/contact-us.
**
** $QT_END_LICENSE$
**
******************************************************************************/

import QtQuick 2.0
import QtQuick.VirtualKeyboard 2.1
import QtQuick.Layouts 1.0

KeyboardLayoutLoader {
    sourceComponent: ((InputContext.inputMethodHints & Qt.ImhPreferUppercase) && ( InputContext.inputMethodHints & Qt.ImhNoAutoUppercase )) ? page2:page1;
    Component {
        id: page1
        KeyboardLayout {
            inputMode: InputEngine.Latin
            keyWeight: 152
            spacing: 0
            KeyboardRow {
                Layout.minimumHeight: 71
                Key {
                    key: Qt.Key_A
                    text: "a"
                }
                Key {
                    key: Qt.Key_B
                    text: "b"
                }
                Key {
                    key: Qt.Key_C
                    text: "c"
                }
                Key {
                    key: Qt.Key_D
                    text: "d"
                }
                Key {
                    key: Qt.Key_E
                    text: "e"
                }
                Key {
                    key: Qt.Key_F
                    text: "f"
                }
                Key {
                    key: Qt.Key_G
                    text: "g"
                }
                Key {
                    key: Qt.Key_H
                    text: "h"
                }
                Key {
                    key: Qt.Key_I
                    text: "i"
                }
                Key {
                    key: Qt.Key_J
                    text: "j"
                }
                FillerKey {
                    weight: 32
                }
                Key {
                    key: Qt.Key_1
                    text: "1"
                }
                Key {
                    key: Qt.Key_2
                    text: "2"
                }
                Key {
                    key: Qt.Key_3
                    text: "3"
                }
                Key {
                    key: Qt.Key_4
                    text: "4"
                }
                Key {
                    key: Qt.Key_5
                    text: "5"
                }
            }
            KeyboardRow {
                Layout.minimumHeight: 71

                Key {
                    key: Qt.Key_K
                    text: "k"
                }
                Key {
                    key: Qt.Key_L
                    text: "l"
                }
                Key {
                    key: Qt.Key_M
                    text: "m"
                }
                Key {
                    key: Qt.Key_N
                    text: "n"
                }
                Key {
                    key: Qt.Key_O
                    text: "o"
                }
                Key {
                    key: Qt.Key_P
                    text: "p"
                }
                Key {
                    key: Qt.Key_Q
                    text: "q"
                }
                Key {
                    key: Qt.Key_R
                    text: "r"
                }
                Key {
                    key: Qt.Key_S
                    text: "s"
                }
                Key {
                    key: Qt.Key_T
                    text: "t"
                }
                FillerKey {
                    weight: 32
                }

                Key {
                    key: Qt.Key_6
                    text: "6"
                }
                Key {
                    key: Qt.Key_7
                    text: "7"
                }
                Key {
                    key: Qt.Key_8
                    text: "8"
                }
                Key {
                    key: Qt.Key_9
                    text: "9"
                }
                Key {
                    key: Qt.Key_0
                    text: "0"
                }
            }

             KeyboardRow {
                Layout.minimumHeight: 71

                Key {
                    key: Qt.Key_U
                    text: "u"
                }
                Key {
                    key: Qt.Key_V
                    text: "v"
                }
                Key {
                    key: Qt.Key_W
                    text: "w"
                }
                Key {
                    key: Qt.Key_X
                    text: "x"
                }
                Key {
                    key: Qt.Key_Y
                    text: "y"
                }
                Key {
                    key: Qt.Key_Z
                    text: "z"
                }
                Key {
                    key: Qt.Key_Odiaeresis
                    text: "ö"
                }
                Key {
                    key: Qt.Key_Udiaeresis
                    text: "ü"
                }
                Key {
                    key: Qt.Key_Adiaeresis
                    text: "ä"
                }
                Key {
                    key: Qt.Key_S
                    text: "ß"
                    alternativeKeys: "sß"
                }
                FillerKey {
                    weight: 32
                }

                Key {
                    key: Qt.Key_At
                    text: "@"
                }
                Key {
                    key: Qt.Key_Period
                    text: "."
                }
                Key {
                    key: Qt.Key_Underscore
                    text: "_"
                }
                Key {
                    key: Qt.Key_Minus
                    text: "-"
                }
                FillerKey{
                }
            }
            KeyboardRow {
                Layout.minimumHeight: 12
                FillerKey{
            }
        }
        KeyboardRow {
            Layout.minimumHeight: 71

            ShiftKey {
                weight: 320
            }
            SymbolModeKey {
                weight: 320
                displayText: "#+="
            }

            Key {
                weight: 320
                key: 0xe000
                text: ".com"
                alternativeKeys: [".com"]
            }
            FillerKey {
                weight: 3
            }
            Key {
                weight: 319
                key: 0xe001
                text: ".de"
                alternativeKeys: [".de"]
           }
            Key {
                weight: 318
                key: 0xe002
                text: ".at"
                alternativeKeys: [".at"]
           }
            FillerKey {
                weight: 32
            }
            BackspaceKey {
                weight: 412
                displayText: "Löschen"
            }
            EnterKey {
                weight: 411
                displayText: "Fertig"
            }
        }
    }
}


Component {
    id: page2
    KeyboardLayout {
        inputMode: InputEngine.Latin
        keyWeight: 154
        spacing: 0
        KeyboardRow {
            Layout.minimumHeight: 71
            Key {
                key: Qt.Key_A
                text: "a"
            }
            Key {
                key: Qt.Key_B
                text: "b"
            }
            Key {
                key: Qt.Key_C
                text: "c"
            }
            Key {
                key: Qt.Key_D
                text: "d"
            }
            Key {
                key: Qt.Key_E
                text: "e"
            }
            Key {
                key: Qt.Key_F
                text: "f"
            }
            Key {
                key: Qt.Key_G
                text: "g"
            }
            Key {
                key: Qt.Key_H
                text: "h"
            }
            Key {
                key: Qt.Key_I
                text: "i"
            }
            Key {
                key: Qt.Key_J
                text: "j"
            }
            FillerKey {
                weight: 32
            }
            Key {
                key: Qt.Key_1
                text: "1"
            }
            Key {
                key: Qt.Key_2
                text: "2"
            }
            Key {
                key: Qt.Key_3
                text: "3"
            }
            Key {
                key: Qt.Key_4
                text: "4"
            }
           Key {
                key: Qt.Key_5
                text: "5"
            }
        }
        KeyboardRow {
            Layout.minimumHeight: 71

            Key {
                key: Qt.Key_K
                text: "k"
            }
            Key {
                key: Qt.Key_L
                text: "l"
            }
            Key {
                key: Qt.Key_M
                text: "m"
            }
            Key {
                key: Qt.Key_N
                text: "n"
            }
            Key {
                key: Qt.Key_O
                text: "o"
            }
            Key {
                key: Qt.Key_P
                text: "p"
            }
            Key {
                key: Qt.Key_Q
                text: "q"
            }
            Key {
                key: Qt.Key_R
                text: "r"
            }
            Key {
                key: Qt.Key_S
                text: "s"
            }
            Key {
                key: Qt.Key_T
                text: "t"
            }

            FillerKey {
                weight: 32
            }
            Key {
                key: Qt.Key_6
                text: "6"
            }
            Key {
                key: Qt.Key_7
                text: "7"
            }
            Key {
                key: Qt.Key_8
                text: "8"
            }
            Key {
                key: Qt.Key_9
                text: "9"
            }
            Key {
                key: Qt.Key_0
                text: "0"
            }
        }

        KeyboardRow {
            Layout.minimumHeight: 71

            Key {
                key: Qt.Key_U
                text: "u"
            }
            Key {
                key: Qt.Key_V
                text: "v"
            }
            Key {
                key: Qt.Key_W
                text: "w"
            }
            Key {
                key: Qt.Key_X
                text: "x"
            }
            Key {
                key: Qt.Key_Y
                text: "y"
            }
            Key {
                key: Qt.Key_Z
                text: "z"
            }
            Key {
                key: Qt.Key_Odiaeresis
                text: "ö"
            }
            Key {
                key: Qt.Key_Udiaeresis
                text: "ü"
            }
            Key {
                key: Qt.Key_Adiaeresis
                text: "ä"
            }
            Key {
                key: Qt.Key_S
                text: "ß"
                alternativeKeys: "sß"
            }
            FillerKey {
                weight: 32
            }
                Key {
                    key: Qt.Key_At
                    text: "@"
                }
                Key {
                    key: Qt.Key_Period
                    text: "."
                }
                Key {
                    key: Qt.Key_Underscore
                    text: "_"
                }
                Key {
                    key: Qt.Key_Minus
                    text: "-"
                }
                FillerKey{
                }
        }
        KeyboardRow {
            Layout.minimumHeight: 12
            FillerKey{
            }
        }
        KeyboardRow {
            Layout.minimumHeight: 71

            ShiftKey {
                weight: 320
            }
            SymbolModeKey {
                weight: 320
                displayText: "#+="
            }
            SpaceKey {
                weight: 1330
                displayText: "Leertaste"
            }
            FillerKey {
                weight: 32
            }
            BackspaceKey {
                weight: 412
                displayText: "Löschen"
            }
            EnterKey {
                weight: 411
                displayText: "Suchen"
            }
        }
    }
}
}
