/*
 * Copyright 2018 Broadcom
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License version 2.1 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License v2.1 (LGPLv2.1) along with this source code.
 */


#ifndef BTUSB_PROC_H
#define BTUSB_PROC_H

struct btusb;

#ifdef CONFIG_PROC_FS

extern void btusb_proc_init(void);
extern void btusb_proc_exit(void);
extern void btusb_proc_add(struct btusb *p_dev, const char *name);
extern void btusb_proc_remove(struct btusb *p_dev, const char *name);

#else

static inline void btusb_proc_init(void) {}
static inline void btusb_proc_exit(void) {}
static inline void btusb_proc_add(struct btusb *p_dev, const char *name) {}
static inline void btusb_proc_remove(struct btusb *p_dev, const char *name) {}

#endif

#endif
