// Copyright 2017, the V8 project authors. All rights reserved.
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above
//       copyright notice, this list of conditions and the following
//       disclaimer in the documentation and/or other materials provided
//       with the distribution.
//     * Neither the name of Google Inc. nor the names of its
//       contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

// Generated by tools/bigint-tester.py.

var data = [{
  a: -0xf03516c2a9dde9d8b8fef2d63e1447574248b3fn,
  b: -0x226fa3e7060d3a4e46283babd136d1an,
  r: 0x204fcdd54c0a4406f1b435333b9feef78978681ca0a1d5ae7952885a69f8ab33acf766n
}, {
  a: -0x962090dc08444174fcc24637n,
  b: 0xcb73545247569965db2ecd44b4e5dbaf54ec977ca57025n,
  r: -0x774f74f27d3240d5197e9e57fbc551b75682541c4687f1215b0dedbbb3c6286c3f35f3n
}, {
  a: 0xf95f27e7e04d7aba26d03e078403efeb2n,
  b: 0x47f9f2af03ea04130d833684d7ff83f356365n,
  r: 0x461cde058f54345bd03b8a7eb21ff562ee0ab96e0c72299f200186fbf5e8723e33523an
}, {
  a: 0xac457fb8f88a6d1d1d5daeb232d401afn,
  b: -0x12a3a68ef619a38a1c7c72218f7c86d0d6c4c0n,
  r: -0xc8b0350993acf258dfdf2e42d9bf38fa41e09b260753267abc90a5dd0d8c208953f40n
}, {
  a: -0x7004c215ac2d4a9c9cdd0aeec9130e3bb74c46597c99a9daee77ace5993c57cn,
  b: 0xd248f0bn,
  r: -0x5c03d1ddd68f544249cf8fde06518fb51799e40eb7c55ae3161343911ca4b67619c054n
}, {
  a: 0x3064722501d82e587e0b01ebd6707cf9b07d1n,
  b: -0xc594e8ee35e73684cf974ae75c2251d8an,
  r: -0x255971f086d4954b7905862d76e4cc16ce8ea4c0383c63ff988872eb188a93fca9e3aan
}, {
  a: 0x8a7dab645b0aa844ae3f04c025898bd5133cfab53a9b4164ec6d7a061f7c72d7b8e2b6n,
  b: 0n,
  r: 0n
}, {
  a: 0x2863b2f30ea48cb3d605ee834abfe842a17n,
  b: 0x486a8913da41ae7960135faf3f41f94bc24n,
  r: 0xb6cd93cf15bf5cf50430a7472dd47dcd7f957b817df034fc468440df8cf85f7cacf3cn
}, {
  a: -0x1360an,
  b: -0xb27a2dbc7df54185945447c158fd641d630b95f2ff96226cc99af22cd270763fan,
  r: 0xd826ec2809e3e8ec50d5da2eef5051217f15e6081cfdc98d1461814fbc946795aa3c4n
}, {
  a: 0xd967140n,
  b: -0xd552d6fbeaea1acea93dd3be0abe928272e408d36f3c976c02fd367ee96e99dn,
  r: -0xb5291d3a8247a34440b3a5951d1cb5b46951b634970ca26c36d2474e4930961dd6b440n
}, {
  a: 0x511dc44297656e37770d655e15138b7bdn,
  b: -0x225aa32364fb2326f8cfade315d30d0b2ce6cn,
  r: -0xae2ac39028c21c940dff4f048b5b1d55e57d8083bf82ed1312882c2bf3593393199bcn
}, {
  a: 0x5948c2b3a092d8b630b7be68913930d79287n,
  b: -0x5bf9b40ba2d6d8be564f767c82ab73234fn,
  r: -0x2013f3c6729d061ce75d7e5d940295c6f0009ebd4ea02638907158ea1c5e988b33aca9n
}, {
  a: 0x69f0a5aeaf410f8ef6f6aa6b1afa4923d9b49e11eaa18af718419d7b1n,
  b: 0xd8b5ce305ede8n,
  r: 0x59ae48443214e065fbd9e77c2c4f9c6cddd0bb5ec54c4927b002258b89338acd8f5568n
}, {
  a: -0x45de7322380554947a58995cd1ad4a107b0b56c5f41917193a8b27bf86e3441n,
  b: -0x7d5fcc7n,
  r: 0x2237c390441f07e3a491fc375ccc7c2a5b07bbd6b9c18ab5ad54e1bcc57e09da2f9a87n
}, {
  a: -0x8c43fb4f1e9ce5404eb7acb4af4dd2b0dd30361de81d131a6ab5832ad8a63n,
  b: -0xb798f0fc0n,
  r: 0x6498650c9461e39e4fd1fe9d63501e070d4200c670dfe8f6f87eae94b7f4b845909740n
}, {
  a: -0xfa227614e6b5f7374f496ff59aaace4220bb578cf80ae06857cfceacd2826f3n,
  b: 0x614770bn,
  r: -0x5f0cdc67b6914271bea3f980c0310a0b5268cbea292ec77b0fde061916fb8137d0a171n
}, {
  a: -0x69f8d68228bd959ca1647860fc624c0b3f32158f8104a4f6571ba7d935fe98e4c9n,
  b: 0x14ffn,
  r: -0x8b0ff9fd6d5648843a09c7b7c5313daa023dc92b005e083902eeda92994ac8c2b9837n
}, {
  a: -0x11d892c2ec94de401d644f1b5bc92fdce3c57d7379c8eaf986f0a7aabcbb4b21b8n,
  b: 0xc64fn,
  r: -0xdd303580d2225d62c84a723926eee1a9d5508f906d3fabd815ec5f1cba919e843b7c8n
}, {
  a: -0x4ff49a90c05d153d2b894n,
  b: -0xe868b8c6fb99616c14d9887b04d5efc0767eb68ea03ca3a87n,
  r: 0x48966127edfed2717cf3ccd01b975c329d9e38721faf336b9ca9d61f44f21852b8de0cn
}, {
  a: -0xa1c473c15166n,
  b: 0xac5876d62221a2a4d5388e0bb50966c292dc00bbdf6b161474f6b57159n,
  r: -0x6ce7e4658a49baa821d5b88c3a67b7740d86c8d2c58879c40c6b719d7a6a8324415276n
}, {
  a: -0x4n,
  b: 0x731e5d21e4bd07fe398035db6198b0e5ae3ed5684690073478e5aeb9e268dd5f822dan,
  r: -0x1cc79748792f41ff8e600d76d8662c396b8fb55a11a401cd1e396bae789a3757e08b68n
}, {
  a: 0xc7199cb7df41ed8c8b5572902765a67bb26dn,
  b: -0x85275a72f9977f690f3041f5d350f98975n,
  r: -0x678ee9aad39e6e7580582781604670cec119bb2a8eaa6cc0c2443eee405e76e509e0d1n
}, {
  a: 0x813372edb9f9fdc7e40a59550176e76373e968d8b4f970decfe325n,
  b: 0xd4c2dc738e4a5401n,
  r: 0x6b60f36c7edaef3db4820b926a91ff51cf5b2986a47a8e6c43660475669042440a0725n
}, {
  a: -0xaa8b308c63ac4eec220154n,
  b: 0x819331eee690765d8acf3a4e1fb66c3b2bd6d60c73739b0bn,
  r: -0x565232a76a225c12ddf61276cb7263d6627dea92c38e2cb3f11d5df40fd22c10ffea9cn
}, {
  a: -0xcdn,
  b: -0xc71b36218a5fc486f84f4db6098b3bbdc139c0813ecb5dcd2f50782e7b5ff8075823n,
  r: 0x9f70ca58dbceb06014d7813ac5a47ed6f3bb3f277f48da1d4ee3703d38cbd99de19407n
}, {
  a: -0xd021133dfe2ea45eefe2cddf55d08e0811fb332d188ba2fn,
  b: -0x41086f60f92db2004e30aefn,
  r: 0x34df417885ce33e5b5b6b213338b8027f4d209723c4681ce97f2339319b2a6c998a7e1n
}, {
  a: -0x8dcc65717n,
  b: 0x92092b19d080f9708ac155648edaab379c8589320fb1a11d2b1d5c0a158ffn,
  r: -0x50e3a5e9e45a68acf8aafca5318c39a96418762f011612995cd3dd76460be91cf7a7e9n
}, {
  a: 0x68e8abeff12c43b516efn,
  b: -0xf720b4bc32b3eaf75d419fae58fb031cbd1e76e95a250bfd4an,
  r: -0x6545e50ab83a01338d9f6d1789259f048b2bb2b0baa62e1ed8ea23cb1821d41147d416n
}, {
  a: 0x85a004e6dfa460714b4c6408b76c5b2d760cc1e5b09cc31dc37e73n,
  b: -0x5193dfc0478b841bn,
  r: -0x2a94d13a9ef66c1270f602be58efe361c2637f38ff1c363b7b80c9227588647e42a221n
}, {
  a: -0x2n,
  b: -0xdc31677d1de6ba227a93037def29356190f9ebd9bc19a7fcf100f102a84101621e48fn,
  r: 0x1b862cefa3bcd7444f52606fbde526ac321f3d7b378334ff9e201e205508202c43c91en
}, {
  a: 0x1a9b9ea1664a662767a195dd3f8a62n,
  b: -0x4fa2c27e9038c3196b0a3d5d59b9daef6c0740c3n,
  r: -0x846f0a5467f831c32f2599a2e6c7d441877f456817d696f63149d4dc10d138aace8a6n
}, {
  a: 0xb9a59e20bcd4db1b77en,
  b: -0xaad2e15619d8cab1e15e6fa36aaed4ec0c24726abe7c4331586n,
  r: -0x7be0e846749c883ec9ff27b75e8ed77c1db9df59083095001ade24204e4c6c452d61f4n
}, {
  a: 0xc8ab3c5cfe27b15e5a6b89dd119518fa592a9cb651a5f0c36505428db6ae9ad7n,
  b: 0x5b8afcn,
  r: 0x47c1d04c27e4a7a13999d8fbc221178f393ca6733b917868973daaef6dd80afdc551a4n
}, {
  a: 0xaa18388abb7b6f73070f360bd015e1c6f409n,
  b: 0x9bc3a07fa6169198e7cedb47d2f931244cn,
  r: 0x677ea55304e600fcd3b45e6eda43ca4713d290d91a6c837df09f0836254312781ab6acn
}, {
  a: -0xf2f1711fe2b1ea5887n,
  b: 0xbd31c46ac0508a8fa95a16f092ad36073823e422bf25801e3685n,
  r: -0xb38b7b215a8e829f0c4031b7efc1d4cd77c1206c98475f80315146eedeec8abd3e7823n
}, {
  a: 0x6e787n,
  b: 0x20cd2cc7d4b6a3777a9a873920f4a01566347e059d59b5c551e069b8f3e7df44bn,
  r: 0xe2797c49ea99ce9de34242d8a198ddf41fbd3787360c2ff3d33227135c0e1559d808dn
}, {
  a: 0xf1b5da44a43c49e26eabfbf46b596a8abf036f46a0943c04896aa89ba7e33n,
  b: 0xb95af8bacn,
  r: 0xaf024f82d5acc743d22372af0d8c2ff9a7818461546d6bd19f2d90c654f17dbfaf7b44n
}, {
  a: -0x564c1241865fa70c6a2n,
  b: -0xb7c5221782e8e6b2c9895f9754f6dc27b1754a77be7aa88bd22n,
  r: 0x3df2d514eade43bba20c25e74e7701253cc8cb82be7560fa18bfffe22b896f9faffb84n
}, {
  a: 0x612e7d9e80f38eb966fb9b71b88b4a48758c931e0d1fef8n,
  b: -0x53087133fab589d4d722690n,
  r: -0x1f85472791a54d400d180c0a45bab6ff83bd2793cf1d27fa7c19fc50ba78b9c4683b80n
}, {
  a: 0x4084bd1d268adb92c835698bbcbc2168bc3f92f3876f243758079d3c85bc84305fb86n,
  b: 0x1n,
  r: 0x4084bd1d268adb92c835698bbcbc2168bc3f92f3876f243758079d3c85bc84305fb86n
}, {
  a: 0xb95907n,
  b: -0x5c3004a7279fa6def24133400673279a74f8c5693daa158fbd6c026d8194c035n,
  r: -0x42bec293b9dfb82d7e236f53de5235d4894faa587c8c3a660572d67beec78a2830ae73n
}, {
  a: 0x5a75bf38n,
  b: -0x2274ec129ec51ff228fbb0b8802c65c422a053e6c6694285a09f50c3ef7f96n,
  r: -0xc2cf42b360965da8a09e0b5614a800ea073c982abe538025132ab46cbdb2a9822d2d0n
}, {
  a: -0xb5d4eda2c2abe5faae57db62d57aac0690840329d1ed23fcdb4840c9c09a316f5d6n,
  b: -0x5c7n,
  r: 0x41a8128e752af1dab453d9477ff57b7d9eceaae469bd10ae9d6de6e4d97bad39a6475an
}, {
  a: 0xd16eb9an,
  b: -0xe3df017c04a5810ffd5063156703ff78aa735e0a2b251ef640e78f1fa0f4380n,
  r: -0xba6b9f437688aa5a0462b17c7624ec1b8f1f4bf09ca7f7c323603e283925d9bd251b00n
}, {
  a: 0xe683ba812fb48c046fa03f0e08499de3f7c5b1256a4b139ee1f240d0a63n,
  b: -0xb531379b5d5n,
  r: -0xa32774263c4e59f0d2dee4355f0decfc09b51bb60251f7dd87240886a0c56e78fca35fn
}, {
  a: 0xb4914719b7fd03eae89cdb4ebf2ad7f8e2n,
  b: 0xe185d63a6f011dd5f6d52a3e1798288e9af1n,
  r: 0x9f12161233b759f67dfe6bd617394f2d4268aebb827d87540c56d356e3b89c9e6540c2n
}, {
  a: -0x877c855abd44735n,
  b: -0xfcb617c2be618439af4e9efd7187394a0d731104971976c98b82e26n,
  r: 0x85bef25f61ec2d13eb3a4d2f267db5d56964552548caad66f93c61e253f9ce4c6617den
}, {
  a: -0x314ffd593bdf73n,
  b: -0xe22366ec1868860e0df70f389fc3c2140132247987cc29596c630288n,
  r: 0x2b8f6f6bc3713142d05a80c085ab7121053eee9d18dc5aff29bb169eaf57b0cd069b18n
}, {
  a: 0x42eae576dff8n,
  b: 0xb97ea5a2bb40f760b84e5d81b9280beba6a3eb70944fa7f460828bf6f2n,
  r: 0x307cdabbc7d9d8a5b1eb359cde528578677120657ec08d8f4a77f4db724cd4b1400870n
}, {
  a: 0x36e51ffd50df59b2daf36f62746006dc351267fa10f9330966cdef65767b0dn,
  b: 0x78410a87n,
  r: 0x19c9596dc34dfe7ffc54fde46746251015b2529c5337b8bb0cfbea7a9a3ff8789665dbn
}, {
  a: -0xccaa868e7b542f954ea420f807ee2222fn,
  b: -0x9e595a3928ef5e8922d1fb29d61c6e6f24026n,
  r: 0x7e98ae765da6e685e2b5ddc0d695043db8bbf89b862e8ce8342a25d9d2c89fe88ad2fan
}, {
  a: -0xan,
  b: -0x611b076be136e483a11bcf135c98f1f9da39cabeae64fc828978a71bb19b696c014aan,
  r: 0x3cb0e4a36cc24ed244b1616c19df973c28641eb72cff1dd195eb68714f0121e380cea4n
}, {
  a: 0x982e26n,
  b: -0x5acf774edb3cf6ad659fdcce08c4a32ed7b554ec81673403953783f91b366888n,
  r: -0x35fb8d990e0d4bf6541ceae9bd00e98652b7610699efa2a2caf64e7bdc822be19bf430n
}, {
  a: -0xdf35795af476710ce9ab424c3d34b09fa04cn,
  b: -0x6b7398c3eeb586e43be2c1d9217f9f0a4bn,
  r: 0x5db023f11df4c12211c10339b556e04be21e102763b4d60edc685b92d2f6cc3e3aee44n
}, {
  a: 0xb758b39b0c5464204e6a8efec012ab8b4f818aa3fcb6fe2e2edn,
  b: -0xc925b4cfa6ac6bc0c81n,
  r: -0x900fa655c8784b157fecf2dc1d5a3f3fb8f2e49f932f8124d3173a1da0bd05f803756dn
}, {
  a: 0x2c4n,
  b: 0xb30b64e73bb68626d1a42660320bc2bf81350d2a4d952a2876ebe1940d9e6735af7n,
  r: 0x1ef2b830f8124cb035bc9fa220a688699a156b868fe908897e8e45bdd75aa15707931cn
}, {
  a: 0x6402d753f369dc736c59a1a315af1e2e88aae054aa115f4608c6a812dbbe317n,
  b: 0x49cb351n,
  r: 0x1cd4326286bd0b72daae26d00191ff26d0109eabf2c15c71bed90fa654d3e4963fef47n
}, {
  a: -0x645e3c38cd3da11684354971970745bc67a1899fbdc274025246ef00n,
  b: 0xe78a72959341fdn,
  r: -0x5ac75010533793bc17d4c5f58110b9934681e537a8e8426ffbdd9f694633058fc93300n
}, {
  a: 0xaa638baca90b597fc2cc67ee62ce1ad7e8d93175f2e00a1cn,
  b: -0xbfe3e0d08eb6ef32a6c5b1n,
  r: -0x7fb7f11c964ee67dae84d34885d3de5c12df744189e33d473992bb9f078dd75ad6895cn
}, {
  a: 0x5dae083ee0c85d7c9f7807n,
  b: -0x4aad456450fd3dc718dfab33c469333e8f55c923f1a935fen,
  r: -0x1b53b6625d4f0bc02283e37d74b22f1a4df93451d015f9c8b9378936e974c87db189f2n
}, {
  a: 0xddcda225154c77e445ddedf2f8e48f29c7b8f5555baa56c9276442cn,
  b: -0x45ca85050e4523cn,
  r: -0x3c77e436269effb578497be622d9f892feb836565f4e68ffdb08ffb4b520beacbe1250n
}, {
  a: -0xf25893ff701b6f533ef3bd65429c78af5a18dd22b6n,
  b: -0x34407e16e8ca637569d5acc79cb6n,
  r: 0x31770b922b75e8c58dcf2424cf7ea701fe03924118a8536bfa5b9842cdffdab1d79564n
}, {
  a: -0x17ddb7721e582b3eb940359083a3e161d1fc966cf53d25b0f58559b566a28cc48n,
  b: -0x5a737n,
  r: 0x86eb58887308e160d393bb8f5a1f972555eed3862f95502e54c97db69d19d696edb78n
}, {
  a: 0x20c15c55aa5bn,
  b: -0xc6e6f8bc174e84f77cf01535f692a83daeafb7d6827239724f07277a62n,
  r: -0x19731af69927a6ec7564b7ef1cc8808d7f6aba91535d88f0c180d96f3330d09cd794d6n
}, {
  a: 0x978c0cb0914ae904c8ab191f0328ad37ea00c71ade6322cc22c7ef4fa9a8cb31an,
  b: 0x8bdban,
  r: 0x52cb0e6a41de5269c1af8e6d43f22bd2f7268d06672cddb19143e5b6efd693c34452e4n
}, {
  a: 0x56162ce6f214f08486a91bc0b953d7bbdec5n,
  b: -0x793061a0ab07208dd61c8b6c58caccd9e5n,
  r: -0x28c0c036021c1138ee900f3707549163fedc043c68724bec467a7ef30eb11331df4339n
}, {
  a: 0x1ccf5948eb3b5a4ec5a6ec6fa473d23n,
  b: 0xc168f96d9f51788f9c7e54276a8802d32caada7n,
  r: 0x15c4229e430633abdb9520a64ea89b4cd371baa7b17ed111c5385f6fcd603d7c6788d5n
}, {
  a: -0x720e4f3c53177a132553173c85baffd27a18e7ecbe421d8447n,
  b: -0x6daa2deeb19c8eb2fc0cn,
  r: 0x30dbe9b429cd1656444bdfd806985ddc503892497f395235548e4fc4546c2982f61754n
}, {
  a: 0x769048e43f36e32533308e2951f6d99cdd40f57782e66b22e8c9d76774n,
  b: -0x7718df398954n,
  r: -0x372896cb44019cf88a177713ab38dbe85b80084ec43780b7a2612c8bc63b5a95df0610n
}, {
  a: 0x36n,
  b: -0x1429c0fab1ea54b4b9cec0d6c33a2e71707b0daf7c1ef0d835821fc0c65aa6d837a9n,
  r: -0x440ceb4e1876dde1f319cad4d2e45cbedb9f4e3042e86cd9b4972b2a9d71f319bbda6n
}, {
  a: 0x6e2f5c31e187aa87cd691n,
  b: -0xc04ce795641d51943895998ca43d74b129e756c98b0862ad3n,
  r: -0x52c49ee1d0cd7e33deddf29531a8248fd2cf5cca502b24ec5b1bbe28c5e3b159fea383n
}, {
  a: 0x387ed48c7eb3b57007cbdb55b95a72942364ec61210effdf87f2335b4703697cdn,
  b: 0xbe6c8n,
  r: 0x2a0613815b9513d38bc49ab015662fdf820de7b645b3a4c35922e04482e4213cd7c628n
}, {
  a: 0x87c61f15a97a382549d24b54b917f041a653807a7f2b0c6019d3c70b48787ae851fn,
  b: 0xc53n,
  r: 0x6894eb117f7ad41f38ccab665252205f914d71865ad3f89845e4cfe100e24d2bd29d0dn
}, {
  a: -0xd08272d1fb47c4dae5b846a10826b3f24204868f38064dcf5aef2e75b39n,
  b: -0x999c02776f1n,
  r: 0x7d1d081fc3219fe55fa928e4b87f7230c513c3bf9aada9fbf17c62bf90f963f58826a9n
}, {
  a: -0x2d9af5b486d93e0c52784904efdfcc1d681a968117cb9897fb649574b602n,
  b: -0x8c5d1fcc3an,
  r: 0x1901555421e58eb4f1c1e57e4d5a91739a0447401ce8934369cd766610243ba1b8d474n
}, {
  a: 0x83b594a5d0d226caf0721d4e86ec2fe2f3aee30acbdb5214n,
  b: -0x5bcb7fb7756e0de542d5cbn,
  r: -0x2f3a3e8948ad6bab41ea9c10f310bdfedec1bf25efa2b017b8c3e0564587282f5cb9dcn
}, {
  a: 0x8fan,
  b: -0x937ae3dc86e26b48f1f8d3c130520dee2fa55d48546a43243a36a6679127c676f38n,
  r: -0x52bdd216992cc770ccc139cd42bc0910c17b2675b45c1deb3328e91bdacff0b87c5cb0n
}, {
  a: 0x57e66e83n,
  b: 0xcdf8fee4c29c284d1f2f9be776898550323923a19924ff3c5651dfe42b0780n,
  r: 0x46b9053f239aa4ad1a1cf59f2597783cc6c638102ec7d57a1525e99d0bb7d17c3dd680n
}, {
  a: 0x623dcbf3683c9d7f9e1d18572f39328376bc92bfe368337dc96b15f9cce4c297n,
  b: 0xfbe2a7n,
  r: 0x60a9919c04213ceeb56e5cb1f325a4d3cd6d78d0b51919d2c31edd7a2dc12167113e81n
}, {
  a: 0x1494523781fa4359295b2d6e7171cdf125dn,
  b: -0x9892abdb2b10c047bae43d31106c3224c5bn,
  r: -0xc43db388a18648f2d9b99758a4de1ad4bf956f3352cfd338d4a35a2285d94c419230fn
}, {
  a: 0x84545a19n,
  b: -0x5ed6dd71a30955df1bd3ef44b0e8fa86b992b305d7122c08adff7b927564c2n,
  r: -0x31060a100e2fe2c16ba83b7c2792b186dab85cd7731379d950d22d90dffb07aa8b0af2n
}, {
  a: -0x79637688e7ce102084664dfece10600fe9382349c7a7f0d03707144b0ab545290n,
  b: -0x74152n,
  r: 0x370b160b3115802fd0ad4848a5062ca122fd8ebf57eeb2da181dbfa78d8b658be90220n
}, {
  a: 0x410n,
  b: -0x49be0ca7d86f95962180e486c49264474b34cd75194aab9baa5a071d8138c2499b3n,
  r: -0x12b941369df454fb1e81ba0637e92b761a18682abb6bf5928640dbce7dcf6954b06730n
}, {
  a: -0x55ef9n,
  b: -0xdaa3d830204194869c538d4e491becaf415d7c8e5b06de0a95d0e7b0cb825a0e6n,
  r: 0x496500baf93ef5af3f1f67dae9d88fc7dd74a56723305656ac862f3b83f3b9122bf3b6n
}, {
  a: -0xab135af031818be22d984afb1f9ace003e0c966d5n,
  b: -0xa4443c25284c8abd7baf634dba532n,
  r: 0x6dc5ff97658ec10327cdf67b5356ba2bae9bc17d48109287024b5d9743087ff2d45e9an
}, {
  a: -0xb9891fca2c621b14c2014314bn,
  b: -0xab73d1e5a75b007fa4fd8c903f00a2454a0b41ff7b59en,
  r: 0x7c4288f4b75f5e16863450ec2dc58a6d723f69699d7d03bea3199649192dd9b7ad734an
}, {
  a: -0xb33f5f8ca4a54d980f735605cf03c0an,
  b: -0x818e052172f01a625f46af0063f8a79540f35e7n,
  r: 0x5ab65fe4877e0692a3cd7fa2138e0861897c3ac42bccf125d25e82bca227b265ca3f06n
}, {
  a: -0x9d290ee1bb3fddfb021d5b9edn,
  b: 0x771d31ddaab53bdb5a0458a6645b373c0327398a9cbe8n,
  r: -0x4920022e8eb47aca3ecd392209ef73d2982aad42611af3d154778187e36e6699946dc8n
}, {
  a: -0xc0363165dfee7a8308c309n,
  b: 0x2e04d80fdb0dede1688e480baa64768ed83569d9bc57d059n,
  r: -0x228d5ff2b5280544de91e0b8e9d41747c75c258c1f4fa4f4494c2403c36de490921e21n
}, {
  a: -0x4f5a552571dc74ec77593156d22010e86875498bc1b102b87603317n,
  b: -0x716555c7202fd59n,
  r: 0x232648cfd67ff8ed52ee5f4cad57d03a7fc4debfe10ed85b2667ab438688b0c71d7dffn
}, {
  a: 0xa14e6a4003bbdf5bcdbc74f9447871aee4ec7013514d0d89ac85197n,
  b: 0xb07deeff674175cn,
  r: 0x6f3542edb8c621621c305670f05408b65a16aa1a7ad6b7addc55c0a90742e4b1bde344n
}, {
  a: -0x73cbd0e4816516469a7c6f082a955b47eca178caan,
  b: 0x3dd865344f012e5ec78f5eacb7022n,
  r: -0x1bf97285c62f474c9c2b2037edd5eee09b414b4321e624480387f232ce873313790e94n
}, {
  a: 0x4eb440daded20e5c7f3fc25205e5f898773e3c81f8bee20c8ab6901784ffdn,
  b: -0xa66e4662fn,
  r: -0x332ac9257f0d9d16137dbd118be83f33b8600c01e14db518876ae687f1adc540497d73n
}, {
  a: 0xaad85cf6b61a8325070ad1d9b81b0596eebn,
  b: -0x2dcb1934831729688f8493851855c5a93a1n,
  r: -0x1e8f92bb4228369e1cb5487fed5d33466caa83848f99d3bd28fd9657d96337b58db2cbn
}, {
  a: 0xd425e2f56ed96b10c899c705an,
  b: -0x42a6d9ad6b535371412fc2b655ae357f0e247ea4a9481n,
  r: -0x373c097845a73cb3438411dd5c9fdff2c7f382cb87ae86ab772429aaa5d9c086cca55an
}, {
  a: -0xb337b40b0c3509de4e198e10aac65185460929ff70n,
  b: 0x53808905be31acc63295ef2896ben,
  r: -0x3a750b266f11d8b5786db735f687d9ce427d86ca84c42594a61934840d2392e2573520n
}, {
  a: -0x192540c48e128ac83d5edf3013b4aa5d00n,
  b: 0x6e453981df0deabd351c083620841a22d547n,
  r: -0xad4ce84f7207aad4f3f23236f162d35a121a559785a06b4a9b9117755fadb34a0cb00n
}, {
  a: -0xf473414a5aba5d583caacfe118231843d2ed57356f4d69376bca4af7e0a6dn,
  b: 0xb39a2cd48n,
  r: -0xab7fcecafd0f5d31313d944728cd4d929696234e33f8281f3d8ca724297f9d27c637a8n
}, {
  a: 0x67a86b4b89dc9fd1b03b6ad8f80744e8213ac9f2e6050242fe23beaf73ccd381bn,
  b: -0x2846dn,
  r: -0x104efd09fb5f8b4fb8b9d82164e53e4704a6e0a0f071089d27dd820e9900392484cf7fn
}, {
  a: -0x2d7504af4b7acb720277a7256cd75cf24ecbfb421d6037f2f313a3da071191e65e4b9n,
  b: 0x3n,
  r: -0x885f0e0de27062560766f570468616d6ec63f1c65820a7d8d93aeb8e1534b5b31ae2bn
}, {
  a: 0xc569e7998002b1d9b345da50eb794ea1adfeab0931f3fn,
  b: -0x59b3016c9d4a0aa2d68dea10en,
  r: -0x452bdbaa79b5cbd2d9c5b1b469e62878a111602d40604f8fd6f972a988103bdf545472n
}, {
  a: -0x7eccec82ee4256552d259d8450ff480f8e407bc12496f0aa7d87baef0a40b3e641n,
  b: 0x9a1dn,
  r: -0x4c55a37d8e28e57304cebe0470b6be448555e7c034e3f1dfd2d3ded3f93f158ce42f5dn
}, {
  a: -0x468c615537e997eae6adfb5be00bad2298b4627d487a2c07df431fn,
  b: 0xc9e71cd3f0ccc731n,
  r: -0x37a3e9097f81716c3b161587abf52a46299febae30f4086765c7d7c4a3e7ef9b9cf1efn
}, {
  a: 0xc8086f1c69cbf2d0aa98b04c7en,
  b: 0xe10f893893ef9c69340eb84b8c0824328bab498efee1n,
  r: 0xafdb8d5f348d08164dd7f6d4b726bca4084ff91869f6708f3a3b83ef8523337abc3eben
}, {
  a: -0xb8159d4ec22be0035f0ca78bcdaea051a8645f548f5bda17fd54513dccbcae20n,
  b: -0x2bbbcen,
  r: 0x1f72ad5787ba94ec81b044df0d7e12ff57f092d59b8f31164092841692e7f9d2657dc0n
}, {
  a: -0xa4fe3cfcae1300c20c59850dd47697e69331575n,
  b: 0x6add8ae52631e3246a072508569e83bn,
  r: -0x44e00e400320ccb20c68a852959b7276d645711ad95d20dd822043af355e222034f9f7n
}, {
  a: -0x55427ee33085ce6a095dcd868f112619fn,
  b: 0x1335e138985462764e189f08974c810df025fn,
  r: -0x665e1316c6fff5134ed89b8960ab610d8fa30291d6258a2090a5561cf962894167801n
}, {
  a: 0xe8add81dd55069376d32c3a1a39a68f410afbe651f7b9f08d6270f8ba904a7bn,
  b: -0xa774860n,
  r: -0x9833508c62cbbabaec6c9bc7a95e78119869f5923b04d73d88f324ef98adb9f83b8620n
}, {
  a: -0x74a0534b33a8d93a6f6c847402fa669487c986c97137946c3ccn,
  b: 0x385d3eeefe81c454282n,
  r: -0x19ad8d226aca8b284aff6b9b31f3c49cf271dd3b832fa2aafb2c6264300f84ea660598n
}, {
  a: 0x16b5483566103549066aa10ce598319f0c081b2f22a8c1b05fb5058600a6391173n,
  b: -0xea4an,
  r: -0x14c84467aeba516426f9520857977b59b8f8e330f14e45d3347721601554203672293en
}, {
  a: 0x9689be9a09f17e5530bb55f207944d310036e515cf044987e1f0320694736529a4472n,
  b: -0xan,
  r: -0x5e1617204636eef53e7515b744bcb03ea0224f2da162adf4ed361f441cc81f3a06ac74n
}, {
  a: -0x36af8dff59cbdef8cc2ff7d8681315dded203n,
  b: -0x3b732a917448a06712272083cbbb72209n,
  r: 0xcb30fae82f9b55131a4f3ff6a3b419f3017c599ee11928314c21e92de479835dec81bn
}, {
  a: 0xd9af1b1d5ccacdd139fc97590b37n,
  b: -0xad3958450fa76d1b038730cccaea30cefb85596f52n,
  r: -0x934c185ecc12bda5e0c9c9f69b28379d49c970085aa620711677db743f3a3d8f81709en
}, {
  a: 0x6f43482b9e38dc7n,
  b: 0x9e2f813c911e206eafefbed71003de5b363c5c0f659ac665d98e4bcn,
  r: 0x44c02c1065de3d4d03188161f7062ce7016592391f52473aec61ddbd5c3876a6895a24n
}, {
  a: 0xb00db23e7c104cc7cf85268caeaf1ffce20b47b3c3can,
  b: -0xa12e34fe6d06d0325d2f477aeen,
  r: -0x6ed8640114069ace690db71375ddf49a9e54f0af1beb8f602cbc72fcc9fed7b77449ccn
}, {
  a: 0x4177f98ecab0b43ac536093f8d4f9c8ffe7n,
  b: 0xb6536a50dc96e6220bbb0b07b064c6cf4c5n,
  r: 0x2ea0a081c8a22596281b0dca853836cccd1801f29c3f4c4795a15fbb848326550918c3n
}, {
  a: 0x14924d27b1d5456dee50b8afd2f93203a2d0110f87eb80e2129ef59ad2b06c7aa0cn,
  b: 0x6b0n,
  r: 0x899263f97542404f29bbd317d2e27e7850cf7217dcf6ede7dc870a7b60fbd57413040n
}, {
  a: -0x3dbcba52b4f10ef3358e5ab92d531ed9924d9d4cd9c32619d437fe3263e5c2535n,
  b: -0xa1f8dn,
  r: 0x270fb22bdb4e16f14c70047a029ba3c040d951fcc73520f1b671c989702d36f553e931n
}, {
  a: -0x8d432f5a893b01051336d68db750bd3b00604c246e7ae8bb3e5de51cce5can,
  b: -0xf7eb2e2ecn,
  r: 0x88cd98d8b10b1196fee7e57accc753035e856a74ab4e74e18fd27da69f5d917e342a38n
}, {
  a: 0xa75b5c37d0cc18351edae76a59f60c8d99f48a97a546e660e2b12d4e274286b7acc9adn,
  b: 0n,
  r: 0n
}, {
  a: 0xfdb60c99592a1affe0cce47d0e6f2694ea86136de00an,
  b: 0xb222f8ebf3cc254e2fe39303a2n,
  r: 0xb08b3da2804d5d838aaef8fa435d213eaaa598657c64c4c4a4c0b21c14bea918e5e454n
}, {
  a: -0x93b5bb1266632209f631cd99347dc6c0939b9f113eeb54af32386f78an,
  b: 0xef741d28dfc03n,
  r: -0x8a29a8d21d9d741f5bc5182818cf960a4a69b323452b6578ed33f0c49d8041d142be9en
}, {
  a: -0x55a828n,
  b: -0xa4f4ea3054f3b4df72a82da6312abf6d2ab14d7e3efac2edeb5981fe34bf8e93n,
  r: 0x3731ac4200843842f7f7ff706a856d4b8cb9f1c179de512019bc57acb2a5f04a4dbef8n
}, {
  a: 0xdd4570eeefdc456067ab0ce141406n,
  b: 0x2ecda9951630efd72ca7697b6b57d36195f93ce6bn,
  r: 0x28743d7a1296634c6b983a955378f43720d6cf0de00b042127ba7f9c8c8f4603f33282n
}, {
  a: 0xa8384d51f7b8286d112bn,
  b: -0x65252c5bbf6897535c493c73ff01a8ff3d9e8d25203265dd66n,
  r: -0x4276a3ca7aa8c44722925f2b27556f2ab6cce366da4efd40893aae14dc4b086f3df622n
}, {
  a: 0x29b77cfa483aec3c1en,
  b: 0x750ec6d1824d84fdede4f4a2f5be215fe8e62712f6b353c124a6n,
  r: 0x1313448d47654cb69d52648c4c69978422ccf11f651c6ed8c49111aada53b07a413374n
}, {
  a: 0x1be29a6340cd34971602cn,
  b: -0x71115c2e84fd5e0649abef527112b14602103e6c333eefbaan,
  r: -0xc50ea3c90e1bbc2380cae7c67175b16ca1a6648f238ed06f893b6057b54651b7d0138n
}, {
  a: -0x6f9d0d30c29312n,
  b: 0xe8e90576277279a9f492965a474ae4b26bda18dc661809ef25fdde02n,
  r: -0x658bec46c68f3e6f930ab4155be271f2d847b0cae7daa437c7d2b83ba8e9be0fd8c224n
}, {
  a: -0x8e91b79d16f631c4c4406e6ac22453bfn,
  b: 0x35520b2ad499ebc0d8c65fa9d53fc39f50e6e9n,
  r: -0x1db1dbe87344975c03a6c35d901fc1b728f439848f1eb298d21f9be8fc707222fdd2d7n
}, {
  a: -0xa6aef6c4edb1aab4f728157f9d29f8b2c101f365f123078dd23f228f7697n,
  b: -0x2d9990969bn,
  r: 0x1db0be1693b996b147a42627371ef4ff056760d5ce3a6a01297e29be725197f049476dn
}, {
  a: -0xbe01n,
  b: 0xfdc3a2b5d2d531c74f7bee7756b79514ff60dd8abcc698bfde581341e90cd7a5f2n,
  r: -0xbc58308695300dc71ec54a7880d3975d2a9ee3cdd5a62224ffc53ca2fe39711a0141f2n
}, {
  a: -0x5f161a4d7582cf3ee78799fa52fdeaf9n,
  b: -0xb3b0830f4bf195bf66e0261e6bcb43defa7ec6n,
  r: 0x42be04443c61a3a5b3360b14a543e7bdd61522aa0c052cebd4f182b8f27c5b8f344a96n
}, {
  a: -0x4n,
  b: 0x77d96cce74f6655a846a6018b665c9dcebd7001aa280a25cd5c07fb7fe24b988faa2dn,
  r: -0x1df65b339d3d9956a11a98062d9972773af5c006a8a0289735701fedff892e623ea8b4n
}, {
  a: -0x163ab839a84ac90621f65f238c41bcb7fe431312f878bebf98ff8e875n,
  b: -0x42659e8d92a1bn,
  r: 0x5c3f66e14e9423bda548d72cd07b54933943f0babba077bf504bb135ba0451890b657n
}, {
  a: -0x22b2694a97eb61dbb560ed7f10fe70bdc8bcn,
  b: -0x4cac6bfdedb0aaafd1f9c6079d347553een,
  r: 0xa6455c3dfc34caf3f418f343a8909575031dd0437db6fe074f947e41d9de9467192c8n
}, {
  a: 0x8ad9fe846b3cf21f6194575f0c9a157a0cfc346ec8010eb7e46n,
  b: -0x8158e3f5aa08d81fa8cn,
  r: -0x46280fd4c31821d3b501684e749aa75196995b40117fbb3dd9790c08662986695f6a48n
}, {
  a: 0xbdda456f24117d31f9b58d44747e948b535bd704fa8d3981a7bbbee3f5afn,
  b: 0x431858fb51n,
  r: 0x31c22ea001ce4dbe5ba26371367b889ac7e87024d8600a551a907f899370c2c42b515fn
}, {
  a: 0xa306dc9a41e98f2a5b4a044eb649947a44aa53db1a0fn,
  b: 0x38c8753b04544f6863781fcc69n,
  r: 0x24292845cf17b9ba702c83e901a1526185146e8e0ab191a89813d2e3beec3b2d72a427n
}, {
  a: -0xd239482cf43b7230990d6d4fbdac4692ae935ff3174n,
  b: 0x5c42e164b8edff6297df6db13a4n,
  r: -0x4bc381cbd208a534b4d01b6417ed73916df4908e256f790c6491183ef1f0e14e634a50n
}, {
  a: -0xc20f404a5f557b3b3een,
  b: 0xc7b39775d70b2aa500e7dcdcd3df433e21c46d2d069b09a0731n,
  r: -0x9761fe741703a1c30461a4b7e61cf95940acf3ca9b2d9af6d37d66ff71f3c7907cf28en
}, {
  a: 0x64393250a92fe4efa4409n,
  b: -0xce3941466e1a74058f324ddf382448bd7ea8103d317a9cb85n,
  r: -0x50bc70c7349f61c0189ee8b81300767470f682cede47a8d898e8650da3d47e34e97badn
}, {
  a: -0x2b78a8b6443ac5af6b0981766d0f77e895bc3801ee125c70a0f2685af5979400n,
  b: 0x9c0dedn,
  r: -0x1a7fe42e5706049d5825a0778a5399d224109f4f450610aa536028e724e30c3fd80400n
}, {
  a: 0x8d1326e1c399a20d8594a07c1abaa497a99ce53c38b7069ee571c07d1n,
  b: 0x402fd8f53b68cn,
  r: 0x235f27cbe139285e25995f84e8ef884a76afcd2ca5f42d8652be5b15bfa246d8a5dc4cn
}, {
  a: -0xe93ef42128n,
  b: -0x208779d0e8880484e05a2e67be34bc7ce2965806a5e96f481e74a3320824n,
  r: 0x1da34db3fae319a64a8ce5bf4c27043d4ea5480b634cd1908244177e6cddaf6d2de9a0n
}, {
  a: 0xd750249eab57069f1b945724b7255bd8e430b5138aa3cff517n,
  b: -0x54ab5e84f53ae7df7538n,
  r: -0x47366e0bc73b64415700d6fe0658d0d39898857561d411f5a2c0507da885b6208a2008n
}, {
  a: 0xa2ec4da1035dc35696f8c1db2944861d2a147fa8aen,
  b: -0x699e6d38705ae291f4b49ad524fen,
  r: -0x4337bf317c014bdff83c4a89907759e0d7054aae1f59d7f77c4b3aaa9926aa4f27d4a4n
}, {
  a: 0x53203abn,
  b: -0xf4865dea337ae826367b755b545b310a4bbcab0764e2326443f090186d9e1ddn,
  r: -0x4f66594d399ee94ea5891918b53b7c331fa5af459717348d697cd91d24a0910f59759fn
}, {
  a: 0x1d9ad7fbf87ba5077bf238d2d11bd339c4b4a17b57d85004n,
  b: 0x7a9e92389aad2bdbf99d95n,
  r: 0xe2e21683cde686e4637864bd2333245e629ad8f6d00f89bbcf615cb19442f09dd0654n
}, {
  a: 0xfbaf21n,
  b: -0xd22a2021800365e77a92925f194832b152fd6c771b7afb490747a3aa61e1f13an,
  r: -0xce9f13643d8e28bd0e8d568231aa5450d21f10489858b7fd3b73a1612b8a6795e4be7an
}, {
  a: 0x8aba3bfb1a46a0edb0b99b063ac65n,
  b: -0xf32b5c88fa09edf44df9818d74106ed025b2044cfn,
  r: -0x83c6465c951bcf881ece88cc1d3a46442a998bb6024e6d7687e7a39ddb88a78e0339abn
}, {
  a: 0x59347c00fa21afe7f190611e8b78bn,
  b: 0x728d7e92974b466e97d288f768f8f6421ec1810a4n,
  r: 0x27eaad3ba59c289e334cd84f59853775f7f0410c10a409b85b678d4e6794f25d96450cn
}, {
  a: 0x13b39e573782856492308e0c6ed05448663en,
  b: 0x5e190beabbdec27978ee0208772fe032d0n,
  r: 0x73de19945582d39c9ea4864954bcb78d09567f1555760cb4e0e92eed73aab770b2e60n
}, {
  a: 0x32c0b3n,
  b: -0x8ee7af7ea0bacbc4538227dd845deff4e83e41972fa41d6cfea52da9a8174b06n,
  r: -0x1c54d1f65a129247c80853cb2bdd82df7bd295e4408e7f251c0e74dae1003ea7b9f532n
}, {
  a: 0x45952701004287de892897684e44b7282a3da3n,
  b: 0x6eeb5c5bacb61450e9fbf7e26e4642a5n,
  r: 0x1e260fc7c102c0ab64d602c0257cb3833cf337618c533bcf848d4de6145356abafc00fn
}, {
  a: 0xfc1ac5a57e4ca288acfea0e6298708f3e0c9544bb607251d27n,
  b: 0x1edddd1342a3f6ba6ff2n,
  r: 0x1e659ffc18e7eb7eb2d0f778410e279f07b61db988ef49ee51bb1ebeacf7fb810f77den
}, {
  a: 0x9e3d4529ac66c293f296b0a3c37a39d2d1e5c0f88727d71766b66f1f6853416ef7n,
  b: -0x9045n,
  r: -0x592d1d6b15354525aa5525f9ba1870782be3cf78cf02d6ba23154dad9e25f33f0dd893n
}, {
  a: 0x10cfbcf8693c31df3f65cf943a057a289fd4d0770a7ab36n,
  b: 0x4845b89c48f5284779989ccn,
  r: 0x4bf01435fc184de7dfda65c5eac454038f19508354605a714411fc95835daed825508n
}, {
  a: 0xb5fa8be84197cc77c80212ccbdf98a6f4217e2c191c7ebc3f8f4f6fa23ff2f52890dn,
  b: -0x7dn,
  r: -0x58db565068071ed67ca9032df8c2d8985345a9b8842e9e1eb08f9c9823939a1b4ceb59n
}, {
  a: -0xf29e6a888609aba1b3598c0da197f1c729482n,
  b: 0x29a19bf186933f9d4bb28a73d34413c46n,
  r: -0x2774887bae814544921b323e56758b327cd929f8d9a77ce06f4a68d52873a8bf25138cn
}, {
  a: 0x2a9d207550997a1fc5abe9e477a57cbd17794c03b8512d12f89bc9433099fe11837n,
  b: 0xe27n,
  r: 0x25b15b65c47ac0f57a683fb20594708581735a2c8a584d4e77c64bd55e4d35aa9db261n
}, {
  a: -0xff0a58fc975ad345943a6f25604b0dad43e841cae5a3738cn,
  b: -0x54559fb4b77c0caaaa66fdn,
  r: 0x5404b2bde4df7d54fd2bccf9f119577895fb77c138846d65db92ff0cb020d9c58af95cn
}, {
  a: 0x1b17n,
  b: 0xa69c5689f1f1af9296c908b4874d02a9cefd29160ad14b0c336d6d4090a8de2546n,
  r: 0x11a1752c52e93a3b3c12bffad27d473326164c14041f0bb80785295aa00ece99e3bb4an
}, {
  a: -0x1e9abef4401ede4b5cfa402de36608498n,
  b: 0x3e73a7b7e24fb6b96cbdd4c281f0ad139d23en,
  r: -0x7774dcfdd7e424ed20419977e709a3023b2cd118dbb6c0f5fd52689857819f5fcccd0n
}, {
  a: -0x8fdd63e980b8f7040079549f04baf3fffa70a1819b1n,
  b: -0x6bd3c1bd97ef54dc0bf8b36bc1cn,
  r: 0x3c98891c666a4a710ef884907f737b972103e8ed69775d825f617084f2c3c653d6cb5cn
}, {
  a: -0x5621a2n,
  b: -0xd14bb08d59ee471d53769a6efbee5a724b1bec93e7888bd7b8dc713b2c9266adn,
  r: 0x466aec8324281683cdd228fc3eaac788e333639ada8e5018e767656ff9415f91ff467an
}, {
  a: 0xb1d2669d5562f74ed0aan,
  b: 0xdb95168d766c56baeb6c2638cded860586b7e51f2ee5bc399en,
  r: 0x98868ce8a994a2773abe2d89e41ab1feba1a68a0fea3c92a912101c284ef3a7df2a2ecn
}, {
  a: -0xaf4bn,
  b: -0x8e826b7064951a9731cc1fabd4516112265b6ba635e9de4b19003ddcde20084ba3n,
  r: 0x6194e7a74eaf64dc25562073bd7ad532d889bb5f288caa7976177d5c1b8cf90e2295c1n
}, {
  a: 0x2b91c28877n,
  b: -0x10a6b47ad509958b8dad8fb635bdd7511afb8a5530b0a7d79d0562b06997n,
  r: -0x2d57b64106dbb23ae4a0e76ab336f05b179a155516f39b59f2c852f414bca23874d31n
}, {
  a: 0xabc84de076c4643ffec9n,
  b: -0x338148b90f5f59277338ddbdb59eb486183d8df2c8c9b45c2en,
  r: -0x228fa83f79bd19447d497f0610236ffb2efd1d89d5eaa1a238d90e685eb663f964041en
}, {
  a: 0xe37eed493eb31126fc980fn,
  b: -0xd7d3c105182f4417453c5974d668d52c53dc3a4e3d82a7dcn,
  r: -0xbfcbc66d4ee3d2c0edfc8a0a3f5f06dba7e79ad41c86185055773782ffca3f12e275e4n
}, {
  a: -0x68d94b9d8cb62cn,
  b: 0xdd9679ad6e7fc2476656b103336d9ee9546e73f1ba03d3f962bd9852n,
  r: -0x5ac1376f0da0f9901902443ba1c00f88a4b1513d0a8bb08bcd76ab1445232f59b87a18n
}, {
  a: -0x2f039b9190b1e2262eb1f2dbc9429cf68a73n,
  b: 0x3f8c96cc7a7f71902ab067ef2cbb4536f7n,
  r: -0xbabb4f390bd4a7f385737bae2e546d4146b5b0591a6611f866d688005cabac512d6f5n
}, {
  a: -0x833afff2ab9b505285af941a70bbn,
  b: 0x771ee647802363f8e87d490aecaf0dbfb08d43cff7n,
  r: -0x3d1043ef7535f54ea5594e775688a09a153c6d47d9e0e540865d0906064dbbc69af96dn
}, {
  a: -0x686580e0b4eac47a7e5e35eac521ad57e32fb0c27bec89b630cf6dc88a9n,
  b: 0x4cb9ac989cbn,
  r: -0x1f49d9ff46d98f470a2bb0dab6907e4429f35b8c2346a60e25585dffeafac3bcb3cf03n
}, {
  a: 0xc886272ce0ecfc03df1702198908f91d8d8a1n,
  b: 0x27530eba344502454b81078696db6e6d3n,
  r: 0x1ecd7effba5f4007ae9931af1628776db534a1388ac666d30fdef4635779cd97d132b3n
}, {
  a: 0xe36620e410a8d31391fn,
  b: -0x909148e59a0f4549b658a87ac494e5b8c155cc6c2610f627c71n,
  r: -0x806a80199700f75e12e7b906f5c5eff99a0ef8eb5cf8fcf55c28e7d305e3fbd9433aafn
}, {
  a: 0x1d67265c1fb33002fan,
  b: -0x394a8d45e47d88012d79999a5a26d40427876a8ab442257b6250n,
  r: -0x694879570dc6ced7d7c1a177ec32d785593aed95a7e498ab49088d69e8173f042a220n
}, {
  a: 0x63f3a8f94b645f1b7e735c63cf580c23853a71e286098n,
  b: -0xd428578165f8bac6160fb9fc9n,
  r: -0x52d5882b2d68035227001820405bece620a34130ca8f2e439d2abc9312e95976ba3f58n
}, {
  a: 0x475c9b1b70be233c6eaffd77509fn,
  b: -0x32e6fdbb15ed125c2c02f025d62776141edb28a659n,
  r: -0xe307a3962b887bfc6bba92f90ea7dcab20dd973b599d39f6acbb3b1af24c91a9a2147n
}, {
  a: 0xc66095f3318ff72548a94e4c2e2405b52n,
  b: 0xd30b7ee35b037e7e01a1f04b36789f24ce52dn,
  r: 0xa38a84119b467d618add49cc66f51fe36dba4e381e4bd9a89e09f5cc0f68f5f758676an
}, {
  a: -0x5cf836407e0e9715303703af63e832f6319cbb371a93a5950e2bb5e1c47eeen,
  b: 0x7198fbfen,
  r: -0x29411ed6496658ef6f789696626f6f56b86d969c6083bb7c3d992405907b8414b94a24n
}, {
  a: -0xcf521c948c73726134dd631ba62fe7a67b39ede2952ff02e40f1f58e68cn,
  b: 0x92f27a68959n,
  r: -0x7701330d90a06c782cc138ff5a88730b1cca558ff78b057b90fbd2450f7f814c1112acn
}, {
  a: 0x650n,
  b: 0x4e07735fea6be9fa2145d45614339f96aa7442584151a66bee0d88527e8fda1562fn,
  r: 0x1ec8f084d77c934faf208cc5f5f85df6713fde2cd1c536a894eb56c88beec10a7008b0n
}, {
  a: 0x73bb314710684454a3927aca8584601cfb5ac9c28b5a502124c94f5dfa338e26015f8n,
  b: -0x6n,
  r: -0x2b66327aa627199fbd56ee0bf211a40ade420ba8f441de0c6dcb7dc33dd3554e4083d0n
}, {
  a: 0x2f258d6a9e071c155698b8a13dff05b49d489dc5a4a53634ff02a982861dad65dn,
  b: 0xcfaa9n,
  r: 0x263ec6ce3e20a951e6fcff6ae40f13d64853c2446e201927c7e24e469a787a5b2a5565n
}, {
  a: 0xc5e4f8ac865446n,
  b: 0x6c110c9acfe995e6f6b1628030c3e0f97c640ea83ff3b978f5cb7d39n,
  r: 0x5389c6dbb43edd900cc57ee7ea337b2accfe35e300f9c24e94fedc857adb97d290f196n
}, {
  a: 0x9544f43b273ff00d23036e1f7e6bdb051eb90ea4f15010dc60998bn,
  b: -0x4078cfc0ece51850n,
  r: -0x2597ae8484de89180f82d9f5a1800321c72ef42c096b7e18d4583872eb572369ec0370n
}, {
  a: -0x9368deb59e565dfc6b8466aaa7d5bf32b7c4a921cb4n,
  b: -0x39c4d146b8611840966dc3ff8dcn,
  r: 0x2143ae6249f8e9c0e9e2008f173412ba6ad3a256e444c1e1b1aaa0b4cf756561ab0ab0n
}, {
  a: 0x83c16aba6519db907n,
  b: -0x556b01e22a1f884e7707ca48c07c5661f185396805e5eff9779fan,
  r: -0x2bf64b3fa752c0bdb94b279d532920aafc16db4ab2e8d05463ea60cf05fee75c9bffd6n
}, {
  a: 0x341ece0f7fc8d6b14511a8e326094n,
  b: -0xf9d41a02e45211e5d9442c203ffcf04ab77ea9d80n,
  r: -0x32dd253b6fc77f46429a350528553df82001d16a36297d55ce5d47c31a0e4911b30e00n
}, {
  a: -0xd8d6882ed10be09cn,
  b: -0x6efc0a491eb2e8f13f4f94002e15bc28efd15aaeaa2474a1adbd21n,
  r: 0x5e01aa687c683a2724c6b7a9bddc4819600ebe4318cac678ab96d363dd92579cc7201cn
}, {
  a: 0x4f2b71c418b36aa791f0d109cc178n,
  b: -0x2a7f66ed844f21bfd1c85cb29ee4f96662eb3266fn,
  r: -0xd24870c5fcd0464e5e0236211bee37c5938fc6cb6a1ce5dbb77acb01895504f97b308n
}, {
  a: 0xb60504b4f905bb5c5a454b23e6daf86adeb17cd60bn,
  b: -0x62da1e08e03bf9707ee72521af3fn,
  r: -0x4649016e2f94a412a8f162222dbab6d3453bba661cd126bda9d89c9b5b0216327531b5n
}, {
  a: -0xa0701a1b53926db7d0cff26f51b446e16833e485226b82adn,
  b: 0xf63ceee81b735662fad31cn,
  r: -0x9a51e9160fc77776856906bdacf1efae41544969e5e2f4df4bd57bb8481c103768e1ecn
}, {
  a: 0xae8ec223db3fc30aa42967ed597424e1e807c66ebc116n,
  b: 0xa5f5bf7e2013a54f3dd6e9acan,
  r: 0x712994536b9c788af04f8dc02a59e165a464a79cc92fd4af66d7c879c976f1fda1975cn
}, {
  a: 0xd268818c320923816b3506190e32e9e98fc3n,
  b: 0x753eaded04cd54baba21afaa35b2a571ben,
  r: 0x605d4777e1105d64f0437b04b6e2a58889d5535fcab625967f36d013716de7f27cc5ban
}, {
  a: 0x90d5n,
  b: 0x604b1d4b15c0389b8974cac3a591c1f1a4810c1672a7982a4f26ad2c54c79012e1n,
  r: 0x367a5ef99bb538c696bb103ac1eabf5e4a96762baf2bab0967b99c970592cb157e4535n
}, {
  a: 0x53a53a8n,
  b: 0x3a80d9dc01cac1083d9c4e8cb618ed6700b78925743ea541922a7bd9b10492dn,
  r: 0x131d890d312aaaaceb65c54a77ae9aa61adf016c7aab4b05166a77701d00d27f9b9c88n
}, {
  a: 0xfd4687dd5d2a8c1b4c769aeb0396474dd35d7e07be052db0e604n,
  b: 0xc6f4a8c293e137234dn,
  r: 0xc4d69b457ff6415dc76a5db97b286755bf71aacb769ed4e15fc50a65174444dc83bb34n
}, {
  a: 0x313312ef3b48b32b107f45b038cc41f26fd16cn,
  b: 0x19e28f831745e8a8eb8eb998f57c1c6dn,
  r: 0x4f98784cd2bc864abaac935a1a6267225b06f21ddb4ba9416e46f5a20044e40d3fafcn
}, {
  a: -0x4f9f171dbfe132aa3960b3f2e8d1c7a6e6b285c178658041bn,
  b: 0x1c33e34f3f94ecbaea07cn,
  r: -0x8c589eb9347d70517b6fbb736a95c2d6b3b9ef4d38e719e600dac4d10edaa488cdd14n
}, {
  a: 0x4e449b6dd6b6f17e5ab10cfn,
  b: -0xe2a062180c2a94f1110649e34c3e4de9b39bab2850109een,
  r: -0x45499a15b9da8e1aa85e1907acab66100e0c5bf2a7a255745ce52f8871fa9f246fe772n
}, {
  a: -0x7695f3c8fn,
  b: -0x5a3b909b20e06f8725b0871c5c9fd5edd650b41872f239693bedae96317f4n,
  r: 0x29cc4f4008d5a7015d0f20f06bb28e61cffcacc91a221e7e915e43bbeed3408f83914cn
}, {
  a: 0x45b1454942c79d4223cb3e92eec9656442e3ecef8a764973c3229a35f3n,
  b: 0xc8a91eeb03ffn,
  r: 0x36a08892ba78b81a0e0d61a531c1ac361d5c433ed6f4b066b64a2723a7e414464e960dn
}, {
  a: 0x93n,
  b: 0x2cc3f3127524319ca572d1297e6184e45a9cc456a899e180d7a9ca3b833f845240abn,
  r: 0x19b484939943c87cf300ee1ad391ff4f200804bdc2d05c7cfbd67f202c5d78fb3b2231n
}, {
  a: -0x9a8163bf95eb0d146c72e5f00cd84d2a326e217c101a5b16e3f762ecdcn,
  b: 0xe0223cb665d2n,
  r: -0x8745e11b4b71307fb115bd5e663cfee35393af9f9d38e6bb2ab878ad31bcaaeb011878n
}, {
  a: -0x4e734991e6aa630f23987c16688c3c77bd0738adcf0c9d2d68dfd922d945db4619n,
  b: -0x3241n,
  r: 0xf666fa42d18d89c1bcbd1f3e21bef6abd5267e7569208e6c703593ef048cf905dae59n
}, {
  a: -0x834c58ebc2b6a97d174a16f4e5b3bcf86b7cdf7f2b8ec6126b4073f35ccd00n,
  b: -0xeb098f05n,
  r: 0x788bfca9c230f460a005042174bd50e19278dd7272bcfea8798817f992c5a6cc530100n
}, {
  a: -0xeb55986bf9dc129546n,
  b: 0xa80478a07128a41613ab97da38339e24f287cdf0f6a244cdae8an,
  r: -0x9a744840daa058bc2dc53a1feb2b0e26dd80613f6ea1450240ff3cb1ebed1964880bbcn
}, {
  a: 0x8117045b27cb98fn,
  b: 0x263d5c75528d54b2bc4b40bec3939b2416485418857ed9b2793450bn,
  r: 0x13485bc1005717f5b38911d7c0a840348f6bb2b27a00c0202f2001b31fd6929f7c8425n
}, {
  a: 0x53dbc564879a1ede1f02a79b9c4786fd70496894702fn,
  b: 0x5185166857e7ac36cede3c95b9n,
  r: 0x1ab421f96d2c9f228b0424744210ccfe9b0ed81beffe71049c401849164ad005946cf7n
}, {
  a: 0x2a084n,
  b: -0x4130786de6b7ced6000d179bc31597f493040ea690d036d76949ec9c6a7d1f163n,
  r: -0xab40d91e964d75b8667a64b90c6946045c06748cca053b51bb745738982f5a1e4570cn
}, {
  a: 0xaa5d9cda0d751n,
  b: 0xb26948215fa3fbff14510ebddf746da661e430155fe098de0368cb162n,
  r: 0x76bb27757c9f548b8bfa5c8d82bc18080075c2e8e9eaac94cbf8da786879cdc2bd6e02n
}, {
  a: 0x1133712a938a94af5a3a921df5c1a3c4n,
  b: 0x57465c82b411d7ff68da14647a5e36e7e0b6ban,
  r: 0x5dd35bdaeac9390ca505e5cf550d64a32afcaef247860c8bcc6c5a1cabe09609e5468n
}, {
  a: 0x7664d077a0a07e1c55dbf873706bd499ee41fb7268d9425c366555149099c47e0a4n,
  b: -0x873n,
  r: -0x3e855cd62c22c0989697194375edf155098177f87abe3abb11f9a2ddcc1c33734f09acn
}, {
  a: 0x725bedd6b510fd6835f39b81d1bea27b1322ba19d312dbfa32n,
  b: -0x9134a4fbccb455620ee0n,
  r: -0x40dd96164c1cf4cc90c86ff01a523f243f4842e883d7b5d79dbc046d622928e94da7c0n
}, {
  a: 0xb4c04d9863a95cbdf83bd9377fb8bfdc287b79a711450db9acn,
  b: -0x396d0d9f8f1cf0d71423n,
  r: -0x288bd0c6647fede509dc8a8a4f83abe248ed5055e02298a83bdea028f87029b2d5d284n
}, {
  a: -0xb57ab5eb9c5a87b44573ffa7c2d181fa8e14e4e33887f7df7n,
  b: 0x659805a3c5e93458ff990n,
  r: -0x48052ea17790bc26ebd1fd004215c0f70e17cef2f51c7a217f86560609bfc0b93519f0n
}, {
  a: 0x3d4ae80d530da290f675291ef33e4dcc3a4f1d3b4a679cde2034c0628e08625bc1ffn,
  b: -0x4fn,
  r: -0x12ea1d9c1ca1352abc0e27b08d103a0205fe6a054bf5f9688bf0475e69d4965a50ddb1n
}, {
  a: -0xab4a76cedc25951d40d2a3779c8819574037bfbn,
  b: 0x2c257f7dfeb5ad68e5fd31f9f9ab67dn,
  r: -0x1d89e37cf8765ad678cdea9e96c2cc861830f540fb18526842965ef1be5ef299d5fb8fn
}, {
  a: 0x15df394af761f9c3n,
  b: 0x18faa25c7c757e25e283f56d08db48c6f077913d76d391a66c1f8an,
  r: 0x222573c2382f621b1983134069902742fb38a173f66f255c8b580108b0c1b0853401en
}, {
  a: 0xebc0d0bd186c79322af5ec129268e66999cb17807eb059c2f1n,
  b: -0x365a8dda2bea8c519ebfn,
  r: -0x320e1073633cc1b4e81fb705a5af637a1b3a69b3d38fd8b59188c0fc629da9738a2fcfn
}, {
  a: 0x36ece4daa1b3a46edbf77c9d4360n,
  b: -0x1af519209561444b525440060f611207b93b701933n,
  r: -0x5c8a55959abb45b6ec2ef6576648186bb3013232b12838560858252cd112dc8e8cc20n
}, {
  a: -0xa1df2603e95c753fafca855b0c9ea2c819b470ef6fn,
  b: 0xe01c8d1b25839c688f155b181166n,
  r: -0x8db54ee4a6d00f3b3322a29187ed20132a8a6b632e413b83625070b5cd24074c4dc53an
}, {
  a: -0x7161a0380773b0734fc2dc4n,
  b: -0x9959f2c1efa98a28cf3d8f63a9f54e06b12855ac691ea1an,
  r: 0x43eb2f365e22b82e052196e8fb0b865b79ced36ee3602d9302ce63d2578e4d6775cde8n
}, {
  a: 0x72519n,
  b: -0xc56cb4cddcb88e67fd77742ab0e67c1fb955c1d977690c24265520b585f2578dbn,
  r: -0x58294ef60720d1f72de0e319f5a09fb50c63acb56a05e2d007565f10117b68031d7463n
}, {
  a: -0x8234f3a8427c8345486522en,
  b: 0xf358fb0ea2ab25c6f901be60c743a5350dc1926920cc28bn,
  r: -0x7bc5852dd57ae691b1565ca8d0769ed3946ae05b5c1187662dc103cb789e75c55d7afan
}, {
  a: 0x182n,
  b: 0xcca3d0e087fea91db2bf446ba17c005e1349aaa0981c34fd3d7b0564bbf58470620n,
  r: 0x1348f00f28d0dfafec784652a497cf88dd9151346255a87e5d6b37e21e36831b173c40n
}, {
  a: 0x42f6f2n,
  b: -0x4652ce1a092d8925772e6eaa5f83ac3b39c42cb62befbd10bf0b3a6dae8e547dn,
  r: -0x12652f2f0a372bca7e5fe9d028f4c9393e9e12a560a63ca6a0124e7309a21d8ff5fc2an
}, {
  a: -0x40bc8743327f9b492ab6f7d0cn,
  b: 0xba15f7b706d513b68101734006214d8657e598d800ce1n,
  r: -0x2f0e88621a34af1160de90f3a0cc4f0364911f71786c3c550114f1d7bb15bc08d9778cn
}, {
  a: 0x5dc31249c0a8df380088e286b668de5f091af313966da83c6330a5739n,
  b: 0x2c395601d3f80n,
  r: 0x10328713f313620650732862faac1eb044af9915548ce765e3667fb82e81b75217a380n
}, {
  a: -0xdcaf40af6b4687e8da0d9fb5bbdc76448ed392546ddfb443n,
  b: -0x7ecff65dc949dbac41bb25n,
  r: 0x6d5187ece5fccaddd7d3788a01d113d174ac4cce3757a98d3fc657ba1b55b11304feafn
}, {
  a: 0x8e4e932e82efe48df4b32038e85cfb9d9ca911d6386e8b9a8eb4458n,
  b: 0x20bbd7c2147b5b4n,
  r: 0x12323dbb33e1f0fe40908a3f6ff5bbb37439cee5de4ae0a678b2bafadd26a8692645e0n
}, {
  a: -0x197ee16af736900226n,
  b: -0x23441be53f0b7194e42f8e921bc4ae9ec13396abd3866a902461n,
  r: 0x383214cb6c36a2d48c676ee4b87adba7df7f289d2cb07b6e8fafc42a30f20de3e2866n
}, {
  a: -0x3c837fab2ab7e88da7c231fdn,
  b: -0xb24c0b5a00b43a5d7c9795837d3e32d11dc9b9dc950986n,
  r: 0x2a25687dd76665901cd865559b7c1eba62af549dfd3661a1b99d4bd54d00dd27a90f6en
}, {
  a: -0xb27bca0682d6e3b3f46e2d0d7f4a209ddd9n,
  b: 0x5402d993c22c76c93f0b0237634c5cb3b80n,
  r: -0x3a929af3a9b0de3b228e72a9af0cef2acb01a255d9f69664f4b23204cd87483322ef80n
}, {
  a: 0x85219bbf888f9d541bd1c336751a8n,
  b: -0x3b416478dee65c08b103b2c7d956abd5b3409b3fan,
  r: -0x1ed0c0adac9d89f811201a1ed0395cd7e02d3bf998ca67245e8320be6f3f6b6fe63610n
}, {
  a: 0xef06dd5d4ce26n,
  b: 0x13a479cb25e182fd662a06afe71c5b7ca208af1cfd989f9ac87dd7450n,
  r: 0x1257148ba8eb3dcd97958aa83514dde3d2e224b4ee336f749594d87405302b40b7a3e0n
}, {
  a: 0x87f20a808ccd2b7n,
  b: 0xf68d1e5caa3f7f08b9553c30dd3f214527e65b56f47c616dca39242n,
  r: 0x82ed8686e2b9fe70d9d6e85f4f4a826a54cdc45a0247df5bf1e1aada488590837fb12en
}, {
  a: -0xacba368ad93e0b26735581da6n,
  b: -0x20bfd9a4dc32c61486fb8d9ac1e2fd2165b95c4f16b63n,
  r: 0x1618b89920d8c2abbcec12a9dc99d6ebfbb2dcea3aab5d2d949075298e137a76bdd932n
}, {
  a: -0x633c4152745ec87e42040b538e78c535eed481bd81a1da0d1174bn,
  b: 0x5d96fdfcc7de40309n,
  r: -0x24476b7dc3ef667532d1a35ae10cf1b9ee144974d40c7298238ba5333e7b49786bb2a3n
}, {
  a: -0x9207c8b4393299714003d92231653dc046855506n,
  b: -0xd97a5e3cb880057d048e84f91fb56cn,
  r: 0x7c0e6697e922fcb375fa38f22e24cdf241b4aa6908ca7150a697a57e4063ea27171c88n
}, {
  a: -0xa96757184830ed3fedb9c0d95e4402a52ac418f760fc9aa475e206bb386n,
  b: -0xbbd4b6ab3c8n,
  r: 0x7c4b3f13a4d2e2726a010a79f1ba7e8a871aebfc640cba3e0765a44da1d8533a26f2b0n
}, {
  a: -0xe71a8e9ad03d9a6e664159ecce481be679fbf3908eb1b2f07c6abcn,
  b: 0x9ca148b8b260f7dfn,
  r: -0x8d65c8403a7c8b917406b2433e0ebc6f0ae16e96c9705a20d3023f2fbeb8e645dc5dc4n
}, {
  a: -0xd3df614ca6b0226aen,
  b: 0xfe4deee70e1ca016383fd3f580e71e321b0b19a01a29827f67590n,
  r: -0xd27822733824dc8163639d482793120291285c9fa683732b20a0e2db2b7009da1747e0n
}, {
  a: -0x97n,
  b: 0x1303ea293ca7f0f2e2d39781c295a3e28bc9304c05d44b62c4350296c2d8408b6c66n,
  r: -0xb374f1e52c70f1f43cace5d89c643aaa073ab7cd770387741bb4486eced8e123cf02an
}, {
  a: 0x337fd7e6ffc9a4ab426478666a8bfab3b4fn,
  b: -0xda0f9e71c080ff94f241c06f71a57dc0d5fn,
  r: -0x2bde023825c367235a40f3e995164931cc9259145070a4c9ea1ee7a5b5d1afa3720551n
}, {
  a: 0xaf3db09075d13c5bd61bd1767a1df07en,
  b: 0x7ad48e01790040fc0f5124eb2fa7bd7747fbdcn,
  r: 0x5414e67049c96ee4846cb84de18d89cef5aa00909851e607b4bf0af205b3aa91783648n
}, {
  a: -0x5dn,
  b: -0x5247b6debfc75640052fe5b90327b57c3d0128cef04993fb0f346db5117db435ebcen,
  r: 0x1de40d6eebab6a5541e2667436256cee22296bd32d4abac234860bdac75aaa7796a9d6n
}, {
  a: -0x6c24e8c23343f661f144189f162be366ca8186e33207e867f904n,
  b: -0x584aae2ff37668b8c8n,
  r: 0x254c3c436195f7072bf01e9017fef6c9eac114fdbf2f2670ca62b3bfec37094dd56b20n
}, {
  a: -0x79bf52212e6d64fa506440033c65446bc8970287bb752936bc545bn,
  b: 0x99d05e07ea64842an,
  r: -0x49267040939136d91ea19e7d393f34a0b04601947bb96dc82cd060f05bb82537f0c2een
}, {
  a: -0x16b028301398ccn,
  b: 0x8b9f06473d38d2b69ee51b33614ed147d4d27785e6d6db0834f0c115n,
  r: -0xc5fbdc981b96b3ea7a14f14a707acae258e6f8fde3fb923c39525b2f71753670d54bcn
}, {
  a: 0x692b436090n,
  b: -0xa1be179d52227d4e7f5d2d6bc9a39041882623906ba65c8add862c9e7af8n,
  r: -0x42724d2f408ee5f6905a8b8924479c62295cc3581b9ae73ca557ddf1cba80e5e2a2b80n
}, {
  a: 0x50484ac8783b4ac96fdf44b3c1fn,
  b: -0xe9527fec6444a619f402c19d0237aa191f9a7c694f8n,
  r: -0x492bab5668d4a304bc65144ea51064f28cb1dd776cf98033e65a9d10ff26cfe09e2a08n
}, {
  a: 0x1b93ca389f451588ccfn,
  b: -0x57524b50cba132e1f72e35f6f09eb1a350cb9ce17bad35b3f1dn,
  r: -0x968172d04a0d595af49538b051dcfb4dffa7e4bbc2d92132d37477aed8ea0ac43e473n
}, {
  a: 0x43d0d4eb417be5f59b3096c8fd752a7eabn,
  b: -0x1a090575611fde3d611ae0df75cc4b5e717en,
  r: -0x6e599698d405c58a7f027bd3b921cff4652152df1d13719314ed248095d72089dd32an
}, {
  a: 0x35e97041a39a1a2fc217n,
  b: 0xf50ba748416f203a35ef887bc01302d900cf388191a83f27c2n,
  r: 0x339adcb1240e9360268158bdde0a6de9bd6df12e3cee1740b1476369a8c3ebfa6b966en
}, {
  a: 0x567e39ffd426f83aea1696b2aa1d1349cbfn,
  b: 0x1c37fa45434fa0baf1ec0f60996c3ebf04en,
  r: 0x988b8051c923f17eb587d70ee482a408985dfab0249074a86078749655f0a714fd232n
}, {
  a: 0x922a98ea80bn,
  b: 0xc86c5991d7c87c397d1d67b9de413ab6150c74c30b896603ebb2ff3d48dn,
  r: 0x726f2493cbf62c71f1f592c2fdcb8e1f9b45bfc46eff7ccce516f5eea549ce0e2caa0fn
}, {
  a: 0xa5f9e832715ca7acb47c0e7fdee2c77ce3847b73125191bba2an,
  b: 0x3226e9e64d4e1cc39e3n,
  r: 0x20840a18169c42a1e1860255616a24ae9d251a255aa0d5c87b5d42b79dc9fbb3816d3en
}, {
  a: -0xef90e8daeebc01fa467a918069a92n,
  b: 0x167bc168889e33898f08e242b522afb378749c55cn,
  r: -0x150a43a0c3f98acbcdea98594cd0753e134ccbc2fda4facdf9e6f160aa1104c8f3e678n
}, {
  a: 0x8da6a9573fd9887c4de85476cb3ef7a438fe9d728724n,
  b: -0xa677508e43de52fe7cb1bc6fc7n,
  r: -0x5c1c16da17e091bd5395c1f79e0072fee841d47e2856259b4e052d024db12c2f0fa8fcn
}, {
  a: -0x7bafcdb9a0128effa23a516609bn,
  b: -0x7ab3cd998a8b3306fd4a9fa61cf69047e729a1c4c06n,
  r: 0x3b48a74d45d364418237e9ed75cb7747448377a75aa37c2aef54559e07456e522847a2n
}, {
  a: -0x66341c75c31223412d0482eefdccfa54738215011541708c4e021295n,
  b: -0x6cb230cf5389c8n,
  r: 0x2b651fba0300483e4416350d47761a006b9b6f64560e8a821f5cdd791710fe8edf4168n
}, {
  a: -0x3934dfb7306c5d90a1aec19be24189a6ce25ea0cff5e823a1d15dcn,
  b: -0xb76289706dd70449n,
  r: 0x28fad0e00324790b68779df17826b9bdcdab13c28a11cde72c317d240d79070e66abbcn
}, {
  a: 0xe2fa670e7bn,
  b: -0x50ddbac8a286c3b77f17b9a792096e4d65daf3a39db6078ba4789ffb7f2cn,
  r: -0x47b2d7fb508b297ea1995745e59fe9b55690771e38f310e31f552977e0dbedc17e8224n
}, {
  a: -0xacdc6adfab2f46b0c93499b1accfn,
  b: 0x590b9dcff43b3a72ecad6691a008d08d607be742aen,
  r: -0x3c20792ff2cf75944404936ea18a4cfb318b9296f8c15cecd75f10d3562f5aa919d2b2n
}, {
  a: -0x629eb4b5871f51451b76fb0339fc3eca0f35def55c0a3c0cda43e56d5974489b2n,
  b: 0x628a0n,
  r: -0x25f5eabae794d3fe43c45a3a8befd20332bed2641d7f88814a7ba66d8930bc7a85df40n
}, {
  a: 0x829483ec38222d85287e9db85a0290cn,
  b: -0x50e2e209fd7f9f96b0e9949a2f6415edfbe3f96n,
  r: -0x294223a27d1148b6f2745b61534ffbacff39926cc001da6aeb8a7b5d46db8aa0da0108n
}, {
  a: -0x388aac04501389455f41912ae69a0d71d1442b388809d2c3b85213498818ac897db6b1n,
  b: 0n,
  r: 0n
}, {
  a: -0x7an,
  b: 0x924fdd0c95dacb1b0808acdbcca1915661a1f7266ba08fdd081f0de5bd58bd00f9cdn,
  r: -0x45ba0f57ff6a44cae1d42260bf84ff432a872fc84f4a848f55decc9f7c3c4a12770bb2n
}, {
  a: 0x634bd9aef170ec859a88db51e6604e129e2n,
  b: -0xba0991b946718b110f7c8a26dc604c83138n,
  r: -0x4828d2599601b6f08d071c8d57818dcf83cd05b0b16022d867e536b837209c6ad56b70n
}, {
  a: -0xf7f8f34f3725d79f6a87f3f7837db0ecb387fe7bb9b33ce1492d911c170n,
  b: -0xc01957f4e9dn,
  r: 0xba1342fe028ba760d45e4f657cc40d135878d5ea2a2ecf5031f3eceafb6307af63c1b0n
}, {
  a: 0xcc19d768d1dfd62407c4e6fe49c5be9470c31b0226f8e01n,
  b: 0x3a814111a8cf6fe84d3e435n,
  r: 0x2ea4e7b3ef5dbb09380a9126d079f891b68dd7c7a05bbd19f5dc967764ea4b0a644a35n
}, {
  a: -0x62f4a9e1f429c49170646ba541943f85c0n,
  b: 0x8979e2d7a3ba6da5e22b28a5848c4cf46bf1n,
  r: -0x35240c3d9034c0914495b7522865eb520509640008a49295c831d58a6148f397b429c0n
}, {
  a: -0xb24f6ddn,
  b: 0xccd387ad6ac72fe2ac43a4cb4d3a8d2a6b80395d16d069202d16db7fedbae34n,
  r: -0x8eaaa179ef658620f3f49cf9fa900049bc8416b15e3231c2165fec040dce1ed85b5ae4n
}, {
  a: 0x1e910a1d2afc5eb848952d9613d9045aaf9af5527dd0c60b28113n,
  b: -0x3ceef3715b5d14b70n,
  r: -0x746864772b8ef4300fe032c8ed965aa822b3e7ef848906485880439c9284b696c0950n
}, {
  a: 0x9be7n,
  b: 0x9b50e9c2072206a902b7cfc852bb5b6a72e6336b0d5944ae7c60f9e906ac30987fn,
  r: 0x5e96238b686609bc5726beaac7da1768f09f0eda36ae18229ec0f2d1984f46cc2e7f99n
}, {
  a: 0x30da1af0448999599dfbb0a466c8dc25aeea14b2n,
  b: 0x6887230d0ce83de55136328f5ac9f3n,
  r: 0x13f264a61fc4cd29f95ddcf64d6aef2cad49cb7b65d36424bf039707de64b9870566f6n
}, {
  a: -0xffda77299267b6d34d3bf94d448af7da41ed6c9cen,
  b: -0xd00a37bd809291e5c5951cdef1b18n,
  r: 0xcfebb70fc2f79cbb5227c1e01be679786ca31d682d184621285b7f23c558f1e8bda550n
}, {
  a: 0xdb3ee32e75683f3512b9f7a4d5fe67deae9n,
  b: -0x9a008ebd745ff7f1e4004161c0ac33a01e5n,
  r: -0x83e44ee915bce412a064b436d0c898b2129cf0ec186bf95d0363fd51a3624060580b6dn
}, {
  a: 0x9c14abd35c85db4a8de1c92084ec528b25c1ff5332554742f51f00d00a743744n,
  b: -0x40f723n,
  r: -0x279bd83d738da19f856288870e1ac6d2bcfaf42babc341fa27a068a108739560362a4cn
}, {
  a: -0x6d2094baecd79e07c7c87653aedd97095db0123fd1eb577f7adn,
  b: -0xe022c65c90be9da97e1n,
  r: 0x5f8b5505f881ba5270f97e4954586c29e8dd0ada6667bde1f3363c2b1ec70b9fd9ba0dn
}, {
  a: -0x28a63d027611fd0c72163f7f9b4d03a1b999540cb76e6abb02b34n,
  b: 0xa083539bde042e70dn,
  r: -0x197cc07967bd390275c12e2e2bd20f409c126fc3cf3df9b7da17ebecc4113f52561da4n
}, {
  a: 0x787afa583c612fbff273e43n,
  b: 0x973d14eb065c9e36c6043eca120ec5b9ee7689f98713996n,
  r: 0x472d48cfea14e28f5475505fb8873944381e69dd44f248323c0fd944240c5e816e6642n
}, {
  a: -0xd00b9dc52732dn,
  b: -0x767eb68081ad6f124b3fecd2b7ec22a858254b0e9d826ad936abba912n,
  r: 0x604c54c138768ff1f7a5068ce43488f5ea6a1b0713cd21997479d25f3e5f45afb3ce2an
}, {
  a: -0xd60a9b62bb5e974ee33n,
  b: 0x598e874d6df28a467012e9a0fc36cb3d2ec5d5b4897a364b516n,
  r: -0x4ae0db07d8f6ec6021766110de04e3a0e1049c37fe2239fa5a9d5d135bdd1e41628762n
}, {
  a: 0xa2b187e8d8n,
  b: -0x88398fff654cd0abd17d2ed849978a1089e36e664db1eeac2f948e1cdcf3n,
  r: -0x5692e53e6fba6587ce7d96721804e97d05ecf64deb9235e48ad42228437de497bba508n
}, {
  a: 0xb6d01d878db266419db47d3n,
  b: -0x7b7d58f1bbd661b1dcd8a0693e8c874d59fa254cf04647fn,
  r: -0x582f8152b67a69ddbf84a2064f270bc76331e97fdcb4b7107c67d684a3f37f38230dadn
}, {
  a: 0x26n,
  b: -0x7b5fc1776f6d9ec16a47482db19646375853491dc369a2fb6e19cde1863b934c74afn,
  r: -0x125036b7ba8a4590b5c694b6c85c4e6c371c5cda6b01ae315257d48f79ecd7dd5951fan
}, {
  a: -0xf348c7eb269a9b32cd2697479a05b692df9d9a3bfcf7537272a1f0adc5e72n,
  b: 0xbf30ea514n,
  r: -0xb5b1c97bab7afb735304737fac1e1a8cab92f62334bbfe6624c229c9af21064252dae8n
}, {
  a: 0x217dcb94e9a8e52a29d1926952n,
  b: 0x32de19f330df144234520718ab40341ea495b3a66458n,
  r: 0x6a7a03eba742bcb002373c0c9843460b19e83dfd743b68f42f305ed31ed8bdca43c30n
}, {
  a: 0x7b4265f1b27d89ba4n,
  b: -0x96ea65f1754364981cd6096a74f39bde9dacdff63adb359e21389n,
  r: -0x48a9c38241b2d4cee739fcceae494e367f0a169289d8f586fc4779727a0c7ed14076c4n
}, {
  a: 0x813c3ec84cfcc1951650f8c47c51d9f4c960f7bbc827325fc8256b6an,
  b: -0xc4d918b9931007n,
  r: -0x635fb89de7649bc727b534fda3ff356b44ba8a4fcd9c43144fead6c992412d179a8fe6n
}, {
  a: -0x3313ca3c2n,
  b: 0xadf8785ac167e7fe0598833c607db8dc074a896f54791fd805388b0faf861n,
  r: -0x22b5f2d9ee36eeda7c8d996a2cb3abd9eb2d0c5767eac642b025b5a149c3c5b211fc82n
}, {
  a: -0x7d440d694d3543f2d855768d1849a6b3ec31cf192f52db2e3ef3an,
  b: -0x393996149fa0d7648n,
  r: 0x1c00549365ebc4b68e75d654a1952856a97797032f7387b47ad4796aaae40b2a520450n
}, {
  a: -0x72319826faad5e6090b70cec420ad99c9cb2149en,
  b: 0x93be0d274d223d97b6997f1b23aaf5n,
  r: -0x41e7410b5b8ff35be981fffbb40caa3323ae92500bba8254ef5327b2d31fd7b3b8a736n
}, {
  a: 0xc7269788005acf7b958d397b48e0172be6e97d72e2ec53edf4ac9bbf53an,
  b: 0x4616f6e8d97n,
  r: 0x36866ad46f85b775c8fd632a6b943cdc06f8b5ba2e0326ec4aca8cb8b9e74b08da9736n
}, {
  a: 0xd2d62c588bcacbb06fd18550937657458768fe1b0d72512364efn,
  b: 0x5cef49569a51b7ad3fn,
  r: 0x4c8a0a499e97acda708ba00d8ac40fbf28d364ece5ec8525ee6d64357cc4f9a8c459d1n
}, {
  a: -0x433271d243517671c247011ab9938255dda410cb9a438b612e13f3fe7298dd51b9610n,
  b: -0x3n,
  r: 0xc9975576c9f4635546d503502cba870198ec3262cecaa2238a3bdbfb57ca97f52c230n
}, {
  a: 0xce10e25dcb5996c7b75b7ec8a4f257673e055c67354301d192d88f2n,
  b: -0x6d1a7040477605dn,
  r: -0x57d278740de31bf47e7cfbb70998b756f2c3c605da534ce0c2dc7ddc29d019a9637fean
}, {
  a: 0xcd371f843742n,
  b: 0xf3dcfb57613ba3ba6cde2ef10f620ae6a53bbfde97697d34d4b4b0a50bn,
  r: 0xc37c77c4ada72cb9643a302f6ccf0351bc31ed09441353a957270c5e4d2516f7abe9d6n
}, {
  a: -0xe5630a13ac31ada0c99c8d1661faa8d3ab10495799d2999e0c15e22e854c289n,
  b: 0x4050f94n,
  r: -0x39a150cebec1e255d2f2f07d5bdb536ef9c99dba6d3d42bbd07a60a69e547d39137e34n
}, {
  a: -0x1af04473c0e9333449e892e6fbd3ed31c1582ee5117c7b23b71fcd0bbd4n,
  b: -0xa52c2663376n,
  r: 0x116181747a22d64a42429c4caa3ea7c9650e25c132e6d316393e31c13277519c19cfb8n
}, {
  a: 0xe6c7f38b01a8465d9bd5b3eebd20305ca359d4d89b05626b6f80c02c11df12dd5n,
  b: -0x3b512n,
  r: -0x3579373e16ceaeaadf544290aa9e19f8ad00f7e57ede5dc392fe61f70e159329dbd1fan
}, {
  a: -0x99n,
  b: 0x8de9930fa2e1963365b371a6169ce0921e6737f708af0422492556d65c15edc7ba87n,
  r: -0x54d098e45858d2c4b7c83eec4383c237542bb072a43099787db750e61d091b1c5e7aafn
}, {
  a: -0x5b4n,
  b: -0xea68cc289b99b5baac689b28bc294892f736407a197c31b7cec1b3d0a2ba1ee399cn,
  r: 0x538ddac579768a06c9f4494e4511b71e629e167b859584b8c4728b581e00d782a08db0n
}, {
  a: -0xe01b9cc5380454b0c4f4563b496a29b0769daabdn,
  b: 0x91448911249994ae0b66f606c9fcf1n,
  r: -0x7f2ba31f21e29de6693fe9edca0eb844b02ebbca3630d5f8c6f75515f8274c5ae4c7edn
}, {
  a: -0x35a471a3e53746916d4993304n,
  b: 0xd479fc081d2eec7fa43d09e39fac2747cdb9e65cbdbc3n,
  r: -0x2c85bda50367764cb09aff63be25285c5fc752017f8625e0e7c3f449af83570782480cn
}, {
  a: -0x81a87bf2e5eaf3e5bf9d0a9daab4n,
  b: -0x7a266be9f7507189889e844c405759b1dca6b7339cn,
  r: 0x3dddc0bc1309bd0747042da06cc4245565ff19cca4e94fa2f5df5eda6b06e59fc1e1b0n
}, {
  a: 0xd6e48f1c85ce26e7347d9e7f844b43c4an,
  b: 0x31f768e17d4925c4a05349185e14eadb1667an,
  r: 0x29f16df4ac51ee88f6d713ef9541ecc199c17436ab494dcc86dbd5cdb42d983f143744n
}, {
  a: 0xcc75bb9n,
  b: -0xae7e18a358db737d8de948af275a4f564c7968636c2619953bf3adebce05871n,
  r: -0x8b5cbb1bb063aa1e1e456ed306b9c7c422225d13a32a21b94718fbb31e0ea4496714a9n
}, {
  a: 0x836ec911b3den,
  b: -0xa7b6cbdcfd3a2ab6533e4ed68e12f1f4f50a1b3bb568eec448f6dd4ad2n,
  r: -0x561b1e97cd93e0697209e8e3a43f30e903474f8c904ce579d6bd559558fc8fa929b81cn
}, {
  a: -0xe324e28f97fc5fd5602738549069d880ae98ec582d64f9a2761995f53950e7cb967f5n,
  b: 0x2n,
  r: -0x1c649c51f2ff8bfaac04e70a920d3b1015d31d8b05ac9f344ec332bea72a1cf972cfean
}, {
  a: 0xbfd36a9dd0a98e056256d4983d675dd0e1ad9261f3cb536a3f1d49386a802c37n,
  b: 0x36ac67n,
  r: 0x28f7c7b6fbf174d4c6808dbfe2c64ff1aeb1484bd922194b43425483e0d44a4ae0be21n
}, {
  a: 0x69755fa5fbd58f584dbedfdfbd142488433fbc1ef3bb6n,
  b: 0xc7fd150784f9bd71589373af3n,
  r: 0x52627f0347a28634ad834a369d9b79d5142b6ef914660b6aa7caaed41bd33183b6e9c2n
}, {
  a: 0xe9cebc3a79a5061c0d672fb667d2dc6285e7a2n,
  b: 0xa92e756a4f6e1f1958d76bbcb5415aa9n,
  r: 0x9a83e8a500fbd5d083cc58bdc8dafda2d7d20169a42cc2b84696ffd17e2fdd77f6ddf2n
}, {
  a: 0x4f19ed5c602355n,
  b: -0xae6529139c744373a12b0b2792f080599d912d00220b364dd1be51a6n,
  r: -0x35e2e140a5121432b03ecf8b41a5c7ee4dd8b1f1784ed175565aad201984e7ef9ace1en
}, {
  a: 0x4ab35e6f684431cb9bb47b8da6a2e444cffeae0b172ca526fn,
  b: 0x9263a02360971f2648fc7n,
  r: 0x2ab75df37c471d78a027e647e1a7e44f30f7e09292de5fcaff78cbb08a2c0360ae1549n
}, {
  a: 0x65e460c02ccff0184e0c2f9n,
  b: -0x25139f3294e2911035b52c46b8261f283deb81ec8049aa2n,
  r: -0xec1d14beeb1d7c98dd49ae455b1fbebf512b7d1fc06c7a995a075e05dc5e8df692b92n
}, {
  a: 0xf50ddadff76c1c0dn,
  b: 0x65919a06f69432d3ff00e9d0b8593bcb6c02caa06a9c88d48be6b7n,
  r: 0x6139d7a4557fd4613e473985407d67315ce40a56e542e13f9466effff6603afe8abb4bn
}, {
  a: -0x81n,
  b: 0xa335fa57e1a0f0e16d88466cf903c94c033992c763e46d25c968ceccefbef8b5fbbfn,
  r: -0x523e332648b219619831ab7ce97ae86f4da002f679561b000a7dd03544cf3b53b3db3fn
}, {
  a: 0x3d6c2e0c25180f3c87e12b328274943e80f124fce3a67d60e6a9c30373f1n,
  b: -0x19360581d6n,
  r: -0x60c86a329f10be670779f9b8349e22d9c781f6a6e997029469c7aff06393cdc045c76n
}, {
  a: -0x2f7114f0c34de08311bbdb0c4f980b48e3n,
  b: 0xa137c8c2c19ab75648779d9d45e5d85b859fn,
  r: -0x1de074ab5a7cd3c07230cd911a0e01cd6c90ce6ef0ecc09dab932ef9faf2febc9133fdn
}, {
  a: -0x246a17d73c8e43fn,
  b: 0x3c9202f5a6c0bcc14a2b89d4c0386e247b46d80279e6f5011f0ac38n,
  r: -0x89da283d0629665ea4b757ef7c349e07cae884d4eee61813eb4236fe1256a775c41c8n
}, {
  a: 0x6a0dn,
  b: 0xf222f89e9e871cf40f0791bcf5365f3f71cba966b4bc3ba92bbbcc8e30b5624d48n,
  r: 0x644ec6b84db1fed9869de5baa420f7331b571b7c210d1e4313b2fb3c436393e9fdbca8n
}, {
  a: 0x8den,
  b: 0x1c1c4b0a89d4d076c455cc535f9228b2bb01c6f47b9ef35650abb7aa9c0e6ee6d15n,
  r: 0xf942e167722d107d20f0c9cb497204e0d639c22be02b71b75f52a69ad3c7fb62b4036n
}, {
  a: 0xfe49cb16f363ab4f944523dc5d05748bb035d0a12c4b9cn,
  b: -0xd67c4f5bf35da836fb9abb9bn,
  r: -0xd50d2a57aa378f6c61eb0bc2aeb615f51210dbe11312e59a481d75d529b0bc60e4bb74n
}, {
  a: -0xd0f46b3a13bb2dcd215857ca3e5d3a1561e5bb6a63a56b3729950253n,
  b: 0xbd0619656c8ce7n,
  r: -0x9a496d9f0b6ec07e4596448fa3c94762e75bd581e7678ac6610ef3a4756a66bcbe7ce5n
}, {
  a: 0x96f2f2b94214bf9a575aa024e98820b04029bd07b964bdcf0e99b174dn,
  b: -0x48738be4c099cn,
  r: -0x2ab875e3ef8a2789d1bd2d4e2863cbce8586b9bfb7660105635668e6504432df2fe7ecn
}, {
  a: -0x6067d8b2bn,
  b: 0x646fd6649303602799680408f13848b245b3238dd92508fcaa49500610eecn,
  r: -0x25d2ae69714d3bc8c0025170a140056d762ce126abf9d18f1e22e70b705b8194a3a5a4n
}, {
  a: -0xee58cfd0eb5370e946629369b8f6313e990be8a6659561d7ce2e5ed9978e69ed24n,
  b: 0x4074n,
  r: -0x3c023432657f7e097b4c89853a255bddf6a0538f04cb6026495504b9607c4703487450n
}, {
  a: -0xbe0ba3df592960f4ffccaa5b4d26a9a7e6b723a56n,
  b: 0x25fe5bdbb85420a0d2718497ed79cn,
  r: -0x1c34826d1f89d8a7bd469234f1fdde5efa55788652125942612ee6a3895831a4edc668n
}, {
  a: 0x3f8d97cffa3d740e9ecc84e94d557b5b2f83c79590a9d70b7b7n,
  b: -0xd071e5b3b013365068fn,
  r: -0x33bf51df42a3b20e220fbb15da4b87a5d89f14b2268a54714e1b9f364173678677e939n
}, {
  a: -0x4e3980d5373n,
  b: -0xc0a66a772af8525177c6aa682fa4fb8bea21eab531c7b1a9ba02d1e389an,
  r: 0x3addfa71acda4515a0fad5129d38e4bf1b4e1885749eff07791e326a03ac4760bf5b2en
}, {
  a: 0x39edcace79d371f163e9a1eadf8329b4c281c9b1425d452b8c7437ac723d50fb3778e3n,
  b: 0n,
  r: 0n
}, {
  a: -0x670c1314b4f60c49066255398e61c4ee6585898e9cd1f01e05429e29aa6275n,
  b: 0xd3492c05n,
  r: -0x550c67e3989254cb8400a8cec455bdca3b69d58fb42bf3835c4441d8feccfc9b9d0849n
}, {
  a: 0x91233d2ecb001bae3450e14a09975ca52d52caead38882e8dc7fn,
  b: 0x50d65d60adeeec5a29n,
  r: 0x2dd48b84619af123d8cac38ae2705612fb791f4e9a840fb82c01af07b6ac5f2be3f657n
}, {
  a: -0x9778d8e120285743af4983a6a82bf3n,
  b: -0x3417e2553df7e7ef2fa63d3cdb56704c7cc959b6n,
  r: 0x1ed2add4560350ff58b536e34be851f2eb774f3d20561584a48ad93e0db40128a1b9c2n
}, {
  a: 0xbad21b1001cacf7f1a2ed797a9ec3ab0af04b0eee8cn,
  b: 0xe48079e749648705013c22a9739n,
  r: 0xa6c0e21de189c8d202fd53cae439ea1c06916129081ef61a4cd20f52be4163bfffb12cn
}, {
  a: 0x75431855058b5bb8444d89c07a2f44b9651ff788a73722937c4f275bb0a912a7n,
  b: -0x5dc3a3n,
  r: -0x2af2fc9c2444fc008992859838b5cbc4cbb6afa98c726907058459bdb0145e0b871555n
}, {
  a: 0x829173af901febd1699c88f310c6d16b947b9603309e7d42281a3e4791ee26143bc3dn,
  b: 0xfn,
  r: 0x7a685c74971ded145302c063dfba6454db33dca2fd94956e05989a6318cf43b2f80793n
}, {
  a: -0xbdb19c8d380f05967e12dca91b08b6196fed110d86a7n,
  b: -0x426d8359c98baa115033f25a76n,
  r: 0x3138f0507bc85ffe0289e5ca2c5fd7079382bab7b9495d31ebe6cf3ba3eb112c70c6fan
}, {
  a: 0xe9a59a9f933ae515f343d3205ba9c601f5n,
  b: 0x55b068b2ec3f52e2e12e1037dc603ff31484n,
  r: 0x4e34fdbfdd2c93445b1eb3fe6a1891954034eaef4723ac42501a0f4cc001d628cf2654n
}, {
  a: -0x1edfa19f0855864c484436f536a20d2865fab93c832856cb8a6efan,
  b: -0x9c68110cb73c81den,
  r: 0x12dcd364f3ffcc33238eabbc002267d07f6661f68e16766c9168273a542f53fc9036ccn
}, {
  a: -0x1c1223abc40fe0n,
  b: -0x97b494ec921658d3d41393d892f73a7b95094b69288ac9e2d181fcd2n,
  r: 0x10a2801fd2c8339fe92e042e5c19817234b3daaefeddc3501f5b761e6380d9c65585c0n
}, {
  a: -0xee05f11f39a59c27056a53d06dcn,
  b: -0x7e96b4961475be5fe7c099b9a4e8bd02322e833233cn,
  r: 0x75b30c105eb6774824c6d0728726f127bb19ce6dfe7a3aead4e16dd6bb637dd011af90n
}, {
  a: -0x6ea3c605abdb364b7a99e8a13bb6n,
  b: -0xfef6cf57bf23274585603f47251db871c1c1ebd222n,
  r: 0x6e3129764358e8840585f853575746c25c5db37fe62fb8108a550ac9fbfd812e773a2cn
}, {
  a: 0x53aca4f11151d3327c4ac7dc89dbb82bd01a5506353580c26f91b8a4b46n,
  b: 0xc779fa51334n,
  r: 0x413312a27ddbb60eb755a2971c9f88ef3273203f5811f9d3947396e8d65211d9cb7c38n
}, {
  a: 0xdc4185798a59dde98n,
  b: -0xa6b8eaeaae7aeb5c1252994af9d1a74842ec9e15aee1a6d231b4en,
  r: -0x8f7195c28d151a7d189b8008a4970fdd4d455b784c19966cd78375b97491c6435bda50n
}, {
  a: 0x81be1d1265d92c495ddcb33ca641faf381b0d0c6caen,
  b: 0xac2c32b7d2032b65bd2dab2a641n,
  r: 0x574221e9a69b5a320e18cf0149a07c4327c7ec4696a8d81a4a7137145171401b9c6c2en
}, {
  a: -0x76c271af8cbee839f8102abec9bc146bead18f74b7e309ae723cc13d66f7n,
  b: 0x10df46be11n,
  r: -0x7d3bb4d5800d3233b88fb0789f673b65b40cd2c0184accfa576455a26705fb8092867n
}, {
  a: -0xacdcbf6ca2e1836f4fd0f026220bc483d59619281a1e677f50d5529n,
  b: 0x8c8e620d8b914a6n,
  r: -0x5ee8dd573e10f3076c3eb65a40423b84639cc1fb3fa4055a8171d1e4a5a28b13ed6c96n
}, {
  a: 0x2b3ef22bfb210533f04733fe6be6bc6d8caeb7859569bn,
  b: 0xc23621c4bed81ac0878430339n,
  r: 0x20ced880c33c4d51e02f56ae207bc7074a6761b43d0a95c8308d0238c629a92a791983n
}, {
  a: -0x8da03c53effb9b4328a41n,
  b: 0xfd9210448b41590b1664346938ee70f8357160d8c80551a59n,
  r: -0x8c482a014b69f2ef1fdd48c1625ecad2abcb323eddc08d5158aa6bd0e0c6512f31aa99n
}, {
  a: -0xb5f93f893b01a47b32304f00fa4n,
  b: -0xdb6f62f55d2e10084722e52586a099ee5d6d37cde2cn,
  r: 0x9bfb66c4c6139e9b8a4f5b4801d481c31732cb0afb94149f0855be9d963090c642e830n
}, {
  a: -0x748f09d25d8850a7fa0n,
  b: -0x1161643fba7374ea222ff7369e5edd7f884e4d0d7aabe490d83n,
  r: 0x7e9d77e94d993efa785629faf0bef9ce01693770315f0a4bde7a7f4fa3784c17a6ee0n
}, {
  a: -0xe18d5bc67933faeddf1cdbe8bd24093094ab4a5b2a3e3780788240n,
  b: -0xd560d89df0afd0c4n,
  r: 0xbbfff138fa75dfdd8d896223dc591cc60ef571735ac3d9da66e9343f14689d4fd7b900n
}, {
  a: -0x8c2cd979535d035cdc96b7302a0a4n,
  b: -0x19c81d9840fbe5c1e37b5bd7eaf37364a27fdb326n,
  r: 0xe1df47b32c6389f92675b83ac223b4282a56d513505fcc743a200b9f91ed7a6ca8458n
}, {
  a: -0x742a6de4c8aa2c9007e5bn,
  b: -0x401eae293e5bfb122d9cbfb0655ad267756c8a4c9cea9d8a3n,
  r: 0x1d188779a0c32cbd5abf8d9f92055d6d5d36e0c36e442d19fe279d0e5837b20a003bf1n
}, {
  a: 0x90d75770c8cd62c5932b7752c81a7a45854f2a4552c1ba1589n,
  b: -0x156fcb499ebb3f859e79n,
  r: -0xc20ea8f93ed21c13c01346cdbba8b16cfb88d92fe799779c5c27306b891bb516bbbc1n
}, {
  a: 0x253a24ba06a3f571199ea702f30dbc7e29476a8e63d59ec8cf7b82348ecd6d1fed12n,
  b: -0x6fn,
  r: -0x102435eca8e1176c0a1bca6a4762f4bab3e5f733bd499fd911f68d74c9eb1250d7cacen
}, {
  a: 0xec917ad29e24060e24d8f9ef8180f4070e273b5b3ba8d272328392571b815cda578n,
  b: 0x7d1n,
  r: 0x7391d2108461793548e03f9991340f36b25a0a6f41d5294ee9cd66adaddfe26c6a5ef8n
}, {
  a: 0x3ca4af1716bed60e50090f99948d3a70a0b62f7dfn,
  b: 0x50d63e2a4f81fdcc25d1b38f25756n,
  r: 0x1326371b7caa94dad4027e91b5079f3ab196a83a23840ba3bb14132155188a8e4a0dean
}, {
  a: -0xfb3f9d2489a803048b5d1e8e035bd52cbf49ff47781a140c4a2e2afbcddc81n,
  b: 0xceea2d5an,
  r: -0xcb13051b8d27b10b57e52dcc919eabff2f96346a1bdc1335059e2a261b9afb120c325an
}, {
  a: 0x7861f9ea6435e43fb20e2129192d114259759n,
  b: -0xe1adecaef84055e24ab845d22e126ff59n,
  r: -0x6a1fe6297f3232b582df4a6954aef7377676aa5678273a8d783cd1d575c42d230944f1n
}, {
  a: -0x43599f7729a3a35ea03d07f6458ffcb349cca178b9cc9n,
  b: 0x806549ba3ffcd2ba6f9639efen,
  r: -0x21c7757d0d41a89a8cc3ab6cdd07b3ee343affe1003adeaf92ff02c5d89edeaa049d6en
}, {
  a: -0xfb45b9b7ed6681bb1f161e9185c90905ff437dfean,
  b: 0xa51b8528596ed832501a02830d47dn,
  r: -0xa20ef3c0f692b83b98b1726289a3fa060f8f7c677f35c9f51fd66defea56cf10961d42n
}, {
  a: 0xff3a245561aa72c8389e8abc7n,
  b: 0xd78ce447fccbea44b7cb391bb6c65db05b86849108236n,
  r: 0xd6e64be7213c36b555495e4a4f4f4167ac45512cde47f4d280c667a849f825b9bf49fan
}, {
  a: 0xf1ec492b32deb07n,
  b: 0xf66b54afeca86f3d5f2518114c355aceab3591e9f167ea65fef90aen,
  r: 0xe8de7c19e01d717b811ef0c0d1c11270aa37613feaf756ac3f2145dffd4b1fa1f2aec2n
}, {
  a: 0x52cfca6faaac83677f753378661f8cb6c3af12n,
  b: -0xb9ffecc54fdb907be5f37dc2558cc04fn,
  r: -0x3c2af2dcb9ec8c09a86225e02ab276cb5513898926a86fd91ae8620daca747e188868en
}, {
  a: 0x7884c0f8802289bb0ab46304b31802305f55df82245a8999fn,
  b: -0x5a207dc9210ec23f9d288n,
  r: -0x2a6df7a6fe2111ff9482f8b0cae8cb9c78e91593a52ff1ec9e533c7a094beb783d0a78n
}, {
  a: -0x23db8c2619f1479b73585349fbd01en,
  b: 0xb54bcca037519e8a2c67633c7bf7d28df4fb1d80n,
  r: -0x1964d8126426bf95c1a7326f7352a1eb618c04ec9e6edee523d33d4e3761ce29e57500n
}, {
  a: 0x179d80f96da9360a09d768c10abc4ca4d79dc64c4f1466n,
  b: -0xfa337ceb1d9beaf5364e2e06n,
  r: -0x17148fda4191873721323727fff1e42a7a3146d36bc33fdb476fbeba01045fba98ce64n
}, {
  a: -0xb48b9178bf7c957b30833bff7b46b969553626c5e12366b00e3bd82fa19ca0885n,
  b: 0xa47a1n,
  r: -0x73ff7efd674e9d19f120e402767a0630425fe1f8a0f456b9ef701fe747be55959e3ea5n
}, {
  a: -0x61a4daa53870f6764f022de1146c1ef0345c9942d28004332fn,
  b: -0x37222867b2011a14ac2an,
  r: 0x15077247d87498dddf4a047d909bd20ed2e3f4d3b6e2f6374512541f00b34198bff9b6n
}, {
  a: -0x8ea0da977e42e5ed061cd44en,
  b: 0x3efc71b92239094f4983856db347c6f2dc7b0cea781792n,
  r: -0x23179aa4038077c8216ab462c11b41898ff609fa730d0ad4989d1cc5e411f4e414167cn
}, {
  a: -0xccc8f28948702d7e107d505d6d62c6fcdn,
  b: 0x26df7819740aa7c419b00d2374d6e784a2e99n,
  r: -0x1f18971e347a5dc8a257dcd57b32efa841e6254732a5e49a164a33ed9f883865e7a785n
}, {
  a: -0x8939912289f2b456e57417646cfc501e13cbn,
  b: 0x2637618e0e0091c6f073e6b0a7af7b1e17n,
  r: -0x147c3b344453b56b41d9abd91a1ee05b5a265c794ce5302311b9d3a166e377008e913dn
}, {
  a: 0x6c9023cc3c7b8c1bb0af7e1ee804352eb4cd35d2n,
  b: -0xf00b0eb95d744b63d02f65ea48f79dn,
  r: -0x65cbd1ff803b24d96acf0fcd8a942fa8b76f017ad60268402c024cf2c2e4d9f7d79fcan
}, {
  a: 0x754f02ebf39006d5ddbfe1aa84a878ec760feaen,
  b: -0xe32c4d56b2cf99812c00118766c30f8n,
  r: -0x68195c9c37e29799cab111d615dd19f46ff22b6fcc98a9a969976f52577852fb1f5890n
}, {
  a: 0x9706ceb6e2b05a27b1ea8be59824251aab8429954537b9d162b49621556218n,
  b: 0x1b70f93en,
  r: 0x10305dd1eca1b9720f880508a45e92500c99e77e060f6b74583fe48ec0597b919719d0n
}, {
  a: -0x38d5n,
  b: -0x16941aacaaef46546835d98438e73dac4f63467c2ba5257b8efde7667604bebf21n,
  r: 0x5032f0ff70e9077fb067c62e775ede401bbc504cedc709b371583dff2113bac843e75n
}, {
  a: -0x83c67aba6787n,
  b: -0x69ea0e7a875ea26b69b5cc109c95acd047ac8c8669b45d73e0c089006cn,
  r: 0x3684e3368fd41018f96972b4a47cc5dca2a2584fb50f6de384a0ca09224e426de2acf4n
}, {
  a: -0xfbece92167b9ean,
  b: -0xebca61a361fce5970aeff475aab5ac7a72637950ec2b7059a55c376en,
  r: 0xe809a3072b2f3e8dd645530462b09de3c09aad446e9035d69a050be329c0ce459b288cn
}, {
  a: 0x80c73bf2efb9c4c76n,
  b: -0xe91ba33f2ec74abbd515036e41125754b5d93e9e45726ce1cdd02n,
  r: -0x75433cb2128ad95ad36294a8123ea5b58e882ac4f30fb84a06ea59b2d5cbb7362276ecn
}, {
  a: -0xb71e0fda479adc5e8a6b031n,
  b: 0xbdaf37978e44c70046c8847e2e82e0d32ff7d3d2454ca92n,
  r: -0x87ae8704dafb65d0cd292b8aba4284b09edc16940b2400edc8a07e90b9f497ea2b25f2n
}, {
  a: 0xecd97591bf0855e58b86b888256c8e4a55cd627c57914dcde3a1bebdb7n,
  b: -0x458d96d15840n,
  r: -0x40599bff23d5cf71844668b48f887d557ff802ae468cb5065727f80907592f1d4d55c0n
}, {
  a: -0x5968af97b3086e0755edb838dda011d982e43764093fn,
  b: 0xe7e1ead214de17651d1abc16ean,
  r: -0x50fc5d77468b6873bc4101c84900cd82c6861f8108da4c0131878283edfee76a7fdd96n
}, {
  a: 0x748bf01fd4714e3496d95f34293d63e03e210d01f3aee43a3653df49f563425bn,
  b: -0x3a5812n,
  r: -0x1a8fccb397f4ef9ac3c0cce5d3f7c0a1742e9cad3ccb86f5f05dc53d68b80a6867f266n
}, {
  a: 0xb051a70a7845a603088en,
  b: -0x7bf4a48d6a5dfdbe0afe0a3ebf901e25b053b202fe5a6488ffn,
  r: -0x555fba6af3025a8e2792c5c3e4f0366faa882086000cd76c84a25b24b450a73d08f572n
}, {
  a: 0x5e490691ac17b09a794c9537892293a52a8120dc5938bdn,
  b: -0xbe8f9f5510cefb1690e5451dn,
  r: -0x462f1859789d2a3573ed0bfa5f229b14ded432ac20989c9bbecbdd0b57f71513775e69n
}, {
  a: 0x649ea2cd2587f1863n,
  b: 0x1601beb2e46829bc59c689efda5c0a71ec52eacc7eb38623f55b3n,
  r: 0x8a6519050ee82a0c00da26fbe8bb0b3ab9861b166df55dc6595f27d68d3bafa53ec39n
}, {
  a: -0xa243n,
  b: 0xac183f029a4cf12615483753dd001807a66874f8bffad44e8a1fdde7c6da62b435n,
  r: -0x6d146238235312bd366f44e98ccce63b214ea75c0696f8ff43f650c3bf7f3d9ddeb3dfn
}, {
  a: 0x3b7e5c966b9e2cd7854b0c128d21ee5b72n,
  b: -0xce490ff544dbae7ca1dc68b9f58946953377n,
  r: -0x2ff0a93ed8da02b17cbdcc934c332c17470bb627ba61bda5705961592fb41ba75e37fen
}, {
  a: -0x5974013e9aedd94422142b33a00c80eccen,
  b: 0x2b915cee3f32ce1e66bee51d68f49bb135a9n,
  r: -0xf39476328dca914a35f67d9bcebdf7af20b9978ff5b67b1f3efc03fdb501b6690f9fen
}, {
  a: -0x42994d4d7c74d1796ff9ef138fcf99d406a97064de32a0n,
  b: 0x642d0445bd969ada564b6b91n,
  r: -0x1a0f98416515ea5f26a1669ee0ae8f53956f31711ef5b490406db49fd3812c95e38ca0n
}, {
  a: 0x9b1243a85f2a22f151ce2f4e3ef5c1n,
  b: 0x7ebc8cea03f8c203d7cd3353237c6fb5cc5fdadbn,
  r: 0x4cc534124c967219268a2de018251ef05e2b871919844dc85578185c0650c18bc1961bn
}, {
  a: -0xd8bfb652208f9a65d0693e3ee57n,
  b: -0xd3d6e9e9ee4af25eb3821493fc25c5a078abdd55103n,
  r: 0xb35bf994a6acf4cfc8dad6e19f48c8795812631dce192b6d9c097fd5035b6063785205n
}, {
  a: 0xcan,
  b: -0x7f7eba97c8f073f4e3f45a9fd3261deabeb7d90b130ebded61d74f77fb4b29e82c09n,
  r: -0x6499ff3bc48dbb7f3bdecf821c9c139b3a7d1142bd09a1dd4f33e4b4ac494f1132bf1an
}, {
  a: 0x4998e5614e399977f3fd7e4bb07af61a81c6314fe4n,
  b: -0x9ee1706ce0ec4f1d44fdeb76629an,
  r: -0x2dad2d45da525d05518c425e8dedff5222172d0d7001d7fbd82b54e7bac35539575728n
}, {
  a: -0x486adc057n,
  b: 0xd11ea187a9a0bcc384a45f77b29b0979ec254d3e7ec764831c498cd46950bn,
  r: -0x3b27e7d7cdc895bcf2d52f4d951433744e360fa291f51bcba9fb44e82c68c52d33e6bdn
}, {
  a: -0x3be8286d2d049c210cb6516f45baa474cf7ea7ad58b09384b85ba8118f36e565cb51n,
  b: -0x17n,
  r: 0x561dba1cf0b6a06f8246150ff43c4c67ea4611092f7dd40ec903c1993ddee9c254447n
}, {
  a: 0x95a3993e8n,
  b: -0x1daec69a2b56f038d431e33c4f5990dc27dc4cb3e2a6bb1207222dfa85249n,
  r: -0x1159b1a4e340d2b691fbc1b76892acfd46520b7bee94976b1623e1b0415401540b7d28n
}, {
  a: 0xb41941f204fc1270138669b0190e5daf4cc10c5732aeb390236a1n,
  b: 0x52c3b575dcb5d966dn,
  r: 0x3a39c60587636e85cb8eb0918473f831f4f6b65407019e65f0e2936451202b1570988dn
}, {
  a: 0xc374fa94b9900c78813818dfa1a94f236ae497c81a55524ef7d5c3f4e59n,
  b: -0x92df8efdc5fn,
  r: -0x702366fbbe1c32003f2b897673a652083a182f9c38e4b7bc5df84aceccf470ffe98f07n
}, {
  a: 0xb99ac78620002bccc22b96caef973e99bfa4562d84690fb17401d126c88b20a61f057dn,
  b: 0n,
  r: 0n
}, {
  a: 0xba8e15e69bdab52e29aadc5b780c8dc72ca9d5729df1ac38f0ea4n,
  b: 0x33df23e6f1d746da8n,
  r: 0x25ccea4bbdd12daf846ff6186aefaa02367b146d15e108af888a39835bb16b756d6fa0n
}, {
  a: 0x48080d96df61894ea8ae4aeee7d27183b3e3e76e2n,
  b: -0xd096b4fbf364e0779d717347d16f4n,
  r: -0x3ab0f2af19d591e82f396a15c91918317085a1c1c3d349a0293b4eef30c0c4a61abb68n
}, {
  a: -0x48c74cbcd5f04a4d336e50a8f2c21ab9b4d1n,
  b: 0x552525e8879bc8ebc028a60391d6392ffcn,
  r: -0x1834bc0fb395edb5c06bce2afca8aa08db37edc7a03e28b68ca89ff243a7db5f895cbcn
}, {
  a: 0xb89c9afbf8a20c3a3e7ef7c1ce987fben,
  b: -0xc23adaa4eb10f5c54064ed5737b51f6e2cbbadn,
  r: -0x8c111e9a5952fa6b4b0a725437a9934c1ec0deed4e991aee47d3e7b177d6fd9b061d66n
}, {
  a: 0xddd0ebc029f42be90c868cfd973n,
  b: 0xab07e18fe9fef41ca20c2e25d5d45de0cf5137b06efn,
  r: 0x943161a11feee398a788233e789393263a481207c5bd9c524b08e5d536259ebc65b45dn
}, {
  a: -0x6b58f0151e777e7en,
  b: -0x79f8abfe20c9ffedf144dc36c371624246fbbaabf7702947e217a2n,
  r: 0x33254fc188382102a6286d8758e147713b8249e84e7bf25671d20e17fe3edaa1375dbcn
}, {
  a: -0xe7f1c525325426b88c84b1379ffac61aden,
  b: 0xf88d9d85ed9b8a3e050b0a8f779982c71c56n,
  r: -0xe13285de3c093a332fc023905a03dfa35da2c4578a9167258a6d281537f97d880f4e94n
}, {
  a: -0x685407n,
  b: -0xf73d5027a7093e78b98057d79bcc9fee70b2e58adb24994ab8b7a500a1377597n,
  r: 0x64c20f71160fa5facbae4edeec71255ff0652d089edd9246a7c042576b36726071c321n
}, {
  a: 0x3efb587f9fa20n,
  b: 0x6dc16846e8dc8deda794d7e42fa3b1e38ff38464ae434b713e8280c4an,
  r: 0x1b0099d39d276a00144dcd72a8cb636fc653684638a5c96e4a6f523fd206f51afbcd40n
}, {
  a: 0x2b72b37a566de4bn,
  b: -0x7cab04ee3ed0b859c423103c32fb50a409622526791e85f63012cf7n,
  r: -0x152895635eaeef3634cc4acd0e39b993b119b3916bd22b84ac8d2d7a72265123c05e5dn
}, {
  a: 0x5af1c7077ca13n,
  b: -0x586a2661ceee51600ef66478d19407648db8bc4d936080264925ea6b1n,
  r: -0x1f68d2299e9bc16bb56784a1642cc59a049de400218a958bc87e6e6907363e78d50923n
}, {
  a: 0xae825ce664017a092n,
  b: -0xd2446b7e948b6fcf9db13f4d2586dd97ba81b5439dc1e792cd13cn,
  r: -0x8f55941c717c36676d815221fcd779be2fb076028db8698940838b8d80525aeab8d438n
}, {
  a: -0xc9800d43d0aen,
  b: -0xf317ac262b92dcca9f0fba5b1137b8c3839a47d80026b29c5ad173b6b2n,
  r: 0xbf572e98a4648cf35e31e580ce96a5bde1f032653af6085c679e178924dc783bacccfcn
}, {
  a: -0x2f10618a30ea95988a9fc453184066ce45d5632b2fdc141c252dfa479535c9fn,
  b: 0x55b368fn,
  r: -0xfc16c21dcd9ad1f68623138bab126eb458edbe1d66d0d7dae848cbd4d5fe8629f46d1n
}, {
  a: -0xe49e3776fa41aff5n,
  b: 0x41872199466bd9ad27e986f44f6187d87cd1b7f703cd60bfb51d24n,
  r: -0x3a84d985bbe1b65f7ee04a7ff0146deee1388262ad189f0314f8f6f3c666add5647f74n
}, {
  a: -0x3e91fe8735449fb8ccc928124579cd22386176faff0e9aa30e26f8ebc29b8960abcn,
  b: 0x17dn,
  r: -0x5d1f47cf3a4721b608c760a33166464bede90e138d98bc24ac100076e0a17b74df9ccn
}, {
  a: -0x2cac9e4dd41dbn,
  b: 0x91e04b1a4e277e403571fd4827ec86327e5ac561e00dd9b8d49a1f2b7n,
  r: -0x1974e9cfc2cac8463c75bf2ca147c9baa4fa06751802e40ece99089fb9b638a026198dn
}, {
  a: -0xf831cfbd5a2e53550f8aeaf602c2c4f3e90110f5db3bcdbae6ff892dfb0f5b1f3cf11n,
  b: 0x6n,
  r: -0x5d12ade701d15f3fe5d4181c410909db7760665c32366d26169fd3713e25c22bb6da66n
}, {
  a: -0xdc7fac1f8ed6b104ee2ab915f0adan,
  b: -0x87172209824278f23a4a7cbb0a1f08b1016450d89n,
  r: 0x745b408e40b46136ec593d9ce5f404171094e4312d2894eff6605289ab695f482be0aan
}, {
  a: -0x697092110d8c7df4c184393d5ff0a5bbc9586f048n,
  b: 0xa68fc4d5ce3d35ff914381660d996n,
  r: -0x449a35aae5c00d50ffb2e5e53596b2cfbeb965fe0525b80a94c00981b8763f49bdd230n
}, {
  a: 0x1917f3n,
  b: 0x8255459f0dd7cd196b3d26e6d68ae05e955dc24914c28d8b7085e2ec8d2d2085n,
  r: 0xcc6852cbaba4b8ec070bc16159df409380f5b2d97033c0201df8aff9370a13cbed13fn
}, {
  a: -0xfa83f884c75602ee23d69d10eb03522ec66085aa852063451fee23413366n,
  b: -0x5de3fd2a2dn,
  r: 0x5be10c0b4c7231cd283ab15d421ccf71ad9e4351a15f3ad1f5b71e50af02b622b2c4een
}, {
  a: 0xf9n,
  b: 0x2af976d41bb8e39ea17dbf44800df74c14deb3a0b654de4dce128f9e08b6903ceaa4n,
  r: 0x29cca4944ef6d5654b134f09a08d9589004c9cb751588c39ad700db0b679924b403984n
}, {
  a: -0xd0c1179d9fden,
  b: -0x22e77497bfd96b2ea702e7e79812fdee7f5306210b8ae4bb1493365b69n,
  r: 0x1c7662727b80736e42969a579cf6bee32301477659a942a9d7507b3da467fbea4e7c0en
}, {
  a: 0xb3cb677b165f7ee76608e4d3c34d06ccec30aba8n,
  b: -0xafa6f43886ad947acf5a603e53d9dfn,
  r: -0x7b5d4d27cfd21ed396ec1464a5d95116a3d5b9542d0d31694858cccbf26d11575eef58n
}, {
  a: -0x54e76be338179ce040b919daa73228df714d968de39b811240661n,
  b: 0x535854f616b513d96n,
  r: -0x1ba453b54e9b1c345bb86124678878486235c6cca27eb444423ec79a6182c13051d9d6n
}, {
  a: 0x6d560ac0565fa78cn,
  b: -0x9010442afbe24b48994c50e3ef619d2c9b4e3241e76328194a5b9an,
  r: -0x3d87588a1328116016411a9ae0329b3759f7a50660e92c7562d3b277ae774b10918e38n
}, {
  a: 0x18bf2e7d4694684021dc9a2be046df83bn,
  b: -0xaef9addb019fbe0fdaab8128a423715be8fd4n,
  r: -0x10ea145bbbf2235e72bae6301b0045623f9aed41a59864595bd17fefb4c37d2b8485dcn
}, {
  a: 0xbn,
  b: 0xd8f0e0143c26535b3aa9ed8bc4a4e2e841e5c432bc3041d1ee6ddb88a7ace9a51b511n,
  r: 0x95259a0de95a594eb854d35017315bffad4df6e2e1612d4053eb86edf346e0a182c7bbn
}, {
  a: -0xce2f6c45ebcdn,
  b: -0xae1197fe8e21cafc2b1326249fdbe037d503f2c865ad51775c2111164an,
  r: 0x8c326728b54e2fbb23043fbe311615741a971fe6b659514fe6f15b6ea8e9b96416c742n
}, {
  a: -0x852985164d5def49de8a75176eb96d7612b5b8ef6f47c4f3a81en,
  b: -0x151593b6aa6b8d1765n,
  r: 0xaf7a1289ac2fdbd1ac47c8dcd1732abc1f4873df19080071e6f8ac5dca366bac205d6n
}, {
  a: 0xda15ecn,
  b: -0x79fe83b54e84525eed8fb62b2cf462bca1a2e1ddc016ebd14b356d0017c72d84n,
  r: -0x67ed2e7fd4274361940560eb31c299920623dbb584fcb3c6b39b9b8945bda604c1c9b0n
}, {
  a: -0xd5e07ce8388c93309c0a4da6c9d6495b577243e591836n,
  b: -0xc4ef4c892100266ec02e06d9dn,
  r: 0xa487cc279de24534699fd94d084eaac3f0f922213af5d0e8f11767266b95b3c732d71en
}, {
  a: -0x3a0d6fff7e5fn,
  b: -0x4f6f1ed668c80668f3c761b00ade91257b8a8e4179d137c25546081c2an,
  r: 0x1203586199e57e072db8c6e2284b3653173413338155b7baef052e06704e893eb51f96n
}, {
  a: 0x4a9df2953af3108e45d32187f349241638170380n,
  b: 0x9204ab3eb7159e28d7a350dae050b8n,
  r: 0x2a8f70baae9b2f38ff9a64dc3a671b3041dcaac65723f0a89b880055f9269d91a28400n
}, {
  a: -0xf76bc58afdf7f5n,
  b: -0x598a05bc523d81365944b9dced2bb526c415918ef06c567bc7096f0dn,
  r: 0x5689dd50ecb4dbb5d8e675cb189191150ac8b66cf9e9161ce48d0011f6dfb05805d271n
}, {
  a: 0x2a204d8fad68388acfd0e327144c8a7a944d2769f8a44be3a012db085ecdff92b602n,
  b: -0x72n,
  r: -0x12c26289fb38692dd08b0527670a15aa960a5b8d30b929cb5d486589ba37bbcf550ce4n
}, {
  a: 0x199d20a6d3b3e5c66b1b2ee505557a064c7118f1f282dfn,
  b: -0x2d7fa44de3f57c051337356cn,
  r: -0x48d6420f9f63b2c95c1e444000cd86bdea4549f1c0460e7ba747dcf866dc8f2506114n
}, {
  a: -0x94817b94fa73f4a63e633c26c09f3b1afb06174adc0ad251n,
  b: -0x212b1e4366f5a0fb4a3fe3n,
  r: 0x133db43c3c67e5e5fd9d7190c18e7057c21903f4aab77ed5358a8518d5427dfdc46cd3n
}, {
  a: -0x3872870fa1f75eab0f01d1n,
  b: 0xdf1580310979921e631da099e8531f238e12252ceea60e5fn,
  r: -0x3130814fc5e944d4dd2c47859ab36e6986c9f68e38d23e327cb59bb3965dd3c8311a8fn
}, {
  a: 0x2405970a850d280ee0f4eaa53ad9cae1f96732ab9ac5n,
  b: -0xe88ff36b227ec8e79b3734acd7n,
  r: -0x20b952414903f16ca76f60819e9a0b59ba6f72fcfbfe8a9e0a955172a96d199d1f5773n
}, {
  a: -0x798049bc3n,
  b: -0x7783a812470d93586e4c94e3b6fa8e336f2a429538e1bbb30cbde7f9e9922n,
  r: 0x38b91eb112be44a0f2a850af7eb88ccfee1ea1bc275c81df99825aea315b14d10e3ae6n
}, {
  a: 0x15e0ccd01adcd548a71f1af857cd9df7c75a25d036a48986c30e50692e6d64bc3330n,
  b: -0xa1n,
  r: -0xdc260cee0e4e222b11a8ff62f385058d45fb1c7f25d7a7dc0ac00922632cc5a5c3130n
}, {
  a: -0xef36a05581n,
  b: -0xb64a835ec4bf1090f4dc820e7c0f40ae7fb2d596e6124c1bf147e2710fc0n,
  r: 0xaa567688a4604666521ce4731ec3c27c94081e7908d7f57101baf5ff7087a4fd33afc0n
}, {
  a: 0x2f93899bb52c109eab1c51faf915c637cf488a31f776740fa0c1fen,
  b: -0x182e98548f4601a2n,
  r: -0x47e7db8a3b4b6a6c28ee8023755755a824d5ad8afa26fa600feea0e18f32b71f0c0bcn
}, {
  a: 0x5706e5c341an,
  b: -0xed7ef0a5c9bf83f1bddb6427ad202a0cbb5bef8e2ee1ad32f44f4563943n,
  r: -0x50bc89e9ad4a1685bcf07a598bc422aea0d76ca4671ce5acc8d2c6d1a90689b2776ccen
}, {
  a: 0x1dc32142b2fc1169897cdc59d98d292dd749a4e8d7c45fbe4605db40dd92c977c933f8n,
  b: 0n,
  r: 0n
}, {
  a: 0x7f45670a4473e37n,
  b: -0xe6303fdaf300348903904f09cbb4305bca8a7fb7e1fb028a18f98f3n,
  r: -0x7270575579b134950a7a0733da4dbbd2a771c1784936baeaa6e951010e08fa9449b635n
}, {
  a: -0x2815cf6fa644b3ce571467458cbn,
  b: -0xf8c081dd2fef70ab644d5fcfd372665d8a162873f6fn,
  r: 0x26f345a55cac16f870d1286bcb8a8976c5d1ed96ae9dfffd03e0549bc12d77b7597505n
}, {
  a: -0xa4581602230b429172a31cn,
  b: 0xcc936aa69938e11cb3b5a4ef1d7ad655a3eb56ac0643797fn,
  r: -0x8354d495c3bf6958737e139628b43c190f76b98e26c62985c67b55ec0ecc68af4b26e4n
}, {
  a: -0xc87fn,
  b: 0x2e6f78b1bc85401726cfaabeeeedee55b57b98436859f78521f52c952a35b7acf3n,
  r: -0x245e1f97bb74a02ce1ce7e6adf626a3c324d974532f70e01cd936375a6f9e8253ca48dn
}, {
  a: -0xbab327427bdc6fc4b8328c1cbb2eb4b2e807ac0db8657bc6055a3892bn,
  b: 0xa36c4f16b353an,
  r: -0x772f0f41bc34c15243680c516450a078c0c1d03e8021d683a2c7c4729575f6126bfaben
}, {
  a: 0xe5aef05a53ab07n,
  b: 0x3b4e52219b376eb105a6afb70cc263c5cbe781d27cdd9ff0a86b9e09n,
  r: 0x353596623c9a7a9705a7642b47449a27c0edbeb956d1c312f2b89a527cd6f7e46c553fn
}, {
  a: -0x366dc89d92bb42a699d0c049ac493ca3c58e7ccn,
  b: 0xc9ab0147de74af3e71194a1a4d12139n,
  r: -0x2ae08e1e6efd4eaaa0aacc5e749abad17a2714173542818dd9a4ebd60dea2ed338e86cn
}, {
  a: 0xc86fb00a45b1affebc2a90ba80c3fa791bc10af2845ad9n,
  b: -0x5c846206ac69eb401f905926n,
  r: -0x486fc99a7157d210c8c7e99312b9a5db760a792144b4597c268f0ab93ed0a3644aed36n
}, {
  a: 0xfb2ed154b3e8c2f5c3db426873e73728904b34016f8ae0a4cacf15ddc8cbc351581en,
  b: 0x7dn,
  r: 0x7aa5dc365bd8a73200a20f6d0097e5eece74b864b376cfb077071dad4b0b7e5eb806a6n
}, {
  a: 0x27796429eb7b3bcc9e374536cba69a55ab45fn,
  b: 0xa43d7db4e0831272e7744fe6c17ca15d1n,
  r: 0x19533f79e2b961bc443f6af440b194f30b665dd1023376567a43fe6fbcd4ab4bcf0c8fn
}, {
  a: 0x7fc34ad227427092932119883b2en,
  b: -0x4d9dd5a883268ade9f313f3b0c4b568dc0eb1d6097n,
  r: -0x26bc82e7af8f2fc431d4e2ddadd323e625ffdec71750219f74d136f509dd5b13c22822n
}, {
  a: 0x374fbec7da019c88ade9aa6158127n,
  b: -0x2e75feff105024505943a8ab063d6977b3f5da6f1n,
  r: -0xa09d2d255c28ced89bf4c24f1204b669f5cb1a9ca4a8c56919b8b4b3e869dd028dfb7n
}, {
  a: 0x1384aae2447bfc5d60b835903n,
  b: 0x3cbe5341c8b166ffde1bc1f434274b63431baf0ce4603n,
  r: 0x4a19adce35fcee810640edcc3167cd1600bb152b2c6c5281104dfdc747efa7d4add09n
}, {
  a: -0xd99aa4ec4b212b43539f4a1b6687594db51fc16n,
  b: -0xfd9bc4b691430b13083180824c1381dn,
  r: 0xd7923cd4f70102a65d091c82d770857a977850a7f487182de5f226c112b2c8ec045e7en
}, {
  a: -0x518bb41cc8527e3f261b9ff87ca8b45ece90251966dcfe4b85e2c1409a82f95c06aen,
  b: -0xf3n,
  r: 0x4d679bf752264dd5f12c38d8de542335fe12d3371ca3c561b0163d7052aa52b25a572an
}, {
  a: -0xb81b36325b2c314763bdf2615e8ef1edd5e87208b6c9n,
  b: -0xff071f7d429173160a8cb4db46n,
  r: 0xb7683a6004eab113152634a5c1dcadffddb9b32ed692b627d913674c2ab30d1413edf6n
}, {
  a: -0x786dfn,
  b: -0x3e5bfffd059f3f5b67970b865aa77fd74bfb0e2292ceb36a761229138435e0b21n,
  r: 0x1d55e7a0d95b3fc61ddf99d47d81123b6222dfc096c9cfbe13e097ada9cad836a5f7bfn
}, {
  a: 0xc1a79584b60e3b68699ce63a58093687c22beecca4a9921bf0a6960n,
  b: -0x5f2b6791ce4b1e1n,
  r: -0x47fe05fb15fb9f01e8114f06bd653a617ebcdb8e826dbc225203d6a1fa42eb7481fd60n
}, {
  a: 0xcb27177b31f9a4e69a1b2e11f930d58e4b0n,
  b: 0x53b5ece4bdccd3c4c862495db48287249a6n,
  r: 0x426e0b3e1a63294d0cbb6852211bb3bf48d5e1e4f28609966356d7e0a01efa573a7a20n
}, {
  a: -0x4c72b824fa48198f18662278814b8b0f3e2dab26cc5e8e0e4d3a7b6d08760n,
  b: 0x124240ba1n,
  r: -0x573d9da514bcd54d506526b908233494808cf1e663a3e582e1ab8551ce11178764360n
}, {
  a: -0x5f0d17a5121e84425b98056275539278a8c0549ad29cb53527678f6n,
  b: -0xbec7de92f3faa40n,
  r: 0x46d5ed5dcf52dadc063569650674f0d0e6b01242cf91317b1d638a5cc96ada387b9980n
}, {
  a: 0xaea1b95b0a497d4f9bf88debaaa608ef7df89303bcef7ca90d8572315ae97e7n,
  b: -0x1642bf6n,
  r: -0xf2f6e2bc24b6687d5faf57fc6845044c17fdf83ec1a35d2328fd4b350c7266685c4fan
}, {
  a: -0x64c4bee7c84d94dcc1af9c5fe61e6644f30859aa7302e2477n,
  b: 0x360ef61d7baeaa92fc886n,
  r: -0x154763e7ff58f4f893ed3267d50c141b574151e1ceaf4b4cd5ee79d1deaa78857d0e4an
}, {
  a: 0xbce676c81e116ffe63cfdcaden,
  b: -0xd74343b7cf1c5e6e6e05307d61814490f0123abb78bccn,
  r: -0x9ed7300b1a491579ee351885d7b3b7995c6d0e72dcb13aadfabede1918a8deb61632e8n
}, {
  a: -0xb76254dcf3fccf8fc39b146ba3eef79ada5n,
  b: -0x54f1729b9e0813f7de0faade101b830812an,
  r: 0x3cd93983a798e549c1c226e5605a800a0c8f22c69e3941dc67bbd23cf95343c166a212n
}, {
  a: -0x7e2f15ec235878en,
  b: -0x38dc2f4fd57ebb927425cd4ad8671651b98a6692d9d5d033232ec88n,
  r: 0x1c06d4947d737db3dfbe65a96afabb506ccfa8df074d600e4f5650de7924f8bb22eb70n
}, {
  a: -0x3eddafe14758758cn,
  b: -0xd0c95c62fa8c85accb38181929f534204228596e2a385d17882cb8n,
  r: 0x334591a61b722da8ef207d10f85c7a7157fddbc07d4830709dfcb1ac794f9882288ca0n
}, {
  a: 0x75695d2ec44781353f504a26eb5c7e4f721d6fec61ccn,
  b: 0x7ed01ce484e959893b785a21f6n,
  r: 0x3a294eb90f9820d25111fb409ab3ec6a093dc83774f5b2263df5a4809a50ad07794608n
}, {
  a: -0x6d2463457621d1a7n,
  b: -0x550a4d82a24085ee4bfc5b4d666e31f487fe16a64fa0631a3118c7n,
  r: 0x2441796d9472aec112ad41b57dffe55767aa1638d968c81b4e870a1d882d6b16e8a0d1n
}, {
  a: 0xbe4e16184391ba56d8a8ae1c9eb3d9fc31aed86094f5n,
  b: 0x5b7af4d0c773b157010a6a2087n,
  r: 0x4401290ec85ac8e2ec6c5aa65d53533ad0ea984c5a3116fd7ebdd0987244046cff2d33n
}, {
  a: 0xe36415282ab02ec48efn,
  b: -0x55187ca554612e222611e9ddb7b047e8e3a7e4bd4edd891b375n,
  r: -0x4b95fb1fa6a4c074033b380c51b05fb379b7debdbff9777a90e2773a91c1d5845b723bn
}, {
  a: 0xf541aa83ecbaf4155a0114b4af47ced560ceed17cn,
  b: -0xd79a76c4eabe7c5a1ccc147b951c8n,
  r: -0xce8e217e4af14b4f76a4e661e616ad7a11eeb5a93796c768e5227d236df87c7177e4e0n
}, {
  a: 0xd6edadfa17e6ceb8ffcdf17eeb31599n,
  b: -0x55bb74dabea16597403bd7681500fd6eb8cf5f4n,
  r: -0x47fa4c7d78e679ee281362b7c96c3fd3e71427db9461f4803dc4c418837dea290802d4n
}, {
  a: 0xdf554ad5ff199n,
  b: 0xa0006272f54f195cbfba8f5d2d3421f30d5af5cef9114b922296e96e8n,
  r: 0x8b95a4a8b012db0485e87e6493485d586d4aedbf0e8dbd04f4760919d67690a74098a8n
}, {
  a: -0xb60f0f180c4c9ae79cdc52bea99fc2d4afn,
  b: -0x8e6efd5e39cb998261a91cef428e8342c393n,
  r: 0x654b4907b7b43b4c4dad35abf655f183e6f5bd90212d1df18449c10b82aa3a86ff6d7dn
}, {
  a: 0x8ad7a407c6a8bfeb6d6n,
  b: 0x37d92a9d503876bb8abccb024b523190ad492cc29a8366ed55fn,
  r: 0x1e4a1c2468f088763430e4ba2bb0b15eebd97f5d1bbc7dcf86ffdb5dbaf6789599e76an
}, {
  a: -0x3827278b4c109c050f08438bf4725e4f288f2ec1249338n,
  b: 0x56dcac8ecc47829c0fd480ddn,
  r: -0x130d8ec8685b5c143718b527017a23da28d1c4e34818071e93cf10a73838f9388f1758n
}, {
  a: 0xd6376b97003dfb5c8adff4dc0812e5596e3a377b64d4e0c87b1267d64a86n,
  b: 0xc7391ea3e3n,
  r: 0xa6b4e09cf7a793c537b1dd4a49b3c3a80baa1051942a56b6749a1734fca94e162b66d2n
}, {
  a: -0xfe494a036b96901n,
  b: -0xc6045d30bcf66fcac697a912e6c5e397a330e7b95a0b46e9aadc3abn,
  r: 0xc4b104f4d697dc53534bfe3dd21d6515f260afe08032bd8e556dd2a335a7985881e6abn
}, {
  a: 0xceb4fc803f281e4a2e0ce3c42fa7c9a670cad6n,
  b: 0x846986cc0234ae47aac8222c66b0d619n,
  r: 0x6aea87452756e1c92c409f7ddb5dd723f0d307d347e6b3172fc8c9db609af841b2b2e6n
}, {
  a: -0x5431b8bb373a0d663520df4a56603f144ea7da9db3bf9e7aa9fb653726929d16cf1n,
  b: 0x46en,
  r: -0x174f4404d4ea3275abf579d1b4a9e576bf46b8a66923ad0035cf79a5a4cdd73db0938en
}, {
  a: 0x73f049458c78da6cn,
  b: 0xc96b94f20c3a9f9f41b99a3d14f744f364e08b101ff9542c243cbcn,
  r: 0x5b38626ac467e320f9842d41acf1fdbc9f8c9195abf27ee93b0f448ebd59f8c321b750n
}, {
  a: 0x16b6d13e29c87466b2cb268c917n,
  b: 0x624ad0c05e8fccdc3ce872fe55309c29e2ce604bf29n,
  r: 0x8b89f77e37a2434195df720a849872c095cddf14b91e49ab61f1d91c733868f2c5dafn
}, {
  a: -0x778fda6699a1b332e2ec012d3221de8b938eeb6f35bec713a36n,
  b: -0xd80eea6fea58b6db554n,
  r: 0x64e857a245b13d70b800cc3d7a7a7107f466279eac9764bf8b7edfe55d17f4be4d47b8n
}, {
  a: -0x943aa97a15871256b768e6a816d1a8a286e65d1dcb4acf96f9ea149af325fcdn,
  b: 0xd665235n,
  r: -0x7c23994342aa0eb6eb3fa3602bb553553076b5f54b69ea26dd3cc9ecc25b4efccb7f71n
}, {
  a: -0xc185eea1e6e7d58a560e9638493e386ad9ba41b576c4eaf9606d49090c1e73d1dn,
  b: -0x7f061n,
  r: 0x6006069e48428acd1f47e63e5b0b1a06380b2e923447d09b875e0fd207c9f4edb457fdn
}, {
  a: 0xe0831215e835485602d7be75c8a4cen,
  b: -0x1f3e8344d58fc47ff652d52f9206ded33de250a9n,
  r: -0x1b66b20e78c9d7e6c8ae6c8b202626411ff51979b53897a550382eef9f35bb08d12bfen
}, {
  a: -0x11fd50627ef5e25488fb20413b0aa4410961b76n,
  b: 0xfc4269ebd2e80138df7746bc9dcd5bfn,
  r: -0x11ba05e126b210449804b98f25d0feb49e9e33ad38eeba4429909be206b976843fab0an
}, {
  a: -0xdf80a276920n,
  b: -0xfade01e0227ff567d3794837bc5216a1e1b3b2d7df307a18cc4a32ca45dn,
  r: 0xdb0571d7dcb606f6d9142e30191f64cede1c12fd8a145955514065aedaccd26129b0a0n
}, {
  a: 0x7bda7d558d552f29470be3bcf224e005964e5fa41decccn,
  b: 0x3b7bb77af4474e123459a480n,
  r: 0x1cc735a19b942b6d19d3e0507c9047e8910c0f29d7d74665a8cab586c765cdfd951600n
}, {
  a: -0x2f6797722175556c8a9aac487ec48a4c8d0781074a2fb56a8dc02336a110cen,
  b: 0x6ca6ae1en,
  r: -0x141e914e5132843cdaaae9e7abb694726a2ada205e9a4ebfb5caa84715d2c9addffc24n
}, {
  a: -0xfacf04e7afb1e05b0a3an,
  b: -0xb71e0e854bd88b4febdce58751f7a7fcf94681f80759b7b307n,
  r: 0xb3676efe1bdfc3cc193f51a4e9e7889db95afc008b94922b0fc615e8f5acf54419d596n
}, {
  a: 0x1bd463e798563232d3de9b661b3b17626ae48d66a2227af38cf3d6d4b1an,
  b: -0x9914bee891en,
  r: -0x10a4310e229f7e1bebe5ed6e19cd8722fd3f7ad717a693988c68539625247f202bb70cn
}, {
  a: 0xbe0290994d7129e96e07ba13c4689d1n,
  b: -0xd7e9e33952bf3043df9881e40c54f07feb1e15bn,
  r: -0xa041c06d2dc6620da026ff3cca53a4287e537bd4a31a94645d63171b07958413b4ae4bn
}, {
  a: 0x369516e3cc67b68f3ac0b8b543e30bd8348b3669b397eabbbf602f914186a267cabn,
  b: 0x50dn,
  r: 0x113af049c8f67d5116bbf64eb87e1c2d3016321d3e0164c964598d040a7f502463abafn
}, {
  a: 0xf9aen,
  b: -0x18382b049598bc3aaba491462ef4303a1bf3a8b27a2611c17483270106888900f2n,
  r: -0x179f1804b29f3ce500d3bb28015f6ce14caefeb2421e0d253bd0c214820d3e0f0a067cn
}, {
  a: 0x6eac958383834170n,
  b: -0x29044ae9a8c1078d88dd0e4256290e05457e693b11d386de2830a0n,
  r: -0x11bb7f074d5ee1bd87e56a72e9d6d4c9eaf06e60360fd128e2a49d1e920abc27cde600n
}, {
  a: 0x854c40f131f96a6e320a348cefaf366a35d68cn,
  b: 0x461e6bfd75e46121923916f80bfebe90n,
  r: 0x2482b0ec68d1d0c1afcd5f2a3d7f7a01d2c13ee49133acd6c758bc7b2e82b2966c96c0n
}, {
  a: -0xbf037275de0be71490f600cb8ba9ad568be307fen,
  b: 0xb7313472955d8e1d688d0f0f14ef74n,
  r: -0x88b02d9d5c85bbf744bf453b3b87d6074e947d79901c740863522d918ff0e6d92dc118n
}, {
  a: 0x775ffe5336ec255ef3b9194c99722a6743ec35bn,
  b: 0xb191b160a6647fa5d68a03fe3091556n,
  r: 0x52cd4eed068965b4f1e31304b2e5cf3b6e640e619457863d5ed082310dfc47c24f1792n
}, {
  a: -0x27b21e0b39bf6adf837884047e94c507d2b98f2c1505599c88a9d4f0d9d90871n,
  b: -0xbc12fdn,
  r: 0x1d29bfd162e3ba03d4e2a45aafbe9840a005d171d307f8f58aee0761b05cbac11149adn
}, {
  a: 0xcbb01f4e04099d71c4b92c2443n,
  b: -0xc7f30deb3eded464c67331156181a94ea275dc15b96fn,
  r: -0x9f174b967a7af4a427fc852dd45bc4e5d12d9a4ff7962a40288a9f2e499684bdd7240dn
}, {
  a: 0xd7d73b1362474n,
  b: -0x11298ab52fd766e63fa478b2cd76ef3237ae1717c7142ea6e8dace161n,
  r: -0xe78515788fcd0b533c44e58b1b1c920c34f8314ea72fad1d091231f32cbe31d7dc3f4n
}, {
  a: 0xe85da3d6694bec8487837f9dc13b316e73b00dfe997n,
  b: 0x3439c1b485530c96aee08853407n,
  r: 0x2f6771f37b80bdfe883b2ea5130e98559f03356499c577bfdce0ffc4b972cd95050f21n
}, {
  a: 0x4c6a8da14d69654dd34n,
  b: 0x5abbb69f6bdfb6a594ee8cbaf55e9eb92450e5b5c1f3336ca5cn,
  r: 0x1b157e23811c8e5b5749505f4e9ea03a1e46e359ab276cdd7a88121548e701020286b0n
}, {
  a: 0x48527d69876679a286b4cba785a18f6dc88ec30913427f14n,
  b: 0x1ed938c2e5ad9f07618e02n,
  r: 0x8b708a7c726be90a4f59da104b7f8635bb0607f950ae5dcb18d57a2551dd8bb961628n
}, {
  a: 0xec62a26a79d71284d9f6b511a1b243650b711f4ec959209e256e133an,
  b: -0x73083e3c8b6051n,
  r: -0x6a37eb82b335c478d46e4f3b8ae390ef1a1972a7fd6f6eb52652640c6337652787d55an
}, {
  a: -0xc5faf18c879d0d5ac4349075519bfc92n,
  b: -0x4e6d7b69c4ecdd2077e801d302bb7fe9bd9d23n,
  r: 0x3ca720e3086e7f0570437da6b71f8c7ed2f2fcd7db01d939660dcd3ab0de8f2c0311f6n
}, {
  a: -0x4b2435cd85276fb716e1a020238a9ddbbdc9e45f5e5c9718fd1fea8addbn,
  b: 0xb3bec5eeff8n,
  r: -0x34c25097a6b3369db0e95b3d720615cc989cba69cc1d7a12c6914b817fdcdce821e128n
}, {
  a: -0xd28aa47b60f8b067499d19583f4bda42a0ac0b4e94b88n,
  b: 0x24d4a4a186428b53ad87754d1n,
  r: -0x1e4a615738cb0ee4fed6c09f3537c3d8c5932562ed8f6326a04b95469537ad1b774a08n
}, {
  a: 0x22072a4956e41415c8bc95ea02f14e57753ed0e378c746f308e4194b91n,
  b: -0x2e47456b1c45n,
  r: -0x626c2d0131a7a7eb220311f277ca3d4b6b14eb86cbe656cb8eff6417ea57fe9b03a15n
}, {
  a: -0xd2d90f8b74f188a7f2809726e6e97adf7a012a21n,
  b: -0xfaa84e75da2695021ad985cdb65e8en,
  r: 0xce72983f9755d482dd33e0cb87e68c5d20b5afbedb3bc2958857ed08debe777a937c4en
}, {
  a: -0x22865fc4780db6dc745e160332fed91a8b0c442978cf6891b1a3f6d2184d9cc0e8n,
  b: 0x545dn,
  r: -0xb60a23d41c41cfbc44525670be525d1944489d25eb4f1a8cb37558d9a4c4ba13e3448n
}, {
  a: 0xfd0b3a167fd5383ace1n,
  b: 0xc0023310e45f611b53f6fe856679a8857095eab34c89a85ade0n,
  r: 0xbdca9821430f4d98deec9c11b0f720e38c602d146b81d8493daba2c1a28c4939f051e0n
}, {
  a: -0xa6n,
  b: -0x7fc936f65d41ed709c13aa27343ccd48d70f2937e93fa16f789201b034ab35a90515n,
  r: 0x52dc79a3c078bff70534c0556bdf6d1d3b73d4ba413f42ae482ead18422704cb994b9en
}, {
  a: -0x584165dbd27fbeaad0f1861b14d5c82e1189cdfe4a5d63a2n,
  b: -0xd53d8ff3da1ce20ae40ccbn,
  r: 0x4983a2f5c4b092248bb4a582756efc4eb422697fe18d9baaa2cb593e9bd23669019976n
}, {
  a: -0x1c9d1315b6e52eea85d9f61a08959240c6a4328dn,
  b: -0xaf7cccb9ce24e6d3d2a8b2343373can,
  r: 0x139d5303064ddfc3cc7cb4cdc60bd1babc40c052a66cb77665b456cffb1b5d365c3a42n
}, {
  a: -0x7d2801112d33c02da004c1cd44ad8bc5a1a1n,
  b: -0x9286f057312fe6ad18f32a8cb15dbc2d99n,
  r: 0x47a2c90c7c69b73a8ae48beb60dd057c090e4069c1ed43cd533cf8736cca7575c2e639n
}, {
  a: 0x8cb61d826a85584b722n,
  b: 0xafd24fc103ae70aa396edaf7f863ac73c049383107811b7aa74n,
  r: 0x60a41766a63a0afd48fc7066fc0bc91495e0aeef0d59fe2225c8114dae37090d0d8f68n
}, {
  a: 0x674f5bf433c10a85f05406938835ee4e6f3f15133bce2da3f4a7e3n,
  b: 0xca315a59e692e943n,
  r: 0x51988935788ba25aab5053e457a5fe287dd0a0872ce719e1368c2d522afc74474b8b69n
}, {
  a: -0x19064c5d103c0d89ebfb1cf00fc283c4a4106en,
  b: -0xc609a78b7c6edefcab9f7176bf8d4b75n,
  r: 0x135bd0a9683a143230da92194b4142ed3e0449550af95bb0cb550d84ac58280e61bc46n
}, {
  a: -0x547495116ec6f965fdbb77e91880e0afd8e1d62aae2045bn,
  b: 0xc5a9bb1934f558316e81876n,
  r: -0x4135b5664c8028d7e064684c024f728a4368c88db57060f5baec8c648c8644b90e89f2n
}, {
  a: -0x64582458ad740b9fe4afddd545e3c8a679486a6c93f7ca2d0774dn,
  b: -0x55b3136853fd95c92n,
  r: 0x2197754e4b0622811a84192205f72b8c2750eda17e9446ee61dedab28388a9d908b5ean
}, {
  a: -0xa95e9cbb4773e097dfe2b8d6a20f2a486n,
  b: 0xd570eb7615dc98243a2a8d79d860aa07076acn,
  r: -0x8d366d945e558a4d20f543e7f4907dc902ec3493366c7c77eeb38ec73e90b5b57c4e08n
}, {
  a: 0x6a3497847754334069008ad6aa5a052d6214efdcbdaf1993831ed05a7bn,
  b: -0xc51d440ee2b8n,
  r: -0x51c69cca3f038c7b1bdf5314814f2221099878c2c009f6c69218102731b5ceb45b9e68n
}, {
  a: -0x38b09e43c08afeb5542n,
  b: 0x420da7afcdbddf60706be3d0152a5c34a3a69232d18cabb08b2n,
  r: -0xea08ee7a69e7a3d4843e9ae653106978e48baa0321b937b043fe84dcccde7078157e4n
}, {
  a: 0x176bf0d66cd058c0778d21d8edffe3d5812n,
  b: 0xf296709d7550b66b3debeeb47b1551d11a1n,
  r: 0x1631cd3771ccf093a421bbff4d3dd5dfde245faabcb1d9da561e64aa3ac863eb779552n
}, {
  a: 0xa86a3d52cbdf8a40953b0ff97102a8813d20n,
  b: -0x1dc4f31c0f085a1387a7faba1902e6ad49n,
  r: -0x13959a38a2346e8e9e41083d8a6a02462d40a851e4e02e6f613546997ca4588de90e20n
}, {
  a: -0x3147d7475064751d636906ca2d1n,
  b: 0xdfc128f372f6073aea1b6a272a62587fddc92ee6496n,
  r: -0x2b12c39282c0f54cd4f6d95ac525ecfdb41a4e4cb259a70a5885c1923486d99f8f0a76n
}, {
  a: 0x7730c65e105527da285014a9f00dan,
  b: -0xd86d4af5545c85c462a3115e8da275660e95a0310n,
  r: -0x64c40a0a2620eb863668153b2336ce3d24d5038066c98e9fbc1ee1dc35d5613d969ba0n
}, {
  a: 0x92302999faa5c1c2e69a52b485c8095dc98bn,
  b: 0xb7cb4fda29098ddcf301a9a7f216878fe4n,
  r: 0x68f48787808f5bc962f7e86c5e5166dd82885bc574b6ebbbaefb2fddb21590f56924ccn
}, {
  a: -0x39cf2a0e00a13b66547f524c0aa399191de49af4f34cc2270584f54bb1893n,
  b: 0x1dbd7d2bdn,
  r: -0x6b741f9aeb5f397a7b7c007e091c9f553cede8933c0b18220cf2af23995cd6cbeba87n
}, {
  a: 0x796f5bcdd9e0507b1a74e0581bf5e97ea4eden,
  b: -0xffc70df3eed2180f16eba65873c763519n,
  r: -0x795458a0c6b1961bab7aedda995ca7b888ac6dcd75dafd92cbfa5b0678633eba89a9aen
}, {
  a: 0xf2bd630a1f340bc34e9b7c26218528c6dbadda37aaa4ec94n,
  b: -0x17e5bbf883bea286ddee5cn,
  r: -0x16a8d98b7c97998fba80e45c063d4ddc857885140f75893596e091ec6a5e845afa9d30n
}, {
  a: -0x1a7a4c72a45e1f7eebc6f4f849355793b1228d53en,
  b: 0xc82feb1f9cd6d1456e59123279204n,
  r: -0x14b4807f22aaf31e0998c3ed9bdfdc04e04d5b6e7aa275a000392be2aa2cc588b2b0f8n
}, {
  a: 0x9f38560e1e04b191021125f5ac35f3c4c7c8108f91fcd609e559832fc3n,
  b: 0x73e561dc10aan,
  r: 0x4814f8ea897f84429535520191aa6fe774685d45fa5ff8e823b9ceaf92dc2a92ade77en
}, {
  a: 0xf70d2531ae7cdc196af5f33ff3n,
  b: -0x3a01ad9923c95915c6047345dc070daf15ed18c90c26n,
  r: -0x37fa99021240e156dba9b79fe957c98ece2b8721c07e0dae1d96528a74d65ae6e5e212n
}, {
  a: 0x6381df80bf03005ccn,
  b: -0x19772747172d6c33d37afe05e0583a687daf57534c49e4a496970n,
  r: -0x9e5ff76e294023472e9049cbc977e2719835b18792db2531575e272328e03668f3540n
}, {
  a: -0xd9a3581ca8b653809cdec3350e313dda14abd03e8ea058n,
  b: 0x69fb184c7b9effcf0fe33d35n,
  r: -0x5a1976f37b25b2f6b1804d47c3bcdef594babdab51d45eed63de0e85e5540a45c42a38n
}, {
  a: -0xe6f865040bcc8757fd66n,
  b: 0xf1366189b05c66007281200bd63b29c4ff1f5dc79d95e2b912n,
  r: -0xd9a0e77e7648c2efa6f8d2ef503923fa4737546dc5f6198d63d3cc4b2405e82c5a872cn
}, {
  a: 0xba43eadcc04a849a08b4aa6bcaf2443a49n,
  b: 0xeea42faf2adfac8240d8245416a5be9d2024n,
  r: 0xada29a8d9bee6e6f7d5e057d172f0022182e2fcf4ac56a184d7720d7a594f985a65244n
}, {
  a: 0x3f5f8b3c8cae6fb2b9d775bdd5d9a47e92cc6b571f6c8fdb3fb09ea11f56n,
  b: 0x658abda60en,
  r: 0x19230a62975bded70aef1acdb7816da35769cbfe4430dfd756a319d9c3574ba59f7ab4n
}, {
  a: 0x96bd295b24230b72eb29163f01f6c49ce9a1bb0ffb9b927e95n,
  b: -0x583ea7183b217c1e8db2n,
  r: -0x33f5ea6b0306718a7a21d76c053cb501d24c5cdea4ab180db66adf1cbc8a51dd0a149an
}, {
  a: 0x34a497n,
  b: -0x7454edc55b601938be386aa3a1a6b8bc5307d36412c33d6794805e717fcae2d2n,
  r: -0x17ec0b52813d77955dddca00d48ff0adf079dced5d9bb49d89bd4e034660066ca251den
}, {
  a: -0x208d280f1c5154ab33eed00b38677d70b274451afd9d677295c2n,
  b: 0xd982f98c419d2b05c4n,
  r: -0x1ba84e5e482dc0168ea809dc0523380e60ad0d1f462fd620fd48ecad3003e1923d7288n
}, {
  a: -0xd177ea00c8c6dcc4289730d911385c9n,
  b: -0x70afabde437525e190546322adff97153601d16n,
  r: 0x5c3433fa44ddf05cb9fb7467f69b944d924bbee105537dcf31bd3f5fcdb70504354446n
}, {
  a: 0x580a31n,
  b: -0x1cdc1a56e8c9faee930ddff019df19538ca23443e0e80cd78bfd12dbf088a759n,
  r: -0x9eccf2d087528b478e62daaf022a85f69743e386bf78b8702ffb829c7e277e7498209n
}, {
  a: 0x7520b80698e69ef55ad76df40n,
  b: -0xcbf3f74947d24e8519a9f98a23f95e60e978169392f41n,
  r: -0x5d5091200241262b36b11550eb37072696563729b22a3fa21f418446251fe2d36b6f40n
}, {
  a: 0x1d0079172cf3bd0n,
  b: 0x26dcfd29c9468c572cbb5bbdbc3108f4a16cedc16beed078768ef87n,
  r: 0x4671b0fb42378c1f1e7110d598f7fa5d019e93ba5f46472911a2934d0e74e009fbab0n
}, {
  a: -0xcf6d4a540080f9b6bn,
  b: 0x1889e2cb9a81855bd360ab63997fa9673af4ed43e48840aaeca8an,
  r: -0x13e1f8381b792654315bcab04ab77848ff0881d28a530b4ddcec1c7687ecba79c635aen
}, {
  a: -0x284b33882b5e714dbcd7557625c7dcf694759b259b2b5c028b5e418ffd506454f3588n,
  b: 0x4n,
  r: -0xa12cce20ad79c536f35d55d8971f73da51d66c966cad700a2d79063ff5419153cd620n
}, {
  a: -0xa1d6n,
  b: -0xade37a8899626d2d3cf77c7d20f13c34dfcd65186c5555ea20d5a98ce7dc964023n,
  r: 0x6ded6c3856a71ef0b7289c2cc251408594f34246de8c3a5e105dd23d599b8ce3efa042n
}, {
  a: 0xd1eaf13747ae44ec8n,
  b: 0x77446a55d5ae06a1bb2f2b773408d733c6eb43cab7f31bee1ee0en,
  r: 0x61cc4fba6f1b353045d5d2be295dbb9e0a4b02eb3b88099f608b69469f1c08a7823ef0n
}, {
  a: -0x8c853bb3345d879d147375acfbb1e78050facn,
  b: 0xe6a5aa7f1d1ac82da024a79ef8e3c808an,
  r: -0x7e9aa318bb4431f91e2b4dfa7e6db1b4c9157717739746b8b917f3e41af7e44ee072b8n
}, {
  a: 0x4f04fd23621f15ece8c6n,
  b: -0x5da0373e9e85c7e5c3c9c6a4b428f4dbe22cb462d0528f65d8n,
  r: -0x1ce644217748e6925c7bcfcbdcaa4fbfc52e885795ecc73d3d034e84c51ca66a548510n
}, {
  a: 0x22984fe24fc4296447e239023ffee096d946cceb88f9c4e6c3ae6d081529c1aeen,
  b: -0x984adn,
  r: -0x14948b9137af6816e34c93a59ef7a905931768ac9be94466dedfa026097d7a43beead6n
}, {
  a: -0x49acd57n,
  b: -0x8389efdf7bf089bc6eee700f2d14dafb49a8105719e1290966b3c75bdbadc01n,
  r: 0x25db23bf356cc0c8a21290e4899ae39adc294bcce006369eea410b33a6e2ca79479157n
}, {
  a: -0x123b60f710d963495d7eedfd8a2bf3438734a265b72822117n,
  b: -0x61f9f50b990e7719aeca0n,
  r: 0x6fa4cf294f1e47c890c6b3674dabddf15847fb861db93013690b179ea655b96abe260n
}, {
  a: 0x4219f0438ead75fe428ac2c435c15a0a40a4e2fec8ae12570aabbn,
  b: -0x522da6be9b415fbd7n,
  r: -0x15381892e8b65ab90107a40e9e1b6e7f7e98aed8c20ed5f438408b42c43a48665bbc0dn
}, {
  a: -0x6f1b02cafn,
  b: -0xafa365cf9bfef089bef5b2a82bf0cd7d920a22b8b66af59e34e33bab7ab4bn,
  r: 0x4c3a614b43ec22aacf9d8e107f14ac07555facfec9c1f58171f36c5a78a3bd938efc45n
}, {
  a: 0xd7b2n,
  b: -0x931a1c1380ecf78043a6a88ccc8cb29df07fe3bfdffca40265638453fd087a166cn,
  r: -0x7bf135bbe6d6a8a0d000016f71b063d6d6cca1328086eb680cd113548be80e6db84b18n
}, {
  a: -0x5d6f33ec684025bfc0c2bn,
  b: 0x734a269cca38f4deeae7c91f12025aa03e183537f05013e99n,
  r: -0x2a14048ff07237b45958a933f0d5d2f027ce4d1a0ff066bc4f0c1a8768ba3de7c0afb3n
}, {
  a: 0x9f4f7fafb7c18138d1c9b871e5f7f427f7714ae55ad6b9adea66bbn,
  b: 0x7a24bb6873e9c8d0n,
  r: 0x4c02bea7c4fb7c16f2cbd517686c92ff0396b52bda04c5c28025909a3f7231efe88ff0n
}, {
  a: 0xfe7452e8622311cea401b62222b30606677b1a90cf9a6692ee88852fn,
  b: -0x97857141ffbf27n,
  r: -0x969b3fe916f32a2e969f81089e487c3ae44224c8fa716632a4651a1426b8e6cafb5b29n
}, {
  a: 0xf1b3fe955b0c92afdn,
  b: 0xcf24a24d5f2fab23d096453b12b01a4d46dad23d490b456e842f7n,
  r: 0xc393216785bcdc055753b42a646718f7606d1c18f4f318fbf20f0aaa028de56275b41bn
}, {
  a: -0x968ae2150dae6c7f31345ead8fd044ce3dfceadaefb5ff98ce1n,
  b: -0x11b6e20f414b2d99d81n,
  r: 0xa6ac4afb4ff9d6dd423cf7bc386c8426b7556dddca403c4cb43fe698aaa9844defa61n
}, {
  a: -0x3aa5f098a4216f174ea9c3608da05dfn,
  b: 0xbb27eba4dd4dfd3c451e47895511f6ac9abe61cn,
  r: -0x2ae05c034002cc52ba83b05863f55953f61e672ffea833053807310e982970dc13fe64n
}, {
  a: 0x83aa145791bf70ca64cf3fdn,
  b: -0x39ea4732a3fce28982e8e7d3b54afd9b90dae3abf08aecdn,
  r: -0x1dc95c9c4eb27683606d2aa0f7e54903ec1d8fd585f934623367ba59e647ecdc5d5799n
}, {
  a: 0x24c747f1ee13c83a4ff1d2322b3c2ed951a783f277a8b6a8n,
  b: -0x92a5664db5607f2cad650cn,
  r: -0x15116a2be95f86701ccfbcc5c04f5614730b51154e27a3eaf7b29b104e52537b80d7e0n
}, {
  a: 0xc146070c0b7205b558f214n,
  b: -0x58fc85c4f19ace85f39e3ef4066a97808a25e92c71bc9fa4n,
  r: -0x432eb8592578ea0d0459e11861fba6d3c5ffd7dc245afef2abec1df8e5d6e7060580d0n
}, {
  a: -0xf050b2297d1a1100ef27c7bd14n,
  b: -0xebfff3b9b279e10a715cb0b0042a64e60b6fd3182abbn,
  r: 0xdd8a58b878233193ba3238e2a5bd74ae6f7bebfa67490adb7411058d7b1e7609cc659cn
}, {
  a: 0x39a8538195e0b95a81f0d1baf4n,
  b: 0x86dc4b40740b82b6c553600379bef121aef87b6cfff2n,
  r: 0x1e5fb9506c7f22f5eb4753c57abefedc7185abe5c916a336a437e653984f64aa6bc6a8n
}, {
  a: 0xc2b3d94a136dc71761422797c080b7617e4347622248b7d7d3f9b0a317e54941bn,
  b: -0x8ac0fn,
  r: -0x6987b08d81bd31ded69c862384b407dcc31a5d4f8300e9c8667deb367acc6bdb4ed195n
}, {
  a: 0x60c70882n,
  b: 0xb1f0ed4ea3edef5b4a3bc48aa0c6023d3554f874b4b83b5306966875142d3bn,
  r: 0x4344b12fd95d9ec5fa1b84d7548b5e2e86335ef8a367625ec76b3e752638595e85cff6n
}, {
  a: 0x8a3c95cef6d50087e6937785an,
  b: 0x374929a863eaea13b8c7e07dd74af23345d33c22c8d40n,
  r: 0x1dda85f4d0c0e2ea72004fb7f44b1348e790c92f810acc8bc22ae887338a38be9fa880n
}, {
  a: 0xb58f11bf0f62cf2f67c934aa2afd32375e979c4d3315a9326d8df358e7d862a33bd063n,
  b: 0n,
  r: 0n
}, {
  a: -0xef937f49670ea6cd645a10225n,
  b: -0x439b1ad039e92100966496bfd37396868f16a81c09996n,
  r: 0x3f44c1b620611f1aba5fccdc8ae27526f16e9af5c5d5371a6ef2162ce9e852475f5eaen
}, {
  a: -0x5a155a52ed0e0b0f5ed18c99403412e09b0a77fe00ae5be5b5a9d3adcdc6e3aa96116bn,
  b: 0n,
  r: 0n
}, {
  a: -0x9abb336fa3fbbbbbc4967b99058100a4ae1aed704c0551a56a36c85n,
  b: 0xc231c6cf8fefa22n,
  r: -0x755ff2f9b0c9800bb5717af3eb1cfc92d03a1a50110d4e05c4867ce7b6a17d9da44baan
}, {
  a: 0xac2f3c9f2b30f9419d8dc7f8d440582e38a59f24769116n,
  b: 0x111ba458cf8bd8df292d0252n,
  r: 0xb81ba8bf552dea2703cbe869cad94c5be9c117dcaaa4eb765aebd37e5a380a1faa50cn
}, {
  a: 0x7df3dbf5f6cd1937f62388a25dfe383606n,
  b: 0xef81f3a14b43050fdbe62532b13dbdd595e3n,
  r: 0x75d69a1a4d8a119b0b5f6729a59dd67899ac4cc35264bad3f371d66177b86484476552n
}, {
  a: -0x9634017068ca45ca454390dc9e3a74823e69103e2aebfe04an,
  b: 0xaaccf3cd0973db5eeb628n,
  r: -0x6436c97175b87c23a1045b5442b579ac1ef2293eb69067b089587c66dbfb408e3ba790n
}, {
  a: 0xb69568dfb403ecbb3154c67a59d6c6d979ba11ac1c144337832bn,
  b: 0x331e3f3ecea148305dn,
  r: 0x247556826b7195f1145b4c9614bf32869d90c35962bbb7d97e00282ec7c7abc2dab69fn
}, {
  a: -0xa38ddc51f17051a748c6bn,
  b: -0x89017ef5fe414bc30a9b559ee8144c124a3aef74c9f407147n,
  r: 0x5787df92b22bb4699a0572c3dff58b19e27af49b689390b23c9d4c314c9035580e2cadn
}, {
  a: -0x79ce67fff35fb0cn,
  b: -0x35b1b84bdd6398bce8dd4b5c7e0c8b00633452ad843ed5def0716e2n,
  r: 0x198c4aee58e916f0a6083399dc9a8a12305ff71b85cc48163eafd985402c24028ea898n
}, {
  a: 0xcb3398895b1ebd68668cb0fe889488d30075693f3ffn,
  b: 0x40277eec33b3f135ba7ec38ae50n,
  r: 0x32ec3fbd7562e66f539c9f47d86bce243cb794ffc1c0dc9bfd40bbd75c24c911db91b0n
}, {
  a: 0x71f6a82ddaab125da27884821741d3e148n,
  b: 0x73efdc303226362098c4c85e8a7e1a4c3e8cn,
  r: 0x339c94d909241f08af1759f563d04c14d5e0323d21f6c8897d4a7291b987e181cea360n
}, {
  a: -0x85813bd39026e8b5b91fc412f7192b538cb077n,
  b: 0xfb005af3a56ee502ae427609c0d451ecn,
  r: -0x82e5e516ed50712ec07928ab696ebd1858cf52f24b09d3fda433702b43ac6aec1454b4n
}, {
  a: 0xf2801b799005690dda5407a98e019b16c9fcf5001163c3ef8eb600n,
  b: -0xf0c5b02fae426979n,
  r: -0xe4135d3c590b8098dc9c40d17fea7f5bc3e9979bd7c498c9940c3c35cdb15caf1a0600n
}, {
  a: 0x8ce25b22a4ccd7c301b60n,
  b: -0x1a5e083569514522fe0b9f174bf1f378298e09ce832edb549n,
  r: -0xe82bce37320d57fdceb7649172de713010955acd769903b9136dfc321dc4884f2ae60n
}, {
  a: 0x8efb57caf01bbaf051f6fcc13eced8704n,
  b: -0xe35b450fb02db83754410ff4417a7321a838an,
  r: -0x7efbd8c3a9d61da79905ad33337c94ad30c1c2d04c5add037df32d85231915c289d428n
}, {
  a: 0x63d1ddc947cc9eabdb3ac881093326c083f0cb1eaab46ff80801edn,
  b: 0x13734a0da7184e79n,
  r: 0x795879c8eab44a00c34f31709c6ab66740c1306fa7dad8a4f7a2ed4637b8975971f05n
}, {
  a: -0xf27d631f60ebc0883n,
  b: 0x68925243cea51f9e436cf4021a6848358184f5f90997a3bff706cn,
  r: -0x630d89b3ab9359743e038ef8244b0abd5a7a597d9c15ec19f88b1dcb1916f12689e744n
}, {
  a: -0xae7a67768ef2acce001b050f38c63324797b1fdfb11fbf4f8bb4265cb28a599bcn,
  b: 0x17133n,
  r: -0xfba1318480aa456d5b30f7acf2ddff33c35eac78c7df0c14c537802f41d0fcb959c74n
}, {
  a: 0x156106d96an,
  b: -0x8950995bc166f7471754ee364a30d528377af78b70b8aaef7b226deb6d48n,
  r: -0xb77a7cb24673f1bdf01b6eaeae47a6193e5f48ccc16e055070e73b94dea42eacd47d0n
}, {
  a: -0xcf5ab5b309n,
  b: -0xe7f3d331785761b2d3c580bee47b52ed34730158a37d6802696b7e589007n,
  r: 0xbbe0581edba92ed19c82f8bd9e6df9f49eb27660789188ce9d0fd1d4d3cb08a8c4f53fn
}, {
  a: 0x7a85ecf7b1n,
  b: 0xfb38b4fa17e3a266740893f75a91901798fd3ebeeccb63148d6e717d96a8n,
  r: 0x783c73408d90451c0362e613739425bfb41197e6f90097c63e60472e4c03f8cf114228n
}, {
  a: 0xc42b731cd1973bb9cd0c959e2c65ddan,
  b: 0x1f8cd580acd30ca3da5f81338190651fcc6ab27n,
  r: 0x182d2e4e321362929fb84d9d31c6c9a865fcc7e08d3e42b5f844dad24f2ef53b84ea36n
}, {
  a: 0x8e6bd5274a4c148ddff468957b5n,
  b: 0x925a86e171e5786b2e9bd61472e3437d302bd74c599n,
  r: 0x516bdc8335e5ad6e7416138f264c0f24ad11da03d51160d5b206190261593f3797b42dn
}, {
  a: -0xf2ef0097b4940b0cda59861a09a82b357ad6a058340ad4220728a0ad92c18ae06a55a5n,
  b: 0n,
  r: 0n
}, {
  a: -0xdc3fbed7637f557557en,
  b: -0x809d986f659f103b6ba6a1b86f0aa8cc20882b68a280cdcd0bfn,
  r: 0x6ea775a96c395223711f1a53e7fd28cb9b4a78e223dc4d2b14b3f64b1ee1d661e72902n
}, {
  a: 0x463b1176a8aed9d18c109403480afn,
  b: 0x9e747f99eabd6192fbe7e95b5f48bb84c7258f9d9n,
  r: 0x2b786a8cad3d999aa528a6cdc2c3647a4b0b4c96c751a6478a9a782e9c0f98a7d34b57n
}, {
  a: -0x5333b0702c59de80f5e809da6aac487cf9ef1345999ecf64f333b3n,
  b: 0x6fdb6b2bfd85d80fn,
  r: -0x245ab98d7a04032e490c17cbe538d36a4b536f485b8d6c23886b1c9d1997d6e0de0f7dn
}, {
  a: 0xc4695ed20ab7d81695d8fa741af911f54605148670dcbee09832d3710f106edn,
  b: 0x6bd0670n,
  r: 0x52b7ef453a4a0f00faec87445260bbba51c6b2e0e9aa0e8bc6e544e8803a98ba9595b0n
}, {
  a: 0xb629d8a1162561n,
  b: -0x253283434f81ad725c2560c2838ba18821946e6474e554f48561c8e0n,
  r: -0x1a77fde2e70b0b2b65060b384dfd2c280edd111b687423994a4a4a87ffdaa9cf557ce0n
}, {
  a: -0x2fb3bde0c02ce5eae636fbfc8n,
  b: -0x22c35a99ccff59351b24fe1c85c107f087ab1a4b69e16n,
  r: 0x67a46035518a7979676279b0e4c2399d01bde8aba4166d744ac3adbc2f5f1fc27eb30n
}, {
  a: -0xbcb103a78112d62aca6d0f6fc4a81057eda287784143ffde70bf5391n,
  b: -0xa8f623fc6fd19en,
  r: 0x7c899705b3d525bd60c1afa161cfb3cc582886cb6ecee1a671bf2bcfe98160c12df47en
}, {
  a: -0xd64233b7b96b50n,
  b: 0xd2524c174dc36b3dcb415b91d433b60ce3ee30eb08fb30f153021bf0n,
  r: -0xb0072f506f56144a2f9d038a602bf10ac90237690a1c839c8aeef41bef186a92c60b00n
}, {
  a: 0x1842ff1d465a5c57da36a1efe3acfafc724a55300285dfen,
  b: 0xdfab272beb6c3b26b3cd1fen,
  r: 0x153294b14744c67d66b9c60e15a1f640894941667e5fd3bf414613241788d64e51a004n
}, {
  a: 0x68a8d1cc8abc4fbc8fdeb609d4f4087d62986e9342aa7321582ff4f4dn,
  b: 0x2ce453f530271n,
  r: 0x125a5cbcfb49a6c01e06160dfc34784e87b899cea076ad4251271909a1e9907a479afdn
}, {
  a: -0x6a1c178e2eden,
  b: -0xdb7c41ac61c52c19edfce69942ffa811e9b1219e300716eca20c4ed23an,
  r: 0x5af988faa057e9c86ec3c0d150c0b0557193c720aefc87f957c7b8110f3db0a84cba4cn
}, {
  a: 0xf074409c6275d81ebe0b3n,
  b: -0x381607c15117ced3f4b8a15d049e942f8f9f394beed1ab94fn,
  r: -0x34ae1f68848e5f26aad700a1ce2158d3ac760a5556aa19f627b3fff7408a931659b23dn
}, {
  a: -0x7fd7dc9a9b69en,
  b: 0x8531953ee7d27318e30e75c5c8873f2614e9cb5d3b28785b694390354n,
  r: -0x4283e87599c80b2701ce098476e3fc227e927549d797abf139c539f80995542a01c5d8n
}, {
  a: 0x234dd67ef244765fe9112e02c58e3bdde2e808d632525b4ebc1276d04n,
  b: 0xfe638573ea7d0n,
  r: 0x2314f45354354fe31c060e18a29322baf1de9d3b7856502eed11d2c73369066b1e2f40n
}, {
  a: 0xabcbd355108721ae387e2f56c71996981n,
  b: 0x75fe7bd2c54bfd42e96b896e9e39015a961ben,
  r: 0x4f2eeee9ef183b7d3d661e6e68719075a82b785c4b3169d80a67374e9a8d05abff2eben
}, {
  a: 0xd1c8777b733e16a721c9ffa95eea441fn,
  b: -0x3de016bc9aa1737a428a26e90e2d7c7336f9a2n,
  r: -0x32b46682beade1de4288d056ce6641f20567ecbc426535e4ad9b38f7013a88380b429en
}, {
  a: 0x2c609146507b1836bee5a47b2e3cfb02bn,
  b: -0x74126b466ede366e959a6e13741a407e25ac2n,
  r: -0x141ef336a5c19017b2c1e580d082e066f327bc4fa89231db477207decbcb5e5a489e96n
}, {
  a: 0x510d160fdf24903bd83cb0f9b6f834000315ab97682a2361d6n,
  b: -0xf0fe23562cb9733f2ac4n,
  r: -0x4c4cbadad7843912b89861cbfdd8bdb78b07f93ec3cdc32fe9f044740dc1f846ce03d8n
}, {
  a: 0xffc24ee754f510f408de0b8b74bc4b8188393n,
  b: -0x11e4b476157a2c736a4b49cfc6a4fc65bn,
  r: -0x11e064963b2bf63c0f118349077917c0104a792f2d94ff1cd7c50c1b5c240fded77741n
}, {
  a: 0xa25c7b57174db65dd099c79e39bdf55e846n,
  b: 0xd5a80d6f467baafb6f388e5531a3f4ae9ddn,
  r: 0x878187d5ac9b9347bd6bdc53b4dda6ebad7c802c353573e72f1be3ac0d57ef5bcd3a6en
}, {
  a: -0x43771ca1733a4b31359e69c30db4b5fn,
  b: -0x3e4bcc16342ed52279499790d51d91231356ea4n,
  r: 0x106ad29d4202875f6e5a1f7c47f2b04b57f88a3525938417f3474ca8bcc38f508a1adcn
}, {
  a: -0x9e992b3084a24a4b0f17e85cn,
  b: -0x6c783e4d1e6af9fc0ee8e75bcb3a1258b31b972d913af3n,
  r: 0x43331c9d96129a7c6502fea3e80000c01b0686eef4c1c1c57b550275fc095186726754n
}, {
  a: -0x7f7n,
  b: 0xdcb83e7795a1cefa33c8347562a0d9bd05c3912677042896013d2f60831030c34a2n,
  r: -0x6ddff798a78cbc78ad26f99d2f48f264088e8a9195df21f42c3de5459b3e5f4637364en
}, {
  a: -0xc654a2e916bb11895ee98n,
  b: -0x698acb13c0cb4cb8f110697338f8776a79ac9901dad12c7ecn,
  r: 0x51c43dc5d6cce2183a9b2cf39a8c987208ce7046766966f8ad9be21d60855eb5601c20n
}, {
  a: -0x7n,
  b: -0x8b9db9b46cafc1bd73fc90bd43cf4b000959fc6568e8cd370baafc15dd8c5a0dbe115n,
  r: 0x3d15013eef8ce4c2e2be7f52cdaab0d004175e6c5de5d9c8151ace4990ed6766032793n
}, {
  a: -0x467af29e2b006364cde84fa4dd48ef42c003add421dn,
  b: 0x3fa4cd1014663515e0bb484b08an,
  r: -0x1185a0ed3b7e3595fb6ef769700620e6a1c2e455acb5efb578d6d4af574a6953ad93a2n
}, {
  a: 0xa59fdeabdc0c2abaa0n,
  b: -0x7b5e7382476f45f7953fb019dd4f444dfc40014de533f41fcbd2n,
  r: -0x4fd0eb6b704240760c257cc698cc54df5d0bab03338b0e43ca84b4a9c2f914f669f740n
}, {
  a: 0xdf9a831918192b6982edeb6c60d5fn,
  b: 0xfd7dd1f58e1a97d2bd5f392c08d7b92b3a41f498dn,
  r: 0xdd699965701786e786d7bf3431af83a057a639f6909667e3fcb410d0fedcc29f667453n
}, {
  a: -0x85f4aeff52db8195b22n,
  b: -0x3ad39e145ef7406c2f096baaf1aa0527eee94e6b93262dde485n,
  r: 0x1ec82b09c207806a0c39a1e03d9c282d33a7a1af0951fa904c374d9e541a21eab0a0aan
}, {
  a: 0x1eb084920badbb50154617b119b551e71441440e565c721c2afb79469a8d98c05d2bn,
  b: 0xf4n,
  r: 0x1d403e5b332196885446ce94cc80d2103f4e34ddaa501cc2d8f7af974b4ef59758ccfcn
}, {
  a: -0xf4e8499b9b01aadd3eb72n,
  b: 0xb52be0b978c0f24bbfb3115118e0e11aa4a3f103c3a59f48en,
  r: -0xad52360c118608aecc9b638259505e1fd2be483baa71794331598e66f1dd371697413cn
}, {
  a: -0xa4fc8918a8abec89f7n,
  b: 0x375a5cebfeabc28f25a0ebdd400242ddcd569ae7076c3e11cfc5n,
  r: -0x23ac7e1f5820349d176e4732ca6a84597888458b1db63df5f27581c0b806238bfbe413n
}, {
  a: 0x7aa556d8fd991673079dn,
  b: -0xdfeff95017c4e19bdf4b5e2270e5dd4169222fb1567bca3a75n,
  r: -0x6b48fe744a047c6d4b081d9c60a6f2c7f6579b4876dbb4d92ab8c7d5f0ad37c32e0cc1n
}, {
  a: 0x1392afef5d1a8bd40730d3638a2986e316478d8428398fedd5a84n,
  b: -0x9b8fce6e127973326n,
  r: -0xbe4cf3ea817e3c5956c0c1598f897d562adff0be836f72ad5f65821f836da6dbfbb98n
}, {
  a: 0xc5a6b00030d4e4ed47bde7n,
  b: -0x2f3debbe053a63f91b2e2d08577afbbf166b2cc66ee0f555n,
  r: -0x2479690ab252dc1d740a65ae53a132ad920fa9277859907779745285e7ce21ddb020b3n
}, {
  a: 0x9051a9e9f61b7b1cac12d948592a51cadb893ba6f22d71b236n,
  b: -0x11baf68592b9ac2e298en,
  r: -0x9fed297c3bffb2bbb882a58e8c666b6a285bc69b8c488bcc21d1e8bba86ccb84f7ff4n
}, {
  a: -0x1fbeb86042cb8dd8e67c1c019683dc377989b339a2b10e0a48b84af09207en,
  b: -0x74a691d82n,
  r: 0xe77134d00017a5df286ac74c29f6461d0d8eaaccefbcd5a864c7714a132c9aafec5fcn
}, {
  a: -0x71e34bae5bfd3c423a6e6ae5a545bc337290a755d711a8025066f900b241f8cn,
  b: 0x5c694d1n,
  r: -0x291c87b52f8ae9166f1d556b3ca39a4cfc3d362426ded5ac7e7b2e0c60ad981d02b14cn
}, {
  a: 0x584d8f0ea2b414ed4926cd8499640de788d2841395a890e35d07d777dn,
  b: 0xca6cb5cf13e9en,
  r: 0x45d2b2502a492fd419ce6cf2255dad6e2e45d64c090289369691341272f8e2790d0526n
}, {
  a: -0x3a19an,
  b: 0xffdc121b7fbf2d7c8a28b9329dabe1095ecc262296ac3205405f31886f698a563n,
  r: -0x3a1178818af1f9d124e48e490169f950860a5dd327595851b25c22c03e861047ffc08en
}, {
  a: 0x56afd459c570b7e87134517a4ee89aa78n,
  b: 0x16066c55437aaffed1458b5c4b2f95ff5d482n,
  r: 0x775490dbde34183922005ffc1af6c2fdd08d032b1f0188958cee7ee563605cfebf0f0n
}, {
  a: 0xfbf7911b528949ecfeb22087430363d88c1a8an,
  b: -0x96993350e035de0970a02e3e36e4310an,
  r: -0x9439d87da7a4331c1dc5e2b0c55a60a675d8e0b18610dc7809caadc5d1e22605757364n
}, {
  a: -0x193d9e40eb9a75cba8b79b45895e4d2c2c7ad2a03cbdbc8145ffc75d86b6163b4n,
  b: -0x9921en,
  r: 0xf192a9c1da67d770e28af183aece979dccdcaa263416f449471015f670306a19a5718n
}, {
  a: 0x88db46e72f9c9fe1ec5fda642587a75e811150698aed31n,
  b: -0xec43013fa02fbe20249e3420n,
  r: -0x7e4df76b8d45c5ace203f206b1e537134765d76e39e4ae357c0b677f8630b6b1c99a20n
}, {
  a: 0xf43710003df37f02bbf28878e8c3f1e25n,
  b: 0x8627caf820fc818ef5f10d55835ec0d364473n,
  r: 0x7ffac863b7e6597dd61bda1fa0150aa66907d49a3acc43a1a6b565f98cff3e012a5e9fn
}, {
  a: 0x97baab7c3be4e5e638abb6a2570f82fde10b09n,
  b: -0xcb357a0ad8494cdc02d83a90b30a4aefn,
  r: -0x7870b7f6676bc2901e14abb8891356a377b08a87159b539a6bd8951913dd3fcba3e767n
}, {
  a: -0x6a2988972525d94422462be2b15d095672ab33a7a9d14628f62ecad374f6ed6389adn,
  b: -0x5an,
  r: 0x25529a05230f4e61f40cab6db25ab54864503028f1b392aa668c734e571ecf74fe66d2n
}, {
  a: -0x11fe36n,
  b: -0x6c365a499c826f6e0313212e23f27fec5f2cbf5cfcc951f9c441f6b71358e8c1n,
  r: 0x79b10bfef7979d460dc86d5052a80aec5d4432e7b69cb836323ca3adbf8b7c08196b6n
}, {
  a: -0x999efa742bdn,
  b: -0x5a21cacce79f782ed518a22029c0100a0e5e0fb43789bc619a5c75a53c4n,
  r: 0x36162b3d87ae2ad00b476a2d6a22b4b784a15ac57cf62d8e4da076e60e010e18245fb4n
}, {
  a: -0x2d82a8feac3ecefdn,
  b: 0x3e63361f1d64cfd5bf0fa2996979a0780e79ba3a72d947ba00cfe3n,
  r: -0xb1748141fe5bab8f06da1707bac1f6beacf27edb9fd22354aba108c3146a857101d57n
}, {
  a: 0xde0381d3bb280490071n,
  b: -0x8f97c6e655dc507097562da8ef4fe7f7500c08285b47dc85792n,
  r: -0x7c87961551756103dad47ead799cda68cfa215b85d723ae0017a7dd5fe98197e10a772n
}, {
  a: 0xe547a61c743f0734e1e39n,
  b: 0x1684cd20961bd21325598cc848106e744d358b697b3a01538n,
  r: 0x142b18efa813cdcc6079b28e3655cd7a64b1a73d63d396fbce768b3e399fa260314978n
}, {
  a: 0x4bbf0b4874284aa4e37c72fb6ffae9f144884n,
  b: -0xd0e366bb32b07d1d15e9fa7304b96f5b8n,
  r: -0x3dce81f761ab6125dc5956f92c2bb5961fab9cafc3a3ff22a25c77f83dbfa1e95272e0n
}, {
  a: 0xbcd35b3f309en,
  b: -0xaf5815a2b3bcbd75f57e6b393e3743441e86a208c7c2fb210f6c056889n,
  r: -0x815573fce8c3a50cf76c0e3ed0edd14755118f4ba86eeac662b3710c9c922e1ba7348en
}, {
  a: -0xbb6fbf4c62c887n,
  b: -0x679cf982d1b5004f3d8437691272a742ef78b4ef36fb3050108f7925n,
  r: 0x4bdce4bfc7a612cc1b519356b63f0dcbac26506019e21c17bfc7528e5f63a72e77ca83n
}, {
  a: 0x11ebc03a512a120n,
  b: 0xcf3e14acd9bb480fde76c7430f59bf05c41a4abf4a7fb9ba92a1e1fn,
  r: 0xe81f8fa3a6854767185768bddfeaff3c8c8feb9f0fd2b8c317372cf758195bb6342e0n
}, {
  a: 0x87dd98454fa7d1e2en,
  b: 0x641216eae9836f5749c744731feb1719a75fc8f6e3106d5ae7625n,
  r: 0x351c29397f8ebd10065758a1928883f107cb9b087eba3937fd0f05951529f8a94290a6n
}, {
  a: 0xba7d4262eb27fcea31eebec72d774ab6cb02187f7f674d83240ced764ba804674f1dn,
  b: 0x8en,
  r: 0x67717ad2de702e49e7b26dd27b382b71649b2996b8ab4cfebdff2bb79df732714de216n
}, {
  a: -0x9b551fn,
  b: -0xfabc3975e21c75aeaea67ce51c3bcc3af4aca0f267bf78eebc42c0748da0ccafn,
  r: 0x982355a63f00951548fef20c594a52edbf72e6651ccabb5be2e5d57c8dc17f7863e431n
}, {
  a: 0x68538909dn,
  b: 0x5676f9b1d598911a58db7b8c0d82ae85119a77f082e3d53763729ed4e0a53n,
  r: 0x233c8c4c2f7dd8d9653422b9f0ed17cdd842fcb3ff126d7092d20f17d11c93cfd304e7n
}, {
  a: -0x57af7c70an,
  b: 0xf24cf28424f306cc0d8b9c3bb8b9688e91e771ec70b217ffeb9bfc9068438n,
  r: -0x52fe3ecc8f760cb976cd689d2dd2d286e0421353468e9521b8fdd78d4ffc262d10b230n
}, {
  a: -0x96f37757e9ee6010b284a4b25e5a98524n,
  b: 0xb7b073e1acda58459e51fed0e0f350919517fn,
  r: -0x6c501606552ef0781acad961fd241e155cb43c6c93b3b6498e325f41465527d6bd70dcn
}, {
  a: -0xd60756c43dfe07c9ebac5aec0af69f20be0b7824c8f421c00fe04d08fab89n,
  b: -0xbf37d936an,
  r: 0x9fde2ae9f247158f6225cc18a79d579e8195d88e87df02d1ddcf43bac4869da7e1b1ban
}, {
  a: 0xd26466b2d113e1ac4b7536afc9f9f1bc0e2b06796b73f0en,
  b: -0x931131f205e240b4c0c2bc9n,
  r: -0x78ddc8af9f5583c82d64d989ed1c5f3e53764eb32aefc72896feb1b1190c8f3a1fdbfen
}, {
  a: -0x2caef17b7870928d2954bc8dc7ac954f00ce3an,
  b: 0x95241e95143ed281ce52e7eba3527c16n,
  r: -0x1a08207d581e1c155b2c263a456532d6b71f9b99e6ad200c4fc4813a499de82a89d0fcn
}, {
  a: -0xf54aceea220343930af1a82n,
  b: 0xc204675933ea5e9fbece0b57bed8a815396e5dd219ebe1fn,
  r: -0xb9e6e8ff3b6f9c9beef720b1db68b8679347c419c0739807783d747b478fc5f91cb1ben
}, {
  a: 0x29befd39635e7e51b5d85be2405f5d59e1n,
  b: -0xf254fa1ec0dbe1c6c5b5629fbfad3dc94e28n,
  r: -0x278466d4dde2bf4d8e48834a3d6d4cb5b92ab74cfeed89338a8682d572b1e086a19928n
}, {
  a: -0xd201967d7cd7c91ac9de84db2ba8a7f8ef417c606d7257b41n,
  b: -0xccd39fd4c573066dc6c50n,
  r: 0xa806de5890abff5cc53fde809051ab68b47ca63179497b64b445ca1ec8cb68dd91f050n
}, {
  a: 0xe8cbb72d17796d7db1c06443f376fd7f2c1db35d803637f1de52fan,
  b: 0x13453a201149d9c5n,
  r: 0x1186125c0895231856824ac6700ca5752071ada379b49c23d23751549be43ad7b5c462n
}, {
  a: 0x838038b1e31d259d6b87ee226956183a901713bde4b2c91057f68a09c08f6ee301ddban,
  b: 0n,
  r: 0n
}, {
  a: -0x7n,
  b: 0x2799e1ec77e16c18fb90ba49cb7db7c68d5f385d840e2a41adb488cb47e60ae1d2bf9n,
  r: -0x115352d774729f4aee0f518049070066ddd9a8a8e9c6327cbbfefbd8ef74a4c2cc33cfn
}, {
  a: 0x5763916efa3b3433ben,
  b: 0x4c35a371fb341b2c964f903551b576a9cc30eaf543e335eaae20n,
  r: 0x1a03de955c90a629642366a891a8ea70fd0667558974fd20c5f0c4e4427b6c835d9bc0n
}, {
  a: 0xcd7c56470037f6a8e707886a6bd488e2c818360c59d1410f41a429n,
  b: -0x1f4efe6a54e1b46dn,
  r: -0x1921768b99e0faf3446c3b7b3d77f9202c300232e901e321416e411a1c70f66268b975n
}, {
  a: -0xe222b9ea2363644a2accbbcean,
  b: -0x623b39cabc18aa2bc86d9b6bbea4fc9d8efffaac8c8f8n,
  r: 0x56c59c394b755308ab82db3fd5bc3bfe98241172581f4e0a75fc4603c7824b8bc5d2b0n
}, {
  a: -0x3773051686447e431c1facaeb4cacc48883d4b941e1bn,
  b: 0xc8c79e70881d630cfb7a40489cn,
  r: -0x2b7d18b3ea597acb6dbe10ca4ddb870b3fee4a5dc9f5240da71bc4e6ef86751b79f074n
}, {
  a: -0x7d5a1da0ec23917a8e699516a0fc58add0d82a88b20bfc6e5fd8cn,
  b: 0x54480abd77a7d4afdn,
  r: -0x2944d8536e055078b3df341e1ec2da28d31faffe805410ae6bd162cce8fabb91f20b5cn
}, {
  a: -0x400b1e80d07b2f25d3bea96f967d26d284acn,
  b: 0x93424f582b84436ead0e910efa6dc583a9n,
  r: -0x24d6f93b520bad2c84ba1ea7a1d14d75d40779f241ed425bb01e9606c5ddf1af39998cn
}, {
  a: -0x8686dd0adb616088a3bf72cn,
  b: -0x1f7b1617de0204f6be9c68ca887ec2bc94739110ecda5edn,
  r: 0x108b032ca68f00a6eb114bde19d70cee808fc8b544642d0e1a179aeb641675f60f2fbcn
}, {
  a: -0x960c5d6e371db0e0357e55278d0a4cf7870497n,
  b: -0xd901e6b03f835ebbb5f938e371ee3fd7n,
  r: 0x7f31987533d1ae2ece8161c6cdf303169c3c53c981dafdc269122fb9666a0007e803d1n
}, {
  a: -0xb9bf878d5ddaa94a285dc6c4bccb648a284ccd88d6886199n,
  b: -0xebc88a3984a878ae1b65b2n,
  r: 0xab14535ba6916e730eb303e09c6a9181fa0151b9d04a338c792338759b603942783962n
}, {
  a: 0xb1d907557b9475dd17b354fe2af8ba1c3094faa783f046b5dba90ec29n,
  b: 0xbc28c425de7a1n,
  r: 0x82b7b39064a6d8a07f02b038d68be1d28c39893bf3b3a818a981a3c9ca753f772284c9n
}, {
  a: 0xfb23cbe1d6e182b47500c1d136561c180881448f44n,
  b: 0xefe3c54bf0b1c446d4828981f0f5n,
  r: 0xeb55dda2ac5f8bf371daf62a30f73bcadefcf6b18f87fef5307a9110eede139230dc14n
}, {
  a: -0x4786ab98056f5138ee016faa69ce6ec5d9d7228bn,
  b: -0xadaf797e4543dd0f8439009fb9d9a3n,
  r: 0x308708f6f75582a2c327a3388e643beb4a9b59bb99d0610f1b68a024fa3b8d5bb5d181n
}, {
  a: 0x8c15fd763539an,
  b: 0x1faa3a8c577f2f79875e2b3a35af371d68d5076623aca3feb2b7d873en,
  r: 0x1153d0556845c95edd7f1dff100444ec0b112da8301784aabd08072a56deb43b56754cn
}, {
  a: -0x696acb7de34adda3b20d9b05693151d748cden,
  b: -0xad0c153453d4f0669d5dc324e4edd3e81n,
  r: 0x47422540eb6837ea0774b14f3e24de588d73996379c9c6c2c7168fbd4172f3517ebfden
}, {
  a: -0xb3ec2d956b9829c3cd6b57141399f23f236e5d5e0eb111254n,
  b: -0x7967e4b29c76a5fbfde7en,
  r: 0x5553a64dd7c14afb13b481798c1e887f58bf058bde217bcf5645f98467eade58f7dd58n
}, {
  a: 0x49b5c8393e8592n,
  b: -0xb55734b064f199069f7cbda3f99673f4fcbcdc7338c748ee59e1bf64n,
  r: -0x3436a2833b5e8a1422a5227eb2608ba2562a62fbec8dd65c02d6d90e7baf0b29661b08n
}, {
  a: 0x1a1588aca5385ca21c0b6f4c5f688957a38f3ba86fca84967df072ce0374c697n,
  b: 0xe664bbn,
  r: 0x17799c423ab749ee002fa4f271d9f9ebbf81980642cfa7e3eec927109370c08f8a0c4dn
}, {
  a: 0xdb71ac9ad9dfb936e99db28771fc229a4ada37n,
  b: 0xd65feb6f5ff2a9104ed1936f936a1059n,
  r: 0xb7c33f4951930d6d208a8387513bfd5c16deb30189c6c6d1f66e2545f8e2d1416f4d1fn
}, {
  a: 0x7790ee20c141061dee99d69f9c9n,
  b: 0xc926305cedfaa8f97906ffe107bee52cafb34ea1516n,
  r: 0x5df2a111a47ab45e8cf5d2259fd5af87b757756a55e77c0f11f4cf7b983dab5e52f446n
}, {
  a: 0xa09342c82b2e37658ae8fbefa748a8743874a9ddc30d663bc8a3ba70d6n,
  b: 0x8bf1beac4410n,
  r: 0x57c7977de7155410f129d50cfb34a3856951af553d64224c38c597705fd4806567e560n
}, {
  a: 0xa6496a8549a2d41186216419fb5cd0cfadda7an,
  b: 0xb49d297489cd977e238c14bcf119eecbn,
  r: 0x7551b4d9805b185bb0ffd16235af0f0ec98f8dd4c9e7601f3406052ff9a6e77fe3aaben
}, {
  a: -0xa0c6c51n,
  b: 0x712aed2b46f3d2637209ae8542557ec88f7233e77be6e60467f49742a407157n,
  r: -0x4712b28b97026460f053ed88d86e31bd58ae95b0ab8e852915d109fc5bbf0744489087n
}, {
  a: 0xb1d890533716a1a2265c80d12740a33ea29b95d55303c045d492n,
  b: -0xaef58f19c1eed5f43cn,
  r: -0x798bc9c48c93df32b1d3c738367896a1b758010d60ed1e56eb0f3a3df471ef3872fa38n
}, {
  a: 0xcac5f83660eab31cd9e2c35ccb66b44fd78f3dcf75c9b693eaec1d1n,
  b: 0xb8a60ef54b4ae9dn,
  r: 0x9241d29f27986469159934b1e2f4f5a9aa53bc8b93714e979fea0bf77d94be13dceb2dn
}, {
  a: 0xdadd0fdc836200a9941777fec2e0002e6b6fb5f4f9714f5dfa87985a40d9f6n,
  b: -0x92f00b4an,
  r: -0x7d9f4bf1653e1fa485cbb2d19aeb141e998c7a8927089905fa262ef08c570582bc931cn
}, {
  a: 0xfe6d3925ec1ee979bdca11f060b3a46c9163e25832de2ff27fa4b6ea22be1bbn,
  b: 0x1843694n,
  r: 0x181d3c8beace894e3a24ead88eda3a3011650d22d2a8e78f21a54c3c4abcad2267f21cn
}, {
  a: 0xcf46a8b245b57d172fc4n,
  b: 0x692ae735d3ecab2ca989dfe5ba8401346a1a2e976649f532c4n,
  r: 0x5526b7fd234786ab0abe4022e8ab19740e6e45f0e81f55c25d06ce7318c949e7a8da10n
}, {
  a: -0x1324b31d031817f62f08730a6c218db3bfa2fef5n,
  b: 0xb759bdc3975a75858a5a71f49f6635n,
  r: -0xdb5f1fcbace903a4c8c8e7cdce06b307b12eb0b7f08acadd87e26b45a01f47c7f66b9n
}, {
  a: -0x7e6a0cc90ed0a32cb22dba06acd3983cd8696b3e4ebc981b2f5c33fb2c4dn,
  b: 0x48677ad0c5n,
  r: -0x23c0ece95299741868c6fb83ae368fe3c2d03d4c9182ac55a491a86ce5a65e2bf9a741n
}, {
  a: 0xb43783f4f0ccc8fc785a095fb0472c356d862b5d778b599a0c69n,
  b: 0xf1542c3a27a1b861adn,
  r: 0xa9e384935e38191a587a62b8b840d3fd60945290a636dea00237636b4b8ca4e0462bf5n
}, {
  a: 0xa1a933988553b543cc098ce88ef2d24166c1142974c5b928fn,
  b: 0xfc8e9024f2100899c9bb0n,
  r: 0x9f7c95ab43857a16ece235524f384bef3957e9f18f774756795e6671445b7bc6d55750n
}, {
  a: 0x8505d1d24b2ca1465ad171ee7391fn,
  b: 0xf840ec682047456c38f3199758522310cac27c959n,
  r: 0x80ff5f8fa5f6e50a70b233461ab9d81ed984162f19a996f065a59b396d005bd1f532c7n
}, {
  a: 0x5be8435f9eb499808e6c4843cb220946e5a54ad5194abd8a5feed860f332e0f9dca8bn,
  b: 0x8n,
  r: 0x2df421afcf5a4cc047362421e59104a372d2a56a8ca55ec52ff76c307999707cee5458n
}, {
  a: -0x4bd3b016db82531ebd913be9fcb50e8e118845b61bcf02bed2399d4n,
  b: -0x4e4d9fec0674442n,
  r: 0x17317db1512fa928b482972eb73797f6fd0ad7d7dc74810d6bb65fbd90075a7c55f8a8n
}, {
  a: -0xad20718c327cb20c560c0bf3c6ab410b8081134bf00751a0ccfe4d307n,
  b: -0x6cf74bc99d595n,
  r: 0x49b0ed758db7d74fc27559e1e5ade4b0312727de8ca9814ed0ecefd9a56555a6f2a613n
}, {
  a: 0x6765c48908d3901d4d0c6ef594d5cn,
  b: -0x29817068f39da0fcaccc5b4f4d281bf6d1de77fa5n,
  r: -0x10c39428e5306435b953709ffc2d54714f4bca2c4fbaea1625aac2ab75ec79cbf3804cn
}, {
  a: 0xb077157387e1283e9b9e45bn,
  b: -0x49587fad06fabe7f88af8b69a23ca576769b5eac26a3b88n,
  r: -0x328ef60faa635b77293e82ac9fdeb5b12752d405570b191e4680770badf52586104958n
}, {
  a: -0x8266e278f366b3de9n,
  b: 0xb2a02b01fb129413b336701c01d86a3b49f9f308be962f3c2ddd2n,
  r: -0x5afd1fadef2b135265d84c7d7c6c9fb929bb1fcee3d0e35ab50ecb479be2b04dfcee22n
}, {
  a: -0x2d2b59e5b0069a48803692722f3700e8151a6ca43n,
  b: 0xecf1ab959e42f83ab426887432cd6n,
  r: -0x29ce9af5bab51e2b3be6d96d619cd1f66c41e70551981885a174d54fba1eab30b99802n
}, {
  a: -0x102ed7f2fc0c8540357bd863d3ccc3e28e209281b4a658ee374b3n,
  b: -0xed0918ee089fbaec4n,
  r: 0xefbf124fb398efd50d3b47353ef424196a86d0a2503639994c36747a535f735f8030cn
}, {
  a: -0x6980e289505b4e54d3beb6c987593d6f907bde916292afc2981fcf111640d1828195an,
  b: 0x8n,
  r: -0x34c07144a82da72a69df5b64c3ac9eb7c83def48b14957e14c0fe7888b2068c140cad0n
}, {
  a: 0x4219602d3192d2ed82a34c2d9669f7n,
  b: 0xf1ed7f66b6a69f8e75c49026c940b3916179d6fen,
  r: 0x3e7735edb17deb1f7ec5d5f56614adf7a8253c20263d3b7faaadef5370f7d6a4909d12n
}, {
  a: 0x2adc55cafe5ef5333ec0612ff789a07a1a7b4e819b3c3f68924339475d69cfc76216n,
  b: -0x62n,
  r: -0x106858d7b56059dd9e05a5345cc2af6ebe23340d9d6d104607fdbbed51c2818a538c6cn
}, {
  a: 0x609e7b14b3b8cb98c432f2c0b08ca276b665cd155b62en,
  b: 0x21d12ba527239da2c3e21ba6an,
  r: 0xcc35fb91aa8f08e6439fe013c91ac145ea8aec644c7be0d20cc240b9e0c9a93c8db0cn
}, {
  a: 0xf513738acn,
  b: -0x6e4218f74d4e851deccc29792c8e621b6ce58165de2fe991f6369aa33cd62n,
  r: -0x698da28ffae101fcf0f30e2fd9eb7be6637eb82776b7fcdcb8dbf1826ce614d1c96dd8n
}, {
  a: -0xed8845747e501698677cc25b08cefda5ca4aa760fee44n,
  b: 0x6efff53cff1231ab9428d3f13n,
  r: -0x66fe0c2140649e867378dac5c5a0314acf61f14e9128365a2dcba92cbb650c72456b0cn
}, {
  a: -0x9cbf40268c2e02aaf0b48664ab71a26766d0ebe842aaf484fbcfad68n,
  b: -0x2de22330fa78b2n,
  r: 0x1c1814a98ba9cec3abc78b98544745690eed696c0bfc025dc727877653b90b473f5250n
}, {
  a: -0xfda526eb910aa6acff8ac0n,
  b: -0x98a76102056c7e135b7319cd45e9707d1a17f533e4a5f69an,
  r: 0x973fe5f5d633390f1a0de9e6415573fdef2c2fe722e6a35f08a35162f00f090ecdf780n
}, {
  a: -0x8752cb82ac65e93fef33b32d3d7e2536fb19a8b9c31cc96ed8be3a4c20c4151n,
  b: -0x78c4dden,
  r: 0x3fd6e011f2fda487609ba90352610bb1f84d4d9d1ecae070c18c0f12306bbae592013en
}, {
  a: -0x52f6f9ad8001159ccb7c6396590e47fn,
  b: -0x54e08ca5abd6fdfd07445751c1d0250c9d74471n,
  r: 0x1b81cf9c273ad06a253563e6853a2b73f620eeacf1301bc7bc242c5e2c3417ef4f980fn
}, {
  a: -0xcd6e57609a4da1ba619649f6a3cd9n,
  b: 0x434a90f2e93cab7a5c5e1d2020255b4f3a36c53f3n,
  r: -0x35ffb71488edf8e05bed6eabbac73945c2d909c3f5938cb3dcb748cb86f5bd9a1e1cfbn
}, {
  a: -0x207a31bde4023d742e15eb650485a15f260n,
  b: -0x3dff201cc745fec89cce0f1014a291377b6n,
  r: 0x7dd7ba4b857b211d2c470e57f4cb5ab87694df2fc11e22cab8e24ed6558829c64f040n
}, {
  a: -0xe23bc5e35fc3d8a621n,
  b: -0x5f29de9f433588e46339aa105f4c529655c7a85e3943d0e891c9n,
  r: 0x54192ebea6140d2bb98e1a8d509316d90a1d62b2b0ad89be1acd7508e11b12d91b20e9n
}, {
  a: 0x1e03dcec9n,
  b: 0x889b5363c454b4c0894939dc1a1c8fb36f43836369d0e975cb7685f00e916n,
  r: 0x1004437b62df35c69633edc94317551122a6f50db64d414b8af73cd96255a61d84b646n
}, {
  a: -0x2302be4693df645f33232d3d21527566e2302f6fb300ed1e180cb0b42549an,
  b: -0xf22bf595an,
  r: 0x211e9aeac43804ecd2d4fdc1507f5d937e46dfa99fc9914729226ce6ed090b97a14824n
}, {
  a: 0x74afd2187c2db62dc7ca6c8bab8ea192d8ed97d15c39180960e60ae4f4n,
  b: 0x5e2d31351c20n,
  r: 0x2aed287ac8559cb93b6272cc40cdd953fc24f9ef34fec82990e80bb11b523e0ceb4e80n
}, {
  a: -0x9e0867c226ab5adn,
  b: 0x8148b5c691640f246f269f6e10d4abc8047315f4beb725c04699e11n,
  r: -0x4fcf1edc89b445dbe5dbea7883b2f9fddbb9dd6a4adb0d7022949bac6ca8435d2bd67dn
}, {
  a: 0xf6819n,
  b: -0x68d639293ef1edb965864698d1dbc88ccad2aae86fc40a92cca07942ebd78b07an,
  r: -0x64f2e9d8f06c65c107b3799bf460e882faa7d679faa972d0aa8de47dad8f9bdfa0cbean
}, {
  a: -0x41cef5007en,
  b: -0xde5e72e07c7a5eb50bb5977ac6ee3d8ad984212b6cc4baa8a0abbe67dcb7n,
  r: 0x3929bffc41a2902fc7900667f70a724635c4b934825d111eaaa91b2ef2ec003441a212n
}, {
  a: 0xd57dea3db89e0e4f62fd8f9ecb5cd23a6295e95c2bn,
  b: 0x209c9daa8f9e2db749c2d26b2855n,
  r: 0x1b32597eeabae8ff35671cb44e454662c61a95f0d4902da17e31cd88f7fbe308db5247n
}, {
  a: -0x91f933e77ff401n,
  b: 0xa65565e30182ed5920dcfb7cf49b88f137571c2e689eb378c1aafd42n,
  r: -0x5ed8497f1b25b182d93e55e603c522d815059482c88339f53459da031ed08feccbe542n
}, {
  a: 0xf95a95a4e968a1f6643a3249b61b7n,
  b: -0x5cc01a7372f7518d90f88e7cc8dec56077facf758n,
  r: -0x5a57ab7b266fddf0dec4520f50cdfcee6cd1c9fe88f11cf7edd2afe9f67c46f0a527e8n
}, {
  a: 0xa6d73289a04c9cf440fff178429a848f5de79bb3cc6417a86a792b781155ea4ce366f2n,
  b: 0n,
  r: 0n
}, {
  a: 0x1219c6f07320ef5bdbbd514400e1f002025bf2ae6a48043e507617bn,
  b: -0xe1ee27c71ff7bean,
  r: -0xff97ea04a55e4e2484b9acd7103a4fe7e7e5ae9ce933a904a03c731c30f0f491a336en
}, {
  a: -0x611fa80f08ac06bdc47acdfb463c9n,
  b: -0xc48f469989bc1ef818757496eda5ad73d5ab5e690n,
  r: 0x4a9298234b2a6a8b9369386b5658bb86ec5e265fc240ccf92a58ea14a0cdbe1e3bb710n
}, {
  a: -0x3b32b33817e34fdd9aa568d901c7ed3d7821597c1f5e6d6b8877b5d59696c92dbn,
  b: 0xdce9dn,
  r: -0x3315a3428432a9eed27bf44d503ac04a30f0f0dc35a28c76b90d7419508d2e7ae14a4fn
}, {
  a: 0xa85621fd61daa6b9c2c8n,
  b: -0xc1949190ecfd0cb8131196d42d1d3be3aa7b133e81b8e13193n,
  r: -0x7f4aa123c2cbd9e09453ee5b7f9e1e7a5484e029479f18c79cb8bdbadbae833cbb20d8n
}, {
  a: 0xf1af9c85422852e3a3af87d6f5b19f4d9fd557c1493db70dd88504c2ff163ce33bn,
  b: -0x4b00n,
  r: -0x46ce72db0a61d048b0f46ccbf9fb09abbdd380b5a07514a10e6ef86520bb83d6924900n
}, {
  a: -0x3n,
  b: -0xbe491a38203bf1aaf0870ab50bbc81d9f15fc339b8891390be9c6d1cf8aaa8cf4f7f7n,
  r: 0x23adb4ea860b3d500d195201f2335858dd41f49ad299b3ab23bd54756e9fffa6dee7e5n
}, {
  a: 0xf109ca8fe24ab6b74793c219ce26a451n,
  b: -0x70f3fc9fecb20bd2a51da62962d0d89a83569fn,
  r: -0x6a5a02c670eb99a7f56947ba493235133982d31521c53eb0c8232827506a3ed4a6444fn
}, {
  a: 0x9a2f5af3984ff615e165bc35n,
  b: -0x7fd719efe025aee562bef70bae43c39f7e724e441cf81cn,
  r: -0x4cff0b83543c6b4b2b02b35082e413a5911bb3df73840ba1dfe8af614cbc03df3fedccn
}, {
  a: -0x57ee6fce12a453406a3n,
  b: -0x70a5d87a8d851304c5237e81a477a0d67dd788753a39efd9a18n,
  r: 0x26b147f37e8d19424b98602612c34b142134c2a1d7185a12e479593ae11ce3f1f5ad48n
}, {
  a: 0xd8c618082b501833184n,
  b: 0x9915823ce15dac14756efac4474be978bc01808ea32637adb36n,
  r: 0x81a09ae50005a0bdacd7dd16cb3417f5dc537202732698e5b83f49edc732ed31f05dd8n
}, {
  a: 0x52dfe90e8193n,
  b: -0x5598b57d296a17913dc99768f4a24eee4f989d25bb056050d11571f4b9n,
  r: -0x1bb5c815062700a5294d1e141726f51e0657b2baa4192da3283bec85a316fc7fdebf3bn
}, {
  a: -0xc9a4e764aa016fba713b4b4a43af3205ef216d1119ca1ab29ba747f5be0e6a35dec887n,
  b: 0n,
  r: 0n
}, {
  a: -0x87402239be3b935afn,
  b: 0x1bcd62a41e9574efc36fc5062de52a7e4559c4ff215c7aa0be85fn,
  r: -0xeb04614c1a6202eaf3f1f273578e94d86f22b3e2f17c0f932ca2800ca59dddee683f1n
}, {
  a: -0xad5b08ce676a6de5cd06b093060c8b5fd255n,
  b: 0xa81393c066116097f2b46b121a6ec414a5n,
  r: -0x71d0ff96aaa2af2b7ecb15ac9619479d668186a6c59fdb0b3e1fa2e2c61958e04534c9n
}, {
  a: 0xa82f3681807e5f4d1414n,
  b: -0x6e6860c20484e28bbbee018a9a26e3640f47bdedf641b36360n,
  r: -0x4888dc2af50268a43571e02fe728107cd10310e68f593a7c5c8344c23c1274a9a74380n
}, {
  a: -0x19d77a0ee77caf8215ccd9bfd7861de31n,
  b: 0xb9d9851f14aba5502198fa26c31b434dfc32en,
  r: -0x12c2ac4b518302bf40bdafdc1c8bfa751335f8a4a62e76acad6b00c8077414ae843fcen
}, {
  a: -0xc415c1709a11d8a63265dda4528n,
  b: 0xe5c9da6c2a51f59d5d5408641b76b1d6b2cd6a823d0n,
  r: -0xb002126bfb8cc6440073f5d0242b9ed606bd94e6dee718dec973b0f99475edeb0ca880n
}, {
  a: 0xa3a8f467f98950b3a2c552771355da2956b112450n,
  b: 0x7cf19341631fad2ad52531f639a38n,
  r: 0x4fe04694445cc6ba8e657d058150f99423bc22431e1e9dd46678005649540e76881180n
}, {
  a: -0x94587babd61c8c859119f924e1aec06ed70ee203bd244f25ba99b9e7b32n,
  b: -0xa334c5c816dn,
  r: 0x5e92eb5391bfa7ce14f9ff31173243050d6a2d8aa24800c1c40a72f7eaf71f3c86a64an
}, {
  a: 0xe42fc8150bf2c3a27a44b640b87f9a2bf1e0bn,
  b: 0xf16c088e7eb6e5ffac0b19859c9997855n,
  r: 0xd7314724bad4c417f230f7456630adeb528128160d8a0101b38369f86e76cf371d21a7n
}, {
  a: -0xba954n,
  b: -0x4b81b52d10ed520b7cf1b85da550bfe594d03be60f0a3fbeeef502c3d71a116cen,
  r: 0x370843019ed28bf86dfa37e0c6b54cc0aeb84dec12cdb70a63aed45a26f6189bc37998n
}, {
  a: -0xeccffb65066c85134d48916n,
  b: 0xd0a04b83011965a8acacb1a03cc613f5c09185e575bdbd3n,
  r: -0xc0fd44195274bbdbf7ab63e593d878163a8f926bc6c0c5d6fcb6950c90fb579144cf22n
}, {
  a: -0xf6n,
  b: -0xc4641c26386e5c037cbac5b743b0b497780aa38cfc0dc2a9a4fb4d461fd7cbae01c8n,
  r: 0xbcb8330cba3a0c6b59db79fe1b0bcd898d5a39297a35390f04897c4162995db935b630n
}, {
  a: 0xce99ef5c3d8121ce8c350ba32a9n,
  b: 0x5b20eb04f8bef3836a9f3f2053506def2c8c7972564n,
  r: 0x498b48ff07453bb654c68e8966786257e9ebadcf8e6891a804868e59cdd833b2bd3704n
}, {
  a: -0xaa7c719a6743df48dc1n,
  b: 0x3a01560eb9322cafca5c4750d4bb8c9199ae8f1a971d6b6ea06n,
  r: -0x26a11589094d35260e013bbdeef2a5d0e129bdbef868d8e5bbe24dc4669ce81a83bc86n
}, {
  a: 0x223435efbd8f572ef5f0d9599c042e228c0ec235f61fbd18ba489ee1n,
  b: -0x630645e2da5a5fn,
  r: -0xd3b076b5bbaa4caacf9336c9df04b20661db15a3b5aaa64893ca1b413b46996680f7fn
}, {
  a: 0x19f2f5a71aeec151f0de1e0ce65836d34596ab1cc75n,
  b: 0xb0819f74e339adb605c04c1c51dn,
  r: 0x11e42c7a6b6b1931c08d15a1cf080b6e65a130681dc445a7093e5518644e84e0af3241n
}, {
  a: -0x9d037dd2bb0f2bc42cc120c080c5cf0723f9a54cdcc96502d6f118n,
  b: 0x342af6a97d0bdf0an,
  r: -0x1fff0f6ac17a51a1927ae70ccbb4bb44e43a3b19190bdd84eefee2274b27386c7152f0n
}, {
  a: -0x8a64ac6ed28b8a6888bf02n,
  b: -0x4c4d6da015a1dfd356705b0884a6db43e8825482dd36fd1fn,
  r: 0x293fbebc2bdf7a6e260feda52a22f124fe623a28f245cfd081b9ee2df86fd2d1c01b3en
}, {
  a: 0xab2574b169d322d1abdd51d3252123b3n,
  b: 0x23ecfd724347f99e8a41745468191ba81064afn,
  r: 0x18048eec3d01a4ccc52b8eb86f4f409e009e11ecbe5b6ccfb0852d0184ba3806c9535dn
}, {
  a: -0x546c2e9b4a8cca9a24896f44777158cfn,
  b: -0xb9f2aea4a484682d7511cbafd589632aa28446n,
  r: 0x3d52358a1ae897a6d267a488d55d5f0c242bf26951628ac1323fc5be7707a843c7049an
}, {
  a: -0x9e3b0e35d27a7c750e415c42649138cc98c55caf554023cn,
  b: -0x789571ab8a5fa3b4e5e9ce0n,
  r: 0x4a880d4a983c1e3faaad78f60f5b8c7074c21020cbef2413a0c1e05b8f8870f4e68480n
}, {
  a: -0x7a7a3985ce1n,
  b: -0x7b5404e12397341991ac32eca8a1b6310fc916c675c85adef019283e515n,
  r: 0x3b00ec13c942fff4a479246ce7c4402170f8996746056f03792bd8184a9de88fb7e375n
}, {
  a: -0xec7b3de7a5a576a43b52dfcd7f038d59648n,
  b: -0xbdf2ff4f95e36ffbba2f3fd5ade6f434386n,
  r: 0xaf77750cd16d6b3f06c4faa277a9985d04544542eb81e4e9e3d7452896051d32f981b0n
}, {
  a: 0x23dd0804n,
  b: 0xdda59785fc5bfe8cd8eff1fef1e2b38b80036b6331fcf5d91ca3408af72a43n,
  r: 0x1f0d029bc37dfd32d2a47634a7788ecbef1524d05fe084199afaab0b4453808a05c10cn
}, {
  a: 0x7886be9dbeb4308f5f8a5001e2228a7182d96n,
  b: 0xcb66353b8c58002c71739ad68212dc363n,
  r: 0x5fc2f7e6f7aa93c8028e618d3598e4a61ee10be5a8fed0c614141d17628d106270e302n
}, {
  a: 0xbn,
  b: 0xc78b4a7ffa9b3ef1dfe6764b7e16e29ccb5dcc28266e06d5022215d6c442cab584b2fn,
  r: 0x892fc337fc4abb4649ee7153e6afbbcbcbd07c5b9a6ba4b271776f03a6edeb5ccb3b05n
}, {
  a: -0x428d04423e7278d381823b6508443966a70f1d35f9aa614672d21n,
  b: -0xe49db848b266cd44fn,
  r: 0x3b6e982edd57d5d6ea2b458dffab16abe0c25876a09a59f1f66d97972fb34aad22412fn
}, {
  a: 0xde1c5591df349fcc6e9f10cc6698950c1ccc0bn,
  b: 0x21e168d9ea2e9e39e1021ce6731385ebn,
  r: 0x1d6538e796f119c3cc0a43762cb2a40ce0adcf8a559996ba400403823adbcb2a420519n
}, {
  a: 0xdc63180cbf1fe8856n,
  b: -0x149392126b2e6242625739e27f214ad0af3f4c490a79166ddbac3n,
  r: -0x11b6c8882d348cd54e875336df1b4fe961cf84b055287461537073063feef03a2e5582n
}, {
  a: -0x8d5ac0641504aad43ff9bn,
  b: -0xb70c5008a8b2e7a343fd918529b6a7c659be8265465dfd2f6n,
  r: 0x6512abf9b3d2f34a56856693330c282ce240215dee8b27fbd533c46dc20cd41609c4f2n
}, {
  a: 0xb07909e9f74bef9n,
  b: 0x4ac0790186dd1ea5dce69368d22654e0992aa5b25399d49ad4757ean,
  r: 0x3387ab0f5415d4ceb367012c34c8ce91fd1f312862c9ccd10151bf88aa619ea9ac2e9an
}, {
  a: -0xc325457914fde8432833038383900c1c78n,
  b: -0x82a328923579d35246be9e934e02baeb833bn,
  r: 0x63954cefffa16d08f9f97e91905ed94c11cb36a10eb7e8a89eaca7183672c5b783f7a8n
}, {
  a: -0x71e37a77a31c4993d6984c7e82fb1f9cn,
  b: 0xb5b183e05802607e32c4b395e7f935b7a045e5n,
  r: -0x50d4ce8978e868881fd22918339aefcbdd40ec47dddf6339856f9ef30e2e511fa8528cn
}, {
  a: 0x9cd6022c791d1b572cfc1b967db4a508249an,
  b: 0x19032d03a66aa5db0ca2e71480676e7539n,
  r: 0xf52d84c393136743dbb2b9035cc3f43ef67bc5ef21cff0bda21ed3fdf11df27b6884an
}, {
  a: 0x8adf490b84b3517n,
  b: 0xb10386a55c1dfa472c2c34ed6710f05bc44a681c25078ad4e40363dn,
  r: 0x60064b296601269adbbb74321132943ad53eaa1b5833a1242a8a5ad04472e10ede807bn
}, {
  a: 0x18d005dee8037f9e9296b6ec65a745747d32bbdcff298fbc9b8b5693ae9142ee5n,
  b: 0xac944n,
  r: 0x10ba22692a3835c53211a6ae42b240c83cd396d9c62ab064357ab19c1c4f70972041d4n
}, {
  a: 0xa288b7efd2e1ccd44339cecc0f9218c1f89d5f9debf8a5ffca86b1f39698152n,
  b: 0x298720fn,
  r: 0x1a5db077df68ca12effe4500fc25fd42fb2ac43a768fa441cf2ef8a68f180cc57517cen
}, {
  a: 0x45848a0c61081d756272b6ee57c234272206216n,
  b: 0x47612171885cfa87c8c184481765854n,
  r: 0x13622296a7ee353816616b405d59408ae47632a8243108cc6d8e445ad1733ae07bbf38n
}, {
  a: -0x5ffb3c2fd8f77346d4722fee868877506c9937c374aa5n,
  b: -0x3df58782a492fb2746d79df0an,
  r: 0x173aeb9678837500e6fc4c5d85c162e558899248b19da1fc7f54f90ab426a58d2ba572n
}, {
  a: -0x32cb20710n,
  b: -0x52ceaeb20aa76f53ab08333181d568a1b43cee0d558d36a4ce918605faccan,
  r: 0x106e1281b054846f4092d2cfc8a26bbe89b538b78bef2a3aef31f223d0b6bf802852a0n
}, {
  a: 0x937585e5c6c8cc175691959c11e189414142416e8886ecd6c0e87877ef9n,
  b: -0x3ad0e37c52dn,
  r: -0x21e0f2dbac161053d72cb3c53dba7401804a2657fcc672ad6d18b2bdd96d2bfd05eec5n
}, {
  a: 0x3d38fb66a2047e5a0f0b20759c28d4a19e62086cccc9n,
  b: -0xd7390d8288d395008385faf664n,
  r: -0x3378800e4858989e4ad34aa181cdc8880ece438015cf50140c5673231a9de340932484n
}, {
  a: -0x5578651c4da36e543564fbe0de0ffn,
  b: -0xa3d98598a0a6675c572d667711d191a7dca57bdc1n,
  r: 0x36b448093c1369b1aaaa19c9cb7a74ce22ffee4b4854d9cfd96046e1153e32343be33fn
}, {
  a: -0xe157c3726c78n,
  b: 0xce727f306a9bc5d7b4b6cd0b45a633e46fa8378c9381b1569e8e37c88cn,
  r: -0xb5b96850447ebbeafee02d880bfc785ae4f9ab90fbd33d2f37c0b050d38480251911a0n
}, {
  a: -0x54cb3ea8b478a96d9a8039f70n,
  b: -0x79d8e8bf718cc893a9ef24bb9fa7bc72b45ee6fb2ff7an,
  r: 0x285be93235ae498e2ff0d34ca93187aadbb020651253e3ee4745676ca680dc196a8b60n
}, {
  a: -0xb086767c1218e9e0eb457dc09a4f7e884acfad16510a908b429889513b3958d516787n,
  b: 0x4n,
  r: -0x2c219d9f04863a783ad15f702693dfa212b3eb459442a422d0a622544ece5635459e1cn
}, {
  a: 0xdc4acf54bcb0ad28927d9n,
  b: 0x43a1c2c7f686334b2db469b97cc477928cf0d537d5db3878bn,
  r: 0x3a32c6ec5515a8d2a1a3e784aa34b30eae0bdd2d954f1abf5015a8d12fcd3c563711d3n
}, {
  a: -0xf2ba95bfae0n,
  b: 0x75f5adfade9a2bf4a3d7bd28808adea02d52df9bc4bf653548e0bd4b9dan,
  r: -0x6fd837f7df70478d8689f452cf5c01f36dc6fccba2f2b372f80a03316954c5121f82c0n
}, {
  a: -0xeed0e2b75f9e5ea3n,
  b: 0x93a51b5db1ee39285a7164c48cd79a55d71f4eee0ec7af7a54e3b7n,
  r: -0x89bbf858dbe0ed63bfa76fbc60ca89c892e3444bd1fb69ddae4d00e7d4ea5c839c2f85n
}, {
  a: 0x53eb0582e35cab228b33215f625147a6b60e29b588ebcn,
  b: -0xebd4782a075a151ded21e0e28n,
  r: -0x4d4e6413a8a79095c6d9fdbf3e61c6aa3167fa75bfd3541d90e90baa41a4660fac9560n
}, {
  a: 0xd37b974b8f4584a19fae8479ad5ban,
  b: -0x34d8313d7a63e5e6f204c1f5d367395342043c854n,
  r: -0x2ba7b3b0725ef1d80a90898e361f403a783420b7777c09200ff21738b0902da5757108n
}, {
  a: -0x96486ad5aa7ee222b18432f0af4633d1bf05ed6b61182f4d78adca169797n,
  b: 0x2c4b72bef7n,
  r: -0x1a00bcf06039119f690c6f7862b6f44ecd929446cc9459389c222a86cb16177e8c54b1n
}, {
  a: -0xa07ffa5e3aa45591n,
  b: 0x68e2e40f41127017a37bed57449f6927fc28838d4b1c77f7e5d48fn,
  r: -0x41c23dacda4a2d6e94e3e79a7b4f31b2981c8f68f255e5776564ffadec89294a5cdfffn
}, {
  a: 0xe6eac4ca0e1cf9478b0f4c7d3757aa306b1b5221an,
  b: 0x6cbb592e63a60a81c4fdfe45322e5n,
  r: 0x621408f47408b35ad9f3f63e16f2754abba40db44236fd78313553aef263563bfcf542n
}, {
  a: -0x30560f3a93n,
  b: 0x15eab7b3db6138eb89bff8e8870d4fd277b2ddce71f991249975767ca650n,
  r: -0x42360993414dd6bf649cb47ec9d1df62d63cf35acfa23de9c8fe94dd7bb77e5f19ff0n
}, {
  a: 0x970381e1dce75a9n,
  b: 0xd376b7e8a020db753559fcfc78afe9d55091dc69d547b29629a2553n,
  r: 0x7cbdec27c2aa3ef48c429b917ef6dfff2c8e20ee5e306b04afa51fca128e60fa9b92cbn
}, {
  a: -0xed6d5c0f5e24124f89cabd382abab94ea19fbn,
  b: -0x3a8a519b8a231a42930a9c15ce60f19cbn,
  r: 0x364b0f7ef712079e067eb622e706d21c2c4b378d3685c9ce4b0457eaa480dcf9e11d09n
}, {
  a: -0xd68385bn,
  b: 0xa2ba38fb6438f1060f5befedefa4ceddb6293f73ed6555c7f2b5fea56695c7an,
  r: -0x885b45e7ee0daa84e34e90c1fff0f75892821a370b180a98e571308efccfb3873e8f5en
}, {
  a: -0x64706a5b05c5854042e80ef89c5caed3008ed3f4e669n,
  b: -0xdb5e58bdadc36a95c87080f650n,
  r: 0x56112f13fb168a05e5cdfc32e6bdd7f9b065d9fd2a1630863bc085ac87aa98b670e6d0n
}, {
  a: -0x237fa335329efn,
  b: -0xc1ef915fedf0516152680264089c0398ce3550c2b093fc7ce00de0656n,
  r: 0x1ae4725d12a144c60215a3d3ae5033ff5140317ca62473abf7583d445cb4b18e2db04an
}, {
  a: -0xcfa6334b5e0ac337n,
  b: -0x9a312e44e0940ba5b86c7a44d3a43cffaa4ac38ff5c1438415f583n,
  r: 0x7d11df32e38626d3873d446be6c5575d4e96f33fd5318e6b1e5d16a9703280cbd88825n
}, {
  a: 0xfb0222ba37330cc68abf4a127808n,
  b: 0x502052d47c0e06ccb8a190de496535eefe2ae9e7a1n,
  r: 0x4e905c558f0e0bde950307ee1722f3fee795c636ac8700a025453885e3d894cf34b508n
}, {
  a: -0x5d7b9b51daf4b874532427n,
  b: 0x8cae95c2439f50ebb854bd9ba1c932b56c15608fb745ef4cn,
  r: -0x335f59a4372486a5f1cdc0b5eb36bfc309d2346b85a851d946f2c91b8a7665c6f22494n
}, {
  a: -0x874b8ca57b1d4bb56450e323912cd4e17584e97302f4f68488a3856af80f5b3n,
  b: 0xc98c03bn,
  r: -0x6a8450b1bebff6accefd8b750eb52ad0c5e29f5c5254cb9fc71025e5ce3fb17146e041n
}, {
  a: -0x3a49de3989e0ce74f27a432ad3b1f98141dc756d67d7609cc90c4296n,
  b: -0xf6c24473ff576en,
  r: 0x382f371bba721bbb0fd68e6eb4a16fbeadbfcc7148a8fcf9587f0528b8eca9434f9674n
}, {
  a: 0xfbcn,
  b: 0x750cbca3050bc22d361ad36c03b075d6b1557fc75ea778d08f4bf191edbc55171f9n,
  r: 0x731b468150365033f5f4e16978a0c7e1e0e3d4684f55310f18eaeecf4189f4ad7d49dcn
}, {
  a: -0x3f537d8eafb67a7f33b999d46c497bbdn,
  b: 0x41cf577e257167f832ce103a69cc71a1a35156n,
  r: -0x10477d085503d250e0c6ba3785a4d798beb6b5bb76c3c7dfd41e0f91f047a8472d5e7en
}, {
  a: -0x27e8142ba533234d6f78aef72c035a0f6da28f57n,
  b: -0xc7148476eeee2b74b92f609adecfd9n,
  r: 0x1f089a75b5725905f90d6abd16656aa6289e1afadc274297a9cf245d24678d0424d9bfn
}, {
  a: 0xf009e9a0de71de83b0c68cb1d9334755ea6eaafbe845ba2bffeea61194fcd1df487an,
  b: -0x6an,
  r: -0x63641abc9c1b262287323641a3ef3b899311d2cc4e2cdf1637f8d0c347b0aee6740284n
}, {
  a: 0x11e16277f87e0dd626524dd339d68bae25731n,
  b: -0x1bec031d723f15c829ec698743359204dn,
  r: -0x1f341612078b501182bc00073c5d3b88fa395fec04346aeb7d93753121a1f940359bdn
}, {
  a: 0x3cdn,
  b: 0xcd69b35a73e5aeb24dd9ee2044b6b1877d5e3416cd204929e97cfe2b38ec21d1036n,
  r: 0x30cbabeaeca7ff8fbb1e54e10a52a60bff77f0bfaa9a3b6144c70120a47597c8769d3en
}, {
  a: 0x4cf66cn,
  b: 0x6c4ee34b220dc5bde46da9c949339201a288ffb71a95650a123b0b176b8830cdn,
  r: 0x208facfa0032824e33b62c272cc891c88b6b8c21e1b924c51bb74bb8851ba4b935947cn
}, {
  a: -0x362b574adc142e7e838660f19cfef1fb784fcf0cf6a286eb8b569708f8f1cn,
  b: -0xeb016cdd2n,
  r: 0x31ba16562254be242dc6e7083868100f13399678acbd589bd9e230f91671e2d7c4d0f8n
}, {
  a: -0xa6245bad474bf36adf6d9c02an,
  b: -0x371045a90dd431e1eb69d9b26d09d9d465ff250aebd0cn,
  r: 0x23bc5f2d78d58eca02d4b9b1d86b2672df09cc78cbf87bb100fa68a15a112811a003f8n
}, {
  a: -0x8e3966n,
  b: 0x7686712433a86e8b74cd167edcaa9fdb7624256eacc6ea8f8145e727562a049cn,
  r: -0x41d925ead6cb5a6713e254ae179c52954f16cbe22064e73d151dbc4a23a72a3e4c9228n
}, {
  a: 0x641f9ec3be3e180a2fd2105456960b20f75a18ff86850c8bd615a1ea44aecbn,
  b: 0xbccb1bd1n,
  r: 0x49d6a88bb87cb7c3686ce2ed14af13238c75decdea9abc847f0ca3cd7ef1b92f7b1cbbn
}, {
  a: 0x3fe33cad6d09e88026b91c69da7499597c43c1d813ef50b818a6f26e29ecn,
  b: -0xb4f6c9349cn,
  r: -0x2d295d3ccb0cb5d022613ff907d39734b49283992c56be63a15fd8d2b09db1cdf17bd0n
}, {
  a: 0xa16a0469f1822bf9f1e10c33ff47613298303dea830a6b88387d597d2aec4n,
  b: 0x9ef78fa1bn,
  r: 0x643b8693d063334e20e90a34885dcc8c2c6f1369ebb2f7ac4901c053caea99a9c3d6acn
}, {
  a: -0xc514ea14f0f7144n,
  b: 0x7c3e07c4a6ac71f7242d83e74619026d2cd0025aeb93b96370e9ca1n,
  r: -0x5fa5e26dcc8425d87ee671d88084cd2639baad40f494c156676b9634266da5ef73abc4n
}, {
  a: -0x48a32n,
  b: -0xa430795fa8aad3cb14b6352e08e7c786f586a6b3f94e0c8408abf86bc95e6cf3en,
  r: 0x2e9641863e84656b529ad18f95769ccef8ed124f978c2f60dc126472fc513eefc3e61cn
}, {
  a: 0x40d93009f568a3887bb108091840d1b414cn,
  b: 0x35ba58148cc1d2dcbeaaa12118eb142821cn,
  r: 0xd9c2b0ed42e0471f53a525b2b1b59a2df4aa91153dd7372c371760cdc766da7bbbc50n
}, {
  a: -0x433f63ce041d41a22e455e902en,
  b: -0x749a0c0d7e05bc90086e5ecf1b9ac6135d3863e07e76n,
  r: 0x1ea13085e7cc29e3494e1706b9efabfd568fcb20946c5a70f71ff865de0c0876cd1934n
}, {
  a: -0xac3d8c38df85n,
  b: -0x9488411c045f08bcb55a2e620b79f9f5ea5da969812e5995efb5756adbn,
  r: 0x63ef4191d9b6508a07bdf817d62e39fc81602736d1fc07319c411e229836e8b1fd48c7n
}, {
  a: 0x95530b5842ea40b20d8f4n,
  b: -0x7cb7495f2ba6693751c23f27b7d7cf6d4ac3cb07563b7c172n,
  r: -0x48bf22a80e04b1c0a1e1d0e012be0e33e4f515e69ffea2c6aa7036b7f301562a9c90a8n
}, {
  a: -0xe8a75d2a43c26db9916538f0906f9cc975n,
  b: 0x3a2cef7d52371f5a71df264349d271de526en,
  r: -0x34dec185bb085977859a2050f82eb11a7699526a93d2efe2a95ca075b93fad865c0a46n
}, {
  a: -0x7c59n,
  b: -0x65d9043019e2a980308d8fd481f982f8dd203cb2a79b4777b07b40e35a702d2d74n,
  r: 0x31788679c142c9e7051572e1efd60b2f13a07d9ba34b7b99d2180e47aed8c6e1b8fd54n
}, {
  a: 0x7e549394219n,
  b: -0x339752c90c8e6b7cc120460405f1ac9bbdbde6cfe3baed91dbf257d9909n,
  r: -0x19758623dcef0cde31c17409ae2d7b2c675a7118f6afbfca5de4be26a87cfcaeb943e1n
}, {
  a: -0x14e0ba0d77f39096a691969ee801e06d3cb2n,
  b: 0x48f8d4c2e6b4044a505b05d182682b3dabn,
  r: -0x5f37f6205f96fad88c372eeb6819dbbf7300c11334d5bd558ca97d06aa3207253f4e6n
}, {
  a: 0x34192065520c354ac7b67a7af608b4cdc0ecdc94769d3an,
  b: 0x7c0e3a2b5bc51f13fce3af00n,
  r: 0x193f10e75d84d843bd566cb0f1f2b283f0e981da04bc1cb40c34240920e2bd97e8a600n
}, {
  a: 0xa2a21da293a73c3181d12655b6239882b5an,
  b: 0xb77690071c636551d7e501278a7e398388cn,
  r: 0x748d3568959fbdea703662c6543a93fafb477d687c929bd53221991f3bd54dcb636538n
}, {
  a: 0x90a3a501590bc6244df5921ec07ebe0741d1ea5n,
  b: 0xfdbd71b089d9f1068675ea48a49a5b1n,
  r: 0x8f5cc31f21391ff0e957b17c8fa6458cc76140983970d8c5fd88e5fe65c78dbbef8915n
}, {
  a: 0x74d43991c69a02e2e12486b2fdb6b16b2692838n,
  b: 0x3032c8efcb137921a7e7832f5119603n,
  r: 0x15fef7f1cf7e798e60100d6659fb4088abfa3722be78ee213dd63294862536f88448a8n
}, {
  a: 0xb52c0cbb046eeab79708d75f8d4a2d0355d8c6102b70901afb345194eae8d9a28c57n,
  b: -0x45n,
  r: -0x30d4df6e6831e5437bb5620cc114fe21e6236d625bb556d745b519fd2350c2a8cfd373n
}, {
  a: -0x8ae4c43671f32cc3491de51fc86e0f515661ef82fe564bf6ca37bc89acfcn,
  b: 0xfb8a4ca6c8n,
  r: -0x887955498e2cf86637f4b512872d51767a0aa6fb2e146c90cc83994f18eaffc48a8ce0n
}, {
  a: 0x13df8928a6b244386190b055642a44d0b72cn,
  b: -0xe8f5f6a4fbf92535d0358e8abd9db6aa34n,
  r: -0x1215ac60b78987733a615ab8c80e556a1387945eefb47850d7af5eaf5a4a7cc9506cf0n
}, {
  a: 0x6f89b8f08c3b06759dcceae26ca90f63ecc14ecf0ebbaf08f6ccn,
  b: 0xb3e0a8bca1b90d5620n,
  r: 0x4e5f2e56957fe37d0e764e3c04a6cd6a56b011cbd16bec1c6c89d8e99b485cd8636180n
}, {
  a: -0x5a69ce4d9379e69176a70a521de33dda9e6d30f194994b8e33351d2b6c6f83096n,
  b: -0x4d29cn,
  r: 0x1b4091ceba82777b1ae957d8a1e1b96a180e2e07651817b9d7d7d3af9172799970a768n
}, {
  a: -0x676880081aea9e289c374283a535458530e9faa3e2bd1b6555c0n,
  b: -0xb84293b75d32da50efn,
  r: 0x4a6e00a1e84d40858ede550c9530a700f1fa0f59974515b9f045305b9b4ce6c3e70e40n
}, {
  a: 0x6d6f3b510a75b32833936b6d8f03883eeba80b0n,
  b: 0x2aa69df0ec79f7e33762dc7f83b924dn,
  r: 0x123b795ff7031553f43ba3dd311a93661bc8bc84c5400308496a94d2e1e84b540d14f0n
}, {
  a: -0xd58133791afaba9319f30558f1n,
  b: 0x9b6cc2ad71682bcb141fbce383981b9e11e28d4cbe1en,
  r: -0x819fef089a53a8c2739600d05dfb900dd219119afa08094c88af7b06f71cbd972f4a3en
}, {
  a: -0x83d379a6471932d547369c2c485en,
  b: -0xa75581cd9ef589be01db90ba0f697a274061f426e5n,
  r: 0x562afc6a4f1734e7b417348b4dd8fd84f8c4a3b1b03565cbdeda168778da28ddf2b016n
}, {
  a: 0xb157bn,
  b: 0xa06cc36513606c7433901407791773530da5be045ecb0f641d52cc6cd8225b9a1n,
  r: 0x6f22265a1014be137db40743070880f4bcf255168ba99dd20de10aa3a6f8099a45655bn
}, {
  a: -0x19f57723e1af2a5fn,
  b: 0xfa14a1119999a57fb32846d4b2613d5d358f4ac58c3acf41c34881n,
  r: -0x195bcddb820074120ac2146c5a56009edeff8dadcd0b9dc3681f956e064b8e628c11dfn
}, {
  a: 0xf4ab9n,
  b: 0x1ca90d27f89fc41baa24a8fb6098519274f8c95ab5c35ac9715931cde1fba93e6n,
  r: 0x1b645594fa11d57c3af52741170819d3c233a3e4e618a24387a909ceabed9f870f5d36n
}, {
  a: 0xf8b1eb238dff5cdfda27n,
  b: 0xabba0b283a88799a9784cab582ac7eab82593ee15f08f9eb03n,
  r: 0xa6d3942c5172e72869ad2d40df527920b5987b3c7527a7496d5735174ca444fbd05b75n
}, {
  a: 0x73458fc2d7b2ac68abf187526a4d175bn,
  b: -0x1ddfe3ca404f09488deac674495c5423a4f13fn,
  r: -0xd73b1730d7b51c3dd17898742a69f3660acaccf923482567ca60d20cce4cb23416a65n
}, {
  a: -0x28c033cb811752d6n,
  b: -0xeed512bd8cbddb25112105683db1ac1c177e07f02164811cdfc4dfn,
  r: 0x26049b0dfa47f8d8acc0dc6f55f25442b2b45e4f4fd95ef39255eb7e2b4351df27006an
}, {
  a: -0x8f7df4fcba5f30afn,
  b: 0xb9c9437c8a49fc41ecbdf5679b538e4e8d49170f7b46c96306e22fn,
  r: -0x6822d5c3c2c14c7ce99f6a2cb6978292b3554ce860f3bbdc8f6d2d05885864118e6e21n
}, {
  a: 0xe5f047883162f94204b26591375401fe55e22b5430436e55ef96232b8a2476322bn,
  b: -0xb6b7n,
  r: -0xa41d319df577aaf51d882fbbd82446783dde2f7ad37e70a4f7c301541855ac18286ebdn
}, {
  a: -0x97c70322a34a107fd1ee21n,
  b: 0xa97b40b26a2c71975eb76763b0eb8bbcc49b8ec94930a401n,
  r: -0x647b740be78bf13bd51d2d564285526ff33c4c37e1c189d3730f739585f6200b8f1221n
}, {
  a: -0x3fa884088efcdd8a03d9a3b9daeef7facaa27n,
  b: 0x7b10bf18bded3f24cbd0f0b3d37f568bfn,
  r: -0x1e9a217d3ec599eb65d4de995c9978ad265ed943eae6b70ca0dca7041751a69f45cb19n
}, {
  a: 0x49799216982ba269342fbbcb49fa5fn,
  b: -0x8482e206265cc7da0902884722d0f0d2163270c8n,
  r: -0x26083feeecc3d180be1ced1ff816cfd689105175f01771a2254b8ba465f58c3fe32a38n
}, {
  a: -0x3ce7e2b98b8f3a13ed57a633d5d042c5cd8946cc31acca8n,
  b: 0x240f34b032c427d1b7d6627n,
  r: -0x8943a01660cd6c34ab72a7eb2a0298033c67dc679a359286646c9b38a48020ca81d98n
}, {
  a: -0xbn,
  b: -0xd780d9ceeabba70ad7230542587935894fc0f6410ed3e40350f9c07d3249cd447c9b7n,
  r: 0x942895be416102d773e8139d9cd354ce66d4a94cba31acc247abb4561292bd1f15aaddn
}, {
  a: -0x704ec2790bf50c4007849251a8cad071b5c465c44f64c05b4a091740n,
  b: -0x5a51177b7c05b1n,
  r: 0x279f43975639e476085b3ed03561fa835292eb8391ea5fc305415398e158e360bd5340n
}, {
  a: -0x2bdb9ee8e98ca563e3cbde0ade4ed87edfca7e881f548517n,
  b: 0x522464e2c5d2adcbaa55d5n,
  r: -0xe129511976942d2454a2210639feaf85272993b6b776328578ee1a0b91bddbfc95f23n
}, {
  a: -0x84874c1bcc2d0df3aefn,
  b: 0x5221c7e3ffd32a9afa75d3a8620cce0fe64adee18cf2008ce3fn,
  r: -0x2a84d34ceb8def05c511dafcbeae370065814b0ad71cc026f34c4300fdb59dbfd3d2d1n
}, {
  a: -0x4b542f7f81d089f4092ed4afn,
  b: 0x695d535a30bb951e13faf2670c63f52e06be264b427dbdn,
  r: -0x1f00fd9762e6b688e954f5c7524774632861e2043a0cddba3b568946d48c02bf8a7833n
}, {
  a: -0xb9de0a31fn,
  b: 0x5adbef727e7c12c234a07572bca23544dc5bbc011b7a940ae282f156210efn,
  r: -0x41f7be61b352d77d018116d62c743198f6ee5724274e70d25522bbad336cc76bc839f1n
}, {
  a: -0xc1748406ad83n,
  b: 0x607f28d65fb7ba73132df0134806fadaedfff0d342420085cdbd066d8en,
  r: -0x48ebc92c34bdb0dcfc6e2b69a1c0539ee3af237a41b81b21b26f3ed87bf200dba705aan
}, {
  a: -0xb4d4e4d3df4ac9ed6bc489edccbbabn,
  b: 0xe6b471d2c5ce5a0124ffe78d404664586b28b715n,
  r: -0xa2f6bbae1af504594cfa1c24c018fd82aba7eee7c824abb6fbeea7a7b8c183a7aaa207n
}, {
  a: -0x8690889fa4e18457b9d805ff0a491b0d344bc5152c0cn,
  b: 0xbd1e3a3643d93cf376d5c5b3e1n,
  r: -0x63689867248ad2799731ee7badc90667362389bc0a30e542352f47bad6e9dee6a41a8cn
}, {
  a: 0x3275caadd7700126f22c325451be555805b085d1c251ce27cb552e658d90a8n,
  b: 0xf4deb468n,
  r: 0x30442ae2c674265464e7fc6578600820f115be6266ea55472a7f3f398638e45ce8e440n
}, {
  a: -0x8191a5d6c1b78db2cf50d7f2068n,
  b: -0x7aa3439256437adc3dbc98c3b5e9f91be3eaa109774n,
  r: 0x3e120af81f2faf97622585eed3e345757d0599b7856fff49b985f926db36a730380720n
}, {
  a: 0xd996dd4918c53a7f01be7df9n,
  b: 0xa604d83c9f28899d870f6095d0a5e029dac97ea5192345n,
  r: 0x8d1bf1a3ac8cf906173e3ec2c07e46fcba39167025c0cec7a46532ca6395d24de1ff1dn
}, {
  a: -0xf96223aaf309499a5ee04a181a1ebb5n,
  b: 0xfc6dfe4bc4e0c1a85a0451ab1a94a47fd69c19bn,
  r: -0xf5e7c19ea5f4c575cb82ac51155828fa606c88ecda22af332651d5ed7d73131dfa2b97n
}, {
  a: 0x94cffe43473c7d7c4b80287c79cf08aee0n,
  b: 0x780a95387081b4938584a8c7c664175497d2n,
  r: 0x45c7a60d55e84f618368a8acc4c1afee59a7a0e9f50b6b752332b752f93b1975c593c0n
}, {
  a: -0x3908ee2f68aae92058bd8090b2ccef558d9ded8589fb1fn,
  b: -0xdcced803ccacf089524afb68n,
  r: 0x3131c200c9c58a2299aa483759a68d61cc4f5645f4d002a071f91e95e74a560e3b6998n
}, {
  a: -0x77913f362bed0caa60578ddf168b0db7f20829aeceba64b54428bd7615071d302fb73n,
  b: 0xan,
  r: -0x4abac781db7427ea7c36b8ab6e16e892f7451a0d41347ef14a997669cd24723e1dd27en
}, {
  a: -0xb2b718e166en,
  b: 0x6919f24eb9b90352b463b8c6266f673ddb26e3496dfba88f043d9583038n,
  r: -0x495f363dec2b0d6ad85a2f929d947c0ea9e2415bc5e48088533de96ff20f706f198810n
}, {
  a: 0x57c130d6dbae9abe5759fa7a6c14d8cbd1n,
  b: 0x3a462abd388352cb82c0ab87a4c35830f49dn,
  r: 0x13f9d28a97893664e7cb0da4b5b2c4eff1b974eb287b6d55994147e0a6ab107a68332dn
}, {
  a: 0x409b4b60f178d7eb4f4e15a46c8df2dbe534en,
  b: -0x89b10fc68af297635743339e1b2d42c74n,
  r: -0x22bfcab133d88adf3e99e20cffe0a6f2129304f2fcb7b51be577111e972e14a9272758n
}, {
  a: 0x9879884fd119adc55b757f72d70120868ba93ec90en,
  b: -0xca1a779b67a8287698b352bb1c7an,
  r: -0x785fa923e0c92ff31c4fc6ec775d0d23df3c870027e0fb32bbe220972d071edf2358acn
}, {
  a: -0xc4a4e107dn,
  b: 0xc60ec1720b7ce23a6bf7e961fbf04b58c48da7b24272f128d83143eb9b408n,
  r: -0x9822dba841337c9964abf9cdd7494d5bedd8b089e908eccd70c719a24b7fcd665d67e8n
}, {
  a: 0x5574287d5abf9a704d27c3b45decabfb0efe75d78f6fa1c5fe72b0d9741b1fn,
  b: 0x97620a39n,
  r: 0x32883dc300f5aae60d31c3ad09f22cdf145dee67896269c1030dcf3e192c509ec73fe7n
}, {
  a: 0xb6ffe9facedc6215221a35a0be6dede25a19218f2adf95e564c050d0c7fe4bn,
  b: 0x6c7d8a8an,
  r: 0x4d8db4b3a8d14fb31e60f93282dceb568f06d903e6a186b29ad7c9f7858d0b2982826en
}, {
  a: 0x831e5dc1054d63e7b69cbc184f39cff7fd6e6ad37a9ec070f76440fa0b9dn,
  b: -0x90ed723aabn,
  r: -0x4a3ab25af0e3eb8f6cccbc74c151ffeef5c4e64517a0f317704f5eaaf4eb19929153dfn
}, {
  a: 0x1450561027eeff0018bc4en,
  b: -0x640b847dc7ca03aa641f31ccdfd3ffcd44afa133954dc1fcn,
  r: -0x7f04b9569bfe7f0a7f0aba97ef8fd1efb80f57b3da0e2f51f2c4354eb80aac7c62ac8n
}, {
  a: 0x8e873146891e9bbed08c762472a1ff215fdb09ca7a3afd8033c839e7a5886636ae174n,
  b: -0x1n,
  r: -0x8e873146891e9bbed08c762472a1ff215fdb09ca7a3afd8033c839e7a5886636ae174n
}, {
  a: 0x46a11e2553b413414ddc80db4716a76c4fe30eb3b8de6cd821b196779a5bccd7n,
  b: 0x3283e3n,
  r: 0xdefdaf6952e1a2148b2d10b4a5a3d53ea7c44e5f61c680123b19323d3c5f8db36a7a5n
}, {
  a: 0xce26n,
  b: 0x12d7295c706c8caf08ccc33af463bd2f3a7614feb796abb4604e0bf86348bfde29n,
  r: 0xf2bef3886300951bb10137e6b68890a160db26c158a7e88a2451937a6c347313ff816n
}, {
  a: -0xd21n,
  b: 0xd3ff754eab2b6f653ffc04b989fe1207677a2035c2bb6b89e6b7b3d596cd3b44850n,
  r: -0xadf4ce31dd54541804d0bba07ecb0aab3358a60e1d19e9edd7e11d00730dc771e96250n
}, {
  a: -0xc491b0bd2350n,
  b: 0xf8c92753ec35b8e7825fc523bc6b8d75438a62948d2d58c6fa67454d19n,
  r: -0xbf0797cda13ee696114000cc8ce9040671b6d8d0d00c9e1c25a78dea181cb2daa782d0n
}, {
  a: 0x3305a57be71b5d6776b299ce082588808bc629e00d9b734d3231eab308257c63n,
  b: 0x99bb3bn,
  r: 0x1ea3b0c93bc4ba135f0b4abda5d0dde02fe528fe2a727b992ff64a4cf1bc9d99aafbd1n
}, {
  a: 0x721e1a823275614e0n,
  b: -0x345e52da0abf9efb665a467f5e352d0bebc904435ac509e1c3a0en,
  r: -0x1758295f04f93e43a660a92ac4648ff250cd6a0f6998a696e9024d03db9d222fefe440n
}, {
  a: 0xb2896a0870200186b6ccf73a7864e89449b8n,
  b: -0xe851c304dd73b5f4794da91809f878f529n,
  r: -0xa2058d9442a3e43645135da409682fd595abf62337e631777604dbd4ca5f23f88ce678n
}, {
  a: -0xa57e4121e3f09e18610dan,
  b: -0x56ccbff52f90f941b2c9135be650231c5dc569cce61499d32n,
  r: 0x381cc694fcc0fd75f92912f75983401c42aff621f26970dbcd14d2fc38e246acaefc94n
}, {
  a: 0x139c5b104d82n,
  b: 0x957b2a6351f4f0ddb3f2e159ea812066940a14523a304e03ea8b5cdf3an,
  r: 0xb73705f80a107c5d278d6629430f73065475f00a0e5c047b0cd9d6e27978545edcd74n
}, {
  a: 0x825b714a2513ddd6caeee084e36dbfb7ea623a9af308bc3f419008ab0f93c233bedd3n,
  b: 0xcn,
  r: 0x61c494f79bcee66118332863aa924fc9efc9abf436468d2f712c06804baed1a6cf25e4n
}, {
  a: 0x1926bbdb9f29faf85beabe0n,
  b: 0xcbbc37ce25ee17cc2e724d8d108a9768b934e263a6de3a8n,
  r: 0x140434e4afc0844346779de361c28ffdc8edeb65ee007803f6b0bd31265727c5e86b00n
}, {
  a: 0x744783d9f0a24d7462279e48a4d16f06d6c941cc34b9937eaebb6a2n,
  b: -0x9f9f73832b9595dn,
  r: -0x4880d7c6f5709759e335c82c100a8795c3fa485998f76acee1f47c065e296ee931aadan
}, {
  a: 0x80cc3ad234757e381ad7cc4f0d718e94ba6a17fc4d6594e6c0a88cn,
  b: -0xe39e6bbc36ddf82cn,
  r: -0x7284cc68c06c5f4e6315e0c6bd25cf39ef2c419a8ba4ce298db0f09843d7d155409810n
}, {
  a: -0xed6ce35f08dbccc368d9da695ebd3b207b3831517d43bfa98fn,
  b: 0x280ff9657cf0c76e41edn,
  r: -0x2527d43534f10e28e8c6d4796f327e065aea89c4d17fca6a5c570c4511926466ef4863n
}, {
  a: 0x193aae2e1e31639de9b85b38d4b8e969ceaf08065n,
  b: 0x7de06fa4b1a747ae7e48d2fc48a6bn,
  r: 0xc67c56599b82c4402b9e4324db1f55e5fd958d29524f0e98fff3f27033d91b0101c37n
}, {
  a: 0xd78449342faa9438604e52890e06107acc9be11c2fn,
  b: 0x961803e217d18fe2b4b3ed2b5819n,
  r: 0x7e5bba905483f62d35baef824166bcc5b4d5b59cf27ecd7884cc6bb735aa54d990e897n
}, {
  a: -0xd5741ec4063e1e5ec780280218643b8ac2ceae1961a50ef6n,
  b: 0x37050997626297076f391en,
  r: -0x2de025e005c729bd54e948ac95812537302f57018fca424d4f7805a3eae6cb685686d4n
}, {
  a: 0x2e026865147bdb6810e2c6c2n,
  b: 0xfe890b00808cc235b1a42cf2829f24d4f3c655523e9362n,
  r: 0x2dbf04d85a01b24618ee06fa7b3ce2fbfc78495d2bc0b13e593f7bc22f8488f5ed7c44n
}, {
  a: -0xb0aebc2b99914c7df4de3f97931a9057587c86c2f50543f026d2ea70df9c58n,
  b: 0x6d201613n,
  r: -0x4b508b3236f9c62a135cbd3fc28a71ab6ef84d081f84a01c61c756585f1e9e9b082a88n
}, {
  a: -0xafc64fc840d089c9242een,
  b: 0x298b46bcad5cae0180115290a541227a602eddab0df9a8274n,
  r: -0x1c8664062a9896bd77880793b72791312b15ad65886a4831b6a049d5e88f52cd6f2fd8n
}, {
  a: 0xa148e07n,
  b: -0x2593ceb7cd5802d9b40f50367c74bad07bb735e997c8b799919c24ba9ba0362n,
  r: -0x17aca78581615ea29078028d007b2f0e3ef92be5817be6ed403ad99c04cee0e99e73aen
}, {
  a: 0x2565ad9defd2430354cn,
  b: 0xb56d93673ec8a8c32a48cec9a5dd312078366aaa5d1960c3cebn,
  r: 0x1a80e5940e95414c3d73343a300d24205285ba93e81968786c1990878277648c4ebcc4n
}, {
  a: -0x8d958a218754d9n,
  b: 0x61c259a17a446e55c392a088ae456fbed8ecfec9c0cc57705565416fn,
  r: -0x3611263bad60583a695f208567c73e121792bb3e4d404b08a7bc5612f3f0e86cd5e317n
}, {
  a: 0xd4cffe59c092bf482328dee4n,
  b: -0x7ab8087eff26963b0b8d587d25b53bb7b3f8e03ead35b2n,
  r: -0x66041bc5a8b598f157868e1689a2400fa0b779a42ebdd42cd0bd6835027f89c0a42e88n
}, {
  a: 0x4b51f10643573356844d53167e41a9c273e29f5a515f40daa83f555a476f8dn,
  b: 0xba119040n,
  r: 0x36beb4007a679b89278c778d6e4b84580e042ba0a66940cc190e6585f2bde99af83340n
}, {
  a: 0x675c5ae0fbe4b4d0cf9914af05a3f784b995e752c51e1an,
  b: 0xb7b515a2dd38090472ca47aan,
  r: 0x4a2c21ff6a59e74a6b406cf59b66ba3c82141d479bc857e572d57428072ceaf6c33344n
}, {
  a: -0x55c99b1dd39f1a0d28c05319e4f02426d47ecdfb7a09n,
  b: 0x87180c8c7716781568d9c504ffn,
  r: -0x2d455fe7cad3368e7145d55175ca2e14e02253e3493169213712bbe992a325a553b2f7n
}, {
  a: 0x8725f780e268d143b35cb0872de443eba46d2n,
  b: 0x88ddad84fdb05d4608b831ff33b88b490n,
  r: 0x484132de004e7c107e74e7b301dc306e3fd21722141a35eb78ed4bb075eb1c48237e20n
}, {
  a: 0x549e98ef80035034872c78dca45483n,
  b: -0xe17ca061d63458a6c8e9fcd45708b41f172043fen,
  r: -0x4a8896400a006f37831d4c9470b98d77bdf2bd1b9b08865d880955561a71a9428a22fan
}, {
  a: 0x577549d79aedf3bc2912d312fbff8aa6afcf304638c0369f26ff42d618bfn,
  b: 0xdb57e54be6n,
  r: 0x4aef5d5d62cd1678c00491cfe541fb1330584e61143fd2c25e9bae829e893cd175309an
}, {
  a: 0x14eca5b643fd236ce460b2b63c43fd92f6900d11357860504a879dn,
  b: -0x94bbe2744118c306n,
  r: -0xc282b2cd64a1d33acac46b221a7ecfe8e57f0f9ad6b57b15ed45be089affa3ac3c4aen
}, {
  a: 0x732aadc01c6735406ab6723eea1e5c8a31f7ad95e57329f1c190138n,
  b: -0xec8ee3b0495e62cn,
  r: -0x6a6ba047a129553e4271d4783f55fdbc601499120b0efa46c5960e3e28bd11e0fc85a0n
}, {
  a: -0xff2d7af0aa8a10b77a9208d31de85c90n,
  b: 0x3c0743af6e01aec88ca616621444a7aa56c398n,
  r: -0x3bd5e68689784511e2021141b70761798d32c92cc56e1d800849d9c2a1089878d8a580n
}, {
  a: 0xcb8a959ca956c5eb279fe4d57b8876781a9e75d44n,
  b: 0x5c734cfc203b0ba006d4b3fba438bn,
  r: 0x49817a3b1cb14e7a1fcc609c1c46716d0a2c46e3990dccae56e59e701fcbd84d706fecn
}, {
  a: 0xa0455c3cdc8fd4a419f497759a4c8e8ee2004e0fa2c6c43435db9f5a1e7049856n,
  b: -0xa5fb0n,
  r: -0x67e9d874a9d4f51341a0186f4cc1a0f1ddc1c89c9d3eb55805e75c0a52fa377b0ca520n
}, {
  a: -0xe6871731f3101e50db582242699f8a4b31fd45da474717d35dd4f875adn,
  b: 0x23728f9c63fbn,
  r: -0x1feba1a672c8bef4bbb8ea4138f5f7159ec06bfc8f5cea158e29ddf0f925893d89479fn
}, {
  a: -0xfea18c9b5dfbbac292609883d59d59f6a6fn,
  b: -0xa68e0e2ff0f3882b8a7ea1e434a5a502d75n,
  r: 0xa5aa0ce542225b0109722998fcf1707ce4202d846ddded3f3e9375772b72edf04127bbn
}, {
  a: -0xc76558631f3427866d77632n,
  b: -0x722be9fe8304fc8fe939b36bc6ad2de83c417a10e622e78n,
  r: 0x58ed55a376981fa3e2d66c170d959fa059321f0eb03eb78b36c1674517c54ee7606370n
}, {
  a: 0x5585ee8ddb692e348da981b52207cf94ec7768614b0a65d5ddb6334b8n,
  b: -0x10dc84b2d3450n,
  r: -0x5a20a56ac5495c4010d63cb757435c5a41868d0773008dbbe75cc8ba06686e20dd980n
}, {
  a: -0xae0bc61792544864ac8808fd8c89d8640n,
  b: -0xb247f4d64de6bc9ae6c510ad7c093f8ed34een,
  r: 0x79351b753fe4a845c0fac21736ce11542253b719615817990a825b49ac2eedcaf7cf80n
}, {
  a: 0x34f05be2cddbede24d86238ca19f5f2058d09d6ffea281f13d4204n,
  b: 0x99085cb221d23c10n,
  r: 0x1fa56198a342bb291cf57125fe2a59a1880087b03c8e1261b87954f122bd341a951040n
}, {
  a: -0x42604d770cf6f420505b7096n,
  b: 0x9279e47a53c06939ec3eac378fd4a8a0ac5685a9e94e35n,
  r: -0x25fa86efff4406dc272d25f9dcf7229d998fdf1cbad592abbb118c5013c5a6fdc2030en
}, {
  a: -0xdeaabc0541aa351ff780a2ac9271cb49ee79ada67f01e7730d7c77826dbn,
  b: -0x4e19e6b4b10n,
  r: 0x43ee8ca085723e7fa7571eb32a32566fe6c96695cd68cbf1c970a99b445e9b126d96b0n
}, {
  a: -0x86a2f7a2a6b13d97c4a839a1ee7e413fd422704702740423d748607fd05e1589a5n,
  b: 0x7584n,
  r: -0x3dcde735060cf48a1f224914b97eacebd0dd1f1258bc49b683df156c2c22705b036214n
}, {
  a: -0xd64f9788c9c3eebeadb25e1e702df9fec88ef83cf372af04b7d9d1715dcc2ce3n,
  b: 0x18bd31n,
  r: -0x14b5d7fceee882a7a3c174c17b00f4da40c13d36595626ac9b380ea2f29416e6802e73n
}, {
  a: 0x6e2n,
  b: 0x2a2fcadaf2c353094310893f5c435bd0eb9b227f6b55726a58d1b1055d6f9a43e1bn,
  r: 0x1225cf236fae46185bf97d0a619079df3f5a1c37100c21d7ff7534466ed1a23c7375d6n
}, {
  a: 0xa85ba046cd20f3770936c9fedfb1c6a3e5e631f144052791895b049b4efn,
  b: 0x98a565c44e2n,
  r: 0x64632d259731623841d38451e56bc94fa7a2baf40b5f335cc7cc5bb78b8414850536fen
}, {
  a: -0xd3ab54f8ddae4ffd12n,
  b: -0x757d1299bf89fc5d0fa4ebca717ee5b1560aea4665c33c874e41n,
  r: 0x6124b7df66931cbe36ff52cd2e6115a11b19f5a0376d7f8379b49c92da459a4de8bd92n
}, {
  a: -0xa19bc37bn,
  b: 0x7f321191b72a33b69c3df880299af0cb0056fdf4159115248932f73f48a5afn,
  r: -0x504be17d87dbe09b4e7e848e55d3a78478fc3d2db1963dd7a7381c6a3dd32f1e10e815n
}, {
  a: 0x9b7can,
  b: -0xec824e0b47b1528ed01aa60fb9ce643a50bfbf57ffcf57d1ad531b101ae844d3cn,
  r: -0x8fa6083012a623af48c631849ce7cac8d9c7a832ce19727c146451f7cd01bafeb6d558n
}, {
  a: 0xfec5789bfeaen,
  b: -0xb2963e730368ca21d8db98ab960b2aa5c0159da84f8e8ef4c3e1f00d80n,
  r: -0xb1bad3b76bcbc581dff64c62ef9aafdd5e61d75c31b005dc025db7cba66d7beb0e2d00n
}, {
  a: -0x26b33c9de8bce689b206aa99a841510caf60en,
  b: 0x86dcb4ce1dbc791334d9d4567cd68f18an,
  r: -0x14632f17eedf7d8451e498e9671ed3a6ac1e835ca6051dc8b5a2f9fd3527494abbd18cn
}, {
  a: 0xfc7daa26abea118913f28e20a0b4e49e33ce89b5f66f0d275ef1fe3877f06caa3f3fbn,
  b: 0xen,
  r: 0xdcedf4e1d66ccf57f1743c5c8c9e480a6d54b87f37a12b827313be7168f25f14f757ban
}, {
  a: 0xfdc2e81af6c09f157b63cn,
  b: 0x2c39bc67f3e6b7a85d022280ae7805d2357e0b6527d62c4c7n,
  r: 0x2bd6bb0c7e0df1c531c972a8a4c2889d16f0674b42249b78f16efed6e1d748d1ac98a4n
}, {
  a: -0x154623d5e6a15599e526e9ab4687cdad8dd7537cn,
  b: -0x44b6294365a033afadaaf358f419b9n,
  r: 0x5b5c4d020df70a04b68cf80285a1379dff105bb7100adfb2a2904bd0761e7b9f2709cn
}, {
  a: 0x5af2316f10ca11a50caa32219ecbd4c4e50eea6d82en,
  b: 0x2b1158447a0602fb486cbc03f68n,
  r: 0xf4cd7be84deebf311029ff650ccea094abe62e9347055f9356cb4c3fe863e9f7b24b0n
}, {
  a: 0x93f4f8ec7241dd96258dfa420b097e1cb73d8d27ce7d6e9c393n,
  b: -0x735aa111fa55008eba4n,
  r: -0x42ab6d092ef3590168006f71092ebf98d8a2cc75f8e3e8816fd424e80575f950e13b2cn
}, {
  a: 0xd440450fce930925033984d07568994cb2200b85c4ffan,
  b: 0x20b274fbee70c421bde20a40dn,
  r: 0x1b1bfe4ffed0226b3e011b992106d00cae14c251c42eff49e680d524232c674b2c37b2n
}, {
  a: 0xe77df82aa8a82d4429fdc757bede529c24767fc8ecb8e48ea1721f92d854e15c74231n,
  b: 0x3n,
  r: 0x2b679e87ff9f887cc7df956073c9af7d46d637f5ac62aadabe4565eb888fea4155c693n
}, {
  a: 0xd4e89aa1ddeb7c8db1d8a010dc42ae46298fb860fd1a87aca8fd710n,
  b: 0x9fd6b37213b7fc4n,
  r: 0x84ef07b9503f17015a68dd73c8406fb95822af98dba8fd7bc78449861e06d012819840n
}, {
  a: -0xf590483dcfe2a71fe25c2a87f122f89dab31d0dda4afc9c2ce403fb96e8553c96902n,
  b: 0x1dn,
  r: -0x1bd1582f008cacee9ca470d16650f629dc64a4a91ba7e9db115d473801851a7dd0e53an
}, {
  a: 0x71d46f24fb97fa9bc34be824488c0d5f8e676f350c8fe84b7d286fn,
  b: 0xa4c429ecb5658a7en,
  r: 0x4943507d0fc9b844798e7badeed71ce20bbf6202035a3b241182ff999e60520e30bca2n
}, {
  a: -0x68n,
  b: 0x996c9926d78699341c745244a65f33eb19378beb41f6f41184eeb61928c7d79396dbn,
  r: -0x3e541e37c78eae3d2b8f416be396ad17823e90d792cc53271e00f9fa38912f93f548f8n
}, {
  a: -0xa69f8cf8a9eace81f272033f75f4ca45838bb2baf130bn,
  b: -0xd3e48ebd8466f62a2c7003093n,
  r: 0x89ea44325bae27a5deb79ec27df708cbb13e662d7029edf09b337d561a066e7619ff51n
}, {
  a: 0x814eea45b4d269f6613ea7ed61d8359c34b307516c68e509e4fc1496fb5n,
  b: 0xff473515a6fn,
  r: 0x80f1930eaebec9f407ff0af7143e37b99ca49c20126280f1a57d177f36e7774762117bn
}, {
  a: 0xd19f5ad2efn,
  b: -0x1885631b1fd7794e4bbbfeeb88d7fbff7da426f5a0bc162c6bdb32b334d8n,
  r: -0x14142974cbff0dd57596b7fbef8cc1312dc83ac7076ef34b54ca5897cdc666129785a8n
}, {
  a: 0x7dec11a92d8dc45824283ae87fn,
  b: 0xf17ef07dbcef6fcfff37ea03c46c8d2deeaa84f35d26n,
  r: 0x76c9ad1c1ee93f4a293118b385b77f911e591b01fa671a819b737bfad23e1d8bc1a5dan
}, {
  a: 0x5080e8779f9fd89n,
  b: -0xa51371fc67d5a26893e15303972c348fe2246df7e7768b7be3b96acn,
  r: -0x33e9333ea0eb8e84955ce2610e02a14daab45b13eee99b87b2a1550910b0368b179e0cn
}, {
  a: 0x758153124a6f04925df350bn,
  b: 0x58d9acadcd93458e91ffa6681eee8556098cf62e8ee70d8n,
  r: 0x28c85e705ea8d7c1b9b4f3e3a9e6d2d0b3903a47cd833dccbca5283e2c6f14e3c39148n
}, {
  a: 0xf462041f830fb05e1968557163c52c77f65246a31e43c4095n,
  b: 0x268616c043badf6c1c6a4n,
  r: 0x24c68da2cc78c6ddc236d133f67051f974d52d3b6a6be166f1d44cf45391a9aee19d74n
}, {
  a: 0x7a361cabf18d408304bcd3e845e15b65db4e61c08dec8138f0dba89n,
  b: 0xce96f286e1db0c0n,
  r: 0x629f9a8eb45ee03d613d311403c1ef3c67916f9b62a1efc2ee2ca7630a2821ba0f16c0n
}, {
  a: -0xfd35314f89f04cdefn,
  b: -0x55b50ff43589bbb158f9d3b8e7c9b02816572416dbf061e863c4en,
  r: 0x54c5bfc2ef9437a30cc72aeafb34b0f640a4b95b76edef3ab5fd87a6859a4560d4c2d2n
}, {
  a: -0x9ea467c6571706n,
  b: -0xce8b2277da2203855f0f61658b83f68ad17f9e094fd81f909f880591n,
  r: 0x7ffe84220e27797b0e8abdbb379ce7153d4f45dcc9faf6588ba497a2394897fff72866n
}, {
  a: 0x6415c2b18a38f8an,
  b: -0x7a6009540435f573d4d23f43343597082db7aa8bbcf47f2030a347dn,
  r: -0x2fd7ea973b148b7908a84d07f3c865150c9211b45cbe2509107527f59e99927a691e62n
}, {
  a: 0x4216fb5adebe366f6517cb56a5cb666d5786f1a12c051111c48b31db7ca8b4ben,
  b: -0x34a732n,
  r: -0xd97d4f4ea9db0a549d58991e4ea64dfc11cdd34b846395ebbd8f5514b3d751d733f1cn
}, {
  a: 0x3e45n,
  b: 0x9b91dce312e6cbb62d6d16c55f45d3e2c2aecff91b5cce1adea6cedd2dd383d968n,
  r: 0x25d741cf87c7fd8b071aa9eaf04597230744cf7c62c4d9ee0f2a690f52b693f130c908n
}, {
  a: 0xd13e94a90841da052418b5eedd88e12n,
  b: -0xb43d42b802bb11c76f1f20029de96a4df3f6494n,
  r: -0x935212f8cf9f17038e06e8c2f63ec372a548fb96c2d81a055ef4137d77635ebd1f2a68n
}, {
  a: 0xa308e43fc163c65dn,
  b: -0xd77098135335aa3a938ae3a1c3146d3e1bc9a50fcb41a166ec9735n,
  r: -0x89342c6efd7c420e9e51ef90d8391a772a191b56616c5134d80551852942c5cf64ec41n
}, {
  a: 0xc4324cd0b2c1a21b09n,
  b: -0x374345867823ce506535eb578bfb7fdc2c2201f592b809e101f2n,
  r: -0x2a5a5cf38e21dced697acf2ebb7dc9c4dc996dbbd48aa13d306ede17e46ea1c1419782n
}, {
  a: 0x1960dcccn,
  b: -0x25b89f850ddc5ea762f8a6c6c3403794e39b865998288413d19dab1628a9adn,
  r: -0x3bd4d5888752dd24462abf8811233b128ffc8b028d9123f88b148c3daf3322017e1dcn
}, {
  a: -0xf952c8d471f3e3a9498ed6n,
  b: 0xcaaf041f086fbbe74053722639e60210fc168935e71e0fc3n,
  r: -0xc565c6126f85630a39949a2bba30227b14902c1c5a20536e4b6de0da956c25197a5702n
}, {
  a: -0xcffc52eb8e97n,
  b: 0xd8ea646f23267edc409a7864a84a1a0d5acf7182dcc1233a99a18a36c3n,
  r: -0xb03b543366fa7bb77512965baf46203582a9b07e225a38c41d204d3d63ec97ade77705n
}, {
  a: 0x9bfa1e05deb7a617d4b390n,
  b: -0x4286602f6e69476dd5704d50152f73120124cea111d24706n,
  r: -0x28885b43ebf1418df74942b9ee5efa851441f2c8bbc988d46570988b7ed87868e92560n
}, {
  a: -0xf983aa51dbda399bn,
  b: -0xa10418a5a84cf8be4c7c7e663c62f774fb255ae035737d6b8903a9n,
  r: 0x9cefcc31f2698e4fda5246c3a5d9a82d5d05359c3f5f05d2f2a1068e2305294eafd853n
}, {
  a: 0x79ee66e28b10434f2n,
  b: 0x43b9a542f1f2047764812c7563364a2dc26d0f2d8fc7ff1798b3bn,
  r: 0x2041d0ec2f1efec0cd7f42bd7ce8369d123049d8b8a3c659e0285082309860ed1999c6n
}, {
  a: 0xc4c069a99e9f9aa49efc32f419d4be7fa8f40c6d3895b3d5fe2fda7c4e454f77an,
  b: 0x51e1bn,
  r: 0x3eee55cfd1e98742bb4eb51567bed60415a07a9543713060b024aaf1423a2edf5865den
}, {
  a: 0x7a65e720c7d5b451dd72806b97077681e5a1e59e5be5f52fb9c8bbn,
  b: 0x30d4f2fd69fee148n,
  r: 0x1758ebe70a7d9fb3f14330fe219d706f45cc0595b9c195f3d98f2e1e05e0609236cf98n
}, {
  a: 0x3e7954fe2dded7298dc4745d5512fab26fd38654e49db63d28ce5n,
  b: 0xfa8cf505d01bf91dfn,
  r: 0x3d24e3263d4c077f367fd9f9416aee056264eb7900cd51219ff23ad1caa57b3a11707bn
}, {
  a: 0x1f65097390e55415049e0555adaf40a41509647a61e7ee5a07d3133n,
  b: 0x6e553e36be857b9n,
  r: 0xd87de3cfa98fd66f0a7957bcd71ec32ee02ddaaec8418cf06b5b27decabb96d68e2dbn
}, {
  a: -0x4f296621ccbc349987ab03a9n,
  b: -0xfe09f6c8b449b409fdadd3ac5090c927fede05eb4197bbn,
  r: 0x4e8e2819f88f1a3d11e3cf1e70eb8830b9b6565dc8943065700e192f380a4109fd5b73n
}, {
  a: 0x107779499e3e1620a911731de7af8ab7a69e680n,
  b: -0x6265373851b6a60a9e0c9b8351ab6bfn,
  r: -0x6543f1e5312190fdcd4688202782d961853eff277dfe58701a48a7e63f87187e1f980n
}, {
  a: -0x5adeceaf9cdda45015fdedf0a12fb5728dacd59b17ec2a10fd87f540f4b99an,
  b: 0x210d5637n,
  r: -0xbbb748f8170efdcd3b80e29217c4aa8a348f08456d9a6c5cd6a2556f871dd71bf9c16n
}, {
  a: -0xced1094106fc8a21e5c3fdd01f8n,
  b: -0x5f575e3c9190ba9d1b9889a31a2eb3184d7cd749c11n,
  r: 0x4d06279af6ae7579ba71cea3f68c246c98a93f8ed5a72586acd2e85e4dad0b67404178n
}, {
  a: -0xcc3de3495b9n,
  b: -0x2a3e5b8d2b776a543357b53aa1b1dd9a632fc458c2ffe8ec28d5f85b293n,
  r: 0x21b3e751b558ba9a652c01d20f24fdd37080f7a4b05ddc793691b8312a22bf98699b3bn
}, {
  a: 0x7209a65ad2c4b2071125dda67bf987ca82e0f679bbe608e78058beb9a3dc1aec499cn,
  b: 0x81n,
  r: 0x3976dcd3c4351db58fa414b0e478bd6d0bf35c3357aeea7ca7acb81b8b91e99111179cn
}, {
  a: -0xe6166732n,
  b: 0xe7bda37721c22de1eeac48234437d7f79dc839d7c4fb334043dafc8d130588n,
  r: -0xd048a893a46037c2a63c28c5d0fe502ad1d6420533e5ba07af2b7192cf98b0dea0cc90n
}, {
  a: -0x2743427279464c90059cbd5380583c05a84968n,
  b: 0x9e06676e606008700e26885b5ab7f54bn,
  r: -0x183c7e7332f2ca5135edca2449b36e64861a88c0ec98acacfa94fb7731d812bfe60978n
}, {
  a: -0x771f4d3208d944d4841e58a80db3a8d570ed941fa68295b99be1cdn,
  b: 0xcc971502be24f3a7n,
  r: -0x5f333ec13f9e7d3140466eb92590740eb3e4614e97a6fa04bc9e47f90baef6f2d9e3bbn
}, {
  a: -0x427b92da61bb61369190541d9158588e72e190a0e86f14fd9ban,
  b: 0xf659599529ca38f52ben,
  r: -0x3ff9f3579aaabd75d07537f7b3a8994232752ca5dede5f087e4e74d9b4e606b9e72c0cn
}, {
  a: 0x6c7n,
  b: 0x3855041e0e8192cc5c00d523e920a56dcfd5588b69309cb5c07fb4fc4c572c3e389n,
  r: 0x17dc82ee7b45029e70389a48660fc412b3b8eeb18d5e87613cba18399e962ccd9b157fn
}, {
  a: 0xf7852603f1bb8eb665ab3e9d6c9802798abcc7f6b742en,
  b: 0x2a544037e9ef3ca9894d498ecn,
  r: 0x28ed4e04783fbdcbc8c31ad558e345c623c0714e71cd46ce1942b5c2e6b7a412226a68n
}, {
  a: 0xc6269a0276793e99589939dd01d57bb5c662a0981n,
  b: 0x7b073a1a105fb71f27808220bf1aen,
  r: 0x5f3a2406507a312ce7eb7204a4b4095b1d8f8f9063284def473bebae4412148e0fe6aen
}];

var error_count = 0;
for (var i = 0; i < data.length; i++) {
  var d = data[i];
  var r = d.a * d.b;
  if (d.r !== r) {
    print("Input A:  " + d.a.toString(16));
    print("Input B:  " + d.b.toString(16));
    print("Result:   " + r.toString(16));
    print("Expected: " + d.r);
    print("Op: *");
    error_count++;
  }
}
if (error_count !== 0)
  throw new Error("Finished with " + error_count + " errors.")

