#pragma once

/***
  This file is part of systemd.

  Copyright 2010 Lennart Poettering

  systemd is free software; you can redistribute it and/or modify it
  under the terms of the GNU Lesser General Public License as published by
  the Free Software Foundation; either version 2.1 of the License, or
  (at your option) any later version.

  systemd is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public License
  along with systemd; If not, see <http://www.gnu.org/licenses/>.
***/

#include <sys/resource.h>

#include "macro.h"

const char *rlimit_to_string(int i) _const_;
int rlimit_from_string(const char *s) _pure_;

int setrlimit_closest(int resource, const struct rlimit *rlim);

int rlimit_parse_one(int resource, const char *val, rlim_t *ret);
int rlimit_parse(int resource, const char *val, struct rlimit *ret);

int rlimit_format(const struct rlimit *rl, char **ret);

#define RLIMIT_MAKE_CONST(lim) ((struct rlimit) { lim, lim })
